/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: Types.proto

package org.apache.drill.common.types;

public final class TypeProtos {
  private TypeProtos() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  /**
   * Protobuf enum {@code common.MinorType}
   */
  public enum MinorType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>LATE = 0;</code>
     *
     * <pre>
     *  late binding type
     * </pre>
     */
    LATE(0, 0),
    /**
     * <code>MAP = 1;</code>
     *
     * <pre>
     *  an empty map column.  Useful for conceptual setup.  Children listed within here
     * </pre>
     */
    MAP(1, 1),
    /**
     * <code>TINYINT = 3;</code>
     *
     * <pre>
     *  single byte signed integer
     * </pre>
     */
    TINYINT(2, 3),
    /**
     * <code>SMALLINT = 4;</code>
     *
     * <pre>
     *  two byte signed integer
     * </pre>
     */
    SMALLINT(3, 4),
    /**
     * <code>INT = 5;</code>
     *
     * <pre>
     *  four byte signed integer
     * </pre>
     */
    INT(4, 5),
    /**
     * <code>BIGINT = 6;</code>
     *
     * <pre>
     *  eight byte signed integer
     * </pre>
     */
    BIGINT(5, 6),
    /**
     * <code>DECIMAL9 = 7;</code>
     *
     * <pre>
     *  a decimal supporting precision between 1 and 9
     * </pre>
     */
    DECIMAL9(6, 7),
    /**
     * <code>DECIMAL18 = 8;</code>
     *
     * <pre>
     *  a decimal supporting precision between 10 and 18
     * </pre>
     */
    DECIMAL18(7, 8),
    /**
     * <code>DECIMAL28SPARSE = 9;</code>
     *
     * <pre>
     *  a decimal supporting precision between 19 and 28
     * </pre>
     */
    DECIMAL28SPARSE(8, 9),
    /**
     * <code>DECIMAL38SPARSE = 10;</code>
     *
     * <pre>
     *  a decimal supporting precision between 29 and 38
     * </pre>
     */
    DECIMAL38SPARSE(9, 10),
    /**
     * <code>MONEY = 11;</code>
     *
     * <pre>
     *  signed decimal with two digit precision
     * </pre>
     */
    MONEY(10, 11),
    /**
     * <code>DATE = 12;</code>
     *
     * <pre>
     *  days since 4713bc
     * </pre>
     */
    DATE(11, 12),
    /**
     * <code>TIME = 13;</code>
     *
     * <pre>
     *  time in micros before or after 2000/1/1
     * </pre>
     */
    TIME(12, 13),
    /**
     * <code>TIMETZ = 14;</code>
     *
     * <pre>
     *  time in micros before or after 2000/1/1 with timezone
     * </pre>
     */
    TIMETZ(13, 14),
    /**
     * <code>TIMESTAMPTZ = 15;</code>
     *
     * <pre>
     *  unix epoch time in millis
     * </pre>
     */
    TIMESTAMPTZ(14, 15),
    /**
     * <code>TIMESTAMP = 16;</code>
     *
     * <pre>
     *  TBD
     * </pre>
     */
    TIMESTAMP(15, 16),
    /**
     * <code>INTERVAL = 17;</code>
     *
     * <pre>
     *  TBD
     * </pre>
     */
    INTERVAL(16, 17),
    /**
     * <code>FLOAT4 = 18;</code>
     *
     * <pre>
     *  4 byte ieee 754
     * </pre>
     */
    FLOAT4(17, 18),
    /**
     * <code>FLOAT8 = 19;</code>
     *
     * <pre>
     *  8 byte ieee 754
     * </pre>
     */
    FLOAT8(18, 19),
    /**
     * <code>BIT = 20;</code>
     *
     * <pre>
     *  single bit value (boolean)
     * </pre>
     */
    BIT(19, 20),
    /**
     * <code>FIXEDCHAR = 21;</code>
     *
     * <pre>
     *  utf8 fixed length string, padded with spaces
     * </pre>
     */
    FIXEDCHAR(20, 21),
    /**
     * <code>FIXED16CHAR = 22;</code>
     */
    FIXED16CHAR(21, 22),
    /**
     * <code>FIXEDBINARY = 23;</code>
     *
     * <pre>
     *  fixed length binary, padded with 0 bytes
     * </pre>
     */
    FIXEDBINARY(22, 23),
    /**
     * <code>VARCHAR = 24;</code>
     *
     * <pre>
     *  utf8 variable length string
     * </pre>
     */
    VARCHAR(23, 24),
    /**
     * <code>VAR16CHAR = 25;</code>
     *
     * <pre>
     * utf16 variable length string
     * </pre>
     */
    VAR16CHAR(24, 25),
    /**
     * <code>VARBINARY = 26;</code>
     *
     * <pre>
     *  variable length binary
     * </pre>
     */
    VARBINARY(25, 26),
    /**
     * <code>UINT1 = 29;</code>
     *
     * <pre>
     *  unsigned 1 byte integer
     * </pre>
     */
    UINT1(26, 29),
    /**
     * <code>UINT2 = 30;</code>
     *
     * <pre>
     *  unsigned 2 byte integer
     * </pre>
     */
    UINT2(27, 30),
    /**
     * <code>UINT4 = 31;</code>
     *
     * <pre>
     *  unsigned 4 byte integer
     * </pre>
     */
    UINT4(28, 31),
    /**
     * <code>UINT8 = 32;</code>
     *
     * <pre>
     *  unsigned 8 byte integer
     * </pre>
     */
    UINT8(29, 32),
    /**
     * <code>DECIMAL28DENSE = 33;</code>
     *
     * <pre>
     * dense decimal representation, supporting precision between 19 and 28
     * </pre>
     */
    DECIMAL28DENSE(30, 33),
    /**
     * <code>DECIMAL38DENSE = 34;</code>
     *
     * <pre>
     * dense decimal representation, supporting precision between 28 and 38
     * </pre>
     */
    DECIMAL38DENSE(31, 34),
    /**
     * <code>NULL = 37;</code>
     *
     * <pre>
     *    PROTO2 = 33;   //  protobuf encoded complex type. (up to 2^16 in length)
     *    PROTO4 = 34;   //  protobuf encoded complex type. (up to 2^32 in length)
     *    MSGPACK2 = 35;   //  msgpack encoded complex type. (up to 2^16 in length)
     *    MSGPACK4 = 36;   //  msgpack encoded complex type. (up to 2^32 in length)
     * </pre>
     */
    NULL(32, 37),
    /**
     * <code>INTERVALYEAR = 38;</code>
     *
     * <pre>
     * Interval type specifying YEAR to MONTH
     * </pre>
     */
    INTERVALYEAR(33, 38),
    /**
     * <code>INTERVALDAY = 39;</code>
     *
     * <pre>
     * Interval type specifying DAY to SECONDS
     * </pre>
     */
    INTERVALDAY(34, 39),
    /**
     * <code>LIST = 40;</code>
     */
    LIST(35, 40),
    /**
     * <code>GENERIC_OBJECT = 41;</code>
     */
    GENERIC_OBJECT(36, 41),
    /**
     * <code>UNION = 42;</code>
     */
    UNION(37, 42),
    /**
     * <code>VARDECIMAL = 43;</code>
     *
     * <pre>
     * variable width decimal (arbitrary precision)
     * </pre>
     */
    VARDECIMAL(38, 43),
    ;

    /**
     * <code>LATE = 0;</code>
     *
     * <pre>
     *  late binding type
     * </pre>
     */
    public static final int LATE_VALUE = 0;
    /**
     * <code>MAP = 1;</code>
     *
     * <pre>
     *  an empty map column.  Useful for conceptual setup.  Children listed within here
     * </pre>
     */
    public static final int MAP_VALUE = 1;
    /**
     * <code>TINYINT = 3;</code>
     *
     * <pre>
     *  single byte signed integer
     * </pre>
     */
    public static final int TINYINT_VALUE = 3;
    /**
     * <code>SMALLINT = 4;</code>
     *
     * <pre>
     *  two byte signed integer
     * </pre>
     */
    public static final int SMALLINT_VALUE = 4;
    /**
     * <code>INT = 5;</code>
     *
     * <pre>
     *  four byte signed integer
     * </pre>
     */
    public static final int INT_VALUE = 5;
    /**
     * <code>BIGINT = 6;</code>
     *
     * <pre>
     *  eight byte signed integer
     * </pre>
     */
    public static final int BIGINT_VALUE = 6;
    /**
     * <code>DECIMAL9 = 7;</code>
     *
     * <pre>
     *  a decimal supporting precision between 1 and 9
     * </pre>
     */
    public static final int DECIMAL9_VALUE = 7;
    /**
     * <code>DECIMAL18 = 8;</code>
     *
     * <pre>
     *  a decimal supporting precision between 10 and 18
     * </pre>
     */
    public static final int DECIMAL18_VALUE = 8;
    /**
     * <code>DECIMAL28SPARSE = 9;</code>
     *
     * <pre>
     *  a decimal supporting precision between 19 and 28
     * </pre>
     */
    public static final int DECIMAL28SPARSE_VALUE = 9;
    /**
     * <code>DECIMAL38SPARSE = 10;</code>
     *
     * <pre>
     *  a decimal supporting precision between 29 and 38
     * </pre>
     */
    public static final int DECIMAL38SPARSE_VALUE = 10;
    /**
     * <code>MONEY = 11;</code>
     *
     * <pre>
     *  signed decimal with two digit precision
     * </pre>
     */
    public static final int MONEY_VALUE = 11;
    /**
     * <code>DATE = 12;</code>
     *
     * <pre>
     *  days since 4713bc
     * </pre>
     */
    public static final int DATE_VALUE = 12;
    /**
     * <code>TIME = 13;</code>
     *
     * <pre>
     *  time in micros before or after 2000/1/1
     * </pre>
     */
    public static final int TIME_VALUE = 13;
    /**
     * <code>TIMETZ = 14;</code>
     *
     * <pre>
     *  time in micros before or after 2000/1/1 with timezone
     * </pre>
     */
    public static final int TIMETZ_VALUE = 14;
    /**
     * <code>TIMESTAMPTZ = 15;</code>
     *
     * <pre>
     *  unix epoch time in millis
     * </pre>
     */
    public static final int TIMESTAMPTZ_VALUE = 15;
    /**
     * <code>TIMESTAMP = 16;</code>
     *
     * <pre>
     *  TBD
     * </pre>
     */
    public static final int TIMESTAMP_VALUE = 16;
    /**
     * <code>INTERVAL = 17;</code>
     *
     * <pre>
     *  TBD
     * </pre>
     */
    public static final int INTERVAL_VALUE = 17;
    /**
     * <code>FLOAT4 = 18;</code>
     *
     * <pre>
     *  4 byte ieee 754
     * </pre>
     */
    public static final int FLOAT4_VALUE = 18;
    /**
     * <code>FLOAT8 = 19;</code>
     *
     * <pre>
     *  8 byte ieee 754
     * </pre>
     */
    public static final int FLOAT8_VALUE = 19;
    /**
     * <code>BIT = 20;</code>
     *
     * <pre>
     *  single bit value (boolean)
     * </pre>
     */
    public static final int BIT_VALUE = 20;
    /**
     * <code>FIXEDCHAR = 21;</code>
     *
     * <pre>
     *  utf8 fixed length string, padded with spaces
     * </pre>
     */
    public static final int FIXEDCHAR_VALUE = 21;
    /**
     * <code>FIXED16CHAR = 22;</code>
     */
    public static final int FIXED16CHAR_VALUE = 22;
    /**
     * <code>FIXEDBINARY = 23;</code>
     *
     * <pre>
     *  fixed length binary, padded with 0 bytes
     * </pre>
     */
    public static final int FIXEDBINARY_VALUE = 23;
    /**
     * <code>VARCHAR = 24;</code>
     *
     * <pre>
     *  utf8 variable length string
     * </pre>
     */
    public static final int VARCHAR_VALUE = 24;
    /**
     * <code>VAR16CHAR = 25;</code>
     *
     * <pre>
     * utf16 variable length string
     * </pre>
     */
    public static final int VAR16CHAR_VALUE = 25;
    /**
     * <code>VARBINARY = 26;</code>
     *
     * <pre>
     *  variable length binary
     * </pre>
     */
    public static final int VARBINARY_VALUE = 26;
    /**
     * <code>UINT1 = 29;</code>
     *
     * <pre>
     *  unsigned 1 byte integer
     * </pre>
     */
    public static final int UINT1_VALUE = 29;
    /**
     * <code>UINT2 = 30;</code>
     *
     * <pre>
     *  unsigned 2 byte integer
     * </pre>
     */
    public static final int UINT2_VALUE = 30;
    /**
     * <code>UINT4 = 31;</code>
     *
     * <pre>
     *  unsigned 4 byte integer
     * </pre>
     */
    public static final int UINT4_VALUE = 31;
    /**
     * <code>UINT8 = 32;</code>
     *
     * <pre>
     *  unsigned 8 byte integer
     * </pre>
     */
    public static final int UINT8_VALUE = 32;
    /**
     * <code>DECIMAL28DENSE = 33;</code>
     *
     * <pre>
     * dense decimal representation, supporting precision between 19 and 28
     * </pre>
     */
    public static final int DECIMAL28DENSE_VALUE = 33;
    /**
     * <code>DECIMAL38DENSE = 34;</code>
     *
     * <pre>
     * dense decimal representation, supporting precision between 28 and 38
     * </pre>
     */
    public static final int DECIMAL38DENSE_VALUE = 34;
    /**
     * <code>NULL = 37;</code>
     *
     * <pre>
     *    PROTO2 = 33;   //  protobuf encoded complex type. (up to 2^16 in length)
     *    PROTO4 = 34;   //  protobuf encoded complex type. (up to 2^32 in length)
     *    MSGPACK2 = 35;   //  msgpack encoded complex type. (up to 2^16 in length)
     *    MSGPACK4 = 36;   //  msgpack encoded complex type. (up to 2^32 in length)
     * </pre>
     */
    public static final int NULL_VALUE = 37;
    /**
     * <code>INTERVALYEAR = 38;</code>
     *
     * <pre>
     * Interval type specifying YEAR to MONTH
     * </pre>
     */
    public static final int INTERVALYEAR_VALUE = 38;
    /**
     * <code>INTERVALDAY = 39;</code>
     *
     * <pre>
     * Interval type specifying DAY to SECONDS
     * </pre>
     */
    public static final int INTERVALDAY_VALUE = 39;
    /**
     * <code>LIST = 40;</code>
     */
    public static final int LIST_VALUE = 40;
    /**
     * <code>GENERIC_OBJECT = 41;</code>
     */
    public static final int GENERIC_OBJECT_VALUE = 41;
    /**
     * <code>UNION = 42;</code>
     */
    public static final int UNION_VALUE = 42;
    /**
     * <code>VARDECIMAL = 43;</code>
     *
     * <pre>
     * variable width decimal (arbitrary precision)
     * </pre>
     */
    public static final int VARDECIMAL_VALUE = 43;


    public final int getNumber() { return value; }

    public static MinorType valueOf(int value) {
      switch (value) {
        case 0: return LATE;
        case 1: return MAP;
        case 3: return TINYINT;
        case 4: return SMALLINT;
        case 5: return INT;
        case 6: return BIGINT;
        case 7: return DECIMAL9;
        case 8: return DECIMAL18;
        case 9: return DECIMAL28SPARSE;
        case 10: return DECIMAL38SPARSE;
        case 11: return MONEY;
        case 12: return DATE;
        case 13: return TIME;
        case 14: return TIMETZ;
        case 15: return TIMESTAMPTZ;
        case 16: return TIMESTAMP;
        case 17: return INTERVAL;
        case 18: return FLOAT4;
        case 19: return FLOAT8;
        case 20: return BIT;
        case 21: return FIXEDCHAR;
        case 22: return FIXED16CHAR;
        case 23: return FIXEDBINARY;
        case 24: return VARCHAR;
        case 25: return VAR16CHAR;
        case 26: return VARBINARY;
        case 29: return UINT1;
        case 30: return UINT2;
        case 31: return UINT4;
        case 32: return UINT8;
        case 33: return DECIMAL28DENSE;
        case 34: return DECIMAL38DENSE;
        case 37: return NULL;
        case 38: return INTERVALYEAR;
        case 39: return INTERVALDAY;
        case 40: return LIST;
        case 41: return GENERIC_OBJECT;
        case 42: return UNION;
        case 43: return VARDECIMAL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MinorType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<MinorType>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<MinorType>() {
            public MinorType findValueByNumber(int number) {
              return MinorType.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.common.types.TypeProtos.getDescriptor().getEnumTypes().get(0);
    }

    private static final MinorType[] VALUES = values();

    public static MinorType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private MinorType(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:common.MinorType)
  }

  /**
   * Protobuf enum {@code common.DataMode}
   */
  public enum DataMode
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>OPTIONAL = 0;</code>
     *
     * <pre>
     * nullable
     * </pre>
     */
    OPTIONAL(0, 0),
    /**
     * <code>REQUIRED = 1;</code>
     *
     * <pre>
     * non-nullable
     * </pre>
     */
    REQUIRED(1, 1),
    /**
     * <code>REPEATED = 2;</code>
     *
     * <pre>
     * single, repeated-field
     * </pre>
     */
    REPEATED(2, 2),
    ;

    /**
     * <code>OPTIONAL = 0;</code>
     *
     * <pre>
     * nullable
     * </pre>
     */
    public static final int OPTIONAL_VALUE = 0;
    /**
     * <code>REQUIRED = 1;</code>
     *
     * <pre>
     * non-nullable
     * </pre>
     */
    public static final int REQUIRED_VALUE = 1;
    /**
     * <code>REPEATED = 2;</code>
     *
     * <pre>
     * single, repeated-field
     * </pre>
     */
    public static final int REPEATED_VALUE = 2;


    public final int getNumber() { return value; }

    public static DataMode valueOf(int value) {
      switch (value) {
        case 0: return OPTIONAL;
        case 1: return REQUIRED;
        case 2: return REPEATED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DataMode>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<DataMode>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<DataMode>() {
            public DataMode findValueByNumber(int number) {
              return DataMode.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.common.types.TypeProtos.getDescriptor().getEnumTypes().get(1);
    }

    private static final DataMode[] VALUES = values();

    public static DataMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private DataMode(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:common.DataMode)
  }

  public interface MajorTypeOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .common.MinorType minor_type = 1;
    /**
     * <code>optional .common.MinorType minor_type = 1;</code>
     */
    boolean hasMinorType();
    /**
     * <code>optional .common.MinorType minor_type = 1;</code>
     */
    org.apache.drill.common.types.TypeProtos.MinorType getMinorType();

    // optional .common.DataMode mode = 2;
    /**
     * <code>optional .common.DataMode mode = 2;</code>
     */
    boolean hasMode();
    /**
     * <code>optional .common.DataMode mode = 2;</code>
     */
    org.apache.drill.common.types.TypeProtos.DataMode getMode();

    // optional int32 width = 3;
    /**
     * <code>optional int32 width = 3;</code>
     */
    boolean hasWidth();
    /**
     * <code>optional int32 width = 3;</code>
     */
    int getWidth();

    // optional int32 precision = 4;
    /**
     * <code>optional int32 precision = 4;</code>
     *
     * <pre>
     * used for decimal types or as optional length for fixed size value
     * </pre>
     */
    boolean hasPrecision();
    /**
     * <code>optional int32 precision = 4;</code>
     *
     * <pre>
     * used for decimal types or as optional length for fixed size value
     * </pre>
     */
    int getPrecision();

    // optional int32 scale = 5;
    /**
     * <code>optional int32 scale = 5;</code>
     *
     * <pre>
     * used for decimal types
     * </pre>
     */
    boolean hasScale();
    /**
     * <code>optional int32 scale = 5;</code>
     *
     * <pre>
     * used for decimal types
     * </pre>
     */
    int getScale();

    // optional int32 timeZone = 6;
    /**
     * <code>optional int32 timeZone = 6;</code>
     *
     * <pre>
     * used by TimeStamp type
     * </pre>
     */
    boolean hasTimeZone();
    /**
     * <code>optional int32 timeZone = 6;</code>
     *
     * <pre>
     * used by TimeStamp type
     * </pre>
     */
    int getTimeZone();

    // repeated .common.MinorType sub_type = 7;
    /**
     * <code>repeated .common.MinorType sub_type = 7;</code>
     *
     * <pre>
     * used by Union type
     * </pre>
     */
    java.util.List<org.apache.drill.common.types.TypeProtos.MinorType> getSubTypeList();
    /**
     * <code>repeated .common.MinorType sub_type = 7;</code>
     *
     * <pre>
     * used by Union type
     * </pre>
     */
    int getSubTypeCount();
    /**
     * <code>repeated .common.MinorType sub_type = 7;</code>
     *
     * <pre>
     * used by Union type
     * </pre>
     */
    org.apache.drill.common.types.TypeProtos.MinorType getSubType(int index);
  }
  /**
   * Protobuf type {@code common.MajorType}
   */
  public static final class MajorType extends
      com.google.protobuf.GeneratedMessage
      implements MajorTypeOrBuilder {
    // Use MajorType.newBuilder() to construct.
    private MajorType(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private MajorType(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final MajorType defaultInstance;
    public static MajorType getDefaultInstance() {
      return defaultInstance;
    }

    public MajorType getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private MajorType(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              org.apache.drill.common.types.TypeProtos.MinorType value = org.apache.drill.common.types.TypeProtos.MinorType.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                minorType_ = value;
              }
              break;
            }
            case 16: {
              int rawValue = input.readEnum();
              org.apache.drill.common.types.TypeProtos.DataMode value = org.apache.drill.common.types.TypeProtos.DataMode.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(2, rawValue);
              } else {
                bitField0_ |= 0x00000002;
                mode_ = value;
              }
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              width_ = input.readInt32();
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              precision_ = input.readInt32();
              break;
            }
            case 40: {
              bitField0_ |= 0x00000010;
              scale_ = input.readInt32();
              break;
            }
            case 48: {
              bitField0_ |= 0x00000020;
              timeZone_ = input.readInt32();
              break;
            }
            case 56: {
              int rawValue = input.readEnum();
              org.apache.drill.common.types.TypeProtos.MinorType value = org.apache.drill.common.types.TypeProtos.MinorType.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(7, rawValue);
              } else {
                if (!((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
                  subType_ = new java.util.ArrayList<org.apache.drill.common.types.TypeProtos.MinorType>();
                  mutable_bitField0_ |= 0x00000040;
                }
                subType_.add(value);
              }
              break;
            }
            case 58: {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while(input.getBytesUntilLimit() > 0) {
                int rawValue = input.readEnum();
                org.apache.drill.common.types.TypeProtos.MinorType value = org.apache.drill.common.types.TypeProtos.MinorType.valueOf(rawValue);
                if (value == null) {
                  unknownFields.mergeVarintField(7, rawValue);
                } else {
                  if (!((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
                    subType_ = new java.util.ArrayList<org.apache.drill.common.types.TypeProtos.MinorType>();
                    mutable_bitField0_ |= 0x00000040;
                  }
                  subType_.add(value);
                }
              }
              input.popLimit(oldLimit);
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
          subType_ = java.util.Collections.unmodifiableList(subType_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.common.types.TypeProtos.internal_static_common_MajorType_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.common.types.TypeProtos.internal_static_common_MajorType_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.common.types.TypeProtos.MajorType.class, org.apache.drill.common.types.TypeProtos.MajorType.Builder.class);
    }

    public static com.google.protobuf.Parser<MajorType> PARSER =
        new com.google.protobuf.AbstractParser<MajorType>() {
      public MajorType parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new MajorType(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<MajorType> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .common.MinorType minor_type = 1;
    public static final int MINOR_TYPE_FIELD_NUMBER = 1;
    private org.apache.drill.common.types.TypeProtos.MinorType minorType_;
    /**
     * <code>optional .common.MinorType minor_type = 1;</code>
     */
    public boolean hasMinorType() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .common.MinorType minor_type = 1;</code>
     */
    public org.apache.drill.common.types.TypeProtos.MinorType getMinorType() {
      return minorType_;
    }

    // optional .common.DataMode mode = 2;
    public static final int MODE_FIELD_NUMBER = 2;
    private org.apache.drill.common.types.TypeProtos.DataMode mode_;
    /**
     * <code>optional .common.DataMode mode = 2;</code>
     */
    public boolean hasMode() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .common.DataMode mode = 2;</code>
     */
    public org.apache.drill.common.types.TypeProtos.DataMode getMode() {
      return mode_;
    }

    // optional int32 width = 3;
    public static final int WIDTH_FIELD_NUMBER = 3;
    private int width_;
    /**
     * <code>optional int32 width = 3;</code>
     */
    public boolean hasWidth() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional int32 width = 3;</code>
     */
    public int getWidth() {
      return width_;
    }

    // optional int32 precision = 4;
    public static final int PRECISION_FIELD_NUMBER = 4;
    private int precision_;
    /**
     * <code>optional int32 precision = 4;</code>
     *
     * <pre>
     * used for decimal types or as optional length for fixed size value
     * </pre>
     */
    public boolean hasPrecision() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional int32 precision = 4;</code>
     *
     * <pre>
     * used for decimal types or as optional length for fixed size value
     * </pre>
     */
    public int getPrecision() {
      return precision_;
    }

    // optional int32 scale = 5;
    public static final int SCALE_FIELD_NUMBER = 5;
    private int scale_;
    /**
     * <code>optional int32 scale = 5;</code>
     *
     * <pre>
     * used for decimal types
     * </pre>
     */
    public boolean hasScale() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional int32 scale = 5;</code>
     *
     * <pre>
     * used for decimal types
     * </pre>
     */
    public int getScale() {
      return scale_;
    }

    // optional int32 timeZone = 6;
    public static final int TIMEZONE_FIELD_NUMBER = 6;
    private int timeZone_;
    /**
     * <code>optional int32 timeZone = 6;</code>
     *
     * <pre>
     * used by TimeStamp type
     * </pre>
     */
    public boolean hasTimeZone() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional int32 timeZone = 6;</code>
     *
     * <pre>
     * used by TimeStamp type
     * </pre>
     */
    public int getTimeZone() {
      return timeZone_;
    }

    // repeated .common.MinorType sub_type = 7;
    public static final int SUB_TYPE_FIELD_NUMBER = 7;
    private java.util.List<org.apache.drill.common.types.TypeProtos.MinorType> subType_;
    /**
     * <code>repeated .common.MinorType sub_type = 7;</code>
     *
     * <pre>
     * used by Union type
     * </pre>
     */
    public java.util.List<org.apache.drill.common.types.TypeProtos.MinorType> getSubTypeList() {
      return subType_;
    }
    /**
     * <code>repeated .common.MinorType sub_type = 7;</code>
     *
     * <pre>
     * used by Union type
     * </pre>
     */
    public int getSubTypeCount() {
      return subType_.size();
    }
    /**
     * <code>repeated .common.MinorType sub_type = 7;</code>
     *
     * <pre>
     * used by Union type
     * </pre>
     */
    public org.apache.drill.common.types.TypeProtos.MinorType getSubType(int index) {
      return subType_.get(index);
    }

    private void initFields() {
      minorType_ = org.apache.drill.common.types.TypeProtos.MinorType.LATE;
      mode_ = org.apache.drill.common.types.TypeProtos.DataMode.OPTIONAL;
      width_ = 0;
      precision_ = 0;
      scale_ = 0;
      timeZone_ = 0;
      subType_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, minorType_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeEnum(2, mode_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeInt32(3, width_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeInt32(4, precision_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeInt32(5, scale_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeInt32(6, timeZone_);
      }
      for (int i = 0; i < subType_.size(); i++) {
        output.writeEnum(7, subType_.get(i).getNumber());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, minorType_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, mode_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(3, width_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(4, precision_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(5, scale_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(6, timeZone_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < subType_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeEnumSizeNoTag(subType_.get(i).getNumber());
        }
        size += dataSize;
        size += 1 * subType_.size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.common.types.TypeProtos.MajorType parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.common.types.TypeProtos.MajorType parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.common.types.TypeProtos.MajorType parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.common.types.TypeProtos.MajorType parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.common.types.TypeProtos.MajorType parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.common.types.TypeProtos.MajorType parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.common.types.TypeProtos.MajorType parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.common.types.TypeProtos.MajorType parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.common.types.TypeProtos.MajorType parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.common.types.TypeProtos.MajorType parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.common.types.TypeProtos.MajorType prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code common.MajorType}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.common.types.TypeProtos.MajorTypeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.common.types.TypeProtos.internal_static_common_MajorType_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.common.types.TypeProtos.internal_static_common_MajorType_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.common.types.TypeProtos.MajorType.class, org.apache.drill.common.types.TypeProtos.MajorType.Builder.class);
      }

      // Construct using org.apache.drill.common.types.TypeProtos.MajorType.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        minorType_ = org.apache.drill.common.types.TypeProtos.MinorType.LATE;
        bitField0_ = (bitField0_ & ~0x00000001);
        mode_ = org.apache.drill.common.types.TypeProtos.DataMode.OPTIONAL;
        bitField0_ = (bitField0_ & ~0x00000002);
        width_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        precision_ = 0;
        bitField0_ = (bitField0_ & ~0x00000008);
        scale_ = 0;
        bitField0_ = (bitField0_ & ~0x00000010);
        timeZone_ = 0;
        bitField0_ = (bitField0_ & ~0x00000020);
        subType_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.common.types.TypeProtos.internal_static_common_MajorType_descriptor;
      }

      public org.apache.drill.common.types.TypeProtos.MajorType getDefaultInstanceForType() {
        return org.apache.drill.common.types.TypeProtos.MajorType.getDefaultInstance();
      }

      public org.apache.drill.common.types.TypeProtos.MajorType build() {
        org.apache.drill.common.types.TypeProtos.MajorType result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.common.types.TypeProtos.MajorType buildPartial() {
        org.apache.drill.common.types.TypeProtos.MajorType result = new org.apache.drill.common.types.TypeProtos.MajorType(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.minorType_ = minorType_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.mode_ = mode_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.width_ = width_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.precision_ = precision_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.scale_ = scale_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.timeZone_ = timeZone_;
        if (((bitField0_ & 0x00000040) == 0x00000040)) {
          subType_ = java.util.Collections.unmodifiableList(subType_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.subType_ = subType_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.common.types.TypeProtos.MajorType) {
          return mergeFrom((org.apache.drill.common.types.TypeProtos.MajorType)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.common.types.TypeProtos.MajorType other) {
        if (other == org.apache.drill.common.types.TypeProtos.MajorType.getDefaultInstance()) return this;
        if (other.hasMinorType()) {
          setMinorType(other.getMinorType());
        }
        if (other.hasMode()) {
          setMode(other.getMode());
        }
        if (other.hasWidth()) {
          setWidth(other.getWidth());
        }
        if (other.hasPrecision()) {
          setPrecision(other.getPrecision());
        }
        if (other.hasScale()) {
          setScale(other.getScale());
        }
        if (other.hasTimeZone()) {
          setTimeZone(other.getTimeZone());
        }
        if (!other.subType_.isEmpty()) {
          if (subType_.isEmpty()) {
            subType_ = other.subType_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureSubTypeIsMutable();
            subType_.addAll(other.subType_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.common.types.TypeProtos.MajorType parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.common.types.TypeProtos.MajorType) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .common.MinorType minor_type = 1;
      private org.apache.drill.common.types.TypeProtos.MinorType minorType_ = org.apache.drill.common.types.TypeProtos.MinorType.LATE;
      /**
       * <code>optional .common.MinorType minor_type = 1;</code>
       */
      public boolean hasMinorType() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .common.MinorType minor_type = 1;</code>
       */
      public org.apache.drill.common.types.TypeProtos.MinorType getMinorType() {
        return minorType_;
      }
      /**
       * <code>optional .common.MinorType minor_type = 1;</code>
       */
      public Builder setMinorType(org.apache.drill.common.types.TypeProtos.MinorType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        minorType_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .common.MinorType minor_type = 1;</code>
       */
      public Builder clearMinorType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        minorType_ = org.apache.drill.common.types.TypeProtos.MinorType.LATE;
        onChanged();
        return this;
      }

      // optional .common.DataMode mode = 2;
      private org.apache.drill.common.types.TypeProtos.DataMode mode_ = org.apache.drill.common.types.TypeProtos.DataMode.OPTIONAL;
      /**
       * <code>optional .common.DataMode mode = 2;</code>
       */
      public boolean hasMode() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .common.DataMode mode = 2;</code>
       */
      public org.apache.drill.common.types.TypeProtos.DataMode getMode() {
        return mode_;
      }
      /**
       * <code>optional .common.DataMode mode = 2;</code>
       */
      public Builder setMode(org.apache.drill.common.types.TypeProtos.DataMode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        mode_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .common.DataMode mode = 2;</code>
       */
      public Builder clearMode() {
        bitField0_ = (bitField0_ & ~0x00000002);
        mode_ = org.apache.drill.common.types.TypeProtos.DataMode.OPTIONAL;
        onChanged();
        return this;
      }

      // optional int32 width = 3;
      private int width_ ;
      /**
       * <code>optional int32 width = 3;</code>
       */
      public boolean hasWidth() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional int32 width = 3;</code>
       */
      public int getWidth() {
        return width_;
      }
      /**
       * <code>optional int32 width = 3;</code>
       */
      public Builder setWidth(int value) {
        bitField0_ |= 0x00000004;
        width_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 width = 3;</code>
       */
      public Builder clearWidth() {
        bitField0_ = (bitField0_ & ~0x00000004);
        width_ = 0;
        onChanged();
        return this;
      }

      // optional int32 precision = 4;
      private int precision_ ;
      /**
       * <code>optional int32 precision = 4;</code>
       *
       * <pre>
       * used for decimal types or as optional length for fixed size value
       * </pre>
       */
      public boolean hasPrecision() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional int32 precision = 4;</code>
       *
       * <pre>
       * used for decimal types or as optional length for fixed size value
       * </pre>
       */
      public int getPrecision() {
        return precision_;
      }
      /**
       * <code>optional int32 precision = 4;</code>
       *
       * <pre>
       * used for decimal types or as optional length for fixed size value
       * </pre>
       */
      public Builder setPrecision(int value) {
        bitField0_ |= 0x00000008;
        precision_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 precision = 4;</code>
       *
       * <pre>
       * used for decimal types or as optional length for fixed size value
       * </pre>
       */
      public Builder clearPrecision() {
        bitField0_ = (bitField0_ & ~0x00000008);
        precision_ = 0;
        onChanged();
        return this;
      }

      // optional int32 scale = 5;
      private int scale_ ;
      /**
       * <code>optional int32 scale = 5;</code>
       *
       * <pre>
       * used for decimal types
       * </pre>
       */
      public boolean hasScale() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional int32 scale = 5;</code>
       *
       * <pre>
       * used for decimal types
       * </pre>
       */
      public int getScale() {
        return scale_;
      }
      /**
       * <code>optional int32 scale = 5;</code>
       *
       * <pre>
       * used for decimal types
       * </pre>
       */
      public Builder setScale(int value) {
        bitField0_ |= 0x00000010;
        scale_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 scale = 5;</code>
       *
       * <pre>
       * used for decimal types
       * </pre>
       */
      public Builder clearScale() {
        bitField0_ = (bitField0_ & ~0x00000010);
        scale_ = 0;
        onChanged();
        return this;
      }

      // optional int32 timeZone = 6;
      private int timeZone_ ;
      /**
       * <code>optional int32 timeZone = 6;</code>
       *
       * <pre>
       * used by TimeStamp type
       * </pre>
       */
      public boolean hasTimeZone() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional int32 timeZone = 6;</code>
       *
       * <pre>
       * used by TimeStamp type
       * </pre>
       */
      public int getTimeZone() {
        return timeZone_;
      }
      /**
       * <code>optional int32 timeZone = 6;</code>
       *
       * <pre>
       * used by TimeStamp type
       * </pre>
       */
      public Builder setTimeZone(int value) {
        bitField0_ |= 0x00000020;
        timeZone_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 timeZone = 6;</code>
       *
       * <pre>
       * used by TimeStamp type
       * </pre>
       */
      public Builder clearTimeZone() {
        bitField0_ = (bitField0_ & ~0x00000020);
        timeZone_ = 0;
        onChanged();
        return this;
      }

      // repeated .common.MinorType sub_type = 7;
      private java.util.List<org.apache.drill.common.types.TypeProtos.MinorType> subType_ =
        java.util.Collections.emptyList();
      private void ensureSubTypeIsMutable() {
        if (!((bitField0_ & 0x00000040) == 0x00000040)) {
          subType_ = new java.util.ArrayList<org.apache.drill.common.types.TypeProtos.MinorType>(subType_);
          bitField0_ |= 0x00000040;
        }
      }
      /**
       * <code>repeated .common.MinorType sub_type = 7;</code>
       *
       * <pre>
       * used by Union type
       * </pre>
       */
      public java.util.List<org.apache.drill.common.types.TypeProtos.MinorType> getSubTypeList() {
        return java.util.Collections.unmodifiableList(subType_);
      }
      /**
       * <code>repeated .common.MinorType sub_type = 7;</code>
       *
       * <pre>
       * used by Union type
       * </pre>
       */
      public int getSubTypeCount() {
        return subType_.size();
      }
      /**
       * <code>repeated .common.MinorType sub_type = 7;</code>
       *
       * <pre>
       * used by Union type
       * </pre>
       */
      public org.apache.drill.common.types.TypeProtos.MinorType getSubType(int index) {
        return subType_.get(index);
      }
      /**
       * <code>repeated .common.MinorType sub_type = 7;</code>
       *
       * <pre>
       * used by Union type
       * </pre>
       */
      public Builder setSubType(
          int index, org.apache.drill.common.types.TypeProtos.MinorType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubTypeIsMutable();
        subType_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated .common.MinorType sub_type = 7;</code>
       *
       * <pre>
       * used by Union type
       * </pre>
       */
      public Builder addSubType(org.apache.drill.common.types.TypeProtos.MinorType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubTypeIsMutable();
        subType_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated .common.MinorType sub_type = 7;</code>
       *
       * <pre>
       * used by Union type
       * </pre>
       */
      public Builder addAllSubType(
          java.lang.Iterable<? extends org.apache.drill.common.types.TypeProtos.MinorType> values) {
        ensureSubTypeIsMutable();
        super.addAll(values, subType_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated .common.MinorType sub_type = 7;</code>
       *
       * <pre>
       * used by Union type
       * </pre>
       */
      public Builder clearSubType() {
        subType_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:common.MajorType)
    }

    static {
      defaultInstance = new MajorType(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:common.MajorType)
  }

  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_common_MajorType_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_common_MajorType_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\013Types.proto\022\006common\"\272\001\n\tMajorType\022%\n\nm" +
      "inor_type\030\001 \001(\0162\021.common.MinorType\022\036\n\004mo" +
      "de\030\002 \001(\0162\020.common.DataMode\022\r\n\005width\030\003 \001(" +
      "\005\022\021\n\tprecision\030\004 \001(\005\022\r\n\005scale\030\005 \001(\005\022\020\n\010t" +
      "imeZone\030\006 \001(\005\022#\n\010sub_type\030\007 \003(\0162\021.common" +
      ".MinorType*\245\004\n\tMinorType\022\010\n\004LATE\020\000\022\007\n\003MA" +
      "P\020\001\022\013\n\007TINYINT\020\003\022\014\n\010SMALLINT\020\004\022\007\n\003INT\020\005\022" +
      "\n\n\006BIGINT\020\006\022\014\n\010DECIMAL9\020\007\022\r\n\tDECIMAL18\020\010" +
      "\022\023\n\017DECIMAL28SPARSE\020\t\022\023\n\017DECIMAL38SPARSE" +
      "\020\n\022\t\n\005MONEY\020\013\022\010\n\004DATE\020\014\022\010\n\004TIME\020\r\022\n\n\006TIM",
      "ETZ\020\016\022\017\n\013TIMESTAMPTZ\020\017\022\r\n\tTIMESTAMP\020\020\022\014\n" +
      "\010INTERVAL\020\021\022\n\n\006FLOAT4\020\022\022\n\n\006FLOAT8\020\023\022\007\n\003B" +
      "IT\020\024\022\r\n\tFIXEDCHAR\020\025\022\017\n\013FIXED16CHAR\020\026\022\017\n\013" +
      "FIXEDBINARY\020\027\022\013\n\007VARCHAR\020\030\022\r\n\tVAR16CHAR\020" +
      "\031\022\r\n\tVARBINARY\020\032\022\t\n\005UINT1\020\035\022\t\n\005UINT2\020\036\022\t" +
      "\n\005UINT4\020\037\022\t\n\005UINT8\020 \022\022\n\016DECIMAL28DENSE\020!" +
      "\022\022\n\016DECIMAL38DENSE\020\"\022\010\n\004NULL\020%\022\020\n\014INTERV" +
      "ALYEAR\020&\022\017\n\013INTERVALDAY\020\'\022\010\n\004LIST\020(\022\022\n\016G" +
      "ENERIC_OBJECT\020)\022\t\n\005UNION\020*\022\016\n\nVARDECIMAL" +
      "\020+*4\n\010DataMode\022\014\n\010OPTIONAL\020\000\022\014\n\010REQUIRED",
      "\020\001\022\014\n\010REPEATED\020\002B-\n\035org.apache.drill.com" +
      "mon.typesB\nTypeProtosH\001"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
      new com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner() {
        public com.google.protobuf.ExtensionRegistry assignDescriptors(
            com.google.protobuf.Descriptors.FileDescriptor root) {
          descriptor = root;
          internal_static_common_MajorType_descriptor =
            getDescriptor().getMessageTypes().get(0);
          internal_static_common_MajorType_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_common_MajorType_descriptor,
              new java.lang.String[] { "MinorType", "Mode", "Width", "Precision", "Scale", "TimeZone", "SubType", });
          return null;
        }
      };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
        }, assigner);
  }

  // @@protoc_insertion_point(outer_class_scope)
}
