/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by http://code.google.com/p/protostuff/ ... DO NOT EDIT!
// Generated from protobuf

package org.apache.drill.exec.proto.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

import com.dyuproject.protostuff.GraphIOUtil;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;

public final class RuntimeFilterBDef implements Externalizable, Message<RuntimeFilterBDef>, Schema<RuntimeFilterBDef>
{

    public static Schema<RuntimeFilterBDef> getSchema()
    {
        return DEFAULT_INSTANCE;
    }

    public static RuntimeFilterBDef getDefaultInstance()
    {
        return DEFAULT_INSTANCE;
    }

    static final RuntimeFilterBDef DEFAULT_INSTANCE = new RuntimeFilterBDef();

    
    private QueryId queryId;
    private int majorFragmentId;
    private int minorFragmentId;
    private Boolean toForeman;
    private List<Integer> bloomFilterSizeInBytes;
    private List<String> probeFields;
    private int hjOpId;
    private long rfIdentifier;

    public RuntimeFilterBDef()
    {
        
    }

    // getters and setters

    // queryId

    public QueryId getQueryId()
    {
        return queryId;
    }

    public RuntimeFilterBDef setQueryId(QueryId queryId)
    {
        this.queryId = queryId;
        return this;
    }

    // majorFragmentId

    public int getMajorFragmentId()
    {
        return majorFragmentId;
    }

    public RuntimeFilterBDef setMajorFragmentId(int majorFragmentId)
    {
        this.majorFragmentId = majorFragmentId;
        return this;
    }

    // minorFragmentId

    public int getMinorFragmentId()
    {
        return minorFragmentId;
    }

    public RuntimeFilterBDef setMinorFragmentId(int minorFragmentId)
    {
        this.minorFragmentId = minorFragmentId;
        return this;
    }

    // toForeman

    public Boolean getToForeman()
    {
        return toForeman;
    }

    public RuntimeFilterBDef setToForeman(Boolean toForeman)
    {
        this.toForeman = toForeman;
        return this;
    }

    // bloomFilterSizeInBytes

    public List<Integer> getBloomFilterSizeInBytesList()
    {
        return bloomFilterSizeInBytes;
    }

    public RuntimeFilterBDef setBloomFilterSizeInBytesList(List<Integer> bloomFilterSizeInBytes)
    {
        this.bloomFilterSizeInBytes = bloomFilterSizeInBytes;
        return this;
    }

    // probeFields

    public List<String> getProbeFieldsList()
    {
        return probeFields;
    }

    public RuntimeFilterBDef setProbeFieldsList(List<String> probeFields)
    {
        this.probeFields = probeFields;
        return this;
    }

    // hjOpId

    public int getHjOpId()
    {
        return hjOpId;
    }

    public RuntimeFilterBDef setHjOpId(int hjOpId)
    {
        this.hjOpId = hjOpId;
        return this;
    }

    // rfIdentifier

    public long getRfIdentifier()
    {
        return rfIdentifier;
    }

    public RuntimeFilterBDef setRfIdentifier(long rfIdentifier)
    {
        this.rfIdentifier = rfIdentifier;
        return this;
    }

    // java serialization

    public void readExternal(ObjectInput in) throws IOException
    {
        GraphIOUtil.mergeDelimitedFrom(in, this, this);
    }

    public void writeExternal(ObjectOutput out) throws IOException
    {
        GraphIOUtil.writeDelimitedTo(out, this, this);
    }

    // message method

    public Schema<RuntimeFilterBDef> cachedSchema()
    {
        return DEFAULT_INSTANCE;
    }

    // schema methods

    public RuntimeFilterBDef newMessage()
    {
        return new RuntimeFilterBDef();
    }

    public Class<RuntimeFilterBDef> typeClass()
    {
        return RuntimeFilterBDef.class;
    }

    public String messageName()
    {
        return RuntimeFilterBDef.class.getSimpleName();
    }

    public String messageFullName()
    {
        return RuntimeFilterBDef.class.getName();
    }

    public boolean isInitialized(RuntimeFilterBDef message)
    {
        return true;
    }

    public void mergeFrom(Input input, RuntimeFilterBDef message) throws IOException
    {
        for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
        {
            switch(number)
            {
                case 0:
                    return;
                case 1:
                    message.queryId = input.mergeObject(message.queryId, QueryId.getSchema());
                    break;

                case 2:
                    message.majorFragmentId = input.readInt32();
                    break;
                case 3:
                    message.minorFragmentId = input.readInt32();
                    break;
                case 4:
                    message.toForeman = input.readBool();
                    break;
                case 5:
                    if(message.bloomFilterSizeInBytes == null)
                        message.bloomFilterSizeInBytes = new ArrayList<Integer>();
                    message.bloomFilterSizeInBytes.add(input.readInt32());
                    break;
                case 6:
                    if(message.probeFields == null)
                        message.probeFields = new ArrayList<String>();
                    message.probeFields.add(input.readString());
                    break;
                case 7:
                    message.hjOpId = input.readInt32();
                    break;
                case 8:
                    message.rfIdentifier = input.readInt64();
                    break;
                default:
                    input.handleUnknownField(number, this);
            }   
        }
    }


    public void writeTo(Output output, RuntimeFilterBDef message) throws IOException
    {
        if(message.queryId != null)
             output.writeObject(1, message.queryId, QueryId.getSchema(), false);


        if(message.majorFragmentId != 0)
            output.writeInt32(2, message.majorFragmentId, false);

        if(message.minorFragmentId != 0)
            output.writeInt32(3, message.minorFragmentId, false);

        if(message.toForeman != null)
            output.writeBool(4, message.toForeman, false);

        if(message.bloomFilterSizeInBytes != null)
        {
            for(Integer bloomFilterSizeInBytes : message.bloomFilterSizeInBytes)
            {
                if(bloomFilterSizeInBytes != null)
                    output.writeInt32(5, bloomFilterSizeInBytes, true);
            }
        }

        if(message.probeFields != null)
        {
            for(String probeFields : message.probeFields)
            {
                if(probeFields != null)
                    output.writeString(6, probeFields, true);
            }
        }

        if(message.hjOpId != 0)
            output.writeInt32(7, message.hjOpId, false);

        if(message.rfIdentifier != 0)
            output.writeInt64(8, message.rfIdentifier, false);
    }

    public String getFieldName(int number)
    {
        switch(number)
        {
            case 1: return "queryId";
            case 2: return "majorFragmentId";
            case 3: return "minorFragmentId";
            case 4: return "toForeman";
            case 5: return "bloomFilterSizeInBytes";
            case 6: return "probeFields";
            case 7: return "hjOpId";
            case 8: return "rfIdentifier";
            default: return null;
        }
    }

    public int getFieldNumber(String name)
    {
        final Integer number = __fieldMap.get(name);
        return number == null ? 0 : number.intValue();
    }

    private static final java.util.HashMap<String,Integer> __fieldMap = new java.util.HashMap<String,Integer>();
    static
    {
        __fieldMap.put("queryId", 1);
        __fieldMap.put("majorFragmentId", 2);
        __fieldMap.put("minorFragmentId", 3);
        __fieldMap.put("toForeman", 4);
        __fieldMap.put("bloomFilterSizeInBytes", 5);
        __fieldMap.put("probeFields", 6);
        __fieldMap.put("hjOpId", 7);
        __fieldMap.put("rfIdentifier", 8);
    }
    
}
