/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by http://code.google.com/p/protostuff/ ... DO NOT EDIT!
// Generated from protobuf

package org.apache.drill.exec.proto;


public final class SchemaBitControl
{

    public static final class BitControlHandshake
    {
        public static final org.apache.drill.exec.proto.SchemaBitControl.BitControlHandshake.MessageSchema WRITE =
            new org.apache.drill.exec.proto.SchemaBitControl.BitControlHandshake.MessageSchema();
        public static final org.apache.drill.exec.proto.SchemaBitControl.BitControlHandshake.BuilderSchema MERGE =
            new org.apache.drill.exec.proto.SchemaBitControl.BitControlHandshake.BuilderSchema();
        
        public static class MessageSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.BitControlHandshake>
        {
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.BitControlHandshake message) throws java.io.IOException
            {
                if(message.hasRpcVersion())
                    output.writeInt32(1, message.getRpcVersion(), false);
                if(message.hasChannel())
                    output.writeEnum(2, message.getChannel().getNumber(), false);
                if(message.hasEndpoint())
                    output.writeObject(3, message.getEndpoint(), org.apache.drill.exec.proto.SchemaCoordinationProtos.DrillbitEndpoint.WRITE, false);

                for(String authenticationMechanisms : message.getAuthenticationMechanismsList())
                    output.writeString(4, authenticationMechanisms, true);
            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.BitControlHandshake message)
            {
                return message.isInitialized();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.BitControlHandshake.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.BitControlHandshake.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.BitControlHandshake> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.BitControlHandshake.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.BitControlHandshake.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.BitControlHandshake.class.getName();
            }
            //unused
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.BitControlHandshake message) throws java.io.IOException {}
            public org.apache.drill.exec.proto.BitControl.BitControlHandshake newMessage() { return null; }
        }
        public static class BuilderSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.BitControlHandshake.Builder>
        {
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.BitControlHandshake.Builder builder) throws java.io.IOException
            {
                for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
                {
                    switch(number)
                    {
                        case 0:
                            return;
                        case 1:
                            builder.setRpcVersion(input.readInt32());
                            break;
                        case 2:
                            builder.setChannel(org.apache.drill.exec.proto.UserBitShared.RpcChannel.valueOf(input.readEnum()));
                            break;
                        case 3:
                            builder.setEndpoint(input.mergeObject(org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.newBuilder(), org.apache.drill.exec.proto.SchemaCoordinationProtos.DrillbitEndpoint.MERGE));

                            break;
                        case 4:
                            builder.addAuthenticationMechanisms(input.readString());
                            break;
                        default:
                            input.handleUnknownField(number, this);
                    }
                }
            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.BitControlHandshake.Builder builder)
            {
                return builder.isInitialized();
            }
            public org.apache.drill.exec.proto.BitControl.BitControlHandshake.Builder newMessage()
            {
                return org.apache.drill.exec.proto.BitControl.BitControlHandshake.newBuilder();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.BitControlHandshake.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.BitControlHandshake.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.BitControlHandshake.Builder> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.BitControlHandshake.Builder.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.BitControlHandshake.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.BitControlHandshake.class.getName();
            }
            //unused
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.BitControlHandshake.Builder builder) throws java.io.IOException {}
        }
        public static java.lang.String getFieldName(int number)
        {
            switch(number)
            {
                case 1: return "rpcVersion";
                case 2: return "channel";
                case 3: return "endpoint";
                case 4: return "authenticationMechanisms";
                default: return null;
            }
        }
        public static int getFieldNumber(java.lang.String name)
        {
            java.lang.Integer number = fieldMap.get(name);
            return number == null ? 0 : number.intValue();
        }
        private static final java.util.HashMap<java.lang.String,java.lang.Integer> fieldMap = new java.util.HashMap<java.lang.String,java.lang.Integer>();
        static
        {
            fieldMap.put("rpcVersion", 1);
            fieldMap.put("channel", 2);
            fieldMap.put("endpoint", 3);
            fieldMap.put("authenticationMechanisms", 4);
        }
    }

    public static final class BitStatus
    {
        public static final org.apache.drill.exec.proto.SchemaBitControl.BitStatus.MessageSchema WRITE =
            new org.apache.drill.exec.proto.SchemaBitControl.BitStatus.MessageSchema();
        public static final org.apache.drill.exec.proto.SchemaBitControl.BitStatus.BuilderSchema MERGE =
            new org.apache.drill.exec.proto.SchemaBitControl.BitStatus.BuilderSchema();
        
        public static class MessageSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.BitStatus>
        {
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.BitStatus message) throws java.io.IOException
            {
                for(org.apache.drill.exec.proto.BitControl.FragmentStatus fragmentStatus : message.getFragmentStatusList())
                    output.writeObject(1, fragmentStatus, org.apache.drill.exec.proto.SchemaBitControl.FragmentStatus.WRITE, true);

            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.BitStatus message)
            {
                return message.isInitialized();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.BitStatus.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.BitStatus.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.BitStatus> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.BitStatus.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.BitStatus.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.BitStatus.class.getName();
            }
            //unused
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.BitStatus message) throws java.io.IOException {}
            public org.apache.drill.exec.proto.BitControl.BitStatus newMessage() { return null; }
        }
        public static class BuilderSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.BitStatus.Builder>
        {
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.BitStatus.Builder builder) throws java.io.IOException
            {
                for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
                {
                    switch(number)
                    {
                        case 0:
                            return;
                        case 1:
                            builder.addFragmentStatus(input.mergeObject(org.apache.drill.exec.proto.BitControl.FragmentStatus.newBuilder(), org.apache.drill.exec.proto.SchemaBitControl.FragmentStatus.MERGE));

                            break;
                        default:
                            input.handleUnknownField(number, this);
                    }
                }
            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.BitStatus.Builder builder)
            {
                return builder.isInitialized();
            }
            public org.apache.drill.exec.proto.BitControl.BitStatus.Builder newMessage()
            {
                return org.apache.drill.exec.proto.BitControl.BitStatus.newBuilder();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.BitStatus.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.BitStatus.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.BitStatus.Builder> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.BitStatus.Builder.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.BitStatus.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.BitStatus.class.getName();
            }
            //unused
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.BitStatus.Builder builder) throws java.io.IOException {}
        }
        public static java.lang.String getFieldName(int number)
        {
            switch(number)
            {
                case 1: return "fragmentStatus";
                default: return null;
            }
        }
        public static int getFieldNumber(java.lang.String name)
        {
            java.lang.Integer number = fieldMap.get(name);
            return number == null ? 0 : number.intValue();
        }
        private static final java.util.HashMap<java.lang.String,java.lang.Integer> fieldMap = new java.util.HashMap<java.lang.String,java.lang.Integer>();
        static
        {
            fieldMap.put("fragmentStatus", 1);
        }
    }

    public static final class FragmentStatus
    {
        public static final org.apache.drill.exec.proto.SchemaBitControl.FragmentStatus.MessageSchema WRITE =
            new org.apache.drill.exec.proto.SchemaBitControl.FragmentStatus.MessageSchema();
        public static final org.apache.drill.exec.proto.SchemaBitControl.FragmentStatus.BuilderSchema MERGE =
            new org.apache.drill.exec.proto.SchemaBitControl.FragmentStatus.BuilderSchema();
        
        public static class MessageSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.FragmentStatus>
        {
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.FragmentStatus message) throws java.io.IOException
            {
                if(message.hasProfile())
                    output.writeObject(1, message.getProfile(), org.apache.drill.exec.proto.SchemaUserBitShared.MinorFragmentProfile.WRITE, false);

                if(message.hasHandle())
                    output.writeObject(2, message.getHandle(), org.apache.drill.exec.proto.SchemaExecProtos.FragmentHandle.WRITE, false);

            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.FragmentStatus message)
            {
                return message.isInitialized();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.FragmentStatus.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.FragmentStatus.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.FragmentStatus> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.FragmentStatus.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.FragmentStatus.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.FragmentStatus.class.getName();
            }
            //unused
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.FragmentStatus message) throws java.io.IOException {}
            public org.apache.drill.exec.proto.BitControl.FragmentStatus newMessage() { return null; }
        }
        public static class BuilderSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder>
        {
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder builder) throws java.io.IOException
            {
                for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
                {
                    switch(number)
                    {
                        case 0:
                            return;
                        case 1:
                            builder.setProfile(input.mergeObject(org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile.newBuilder(), org.apache.drill.exec.proto.SchemaUserBitShared.MinorFragmentProfile.MERGE));

                            break;
                        case 2:
                            builder.setHandle(input.mergeObject(org.apache.drill.exec.proto.ExecProtos.FragmentHandle.newBuilder(), org.apache.drill.exec.proto.SchemaExecProtos.FragmentHandle.MERGE));

                            break;
                        default:
                            input.handleUnknownField(number, this);
                    }
                }
            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder builder)
            {
                return builder.isInitialized();
            }
            public org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder newMessage()
            {
                return org.apache.drill.exec.proto.BitControl.FragmentStatus.newBuilder();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.FragmentStatus.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.FragmentStatus.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.FragmentStatus.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.FragmentStatus.class.getName();
            }
            //unused
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder builder) throws java.io.IOException {}
        }
        public static java.lang.String getFieldName(int number)
        {
            switch(number)
            {
                case 1: return "profile";
                case 2: return "handle";
                default: return null;
            }
        }
        public static int getFieldNumber(java.lang.String name)
        {
            java.lang.Integer number = fieldMap.get(name);
            return number == null ? 0 : number.intValue();
        }
        private static final java.util.HashMap<java.lang.String,java.lang.Integer> fieldMap = new java.util.HashMap<java.lang.String,java.lang.Integer>();
        static
        {
            fieldMap.put("profile", 1);
            fieldMap.put("handle", 2);
        }
    }

    public static final class InitializeFragments
    {
        public static final org.apache.drill.exec.proto.SchemaBitControl.InitializeFragments.MessageSchema WRITE =
            new org.apache.drill.exec.proto.SchemaBitControl.InitializeFragments.MessageSchema();
        public static final org.apache.drill.exec.proto.SchemaBitControl.InitializeFragments.BuilderSchema MERGE =
            new org.apache.drill.exec.proto.SchemaBitControl.InitializeFragments.BuilderSchema();
        
        public static class MessageSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.InitializeFragments>
        {
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.InitializeFragments message) throws java.io.IOException
            {
                for(org.apache.drill.exec.proto.BitControl.PlanFragment fragment : message.getFragmentList())
                    output.writeObject(1, fragment, org.apache.drill.exec.proto.SchemaBitControl.PlanFragment.WRITE, true);

            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.InitializeFragments message)
            {
                return message.isInitialized();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.InitializeFragments.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.InitializeFragments.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.InitializeFragments> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.InitializeFragments.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.InitializeFragments.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.InitializeFragments.class.getName();
            }
            //unused
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.InitializeFragments message) throws java.io.IOException {}
            public org.apache.drill.exec.proto.BitControl.InitializeFragments newMessage() { return null; }
        }
        public static class BuilderSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.InitializeFragments.Builder>
        {
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.InitializeFragments.Builder builder) throws java.io.IOException
            {
                for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
                {
                    switch(number)
                    {
                        case 0:
                            return;
                        case 1:
                            builder.addFragment(input.mergeObject(org.apache.drill.exec.proto.BitControl.PlanFragment.newBuilder(), org.apache.drill.exec.proto.SchemaBitControl.PlanFragment.MERGE));

                            break;
                        default:
                            input.handleUnknownField(number, this);
                    }
                }
            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.InitializeFragments.Builder builder)
            {
                return builder.isInitialized();
            }
            public org.apache.drill.exec.proto.BitControl.InitializeFragments.Builder newMessage()
            {
                return org.apache.drill.exec.proto.BitControl.InitializeFragments.newBuilder();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.InitializeFragments.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.InitializeFragments.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.InitializeFragments.Builder> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.InitializeFragments.Builder.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.InitializeFragments.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.InitializeFragments.class.getName();
            }
            //unused
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.InitializeFragments.Builder builder) throws java.io.IOException {}
        }
        public static java.lang.String getFieldName(int number)
        {
            switch(number)
            {
                case 1: return "fragment";
                default: return null;
            }
        }
        public static int getFieldNumber(java.lang.String name)
        {
            java.lang.Integer number = fieldMap.get(name);
            return number == null ? 0 : number.intValue();
        }
        private static final java.util.HashMap<java.lang.String,java.lang.Integer> fieldMap = new java.util.HashMap<java.lang.String,java.lang.Integer>();
        static
        {
            fieldMap.put("fragment", 1);
        }
    }

    public static final class CustomMessage
    {
        public static final org.apache.drill.exec.proto.SchemaBitControl.CustomMessage.MessageSchema WRITE =
            new org.apache.drill.exec.proto.SchemaBitControl.CustomMessage.MessageSchema();
        public static final org.apache.drill.exec.proto.SchemaBitControl.CustomMessage.BuilderSchema MERGE =
            new org.apache.drill.exec.proto.SchemaBitControl.CustomMessage.BuilderSchema();
        
        public static class MessageSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.CustomMessage>
        {
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.CustomMessage message) throws java.io.IOException
            {
                if(message.hasType())
                    output.writeInt32(1, message.getType(), false);
                if(message.hasMessage())
                    output.writeByteArray(2, message.getMessage().toByteArray(), false);

            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.CustomMessage message)
            {
                return message.isInitialized();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.CustomMessage.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.CustomMessage.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.CustomMessage> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.CustomMessage.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.CustomMessage.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.CustomMessage.class.getName();
            }
            //unused
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.CustomMessage message) throws java.io.IOException {}
            public org.apache.drill.exec.proto.BitControl.CustomMessage newMessage() { return null; }
        }
        public static class BuilderSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.CustomMessage.Builder>
        {
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.CustomMessage.Builder builder) throws java.io.IOException
            {
                for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
                {
                    switch(number)
                    {
                        case 0:
                            return;
                        case 1:
                            builder.setType(input.readInt32());
                            break;
                        case 2:
                            builder.setMessage(com.google.protobuf.ByteString.copyFrom(input.readByteArray()));
                            break;
                        default:
                            input.handleUnknownField(number, this);
                    }
                }
            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.CustomMessage.Builder builder)
            {
                return builder.isInitialized();
            }
            public org.apache.drill.exec.proto.BitControl.CustomMessage.Builder newMessage()
            {
                return org.apache.drill.exec.proto.BitControl.CustomMessage.newBuilder();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.CustomMessage.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.CustomMessage.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.CustomMessage.Builder> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.CustomMessage.Builder.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.CustomMessage.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.CustomMessage.class.getName();
            }
            //unused
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.CustomMessage.Builder builder) throws java.io.IOException {}
        }
        public static java.lang.String getFieldName(int number)
        {
            switch(number)
            {
                case 1: return "type";
                case 2: return "message";
                default: return null;
            }
        }
        public static int getFieldNumber(java.lang.String name)
        {
            java.lang.Integer number = fieldMap.get(name);
            return number == null ? 0 : number.intValue();
        }
        private static final java.util.HashMap<java.lang.String,java.lang.Integer> fieldMap = new java.util.HashMap<java.lang.String,java.lang.Integer>();
        static
        {
            fieldMap.put("type", 1);
            fieldMap.put("message", 2);
        }
    }

    public static final class PlanFragment
    {
        public static final org.apache.drill.exec.proto.SchemaBitControl.PlanFragment.MessageSchema WRITE =
            new org.apache.drill.exec.proto.SchemaBitControl.PlanFragment.MessageSchema();
        public static final org.apache.drill.exec.proto.SchemaBitControl.PlanFragment.BuilderSchema MERGE =
            new org.apache.drill.exec.proto.SchemaBitControl.PlanFragment.BuilderSchema();
        
        public static class MessageSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.PlanFragment>
        {
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.PlanFragment message) throws java.io.IOException
            {
                if(message.hasHandle())
                    output.writeObject(1, message.getHandle(), org.apache.drill.exec.proto.SchemaExecProtos.FragmentHandle.WRITE, false);

                if(message.hasNetworkCost())
                    output.writeFloat(4, message.getNetworkCost(), false);
                if(message.hasCpuCost())
                    output.writeFloat(5, message.getCpuCost(), false);
                if(message.hasDiskCost())
                    output.writeFloat(6, message.getDiskCost(), false);
                if(message.hasMemoryCost())
                    output.writeFloat(7, message.getMemoryCost(), false);
                if(message.hasFragmentJson())
                    output.writeString(8, message.getFragmentJson(), false);
                if(message.hasLeafFragment())
                    output.writeBool(9, message.getLeafFragment(), false);
                if(message.hasAssignment())
                    output.writeObject(10, message.getAssignment(), org.apache.drill.exec.proto.SchemaCoordinationProtos.DrillbitEndpoint.WRITE, false);

                if(message.hasForeman())
                    output.writeObject(11, message.getForeman(), org.apache.drill.exec.proto.SchemaCoordinationProtos.DrillbitEndpoint.WRITE, false);

                if(message.hasMemInitial())
                    output.writeInt64(12, message.getMemInitial(), false);
                if(message.hasMemMax())
                    output.writeInt64(13, message.getMemMax(), false);
                if(message.hasCredentials())
                    output.writeObject(14, message.getCredentials(), org.apache.drill.exec.proto.SchemaUserBitShared.UserCredentials.WRITE, false);

                if(message.hasOptionsJson())
                    output.writeString(15, message.getOptionsJson(), false);
                if(message.hasContext())
                    output.writeObject(16, message.getContext(), org.apache.drill.exec.proto.SchemaBitControl.QueryContextInformation.WRITE, false);

                for(org.apache.drill.exec.proto.BitControl.Collector collector : message.getCollectorList())
                    output.writeObject(17, collector, org.apache.drill.exec.proto.SchemaBitControl.Collector.WRITE, true);

            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.PlanFragment message)
            {
                return message.isInitialized();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.PlanFragment.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.PlanFragment.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.PlanFragment> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.PlanFragment.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.PlanFragment.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.PlanFragment.class.getName();
            }
            //unused
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.PlanFragment message) throws java.io.IOException {}
            public org.apache.drill.exec.proto.BitControl.PlanFragment newMessage() { return null; }
        }
        public static class BuilderSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.PlanFragment.Builder>
        {
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder builder) throws java.io.IOException
            {
                for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
                {
                    switch(number)
                    {
                        case 0:
                            return;
                        case 1:
                            builder.setHandle(input.mergeObject(org.apache.drill.exec.proto.ExecProtos.FragmentHandle.newBuilder(), org.apache.drill.exec.proto.SchemaExecProtos.FragmentHandle.MERGE));

                            break;
                        case 4:
                            builder.setNetworkCost(input.readFloat());
                            break;
                        case 5:
                            builder.setCpuCost(input.readFloat());
                            break;
                        case 6:
                            builder.setDiskCost(input.readFloat());
                            break;
                        case 7:
                            builder.setMemoryCost(input.readFloat());
                            break;
                        case 8:
                            builder.setFragmentJson(input.readString());
                            break;
                        case 9:
                            builder.setLeafFragment(input.readBool());
                            break;
                        case 10:
                            builder.setAssignment(input.mergeObject(org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.newBuilder(), org.apache.drill.exec.proto.SchemaCoordinationProtos.DrillbitEndpoint.MERGE));

                            break;
                        case 11:
                            builder.setForeman(input.mergeObject(org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.newBuilder(), org.apache.drill.exec.proto.SchemaCoordinationProtos.DrillbitEndpoint.MERGE));

                            break;
                        case 12:
                            builder.setMemInitial(input.readInt64());
                            break;
                        case 13:
                            builder.setMemMax(input.readInt64());
                            break;
                        case 14:
                            builder.setCredentials(input.mergeObject(org.apache.drill.exec.proto.UserBitShared.UserCredentials.newBuilder(), org.apache.drill.exec.proto.SchemaUserBitShared.UserCredentials.MERGE));

                            break;
                        case 15:
                            builder.setOptionsJson(input.readString());
                            break;
                        case 16:
                            builder.setContext(input.mergeObject(org.apache.drill.exec.proto.BitControl.QueryContextInformation.newBuilder(), org.apache.drill.exec.proto.SchemaBitControl.QueryContextInformation.MERGE));

                            break;
                        case 17:
                            builder.addCollector(input.mergeObject(org.apache.drill.exec.proto.BitControl.Collector.newBuilder(), org.apache.drill.exec.proto.SchemaBitControl.Collector.MERGE));

                            break;
                        default:
                            input.handleUnknownField(number, this);
                    }
                }
            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.PlanFragment.Builder builder)
            {
                return builder.isInitialized();
            }
            public org.apache.drill.exec.proto.BitControl.PlanFragment.Builder newMessage()
            {
                return org.apache.drill.exec.proto.BitControl.PlanFragment.newBuilder();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.PlanFragment.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.PlanFragment.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.PlanFragment.Builder> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.PlanFragment.Builder.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.PlanFragment.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.PlanFragment.class.getName();
            }
            //unused
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder builder) throws java.io.IOException {}
        }
        public static java.lang.String getFieldName(int number)
        {
            switch(number)
            {
                case 1: return "handle";
                case 4: return "networkCost";
                case 5: return "cpuCost";
                case 6: return "diskCost";
                case 7: return "memoryCost";
                case 8: return "fragmentJson";
                case 9: return "leafFragment";
                case 10: return "assignment";
                case 11: return "foreman";
                case 12: return "memInitial";
                case 13: return "memMax";
                case 14: return "credentials";
                case 15: return "optionsJson";
                case 16: return "context";
                case 17: return "collector";
                default: return null;
            }
        }
        public static int getFieldNumber(java.lang.String name)
        {
            java.lang.Integer number = fieldMap.get(name);
            return number == null ? 0 : number.intValue();
        }
        private static final java.util.HashMap<java.lang.String,java.lang.Integer> fieldMap = new java.util.HashMap<java.lang.String,java.lang.Integer>();
        static
        {
            fieldMap.put("handle", 1);
            fieldMap.put("networkCost", 4);
            fieldMap.put("cpuCost", 5);
            fieldMap.put("diskCost", 6);
            fieldMap.put("memoryCost", 7);
            fieldMap.put("fragmentJson", 8);
            fieldMap.put("leafFragment", 9);
            fieldMap.put("assignment", 10);
            fieldMap.put("foreman", 11);
            fieldMap.put("memInitial", 12);
            fieldMap.put("memMax", 13);
            fieldMap.put("credentials", 14);
            fieldMap.put("optionsJson", 15);
            fieldMap.put("context", 16);
            fieldMap.put("collector", 17);
        }
    }

    public static final class Collector
    {
        public static final org.apache.drill.exec.proto.SchemaBitControl.Collector.MessageSchema WRITE =
            new org.apache.drill.exec.proto.SchemaBitControl.Collector.MessageSchema();
        public static final org.apache.drill.exec.proto.SchemaBitControl.Collector.BuilderSchema MERGE =
            new org.apache.drill.exec.proto.SchemaBitControl.Collector.BuilderSchema();
        
        public static class MessageSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.Collector>
        {
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.Collector message) throws java.io.IOException
            {
                if(message.hasOppositeMajorFragmentId())
                    output.writeInt32(1, message.getOppositeMajorFragmentId(), false);
                for(int incomingMinorFragment : message.getIncomingMinorFragmentList())
                    output.writeInt32(2, incomingMinorFragment, true);
                if(message.hasSupportsOutOfOrder())
                    output.writeBool(3, message.getSupportsOutOfOrder(), false);
                if(message.hasIsSpooling())
                    output.writeBool(4, message.getIsSpooling(), false);
            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.Collector message)
            {
                return message.isInitialized();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.Collector.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.Collector.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.Collector> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.Collector.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.Collector.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.Collector.class.getName();
            }
            //unused
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.Collector message) throws java.io.IOException {}
            public org.apache.drill.exec.proto.BitControl.Collector newMessage() { return null; }
        }
        public static class BuilderSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.Collector.Builder>
        {
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.Collector.Builder builder) throws java.io.IOException
            {
                for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
                {
                    switch(number)
                    {
                        case 0:
                            return;
                        case 1:
                            builder.setOppositeMajorFragmentId(input.readInt32());
                            break;
                        case 2:
                            builder.addIncomingMinorFragment(input.readInt32());
                            break;
                        case 3:
                            builder.setSupportsOutOfOrder(input.readBool());
                            break;
                        case 4:
                            builder.setIsSpooling(input.readBool());
                            break;
                        default:
                            input.handleUnknownField(number, this);
                    }
                }
            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.Collector.Builder builder)
            {
                return builder.isInitialized();
            }
            public org.apache.drill.exec.proto.BitControl.Collector.Builder newMessage()
            {
                return org.apache.drill.exec.proto.BitControl.Collector.newBuilder();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.Collector.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.Collector.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.Collector.Builder> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.Collector.Builder.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.Collector.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.Collector.class.getName();
            }
            //unused
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.Collector.Builder builder) throws java.io.IOException {}
        }
        public static java.lang.String getFieldName(int number)
        {
            switch(number)
            {
                case 1: return "oppositeMajorFragmentId";
                case 2: return "incomingMinorFragment";
                case 3: return "supportsOutOfOrder";
                case 4: return "isSpooling";
                default: return null;
            }
        }
        public static int getFieldNumber(java.lang.String name)
        {
            java.lang.Integer number = fieldMap.get(name);
            return number == null ? 0 : number.intValue();
        }
        private static final java.util.HashMap<java.lang.String,java.lang.Integer> fieldMap = new java.util.HashMap<java.lang.String,java.lang.Integer>();
        static
        {
            fieldMap.put("oppositeMajorFragmentId", 1);
            fieldMap.put("incomingMinorFragment", 2);
            fieldMap.put("supportsOutOfOrder", 3);
            fieldMap.put("isSpooling", 4);
        }
    }

    public static final class QueryContextInformation
    {
        public static final org.apache.drill.exec.proto.SchemaBitControl.QueryContextInformation.MessageSchema WRITE =
            new org.apache.drill.exec.proto.SchemaBitControl.QueryContextInformation.MessageSchema();
        public static final org.apache.drill.exec.proto.SchemaBitControl.QueryContextInformation.BuilderSchema MERGE =
            new org.apache.drill.exec.proto.SchemaBitControl.QueryContextInformation.BuilderSchema();
        
        public static class MessageSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.QueryContextInformation>
        {
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.QueryContextInformation message) throws java.io.IOException
            {
                if(message.hasQueryStartTime())
                    output.writeInt64(1, message.getQueryStartTime(), false);
                if(message.hasTimeZone())
                    output.writeInt32(2, message.getTimeZone(), false);
                if(message.hasDefaultSchemaName())
                    output.writeString(3, message.getDefaultSchemaName(), false);
                if(message.hasSessionId())
                    output.writeString(4, message.getSessionId(), false);
            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.QueryContextInformation message)
            {
                return message.isInitialized();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.QueryContextInformation.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.QueryContextInformation.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.QueryContextInformation> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.QueryContextInformation.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.QueryContextInformation.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.QueryContextInformation.class.getName();
            }
            //unused
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.QueryContextInformation message) throws java.io.IOException {}
            public org.apache.drill.exec.proto.BitControl.QueryContextInformation newMessage() { return null; }
        }
        public static class BuilderSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.QueryContextInformation.Builder>
        {
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.QueryContextInformation.Builder builder) throws java.io.IOException
            {
                for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
                {
                    switch(number)
                    {
                        case 0:
                            return;
                        case 1:
                            builder.setQueryStartTime(input.readInt64());
                            break;
                        case 2:
                            builder.setTimeZone(input.readInt32());
                            break;
                        case 3:
                            builder.setDefaultSchemaName(input.readString());
                            break;
                        case 4:
                            builder.setSessionId(input.readString());
                            break;
                        default:
                            input.handleUnknownField(number, this);
                    }
                }
            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.QueryContextInformation.Builder builder)
            {
                return builder.isInitialized();
            }
            public org.apache.drill.exec.proto.BitControl.QueryContextInformation.Builder newMessage()
            {
                return org.apache.drill.exec.proto.BitControl.QueryContextInformation.newBuilder();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.QueryContextInformation.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.QueryContextInformation.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.QueryContextInformation.Builder> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.QueryContextInformation.Builder.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.QueryContextInformation.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.QueryContextInformation.class.getName();
            }
            //unused
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.QueryContextInformation.Builder builder) throws java.io.IOException {}
        }
        public static java.lang.String getFieldName(int number)
        {
            switch(number)
            {
                case 1: return "queryStartTime";
                case 2: return "timeZone";
                case 3: return "defaultSchemaName";
                case 4: return "sessionId";
                default: return null;
            }
        }
        public static int getFieldNumber(java.lang.String name)
        {
            java.lang.Integer number = fieldMap.get(name);
            return number == null ? 0 : number.intValue();
        }
        private static final java.util.HashMap<java.lang.String,java.lang.Integer> fieldMap = new java.util.HashMap<java.lang.String,java.lang.Integer>();
        static
        {
            fieldMap.put("queryStartTime", 1);
            fieldMap.put("timeZone", 2);
            fieldMap.put("defaultSchemaName", 3);
            fieldMap.put("sessionId", 4);
        }
    }

    public static final class WorkQueueStatus
    {
        public static final org.apache.drill.exec.proto.SchemaBitControl.WorkQueueStatus.MessageSchema WRITE =
            new org.apache.drill.exec.proto.SchemaBitControl.WorkQueueStatus.MessageSchema();
        public static final org.apache.drill.exec.proto.SchemaBitControl.WorkQueueStatus.BuilderSchema MERGE =
            new org.apache.drill.exec.proto.SchemaBitControl.WorkQueueStatus.BuilderSchema();
        
        public static class MessageSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.WorkQueueStatus>
        {
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.WorkQueueStatus message) throws java.io.IOException
            {
                if(message.hasEndpoint())
                    output.writeObject(1, message.getEndpoint(), org.apache.drill.exec.proto.SchemaCoordinationProtos.DrillbitEndpoint.WRITE, false);

                if(message.hasQueueLength())
                    output.writeInt32(2, message.getQueueLength(), false);
                if(message.hasReportTime())
                    output.writeInt64(3, message.getReportTime(), false);
            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.WorkQueueStatus message)
            {
                return message.isInitialized();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.WorkQueueStatus.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.WorkQueueStatus.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.WorkQueueStatus> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.WorkQueueStatus.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.WorkQueueStatus.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.WorkQueueStatus.class.getName();
            }
            //unused
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.WorkQueueStatus message) throws java.io.IOException {}
            public org.apache.drill.exec.proto.BitControl.WorkQueueStatus newMessage() { return null; }
        }
        public static class BuilderSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.WorkQueueStatus.Builder>
        {
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.WorkQueueStatus.Builder builder) throws java.io.IOException
            {
                for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
                {
                    switch(number)
                    {
                        case 0:
                            return;
                        case 1:
                            builder.setEndpoint(input.mergeObject(org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.newBuilder(), org.apache.drill.exec.proto.SchemaCoordinationProtos.DrillbitEndpoint.MERGE));

                            break;
                        case 2:
                            builder.setQueueLength(input.readInt32());
                            break;
                        case 3:
                            builder.setReportTime(input.readInt64());
                            break;
                        default:
                            input.handleUnknownField(number, this);
                    }
                }
            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.WorkQueueStatus.Builder builder)
            {
                return builder.isInitialized();
            }
            public org.apache.drill.exec.proto.BitControl.WorkQueueStatus.Builder newMessage()
            {
                return org.apache.drill.exec.proto.BitControl.WorkQueueStatus.newBuilder();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.WorkQueueStatus.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.WorkQueueStatus.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.WorkQueueStatus.Builder> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.WorkQueueStatus.Builder.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.WorkQueueStatus.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.WorkQueueStatus.class.getName();
            }
            //unused
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.WorkQueueStatus.Builder builder) throws java.io.IOException {}
        }
        public static java.lang.String getFieldName(int number)
        {
            switch(number)
            {
                case 1: return "endpoint";
                case 2: return "queueLength";
                case 3: return "reportTime";
                default: return null;
            }
        }
        public static int getFieldNumber(java.lang.String name)
        {
            java.lang.Integer number = fieldMap.get(name);
            return number == null ? 0 : number.intValue();
        }
        private static final java.util.HashMap<java.lang.String,java.lang.Integer> fieldMap = new java.util.HashMap<java.lang.String,java.lang.Integer>();
        static
        {
            fieldMap.put("endpoint", 1);
            fieldMap.put("queueLength", 2);
            fieldMap.put("reportTime", 3);
        }
    }

    public static final class FinishedReceiver
    {
        public static final org.apache.drill.exec.proto.SchemaBitControl.FinishedReceiver.MessageSchema WRITE =
            new org.apache.drill.exec.proto.SchemaBitControl.FinishedReceiver.MessageSchema();
        public static final org.apache.drill.exec.proto.SchemaBitControl.FinishedReceiver.BuilderSchema MERGE =
            new org.apache.drill.exec.proto.SchemaBitControl.FinishedReceiver.BuilderSchema();
        
        public static class MessageSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.FinishedReceiver>
        {
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.FinishedReceiver message) throws java.io.IOException
            {
                if(message.hasReceiver())
                    output.writeObject(1, message.getReceiver(), org.apache.drill.exec.proto.SchemaExecProtos.FragmentHandle.WRITE, false);

                if(message.hasSender())
                    output.writeObject(2, message.getSender(), org.apache.drill.exec.proto.SchemaExecProtos.FragmentHandle.WRITE, false);

            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.FinishedReceiver message)
            {
                return message.isInitialized();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.FinishedReceiver.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.FinishedReceiver.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.FinishedReceiver> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.FinishedReceiver.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.FinishedReceiver.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.FinishedReceiver.class.getName();
            }
            //unused
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.FinishedReceiver message) throws java.io.IOException {}
            public org.apache.drill.exec.proto.BitControl.FinishedReceiver newMessage() { return null; }
        }
        public static class BuilderSchema implements com.dyuproject.protostuff.Schema<org.apache.drill.exec.proto.BitControl.FinishedReceiver.Builder>
        {
            public void mergeFrom(com.dyuproject.protostuff.Input input, org.apache.drill.exec.proto.BitControl.FinishedReceiver.Builder builder) throws java.io.IOException
            {
                for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
                {
                    switch(number)
                    {
                        case 0:
                            return;
                        case 1:
                            builder.setReceiver(input.mergeObject(org.apache.drill.exec.proto.ExecProtos.FragmentHandle.newBuilder(), org.apache.drill.exec.proto.SchemaExecProtos.FragmentHandle.MERGE));

                            break;
                        case 2:
                            builder.setSender(input.mergeObject(org.apache.drill.exec.proto.ExecProtos.FragmentHandle.newBuilder(), org.apache.drill.exec.proto.SchemaExecProtos.FragmentHandle.MERGE));

                            break;
                        default:
                            input.handleUnknownField(number, this);
                    }
                }
            }
            public boolean isInitialized(org.apache.drill.exec.proto.BitControl.FinishedReceiver.Builder builder)
            {
                return builder.isInitialized();
            }
            public org.apache.drill.exec.proto.BitControl.FinishedReceiver.Builder newMessage()
            {
                return org.apache.drill.exec.proto.BitControl.FinishedReceiver.newBuilder();
            }
            public java.lang.String getFieldName(int number)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.FinishedReceiver.getFieldName(number);
            }
            public int getFieldNumber(java.lang.String name)
            {
                return org.apache.drill.exec.proto.SchemaBitControl.FinishedReceiver.getFieldNumber(name);
            }
            public java.lang.Class<org.apache.drill.exec.proto.BitControl.FinishedReceiver.Builder> typeClass()
            {
                return org.apache.drill.exec.proto.BitControl.FinishedReceiver.Builder.class;
            }
            public java.lang.String messageName()
            {
                return org.apache.drill.exec.proto.BitControl.FinishedReceiver.class.getSimpleName();
            }
            public java.lang.String messageFullName()
            {
                return org.apache.drill.exec.proto.BitControl.FinishedReceiver.class.getName();
            }
            //unused
            public void writeTo(com.dyuproject.protostuff.Output output, org.apache.drill.exec.proto.BitControl.FinishedReceiver.Builder builder) throws java.io.IOException {}
        }
        public static java.lang.String getFieldName(int number)
        {
            switch(number)
            {
                case 1: return "receiver";
                case 2: return "sender";
                default: return null;
            }
        }
        public static int getFieldNumber(java.lang.String name)
        {
            java.lang.Integer number = fieldMap.get(name);
            return number == null ? 0 : number.intValue();
        }
        private static final java.util.HashMap<java.lang.String,java.lang.Integer> fieldMap = new java.util.HashMap<java.lang.String,java.lang.Integer>();
        static
        {
            fieldMap.put("receiver", 1);
            fieldMap.put("sender", 2);
        }
    }

}
