/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: User.proto

package org.apache.drill.exec.proto;

public final class UserProtos {
  private UserProtos() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  /**
   * Protobuf enum {@code exec.user.RpcType}
   *
   * <pre>
   *&#47;/// User &lt;-&gt; Bit RPC ///////
   * </pre>
   */
  public enum RpcType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>HANDSHAKE = 0;</code>
     */
    HANDSHAKE(0, 0),
    /**
     * <code>ACK = 1;</code>
     */
    ACK(1, 1),
    /**
     * <code>GOODBYE = 2;</code>
     */
    GOODBYE(2, 2),
    /**
     * <code>RUN_QUERY = 3;</code>
     *
     * <pre>
     * user to bit
     * </pre>
     */
    RUN_QUERY(3, 3),
    /**
     * <code>CANCEL_QUERY = 4;</code>
     *
     * <pre>
     * user is sending a query cancellation request to the drillbit
     * </pre>
     */
    CANCEL_QUERY(4, 4),
    /**
     * <code>REQUEST_RESULTS = 5;</code>
     */
    REQUEST_RESULTS(5, 5),
    /**
     * <code>RESUME_PAUSED_QUERY = 11;</code>
     *
     * <pre>
     * user is sending a query resume request to the drillbit
     * </pre>
     */
    RESUME_PAUSED_QUERY(6, 11),
    /**
     * <code>GET_QUERY_PLAN_FRAGMENTS = 12;</code>
     *
     * <pre>
     * to get plan fragments from query
     * </pre>
     */
    GET_QUERY_PLAN_FRAGMENTS(7, 12),
    /**
     * <code>GET_CATALOGS = 14;</code>
     *
     * <pre>
     * user is requesting metadata of catalog(s).
     * </pre>
     */
    GET_CATALOGS(8, 14),
    /**
     * <code>GET_SCHEMAS = 15;</code>
     *
     * <pre>
     * user is requesting metadata of schema(s)
     * </pre>
     */
    GET_SCHEMAS(9, 15),
    /**
     * <code>GET_TABLES = 16;</code>
     *
     * <pre>
     * user is requesting metadata of table(s)
     * </pre>
     */
    GET_TABLES(10, 16),
    /**
     * <code>GET_COLUMNS = 17;</code>
     *
     * <pre>
     * user is requesting metadata of column(s)
     * </pre>
     */
    GET_COLUMNS(11, 17),
    /**
     * <code>CREATE_PREPARED_STATEMENT = 22;</code>
     *
     * <pre>
     * user is sending a request to create prepared statement
     * </pre>
     */
    CREATE_PREPARED_STATEMENT(12, 22),
    /**
     * <code>GET_SERVER_META = 8;</code>
     *
     * <pre>
     * user is sending a request to receive server metadata
     * </pre>
     */
    GET_SERVER_META(13, 8),
    /**
     * <code>QUERY_DATA = 6;</code>
     *
     * <pre>
     * bit to user
     * </pre>
     */
    QUERY_DATA(14, 6),
    /**
     * <code>QUERY_HANDLE = 7;</code>
     */
    QUERY_HANDLE(15, 7),
    /**
     * <code>QUERY_PLAN_FRAGMENTS = 13;</code>
     *
     * <pre>
     * return plan fragments
     * </pre>
     */
    QUERY_PLAN_FRAGMENTS(16, 13),
    /**
     * <code>CATALOGS = 18;</code>
     *
     * <pre>
     * return catalogs metadata in response to GET_CATALOGS
     * </pre>
     */
    CATALOGS(17, 18),
    /**
     * <code>SCHEMAS = 19;</code>
     *
     * <pre>
     * return schema metadata in response to GET_SCHEMAS
     * </pre>
     */
    SCHEMAS(18, 19),
    /**
     * <code>TABLES = 20;</code>
     *
     * <pre>
     * return table metadata in response to GET_TABLES
     * </pre>
     */
    TABLES(19, 20),
    /**
     * <code>COLUMNS = 21;</code>
     *
     * <pre>
     * return column metadata in response to GET_COLUMNS
     * </pre>
     */
    COLUMNS(20, 21),
    /**
     * <code>PREPARED_STATEMENT = 23;</code>
     *
     * <pre>
     * return preparated statement in response to CREATE_PREPARED_STATEMENT
     * </pre>
     */
    PREPARED_STATEMENT(21, 23),
    /**
     * <code>SERVER_META = 9;</code>
     *
     * <pre>
     * return server infos in respose to GET_SERVER_META
     * </pre>
     */
    SERVER_META(22, 9),
    /**
     * <code>QUERY_RESULT = 10;</code>
     *
     * <pre>
     * drillbit is reporting a query status change, most likely a terminal message, to the user
     * </pre>
     */
    QUERY_RESULT(23, 10),
    /**
     * <code>SASL_MESSAGE = 24;</code>
     *
     * <pre>
     * user to bit and bit to user
     * </pre>
     */
    SASL_MESSAGE(24, 24),
    ;

    /**
     * <code>HANDSHAKE = 0;</code>
     */
    public static final int HANDSHAKE_VALUE = 0;
    /**
     * <code>ACK = 1;</code>
     */
    public static final int ACK_VALUE = 1;
    /**
     * <code>GOODBYE = 2;</code>
     */
    public static final int GOODBYE_VALUE = 2;
    /**
     * <code>RUN_QUERY = 3;</code>
     *
     * <pre>
     * user to bit
     * </pre>
     */
    public static final int RUN_QUERY_VALUE = 3;
    /**
     * <code>CANCEL_QUERY = 4;</code>
     *
     * <pre>
     * user is sending a query cancellation request to the drillbit
     * </pre>
     */
    public static final int CANCEL_QUERY_VALUE = 4;
    /**
     * <code>REQUEST_RESULTS = 5;</code>
     */
    public static final int REQUEST_RESULTS_VALUE = 5;
    /**
     * <code>RESUME_PAUSED_QUERY = 11;</code>
     *
     * <pre>
     * user is sending a query resume request to the drillbit
     * </pre>
     */
    public static final int RESUME_PAUSED_QUERY_VALUE = 11;
    /**
     * <code>GET_QUERY_PLAN_FRAGMENTS = 12;</code>
     *
     * <pre>
     * to get plan fragments from query
     * </pre>
     */
    public static final int GET_QUERY_PLAN_FRAGMENTS_VALUE = 12;
    /**
     * <code>GET_CATALOGS = 14;</code>
     *
     * <pre>
     * user is requesting metadata of catalog(s).
     * </pre>
     */
    public static final int GET_CATALOGS_VALUE = 14;
    /**
     * <code>GET_SCHEMAS = 15;</code>
     *
     * <pre>
     * user is requesting metadata of schema(s)
     * </pre>
     */
    public static final int GET_SCHEMAS_VALUE = 15;
    /**
     * <code>GET_TABLES = 16;</code>
     *
     * <pre>
     * user is requesting metadata of table(s)
     * </pre>
     */
    public static final int GET_TABLES_VALUE = 16;
    /**
     * <code>GET_COLUMNS = 17;</code>
     *
     * <pre>
     * user is requesting metadata of column(s)
     * </pre>
     */
    public static final int GET_COLUMNS_VALUE = 17;
    /**
     * <code>CREATE_PREPARED_STATEMENT = 22;</code>
     *
     * <pre>
     * user is sending a request to create prepared statement
     * </pre>
     */
    public static final int CREATE_PREPARED_STATEMENT_VALUE = 22;
    /**
     * <code>GET_SERVER_META = 8;</code>
     *
     * <pre>
     * user is sending a request to receive server metadata
     * </pre>
     */
    public static final int GET_SERVER_META_VALUE = 8;
    /**
     * <code>QUERY_DATA = 6;</code>
     *
     * <pre>
     * bit to user
     * </pre>
     */
    public static final int QUERY_DATA_VALUE = 6;
    /**
     * <code>QUERY_HANDLE = 7;</code>
     */
    public static final int QUERY_HANDLE_VALUE = 7;
    /**
     * <code>QUERY_PLAN_FRAGMENTS = 13;</code>
     *
     * <pre>
     * return plan fragments
     * </pre>
     */
    public static final int QUERY_PLAN_FRAGMENTS_VALUE = 13;
    /**
     * <code>CATALOGS = 18;</code>
     *
     * <pre>
     * return catalogs metadata in response to GET_CATALOGS
     * </pre>
     */
    public static final int CATALOGS_VALUE = 18;
    /**
     * <code>SCHEMAS = 19;</code>
     *
     * <pre>
     * return schema metadata in response to GET_SCHEMAS
     * </pre>
     */
    public static final int SCHEMAS_VALUE = 19;
    /**
     * <code>TABLES = 20;</code>
     *
     * <pre>
     * return table metadata in response to GET_TABLES
     * </pre>
     */
    public static final int TABLES_VALUE = 20;
    /**
     * <code>COLUMNS = 21;</code>
     *
     * <pre>
     * return column metadata in response to GET_COLUMNS
     * </pre>
     */
    public static final int COLUMNS_VALUE = 21;
    /**
     * <code>PREPARED_STATEMENT = 23;</code>
     *
     * <pre>
     * return preparated statement in response to CREATE_PREPARED_STATEMENT
     * </pre>
     */
    public static final int PREPARED_STATEMENT_VALUE = 23;
    /**
     * <code>SERVER_META = 9;</code>
     *
     * <pre>
     * return server infos in respose to GET_SERVER_META
     * </pre>
     */
    public static final int SERVER_META_VALUE = 9;
    /**
     * <code>QUERY_RESULT = 10;</code>
     *
     * <pre>
     * drillbit is reporting a query status change, most likely a terminal message, to the user
     * </pre>
     */
    public static final int QUERY_RESULT_VALUE = 10;
    /**
     * <code>SASL_MESSAGE = 24;</code>
     *
     * <pre>
     * user to bit and bit to user
     * </pre>
     */
    public static final int SASL_MESSAGE_VALUE = 24;


    public final int getNumber() { return value; }

    public static RpcType valueOf(int value) {
      switch (value) {
        case 0: return HANDSHAKE;
        case 1: return ACK;
        case 2: return GOODBYE;
        case 3: return RUN_QUERY;
        case 4: return CANCEL_QUERY;
        case 5: return REQUEST_RESULTS;
        case 11: return RESUME_PAUSED_QUERY;
        case 12: return GET_QUERY_PLAN_FRAGMENTS;
        case 14: return GET_CATALOGS;
        case 15: return GET_SCHEMAS;
        case 16: return GET_TABLES;
        case 17: return GET_COLUMNS;
        case 22: return CREATE_PREPARED_STATEMENT;
        case 8: return GET_SERVER_META;
        case 6: return QUERY_DATA;
        case 7: return QUERY_HANDLE;
        case 13: return QUERY_PLAN_FRAGMENTS;
        case 18: return CATALOGS;
        case 19: return SCHEMAS;
        case 20: return TABLES;
        case 21: return COLUMNS;
        case 23: return PREPARED_STATEMENT;
        case 9: return SERVER_META;
        case 10: return QUERY_RESULT;
        case 24: return SASL_MESSAGE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RpcType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<RpcType>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<RpcType>() {
            public RpcType findValueByNumber(int number) {
              return RpcType.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(0);
    }

    private static final RpcType[] VALUES = values();

    public static RpcType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private RpcType(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.RpcType)
  }

  /**
   * Protobuf enum {@code exec.user.SaslSupport}
   */
  public enum SaslSupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>UNKNOWN_SASL_SUPPORT = 0;</code>
     */
    UNKNOWN_SASL_SUPPORT(0, 0),
    /**
     * <code>SASL_AUTH = 1;</code>
     */
    SASL_AUTH(1, 1),
    /**
     * <code>SASL_PRIVACY = 2;</code>
     */
    SASL_PRIVACY(2, 2),
    ;

    /**
     * <code>UNKNOWN_SASL_SUPPORT = 0;</code>
     */
    public static final int UNKNOWN_SASL_SUPPORT_VALUE = 0;
    /**
     * <code>SASL_AUTH = 1;</code>
     */
    public static final int SASL_AUTH_VALUE = 1;
    /**
     * <code>SASL_PRIVACY = 2;</code>
     */
    public static final int SASL_PRIVACY_VALUE = 2;


    public final int getNumber() { return value; }

    public static SaslSupport valueOf(int value) {
      switch (value) {
        case 0: return UNKNOWN_SASL_SUPPORT;
        case 1: return SASL_AUTH;
        case 2: return SASL_PRIVACY;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SaslSupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<SaslSupport>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<SaslSupport>() {
            public SaslSupport findValueByNumber(int number) {
              return SaslSupport.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(1);
    }

    private static final SaslSupport[] VALUES = values();

    public static SaslSupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private SaslSupport(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.SaslSupport)
  }

  /**
   * Protobuf enum {@code exec.user.QueryResultsMode}
   */
  public enum QueryResultsMode
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>STREAM_FULL = 1;</code>
     *
     * <pre>
     * Server will inform the client regularly on the status of the query. Once the query is completed, service will inform the client as each query chunk is made available.
     * </pre>
     */
    STREAM_FULL(0, 1),
    ;

    /**
     * <code>STREAM_FULL = 1;</code>
     *
     * <pre>
     * Server will inform the client regularly on the status of the query. Once the query is completed, service will inform the client as each query chunk is made available.
     * </pre>
     */
    public static final int STREAM_FULL_VALUE = 1;


    public final int getNumber() { return value; }

    public static QueryResultsMode valueOf(int value) {
      switch (value) {
        case 1: return STREAM_FULL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<QueryResultsMode>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<QueryResultsMode>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<QueryResultsMode>() {
            public QueryResultsMode findValueByNumber(int number) {
              return QueryResultsMode.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(2);
    }

    private static final QueryResultsMode[] VALUES = values();

    public static QueryResultsMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private QueryResultsMode(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.QueryResultsMode)
  }

  /**
   * Protobuf enum {@code exec.user.HandshakeStatus}
   */
  public enum HandshakeStatus
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>SUCCESS = 1;</code>
     *
     * <pre>
     * Handshake is successful (including authentication if any)
     * </pre>
     */
    SUCCESS(0, 1),
    /**
     * <code>RPC_VERSION_MISMATCH = 2;</code>
     *
     * <pre>
     * Client and Server RPC versions are different
     * </pre>
     */
    RPC_VERSION_MISMATCH(1, 2),
    /**
     * <code>AUTH_FAILED = 3;</code>
     *
     * <pre>
     * User authentication failed
     * </pre>
     */
    AUTH_FAILED(2, 3),
    /**
     * <code>UNKNOWN_FAILURE = 4;</code>
     *
     * <pre>
     * Unknown failure, refer to the error message for more details
     * </pre>
     */
    UNKNOWN_FAILURE(3, 4),
    /**
     * <code>AUTH_REQUIRED = 5;</code>
     *
     * <pre>
     * User authentication required
     * </pre>
     */
    AUTH_REQUIRED(4, 5),
    ;

    /**
     * <code>SUCCESS = 1;</code>
     *
     * <pre>
     * Handshake is successful (including authentication if any)
     * </pre>
     */
    public static final int SUCCESS_VALUE = 1;
    /**
     * <code>RPC_VERSION_MISMATCH = 2;</code>
     *
     * <pre>
     * Client and Server RPC versions are different
     * </pre>
     */
    public static final int RPC_VERSION_MISMATCH_VALUE = 2;
    /**
     * <code>AUTH_FAILED = 3;</code>
     *
     * <pre>
     * User authentication failed
     * </pre>
     */
    public static final int AUTH_FAILED_VALUE = 3;
    /**
     * <code>UNKNOWN_FAILURE = 4;</code>
     *
     * <pre>
     * Unknown failure, refer to the error message for more details
     * </pre>
     */
    public static final int UNKNOWN_FAILURE_VALUE = 4;
    /**
     * <code>AUTH_REQUIRED = 5;</code>
     *
     * <pre>
     * User authentication required
     * </pre>
     */
    public static final int AUTH_REQUIRED_VALUE = 5;


    public final int getNumber() { return value; }

    public static HandshakeStatus valueOf(int value) {
      switch (value) {
        case 1: return SUCCESS;
        case 2: return RPC_VERSION_MISMATCH;
        case 3: return AUTH_FAILED;
        case 4: return UNKNOWN_FAILURE;
        case 5: return AUTH_REQUIRED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<HandshakeStatus>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<HandshakeStatus>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<HandshakeStatus>() {
            public HandshakeStatus findValueByNumber(int number) {
              return HandshakeStatus.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(3);
    }

    private static final HandshakeStatus[] VALUES = values();

    public static HandshakeStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private HandshakeStatus(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.HandshakeStatus)
  }

  /**
   * Protobuf enum {@code exec.user.RequestStatus}
   *
   * <pre>
   *
   * Enum indicating the request status.
   * </pre>
   */
  public enum RequestStatus
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>UNKNOWN_STATUS = 0;</code>
     */
    UNKNOWN_STATUS(0, 0),
    /**
     * <code>OK = 1;</code>
     */
    OK(1, 1),
    /**
     * <code>FAILED = 2;</code>
     */
    FAILED(2, 2),
    /**
     * <code>TIMEOUT = 3;</code>
     *
     * <pre>
     **
     * Request timed out. Futher attempts can change any API specific parameters and retry or just retry the request.
     * </pre>
     */
    TIMEOUT(3, 3),
    ;

    /**
     * <code>UNKNOWN_STATUS = 0;</code>
     */
    public static final int UNKNOWN_STATUS_VALUE = 0;
    /**
     * <code>OK = 1;</code>
     */
    public static final int OK_VALUE = 1;
    /**
     * <code>FAILED = 2;</code>
     */
    public static final int FAILED_VALUE = 2;
    /**
     * <code>TIMEOUT = 3;</code>
     *
     * <pre>
     **
     * Request timed out. Futher attempts can change any API specific parameters and retry or just retry the request.
     * </pre>
     */
    public static final int TIMEOUT_VALUE = 3;


    public final int getNumber() { return value; }

    public static RequestStatus valueOf(int value) {
      switch (value) {
        case 0: return UNKNOWN_STATUS;
        case 1: return OK;
        case 2: return FAILED;
        case 3: return TIMEOUT;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RequestStatus>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<RequestStatus>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<RequestStatus>() {
            public RequestStatus findValueByNumber(int number) {
              return RequestStatus.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(4);
    }

    private static final RequestStatus[] VALUES = values();

    public static RequestStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private RequestStatus(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.RequestStatus)
  }

  /**
   * Protobuf enum {@code exec.user.ColumnSearchability}
   *
   * <pre>
   *
   * How a column can be used in WHERE clause
   * </pre>
   */
  public enum ColumnSearchability
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>UNKNOWN_SEARCHABILITY = 0;</code>
     */
    UNKNOWN_SEARCHABILITY(0, 0),
    /**
     * <code>NONE = 1;</code>
     *
     * <pre>
     * can't be used in WHERE clause
     * </pre>
     */
    NONE(1, 1),
    /**
     * <code>CHAR = 2;</code>
     *
     * <pre>
     * can be used in WHERE clause but only with LIKE predicate
     * </pre>
     */
    CHAR(2, 2),
    /**
     * <code>NUMBER = 3;</code>
     *
     * <pre>
     * can be used in a WHERE clause with all the comparison operators except LIKE
     * </pre>
     */
    NUMBER(3, 3),
    /**
     * <code>ALL = 4;</code>
     *
     * <pre>
     * can be used in a WHERE clause with all the comparison operators
     * </pre>
     */
    ALL(4, 4),
    ;

    /**
     * <code>UNKNOWN_SEARCHABILITY = 0;</code>
     */
    public static final int UNKNOWN_SEARCHABILITY_VALUE = 0;
    /**
     * <code>NONE = 1;</code>
     *
     * <pre>
     * can't be used in WHERE clause
     * </pre>
     */
    public static final int NONE_VALUE = 1;
    /**
     * <code>CHAR = 2;</code>
     *
     * <pre>
     * can be used in WHERE clause but only with LIKE predicate
     * </pre>
     */
    public static final int CHAR_VALUE = 2;
    /**
     * <code>NUMBER = 3;</code>
     *
     * <pre>
     * can be used in a WHERE clause with all the comparison operators except LIKE
     * </pre>
     */
    public static final int NUMBER_VALUE = 3;
    /**
     * <code>ALL = 4;</code>
     *
     * <pre>
     * can be used in a WHERE clause with all the comparison operators
     * </pre>
     */
    public static final int ALL_VALUE = 4;


    public final int getNumber() { return value; }

    public static ColumnSearchability valueOf(int value) {
      switch (value) {
        case 0: return UNKNOWN_SEARCHABILITY;
        case 1: return NONE;
        case 2: return CHAR;
        case 3: return NUMBER;
        case 4: return ALL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ColumnSearchability>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<ColumnSearchability>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ColumnSearchability>() {
            public ColumnSearchability findValueByNumber(int number) {
              return ColumnSearchability.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(5);
    }

    private static final ColumnSearchability[] VALUES = values();

    public static ColumnSearchability valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private ColumnSearchability(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.ColumnSearchability)
  }

  /**
   * Protobuf enum {@code exec.user.ColumnUpdatability}
   *
   * <pre>
   *
   * Whether a column can be updatable.
   * </pre>
   */
  public enum ColumnUpdatability
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>UNKNOWN_UPDATABILITY = 0;</code>
     */
    UNKNOWN_UPDATABILITY(0, 0),
    /**
     * <code>READ_ONLY = 1;</code>
     */
    READ_ONLY(1, 1),
    /**
     * <code>WRITABLE = 2;</code>
     */
    WRITABLE(2, 2),
    ;

    /**
     * <code>UNKNOWN_UPDATABILITY = 0;</code>
     */
    public static final int UNKNOWN_UPDATABILITY_VALUE = 0;
    /**
     * <code>READ_ONLY = 1;</code>
     */
    public static final int READ_ONLY_VALUE = 1;
    /**
     * <code>WRITABLE = 2;</code>
     */
    public static final int WRITABLE_VALUE = 2;


    public final int getNumber() { return value; }

    public static ColumnUpdatability valueOf(int value) {
      switch (value) {
        case 0: return UNKNOWN_UPDATABILITY;
        case 1: return READ_ONLY;
        case 2: return WRITABLE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ColumnUpdatability>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<ColumnUpdatability>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ColumnUpdatability>() {
            public ColumnUpdatability findValueByNumber(int number) {
              return ColumnUpdatability.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(6);
    }

    private static final ColumnUpdatability[] VALUES = values();

    public static ColumnUpdatability valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private ColumnUpdatability(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.ColumnUpdatability)
  }

  /**
   * Protobuf enum {@code exec.user.CollateSupport}
   */
  public enum CollateSupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>CS_UNKNOWN = 0;</code>
     *
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     */
    CS_UNKNOWN(0, 0),
    /**
     * <code>CS_GROUP_BY = 1;</code>
     *
     * <pre>
     * COLLATE clause can be added after each grouping column
     * </pre>
     */
    CS_GROUP_BY(1, 1),
    ;

    /**
     * <code>CS_UNKNOWN = 0;</code>
     *
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     */
    public static final int CS_UNKNOWN_VALUE = 0;
    /**
     * <code>CS_GROUP_BY = 1;</code>
     *
     * <pre>
     * COLLATE clause can be added after each grouping column
     * </pre>
     */
    public static final int CS_GROUP_BY_VALUE = 1;


    public final int getNumber() { return value; }

    public static CollateSupport valueOf(int value) {
      switch (value) {
        case 0: return CS_UNKNOWN;
        case 1: return CS_GROUP_BY;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CollateSupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<CollateSupport>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<CollateSupport>() {
            public CollateSupport findValueByNumber(int number) {
              return CollateSupport.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(7);
    }

    private static final CollateSupport[] VALUES = values();

    public static CollateSupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private CollateSupport(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.CollateSupport)
  }

  /**
   * Protobuf enum {@code exec.user.CorrelationNamesSupport}
   */
  public enum CorrelationNamesSupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>CN_NONE = 1;</code>
     *
     * <pre>
     * Correlation names are not supported
     * </pre>
     */
    CN_NONE(0, 1),
    /**
     * <code>CN_DIFFERENT_NAMES = 2;</code>
     *
     * <pre>
     * Correlation names are supported, but names have to
     * </pre>
     */
    CN_DIFFERENT_NAMES(1, 2),
    /**
     * <code>CN_ANY = 3;</code>
     *
     * <pre>
     * be different from the tables they represent
     * </pre>
     */
    CN_ANY(2, 3),
    ;

    /**
     * <code>CN_NONE = 1;</code>
     *
     * <pre>
     * Correlation names are not supported
     * </pre>
     */
    public static final int CN_NONE_VALUE = 1;
    /**
     * <code>CN_DIFFERENT_NAMES = 2;</code>
     *
     * <pre>
     * Correlation names are supported, but names have to
     * </pre>
     */
    public static final int CN_DIFFERENT_NAMES_VALUE = 2;
    /**
     * <code>CN_ANY = 3;</code>
     *
     * <pre>
     * be different from the tables they represent
     * </pre>
     */
    public static final int CN_ANY_VALUE = 3;


    public final int getNumber() { return value; }

    public static CorrelationNamesSupport valueOf(int value) {
      switch (value) {
        case 1: return CN_NONE;
        case 2: return CN_DIFFERENT_NAMES;
        case 3: return CN_ANY;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CorrelationNamesSupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<CorrelationNamesSupport>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<CorrelationNamesSupport>() {
            public CorrelationNamesSupport findValueByNumber(int number) {
              return CorrelationNamesSupport.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(8);
    }

    private static final CorrelationNamesSupport[] VALUES = values();

    public static CorrelationNamesSupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private CorrelationNamesSupport(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.CorrelationNamesSupport)
  }

  /**
   * Protobuf enum {@code exec.user.DateTimeLiteralsSupport}
   */
  public enum DateTimeLiteralsSupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>DL_UNKNOWN = 0;</code>
     *
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     */
    DL_UNKNOWN(0, 0),
    /**
     * <code>DL_DATE = 1;</code>
     *
     * <pre>
     * DATE literal is supported
     * </pre>
     */
    DL_DATE(1, 1),
    /**
     * <code>DL_TIME = 2;</code>
     *
     * <pre>
     * TIME literal is supported
     * </pre>
     */
    DL_TIME(2, 2),
    /**
     * <code>DL_TIMESTAMP = 3;</code>
     *
     * <pre>
     * TIMESTAMP literal is supported
     * </pre>
     */
    DL_TIMESTAMP(3, 3),
    /**
     * <code>DL_INTERVAL_YEAR = 4;</code>
     *
     * <pre>
     * INTERVAL YEAR literal is supported
     * </pre>
     */
    DL_INTERVAL_YEAR(4, 4),
    /**
     * <code>DL_INTERVAL_MONTH = 5;</code>
     *
     * <pre>
     * INTERVAL MONTH literal is supported
     * </pre>
     */
    DL_INTERVAL_MONTH(5, 5),
    /**
     * <code>DL_INTERVAL_DAY = 6;</code>
     *
     * <pre>
     * INTERVAL DAY literal is supported
     * </pre>
     */
    DL_INTERVAL_DAY(6, 6),
    /**
     * <code>DL_INTERVAL_HOUR = 7;</code>
     *
     * <pre>
     * INTERVAL HOUR literal is supported
     * </pre>
     */
    DL_INTERVAL_HOUR(7, 7),
    /**
     * <code>DL_INTERVAL_MINUTE = 8;</code>
     *
     * <pre>
     * INTERVAL MINUTE literal is supported
     * </pre>
     */
    DL_INTERVAL_MINUTE(8, 8),
    /**
     * <code>DL_INTERVAL_SECOND = 9;</code>
     *
     * <pre>
     * INTERVAL SECOND literal is supported
     * </pre>
     */
    DL_INTERVAL_SECOND(9, 9),
    /**
     * <code>DL_INTERVAL_YEAR_TO_MONTH = 10;</code>
     *
     * <pre>
     * INTERVAL YEAR TO MONTH literal is supported
     * </pre>
     */
    DL_INTERVAL_YEAR_TO_MONTH(10, 10),
    /**
     * <code>DL_INTERVAL_DAY_TO_HOUR = 11;</code>
     *
     * <pre>
     * INTERVAL DAY TO HOUR literal is supported
     * </pre>
     */
    DL_INTERVAL_DAY_TO_HOUR(11, 11),
    /**
     * <code>DL_INTERVAL_DAY_TO_MINUTE = 12;</code>
     *
     * <pre>
     * INTERVAL DAY TO MINUTE literal is supported
     * </pre>
     */
    DL_INTERVAL_DAY_TO_MINUTE(12, 12),
    /**
     * <code>DL_INTERVAL_DAY_TO_SECOND = 13;</code>
     *
     * <pre>
     * INTERVAL DAY TO SECOND literal is supported
     * </pre>
     */
    DL_INTERVAL_DAY_TO_SECOND(13, 13),
    /**
     * <code>DL_INTERVAL_HOUR_TO_MINUTE = 14;</code>
     *
     * <pre>
     * INTERVAL HOUR TO MINUTE literal is supported
     * </pre>
     */
    DL_INTERVAL_HOUR_TO_MINUTE(14, 14),
    /**
     * <code>DL_INTERVAL_HOUR_TO_SECOND = 15;</code>
     *
     * <pre>
     * INTERVAL HOUR TO SECOND literal is supported
     * </pre>
     */
    DL_INTERVAL_HOUR_TO_SECOND(15, 15),
    /**
     * <code>DL_INTERVAL_MINUTE_TO_SECOND = 16;</code>
     *
     * <pre>
     * INTERVAL MINUTE TO SECOND literal is supported
     * </pre>
     */
    DL_INTERVAL_MINUTE_TO_SECOND(16, 16),
    ;

    /**
     * <code>DL_UNKNOWN = 0;</code>
     *
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     */
    public static final int DL_UNKNOWN_VALUE = 0;
    /**
     * <code>DL_DATE = 1;</code>
     *
     * <pre>
     * DATE literal is supported
     * </pre>
     */
    public static final int DL_DATE_VALUE = 1;
    /**
     * <code>DL_TIME = 2;</code>
     *
     * <pre>
     * TIME literal is supported
     * </pre>
     */
    public static final int DL_TIME_VALUE = 2;
    /**
     * <code>DL_TIMESTAMP = 3;</code>
     *
     * <pre>
     * TIMESTAMP literal is supported
     * </pre>
     */
    public static final int DL_TIMESTAMP_VALUE = 3;
    /**
     * <code>DL_INTERVAL_YEAR = 4;</code>
     *
     * <pre>
     * INTERVAL YEAR literal is supported
     * </pre>
     */
    public static final int DL_INTERVAL_YEAR_VALUE = 4;
    /**
     * <code>DL_INTERVAL_MONTH = 5;</code>
     *
     * <pre>
     * INTERVAL MONTH literal is supported
     * </pre>
     */
    public static final int DL_INTERVAL_MONTH_VALUE = 5;
    /**
     * <code>DL_INTERVAL_DAY = 6;</code>
     *
     * <pre>
     * INTERVAL DAY literal is supported
     * </pre>
     */
    public static final int DL_INTERVAL_DAY_VALUE = 6;
    /**
     * <code>DL_INTERVAL_HOUR = 7;</code>
     *
     * <pre>
     * INTERVAL HOUR literal is supported
     * </pre>
     */
    public static final int DL_INTERVAL_HOUR_VALUE = 7;
    /**
     * <code>DL_INTERVAL_MINUTE = 8;</code>
     *
     * <pre>
     * INTERVAL MINUTE literal is supported
     * </pre>
     */
    public static final int DL_INTERVAL_MINUTE_VALUE = 8;
    /**
     * <code>DL_INTERVAL_SECOND = 9;</code>
     *
     * <pre>
     * INTERVAL SECOND literal is supported
     * </pre>
     */
    public static final int DL_INTERVAL_SECOND_VALUE = 9;
    /**
     * <code>DL_INTERVAL_YEAR_TO_MONTH = 10;</code>
     *
     * <pre>
     * INTERVAL YEAR TO MONTH literal is supported
     * </pre>
     */
    public static final int DL_INTERVAL_YEAR_TO_MONTH_VALUE = 10;
    /**
     * <code>DL_INTERVAL_DAY_TO_HOUR = 11;</code>
     *
     * <pre>
     * INTERVAL DAY TO HOUR literal is supported
     * </pre>
     */
    public static final int DL_INTERVAL_DAY_TO_HOUR_VALUE = 11;
    /**
     * <code>DL_INTERVAL_DAY_TO_MINUTE = 12;</code>
     *
     * <pre>
     * INTERVAL DAY TO MINUTE literal is supported
     * </pre>
     */
    public static final int DL_INTERVAL_DAY_TO_MINUTE_VALUE = 12;
    /**
     * <code>DL_INTERVAL_DAY_TO_SECOND = 13;</code>
     *
     * <pre>
     * INTERVAL DAY TO SECOND literal is supported
     * </pre>
     */
    public static final int DL_INTERVAL_DAY_TO_SECOND_VALUE = 13;
    /**
     * <code>DL_INTERVAL_HOUR_TO_MINUTE = 14;</code>
     *
     * <pre>
     * INTERVAL HOUR TO MINUTE literal is supported
     * </pre>
     */
    public static final int DL_INTERVAL_HOUR_TO_MINUTE_VALUE = 14;
    /**
     * <code>DL_INTERVAL_HOUR_TO_SECOND = 15;</code>
     *
     * <pre>
     * INTERVAL HOUR TO SECOND literal is supported
     * </pre>
     */
    public static final int DL_INTERVAL_HOUR_TO_SECOND_VALUE = 15;
    /**
     * <code>DL_INTERVAL_MINUTE_TO_SECOND = 16;</code>
     *
     * <pre>
     * INTERVAL MINUTE TO SECOND literal is supported
     * </pre>
     */
    public static final int DL_INTERVAL_MINUTE_TO_SECOND_VALUE = 16;


    public final int getNumber() { return value; }

    public static DateTimeLiteralsSupport valueOf(int value) {
      switch (value) {
        case 0: return DL_UNKNOWN;
        case 1: return DL_DATE;
        case 2: return DL_TIME;
        case 3: return DL_TIMESTAMP;
        case 4: return DL_INTERVAL_YEAR;
        case 5: return DL_INTERVAL_MONTH;
        case 6: return DL_INTERVAL_DAY;
        case 7: return DL_INTERVAL_HOUR;
        case 8: return DL_INTERVAL_MINUTE;
        case 9: return DL_INTERVAL_SECOND;
        case 10: return DL_INTERVAL_YEAR_TO_MONTH;
        case 11: return DL_INTERVAL_DAY_TO_HOUR;
        case 12: return DL_INTERVAL_DAY_TO_MINUTE;
        case 13: return DL_INTERVAL_DAY_TO_SECOND;
        case 14: return DL_INTERVAL_HOUR_TO_MINUTE;
        case 15: return DL_INTERVAL_HOUR_TO_SECOND;
        case 16: return DL_INTERVAL_MINUTE_TO_SECOND;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DateTimeLiteralsSupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<DateTimeLiteralsSupport>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<DateTimeLiteralsSupport>() {
            public DateTimeLiteralsSupport findValueByNumber(int number) {
              return DateTimeLiteralsSupport.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(9);
    }

    private static final DateTimeLiteralsSupport[] VALUES = values();

    public static DateTimeLiteralsSupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private DateTimeLiteralsSupport(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.DateTimeLiteralsSupport)
  }

  /**
   * Protobuf enum {@code exec.user.GroupBySupport}
   */
  public enum GroupBySupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>GB_NONE = 1;</code>
     *
     * <pre>
     * Group by is not supported
     * </pre>
     */
    GB_NONE(0, 1),
    /**
     * <code>GB_SELECT_ONLY = 2;</code>
     *
     * <pre>
     * Group by supported with non aggregated columns in select
     * </pre>
     */
    GB_SELECT_ONLY(1, 2),
    /**
     * <code>GB_BEYOND_SELECT = 3;</code>
     *
     * <pre>
     * Group by supported with columns absent from the select list
     *if all the non-aggregated colums from the select list are also added 
     * </pre>
     */
    GB_BEYOND_SELECT(2, 3),
    /**
     * <code>GB_UNRELATED = 4;</code>
     *
     * <pre>
     * Group by supported with columns absent from the select list
     * </pre>
     */
    GB_UNRELATED(3, 4),
    ;

    /**
     * <code>GB_NONE = 1;</code>
     *
     * <pre>
     * Group by is not supported
     * </pre>
     */
    public static final int GB_NONE_VALUE = 1;
    /**
     * <code>GB_SELECT_ONLY = 2;</code>
     *
     * <pre>
     * Group by supported with non aggregated columns in select
     * </pre>
     */
    public static final int GB_SELECT_ONLY_VALUE = 2;
    /**
     * <code>GB_BEYOND_SELECT = 3;</code>
     *
     * <pre>
     * Group by supported with columns absent from the select list
     *if all the non-aggregated colums from the select list are also added 
     * </pre>
     */
    public static final int GB_BEYOND_SELECT_VALUE = 3;
    /**
     * <code>GB_UNRELATED = 4;</code>
     *
     * <pre>
     * Group by supported with columns absent from the select list
     * </pre>
     */
    public static final int GB_UNRELATED_VALUE = 4;


    public final int getNumber() { return value; }

    public static GroupBySupport valueOf(int value) {
      switch (value) {
        case 1: return GB_NONE;
        case 2: return GB_SELECT_ONLY;
        case 3: return GB_BEYOND_SELECT;
        case 4: return GB_UNRELATED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<GroupBySupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<GroupBySupport>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<GroupBySupport>() {
            public GroupBySupport findValueByNumber(int number) {
              return GroupBySupport.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(10);
    }

    private static final GroupBySupport[] VALUES = values();

    public static GroupBySupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private GroupBySupport(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.GroupBySupport)
  }

  /**
   * Protobuf enum {@code exec.user.IdentifierCasing}
   */
  public enum IdentifierCasing
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>IC_UNKNOWN = 0;</code>
     *
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     */
    IC_UNKNOWN(0, 0),
    /**
     * <code>IC_STORES_LOWER = 1;</code>
     *
     * <pre>
     * Mixed case identifier is treated as case insensitive
     *and stored in lower case 
     * </pre>
     */
    IC_STORES_LOWER(1, 1),
    /**
     * <code>IC_STORES_MIXED = 2;</code>
     *
     * <pre>
     * Mixed case identifier is treated as case insensitive
     *and stored in mixed case 
     * </pre>
     */
    IC_STORES_MIXED(2, 2),
    /**
     * <code>IC_STORES_UPPER = 3;</code>
     *
     * <pre>
     * Mixed case identifier is treated as case insensitive
     *and stored in upper case 
     * </pre>
     */
    IC_STORES_UPPER(3, 3),
    /**
     * <code>IC_SUPPORTS_MIXED = 4;</code>
     *
     * <pre>
     * Mixed case identifier is treated as case sensitive
     *and stored in mixed case 
     * </pre>
     */
    IC_SUPPORTS_MIXED(4, 4),
    ;

    /**
     * <code>IC_UNKNOWN = 0;</code>
     *
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     */
    public static final int IC_UNKNOWN_VALUE = 0;
    /**
     * <code>IC_STORES_LOWER = 1;</code>
     *
     * <pre>
     * Mixed case identifier is treated as case insensitive
     *and stored in lower case 
     * </pre>
     */
    public static final int IC_STORES_LOWER_VALUE = 1;
    /**
     * <code>IC_STORES_MIXED = 2;</code>
     *
     * <pre>
     * Mixed case identifier is treated as case insensitive
     *and stored in mixed case 
     * </pre>
     */
    public static final int IC_STORES_MIXED_VALUE = 2;
    /**
     * <code>IC_STORES_UPPER = 3;</code>
     *
     * <pre>
     * Mixed case identifier is treated as case insensitive
     *and stored in upper case 
     * </pre>
     */
    public static final int IC_STORES_UPPER_VALUE = 3;
    /**
     * <code>IC_SUPPORTS_MIXED = 4;</code>
     *
     * <pre>
     * Mixed case identifier is treated as case sensitive
     *and stored in mixed case 
     * </pre>
     */
    public static final int IC_SUPPORTS_MIXED_VALUE = 4;


    public final int getNumber() { return value; }

    public static IdentifierCasing valueOf(int value) {
      switch (value) {
        case 0: return IC_UNKNOWN;
        case 1: return IC_STORES_LOWER;
        case 2: return IC_STORES_MIXED;
        case 3: return IC_STORES_UPPER;
        case 4: return IC_SUPPORTS_MIXED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IdentifierCasing>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<IdentifierCasing>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<IdentifierCasing>() {
            public IdentifierCasing findValueByNumber(int number) {
              return IdentifierCasing.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(11);
    }

    private static final IdentifierCasing[] VALUES = values();

    public static IdentifierCasing valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private IdentifierCasing(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.IdentifierCasing)
  }

  /**
   * Protobuf enum {@code exec.user.NullCollation}
   */
  public enum NullCollation
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>NC_UNKNOWN = 0;</code>
     *
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     */
    NC_UNKNOWN(0, 0),
    /**
     * <code>NC_AT_START = 1;</code>
     *
     * <pre>
     * NULL values are sorted at the start regardless of the order
     * </pre>
     */
    NC_AT_START(1, 1),
    /**
     * <code>NC_AT_END = 2;</code>
     *
     * <pre>
     * NULL values are sorted at the end regardless of the order
     * </pre>
     */
    NC_AT_END(2, 2),
    /**
     * <code>NC_HIGH = 3;</code>
     *
     * <pre>
     * NULL is the highest value
     * </pre>
     */
    NC_HIGH(3, 3),
    /**
     * <code>NC_LOW = 4;</code>
     *
     * <pre>
     * NULL is the lowest value
     * </pre>
     */
    NC_LOW(4, 4),
    ;

    /**
     * <code>NC_UNKNOWN = 0;</code>
     *
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     */
    public static final int NC_UNKNOWN_VALUE = 0;
    /**
     * <code>NC_AT_START = 1;</code>
     *
     * <pre>
     * NULL values are sorted at the start regardless of the order
     * </pre>
     */
    public static final int NC_AT_START_VALUE = 1;
    /**
     * <code>NC_AT_END = 2;</code>
     *
     * <pre>
     * NULL values are sorted at the end regardless of the order
     * </pre>
     */
    public static final int NC_AT_END_VALUE = 2;
    /**
     * <code>NC_HIGH = 3;</code>
     *
     * <pre>
     * NULL is the highest value
     * </pre>
     */
    public static final int NC_HIGH_VALUE = 3;
    /**
     * <code>NC_LOW = 4;</code>
     *
     * <pre>
     * NULL is the lowest value
     * </pre>
     */
    public static final int NC_LOW_VALUE = 4;


    public final int getNumber() { return value; }

    public static NullCollation valueOf(int value) {
      switch (value) {
        case 0: return NC_UNKNOWN;
        case 1: return NC_AT_START;
        case 2: return NC_AT_END;
        case 3: return NC_HIGH;
        case 4: return NC_LOW;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NullCollation>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<NullCollation>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<NullCollation>() {
            public NullCollation findValueByNumber(int number) {
              return NullCollation.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(12);
    }

    private static final NullCollation[] VALUES = values();

    public static NullCollation valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private NullCollation(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.NullCollation)
  }

  /**
   * Protobuf enum {@code exec.user.OrderBySupport}
   */
  public enum OrderBySupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>OB_UNKNOWN = 0;</code>
     *
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     */
    OB_UNKNOWN(0, 0),
    /**
     * <code>OB_UNRELATED = 1;</code>
     *
     * <pre>
     * ORDER BY supported with columns not in SELECT list
     * </pre>
     */
    OB_UNRELATED(1, 1),
    /**
     * <code>OB_EXPRESSION = 2;</code>
     *
     * <pre>
     * ORDER BY with expressions is supported
     * </pre>
     */
    OB_EXPRESSION(2, 2),
    ;

    /**
     * <code>OB_UNKNOWN = 0;</code>
     *
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     */
    public static final int OB_UNKNOWN_VALUE = 0;
    /**
     * <code>OB_UNRELATED = 1;</code>
     *
     * <pre>
     * ORDER BY supported with columns not in SELECT list
     * </pre>
     */
    public static final int OB_UNRELATED_VALUE = 1;
    /**
     * <code>OB_EXPRESSION = 2;</code>
     *
     * <pre>
     * ORDER BY with expressions is supported
     * </pre>
     */
    public static final int OB_EXPRESSION_VALUE = 2;


    public final int getNumber() { return value; }

    public static OrderBySupport valueOf(int value) {
      switch (value) {
        case 0: return OB_UNKNOWN;
        case 1: return OB_UNRELATED;
        case 2: return OB_EXPRESSION;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<OrderBySupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<OrderBySupport>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<OrderBySupport>() {
            public OrderBySupport findValueByNumber(int number) {
              return OrderBySupport.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(13);
    }

    private static final OrderBySupport[] VALUES = values();

    public static OrderBySupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private OrderBySupport(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.OrderBySupport)
  }

  /**
   * Protobuf enum {@code exec.user.OuterJoinSupport}
   */
  public enum OuterJoinSupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>OJ_UNKNOWN = 0;</code>
     *
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     */
    OJ_UNKNOWN(0, 0),
    /**
     * <code>OJ_LEFT = 1;</code>
     *
     * <pre>
     * Left outer join is supported
     * </pre>
     */
    OJ_LEFT(1, 1),
    /**
     * <code>OJ_RIGHT = 2;</code>
     *
     * <pre>
     * Right outer join is supported
     * </pre>
     */
    OJ_RIGHT(2, 2),
    /**
     * <code>OJ_FULL = 3;</code>
     *
     * <pre>
     * Full outer join is supported
     * </pre>
     */
    OJ_FULL(3, 3),
    /**
     * <code>OJ_NESTED = 4;</code>
     *
     * <pre>
     * Nested outer join is supported
     * </pre>
     */
    OJ_NESTED(4, 4),
    /**
     * <code>OJ_NOT_ORDERED = 5;</code>
     *
     * <pre>
     * Column names in the ON clause don't have to share the same order
     *as their respective table names in the OUTER JOIN clase 
     * </pre>
     */
    OJ_NOT_ORDERED(5, 5),
    /**
     * <code>OJ_INNER = 6;</code>
     *
     * <pre>
     * Inner table can also be used in an inner join
     * </pre>
     */
    OJ_INNER(6, 6),
    /**
     * <code>OJ_ALL_COMPARISON_OPS = 7;</code>
     *
     * <pre>
     * Any comparison operator is supported in the ON clause
     * </pre>
     */
    OJ_ALL_COMPARISON_OPS(7, 7),
    ;

    /**
     * <code>OJ_UNKNOWN = 0;</code>
     *
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     */
    public static final int OJ_UNKNOWN_VALUE = 0;
    /**
     * <code>OJ_LEFT = 1;</code>
     *
     * <pre>
     * Left outer join is supported
     * </pre>
     */
    public static final int OJ_LEFT_VALUE = 1;
    /**
     * <code>OJ_RIGHT = 2;</code>
     *
     * <pre>
     * Right outer join is supported
     * </pre>
     */
    public static final int OJ_RIGHT_VALUE = 2;
    /**
     * <code>OJ_FULL = 3;</code>
     *
     * <pre>
     * Full outer join is supported
     * </pre>
     */
    public static final int OJ_FULL_VALUE = 3;
    /**
     * <code>OJ_NESTED = 4;</code>
     *
     * <pre>
     * Nested outer join is supported
     * </pre>
     */
    public static final int OJ_NESTED_VALUE = 4;
    /**
     * <code>OJ_NOT_ORDERED = 5;</code>
     *
     * <pre>
     * Column names in the ON clause don't have to share the same order
     *as their respective table names in the OUTER JOIN clase 
     * </pre>
     */
    public static final int OJ_NOT_ORDERED_VALUE = 5;
    /**
     * <code>OJ_INNER = 6;</code>
     *
     * <pre>
     * Inner table can also be used in an inner join
     * </pre>
     */
    public static final int OJ_INNER_VALUE = 6;
    /**
     * <code>OJ_ALL_COMPARISON_OPS = 7;</code>
     *
     * <pre>
     * Any comparison operator is supported in the ON clause
     * </pre>
     */
    public static final int OJ_ALL_COMPARISON_OPS_VALUE = 7;


    public final int getNumber() { return value; }

    public static OuterJoinSupport valueOf(int value) {
      switch (value) {
        case 0: return OJ_UNKNOWN;
        case 1: return OJ_LEFT;
        case 2: return OJ_RIGHT;
        case 3: return OJ_FULL;
        case 4: return OJ_NESTED;
        case 5: return OJ_NOT_ORDERED;
        case 6: return OJ_INNER;
        case 7: return OJ_ALL_COMPARISON_OPS;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<OuterJoinSupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<OuterJoinSupport>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<OuterJoinSupport>() {
            public OuterJoinSupport findValueByNumber(int number) {
              return OuterJoinSupport.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(14);
    }

    private static final OuterJoinSupport[] VALUES = values();

    public static OuterJoinSupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private OuterJoinSupport(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.OuterJoinSupport)
  }

  /**
   * Protobuf enum {@code exec.user.SubQuerySupport}
   */
  public enum SubQuerySupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>SQ_UNKNOWN = 0;</code>
     *
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     */
    SQ_UNKNOWN(0, 0),
    /**
     * <code>SQ_CORRELATED = 1;</code>
     *
     * <pre>
     * Correlated subquery is supported
     * </pre>
     */
    SQ_CORRELATED(1, 1),
    /**
     * <code>SQ_IN_COMPARISON = 2;</code>
     *
     * <pre>
     * Subquery in comparison expression is supported
     * </pre>
     */
    SQ_IN_COMPARISON(2, 2),
    /**
     * <code>SQ_IN_EXISTS = 3;</code>
     *
     * <pre>
     * Subquery in EXISTS expression is supported
     * </pre>
     */
    SQ_IN_EXISTS(3, 3),
    /**
     * <code>SQ_IN_INSERT = 4;</code>
     *
     * <pre>
     * Subquery in INSERT expression is supported
     * </pre>
     */
    SQ_IN_INSERT(4, 4),
    /**
     * <code>SQ_IN_QUANTIFIED = 5;</code>
     *
     * <pre>
     * Subquery in quantified expression is supported
     * </pre>
     */
    SQ_IN_QUANTIFIED(5, 5),
    ;

    /**
     * <code>SQ_UNKNOWN = 0;</code>
     *
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     */
    public static final int SQ_UNKNOWN_VALUE = 0;
    /**
     * <code>SQ_CORRELATED = 1;</code>
     *
     * <pre>
     * Correlated subquery is supported
     * </pre>
     */
    public static final int SQ_CORRELATED_VALUE = 1;
    /**
     * <code>SQ_IN_COMPARISON = 2;</code>
     *
     * <pre>
     * Subquery in comparison expression is supported
     * </pre>
     */
    public static final int SQ_IN_COMPARISON_VALUE = 2;
    /**
     * <code>SQ_IN_EXISTS = 3;</code>
     *
     * <pre>
     * Subquery in EXISTS expression is supported
     * </pre>
     */
    public static final int SQ_IN_EXISTS_VALUE = 3;
    /**
     * <code>SQ_IN_INSERT = 4;</code>
     *
     * <pre>
     * Subquery in INSERT expression is supported
     * </pre>
     */
    public static final int SQ_IN_INSERT_VALUE = 4;
    /**
     * <code>SQ_IN_QUANTIFIED = 5;</code>
     *
     * <pre>
     * Subquery in quantified expression is supported
     * </pre>
     */
    public static final int SQ_IN_QUANTIFIED_VALUE = 5;


    public final int getNumber() { return value; }

    public static SubQuerySupport valueOf(int value) {
      switch (value) {
        case 0: return SQ_UNKNOWN;
        case 1: return SQ_CORRELATED;
        case 2: return SQ_IN_COMPARISON;
        case 3: return SQ_IN_EXISTS;
        case 4: return SQ_IN_INSERT;
        case 5: return SQ_IN_QUANTIFIED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SubQuerySupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<SubQuerySupport>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<SubQuerySupport>() {
            public SubQuerySupport findValueByNumber(int number) {
              return SubQuerySupport.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(15);
    }

    private static final SubQuerySupport[] VALUES = values();

    public static SubQuerySupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private SubQuerySupport(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.SubQuerySupport)
  }

  /**
   * Protobuf enum {@code exec.user.UnionSupport}
   */
  public enum UnionSupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>U_UNKNOWN = 0;</code>
     *
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     */
    U_UNKNOWN(0, 0),
    /**
     * <code>U_UNION = 1;</code>
     *
     * <pre>
     * UNION is supported
     * </pre>
     */
    U_UNION(1, 1),
    /**
     * <code>U_UNION_ALL = 2;</code>
     *
     * <pre>
     * UNION_ALL is supported
     * </pre>
     */
    U_UNION_ALL(2, 2),
    ;

    /**
     * <code>U_UNKNOWN = 0;</code>
     *
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     */
    public static final int U_UNKNOWN_VALUE = 0;
    /**
     * <code>U_UNION = 1;</code>
     *
     * <pre>
     * UNION is supported
     * </pre>
     */
    public static final int U_UNION_VALUE = 1;
    /**
     * <code>U_UNION_ALL = 2;</code>
     *
     * <pre>
     * UNION_ALL is supported
     * </pre>
     */
    public static final int U_UNION_ALL_VALUE = 2;


    public final int getNumber() { return value; }

    public static UnionSupport valueOf(int value) {
      switch (value) {
        case 0: return U_UNKNOWN;
        case 1: return U_UNION;
        case 2: return U_UNION_ALL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<UnionSupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<UnionSupport>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<UnionSupport>() {
            public UnionSupport findValueByNumber(int number) {
              return UnionSupport.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(16);
    }

    private static final UnionSupport[] VALUES = values();

    public static UnionSupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private UnionSupport(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.UnionSupport)
  }

  public interface PropertyOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // required string key = 1;
    /**
     * <code>required string key = 1;</code>
     */
    boolean hasKey();
    /**
     * <code>required string key = 1;</code>
     */
    java.lang.String getKey();
    /**
     * <code>required string key = 1;</code>
     */
    com.google.protobuf.ByteString
        getKeyBytes();

    // required string value = 2;
    /**
     * <code>required string value = 2;</code>
     */
    boolean hasValue();
    /**
     * <code>required string value = 2;</code>
     */
    java.lang.String getValue();
    /**
     * <code>required string value = 2;</code>
     */
    com.google.protobuf.ByteString
        getValueBytes();
  }
  /**
   * Protobuf type {@code exec.user.Property}
   */
  public static final class Property extends
      com.google.protobuf.GeneratedMessage
      implements PropertyOrBuilder {
    // Use Property.newBuilder() to construct.
    private Property(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Property(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Property defaultInstance;
    public static Property getDefaultInstance() {
      return defaultInstance;
    }

    public Property getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Property(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              key_ = input.readBytes();
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              value_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_Property_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_Property_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.Property.class, org.apache.drill.exec.proto.UserProtos.Property.Builder.class);
    }

    public static com.google.protobuf.Parser<Property> PARSER =
        new com.google.protobuf.AbstractParser<Property>() {
      public Property parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Property(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Property> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // required string key = 1;
    public static final int KEY_FIELD_NUMBER = 1;
    private java.lang.Object key_;
    /**
     * <code>required string key = 1;</code>
     */
    public boolean hasKey() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string key = 1;</code>
     */
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          key_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string key = 1;</code>
     */
    public com.google.protobuf.ByteString
        getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // required string value = 2;
    public static final int VALUE_FIELD_NUMBER = 2;
    private java.lang.Object value_;
    /**
     * <code>required string value = 2;</code>
     */
    public boolean hasValue() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required string value = 2;</code>
     */
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          value_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string value = 2;</code>
     */
    public com.google.protobuf.ByteString
        getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      key_ = "";
      value_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      if (!hasKey()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasValue()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getKeyBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getValueBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getKeyBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getValueBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.Property prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.Property}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_Property_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_Property_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.Property.class, org.apache.drill.exec.proto.UserProtos.Property.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.Property.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        key_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        value_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_Property_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.Property getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.Property.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.Property build() {
        org.apache.drill.exec.proto.UserProtos.Property result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.Property buildPartial() {
        org.apache.drill.exec.proto.UserProtos.Property result = new org.apache.drill.exec.proto.UserProtos.Property(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.key_ = key_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.value_ = value_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.Property) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.Property)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.Property other) {
        if (other == org.apache.drill.exec.proto.UserProtos.Property.getDefaultInstance()) return this;
        if (other.hasKey()) {
          bitField0_ |= 0x00000001;
          key_ = other.key_;
          onChanged();
        }
        if (other.hasValue()) {
          bitField0_ |= 0x00000002;
          value_ = other.value_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasKey()) {
          
          return false;
        }
        if (!hasValue()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.Property parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.Property) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // required string key = 1;
      private java.lang.Object key_ = "";
      /**
       * <code>required string key = 1;</code>
       */
      public boolean hasKey() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string key = 1;</code>
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          key_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string key = 1;</code>
       */
      public com.google.protobuf.ByteString
          getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string key = 1;</code>
       */
      public Builder setKey(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        key_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string key = 1;</code>
       */
      public Builder clearKey() {
        bitField0_ = (bitField0_ & ~0x00000001);
        key_ = getDefaultInstance().getKey();
        onChanged();
        return this;
      }
      /**
       * <code>required string key = 1;</code>
       */
      public Builder setKeyBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        key_ = value;
        onChanged();
        return this;
      }

      // required string value = 2;
      private java.lang.Object value_ = "";
      /**
       * <code>required string value = 2;</code>
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required string value = 2;</code>
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string value = 2;</code>
       */
      public com.google.protobuf.ByteString
          getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string value = 2;</code>
       */
      public Builder setValue(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string value = 2;</code>
       */
      public Builder clearValue() {
        bitField0_ = (bitField0_ & ~0x00000002);
        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }
      /**
       * <code>required string value = 2;</code>
       */
      public Builder setValueBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        value_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.Property)
    }

    static {
      defaultInstance = new Property(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.Property)
  }

  public interface UserPropertiesOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // repeated .exec.user.Property properties = 1;
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    java.util.List<org.apache.drill.exec.proto.UserProtos.Property> 
        getPropertiesList();
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.Property getProperties(int index);
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    int getPropertiesCount();
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    java.util.List<? extends org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder> 
        getPropertiesOrBuilderList();
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder getPropertiesOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code exec.user.UserProperties}
   */
  public static final class UserProperties extends
      com.google.protobuf.GeneratedMessage
      implements UserPropertiesOrBuilder {
    // Use UserProperties.newBuilder() to construct.
    private UserProperties(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private UserProperties(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final UserProperties defaultInstance;
    public static UserProperties getDefaultInstance() {
      return defaultInstance;
    }

    public UserProperties getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private UserProperties(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                properties_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.Property>();
                mutable_bitField0_ |= 0x00000001;
              }
              properties_.add(input.readMessage(org.apache.drill.exec.proto.UserProtos.Property.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          properties_ = java.util.Collections.unmodifiableList(properties_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserProperties_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserProperties_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.UserProperties.class, org.apache.drill.exec.proto.UserProtos.UserProperties.Builder.class);
    }

    public static com.google.protobuf.Parser<UserProperties> PARSER =
        new com.google.protobuf.AbstractParser<UserProperties>() {
      public UserProperties parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new UserProperties(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<UserProperties> getParserForType() {
      return PARSER;
    }

    // repeated .exec.user.Property properties = 1;
    public static final int PROPERTIES_FIELD_NUMBER = 1;
    private java.util.List<org.apache.drill.exec.proto.UserProtos.Property> properties_;
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    public java.util.List<org.apache.drill.exec.proto.UserProtos.Property> getPropertiesList() {
      return properties_;
    }
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder> 
        getPropertiesOrBuilderList() {
      return properties_;
    }
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    public int getPropertiesCount() {
      return properties_.size();
    }
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.Property getProperties(int index) {
      return properties_.get(index);
    }
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder getPropertiesOrBuilder(
        int index) {
      return properties_.get(index);
    }

    private void initFields() {
      properties_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      for (int i = 0; i < getPropertiesCount(); i++) {
        if (!getProperties(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < properties_.size(); i++) {
        output.writeMessage(1, properties_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < properties_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, properties_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.UserProperties prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.UserProperties}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserProperties_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserProperties_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.UserProperties.class, org.apache.drill.exec.proto.UserProtos.UserProperties.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.UserProperties.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getPropertiesFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (propertiesBuilder_ == null) {
          properties_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          propertiesBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserProperties_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.UserProperties getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.UserProperties build() {
        org.apache.drill.exec.proto.UserProtos.UserProperties result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.UserProperties buildPartial() {
        org.apache.drill.exec.proto.UserProtos.UserProperties result = new org.apache.drill.exec.proto.UserProtos.UserProperties(this);
        int from_bitField0_ = bitField0_;
        if (propertiesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            properties_ = java.util.Collections.unmodifiableList(properties_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.properties_ = properties_;
        } else {
          result.properties_ = propertiesBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.UserProperties) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.UserProperties)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.UserProperties other) {
        if (other == org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance()) return this;
        if (propertiesBuilder_ == null) {
          if (!other.properties_.isEmpty()) {
            if (properties_.isEmpty()) {
              properties_ = other.properties_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensurePropertiesIsMutable();
              properties_.addAll(other.properties_);
            }
            onChanged();
          }
        } else {
          if (!other.properties_.isEmpty()) {
            if (propertiesBuilder_.isEmpty()) {
              propertiesBuilder_.dispose();
              propertiesBuilder_ = null;
              properties_ = other.properties_;
              bitField0_ = (bitField0_ & ~0x00000001);
              propertiesBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getPropertiesFieldBuilder() : null;
            } else {
              propertiesBuilder_.addAllMessages(other.properties_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        for (int i = 0; i < getPropertiesCount(); i++) {
          if (!getProperties(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.UserProperties parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.UserProperties) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // repeated .exec.user.Property properties = 1;
      private java.util.List<org.apache.drill.exec.proto.UserProtos.Property> properties_ =
        java.util.Collections.emptyList();
      private void ensurePropertiesIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          properties_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.Property>(properties_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.Property, org.apache.drill.exec.proto.UserProtos.Property.Builder, org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder> propertiesBuilder_;

      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.Property> getPropertiesList() {
        if (propertiesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(properties_);
        } else {
          return propertiesBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public int getPropertiesCount() {
        if (propertiesBuilder_ == null) {
          return properties_.size();
        } else {
          return propertiesBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.Property getProperties(int index) {
        if (propertiesBuilder_ == null) {
          return properties_.get(index);
        } else {
          return propertiesBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder setProperties(
          int index, org.apache.drill.exec.proto.UserProtos.Property value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropertiesIsMutable();
          properties_.set(index, value);
          onChanged();
        } else {
          propertiesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder setProperties(
          int index, org.apache.drill.exec.proto.UserProtos.Property.Builder builderForValue) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.set(index, builderForValue.build());
          onChanged();
        } else {
          propertiesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder addProperties(org.apache.drill.exec.proto.UserProtos.Property value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropertiesIsMutable();
          properties_.add(value);
          onChanged();
        } else {
          propertiesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder addProperties(
          int index, org.apache.drill.exec.proto.UserProtos.Property value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropertiesIsMutable();
          properties_.add(index, value);
          onChanged();
        } else {
          propertiesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder addProperties(
          org.apache.drill.exec.proto.UserProtos.Property.Builder builderForValue) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.add(builderForValue.build());
          onChanged();
        } else {
          propertiesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder addProperties(
          int index, org.apache.drill.exec.proto.UserProtos.Property.Builder builderForValue) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.add(index, builderForValue.build());
          onChanged();
        } else {
          propertiesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder addAllProperties(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.UserProtos.Property> values) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          super.addAll(values, properties_);
          onChanged();
        } else {
          propertiesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder clearProperties() {
        if (propertiesBuilder_ == null) {
          properties_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          propertiesBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder removeProperties(int index) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.remove(index);
          onChanged();
        } else {
          propertiesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.Property.Builder getPropertiesBuilder(
          int index) {
        return getPropertiesFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder getPropertiesOrBuilder(
          int index) {
        if (propertiesBuilder_ == null) {
          return properties_.get(index);  } else {
          return propertiesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder> 
           getPropertiesOrBuilderList() {
        if (propertiesBuilder_ != null) {
          return propertiesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(properties_);
        }
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.Property.Builder addPropertiesBuilder() {
        return getPropertiesFieldBuilder().addBuilder(
            org.apache.drill.exec.proto.UserProtos.Property.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.Property.Builder addPropertiesBuilder(
          int index) {
        return getPropertiesFieldBuilder().addBuilder(
            index, org.apache.drill.exec.proto.UserProtos.Property.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.Property.Builder> 
           getPropertiesBuilderList() {
        return getPropertiesFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.Property, org.apache.drill.exec.proto.UserProtos.Property.Builder, org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder> 
          getPropertiesFieldBuilder() {
        if (propertiesBuilder_ == null) {
          propertiesBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.Property, org.apache.drill.exec.proto.UserProtos.Property.Builder, org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder>(
                  properties_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          properties_ = null;
        }
        return propertiesBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.UserProperties)
    }

    static {
      defaultInstance = new UserProperties(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.UserProperties)
  }

  public interface RpcEndpointInfosOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional string name = 1;
    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * example: Apache Drill Server, Apache Drill C++ client
     * </pre>
     */
    boolean hasName();
    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * example: Apache Drill Server, Apache Drill C++ client
     * </pre>
     */
    java.lang.String getName();
    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * example: Apache Drill Server, Apache Drill C++ client
     * </pre>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    // optional string version = 2;
    /**
     * <code>optional string version = 2;</code>
     *
     * <pre>
     * example: 1.9.0
     * </pre>
     */
    boolean hasVersion();
    /**
     * <code>optional string version = 2;</code>
     *
     * <pre>
     * example: 1.9.0
     * </pre>
     */
    java.lang.String getVersion();
    /**
     * <code>optional string version = 2;</code>
     *
     * <pre>
     * example: 1.9.0
     * </pre>
     */
    com.google.protobuf.ByteString
        getVersionBytes();

    // optional uint32 majorVersion = 3;
    /**
     * <code>optional uint32 majorVersion = 3;</code>
     *
     * <pre>
     * example: 1
     * </pre>
     */
    boolean hasMajorVersion();
    /**
     * <code>optional uint32 majorVersion = 3;</code>
     *
     * <pre>
     * example: 1
     * </pre>
     */
    int getMajorVersion();

    // optional uint32 minorVersion = 4;
    /**
     * <code>optional uint32 minorVersion = 4;</code>
     *
     * <pre>
     * example: 9
     * </pre>
     */
    boolean hasMinorVersion();
    /**
     * <code>optional uint32 minorVersion = 4;</code>
     *
     * <pre>
     * example: 9
     * </pre>
     */
    int getMinorVersion();

    // optional uint32 patchVersion = 5;
    /**
     * <code>optional uint32 patchVersion = 5;</code>
     *
     * <pre>
     * example: 0
     * </pre>
     */
    boolean hasPatchVersion();
    /**
     * <code>optional uint32 patchVersion = 5;</code>
     *
     * <pre>
     * example: 0
     * </pre>
     */
    int getPatchVersion();

    // optional string application = 6;
    /**
     * <code>optional string application = 6;</code>
     *
     * <pre>
     * example: Tableau 9.3
     * </pre>
     */
    boolean hasApplication();
    /**
     * <code>optional string application = 6;</code>
     *
     * <pre>
     * example: Tableau 9.3
     * </pre>
     */
    java.lang.String getApplication();
    /**
     * <code>optional string application = 6;</code>
     *
     * <pre>
     * example: Tableau 9.3
     * </pre>
     */
    com.google.protobuf.ByteString
        getApplicationBytes();

    // optional uint32 buildNumber = 7;
    /**
     * <code>optional uint32 buildNumber = 7;</code>
     *
     * <pre>
     * example: 32
     * </pre>
     */
    boolean hasBuildNumber();
    /**
     * <code>optional uint32 buildNumber = 7;</code>
     *
     * <pre>
     * example: 32
     * </pre>
     */
    int getBuildNumber();

    // optional string versionQualifier = 8;
    /**
     * <code>optional string versionQualifier = 8;</code>
     *
     * <pre>
     * example: SNAPSHOT
     * </pre>
     */
    boolean hasVersionQualifier();
    /**
     * <code>optional string versionQualifier = 8;</code>
     *
     * <pre>
     * example: SNAPSHOT
     * </pre>
     */
    java.lang.String getVersionQualifier();
    /**
     * <code>optional string versionQualifier = 8;</code>
     *
     * <pre>
     * example: SNAPSHOT
     * </pre>
     */
    com.google.protobuf.ByteString
        getVersionQualifierBytes();
  }
  /**
   * Protobuf type {@code exec.user.RpcEndpointInfos}
   */
  public static final class RpcEndpointInfos extends
      com.google.protobuf.GeneratedMessage
      implements RpcEndpointInfosOrBuilder {
    // Use RpcEndpointInfos.newBuilder() to construct.
    private RpcEndpointInfos(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private RpcEndpointInfos(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final RpcEndpointInfos defaultInstance;
    public static RpcEndpointInfos getDefaultInstance() {
      return defaultInstance;
    }

    public RpcEndpointInfos getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private RpcEndpointInfos(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              name_ = input.readBytes();
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              version_ = input.readBytes();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              majorVersion_ = input.readUInt32();
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              minorVersion_ = input.readUInt32();
              break;
            }
            case 40: {
              bitField0_ |= 0x00000010;
              patchVersion_ = input.readUInt32();
              break;
            }
            case 50: {
              bitField0_ |= 0x00000020;
              application_ = input.readBytes();
              break;
            }
            case 56: {
              bitField0_ |= 0x00000040;
              buildNumber_ = input.readUInt32();
              break;
            }
            case 66: {
              bitField0_ |= 0x00000080;
              versionQualifier_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RpcEndpointInfos_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RpcEndpointInfos_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.class, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder.class);
    }

    public static com.google.protobuf.Parser<RpcEndpointInfos> PARSER =
        new com.google.protobuf.AbstractParser<RpcEndpointInfos>() {
      public RpcEndpointInfos parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new RpcEndpointInfos(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<RpcEndpointInfos> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional string name = 1;
    public static final int NAME_FIELD_NUMBER = 1;
    private java.lang.Object name_;
    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * example: Apache Drill Server, Apache Drill C++ client
     * </pre>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * example: Apache Drill Server, Apache Drill C++ client
     * </pre>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * example: Apache Drill Server, Apache Drill C++ client
     * </pre>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string version = 2;
    public static final int VERSION_FIELD_NUMBER = 2;
    private java.lang.Object version_;
    /**
     * <code>optional string version = 2;</code>
     *
     * <pre>
     * example: 1.9.0
     * </pre>
     */
    public boolean hasVersion() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string version = 2;</code>
     *
     * <pre>
     * example: 1.9.0
     * </pre>
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          version_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string version = 2;</code>
     *
     * <pre>
     * example: 1.9.0
     * </pre>
     */
    public com.google.protobuf.ByteString
        getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional uint32 majorVersion = 3;
    public static final int MAJORVERSION_FIELD_NUMBER = 3;
    private int majorVersion_;
    /**
     * <code>optional uint32 majorVersion = 3;</code>
     *
     * <pre>
     * example: 1
     * </pre>
     */
    public boolean hasMajorVersion() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional uint32 majorVersion = 3;</code>
     *
     * <pre>
     * example: 1
     * </pre>
     */
    public int getMajorVersion() {
      return majorVersion_;
    }

    // optional uint32 minorVersion = 4;
    public static final int MINORVERSION_FIELD_NUMBER = 4;
    private int minorVersion_;
    /**
     * <code>optional uint32 minorVersion = 4;</code>
     *
     * <pre>
     * example: 9
     * </pre>
     */
    public boolean hasMinorVersion() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional uint32 minorVersion = 4;</code>
     *
     * <pre>
     * example: 9
     * </pre>
     */
    public int getMinorVersion() {
      return minorVersion_;
    }

    // optional uint32 patchVersion = 5;
    public static final int PATCHVERSION_FIELD_NUMBER = 5;
    private int patchVersion_;
    /**
     * <code>optional uint32 patchVersion = 5;</code>
     *
     * <pre>
     * example: 0
     * </pre>
     */
    public boolean hasPatchVersion() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional uint32 patchVersion = 5;</code>
     *
     * <pre>
     * example: 0
     * </pre>
     */
    public int getPatchVersion() {
      return patchVersion_;
    }

    // optional string application = 6;
    public static final int APPLICATION_FIELD_NUMBER = 6;
    private java.lang.Object application_;
    /**
     * <code>optional string application = 6;</code>
     *
     * <pre>
     * example: Tableau 9.3
     * </pre>
     */
    public boolean hasApplication() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional string application = 6;</code>
     *
     * <pre>
     * example: Tableau 9.3
     * </pre>
     */
    public java.lang.String getApplication() {
      java.lang.Object ref = application_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          application_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string application = 6;</code>
     *
     * <pre>
     * example: Tableau 9.3
     * </pre>
     */
    public com.google.protobuf.ByteString
        getApplicationBytes() {
      java.lang.Object ref = application_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        application_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional uint32 buildNumber = 7;
    public static final int BUILDNUMBER_FIELD_NUMBER = 7;
    private int buildNumber_;
    /**
     * <code>optional uint32 buildNumber = 7;</code>
     *
     * <pre>
     * example: 32
     * </pre>
     */
    public boolean hasBuildNumber() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional uint32 buildNumber = 7;</code>
     *
     * <pre>
     * example: 32
     * </pre>
     */
    public int getBuildNumber() {
      return buildNumber_;
    }

    // optional string versionQualifier = 8;
    public static final int VERSIONQUALIFIER_FIELD_NUMBER = 8;
    private java.lang.Object versionQualifier_;
    /**
     * <code>optional string versionQualifier = 8;</code>
     *
     * <pre>
     * example: SNAPSHOT
     * </pre>
     */
    public boolean hasVersionQualifier() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     * <code>optional string versionQualifier = 8;</code>
     *
     * <pre>
     * example: SNAPSHOT
     * </pre>
     */
    public java.lang.String getVersionQualifier() {
      java.lang.Object ref = versionQualifier_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          versionQualifier_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string versionQualifier = 8;</code>
     *
     * <pre>
     * example: SNAPSHOT
     * </pre>
     */
    public com.google.protobuf.ByteString
        getVersionQualifierBytes() {
      java.lang.Object ref = versionQualifier_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        versionQualifier_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      name_ = "";
      version_ = "";
      majorVersion_ = 0;
      minorVersion_ = 0;
      patchVersion_ = 0;
      application_ = "";
      buildNumber_ = 0;
      versionQualifier_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getVersionBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt32(3, majorVersion_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeUInt32(4, minorVersion_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeUInt32(5, patchVersion_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeBytes(6, getApplicationBytes());
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeUInt32(7, buildNumber_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeBytes(8, getVersionQualifierBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getVersionBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(3, majorVersion_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(4, minorVersion_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(5, patchVersion_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(6, getApplicationBytes());
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(7, buildNumber_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(8, getVersionQualifierBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.RpcEndpointInfos}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RpcEndpointInfos_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RpcEndpointInfos_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.class, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        version_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        majorVersion_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        minorVersion_ = 0;
        bitField0_ = (bitField0_ & ~0x00000008);
        patchVersion_ = 0;
        bitField0_ = (bitField0_ & ~0x00000010);
        application_ = "";
        bitField0_ = (bitField0_ & ~0x00000020);
        buildNumber_ = 0;
        bitField0_ = (bitField0_ & ~0x00000040);
        versionQualifier_ = "";
        bitField0_ = (bitField0_ & ~0x00000080);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RpcEndpointInfos_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos build() {
        org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos buildPartial() {
        org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos result = new org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.version_ = version_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.majorVersion_ = majorVersion_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.minorVersion_ = minorVersion_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.patchVersion_ = patchVersion_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.application_ = application_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.buildNumber_ = buildNumber_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000080;
        }
        result.versionQualifier_ = versionQualifier_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos other) {
        if (other == org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance()) return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          onChanged();
        }
        if (other.hasVersion()) {
          bitField0_ |= 0x00000002;
          version_ = other.version_;
          onChanged();
        }
        if (other.hasMajorVersion()) {
          setMajorVersion(other.getMajorVersion());
        }
        if (other.hasMinorVersion()) {
          setMinorVersion(other.getMinorVersion());
        }
        if (other.hasPatchVersion()) {
          setPatchVersion(other.getPatchVersion());
        }
        if (other.hasApplication()) {
          bitField0_ |= 0x00000020;
          application_ = other.application_;
          onChanged();
        }
        if (other.hasBuildNumber()) {
          setBuildNumber(other.getBuildNumber());
        }
        if (other.hasVersionQualifier()) {
          bitField0_ |= 0x00000080;
          versionQualifier_ = other.versionQualifier_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional string name = 1;
      private java.lang.Object name_ = "";
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * example: Apache Drill Server, Apache Drill C++ client
       * </pre>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * example: Apache Drill Server, Apache Drill C++ client
       * </pre>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * example: Apache Drill Server, Apache Drill C++ client
       * </pre>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * example: Apache Drill Server, Apache Drill C++ client
       * </pre>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * example: Apache Drill Server, Apache Drill C++ client
       * </pre>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * example: Apache Drill Server, Apache Drill C++ client
       * </pre>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }

      // optional string version = 2;
      private java.lang.Object version_ = "";
      /**
       * <code>optional string version = 2;</code>
       *
       * <pre>
       * example: 1.9.0
       * </pre>
       */
      public boolean hasVersion() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string version = 2;</code>
       *
       * <pre>
       * example: 1.9.0
       * </pre>
       */
      public java.lang.String getVersion() {
        java.lang.Object ref = version_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          version_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string version = 2;</code>
       *
       * <pre>
       * example: 1.9.0
       * </pre>
       */
      public com.google.protobuf.ByteString
          getVersionBytes() {
        java.lang.Object ref = version_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          version_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string version = 2;</code>
       *
       * <pre>
       * example: 1.9.0
       * </pre>
       */
      public Builder setVersion(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        version_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string version = 2;</code>
       *
       * <pre>
       * example: 1.9.0
       * </pre>
       */
      public Builder clearVersion() {
        bitField0_ = (bitField0_ & ~0x00000002);
        version_ = getDefaultInstance().getVersion();
        onChanged();
        return this;
      }
      /**
       * <code>optional string version = 2;</code>
       *
       * <pre>
       * example: 1.9.0
       * </pre>
       */
      public Builder setVersionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        version_ = value;
        onChanged();
        return this;
      }

      // optional uint32 majorVersion = 3;
      private int majorVersion_ ;
      /**
       * <code>optional uint32 majorVersion = 3;</code>
       *
       * <pre>
       * example: 1
       * </pre>
       */
      public boolean hasMajorVersion() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional uint32 majorVersion = 3;</code>
       *
       * <pre>
       * example: 1
       * </pre>
       */
      public int getMajorVersion() {
        return majorVersion_;
      }
      /**
       * <code>optional uint32 majorVersion = 3;</code>
       *
       * <pre>
       * example: 1
       * </pre>
       */
      public Builder setMajorVersion(int value) {
        bitField0_ |= 0x00000004;
        majorVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 majorVersion = 3;</code>
       *
       * <pre>
       * example: 1
       * </pre>
       */
      public Builder clearMajorVersion() {
        bitField0_ = (bitField0_ & ~0x00000004);
        majorVersion_ = 0;
        onChanged();
        return this;
      }

      // optional uint32 minorVersion = 4;
      private int minorVersion_ ;
      /**
       * <code>optional uint32 minorVersion = 4;</code>
       *
       * <pre>
       * example: 9
       * </pre>
       */
      public boolean hasMinorVersion() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional uint32 minorVersion = 4;</code>
       *
       * <pre>
       * example: 9
       * </pre>
       */
      public int getMinorVersion() {
        return minorVersion_;
      }
      /**
       * <code>optional uint32 minorVersion = 4;</code>
       *
       * <pre>
       * example: 9
       * </pre>
       */
      public Builder setMinorVersion(int value) {
        bitField0_ |= 0x00000008;
        minorVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 minorVersion = 4;</code>
       *
       * <pre>
       * example: 9
       * </pre>
       */
      public Builder clearMinorVersion() {
        bitField0_ = (bitField0_ & ~0x00000008);
        minorVersion_ = 0;
        onChanged();
        return this;
      }

      // optional uint32 patchVersion = 5;
      private int patchVersion_ ;
      /**
       * <code>optional uint32 patchVersion = 5;</code>
       *
       * <pre>
       * example: 0
       * </pre>
       */
      public boolean hasPatchVersion() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional uint32 patchVersion = 5;</code>
       *
       * <pre>
       * example: 0
       * </pre>
       */
      public int getPatchVersion() {
        return patchVersion_;
      }
      /**
       * <code>optional uint32 patchVersion = 5;</code>
       *
       * <pre>
       * example: 0
       * </pre>
       */
      public Builder setPatchVersion(int value) {
        bitField0_ |= 0x00000010;
        patchVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 patchVersion = 5;</code>
       *
       * <pre>
       * example: 0
       * </pre>
       */
      public Builder clearPatchVersion() {
        bitField0_ = (bitField0_ & ~0x00000010);
        patchVersion_ = 0;
        onChanged();
        return this;
      }

      // optional string application = 6;
      private java.lang.Object application_ = "";
      /**
       * <code>optional string application = 6;</code>
       *
       * <pre>
       * example: Tableau 9.3
       * </pre>
       */
      public boolean hasApplication() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional string application = 6;</code>
       *
       * <pre>
       * example: Tableau 9.3
       * </pre>
       */
      public java.lang.String getApplication() {
        java.lang.Object ref = application_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          application_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string application = 6;</code>
       *
       * <pre>
       * example: Tableau 9.3
       * </pre>
       */
      public com.google.protobuf.ByteString
          getApplicationBytes() {
        java.lang.Object ref = application_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          application_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string application = 6;</code>
       *
       * <pre>
       * example: Tableau 9.3
       * </pre>
       */
      public Builder setApplication(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
        application_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string application = 6;</code>
       *
       * <pre>
       * example: Tableau 9.3
       * </pre>
       */
      public Builder clearApplication() {
        bitField0_ = (bitField0_ & ~0x00000020);
        application_ = getDefaultInstance().getApplication();
        onChanged();
        return this;
      }
      /**
       * <code>optional string application = 6;</code>
       *
       * <pre>
       * example: Tableau 9.3
       * </pre>
       */
      public Builder setApplicationBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
        application_ = value;
        onChanged();
        return this;
      }

      // optional uint32 buildNumber = 7;
      private int buildNumber_ ;
      /**
       * <code>optional uint32 buildNumber = 7;</code>
       *
       * <pre>
       * example: 32
       * </pre>
       */
      public boolean hasBuildNumber() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional uint32 buildNumber = 7;</code>
       *
       * <pre>
       * example: 32
       * </pre>
       */
      public int getBuildNumber() {
        return buildNumber_;
      }
      /**
       * <code>optional uint32 buildNumber = 7;</code>
       *
       * <pre>
       * example: 32
       * </pre>
       */
      public Builder setBuildNumber(int value) {
        bitField0_ |= 0x00000040;
        buildNumber_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 buildNumber = 7;</code>
       *
       * <pre>
       * example: 32
       * </pre>
       */
      public Builder clearBuildNumber() {
        bitField0_ = (bitField0_ & ~0x00000040);
        buildNumber_ = 0;
        onChanged();
        return this;
      }

      // optional string versionQualifier = 8;
      private java.lang.Object versionQualifier_ = "";
      /**
       * <code>optional string versionQualifier = 8;</code>
       *
       * <pre>
       * example: SNAPSHOT
       * </pre>
       */
      public boolean hasVersionQualifier() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <code>optional string versionQualifier = 8;</code>
       *
       * <pre>
       * example: SNAPSHOT
       * </pre>
       */
      public java.lang.String getVersionQualifier() {
        java.lang.Object ref = versionQualifier_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          versionQualifier_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string versionQualifier = 8;</code>
       *
       * <pre>
       * example: SNAPSHOT
       * </pre>
       */
      public com.google.protobuf.ByteString
          getVersionQualifierBytes() {
        java.lang.Object ref = versionQualifier_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          versionQualifier_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string versionQualifier = 8;</code>
       *
       * <pre>
       * example: SNAPSHOT
       * </pre>
       */
      public Builder setVersionQualifier(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000080;
        versionQualifier_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string versionQualifier = 8;</code>
       *
       * <pre>
       * example: SNAPSHOT
       * </pre>
       */
      public Builder clearVersionQualifier() {
        bitField0_ = (bitField0_ & ~0x00000080);
        versionQualifier_ = getDefaultInstance().getVersionQualifier();
        onChanged();
        return this;
      }
      /**
       * <code>optional string versionQualifier = 8;</code>
       *
       * <pre>
       * example: SNAPSHOT
       * </pre>
       */
      public Builder setVersionQualifierBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000080;
        versionQualifier_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.RpcEndpointInfos)
    }

    static {
      defaultInstance = new RpcEndpointInfos(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.RpcEndpointInfos)
  }

  public interface UserToBitHandshakeOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.shared.RpcChannel channel = 1 [default = USER];
    /**
     * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
     */
    boolean hasChannel();
    /**
     * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
     */
    org.apache.drill.exec.proto.UserBitShared.RpcChannel getChannel();

    // optional bool support_listening = 2;
    /**
     * <code>optional bool support_listening = 2;</code>
     */
    boolean hasSupportListening();
    /**
     * <code>optional bool support_listening = 2;</code>
     */
    boolean getSupportListening();

    // optional int32 rpc_version = 3;
    /**
     * <code>optional int32 rpc_version = 3;</code>
     */
    boolean hasRpcVersion();
    /**
     * <code>optional int32 rpc_version = 3;</code>
     */
    int getRpcVersion();

    // optional .exec.shared.UserCredentials credentials = 4;
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     */
    boolean hasCredentials();
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.UserCredentials getCredentials();
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder getCredentialsOrBuilder();

    // optional .exec.user.UserProperties properties = 5;
    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     */
    boolean hasProperties();
    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     */
    org.apache.drill.exec.proto.UserProtos.UserProperties getProperties();
    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     */
    org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder getPropertiesOrBuilder();

    // optional bool support_complex_types = 6 [default = false];
    /**
     * <code>optional bool support_complex_types = 6 [default = false];</code>
     */
    boolean hasSupportComplexTypes();
    /**
     * <code>optional bool support_complex_types = 6 [default = false];</code>
     */
    boolean getSupportComplexTypes();

    // optional bool support_timeout = 7 [default = false];
    /**
     * <code>optional bool support_timeout = 7 [default = false];</code>
     */
    boolean hasSupportTimeout();
    /**
     * <code>optional bool support_timeout = 7 [default = false];</code>
     */
    boolean getSupportTimeout();

    // optional .exec.user.RpcEndpointInfos client_infos = 8;
    /**
     * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
     */
    boolean hasClientInfos();
    /**
     * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
     */
    org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos getClientInfos();
    /**
     * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
     */
    org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder getClientInfosOrBuilder();

    // optional .exec.user.SaslSupport sasl_support = 9;
    /**
     * <code>optional .exec.user.SaslSupport sasl_support = 9;</code>
     */
    boolean hasSaslSupport();
    /**
     * <code>optional .exec.user.SaslSupport sasl_support = 9;</code>
     */
    org.apache.drill.exec.proto.UserProtos.SaslSupport getSaslSupport();
  }
  /**
   * Protobuf type {@code exec.user.UserToBitHandshake}
   */
  public static final class UserToBitHandshake extends
      com.google.protobuf.GeneratedMessage
      implements UserToBitHandshakeOrBuilder {
    // Use UserToBitHandshake.newBuilder() to construct.
    private UserToBitHandshake(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private UserToBitHandshake(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final UserToBitHandshake defaultInstance;
    public static UserToBitHandshake getDefaultInstance() {
      return defaultInstance;
    }

    public UserToBitHandshake getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private UserToBitHandshake(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.UserBitShared.RpcChannel value = org.apache.drill.exec.proto.UserBitShared.RpcChannel.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                channel_ = value;
              }
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              supportListening_ = input.readBool();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              rpcVersion_ = input.readInt32();
              break;
            }
            case 34: {
              org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder subBuilder = null;
              if (((bitField0_ & 0x00000008) == 0x00000008)) {
                subBuilder = credentials_.toBuilder();
              }
              credentials_ = input.readMessage(org.apache.drill.exec.proto.UserBitShared.UserCredentials.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(credentials_);
                credentials_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000008;
              break;
            }
            case 42: {
              org.apache.drill.exec.proto.UserProtos.UserProperties.Builder subBuilder = null;
              if (((bitField0_ & 0x00000010) == 0x00000010)) {
                subBuilder = properties_.toBuilder();
              }
              properties_ = input.readMessage(org.apache.drill.exec.proto.UserProtos.UserProperties.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(properties_);
                properties_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000010;
              break;
            }
            case 48: {
              bitField0_ |= 0x00000020;
              supportComplexTypes_ = input.readBool();
              break;
            }
            case 56: {
              bitField0_ |= 0x00000040;
              supportTimeout_ = input.readBool();
              break;
            }
            case 66: {
              org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder subBuilder = null;
              if (((bitField0_ & 0x00000080) == 0x00000080)) {
                subBuilder = clientInfos_.toBuilder();
              }
              clientInfos_ = input.readMessage(org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(clientInfos_);
                clientInfos_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000080;
              break;
            }
            case 72: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.UserProtos.SaslSupport value = org.apache.drill.exec.proto.UserProtos.SaslSupport.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(9, rawValue);
              } else {
                bitField0_ |= 0x00000100;
                saslSupport_ = value;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserToBitHandshake_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserToBitHandshake_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.class, org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.Builder.class);
    }

    public static com.google.protobuf.Parser<UserToBitHandshake> PARSER =
        new com.google.protobuf.AbstractParser<UserToBitHandshake>() {
      public UserToBitHandshake parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new UserToBitHandshake(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<UserToBitHandshake> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.shared.RpcChannel channel = 1 [default = USER];
    public static final int CHANNEL_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserBitShared.RpcChannel channel_;
    /**
     * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
     */
    public boolean hasChannel() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.RpcChannel getChannel() {
      return channel_;
    }

    // optional bool support_listening = 2;
    public static final int SUPPORT_LISTENING_FIELD_NUMBER = 2;
    private boolean supportListening_;
    /**
     * <code>optional bool support_listening = 2;</code>
     */
    public boolean hasSupportListening() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional bool support_listening = 2;</code>
     */
    public boolean getSupportListening() {
      return supportListening_;
    }

    // optional int32 rpc_version = 3;
    public static final int RPC_VERSION_FIELD_NUMBER = 3;
    private int rpcVersion_;
    /**
     * <code>optional int32 rpc_version = 3;</code>
     */
    public boolean hasRpcVersion() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional int32 rpc_version = 3;</code>
     */
    public int getRpcVersion() {
      return rpcVersion_;
    }

    // optional .exec.shared.UserCredentials credentials = 4;
    public static final int CREDENTIALS_FIELD_NUMBER = 4;
    private org.apache.drill.exec.proto.UserBitShared.UserCredentials credentials_;
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     */
    public boolean hasCredentials() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.UserCredentials getCredentials() {
      return credentials_;
    }
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder getCredentialsOrBuilder() {
      return credentials_;
    }

    // optional .exec.user.UserProperties properties = 5;
    public static final int PROPERTIES_FIELD_NUMBER = 5;
    private org.apache.drill.exec.proto.UserProtos.UserProperties properties_;
    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     */
    public boolean hasProperties() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.UserProperties getProperties() {
      return properties_;
    }
    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder getPropertiesOrBuilder() {
      return properties_;
    }

    // optional bool support_complex_types = 6 [default = false];
    public static final int SUPPORT_COMPLEX_TYPES_FIELD_NUMBER = 6;
    private boolean supportComplexTypes_;
    /**
     * <code>optional bool support_complex_types = 6 [default = false];</code>
     */
    public boolean hasSupportComplexTypes() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional bool support_complex_types = 6 [default = false];</code>
     */
    public boolean getSupportComplexTypes() {
      return supportComplexTypes_;
    }

    // optional bool support_timeout = 7 [default = false];
    public static final int SUPPORT_TIMEOUT_FIELD_NUMBER = 7;
    private boolean supportTimeout_;
    /**
     * <code>optional bool support_timeout = 7 [default = false];</code>
     */
    public boolean hasSupportTimeout() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional bool support_timeout = 7 [default = false];</code>
     */
    public boolean getSupportTimeout() {
      return supportTimeout_;
    }

    // optional .exec.user.RpcEndpointInfos client_infos = 8;
    public static final int CLIENT_INFOS_FIELD_NUMBER = 8;
    private org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos clientInfos_;
    /**
     * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
     */
    public boolean hasClientInfos() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos getClientInfos() {
      return clientInfos_;
    }
    /**
     * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder getClientInfosOrBuilder() {
      return clientInfos_;
    }

    // optional .exec.user.SaslSupport sasl_support = 9;
    public static final int SASL_SUPPORT_FIELD_NUMBER = 9;
    private org.apache.drill.exec.proto.UserProtos.SaslSupport saslSupport_;
    /**
     * <code>optional .exec.user.SaslSupport sasl_support = 9;</code>
     */
    public boolean hasSaslSupport() {
      return ((bitField0_ & 0x00000100) == 0x00000100);
    }
    /**
     * <code>optional .exec.user.SaslSupport sasl_support = 9;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.SaslSupport getSaslSupport() {
      return saslSupport_;
    }

    private void initFields() {
      channel_ = org.apache.drill.exec.proto.UserBitShared.RpcChannel.USER;
      supportListening_ = false;
      rpcVersion_ = 0;
      credentials_ = org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance();
      properties_ = org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance();
      supportComplexTypes_ = false;
      supportTimeout_ = false;
      clientInfos_ = org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance();
      saslSupport_ = org.apache.drill.exec.proto.UserProtos.SaslSupport.UNKNOWN_SASL_SUPPORT;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      if (hasProperties()) {
        if (!getProperties().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, channel_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBool(2, supportListening_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeInt32(3, rpcVersion_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeMessage(4, credentials_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeMessage(5, properties_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeBool(6, supportComplexTypes_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeBool(7, supportTimeout_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeMessage(8, clientInfos_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        output.writeEnum(9, saslSupport_.getNumber());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, channel_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, supportListening_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(3, rpcVersion_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, credentials_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, properties_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(6, supportComplexTypes_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(7, supportTimeout_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, clientInfos_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(9, saslSupport_.getNumber());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.UserToBitHandshake prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.UserToBitHandshake}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.UserToBitHandshakeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserToBitHandshake_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserToBitHandshake_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.class, org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getCredentialsFieldBuilder();
          getPropertiesFieldBuilder();
          getClientInfosFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        channel_ = org.apache.drill.exec.proto.UserBitShared.RpcChannel.USER;
        bitField0_ = (bitField0_ & ~0x00000001);
        supportListening_ = false;
        bitField0_ = (bitField0_ & ~0x00000002);
        rpcVersion_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        if (credentialsBuilder_ == null) {
          credentials_ = org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance();
        } else {
          credentialsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        if (propertiesBuilder_ == null) {
          properties_ = org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance();
        } else {
          propertiesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        supportComplexTypes_ = false;
        bitField0_ = (bitField0_ & ~0x00000020);
        supportTimeout_ = false;
        bitField0_ = (bitField0_ & ~0x00000040);
        if (clientInfosBuilder_ == null) {
          clientInfos_ = org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance();
        } else {
          clientInfosBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000080);
        saslSupport_ = org.apache.drill.exec.proto.UserProtos.SaslSupport.UNKNOWN_SASL_SUPPORT;
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserToBitHandshake_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.UserToBitHandshake getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.UserToBitHandshake build() {
        org.apache.drill.exec.proto.UserProtos.UserToBitHandshake result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.UserToBitHandshake buildPartial() {
        org.apache.drill.exec.proto.UserProtos.UserToBitHandshake result = new org.apache.drill.exec.proto.UserProtos.UserToBitHandshake(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.channel_ = channel_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.supportListening_ = supportListening_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.rpcVersion_ = rpcVersion_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        if (credentialsBuilder_ == null) {
          result.credentials_ = credentials_;
        } else {
          result.credentials_ = credentialsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        if (propertiesBuilder_ == null) {
          result.properties_ = properties_;
        } else {
          result.properties_ = propertiesBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.supportComplexTypes_ = supportComplexTypes_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.supportTimeout_ = supportTimeout_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000080;
        }
        if (clientInfosBuilder_ == null) {
          result.clientInfos_ = clientInfos_;
        } else {
          result.clientInfos_ = clientInfosBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
          to_bitField0_ |= 0x00000100;
        }
        result.saslSupport_ = saslSupport_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.UserToBitHandshake) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.UserToBitHandshake)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.UserToBitHandshake other) {
        if (other == org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.getDefaultInstance()) return this;
        if (other.hasChannel()) {
          setChannel(other.getChannel());
        }
        if (other.hasSupportListening()) {
          setSupportListening(other.getSupportListening());
        }
        if (other.hasRpcVersion()) {
          setRpcVersion(other.getRpcVersion());
        }
        if (other.hasCredentials()) {
          mergeCredentials(other.getCredentials());
        }
        if (other.hasProperties()) {
          mergeProperties(other.getProperties());
        }
        if (other.hasSupportComplexTypes()) {
          setSupportComplexTypes(other.getSupportComplexTypes());
        }
        if (other.hasSupportTimeout()) {
          setSupportTimeout(other.getSupportTimeout());
        }
        if (other.hasClientInfos()) {
          mergeClientInfos(other.getClientInfos());
        }
        if (other.hasSaslSupport()) {
          setSaslSupport(other.getSaslSupport());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (hasProperties()) {
          if (!getProperties().isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.UserToBitHandshake) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.shared.RpcChannel channel = 1 [default = USER];
      private org.apache.drill.exec.proto.UserBitShared.RpcChannel channel_ = org.apache.drill.exec.proto.UserBitShared.RpcChannel.USER;
      /**
       * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
       */
      public boolean hasChannel() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.RpcChannel getChannel() {
        return channel_;
      }
      /**
       * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
       */
      public Builder setChannel(org.apache.drill.exec.proto.UserBitShared.RpcChannel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        channel_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
       */
      public Builder clearChannel() {
        bitField0_ = (bitField0_ & ~0x00000001);
        channel_ = org.apache.drill.exec.proto.UserBitShared.RpcChannel.USER;
        onChanged();
        return this;
      }

      // optional bool support_listening = 2;
      private boolean supportListening_ ;
      /**
       * <code>optional bool support_listening = 2;</code>
       */
      public boolean hasSupportListening() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional bool support_listening = 2;</code>
       */
      public boolean getSupportListening() {
        return supportListening_;
      }
      /**
       * <code>optional bool support_listening = 2;</code>
       */
      public Builder setSupportListening(boolean value) {
        bitField0_ |= 0x00000002;
        supportListening_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool support_listening = 2;</code>
       */
      public Builder clearSupportListening() {
        bitField0_ = (bitField0_ & ~0x00000002);
        supportListening_ = false;
        onChanged();
        return this;
      }

      // optional int32 rpc_version = 3;
      private int rpcVersion_ ;
      /**
       * <code>optional int32 rpc_version = 3;</code>
       */
      public boolean hasRpcVersion() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional int32 rpc_version = 3;</code>
       */
      public int getRpcVersion() {
        return rpcVersion_;
      }
      /**
       * <code>optional int32 rpc_version = 3;</code>
       */
      public Builder setRpcVersion(int value) {
        bitField0_ |= 0x00000004;
        rpcVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 rpc_version = 3;</code>
       */
      public Builder clearRpcVersion() {
        bitField0_ = (bitField0_ & ~0x00000004);
        rpcVersion_ = 0;
        onChanged();
        return this;
      }

      // optional .exec.shared.UserCredentials credentials = 4;
      private org.apache.drill.exec.proto.UserBitShared.UserCredentials credentials_ = org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.UserCredentials, org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder, org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder> credentialsBuilder_;
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public boolean hasCredentials() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.UserCredentials getCredentials() {
        if (credentialsBuilder_ == null) {
          return credentials_;
        } else {
          return credentialsBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public Builder setCredentials(org.apache.drill.exec.proto.UserBitShared.UserCredentials value) {
        if (credentialsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          credentials_ = value;
          onChanged();
        } else {
          credentialsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public Builder setCredentials(
          org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder builderForValue) {
        if (credentialsBuilder_ == null) {
          credentials_ = builderForValue.build();
          onChanged();
        } else {
          credentialsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public Builder mergeCredentials(org.apache.drill.exec.proto.UserBitShared.UserCredentials value) {
        if (credentialsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008) &&
              credentials_ != org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance()) {
            credentials_ =
              org.apache.drill.exec.proto.UserBitShared.UserCredentials.newBuilder(credentials_).mergeFrom(value).buildPartial();
          } else {
            credentials_ = value;
          }
          onChanged();
        } else {
          credentialsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public Builder clearCredentials() {
        if (credentialsBuilder_ == null) {
          credentials_ = org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance();
          onChanged();
        } else {
          credentialsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder getCredentialsBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getCredentialsFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder getCredentialsOrBuilder() {
        if (credentialsBuilder_ != null) {
          return credentialsBuilder_.getMessageOrBuilder();
        } else {
          return credentials_;
        }
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.UserCredentials, org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder, org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder> 
          getCredentialsFieldBuilder() {
        if (credentialsBuilder_ == null) {
          credentialsBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserBitShared.UserCredentials, org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder, org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder>(
                  credentials_,
                  getParentForChildren(),
                  isClean());
          credentials_ = null;
        }
        return credentialsBuilder_;
      }

      // optional .exec.user.UserProperties properties = 5;
      private org.apache.drill.exec.proto.UserProtos.UserProperties properties_ = org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.UserProperties, org.apache.drill.exec.proto.UserProtos.UserProperties.Builder, org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder> propertiesBuilder_;
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public boolean hasProperties() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.UserProperties getProperties() {
        if (propertiesBuilder_ == null) {
          return properties_;
        } else {
          return propertiesBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public Builder setProperties(org.apache.drill.exec.proto.UserProtos.UserProperties value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          properties_ = value;
          onChanged();
        } else {
          propertiesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public Builder setProperties(
          org.apache.drill.exec.proto.UserProtos.UserProperties.Builder builderForValue) {
        if (propertiesBuilder_ == null) {
          properties_ = builderForValue.build();
          onChanged();
        } else {
          propertiesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public Builder mergeProperties(org.apache.drill.exec.proto.UserProtos.UserProperties value) {
        if (propertiesBuilder_ == null) {
          if (((bitField0_ & 0x00000010) == 0x00000010) &&
              properties_ != org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance()) {
            properties_ =
              org.apache.drill.exec.proto.UserProtos.UserProperties.newBuilder(properties_).mergeFrom(value).buildPartial();
          } else {
            properties_ = value;
          }
          onChanged();
        } else {
          propertiesBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public Builder clearProperties() {
        if (propertiesBuilder_ == null) {
          properties_ = org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance();
          onChanged();
        } else {
          propertiesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.UserProperties.Builder getPropertiesBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getPropertiesFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder getPropertiesOrBuilder() {
        if (propertiesBuilder_ != null) {
          return propertiesBuilder_.getMessageOrBuilder();
        } else {
          return properties_;
        }
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.UserProperties, org.apache.drill.exec.proto.UserProtos.UserProperties.Builder, org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder> 
          getPropertiesFieldBuilder() {
        if (propertiesBuilder_ == null) {
          propertiesBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.UserProperties, org.apache.drill.exec.proto.UserProtos.UserProperties.Builder, org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder>(
                  properties_,
                  getParentForChildren(),
                  isClean());
          properties_ = null;
        }
        return propertiesBuilder_;
      }

      // optional bool support_complex_types = 6 [default = false];
      private boolean supportComplexTypes_ ;
      /**
       * <code>optional bool support_complex_types = 6 [default = false];</code>
       */
      public boolean hasSupportComplexTypes() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional bool support_complex_types = 6 [default = false];</code>
       */
      public boolean getSupportComplexTypes() {
        return supportComplexTypes_;
      }
      /**
       * <code>optional bool support_complex_types = 6 [default = false];</code>
       */
      public Builder setSupportComplexTypes(boolean value) {
        bitField0_ |= 0x00000020;
        supportComplexTypes_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool support_complex_types = 6 [default = false];</code>
       */
      public Builder clearSupportComplexTypes() {
        bitField0_ = (bitField0_ & ~0x00000020);
        supportComplexTypes_ = false;
        onChanged();
        return this;
      }

      // optional bool support_timeout = 7 [default = false];
      private boolean supportTimeout_ ;
      /**
       * <code>optional bool support_timeout = 7 [default = false];</code>
       */
      public boolean hasSupportTimeout() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional bool support_timeout = 7 [default = false];</code>
       */
      public boolean getSupportTimeout() {
        return supportTimeout_;
      }
      /**
       * <code>optional bool support_timeout = 7 [default = false];</code>
       */
      public Builder setSupportTimeout(boolean value) {
        bitField0_ |= 0x00000040;
        supportTimeout_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool support_timeout = 7 [default = false];</code>
       */
      public Builder clearSupportTimeout() {
        bitField0_ = (bitField0_ & ~0x00000040);
        supportTimeout_ = false;
        onChanged();
        return this;
      }

      // optional .exec.user.RpcEndpointInfos client_infos = 8;
      private org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos clientInfos_ = org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder> clientInfosBuilder_;
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       */
      public boolean hasClientInfos() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos getClientInfos() {
        if (clientInfosBuilder_ == null) {
          return clientInfos_;
        } else {
          return clientInfosBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       */
      public Builder setClientInfos(org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos value) {
        if (clientInfosBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          clientInfos_ = value;
          onChanged();
        } else {
          clientInfosBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       */
      public Builder setClientInfos(
          org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder builderForValue) {
        if (clientInfosBuilder_ == null) {
          clientInfos_ = builderForValue.build();
          onChanged();
        } else {
          clientInfosBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       */
      public Builder mergeClientInfos(org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos value) {
        if (clientInfosBuilder_ == null) {
          if (((bitField0_ & 0x00000080) == 0x00000080) &&
              clientInfos_ != org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance()) {
            clientInfos_ =
              org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.newBuilder(clientInfos_).mergeFrom(value).buildPartial();
          } else {
            clientInfos_ = value;
          }
          onChanged();
        } else {
          clientInfosBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       */
      public Builder clearClientInfos() {
        if (clientInfosBuilder_ == null) {
          clientInfos_ = org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance();
          onChanged();
        } else {
          clientInfosBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000080);
        return this;
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder getClientInfosBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getClientInfosFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder getClientInfosOrBuilder() {
        if (clientInfosBuilder_ != null) {
          return clientInfosBuilder_.getMessageOrBuilder();
        } else {
          return clientInfos_;
        }
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder> 
          getClientInfosFieldBuilder() {
        if (clientInfosBuilder_ == null) {
          clientInfosBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder>(
                  clientInfos_,
                  getParentForChildren(),
                  isClean());
          clientInfos_ = null;
        }
        return clientInfosBuilder_;
      }

      // optional .exec.user.SaslSupport sasl_support = 9;
      private org.apache.drill.exec.proto.UserProtos.SaslSupport saslSupport_ = org.apache.drill.exec.proto.UserProtos.SaslSupport.UNKNOWN_SASL_SUPPORT;
      /**
       * <code>optional .exec.user.SaslSupport sasl_support = 9;</code>
       */
      public boolean hasSaslSupport() {
        return ((bitField0_ & 0x00000100) == 0x00000100);
      }
      /**
       * <code>optional .exec.user.SaslSupport sasl_support = 9;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.SaslSupport getSaslSupport() {
        return saslSupport_;
      }
      /**
       * <code>optional .exec.user.SaslSupport sasl_support = 9;</code>
       */
      public Builder setSaslSupport(org.apache.drill.exec.proto.UserProtos.SaslSupport value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000100;
        saslSupport_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.user.SaslSupport sasl_support = 9;</code>
       */
      public Builder clearSaslSupport() {
        bitField0_ = (bitField0_ & ~0x00000100);
        saslSupport_ = org.apache.drill.exec.proto.UserProtos.SaslSupport.UNKNOWN_SASL_SUPPORT;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.UserToBitHandshake)
    }

    static {
      defaultInstance = new UserToBitHandshake(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.UserToBitHandshake)
  }

  public interface RequestResultsOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.shared.QueryId query_id = 1;
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    boolean hasQueryId();
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId();
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder();

    // optional int32 maximum_responses = 2;
    /**
     * <code>optional int32 maximum_responses = 2;</code>
     */
    boolean hasMaximumResponses();
    /**
     * <code>optional int32 maximum_responses = 2;</code>
     */
    int getMaximumResponses();
  }
  /**
   * Protobuf type {@code exec.user.RequestResults}
   */
  public static final class RequestResults extends
      com.google.protobuf.GeneratedMessage
      implements RequestResultsOrBuilder {
    // Use RequestResults.newBuilder() to construct.
    private RequestResults(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private RequestResults(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final RequestResults defaultInstance;
    public static RequestResults getDefaultInstance() {
      return defaultInstance;
    }

    public RequestResults getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private RequestResults(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              org.apache.drill.exec.proto.UserBitShared.QueryId.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = queryId_.toBuilder();
              }
              queryId_ = input.readMessage(org.apache.drill.exec.proto.UserBitShared.QueryId.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(queryId_);
                queryId_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              maximumResponses_ = input.readInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RequestResults_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RequestResults_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.RequestResults.class, org.apache.drill.exec.proto.UserProtos.RequestResults.Builder.class);
    }

    public static com.google.protobuf.Parser<RequestResults> PARSER =
        new com.google.protobuf.AbstractParser<RequestResults>() {
      public RequestResults parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new RequestResults(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<RequestResults> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.shared.QueryId query_id = 1;
    public static final int QUERY_ID_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserBitShared.QueryId queryId_;
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    public boolean hasQueryId() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId() {
      return queryId_;
    }
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder() {
      return queryId_;
    }

    // optional int32 maximum_responses = 2;
    public static final int MAXIMUM_RESPONSES_FIELD_NUMBER = 2;
    private int maximumResponses_;
    /**
     * <code>optional int32 maximum_responses = 2;</code>
     */
    public boolean hasMaximumResponses() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional int32 maximum_responses = 2;</code>
     */
    public int getMaximumResponses() {
      return maximumResponses_;
    }

    private void initFields() {
      queryId_ = org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance();
      maximumResponses_ = 0;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, queryId_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeInt32(2, maximumResponses_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, queryId_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(2, maximumResponses_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.RequestResults prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.RequestResults}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.RequestResultsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RequestResults_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RequestResults_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.RequestResults.class, org.apache.drill.exec.proto.UserProtos.RequestResults.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.RequestResults.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getQueryIdFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (queryIdBuilder_ == null) {
          queryId_ = org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance();
        } else {
          queryIdBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        maximumResponses_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RequestResults_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.RequestResults getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.RequestResults.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.RequestResults build() {
        org.apache.drill.exec.proto.UserProtos.RequestResults result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.RequestResults buildPartial() {
        org.apache.drill.exec.proto.UserProtos.RequestResults result = new org.apache.drill.exec.proto.UserProtos.RequestResults(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (queryIdBuilder_ == null) {
          result.queryId_ = queryId_;
        } else {
          result.queryId_ = queryIdBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.maximumResponses_ = maximumResponses_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.RequestResults) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.RequestResults)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.RequestResults other) {
        if (other == org.apache.drill.exec.proto.UserProtos.RequestResults.getDefaultInstance()) return this;
        if (other.hasQueryId()) {
          mergeQueryId(other.getQueryId());
        }
        if (other.hasMaximumResponses()) {
          setMaximumResponses(other.getMaximumResponses());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.RequestResults parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.RequestResults) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.shared.QueryId query_id = 1;
      private org.apache.drill.exec.proto.UserBitShared.QueryId queryId_ = org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder> queryIdBuilder_;
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public boolean hasQueryId() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId() {
        if (queryIdBuilder_ == null) {
          return queryId_;
        } else {
          return queryIdBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder setQueryId(org.apache.drill.exec.proto.UserBitShared.QueryId value) {
        if (queryIdBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          queryId_ = value;
          onChanged();
        } else {
          queryIdBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder setQueryId(
          org.apache.drill.exec.proto.UserBitShared.QueryId.Builder builderForValue) {
        if (queryIdBuilder_ == null) {
          queryId_ = builderForValue.build();
          onChanged();
        } else {
          queryIdBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder mergeQueryId(org.apache.drill.exec.proto.UserBitShared.QueryId value) {
        if (queryIdBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              queryId_ != org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance()) {
            queryId_ =
              org.apache.drill.exec.proto.UserBitShared.QueryId.newBuilder(queryId_).mergeFrom(value).buildPartial();
          } else {
            queryId_ = value;
          }
          onChanged();
        } else {
          queryIdBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder clearQueryId() {
        if (queryIdBuilder_ == null) {
          queryId_ = org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance();
          onChanged();
        } else {
          queryIdBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryId.Builder getQueryIdBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getQueryIdFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder() {
        if (queryIdBuilder_ != null) {
          return queryIdBuilder_.getMessageOrBuilder();
        } else {
          return queryId_;
        }
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder> 
          getQueryIdFieldBuilder() {
        if (queryIdBuilder_ == null) {
          queryIdBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder>(
                  queryId_,
                  getParentForChildren(),
                  isClean());
          queryId_ = null;
        }
        return queryIdBuilder_;
      }

      // optional int32 maximum_responses = 2;
      private int maximumResponses_ ;
      /**
       * <code>optional int32 maximum_responses = 2;</code>
       */
      public boolean hasMaximumResponses() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional int32 maximum_responses = 2;</code>
       */
      public int getMaximumResponses() {
        return maximumResponses_;
      }
      /**
       * <code>optional int32 maximum_responses = 2;</code>
       */
      public Builder setMaximumResponses(int value) {
        bitField0_ |= 0x00000002;
        maximumResponses_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 maximum_responses = 2;</code>
       */
      public Builder clearMaximumResponses() {
        bitField0_ = (bitField0_ & ~0x00000002);
        maximumResponses_ = 0;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.RequestResults)
    }

    static {
      defaultInstance = new RequestResults(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.RequestResults)
  }

  public interface GetQueryPlanFragmentsOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // required string query = 1;
    /**
     * <code>required string query = 1;</code>
     */
    boolean hasQuery();
    /**
     * <code>required string query = 1;</code>
     */
    java.lang.String getQuery();
    /**
     * <code>required string query = 1;</code>
     */
    com.google.protobuf.ByteString
        getQueryBytes();

    // optional .exec.shared.QueryType type = 2;
    /**
     * <code>optional .exec.shared.QueryType type = 2;</code>
     */
    boolean hasType();
    /**
     * <code>optional .exec.shared.QueryType type = 2;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.QueryType getType();

    // optional bool split_plan = 3 [default = false];
    /**
     * <code>optional bool split_plan = 3 [default = false];</code>
     */
    boolean hasSplitPlan();
    /**
     * <code>optional bool split_plan = 3 [default = false];</code>
     */
    boolean getSplitPlan();
  }
  /**
   * Protobuf type {@code exec.user.GetQueryPlanFragments}
   */
  public static final class GetQueryPlanFragments extends
      com.google.protobuf.GeneratedMessage
      implements GetQueryPlanFragmentsOrBuilder {
    // Use GetQueryPlanFragments.newBuilder() to construct.
    private GetQueryPlanFragments(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private GetQueryPlanFragments(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final GetQueryPlanFragments defaultInstance;
    public static GetQueryPlanFragments getDefaultInstance() {
      return defaultInstance;
    }

    public GetQueryPlanFragments getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private GetQueryPlanFragments(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              query_ = input.readBytes();
              break;
            }
            case 16: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.UserBitShared.QueryType value = org.apache.drill.exec.proto.UserBitShared.QueryType.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(2, rawValue);
              } else {
                bitField0_ |= 0x00000002;
                type_ = value;
              }
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              splitPlan_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetQueryPlanFragments_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetQueryPlanFragments_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments.class, org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments.Builder.class);
    }

    public static com.google.protobuf.Parser<GetQueryPlanFragments> PARSER =
        new com.google.protobuf.AbstractParser<GetQueryPlanFragments>() {
      public GetQueryPlanFragments parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new GetQueryPlanFragments(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<GetQueryPlanFragments> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // required string query = 1;
    public static final int QUERY_FIELD_NUMBER = 1;
    private java.lang.Object query_;
    /**
     * <code>required string query = 1;</code>
     */
    public boolean hasQuery() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string query = 1;</code>
     */
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          query_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string query = 1;</code>
     */
    public com.google.protobuf.ByteString
        getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional .exec.shared.QueryType type = 2;
    public static final int TYPE_FIELD_NUMBER = 2;
    private org.apache.drill.exec.proto.UserBitShared.QueryType type_;
    /**
     * <code>optional .exec.shared.QueryType type = 2;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .exec.shared.QueryType type = 2;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.QueryType getType() {
      return type_;
    }

    // optional bool split_plan = 3 [default = false];
    public static final int SPLIT_PLAN_FIELD_NUMBER = 3;
    private boolean splitPlan_;
    /**
     * <code>optional bool split_plan = 3 [default = false];</code>
     */
    public boolean hasSplitPlan() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional bool split_plan = 3 [default = false];</code>
     */
    public boolean getSplitPlan() {
      return splitPlan_;
    }

    private void initFields() {
      query_ = "";
      type_ = org.apache.drill.exec.proto.UserBitShared.QueryType.SQL;
      splitPlan_ = false;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      if (!hasQuery()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getQueryBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeEnum(2, type_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBool(3, splitPlan_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getQueryBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, type_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(3, splitPlan_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.GetQueryPlanFragments}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragmentsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetQueryPlanFragments_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetQueryPlanFragments_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments.class, org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        query_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = org.apache.drill.exec.proto.UserBitShared.QueryType.SQL;
        bitField0_ = (bitField0_ & ~0x00000002);
        splitPlan_ = false;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetQueryPlanFragments_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments build() {
        org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments result = new org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.query_ = query_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.splitPlan_ = splitPlan_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments.getDefaultInstance()) return this;
        if (other.hasQuery()) {
          bitField0_ |= 0x00000001;
          query_ = other.query_;
          onChanged();
        }
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasSplitPlan()) {
          setSplitPlan(other.getSplitPlan());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasQuery()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // required string query = 1;
      private java.lang.Object query_ = "";
      /**
       * <code>required string query = 1;</code>
       */
      public boolean hasQuery() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string query = 1;</code>
       */
      public java.lang.String getQuery() {
        java.lang.Object ref = query_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          query_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string query = 1;</code>
       */
      public com.google.protobuf.ByteString
          getQueryBytes() {
        java.lang.Object ref = query_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          query_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string query = 1;</code>
       */
      public Builder setQuery(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        query_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string query = 1;</code>
       */
      public Builder clearQuery() {
        bitField0_ = (bitField0_ & ~0x00000001);
        query_ = getDefaultInstance().getQuery();
        onChanged();
        return this;
      }
      /**
       * <code>required string query = 1;</code>
       */
      public Builder setQueryBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        query_ = value;
        onChanged();
        return this;
      }

      // optional .exec.shared.QueryType type = 2;
      private org.apache.drill.exec.proto.UserBitShared.QueryType type_ = org.apache.drill.exec.proto.UserBitShared.QueryType.SQL;
      /**
       * <code>optional .exec.shared.QueryType type = 2;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .exec.shared.QueryType type = 2;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryType getType() {
        return type_;
      }
      /**
       * <code>optional .exec.shared.QueryType type = 2;</code>
       */
      public Builder setType(org.apache.drill.exec.proto.UserBitShared.QueryType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryType type = 2;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000002);
        type_ = org.apache.drill.exec.proto.UserBitShared.QueryType.SQL;
        onChanged();
        return this;
      }

      // optional bool split_plan = 3 [default = false];
      private boolean splitPlan_ ;
      /**
       * <code>optional bool split_plan = 3 [default = false];</code>
       */
      public boolean hasSplitPlan() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional bool split_plan = 3 [default = false];</code>
       */
      public boolean getSplitPlan() {
        return splitPlan_;
      }
      /**
       * <code>optional bool split_plan = 3 [default = false];</code>
       */
      public Builder setSplitPlan(boolean value) {
        bitField0_ |= 0x00000004;
        splitPlan_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool split_plan = 3 [default = false];</code>
       */
      public Builder clearSplitPlan() {
        bitField0_ = (bitField0_ & ~0x00000004);
        splitPlan_ = false;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.GetQueryPlanFragments)
    }

    static {
      defaultInstance = new GetQueryPlanFragments(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetQueryPlanFragments)
  }

  public interface QueryPlanFragmentsOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // required .exec.shared.QueryResult.QueryState status = 1;
    /**
     * <code>required .exec.shared.QueryResult.QueryState status = 1;</code>
     */
    boolean hasStatus();
    /**
     * <code>required .exec.shared.QueryResult.QueryState status = 1;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState getStatus();

    // optional .exec.shared.QueryId query_id = 2;
    /**
     * <code>optional .exec.shared.QueryId query_id = 2;</code>
     */
    boolean hasQueryId();
    /**
     * <code>optional .exec.shared.QueryId query_id = 2;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId();
    /**
     * <code>optional .exec.shared.QueryId query_id = 2;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder();

    // repeated .exec.bit.control.PlanFragment fragments = 3;
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment> 
        getFragmentsList();
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    org.apache.drill.exec.proto.BitControl.PlanFragment getFragments(int index);
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    int getFragmentsCount();
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    java.util.List<? extends org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder> 
        getFragmentsOrBuilderList();
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder getFragmentsOrBuilder(
        int index);

    // optional .exec.shared.DrillPBError error = 4;
    /**
     * <code>optional .exec.shared.DrillPBError error = 4;</code>
     */
    boolean hasError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 4;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBError getError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 4;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder();
  }
  /**
   * Protobuf type {@code exec.user.QueryPlanFragments}
   */
  public static final class QueryPlanFragments extends
      com.google.protobuf.GeneratedMessage
      implements QueryPlanFragmentsOrBuilder {
    // Use QueryPlanFragments.newBuilder() to construct.
    private QueryPlanFragments(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private QueryPlanFragments(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final QueryPlanFragments defaultInstance;
    public static QueryPlanFragments getDefaultInstance() {
      return defaultInstance;
    }

    public QueryPlanFragments getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private QueryPlanFragments(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState value = org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                status_ = value;
              }
              break;
            }
            case 18: {
              org.apache.drill.exec.proto.UserBitShared.QueryId.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = queryId_.toBuilder();
              }
              queryId_ = input.readMessage(org.apache.drill.exec.proto.UserBitShared.QueryId.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(queryId_);
                queryId_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
            case 26: {
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                fragments_ = new java.util.ArrayList<org.apache.drill.exec.proto.BitControl.PlanFragment>();
                mutable_bitField0_ |= 0x00000004;
              }
              fragments_.add(input.readMessage(org.apache.drill.exec.proto.BitControl.PlanFragment.PARSER, extensionRegistry));
              break;
            }
            case 34: {
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder subBuilder = null;
              if (((bitField0_ & 0x00000004) == 0x00000004)) {
                subBuilder = error_.toBuilder();
              }
              error_ = input.readMessage(org.apache.drill.exec.proto.UserBitShared.DrillPBError.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(error_);
                error_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000004;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          fragments_ = java.util.Collections.unmodifiableList(fragments_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_QueryPlanFragments_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_QueryPlanFragments_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.QueryPlanFragments.class, org.apache.drill.exec.proto.UserProtos.QueryPlanFragments.Builder.class);
    }

    public static com.google.protobuf.Parser<QueryPlanFragments> PARSER =
        new com.google.protobuf.AbstractParser<QueryPlanFragments>() {
      public QueryPlanFragments parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new QueryPlanFragments(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<QueryPlanFragments> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // required .exec.shared.QueryResult.QueryState status = 1;
    public static final int STATUS_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState status_;
    /**
     * <code>required .exec.shared.QueryResult.QueryState status = 1;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .exec.shared.QueryResult.QueryState status = 1;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState getStatus() {
      return status_;
    }

    // optional .exec.shared.QueryId query_id = 2;
    public static final int QUERY_ID_FIELD_NUMBER = 2;
    private org.apache.drill.exec.proto.UserBitShared.QueryId queryId_;
    /**
     * <code>optional .exec.shared.QueryId query_id = 2;</code>
     */
    public boolean hasQueryId() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .exec.shared.QueryId query_id = 2;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId() {
      return queryId_;
    }
    /**
     * <code>optional .exec.shared.QueryId query_id = 2;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder() {
      return queryId_;
    }

    // repeated .exec.bit.control.PlanFragment fragments = 3;
    public static final int FRAGMENTS_FIELD_NUMBER = 3;
    private java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment> fragments_;
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    public java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment> getFragmentsList() {
      return fragments_;
    }
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    public java.util.List<? extends org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder> 
        getFragmentsOrBuilderList() {
      return fragments_;
    }
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    public int getFragmentsCount() {
      return fragments_.size();
    }
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    public org.apache.drill.exec.proto.BitControl.PlanFragment getFragments(int index) {
      return fragments_.get(index);
    }
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    public org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder getFragmentsOrBuilder(
        int index) {
      return fragments_.get(index);
    }

    // optional .exec.shared.DrillPBError error = 4;
    public static final int ERROR_FIELD_NUMBER = 4;
    private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_;
    /**
     * <code>optional .exec.shared.DrillPBError error = 4;</code>
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 4;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
      return error_;
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 4;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
      return error_;
    }

    private void initFields() {
      status_ = org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState.STARTING;
      queryId_ = org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance();
      fragments_ = java.util.Collections.emptyList();
      error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      if (!hasStatus()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, status_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, queryId_);
      }
      for (int i = 0; i < fragments_.size(); i++) {
        output.writeMessage(3, fragments_.get(i));
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(4, error_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, status_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, queryId_);
      }
      for (int i = 0; i < fragments_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, fragments_.get(i));
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, error_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.QueryPlanFragments prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.QueryPlanFragments}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.QueryPlanFragmentsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_QueryPlanFragments_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_QueryPlanFragments_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.QueryPlanFragments.class, org.apache.drill.exec.proto.UserProtos.QueryPlanFragments.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.QueryPlanFragments.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getQueryIdFieldBuilder();
          getFragmentsFieldBuilder();
          getErrorFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        status_ = org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState.STARTING;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (queryIdBuilder_ == null) {
          queryId_ = org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance();
        } else {
          queryIdBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (fragmentsBuilder_ == null) {
          fragments_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          fragmentsBuilder_.clear();
        }
        if (errorBuilder_ == null) {
          error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_QueryPlanFragments_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.QueryPlanFragments getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.QueryPlanFragments.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.QueryPlanFragments build() {
        org.apache.drill.exec.proto.UserProtos.QueryPlanFragments result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.QueryPlanFragments buildPartial() {
        org.apache.drill.exec.proto.UserProtos.QueryPlanFragments result = new org.apache.drill.exec.proto.UserProtos.QueryPlanFragments(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.status_ = status_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (queryIdBuilder_ == null) {
          result.queryId_ = queryId_;
        } else {
          result.queryId_ = queryIdBuilder_.build();
        }
        if (fragmentsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)) {
            fragments_ = java.util.Collections.unmodifiableList(fragments_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.fragments_ = fragments_;
        } else {
          result.fragments_ = fragmentsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000004;
        }
        if (errorBuilder_ == null) {
          result.error_ = error_;
        } else {
          result.error_ = errorBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.QueryPlanFragments) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.QueryPlanFragments)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.QueryPlanFragments other) {
        if (other == org.apache.drill.exec.proto.UserProtos.QueryPlanFragments.getDefaultInstance()) return this;
        if (other.hasStatus()) {
          setStatus(other.getStatus());
        }
        if (other.hasQueryId()) {
          mergeQueryId(other.getQueryId());
        }
        if (fragmentsBuilder_ == null) {
          if (!other.fragments_.isEmpty()) {
            if (fragments_.isEmpty()) {
              fragments_ = other.fragments_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureFragmentsIsMutable();
              fragments_.addAll(other.fragments_);
            }
            onChanged();
          }
        } else {
          if (!other.fragments_.isEmpty()) {
            if (fragmentsBuilder_.isEmpty()) {
              fragmentsBuilder_.dispose();
              fragmentsBuilder_ = null;
              fragments_ = other.fragments_;
              bitField0_ = (bitField0_ & ~0x00000004);
              fragmentsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getFragmentsFieldBuilder() : null;
            } else {
              fragmentsBuilder_.addAllMessages(other.fragments_);
            }
          }
        }
        if (other.hasError()) {
          mergeError(other.getError());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasStatus()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.QueryPlanFragments) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // required .exec.shared.QueryResult.QueryState status = 1;
      private org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState status_ = org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState.STARTING;
      /**
       * <code>required .exec.shared.QueryResult.QueryState status = 1;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .exec.shared.QueryResult.QueryState status = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState getStatus() {
        return status_;
      }
      /**
       * <code>required .exec.shared.QueryResult.QueryState status = 1;</code>
       */
      public Builder setStatus(org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        status_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required .exec.shared.QueryResult.QueryState status = 1;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState.STARTING;
        onChanged();
        return this;
      }

      // optional .exec.shared.QueryId query_id = 2;
      private org.apache.drill.exec.proto.UserBitShared.QueryId queryId_ = org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder> queryIdBuilder_;
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       */
      public boolean hasQueryId() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId() {
        if (queryIdBuilder_ == null) {
          return queryId_;
        } else {
          return queryIdBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       */
      public Builder setQueryId(org.apache.drill.exec.proto.UserBitShared.QueryId value) {
        if (queryIdBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          queryId_ = value;
          onChanged();
        } else {
          queryIdBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       */
      public Builder setQueryId(
          org.apache.drill.exec.proto.UserBitShared.QueryId.Builder builderForValue) {
        if (queryIdBuilder_ == null) {
          queryId_ = builderForValue.build();
          onChanged();
        } else {
          queryIdBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       */
      public Builder mergeQueryId(org.apache.drill.exec.proto.UserBitShared.QueryId value) {
        if (queryIdBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002) &&
              queryId_ != org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance()) {
            queryId_ =
              org.apache.drill.exec.proto.UserBitShared.QueryId.newBuilder(queryId_).mergeFrom(value).buildPartial();
          } else {
            queryId_ = value;
          }
          onChanged();
        } else {
          queryIdBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       */
      public Builder clearQueryId() {
        if (queryIdBuilder_ == null) {
          queryId_ = org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance();
          onChanged();
        } else {
          queryIdBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryId.Builder getQueryIdBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getQueryIdFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder() {
        if (queryIdBuilder_ != null) {
          return queryIdBuilder_.getMessageOrBuilder();
        } else {
          return queryId_;
        }
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder> 
          getQueryIdFieldBuilder() {
        if (queryIdBuilder_ == null) {
          queryIdBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder>(
                  queryId_,
                  getParentForChildren(),
                  isClean());
          queryId_ = null;
        }
        return queryIdBuilder_;
      }

      // repeated .exec.bit.control.PlanFragment fragments = 3;
      private java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment> fragments_ =
        java.util.Collections.emptyList();
      private void ensureFragmentsIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          fragments_ = new java.util.ArrayList<org.apache.drill.exec.proto.BitControl.PlanFragment>(fragments_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.BitControl.PlanFragment, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder, org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder> fragmentsBuilder_;

      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment> getFragmentsList() {
        if (fragmentsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(fragments_);
        } else {
          return fragmentsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public int getFragmentsCount() {
        if (fragmentsBuilder_ == null) {
          return fragments_.size();
        } else {
          return fragmentsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public org.apache.drill.exec.proto.BitControl.PlanFragment getFragments(int index) {
        if (fragmentsBuilder_ == null) {
          return fragments_.get(index);
        } else {
          return fragmentsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder setFragments(
          int index, org.apache.drill.exec.proto.BitControl.PlanFragment value) {
        if (fragmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFragmentsIsMutable();
          fragments_.set(index, value);
          onChanged();
        } else {
          fragmentsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder setFragments(
          int index, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder builderForValue) {
        if (fragmentsBuilder_ == null) {
          ensureFragmentsIsMutable();
          fragments_.set(index, builderForValue.build());
          onChanged();
        } else {
          fragmentsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder addFragments(org.apache.drill.exec.proto.BitControl.PlanFragment value) {
        if (fragmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFragmentsIsMutable();
          fragments_.add(value);
          onChanged();
        } else {
          fragmentsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder addFragments(
          int index, org.apache.drill.exec.proto.BitControl.PlanFragment value) {
        if (fragmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFragmentsIsMutable();
          fragments_.add(index, value);
          onChanged();
        } else {
          fragmentsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder addFragments(
          org.apache.drill.exec.proto.BitControl.PlanFragment.Builder builderForValue) {
        if (fragmentsBuilder_ == null) {
          ensureFragmentsIsMutable();
          fragments_.add(builderForValue.build());
          onChanged();
        } else {
          fragmentsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder addFragments(
          int index, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder builderForValue) {
        if (fragmentsBuilder_ == null) {
          ensureFragmentsIsMutable();
          fragments_.add(index, builderForValue.build());
          onChanged();
        } else {
          fragmentsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder addAllFragments(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.BitControl.PlanFragment> values) {
        if (fragmentsBuilder_ == null) {
          ensureFragmentsIsMutable();
          super.addAll(values, fragments_);
          onChanged();
        } else {
          fragmentsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder clearFragments() {
        if (fragmentsBuilder_ == null) {
          fragments_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          fragmentsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder removeFragments(int index) {
        if (fragmentsBuilder_ == null) {
          ensureFragmentsIsMutable();
          fragments_.remove(index);
          onChanged();
        } else {
          fragmentsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public org.apache.drill.exec.proto.BitControl.PlanFragment.Builder getFragmentsBuilder(
          int index) {
        return getFragmentsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder getFragmentsOrBuilder(
          int index) {
        if (fragmentsBuilder_ == null) {
          return fragments_.get(index);  } else {
          return fragmentsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public java.util.List<? extends org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder> 
           getFragmentsOrBuilderList() {
        if (fragmentsBuilder_ != null) {
          return fragmentsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(fragments_);
        }
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public org.apache.drill.exec.proto.BitControl.PlanFragment.Builder addFragmentsBuilder() {
        return getFragmentsFieldBuilder().addBuilder(
            org.apache.drill.exec.proto.BitControl.PlanFragment.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public org.apache.drill.exec.proto.BitControl.PlanFragment.Builder addFragmentsBuilder(
          int index) {
        return getFragmentsFieldBuilder().addBuilder(
            index, org.apache.drill.exec.proto.BitControl.PlanFragment.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment.Builder> 
           getFragmentsBuilderList() {
        return getFragmentsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.BitControl.PlanFragment, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder, org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder> 
          getFragmentsFieldBuilder() {
        if (fragmentsBuilder_ == null) {
          fragmentsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.drill.exec.proto.BitControl.PlanFragment, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder, org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder>(
                  fragments_,
                  ((bitField0_ & 0x00000004) == 0x00000004),
                  getParentForChildren(),
                  isClean());
          fragments_ = null;
        }
        return fragmentsBuilder_;
      }

      // optional .exec.shared.DrillPBError error = 4;
      private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> errorBuilder_;
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       */
      public boolean hasError() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
        if (errorBuilder_ == null) {
          return error_;
        } else {
          return errorBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       */
      public Builder setError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          error_ = value;
          onChanged();
        } else {
          errorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       */
      public Builder setError(
          org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder builderForValue) {
        if (errorBuilder_ == null) {
          error_ = builderForValue.build();
          onChanged();
        } else {
          errorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       */
      public Builder mergeError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008) &&
              error_ != org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance()) {
            error_ =
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.newBuilder(error_).mergeFrom(value).buildPartial();
          } else {
            error_ = value;
          }
          onChanged();
        } else {
          errorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       */
      public Builder clearError() {
        if (errorBuilder_ == null) {
          error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
          onChanged();
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder getErrorBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getErrorFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
        if (errorBuilder_ != null) {
          return errorBuilder_.getMessageOrBuilder();
        } else {
          return error_;
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> 
          getErrorFieldBuilder() {
        if (errorBuilder_ == null) {
          errorBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder>(
                  error_,
                  getParentForChildren(),
                  isClean());
          error_ = null;
        }
        return errorBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.QueryPlanFragments)
    }

    static {
      defaultInstance = new QueryPlanFragments(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.QueryPlanFragments)
  }

  public interface BitToUserHandshakeOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional int32 rpc_version = 2;
    /**
     * <code>optional int32 rpc_version = 2;</code>
     */
    boolean hasRpcVersion();
    /**
     * <code>optional int32 rpc_version = 2;</code>
     */
    int getRpcVersion();

    // optional .exec.user.HandshakeStatus status = 3;
    /**
     * <code>optional .exec.user.HandshakeStatus status = 3;</code>
     */
    boolean hasStatus();
    /**
     * <code>optional .exec.user.HandshakeStatus status = 3;</code>
     */
    org.apache.drill.exec.proto.UserProtos.HandshakeStatus getStatus();

    // optional string errorId = 4;
    /**
     * <code>optional string errorId = 4;</code>
     */
    boolean hasErrorId();
    /**
     * <code>optional string errorId = 4;</code>
     */
    java.lang.String getErrorId();
    /**
     * <code>optional string errorId = 4;</code>
     */
    com.google.protobuf.ByteString
        getErrorIdBytes();

    // optional string errorMessage = 5;
    /**
     * <code>optional string errorMessage = 5;</code>
     */
    boolean hasErrorMessage();
    /**
     * <code>optional string errorMessage = 5;</code>
     */
    java.lang.String getErrorMessage();
    /**
     * <code>optional string errorMessage = 5;</code>
     */
    com.google.protobuf.ByteString
        getErrorMessageBytes();

    // optional .exec.user.RpcEndpointInfos server_infos = 6;
    /**
     * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
     */
    boolean hasServerInfos();
    /**
     * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
     */
    org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos getServerInfos();
    /**
     * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
     */
    org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder getServerInfosOrBuilder();

    // repeated string authenticationMechanisms = 7;
    /**
     * <code>repeated string authenticationMechanisms = 7;</code>
     */
    java.util.List<java.lang.String>
    getAuthenticationMechanismsList();
    /**
     * <code>repeated string authenticationMechanisms = 7;</code>
     */
    int getAuthenticationMechanismsCount();
    /**
     * <code>repeated string authenticationMechanisms = 7;</code>
     */
    java.lang.String getAuthenticationMechanisms(int index);
    /**
     * <code>repeated string authenticationMechanisms = 7;</code>
     */
    com.google.protobuf.ByteString
        getAuthenticationMechanismsBytes(int index);

    // repeated .exec.user.RpcType supported_methods = 8;
    /**
     * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
     */
    java.util.List<org.apache.drill.exec.proto.UserProtos.RpcType> getSupportedMethodsList();
    /**
     * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
     */
    int getSupportedMethodsCount();
    /**
     * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
     */
    org.apache.drill.exec.proto.UserProtos.RpcType getSupportedMethods(int index);

    // optional bool encrypted = 9;
    /**
     * <code>optional bool encrypted = 9;</code>
     */
    boolean hasEncrypted();
    /**
     * <code>optional bool encrypted = 9;</code>
     */
    boolean getEncrypted();

    // optional int32 maxWrappedSize = 10;
    /**
     * <code>optional int32 maxWrappedSize = 10;</code>
     */
    boolean hasMaxWrappedSize();
    /**
     * <code>optional int32 maxWrappedSize = 10;</code>
     */
    int getMaxWrappedSize();
  }
  /**
   * Protobuf type {@code exec.user.BitToUserHandshake}
   */
  public static final class BitToUserHandshake extends
      com.google.protobuf.GeneratedMessage
      implements BitToUserHandshakeOrBuilder {
    // Use BitToUserHandshake.newBuilder() to construct.
    private BitToUserHandshake(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private BitToUserHandshake(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final BitToUserHandshake defaultInstance;
    public static BitToUserHandshake getDefaultInstance() {
      return defaultInstance;
    }

    public BitToUserHandshake getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private BitToUserHandshake(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 16: {
              bitField0_ |= 0x00000001;
              rpcVersion_ = input.readInt32();
              break;
            }
            case 24: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.UserProtos.HandshakeStatus value = org.apache.drill.exec.proto.UserProtos.HandshakeStatus.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(3, rawValue);
              } else {
                bitField0_ |= 0x00000002;
                status_ = value;
              }
              break;
            }
            case 34: {
              bitField0_ |= 0x00000004;
              errorId_ = input.readBytes();
              break;
            }
            case 42: {
              bitField0_ |= 0x00000008;
              errorMessage_ = input.readBytes();
              break;
            }
            case 50: {
              org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder subBuilder = null;
              if (((bitField0_ & 0x00000010) == 0x00000010)) {
                subBuilder = serverInfos_.toBuilder();
              }
              serverInfos_ = input.readMessage(org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(serverInfos_);
                serverInfos_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000010;
              break;
            }
            case 58: {
              if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
                authenticationMechanisms_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000020;
              }
              authenticationMechanisms_.add(input.readBytes());
              break;
            }
            case 64: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.UserProtos.RpcType value = org.apache.drill.exec.proto.UserProtos.RpcType.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(8, rawValue);
              } else {
                if (!((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
                  supportedMethods_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.RpcType>();
                  mutable_bitField0_ |= 0x00000040;
                }
                supportedMethods_.add(value);
              }
              break;
            }
            case 66: {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while(input.getBytesUntilLimit() > 0) {
                int rawValue = input.readEnum();
                org.apache.drill.exec.proto.UserProtos.RpcType value = org.apache.drill.exec.proto.UserProtos.RpcType.valueOf(rawValue);
                if (value == null) {
                  unknownFields.mergeVarintField(8, rawValue);
                } else {
                  if (!((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
                    supportedMethods_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.RpcType>();
                    mutable_bitField0_ |= 0x00000040;
                  }
                  supportedMethods_.add(value);
                }
              }
              input.popLimit(oldLimit);
              break;
            }
            case 72: {
              bitField0_ |= 0x00000020;
              encrypted_ = input.readBool();
              break;
            }
            case 80: {
              bitField0_ |= 0x00000040;
              maxWrappedSize_ = input.readInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
          authenticationMechanisms_ = new com.google.protobuf.UnmodifiableLazyStringList(authenticationMechanisms_);
        }
        if (((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
          supportedMethods_ = java.util.Collections.unmodifiableList(supportedMethods_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_BitToUserHandshake_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_BitToUserHandshake_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.class, org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.Builder.class);
    }

    public static com.google.protobuf.Parser<BitToUserHandshake> PARSER =
        new com.google.protobuf.AbstractParser<BitToUserHandshake>() {
      public BitToUserHandshake parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new BitToUserHandshake(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<BitToUserHandshake> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional int32 rpc_version = 2;
    public static final int RPC_VERSION_FIELD_NUMBER = 2;
    private int rpcVersion_;
    /**
     * <code>optional int32 rpc_version = 2;</code>
     */
    public boolean hasRpcVersion() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional int32 rpc_version = 2;</code>
     */
    public int getRpcVersion() {
      return rpcVersion_;
    }

    // optional .exec.user.HandshakeStatus status = 3;
    public static final int STATUS_FIELD_NUMBER = 3;
    private org.apache.drill.exec.proto.UserProtos.HandshakeStatus status_;
    /**
     * <code>optional .exec.user.HandshakeStatus status = 3;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .exec.user.HandshakeStatus status = 3;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.HandshakeStatus getStatus() {
      return status_;
    }

    // optional string errorId = 4;
    public static final int ERRORID_FIELD_NUMBER = 4;
    private java.lang.Object errorId_;
    /**
     * <code>optional string errorId = 4;</code>
     */
    public boolean hasErrorId() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional string errorId = 4;</code>
     */
    public java.lang.String getErrorId() {
      java.lang.Object ref = errorId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          errorId_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string errorId = 4;</code>
     */
    public com.google.protobuf.ByteString
        getErrorIdBytes() {
      java.lang.Object ref = errorId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        errorId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string errorMessage = 5;
    public static final int ERRORMESSAGE_FIELD_NUMBER = 5;
    private java.lang.Object errorMessage_;
    /**
     * <code>optional string errorMessage = 5;</code>
     */
    public boolean hasErrorMessage() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional string errorMessage = 5;</code>
     */
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          errorMessage_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string errorMessage = 5;</code>
     */
    public com.google.protobuf.ByteString
        getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional .exec.user.RpcEndpointInfos server_infos = 6;
    public static final int SERVER_INFOS_FIELD_NUMBER = 6;
    private org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos serverInfos_;
    /**
     * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
     */
    public boolean hasServerInfos() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos getServerInfos() {
      return serverInfos_;
    }
    /**
     * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder getServerInfosOrBuilder() {
      return serverInfos_;
    }

    // repeated string authenticationMechanisms = 7;
    public static final int AUTHENTICATIONMECHANISMS_FIELD_NUMBER = 7;
    private com.google.protobuf.LazyStringList authenticationMechanisms_;
    /**
     * <code>repeated string authenticationMechanisms = 7;</code>
     */
    public java.util.List<java.lang.String>
        getAuthenticationMechanismsList() {
      return authenticationMechanisms_;
    }
    /**
     * <code>repeated string authenticationMechanisms = 7;</code>
     */
    public int getAuthenticationMechanismsCount() {
      return authenticationMechanisms_.size();
    }
    /**
     * <code>repeated string authenticationMechanisms = 7;</code>
     */
    public java.lang.String getAuthenticationMechanisms(int index) {
      return authenticationMechanisms_.get(index);
    }
    /**
     * <code>repeated string authenticationMechanisms = 7;</code>
     */
    public com.google.protobuf.ByteString
        getAuthenticationMechanismsBytes(int index) {
      return authenticationMechanisms_.getByteString(index);
    }

    // repeated .exec.user.RpcType supported_methods = 8;
    public static final int SUPPORTED_METHODS_FIELD_NUMBER = 8;
    private java.util.List<org.apache.drill.exec.proto.UserProtos.RpcType> supportedMethods_;
    /**
     * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
     */
    public java.util.List<org.apache.drill.exec.proto.UserProtos.RpcType> getSupportedMethodsList() {
      return supportedMethods_;
    }
    /**
     * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
     */
    public int getSupportedMethodsCount() {
      return supportedMethods_.size();
    }
    /**
     * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.RpcType getSupportedMethods(int index) {
      return supportedMethods_.get(index);
    }

    // optional bool encrypted = 9;
    public static final int ENCRYPTED_FIELD_NUMBER = 9;
    private boolean encrypted_;
    /**
     * <code>optional bool encrypted = 9;</code>
     */
    public boolean hasEncrypted() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional bool encrypted = 9;</code>
     */
    public boolean getEncrypted() {
      return encrypted_;
    }

    // optional int32 maxWrappedSize = 10;
    public static final int MAXWRAPPEDSIZE_FIELD_NUMBER = 10;
    private int maxWrappedSize_;
    /**
     * <code>optional int32 maxWrappedSize = 10;</code>
     */
    public boolean hasMaxWrappedSize() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional int32 maxWrappedSize = 10;</code>
     */
    public int getMaxWrappedSize() {
      return maxWrappedSize_;
    }

    private void initFields() {
      rpcVersion_ = 0;
      status_ = org.apache.drill.exec.proto.UserProtos.HandshakeStatus.SUCCESS;
      errorId_ = "";
      errorMessage_ = "";
      serverInfos_ = org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance();
      authenticationMechanisms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      supportedMethods_ = java.util.Collections.emptyList();
      encrypted_ = false;
      maxWrappedSize_ = 0;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt32(2, rpcVersion_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeEnum(3, status_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(4, getErrorIdBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeBytes(5, getErrorMessageBytes());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeMessage(6, serverInfos_);
      }
      for (int i = 0; i < authenticationMechanisms_.size(); i++) {
        output.writeBytes(7, authenticationMechanisms_.getByteString(i));
      }
      for (int i = 0; i < supportedMethods_.size(); i++) {
        output.writeEnum(8, supportedMethods_.get(i).getNumber());
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeBool(9, encrypted_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeInt32(10, maxWrappedSize_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(2, rpcVersion_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, status_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(4, getErrorIdBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(5, getErrorMessageBytes());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, serverInfos_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < authenticationMechanisms_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeBytesSizeNoTag(authenticationMechanisms_.getByteString(i));
        }
        size += dataSize;
        size += 1 * getAuthenticationMechanismsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < supportedMethods_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeEnumSizeNoTag(supportedMethods_.get(i).getNumber());
        }
        size += dataSize;
        size += 1 * supportedMethods_.size();
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(9, encrypted_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(10, maxWrappedSize_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.BitToUserHandshake prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.BitToUserHandshake}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.BitToUserHandshakeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_BitToUserHandshake_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_BitToUserHandshake_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.class, org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getServerInfosFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        rpcVersion_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = org.apache.drill.exec.proto.UserProtos.HandshakeStatus.SUCCESS;
        bitField0_ = (bitField0_ & ~0x00000002);
        errorId_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        errorMessage_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        if (serverInfosBuilder_ == null) {
          serverInfos_ = org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance();
        } else {
          serverInfosBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        authenticationMechanisms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000020);
        supportedMethods_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        encrypted_ = false;
        bitField0_ = (bitField0_ & ~0x00000080);
        maxWrappedSize_ = 0;
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_BitToUserHandshake_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.BitToUserHandshake getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.BitToUserHandshake build() {
        org.apache.drill.exec.proto.UserProtos.BitToUserHandshake result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.BitToUserHandshake buildPartial() {
        org.apache.drill.exec.proto.UserProtos.BitToUserHandshake result = new org.apache.drill.exec.proto.UserProtos.BitToUserHandshake(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.rpcVersion_ = rpcVersion_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.status_ = status_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.errorId_ = errorId_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.errorMessage_ = errorMessage_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        if (serverInfosBuilder_ == null) {
          result.serverInfos_ = serverInfos_;
        } else {
          result.serverInfos_ = serverInfosBuilder_.build();
        }
        if (((bitField0_ & 0x00000020) == 0x00000020)) {
          authenticationMechanisms_ = new com.google.protobuf.UnmodifiableLazyStringList(
              authenticationMechanisms_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.authenticationMechanisms_ = authenticationMechanisms_;
        if (((bitField0_ & 0x00000040) == 0x00000040)) {
          supportedMethods_ = java.util.Collections.unmodifiableList(supportedMethods_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.supportedMethods_ = supportedMethods_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000020;
        }
        result.encrypted_ = encrypted_;
        if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
          to_bitField0_ |= 0x00000040;
        }
        result.maxWrappedSize_ = maxWrappedSize_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.BitToUserHandshake) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.BitToUserHandshake)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.BitToUserHandshake other) {
        if (other == org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.getDefaultInstance()) return this;
        if (other.hasRpcVersion()) {
          setRpcVersion(other.getRpcVersion());
        }
        if (other.hasStatus()) {
          setStatus(other.getStatus());
        }
        if (other.hasErrorId()) {
          bitField0_ |= 0x00000004;
          errorId_ = other.errorId_;
          onChanged();
        }
        if (other.hasErrorMessage()) {
          bitField0_ |= 0x00000008;
          errorMessage_ = other.errorMessage_;
          onChanged();
        }
        if (other.hasServerInfos()) {
          mergeServerInfos(other.getServerInfos());
        }
        if (!other.authenticationMechanisms_.isEmpty()) {
          if (authenticationMechanisms_.isEmpty()) {
            authenticationMechanisms_ = other.authenticationMechanisms_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureAuthenticationMechanismsIsMutable();
            authenticationMechanisms_.addAll(other.authenticationMechanisms_);
          }
          onChanged();
        }
        if (!other.supportedMethods_.isEmpty()) {
          if (supportedMethods_.isEmpty()) {
            supportedMethods_ = other.supportedMethods_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureSupportedMethodsIsMutable();
            supportedMethods_.addAll(other.supportedMethods_);
          }
          onChanged();
        }
        if (other.hasEncrypted()) {
          setEncrypted(other.getEncrypted());
        }
        if (other.hasMaxWrappedSize()) {
          setMaxWrappedSize(other.getMaxWrappedSize());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.BitToUserHandshake) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional int32 rpc_version = 2;
      private int rpcVersion_ ;
      /**
       * <code>optional int32 rpc_version = 2;</code>
       */
      public boolean hasRpcVersion() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional int32 rpc_version = 2;</code>
       */
      public int getRpcVersion() {
        return rpcVersion_;
      }
      /**
       * <code>optional int32 rpc_version = 2;</code>
       */
      public Builder setRpcVersion(int value) {
        bitField0_ |= 0x00000001;
        rpcVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 rpc_version = 2;</code>
       */
      public Builder clearRpcVersion() {
        bitField0_ = (bitField0_ & ~0x00000001);
        rpcVersion_ = 0;
        onChanged();
        return this;
      }

      // optional .exec.user.HandshakeStatus status = 3;
      private org.apache.drill.exec.proto.UserProtos.HandshakeStatus status_ = org.apache.drill.exec.proto.UserProtos.HandshakeStatus.SUCCESS;
      /**
       * <code>optional .exec.user.HandshakeStatus status = 3;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .exec.user.HandshakeStatus status = 3;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.HandshakeStatus getStatus() {
        return status_;
      }
      /**
       * <code>optional .exec.user.HandshakeStatus status = 3;</code>
       */
      public Builder setStatus(org.apache.drill.exec.proto.UserProtos.HandshakeStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        status_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.user.HandshakeStatus status = 3;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000002);
        status_ = org.apache.drill.exec.proto.UserProtos.HandshakeStatus.SUCCESS;
        onChanged();
        return this;
      }

      // optional string errorId = 4;
      private java.lang.Object errorId_ = "";
      /**
       * <code>optional string errorId = 4;</code>
       */
      public boolean hasErrorId() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional string errorId = 4;</code>
       */
      public java.lang.String getErrorId() {
        java.lang.Object ref = errorId_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          errorId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string errorId = 4;</code>
       */
      public com.google.protobuf.ByteString
          getErrorIdBytes() {
        java.lang.Object ref = errorId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          errorId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string errorId = 4;</code>
       */
      public Builder setErrorId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        errorId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string errorId = 4;</code>
       */
      public Builder clearErrorId() {
        bitField0_ = (bitField0_ & ~0x00000004);
        errorId_ = getDefaultInstance().getErrorId();
        onChanged();
        return this;
      }
      /**
       * <code>optional string errorId = 4;</code>
       */
      public Builder setErrorIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        errorId_ = value;
        onChanged();
        return this;
      }

      // optional string errorMessage = 5;
      private java.lang.Object errorMessage_ = "";
      /**
       * <code>optional string errorMessage = 5;</code>
       */
      public boolean hasErrorMessage() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional string errorMessage = 5;</code>
       */
      public java.lang.String getErrorMessage() {
        java.lang.Object ref = errorMessage_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          errorMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string errorMessage = 5;</code>
       */
      public com.google.protobuf.ByteString
          getErrorMessageBytes() {
        java.lang.Object ref = errorMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          errorMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string errorMessage = 5;</code>
       */
      public Builder setErrorMessage(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        errorMessage_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string errorMessage = 5;</code>
       */
      public Builder clearErrorMessage() {
        bitField0_ = (bitField0_ & ~0x00000008);
        errorMessage_ = getDefaultInstance().getErrorMessage();
        onChanged();
        return this;
      }
      /**
       * <code>optional string errorMessage = 5;</code>
       */
      public Builder setErrorMessageBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        errorMessage_ = value;
        onChanged();
        return this;
      }

      // optional .exec.user.RpcEndpointInfos server_infos = 6;
      private org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos serverInfos_ = org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder> serverInfosBuilder_;
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       */
      public boolean hasServerInfos() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos getServerInfos() {
        if (serverInfosBuilder_ == null) {
          return serverInfos_;
        } else {
          return serverInfosBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       */
      public Builder setServerInfos(org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos value) {
        if (serverInfosBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          serverInfos_ = value;
          onChanged();
        } else {
          serverInfosBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       */
      public Builder setServerInfos(
          org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder builderForValue) {
        if (serverInfosBuilder_ == null) {
          serverInfos_ = builderForValue.build();
          onChanged();
        } else {
          serverInfosBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       */
      public Builder mergeServerInfos(org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos value) {
        if (serverInfosBuilder_ == null) {
          if (((bitField0_ & 0x00000010) == 0x00000010) &&
              serverInfos_ != org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance()) {
            serverInfos_ =
              org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.newBuilder(serverInfos_).mergeFrom(value).buildPartial();
          } else {
            serverInfos_ = value;
          }
          onChanged();
        } else {
          serverInfosBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       */
      public Builder clearServerInfos() {
        if (serverInfosBuilder_ == null) {
          serverInfos_ = org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance();
          onChanged();
        } else {
          serverInfosBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder getServerInfosBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getServerInfosFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder getServerInfosOrBuilder() {
        if (serverInfosBuilder_ != null) {
          return serverInfosBuilder_.getMessageOrBuilder();
        } else {
          return serverInfos_;
        }
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder> 
          getServerInfosFieldBuilder() {
        if (serverInfosBuilder_ == null) {
          serverInfosBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder>(
                  serverInfos_,
                  getParentForChildren(),
                  isClean());
          serverInfos_ = null;
        }
        return serverInfosBuilder_;
      }

      // repeated string authenticationMechanisms = 7;
      private com.google.protobuf.LazyStringList authenticationMechanisms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureAuthenticationMechanismsIsMutable() {
        if (!((bitField0_ & 0x00000020) == 0x00000020)) {
          authenticationMechanisms_ = new com.google.protobuf.LazyStringArrayList(authenticationMechanisms_);
          bitField0_ |= 0x00000020;
         }
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       */
      public java.util.List<java.lang.String>
          getAuthenticationMechanismsList() {
        return java.util.Collections.unmodifiableList(authenticationMechanisms_);
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       */
      public int getAuthenticationMechanismsCount() {
        return authenticationMechanisms_.size();
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       */
      public java.lang.String getAuthenticationMechanisms(int index) {
        return authenticationMechanisms_.get(index);
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       */
      public com.google.protobuf.ByteString
          getAuthenticationMechanismsBytes(int index) {
        return authenticationMechanisms_.getByteString(index);
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       */
      public Builder setAuthenticationMechanisms(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureAuthenticationMechanismsIsMutable();
        authenticationMechanisms_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       */
      public Builder addAuthenticationMechanisms(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureAuthenticationMechanismsIsMutable();
        authenticationMechanisms_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       */
      public Builder addAllAuthenticationMechanisms(
          java.lang.Iterable<java.lang.String> values) {
        ensureAuthenticationMechanismsIsMutable();
        super.addAll(values, authenticationMechanisms_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       */
      public Builder clearAuthenticationMechanisms() {
        authenticationMechanisms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       */
      public Builder addAuthenticationMechanismsBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureAuthenticationMechanismsIsMutable();
        authenticationMechanisms_.add(value);
        onChanged();
        return this;
      }

      // repeated .exec.user.RpcType supported_methods = 8;
      private java.util.List<org.apache.drill.exec.proto.UserProtos.RpcType> supportedMethods_ =
        java.util.Collections.emptyList();
      private void ensureSupportedMethodsIsMutable() {
        if (!((bitField0_ & 0x00000040) == 0x00000040)) {
          supportedMethods_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.RpcType>(supportedMethods_);
          bitField0_ |= 0x00000040;
        }
      }
      /**
       * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.RpcType> getSupportedMethodsList() {
        return java.util.Collections.unmodifiableList(supportedMethods_);
      }
      /**
       * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
       */
      public int getSupportedMethodsCount() {
        return supportedMethods_.size();
      }
      /**
       * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.RpcType getSupportedMethods(int index) {
        return supportedMethods_.get(index);
      }
      /**
       * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
       */
      public Builder setSupportedMethods(
          int index, org.apache.drill.exec.proto.UserProtos.RpcType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSupportedMethodsIsMutable();
        supportedMethods_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
       */
      public Builder addSupportedMethods(org.apache.drill.exec.proto.UserProtos.RpcType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSupportedMethodsIsMutable();
        supportedMethods_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
       */
      public Builder addAllSupportedMethods(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.UserProtos.RpcType> values) {
        ensureSupportedMethodsIsMutable();
        super.addAll(values, supportedMethods_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
       */
      public Builder clearSupportedMethods() {
        supportedMethods_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
        return this;
      }

      // optional bool encrypted = 9;
      private boolean encrypted_ ;
      /**
       * <code>optional bool encrypted = 9;</code>
       */
      public boolean hasEncrypted() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <code>optional bool encrypted = 9;</code>
       */
      public boolean getEncrypted() {
        return encrypted_;
      }
      /**
       * <code>optional bool encrypted = 9;</code>
       */
      public Builder setEncrypted(boolean value) {
        bitField0_ |= 0x00000080;
        encrypted_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool encrypted = 9;</code>
       */
      public Builder clearEncrypted() {
        bitField0_ = (bitField0_ & ~0x00000080);
        encrypted_ = false;
        onChanged();
        return this;
      }

      // optional int32 maxWrappedSize = 10;
      private int maxWrappedSize_ ;
      /**
       * <code>optional int32 maxWrappedSize = 10;</code>
       */
      public boolean hasMaxWrappedSize() {
        return ((bitField0_ & 0x00000100) == 0x00000100);
      }
      /**
       * <code>optional int32 maxWrappedSize = 10;</code>
       */
      public int getMaxWrappedSize() {
        return maxWrappedSize_;
      }
      /**
       * <code>optional int32 maxWrappedSize = 10;</code>
       */
      public Builder setMaxWrappedSize(int value) {
        bitField0_ |= 0x00000100;
        maxWrappedSize_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 maxWrappedSize = 10;</code>
       */
      public Builder clearMaxWrappedSize() {
        bitField0_ = (bitField0_ & ~0x00000100);
        maxWrappedSize_ = 0;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.BitToUserHandshake)
    }

    static {
      defaultInstance = new BitToUserHandshake(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.BitToUserHandshake)
  }

  public interface LikeFilterOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional string pattern = 1;
    /**
     * <code>optional string pattern = 1;</code>
     *
     * <pre>
     * pattern to match
     * </pre>
     */
    boolean hasPattern();
    /**
     * <code>optional string pattern = 1;</code>
     *
     * <pre>
     * pattern to match
     * </pre>
     */
    java.lang.String getPattern();
    /**
     * <code>optional string pattern = 1;</code>
     *
     * <pre>
     * pattern to match
     * </pre>
     */
    com.google.protobuf.ByteString
        getPatternBytes();

    // optional string escape = 2;
    /**
     * <code>optional string escape = 2;</code>
     *
     * <pre>
     * escape character (if any) present in the pattern
     * </pre>
     */
    boolean hasEscape();
    /**
     * <code>optional string escape = 2;</code>
     *
     * <pre>
     * escape character (if any) present in the pattern
     * </pre>
     */
    java.lang.String getEscape();
    /**
     * <code>optional string escape = 2;</code>
     *
     * <pre>
     * escape character (if any) present in the pattern
     * </pre>
     */
    com.google.protobuf.ByteString
        getEscapeBytes();
  }
  /**
   * Protobuf type {@code exec.user.LikeFilter}
   *
   * <pre>
   *
   * Simple filter which encapsulates the SQL LIKE ... ESCAPE function
   * </pre>
   */
  public static final class LikeFilter extends
      com.google.protobuf.GeneratedMessage
      implements LikeFilterOrBuilder {
    // Use LikeFilter.newBuilder() to construct.
    private LikeFilter(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private LikeFilter(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final LikeFilter defaultInstance;
    public static LikeFilter getDefaultInstance() {
      return defaultInstance;
    }

    public LikeFilter getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private LikeFilter(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              pattern_ = input.readBytes();
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              escape_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_LikeFilter_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_LikeFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.LikeFilter.class, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder.class);
    }

    public static com.google.protobuf.Parser<LikeFilter> PARSER =
        new com.google.protobuf.AbstractParser<LikeFilter>() {
      public LikeFilter parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new LikeFilter(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<LikeFilter> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional string pattern = 1;
    public static final int PATTERN_FIELD_NUMBER = 1;
    private java.lang.Object pattern_;
    /**
     * <code>optional string pattern = 1;</code>
     *
     * <pre>
     * pattern to match
     * </pre>
     */
    public boolean hasPattern() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string pattern = 1;</code>
     *
     * <pre>
     * pattern to match
     * </pre>
     */
    public java.lang.String getPattern() {
      java.lang.Object ref = pattern_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          pattern_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string pattern = 1;</code>
     *
     * <pre>
     * pattern to match
     * </pre>
     */
    public com.google.protobuf.ByteString
        getPatternBytes() {
      java.lang.Object ref = pattern_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        pattern_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string escape = 2;
    public static final int ESCAPE_FIELD_NUMBER = 2;
    private java.lang.Object escape_;
    /**
     * <code>optional string escape = 2;</code>
     *
     * <pre>
     * escape character (if any) present in the pattern
     * </pre>
     */
    public boolean hasEscape() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string escape = 2;</code>
     *
     * <pre>
     * escape character (if any) present in the pattern
     * </pre>
     */
    public java.lang.String getEscape() {
      java.lang.Object ref = escape_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          escape_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string escape = 2;</code>
     *
     * <pre>
     * escape character (if any) present in the pattern
     * </pre>
     */
    public com.google.protobuf.ByteString
        getEscapeBytes() {
      java.lang.Object ref = escape_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        escape_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      pattern_ = "";
      escape_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getPatternBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getEscapeBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getPatternBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getEscapeBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.LikeFilter prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.LikeFilter}
     *
     * <pre>
     *
     * Simple filter which encapsulates the SQL LIKE ... ESCAPE function
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_LikeFilter_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_LikeFilter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.LikeFilter.class, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        pattern_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        escape_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_LikeFilter_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.LikeFilter getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.LikeFilter build() {
        org.apache.drill.exec.proto.UserProtos.LikeFilter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.LikeFilter buildPartial() {
        org.apache.drill.exec.proto.UserProtos.LikeFilter result = new org.apache.drill.exec.proto.UserProtos.LikeFilter(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.pattern_ = pattern_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.escape_ = escape_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.LikeFilter) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.LikeFilter)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.LikeFilter other) {
        if (other == org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) return this;
        if (other.hasPattern()) {
          bitField0_ |= 0x00000001;
          pattern_ = other.pattern_;
          onChanged();
        }
        if (other.hasEscape()) {
          bitField0_ |= 0x00000002;
          escape_ = other.escape_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.LikeFilter parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.LikeFilter) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional string pattern = 1;
      private java.lang.Object pattern_ = "";
      /**
       * <code>optional string pattern = 1;</code>
       *
       * <pre>
       * pattern to match
       * </pre>
       */
      public boolean hasPattern() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string pattern = 1;</code>
       *
       * <pre>
       * pattern to match
       * </pre>
       */
      public java.lang.String getPattern() {
        java.lang.Object ref = pattern_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          pattern_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string pattern = 1;</code>
       *
       * <pre>
       * pattern to match
       * </pre>
       */
      public com.google.protobuf.ByteString
          getPatternBytes() {
        java.lang.Object ref = pattern_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          pattern_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string pattern = 1;</code>
       *
       * <pre>
       * pattern to match
       * </pre>
       */
      public Builder setPattern(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        pattern_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string pattern = 1;</code>
       *
       * <pre>
       * pattern to match
       * </pre>
       */
      public Builder clearPattern() {
        bitField0_ = (bitField0_ & ~0x00000001);
        pattern_ = getDefaultInstance().getPattern();
        onChanged();
        return this;
      }
      /**
       * <code>optional string pattern = 1;</code>
       *
       * <pre>
       * pattern to match
       * </pre>
       */
      public Builder setPatternBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        pattern_ = value;
        onChanged();
        return this;
      }

      // optional string escape = 2;
      private java.lang.Object escape_ = "";
      /**
       * <code>optional string escape = 2;</code>
       *
       * <pre>
       * escape character (if any) present in the pattern
       * </pre>
       */
      public boolean hasEscape() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string escape = 2;</code>
       *
       * <pre>
       * escape character (if any) present in the pattern
       * </pre>
       */
      public java.lang.String getEscape() {
        java.lang.Object ref = escape_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          escape_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string escape = 2;</code>
       *
       * <pre>
       * escape character (if any) present in the pattern
       * </pre>
       */
      public com.google.protobuf.ByteString
          getEscapeBytes() {
        java.lang.Object ref = escape_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          escape_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string escape = 2;</code>
       *
       * <pre>
       * escape character (if any) present in the pattern
       * </pre>
       */
      public Builder setEscape(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        escape_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string escape = 2;</code>
       *
       * <pre>
       * escape character (if any) present in the pattern
       * </pre>
       */
      public Builder clearEscape() {
        bitField0_ = (bitField0_ & ~0x00000002);
        escape_ = getDefaultInstance().getEscape();
        onChanged();
        return this;
      }
      /**
       * <code>optional string escape = 2;</code>
       *
       * <pre>
       * escape character (if any) present in the pattern
       * </pre>
       */
      public Builder setEscapeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        escape_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.LikeFilter)
    }

    static {
      defaultInstance = new LikeFilter(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.LikeFilter)
  }

  public interface GetCatalogsReqOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.user.LikeFilter catalog_name_filter = 1;
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    boolean hasCatalogNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder();
  }
  /**
   * Protobuf type {@code exec.user.GetCatalogsReq}
   *
   * <pre>
   *
   * Request message for getting the metadata for catalogs satisfying the given optional filter.
   * </pre>
   */
  public static final class GetCatalogsReq extends
      com.google.protobuf.GeneratedMessage
      implements GetCatalogsReqOrBuilder {
    // Use GetCatalogsReq.newBuilder() to construct.
    private GetCatalogsReq(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private GetCatalogsReq(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final GetCatalogsReq defaultInstance;
    public static GetCatalogsReq getDefaultInstance() {
      return defaultInstance;
    }

    public GetCatalogsReq getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private GetCatalogsReq(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = catalogNameFilter_.toBuilder();
              }
              catalogNameFilter_ = input.readMessage(org.apache.drill.exec.proto.UserProtos.LikeFilter.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(catalogNameFilter_);
                catalogNameFilter_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsReq_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsReq_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetCatalogsReq.class, org.apache.drill.exec.proto.UserProtos.GetCatalogsReq.Builder.class);
    }

    public static com.google.protobuf.Parser<GetCatalogsReq> PARSER =
        new com.google.protobuf.AbstractParser<GetCatalogsReq>() {
      public GetCatalogsReq parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new GetCatalogsReq(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<GetCatalogsReq> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.user.LikeFilter catalog_name_filter = 1;
    public static final int CATALOG_NAME_FILTER_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter catalogNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    public boolean hasCatalogNameFilter() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter() {
      return catalogNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder() {
      return catalogNameFilter_;
    }

    private void initFields() {
      catalogNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, catalogNameFilter_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, catalogNameFilter_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetCatalogsReq prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.GetCatalogsReq}
     *
     * <pre>
     *
     * Request message for getting the metadata for catalogs satisfying the given optional filter.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.GetCatalogsReqOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsReq_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsReq_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetCatalogsReq.class, org.apache.drill.exec.proto.UserProtos.GetCatalogsReq.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetCatalogsReq.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getCatalogNameFilterFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
        } else {
          catalogNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsReq_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.GetCatalogsReq getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetCatalogsReq.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.GetCatalogsReq build() {
        org.apache.drill.exec.proto.UserProtos.GetCatalogsReq result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.GetCatalogsReq buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetCatalogsReq result = new org.apache.drill.exec.proto.UserProtos.GetCatalogsReq(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (catalogNameFilterBuilder_ == null) {
          result.catalogNameFilter_ = catalogNameFilter_;
        } else {
          result.catalogNameFilter_ = catalogNameFilterBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetCatalogsReq) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetCatalogsReq)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetCatalogsReq other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetCatalogsReq.getDefaultInstance()) return this;
        if (other.hasCatalogNameFilter()) {
          mergeCatalogNameFilter(other.getCatalogNameFilter());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.GetCatalogsReq) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.user.LikeFilter catalog_name_filter = 1;
      private org.apache.drill.exec.proto.UserProtos.LikeFilter catalogNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> catalogNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public boolean hasCatalogNameFilter() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter() {
        if (catalogNameFilterBuilder_ == null) {
          return catalogNameFilter_;
        } else {
          return catalogNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder setCatalogNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (catalogNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          catalogNameFilter_ = value;
          onChanged();
        } else {
          catalogNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder setCatalogNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          catalogNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder mergeCatalogNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (catalogNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              catalogNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            catalogNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(catalogNameFilter_).mergeFrom(value).buildPartial();
          } else {
            catalogNameFilter_ = value;
          }
          onChanged();
        } else {
          catalogNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder clearCatalogNameFilter() {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
          onChanged();
        } else {
          catalogNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getCatalogNameFilterBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCatalogNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder() {
        if (catalogNameFilterBuilder_ != null) {
          return catalogNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return catalogNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getCatalogNameFilterFieldBuilder() {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  catalogNameFilter_,
                  getParentForChildren(),
                  isClean());
          catalogNameFilter_ = null;
        }
        return catalogNameFilterBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.GetCatalogsReq)
    }

    static {
      defaultInstance = new GetCatalogsReq(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetCatalogsReq)
  }

  public interface CatalogMetadataOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional string catalog_name = 1;
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    boolean hasCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    java.lang.String getCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    com.google.protobuf.ByteString
        getCatalogNameBytes();

    // optional string description = 2;
    /**
     * <code>optional string description = 2;</code>
     */
    boolean hasDescription();
    /**
     * <code>optional string description = 2;</code>
     */
    java.lang.String getDescription();
    /**
     * <code>optional string description = 2;</code>
     */
    com.google.protobuf.ByteString
        getDescriptionBytes();

    // optional string connect = 3;
    /**
     * <code>optional string connect = 3;</code>
     */
    boolean hasConnect();
    /**
     * <code>optional string connect = 3;</code>
     */
    java.lang.String getConnect();
    /**
     * <code>optional string connect = 3;</code>
     */
    com.google.protobuf.ByteString
        getConnectBytes();
  }
  /**
   * Protobuf type {@code exec.user.CatalogMetadata}
   *
   * <pre>
   *
   * Message encapsulating metadata for a Catalog.
   * </pre>
   */
  public static final class CatalogMetadata extends
      com.google.protobuf.GeneratedMessage
      implements CatalogMetadataOrBuilder {
    // Use CatalogMetadata.newBuilder() to construct.
    private CatalogMetadata(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private CatalogMetadata(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final CatalogMetadata defaultInstance;
    public static CatalogMetadata getDefaultInstance() {
      return defaultInstance;
    }

    public CatalogMetadata getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private CatalogMetadata(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              catalogName_ = input.readBytes();
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              description_ = input.readBytes();
              break;
            }
            case 26: {
              bitField0_ |= 0x00000004;
              connect_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CatalogMetadata_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CatalogMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.CatalogMetadata.class, org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder.class);
    }

    public static com.google.protobuf.Parser<CatalogMetadata> PARSER =
        new com.google.protobuf.AbstractParser<CatalogMetadata>() {
      public CatalogMetadata parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new CatalogMetadata(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<CatalogMetadata> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional string catalog_name = 1;
    public static final int CATALOG_NAME_FIELD_NUMBER = 1;
    private java.lang.Object catalogName_;
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    public boolean hasCatalogName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    public java.lang.String getCatalogName() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          catalogName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getCatalogNameBytes() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        catalogName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string description = 2;
    public static final int DESCRIPTION_FIELD_NUMBER = 2;
    private java.lang.Object description_;
    /**
     * <code>optional string description = 2;</code>
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string description = 2;</code>
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          description_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string description = 2;</code>
     */
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string connect = 3;
    public static final int CONNECT_FIELD_NUMBER = 3;
    private java.lang.Object connect_;
    /**
     * <code>optional string connect = 3;</code>
     */
    public boolean hasConnect() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional string connect = 3;</code>
     */
    public java.lang.String getConnect() {
      java.lang.Object ref = connect_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          connect_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string connect = 3;</code>
     */
    public com.google.protobuf.ByteString
        getConnectBytes() {
      java.lang.Object ref = connect_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        connect_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      catalogName_ = "";
      description_ = "";
      connect_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getCatalogNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getDescriptionBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(3, getConnectBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getCatalogNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getDescriptionBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, getConnectBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.CatalogMetadata prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.CatalogMetadata}
     *
     * <pre>
     *
     * Message encapsulating metadata for a Catalog.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CatalogMetadata_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CatalogMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.CatalogMetadata.class, org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.CatalogMetadata.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        catalogName_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        description_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        connect_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CatalogMetadata_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.CatalogMetadata getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.CatalogMetadata.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.CatalogMetadata build() {
        org.apache.drill.exec.proto.UserProtos.CatalogMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.CatalogMetadata buildPartial() {
        org.apache.drill.exec.proto.UserProtos.CatalogMetadata result = new org.apache.drill.exec.proto.UserProtos.CatalogMetadata(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.catalogName_ = catalogName_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.description_ = description_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.connect_ = connect_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.CatalogMetadata) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.CatalogMetadata)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.CatalogMetadata other) {
        if (other == org.apache.drill.exec.proto.UserProtos.CatalogMetadata.getDefaultInstance()) return this;
        if (other.hasCatalogName()) {
          bitField0_ |= 0x00000001;
          catalogName_ = other.catalogName_;
          onChanged();
        }
        if (other.hasDescription()) {
          bitField0_ |= 0x00000002;
          description_ = other.description_;
          onChanged();
        }
        if (other.hasConnect()) {
          bitField0_ |= 0x00000004;
          connect_ = other.connect_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.CatalogMetadata parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.CatalogMetadata) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional string catalog_name = 1;
      private java.lang.Object catalogName_ = "";
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public boolean hasCatalogName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public java.lang.String getCatalogName() {
        java.lang.Object ref = catalogName_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          catalogName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public com.google.protobuf.ByteString
          getCatalogNameBytes() {
        java.lang.Object ref = catalogName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          catalogName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public Builder setCatalogName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public Builder clearCatalogName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        catalogName_ = getDefaultInstance().getCatalogName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public Builder setCatalogNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }

      // optional string description = 2;
      private java.lang.Object description_ = "";
      /**
       * <code>optional string description = 2;</code>
       */
      public boolean hasDescription() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string description = 2;</code>
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string description = 2;</code>
       */
      public com.google.protobuf.ByteString
          getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string description = 2;</code>
       */
      public Builder setDescription(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        description_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string description = 2;</code>
       */
      public Builder clearDescription() {
        bitField0_ = (bitField0_ & ~0x00000002);
        description_ = getDefaultInstance().getDescription();
        onChanged();
        return this;
      }
      /**
       * <code>optional string description = 2;</code>
       */
      public Builder setDescriptionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        description_ = value;
        onChanged();
        return this;
      }

      // optional string connect = 3;
      private java.lang.Object connect_ = "";
      /**
       * <code>optional string connect = 3;</code>
       */
      public boolean hasConnect() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional string connect = 3;</code>
       */
      public java.lang.String getConnect() {
        java.lang.Object ref = connect_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          connect_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string connect = 3;</code>
       */
      public com.google.protobuf.ByteString
          getConnectBytes() {
        java.lang.Object ref = connect_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          connect_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string connect = 3;</code>
       */
      public Builder setConnect(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        connect_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string connect = 3;</code>
       */
      public Builder clearConnect() {
        bitField0_ = (bitField0_ & ~0x00000004);
        connect_ = getDefaultInstance().getConnect();
        onChanged();
        return this;
      }
      /**
       * <code>optional string connect = 3;</code>
       */
      public Builder setConnectBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        connect_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.CatalogMetadata)
    }

    static {
      defaultInstance = new CatalogMetadata(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.CatalogMetadata)
  }

  public interface GetCatalogsRespOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.user.RequestStatus status = 1;
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     */
    boolean hasStatus();
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus();

    // repeated .exec.user.CatalogMetadata catalogs = 2;
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    java.util.List<org.apache.drill.exec.proto.UserProtos.CatalogMetadata> 
        getCatalogsList();
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.CatalogMetadata getCatalogs(int index);
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    int getCatalogsCount();
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    java.util.List<? extends org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder> 
        getCatalogsOrBuilderList();
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder getCatalogsOrBuilder(
        int index);

    // optional .exec.shared.DrillPBError error = 3;
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    boolean hasError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBError getError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder();
  }
  /**
   * Protobuf type {@code exec.user.GetCatalogsResp}
   *
   * <pre>
   *
   * Response message for GetCatalogReq.
   * </pre>
   */
  public static final class GetCatalogsResp extends
      com.google.protobuf.GeneratedMessage
      implements GetCatalogsRespOrBuilder {
    // Use GetCatalogsResp.newBuilder() to construct.
    private GetCatalogsResp(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private GetCatalogsResp(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final GetCatalogsResp defaultInstance;
    public static GetCatalogsResp getDefaultInstance() {
      return defaultInstance;
    }

    public GetCatalogsResp getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private GetCatalogsResp(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.UserProtos.RequestStatus value = org.apache.drill.exec.proto.UserProtos.RequestStatus.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                status_ = value;
              }
              break;
            }
            case 18: {
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                catalogs_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.CatalogMetadata>();
                mutable_bitField0_ |= 0x00000002;
              }
              catalogs_.add(input.readMessage(org.apache.drill.exec.proto.UserProtos.CatalogMetadata.PARSER, extensionRegistry));
              break;
            }
            case 26: {
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = error_.toBuilder();
              }
              error_ = input.readMessage(org.apache.drill.exec.proto.UserBitShared.DrillPBError.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(error_);
                error_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          catalogs_ = java.util.Collections.unmodifiableList(catalogs_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsResp_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsResp_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetCatalogsResp.class, org.apache.drill.exec.proto.UserProtos.GetCatalogsResp.Builder.class);
    }

    public static com.google.protobuf.Parser<GetCatalogsResp> PARSER =
        new com.google.protobuf.AbstractParser<GetCatalogsResp>() {
      public GetCatalogsResp parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new GetCatalogsResp(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<GetCatalogsResp> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.user.RequestStatus status = 1;
    public static final int STATUS_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserProtos.RequestStatus status_;
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus() {
      return status_;
    }

    // repeated .exec.user.CatalogMetadata catalogs = 2;
    public static final int CATALOGS_FIELD_NUMBER = 2;
    private java.util.List<org.apache.drill.exec.proto.UserProtos.CatalogMetadata> catalogs_;
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    public java.util.List<org.apache.drill.exec.proto.UserProtos.CatalogMetadata> getCatalogsList() {
      return catalogs_;
    }
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder> 
        getCatalogsOrBuilderList() {
      return catalogs_;
    }
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    public int getCatalogsCount() {
      return catalogs_.size();
    }
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.CatalogMetadata getCatalogs(int index) {
      return catalogs_.get(index);
    }
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder getCatalogsOrBuilder(
        int index) {
      return catalogs_.get(index);
    }

    // optional .exec.shared.DrillPBError error = 3;
    public static final int ERROR_FIELD_NUMBER = 3;
    private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_;
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
      return error_;
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
      return error_;
    }

    private void initFields() {
      status_ = org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS;
      catalogs_ = java.util.Collections.emptyList();
      error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, status_.getNumber());
      }
      for (int i = 0; i < catalogs_.size(); i++) {
        output.writeMessage(2, catalogs_.get(i));
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(3, error_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, status_.getNumber());
      }
      for (int i = 0; i < catalogs_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, catalogs_.get(i));
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, error_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetCatalogsResp prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.GetCatalogsResp}
     *
     * <pre>
     *
     * Response message for GetCatalogReq.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.GetCatalogsRespOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsResp_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsResp_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetCatalogsResp.class, org.apache.drill.exec.proto.UserProtos.GetCatalogsResp.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetCatalogsResp.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getCatalogsFieldBuilder();
          getErrorFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        status_ = org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (catalogsBuilder_ == null) {
          catalogs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          catalogsBuilder_.clear();
        }
        if (errorBuilder_ == null) {
          error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsResp_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.GetCatalogsResp getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetCatalogsResp.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.GetCatalogsResp build() {
        org.apache.drill.exec.proto.UserProtos.GetCatalogsResp result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.GetCatalogsResp buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetCatalogsResp result = new org.apache.drill.exec.proto.UserProtos.GetCatalogsResp(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.status_ = status_;
        if (catalogsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            catalogs_ = java.util.Collections.unmodifiableList(catalogs_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.catalogs_ = catalogs_;
        } else {
          result.catalogs_ = catalogsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000002;
        }
        if (errorBuilder_ == null) {
          result.error_ = error_;
        } else {
          result.error_ = errorBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetCatalogsResp) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetCatalogsResp)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetCatalogsResp other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetCatalogsResp.getDefaultInstance()) return this;
        if (other.hasStatus()) {
          setStatus(other.getStatus());
        }
        if (catalogsBuilder_ == null) {
          if (!other.catalogs_.isEmpty()) {
            if (catalogs_.isEmpty()) {
              catalogs_ = other.catalogs_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureCatalogsIsMutable();
              catalogs_.addAll(other.catalogs_);
            }
            onChanged();
          }
        } else {
          if (!other.catalogs_.isEmpty()) {
            if (catalogsBuilder_.isEmpty()) {
              catalogsBuilder_.dispose();
              catalogsBuilder_ = null;
              catalogs_ = other.catalogs_;
              bitField0_ = (bitField0_ & ~0x00000002);
              catalogsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getCatalogsFieldBuilder() : null;
            } else {
              catalogsBuilder_.addAllMessages(other.catalogs_);
            }
          }
        }
        if (other.hasError()) {
          mergeError(other.getError());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.GetCatalogsResp) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.user.RequestStatus status = 1;
      private org.apache.drill.exec.proto.UserProtos.RequestStatus status_ = org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS;
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus() {
        return status_;
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       */
      public Builder setStatus(org.apache.drill.exec.proto.UserProtos.RequestStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        status_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS;
        onChanged();
        return this;
      }

      // repeated .exec.user.CatalogMetadata catalogs = 2;
      private java.util.List<org.apache.drill.exec.proto.UserProtos.CatalogMetadata> catalogs_ =
        java.util.Collections.emptyList();
      private void ensureCatalogsIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          catalogs_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.CatalogMetadata>(catalogs_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.CatalogMetadata, org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder, org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder> catalogsBuilder_;

      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.CatalogMetadata> getCatalogsList() {
        if (catalogsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(catalogs_);
        } else {
          return catalogsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public int getCatalogsCount() {
        if (catalogsBuilder_ == null) {
          return catalogs_.size();
        } else {
          return catalogsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.CatalogMetadata getCatalogs(int index) {
        if (catalogsBuilder_ == null) {
          return catalogs_.get(index);
        } else {
          return catalogsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder setCatalogs(
          int index, org.apache.drill.exec.proto.UserProtos.CatalogMetadata value) {
        if (catalogsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCatalogsIsMutable();
          catalogs_.set(index, value);
          onChanged();
        } else {
          catalogsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder setCatalogs(
          int index, org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder builderForValue) {
        if (catalogsBuilder_ == null) {
          ensureCatalogsIsMutable();
          catalogs_.set(index, builderForValue.build());
          onChanged();
        } else {
          catalogsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder addCatalogs(org.apache.drill.exec.proto.UserProtos.CatalogMetadata value) {
        if (catalogsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCatalogsIsMutable();
          catalogs_.add(value);
          onChanged();
        } else {
          catalogsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder addCatalogs(
          int index, org.apache.drill.exec.proto.UserProtos.CatalogMetadata value) {
        if (catalogsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCatalogsIsMutable();
          catalogs_.add(index, value);
          onChanged();
        } else {
          catalogsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder addCatalogs(
          org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder builderForValue) {
        if (catalogsBuilder_ == null) {
          ensureCatalogsIsMutable();
          catalogs_.add(builderForValue.build());
          onChanged();
        } else {
          catalogsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder addCatalogs(
          int index, org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder builderForValue) {
        if (catalogsBuilder_ == null) {
          ensureCatalogsIsMutable();
          catalogs_.add(index, builderForValue.build());
          onChanged();
        } else {
          catalogsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder addAllCatalogs(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.UserProtos.CatalogMetadata> values) {
        if (catalogsBuilder_ == null) {
          ensureCatalogsIsMutable();
          super.addAll(values, catalogs_);
          onChanged();
        } else {
          catalogsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder clearCatalogs() {
        if (catalogsBuilder_ == null) {
          catalogs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          catalogsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder removeCatalogs(int index) {
        if (catalogsBuilder_ == null) {
          ensureCatalogsIsMutable();
          catalogs_.remove(index);
          onChanged();
        } else {
          catalogsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder getCatalogsBuilder(
          int index) {
        return getCatalogsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder getCatalogsOrBuilder(
          int index) {
        if (catalogsBuilder_ == null) {
          return catalogs_.get(index);  } else {
          return catalogsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder> 
           getCatalogsOrBuilderList() {
        if (catalogsBuilder_ != null) {
          return catalogsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(catalogs_);
        }
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder addCatalogsBuilder() {
        return getCatalogsFieldBuilder().addBuilder(
            org.apache.drill.exec.proto.UserProtos.CatalogMetadata.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder addCatalogsBuilder(
          int index) {
        return getCatalogsFieldBuilder().addBuilder(
            index, org.apache.drill.exec.proto.UserProtos.CatalogMetadata.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder> 
           getCatalogsBuilderList() {
        return getCatalogsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.CatalogMetadata, org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder, org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder> 
          getCatalogsFieldBuilder() {
        if (catalogsBuilder_ == null) {
          catalogsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.CatalogMetadata, org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder, org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder>(
                  catalogs_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          catalogs_ = null;
        }
        return catalogsBuilder_;
      }

      // optional .exec.shared.DrillPBError error = 3;
      private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> errorBuilder_;
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public boolean hasError() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
        if (errorBuilder_ == null) {
          return error_;
        } else {
          return errorBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder setError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          error_ = value;
          onChanged();
        } else {
          errorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder setError(
          org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder builderForValue) {
        if (errorBuilder_ == null) {
          error_ = builderForValue.build();
          onChanged();
        } else {
          errorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder mergeError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004) &&
              error_ != org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance()) {
            error_ =
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.newBuilder(error_).mergeFrom(value).buildPartial();
          } else {
            error_ = value;
          }
          onChanged();
        } else {
          errorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder clearError() {
        if (errorBuilder_ == null) {
          error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
          onChanged();
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder getErrorBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getErrorFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
        if (errorBuilder_ != null) {
          return errorBuilder_.getMessageOrBuilder();
        } else {
          return error_;
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> 
          getErrorFieldBuilder() {
        if (errorBuilder_ == null) {
          errorBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder>(
                  error_,
                  getParentForChildren(),
                  isClean());
          error_ = null;
        }
        return errorBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.GetCatalogsResp)
    }

    static {
      defaultInstance = new GetCatalogsResp(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetCatalogsResp)
  }

  public interface GetSchemasReqOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.user.LikeFilter catalog_name_filter = 1;
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    boolean hasCatalogNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder();

    // optional .exec.user.LikeFilter schema_name_filter = 2;
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    boolean hasSchemaNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder();
  }
  /**
   * Protobuf type {@code exec.user.GetSchemasReq}
   *
   * <pre>
   *
   * Request message for getting the metadata for schemas satisfying the given optional filters.
   * </pre>
   */
  public static final class GetSchemasReq extends
      com.google.protobuf.GeneratedMessage
      implements GetSchemasReqOrBuilder {
    // Use GetSchemasReq.newBuilder() to construct.
    private GetSchemasReq(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private GetSchemasReq(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final GetSchemasReq defaultInstance;
    public static GetSchemasReq getDefaultInstance() {
      return defaultInstance;
    }

    public GetSchemasReq getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private GetSchemasReq(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = catalogNameFilter_.toBuilder();
              }
              catalogNameFilter_ = input.readMessage(org.apache.drill.exec.proto.UserProtos.LikeFilter.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(catalogNameFilter_);
                catalogNameFilter_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 18: {
              org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = schemaNameFilter_.toBuilder();
              }
              schemaNameFilter_ = input.readMessage(org.apache.drill.exec.proto.UserProtos.LikeFilter.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(schemaNameFilter_);
                schemaNameFilter_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasReq_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasReq_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetSchemasReq.class, org.apache.drill.exec.proto.UserProtos.GetSchemasReq.Builder.class);
    }

    public static com.google.protobuf.Parser<GetSchemasReq> PARSER =
        new com.google.protobuf.AbstractParser<GetSchemasReq>() {
      public GetSchemasReq parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new GetSchemasReq(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<GetSchemasReq> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.user.LikeFilter catalog_name_filter = 1;
    public static final int CATALOG_NAME_FILTER_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter catalogNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    public boolean hasCatalogNameFilter() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter() {
      return catalogNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder() {
      return catalogNameFilter_;
    }

    // optional .exec.user.LikeFilter schema_name_filter = 2;
    public static final int SCHEMA_NAME_FILTER_FIELD_NUMBER = 2;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter schemaNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    public boolean hasSchemaNameFilter() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter() {
      return schemaNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder() {
      return schemaNameFilter_;
    }

    private void initFields() {
      catalogNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      schemaNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, catalogNameFilter_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, schemaNameFilter_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, catalogNameFilter_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, schemaNameFilter_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetSchemasReq prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.GetSchemasReq}
     *
     * <pre>
     *
     * Request message for getting the metadata for schemas satisfying the given optional filters.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.GetSchemasReqOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasReq_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasReq_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetSchemasReq.class, org.apache.drill.exec.proto.UserProtos.GetSchemasReq.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetSchemasReq.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getCatalogNameFilterFieldBuilder();
          getSchemaNameFilterFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
        } else {
          catalogNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
        } else {
          schemaNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasReq_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.GetSchemasReq getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetSchemasReq.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.GetSchemasReq build() {
        org.apache.drill.exec.proto.UserProtos.GetSchemasReq result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.GetSchemasReq buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetSchemasReq result = new org.apache.drill.exec.proto.UserProtos.GetSchemasReq(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (catalogNameFilterBuilder_ == null) {
          result.catalogNameFilter_ = catalogNameFilter_;
        } else {
          result.catalogNameFilter_ = catalogNameFilterBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (schemaNameFilterBuilder_ == null) {
          result.schemaNameFilter_ = schemaNameFilter_;
        } else {
          result.schemaNameFilter_ = schemaNameFilterBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetSchemasReq) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetSchemasReq)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetSchemasReq other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetSchemasReq.getDefaultInstance()) return this;
        if (other.hasCatalogNameFilter()) {
          mergeCatalogNameFilter(other.getCatalogNameFilter());
        }
        if (other.hasSchemaNameFilter()) {
          mergeSchemaNameFilter(other.getSchemaNameFilter());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.GetSchemasReq parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.GetSchemasReq) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.user.LikeFilter catalog_name_filter = 1;
      private org.apache.drill.exec.proto.UserProtos.LikeFilter catalogNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> catalogNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public boolean hasCatalogNameFilter() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter() {
        if (catalogNameFilterBuilder_ == null) {
          return catalogNameFilter_;
        } else {
          return catalogNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder setCatalogNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (catalogNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          catalogNameFilter_ = value;
          onChanged();
        } else {
          catalogNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder setCatalogNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          catalogNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder mergeCatalogNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (catalogNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              catalogNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            catalogNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(catalogNameFilter_).mergeFrom(value).buildPartial();
          } else {
            catalogNameFilter_ = value;
          }
          onChanged();
        } else {
          catalogNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder clearCatalogNameFilter() {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
          onChanged();
        } else {
          catalogNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getCatalogNameFilterBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCatalogNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder() {
        if (catalogNameFilterBuilder_ != null) {
          return catalogNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return catalogNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getCatalogNameFilterFieldBuilder() {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  catalogNameFilter_,
                  getParentForChildren(),
                  isClean());
          catalogNameFilter_ = null;
        }
        return catalogNameFilterBuilder_;
      }

      // optional .exec.user.LikeFilter schema_name_filter = 2;
      private org.apache.drill.exec.proto.UserProtos.LikeFilter schemaNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> schemaNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public boolean hasSchemaNameFilter() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter() {
        if (schemaNameFilterBuilder_ == null) {
          return schemaNameFilter_;
        } else {
          return schemaNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder setSchemaNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (schemaNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          schemaNameFilter_ = value;
          onChanged();
        } else {
          schemaNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder setSchemaNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          schemaNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder mergeSchemaNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (schemaNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002) &&
              schemaNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            schemaNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(schemaNameFilter_).mergeFrom(value).buildPartial();
          } else {
            schemaNameFilter_ = value;
          }
          onChanged();
        } else {
          schemaNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder clearSchemaNameFilter() {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
          onChanged();
        } else {
          schemaNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getSchemaNameFilterBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSchemaNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder() {
        if (schemaNameFilterBuilder_ != null) {
          return schemaNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return schemaNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getSchemaNameFilterFieldBuilder() {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  schemaNameFilter_,
                  getParentForChildren(),
                  isClean());
          schemaNameFilter_ = null;
        }
        return schemaNameFilterBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.GetSchemasReq)
    }

    static {
      defaultInstance = new GetSchemasReq(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetSchemasReq)
  }

  public interface SchemaMetadataOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional string catalog_name = 1;
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    boolean hasCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    java.lang.String getCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    com.google.protobuf.ByteString
        getCatalogNameBytes();

    // optional string schema_name = 2;
    /**
     * <code>optional string schema_name = 2;</code>
     */
    boolean hasSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     */
    java.lang.String getSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     */
    com.google.protobuf.ByteString
        getSchemaNameBytes();

    // optional string owner = 3;
    /**
     * <code>optional string owner = 3;</code>
     */
    boolean hasOwner();
    /**
     * <code>optional string owner = 3;</code>
     */
    java.lang.String getOwner();
    /**
     * <code>optional string owner = 3;</code>
     */
    com.google.protobuf.ByteString
        getOwnerBytes();

    // optional string type = 4;
    /**
     * <code>optional string type = 4;</code>
     *
     * <pre>
     * Type. Ex. "file", "mongodb", "hive" etc.
     * </pre>
     */
    boolean hasType();
    /**
     * <code>optional string type = 4;</code>
     *
     * <pre>
     * Type. Ex. "file", "mongodb", "hive" etc.
     * </pre>
     */
    java.lang.String getType();
    /**
     * <code>optional string type = 4;</code>
     *
     * <pre>
     * Type. Ex. "file", "mongodb", "hive" etc.
     * </pre>
     */
    com.google.protobuf.ByteString
        getTypeBytes();

    // optional string mutable = 5;
    /**
     * <code>optional string mutable = 5;</code>
     */
    boolean hasMutable();
    /**
     * <code>optional string mutable = 5;</code>
     */
    java.lang.String getMutable();
    /**
     * <code>optional string mutable = 5;</code>
     */
    com.google.protobuf.ByteString
        getMutableBytes();
  }
  /**
   * Protobuf type {@code exec.user.SchemaMetadata}
   *
   * <pre>
   *
   * Message encapsulating metadata for a Schema.
   * </pre>
   */
  public static final class SchemaMetadata extends
      com.google.protobuf.GeneratedMessage
      implements SchemaMetadataOrBuilder {
    // Use SchemaMetadata.newBuilder() to construct.
    private SchemaMetadata(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private SchemaMetadata(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final SchemaMetadata defaultInstance;
    public static SchemaMetadata getDefaultInstance() {
      return defaultInstance;
    }

    public SchemaMetadata getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private SchemaMetadata(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              catalogName_ = input.readBytes();
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              schemaName_ = input.readBytes();
              break;
            }
            case 26: {
              bitField0_ |= 0x00000004;
              owner_ = input.readBytes();
              break;
            }
            case 34: {
              bitField0_ |= 0x00000008;
              type_ = input.readBytes();
              break;
            }
            case 42: {
              bitField0_ |= 0x00000010;
              mutable_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_SchemaMetadata_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_SchemaMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.SchemaMetadata.class, org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder.class);
    }

    public static com.google.protobuf.Parser<SchemaMetadata> PARSER =
        new com.google.protobuf.AbstractParser<SchemaMetadata>() {
      public SchemaMetadata parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new SchemaMetadata(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<SchemaMetadata> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional string catalog_name = 1;
    public static final int CATALOG_NAME_FIELD_NUMBER = 1;
    private java.lang.Object catalogName_;
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    public boolean hasCatalogName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    public java.lang.String getCatalogName() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          catalogName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getCatalogNameBytes() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        catalogName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string schema_name = 2;
    public static final int SCHEMA_NAME_FIELD_NUMBER = 2;
    private java.lang.Object schemaName_;
    /**
     * <code>optional string schema_name = 2;</code>
     */
    public boolean hasSchemaName() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string schema_name = 2;</code>
     */
    public java.lang.String getSchemaName() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          schemaName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string schema_name = 2;</code>
     */
    public com.google.protobuf.ByteString
        getSchemaNameBytes() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        schemaName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string owner = 3;
    public static final int OWNER_FIELD_NUMBER = 3;
    private java.lang.Object owner_;
    /**
     * <code>optional string owner = 3;</code>
     */
    public boolean hasOwner() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional string owner = 3;</code>
     */
    public java.lang.String getOwner() {
      java.lang.Object ref = owner_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          owner_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string owner = 3;</code>
     */
    public com.google.protobuf.ByteString
        getOwnerBytes() {
      java.lang.Object ref = owner_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        owner_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string type = 4;
    public static final int TYPE_FIELD_NUMBER = 4;
    private java.lang.Object type_;
    /**
     * <code>optional string type = 4;</code>
     *
     * <pre>
     * Type. Ex. "file", "mongodb", "hive" etc.
     * </pre>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional string type = 4;</code>
     *
     * <pre>
     * Type. Ex. "file", "mongodb", "hive" etc.
     * </pre>
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          type_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string type = 4;</code>
     *
     * <pre>
     * Type. Ex. "file", "mongodb", "hive" etc.
     * </pre>
     */
    public com.google.protobuf.ByteString
        getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string mutable = 5;
    public static final int MUTABLE_FIELD_NUMBER = 5;
    private java.lang.Object mutable_;
    /**
     * <code>optional string mutable = 5;</code>
     */
    public boolean hasMutable() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional string mutable = 5;</code>
     */
    public java.lang.String getMutable() {
      java.lang.Object ref = mutable_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          mutable_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string mutable = 5;</code>
     */
    public com.google.protobuf.ByteString
        getMutableBytes() {
      java.lang.Object ref = mutable_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        mutable_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      catalogName_ = "";
      schemaName_ = "";
      owner_ = "";
      type_ = "";
      mutable_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getCatalogNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getSchemaNameBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(3, getOwnerBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeBytes(4, getTypeBytes());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeBytes(5, getMutableBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getCatalogNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getSchemaNameBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, getOwnerBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(4, getTypeBytes());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(5, getMutableBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.SchemaMetadata prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.SchemaMetadata}
     *
     * <pre>
     *
     * Message encapsulating metadata for a Schema.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_SchemaMetadata_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_SchemaMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.SchemaMetadata.class, org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.SchemaMetadata.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        catalogName_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        schemaName_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        owner_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        type_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        mutable_ = "";
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_SchemaMetadata_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.SchemaMetadata getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.SchemaMetadata.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.SchemaMetadata build() {
        org.apache.drill.exec.proto.UserProtos.SchemaMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.SchemaMetadata buildPartial() {
        org.apache.drill.exec.proto.UserProtos.SchemaMetadata result = new org.apache.drill.exec.proto.UserProtos.SchemaMetadata(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.catalogName_ = catalogName_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.schemaName_ = schemaName_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.owner_ = owner_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.mutable_ = mutable_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.SchemaMetadata) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.SchemaMetadata)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.SchemaMetadata other) {
        if (other == org.apache.drill.exec.proto.UserProtos.SchemaMetadata.getDefaultInstance()) return this;
        if (other.hasCatalogName()) {
          bitField0_ |= 0x00000001;
          catalogName_ = other.catalogName_;
          onChanged();
        }
        if (other.hasSchemaName()) {
          bitField0_ |= 0x00000002;
          schemaName_ = other.schemaName_;
          onChanged();
        }
        if (other.hasOwner()) {
          bitField0_ |= 0x00000004;
          owner_ = other.owner_;
          onChanged();
        }
        if (other.hasType()) {
          bitField0_ |= 0x00000008;
          type_ = other.type_;
          onChanged();
        }
        if (other.hasMutable()) {
          bitField0_ |= 0x00000010;
          mutable_ = other.mutable_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.SchemaMetadata parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.SchemaMetadata) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional string catalog_name = 1;
      private java.lang.Object catalogName_ = "";
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public boolean hasCatalogName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public java.lang.String getCatalogName() {
        java.lang.Object ref = catalogName_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          catalogName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public com.google.protobuf.ByteString
          getCatalogNameBytes() {
        java.lang.Object ref = catalogName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          catalogName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public Builder setCatalogName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public Builder clearCatalogName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        catalogName_ = getDefaultInstance().getCatalogName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public Builder setCatalogNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }

      // optional string schema_name = 2;
      private java.lang.Object schemaName_ = "";
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public boolean hasSchemaName() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public java.lang.String getSchemaName() {
        java.lang.Object ref = schemaName_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          schemaName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public com.google.protobuf.ByteString
          getSchemaNameBytes() {
        java.lang.Object ref = schemaName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          schemaName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public Builder setSchemaName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schemaName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public Builder clearSchemaName() {
        bitField0_ = (bitField0_ & ~0x00000002);
        schemaName_ = getDefaultInstance().getSchemaName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public Builder setSchemaNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schemaName_ = value;
        onChanged();
        return this;
      }

      // optional string owner = 3;
      private java.lang.Object owner_ = "";
      /**
       * <code>optional string owner = 3;</code>
       */
      public boolean hasOwner() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional string owner = 3;</code>
       */
      public java.lang.String getOwner() {
        java.lang.Object ref = owner_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          owner_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string owner = 3;</code>
       */
      public com.google.protobuf.ByteString
          getOwnerBytes() {
        java.lang.Object ref = owner_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          owner_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string owner = 3;</code>
       */
      public Builder setOwner(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        owner_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string owner = 3;</code>
       */
      public Builder clearOwner() {
        bitField0_ = (bitField0_ & ~0x00000004);
        owner_ = getDefaultInstance().getOwner();
        onChanged();
        return this;
      }
      /**
       * <code>optional string owner = 3;</code>
       */
      public Builder setOwnerBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        owner_ = value;
        onChanged();
        return this;
      }

      // optional string type = 4;
      private java.lang.Object type_ = "";
      /**
       * <code>optional string type = 4;</code>
       *
       * <pre>
       * Type. Ex. "file", "mongodb", "hive" etc.
       * </pre>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional string type = 4;</code>
       *
       * <pre>
       * Type. Ex. "file", "mongodb", "hive" etc.
       * </pre>
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          type_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string type = 4;</code>
       *
       * <pre>
       * Type. Ex. "file", "mongodb", "hive" etc.
       * </pre>
       */
      public com.google.protobuf.ByteString
          getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string type = 4;</code>
       *
       * <pre>
       * Type. Ex. "file", "mongodb", "hive" etc.
       * </pre>
       */
      public Builder setType(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string type = 4;</code>
       *
       * <pre>
       * Type. Ex. "file", "mongodb", "hive" etc.
       * </pre>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000008);
        type_ = getDefaultInstance().getType();
        onChanged();
        return this;
      }
      /**
       * <code>optional string type = 4;</code>
       *
       * <pre>
       * Type. Ex. "file", "mongodb", "hive" etc.
       * </pre>
       */
      public Builder setTypeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        type_ = value;
        onChanged();
        return this;
      }

      // optional string mutable = 5;
      private java.lang.Object mutable_ = "";
      /**
       * <code>optional string mutable = 5;</code>
       */
      public boolean hasMutable() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional string mutable = 5;</code>
       */
      public java.lang.String getMutable() {
        java.lang.Object ref = mutable_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          mutable_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string mutable = 5;</code>
       */
      public com.google.protobuf.ByteString
          getMutableBytes() {
        java.lang.Object ref = mutable_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          mutable_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string mutable = 5;</code>
       */
      public Builder setMutable(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
        mutable_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string mutable = 5;</code>
       */
      public Builder clearMutable() {
        bitField0_ = (bitField0_ & ~0x00000010);
        mutable_ = getDefaultInstance().getMutable();
        onChanged();
        return this;
      }
      /**
       * <code>optional string mutable = 5;</code>
       */
      public Builder setMutableBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
        mutable_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.SchemaMetadata)
    }

    static {
      defaultInstance = new SchemaMetadata(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.SchemaMetadata)
  }

  public interface GetSchemasRespOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.user.RequestStatus status = 1;
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     */
    boolean hasStatus();
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus();

    // repeated .exec.user.SchemaMetadata schemas = 2;
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    java.util.List<org.apache.drill.exec.proto.UserProtos.SchemaMetadata> 
        getSchemasList();
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.SchemaMetadata getSchemas(int index);
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    int getSchemasCount();
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    java.util.List<? extends org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder> 
        getSchemasOrBuilderList();
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder getSchemasOrBuilder(
        int index);

    // optional .exec.shared.DrillPBError error = 3;
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    boolean hasError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBError getError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder();
  }
  /**
   * Protobuf type {@code exec.user.GetSchemasResp}
   *
   * <pre>
   *
   * Response message for GetSchemasReq.
   * </pre>
   */
  public static final class GetSchemasResp extends
      com.google.protobuf.GeneratedMessage
      implements GetSchemasRespOrBuilder {
    // Use GetSchemasResp.newBuilder() to construct.
    private GetSchemasResp(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private GetSchemasResp(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final GetSchemasResp defaultInstance;
    public static GetSchemasResp getDefaultInstance() {
      return defaultInstance;
    }

    public GetSchemasResp getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private GetSchemasResp(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.UserProtos.RequestStatus value = org.apache.drill.exec.proto.UserProtos.RequestStatus.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                status_ = value;
              }
              break;
            }
            case 18: {
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                schemas_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.SchemaMetadata>();
                mutable_bitField0_ |= 0x00000002;
              }
              schemas_.add(input.readMessage(org.apache.drill.exec.proto.UserProtos.SchemaMetadata.PARSER, extensionRegistry));
              break;
            }
            case 26: {
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = error_.toBuilder();
              }
              error_ = input.readMessage(org.apache.drill.exec.proto.UserBitShared.DrillPBError.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(error_);
                error_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          schemas_ = java.util.Collections.unmodifiableList(schemas_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasResp_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasResp_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetSchemasResp.class, org.apache.drill.exec.proto.UserProtos.GetSchemasResp.Builder.class);
    }

    public static com.google.protobuf.Parser<GetSchemasResp> PARSER =
        new com.google.protobuf.AbstractParser<GetSchemasResp>() {
      public GetSchemasResp parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new GetSchemasResp(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<GetSchemasResp> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.user.RequestStatus status = 1;
    public static final int STATUS_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserProtos.RequestStatus status_;
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus() {
      return status_;
    }

    // repeated .exec.user.SchemaMetadata schemas = 2;
    public static final int SCHEMAS_FIELD_NUMBER = 2;
    private java.util.List<org.apache.drill.exec.proto.UserProtos.SchemaMetadata> schemas_;
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    public java.util.List<org.apache.drill.exec.proto.UserProtos.SchemaMetadata> getSchemasList() {
      return schemas_;
    }
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder> 
        getSchemasOrBuilderList() {
      return schemas_;
    }
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    public int getSchemasCount() {
      return schemas_.size();
    }
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.SchemaMetadata getSchemas(int index) {
      return schemas_.get(index);
    }
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder getSchemasOrBuilder(
        int index) {
      return schemas_.get(index);
    }

    // optional .exec.shared.DrillPBError error = 3;
    public static final int ERROR_FIELD_NUMBER = 3;
    private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_;
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
      return error_;
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
      return error_;
    }

    private void initFields() {
      status_ = org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS;
      schemas_ = java.util.Collections.emptyList();
      error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, status_.getNumber());
      }
      for (int i = 0; i < schemas_.size(); i++) {
        output.writeMessage(2, schemas_.get(i));
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(3, error_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, status_.getNumber());
      }
      for (int i = 0; i < schemas_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, schemas_.get(i));
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, error_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetSchemasResp prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.GetSchemasResp}
     *
     * <pre>
     *
     * Response message for GetSchemasReq.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.GetSchemasRespOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasResp_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasResp_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetSchemasResp.class, org.apache.drill.exec.proto.UserProtos.GetSchemasResp.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetSchemasResp.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getSchemasFieldBuilder();
          getErrorFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        status_ = org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (schemasBuilder_ == null) {
          schemas_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          schemasBuilder_.clear();
        }
        if (errorBuilder_ == null) {
          error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasResp_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.GetSchemasResp getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetSchemasResp.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.GetSchemasResp build() {
        org.apache.drill.exec.proto.UserProtos.GetSchemasResp result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.GetSchemasResp buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetSchemasResp result = new org.apache.drill.exec.proto.UserProtos.GetSchemasResp(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.status_ = status_;
        if (schemasBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            schemas_ = java.util.Collections.unmodifiableList(schemas_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.schemas_ = schemas_;
        } else {
          result.schemas_ = schemasBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000002;
        }
        if (errorBuilder_ == null) {
          result.error_ = error_;
        } else {
          result.error_ = errorBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetSchemasResp) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetSchemasResp)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetSchemasResp other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetSchemasResp.getDefaultInstance()) return this;
        if (other.hasStatus()) {
          setStatus(other.getStatus());
        }
        if (schemasBuilder_ == null) {
          if (!other.schemas_.isEmpty()) {
            if (schemas_.isEmpty()) {
              schemas_ = other.schemas_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureSchemasIsMutable();
              schemas_.addAll(other.schemas_);
            }
            onChanged();
          }
        } else {
          if (!other.schemas_.isEmpty()) {
            if (schemasBuilder_.isEmpty()) {
              schemasBuilder_.dispose();
              schemasBuilder_ = null;
              schemas_ = other.schemas_;
              bitField0_ = (bitField0_ & ~0x00000002);
              schemasBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getSchemasFieldBuilder() : null;
            } else {
              schemasBuilder_.addAllMessages(other.schemas_);
            }
          }
        }
        if (other.hasError()) {
          mergeError(other.getError());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.GetSchemasResp parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.GetSchemasResp) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.user.RequestStatus status = 1;
      private org.apache.drill.exec.proto.UserProtos.RequestStatus status_ = org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS;
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus() {
        return status_;
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       */
      public Builder setStatus(org.apache.drill.exec.proto.UserProtos.RequestStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        status_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS;
        onChanged();
        return this;
      }

      // repeated .exec.user.SchemaMetadata schemas = 2;
      private java.util.List<org.apache.drill.exec.proto.UserProtos.SchemaMetadata> schemas_ =
        java.util.Collections.emptyList();
      private void ensureSchemasIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          schemas_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.SchemaMetadata>(schemas_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.SchemaMetadata, org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder, org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder> schemasBuilder_;

      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.SchemaMetadata> getSchemasList() {
        if (schemasBuilder_ == null) {
          return java.util.Collections.unmodifiableList(schemas_);
        } else {
          return schemasBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public int getSchemasCount() {
        if (schemasBuilder_ == null) {
          return schemas_.size();
        } else {
          return schemasBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.SchemaMetadata getSchemas(int index) {
        if (schemasBuilder_ == null) {
          return schemas_.get(index);
        } else {
          return schemasBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder setSchemas(
          int index, org.apache.drill.exec.proto.UserProtos.SchemaMetadata value) {
        if (schemasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSchemasIsMutable();
          schemas_.set(index, value);
          onChanged();
        } else {
          schemasBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder setSchemas(
          int index, org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder builderForValue) {
        if (schemasBuilder_ == null) {
          ensureSchemasIsMutable();
          schemas_.set(index, builderForValue.build());
          onChanged();
        } else {
          schemasBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder addSchemas(org.apache.drill.exec.proto.UserProtos.SchemaMetadata value) {
        if (schemasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSchemasIsMutable();
          schemas_.add(value);
          onChanged();
        } else {
          schemasBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder addSchemas(
          int index, org.apache.drill.exec.proto.UserProtos.SchemaMetadata value) {
        if (schemasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSchemasIsMutable();
          schemas_.add(index, value);
          onChanged();
        } else {
          schemasBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder addSchemas(
          org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder builderForValue) {
        if (schemasBuilder_ == null) {
          ensureSchemasIsMutable();
          schemas_.add(builderForValue.build());
          onChanged();
        } else {
          schemasBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder addSchemas(
          int index, org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder builderForValue) {
        if (schemasBuilder_ == null) {
          ensureSchemasIsMutable();
          schemas_.add(index, builderForValue.build());
          onChanged();
        } else {
          schemasBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder addAllSchemas(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.UserProtos.SchemaMetadata> values) {
        if (schemasBuilder_ == null) {
          ensureSchemasIsMutable();
          super.addAll(values, schemas_);
          onChanged();
        } else {
          schemasBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder clearSchemas() {
        if (schemasBuilder_ == null) {
          schemas_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          schemasBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder removeSchemas(int index) {
        if (schemasBuilder_ == null) {
          ensureSchemasIsMutable();
          schemas_.remove(index);
          onChanged();
        } else {
          schemasBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder getSchemasBuilder(
          int index) {
        return getSchemasFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder getSchemasOrBuilder(
          int index) {
        if (schemasBuilder_ == null) {
          return schemas_.get(index);  } else {
          return schemasBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder> 
           getSchemasOrBuilderList() {
        if (schemasBuilder_ != null) {
          return schemasBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(schemas_);
        }
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder addSchemasBuilder() {
        return getSchemasFieldBuilder().addBuilder(
            org.apache.drill.exec.proto.UserProtos.SchemaMetadata.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder addSchemasBuilder(
          int index) {
        return getSchemasFieldBuilder().addBuilder(
            index, org.apache.drill.exec.proto.UserProtos.SchemaMetadata.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder> 
           getSchemasBuilderList() {
        return getSchemasFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.SchemaMetadata, org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder, org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder> 
          getSchemasFieldBuilder() {
        if (schemasBuilder_ == null) {
          schemasBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.SchemaMetadata, org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder, org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder>(
                  schemas_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          schemas_ = null;
        }
        return schemasBuilder_;
      }

      // optional .exec.shared.DrillPBError error = 3;
      private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> errorBuilder_;
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public boolean hasError() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
        if (errorBuilder_ == null) {
          return error_;
        } else {
          return errorBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder setError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          error_ = value;
          onChanged();
        } else {
          errorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder setError(
          org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder builderForValue) {
        if (errorBuilder_ == null) {
          error_ = builderForValue.build();
          onChanged();
        } else {
          errorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder mergeError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004) &&
              error_ != org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance()) {
            error_ =
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.newBuilder(error_).mergeFrom(value).buildPartial();
          } else {
            error_ = value;
          }
          onChanged();
        } else {
          errorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder clearError() {
        if (errorBuilder_ == null) {
          error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
          onChanged();
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder getErrorBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getErrorFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
        if (errorBuilder_ != null) {
          return errorBuilder_.getMessageOrBuilder();
        } else {
          return error_;
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> 
          getErrorFieldBuilder() {
        if (errorBuilder_ == null) {
          errorBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder>(
                  error_,
                  getParentForChildren(),
                  isClean());
          error_ = null;
        }
        return errorBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.GetSchemasResp)
    }

    static {
      defaultInstance = new GetSchemasResp(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetSchemasResp)
  }

  public interface GetTablesReqOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.user.LikeFilter catalog_name_filter = 1;
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    boolean hasCatalogNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder();

    // optional .exec.user.LikeFilter schema_name_filter = 2;
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    boolean hasSchemaNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder();

    // optional .exec.user.LikeFilter table_name_filter = 3;
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     */
    boolean hasTableNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getTableNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getTableNameFilterOrBuilder();

    // repeated string table_type_filter = 4;
    /**
     * <code>repeated string table_type_filter = 4;</code>
     */
    java.util.List<java.lang.String>
    getTableTypeFilterList();
    /**
     * <code>repeated string table_type_filter = 4;</code>
     */
    int getTableTypeFilterCount();
    /**
     * <code>repeated string table_type_filter = 4;</code>
     */
    java.lang.String getTableTypeFilter(int index);
    /**
     * <code>repeated string table_type_filter = 4;</code>
     */
    com.google.protobuf.ByteString
        getTableTypeFilterBytes(int index);
  }
  /**
   * Protobuf type {@code exec.user.GetTablesReq}
   *
   * <pre>
   *
   * Request message for getting the metadata for tables satisfying the given optional filters.
   * </pre>
   */
  public static final class GetTablesReq extends
      com.google.protobuf.GeneratedMessage
      implements GetTablesReqOrBuilder {
    // Use GetTablesReq.newBuilder() to construct.
    private GetTablesReq(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private GetTablesReq(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final GetTablesReq defaultInstance;
    public static GetTablesReq getDefaultInstance() {
      return defaultInstance;
    }

    public GetTablesReq getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private GetTablesReq(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = catalogNameFilter_.toBuilder();
              }
              catalogNameFilter_ = input.readMessage(org.apache.drill.exec.proto.UserProtos.LikeFilter.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(catalogNameFilter_);
                catalogNameFilter_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 18: {
              org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = schemaNameFilter_.toBuilder();
              }
              schemaNameFilter_ = input.readMessage(org.apache.drill.exec.proto.UserProtos.LikeFilter.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(schemaNameFilter_);
                schemaNameFilter_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
            case 26: {
              org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder subBuilder = null;
              if (((bitField0_ & 0x00000004) == 0x00000004)) {
                subBuilder = tableNameFilter_.toBuilder();
              }
              tableNameFilter_ = input.readMessage(org.apache.drill.exec.proto.UserProtos.LikeFilter.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(tableNameFilter_);
                tableNameFilter_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000004;
              break;
            }
            case 34: {
              if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                tableTypeFilter_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000008;
              }
              tableTypeFilter_.add(input.readBytes());
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
          tableTypeFilter_ = new com.google.protobuf.UnmodifiableLazyStringList(tableTypeFilter_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesReq_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesReq_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetTablesReq.class, org.apache.drill.exec.proto.UserProtos.GetTablesReq.Builder.class);
    }

    public static com.google.protobuf.Parser<GetTablesReq> PARSER =
        new com.google.protobuf.AbstractParser<GetTablesReq>() {
      public GetTablesReq parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new GetTablesReq(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<GetTablesReq> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.user.LikeFilter catalog_name_filter = 1;
    public static final int CATALOG_NAME_FILTER_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter catalogNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    public boolean hasCatalogNameFilter() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter() {
      return catalogNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder() {
      return catalogNameFilter_;
    }

    // optional .exec.user.LikeFilter schema_name_filter = 2;
    public static final int SCHEMA_NAME_FILTER_FIELD_NUMBER = 2;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter schemaNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    public boolean hasSchemaNameFilter() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter() {
      return schemaNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder() {
      return schemaNameFilter_;
    }

    // optional .exec.user.LikeFilter table_name_filter = 3;
    public static final int TABLE_NAME_FILTER_FIELD_NUMBER = 3;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter tableNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     */
    public boolean hasTableNameFilter() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getTableNameFilter() {
      return tableNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getTableNameFilterOrBuilder() {
      return tableNameFilter_;
    }

    // repeated string table_type_filter = 4;
    public static final int TABLE_TYPE_FILTER_FIELD_NUMBER = 4;
    private com.google.protobuf.LazyStringList tableTypeFilter_;
    /**
     * <code>repeated string table_type_filter = 4;</code>
     */
    public java.util.List<java.lang.String>
        getTableTypeFilterList() {
      return tableTypeFilter_;
    }
    /**
     * <code>repeated string table_type_filter = 4;</code>
     */
    public int getTableTypeFilterCount() {
      return tableTypeFilter_.size();
    }
    /**
     * <code>repeated string table_type_filter = 4;</code>
     */
    public java.lang.String getTableTypeFilter(int index) {
      return tableTypeFilter_.get(index);
    }
    /**
     * <code>repeated string table_type_filter = 4;</code>
     */
    public com.google.protobuf.ByteString
        getTableTypeFilterBytes(int index) {
      return tableTypeFilter_.getByteString(index);
    }

    private void initFields() {
      catalogNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      schemaNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      tableNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      tableTypeFilter_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, catalogNameFilter_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, schemaNameFilter_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, tableNameFilter_);
      }
      for (int i = 0; i < tableTypeFilter_.size(); i++) {
        output.writeBytes(4, tableTypeFilter_.getByteString(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, catalogNameFilter_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, schemaNameFilter_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, tableNameFilter_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < tableTypeFilter_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeBytesSizeNoTag(tableTypeFilter_.getByteString(i));
        }
        size += dataSize;
        size += 1 * getTableTypeFilterList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetTablesReq prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.GetTablesReq}
     *
     * <pre>
     *
     * Request message for getting the metadata for tables satisfying the given optional filters.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.GetTablesReqOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesReq_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesReq_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetTablesReq.class, org.apache.drill.exec.proto.UserProtos.GetTablesReq.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetTablesReq.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getCatalogNameFilterFieldBuilder();
          getSchemaNameFilterFieldBuilder();
          getTableNameFilterFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
        } else {
          catalogNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
        } else {
          schemaNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (tableNameFilterBuilder_ == null) {
          tableNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
        } else {
          tableNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        tableTypeFilter_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesReq_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.GetTablesReq getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetTablesReq.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.GetTablesReq build() {
        org.apache.drill.exec.proto.UserProtos.GetTablesReq result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.GetTablesReq buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetTablesReq result = new org.apache.drill.exec.proto.UserProtos.GetTablesReq(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (catalogNameFilterBuilder_ == null) {
          result.catalogNameFilter_ = catalogNameFilter_;
        } else {
          result.catalogNameFilter_ = catalogNameFilterBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (schemaNameFilterBuilder_ == null) {
          result.schemaNameFilter_ = schemaNameFilter_;
        } else {
          result.schemaNameFilter_ = schemaNameFilterBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (tableNameFilterBuilder_ == null) {
          result.tableNameFilter_ = tableNameFilter_;
        } else {
          result.tableNameFilter_ = tableNameFilterBuilder_.build();
        }
        if (((bitField0_ & 0x00000008) == 0x00000008)) {
          tableTypeFilter_ = new com.google.protobuf.UnmodifiableLazyStringList(
              tableTypeFilter_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.tableTypeFilter_ = tableTypeFilter_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetTablesReq) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetTablesReq)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetTablesReq other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetTablesReq.getDefaultInstance()) return this;
        if (other.hasCatalogNameFilter()) {
          mergeCatalogNameFilter(other.getCatalogNameFilter());
        }
        if (other.hasSchemaNameFilter()) {
          mergeSchemaNameFilter(other.getSchemaNameFilter());
        }
        if (other.hasTableNameFilter()) {
          mergeTableNameFilter(other.getTableNameFilter());
        }
        if (!other.tableTypeFilter_.isEmpty()) {
          if (tableTypeFilter_.isEmpty()) {
            tableTypeFilter_ = other.tableTypeFilter_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureTableTypeFilterIsMutable();
            tableTypeFilter_.addAll(other.tableTypeFilter_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.GetTablesReq parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.GetTablesReq) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.user.LikeFilter catalog_name_filter = 1;
      private org.apache.drill.exec.proto.UserProtos.LikeFilter catalogNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> catalogNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public boolean hasCatalogNameFilter() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter() {
        if (catalogNameFilterBuilder_ == null) {
          return catalogNameFilter_;
        } else {
          return catalogNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder setCatalogNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (catalogNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          catalogNameFilter_ = value;
          onChanged();
        } else {
          catalogNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder setCatalogNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          catalogNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder mergeCatalogNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (catalogNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              catalogNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            catalogNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(catalogNameFilter_).mergeFrom(value).buildPartial();
          } else {
            catalogNameFilter_ = value;
          }
          onChanged();
        } else {
          catalogNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder clearCatalogNameFilter() {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
          onChanged();
        } else {
          catalogNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getCatalogNameFilterBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCatalogNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder() {
        if (catalogNameFilterBuilder_ != null) {
          return catalogNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return catalogNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getCatalogNameFilterFieldBuilder() {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  catalogNameFilter_,
                  getParentForChildren(),
                  isClean());
          catalogNameFilter_ = null;
        }
        return catalogNameFilterBuilder_;
      }

      // optional .exec.user.LikeFilter schema_name_filter = 2;
      private org.apache.drill.exec.proto.UserProtos.LikeFilter schemaNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> schemaNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public boolean hasSchemaNameFilter() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter() {
        if (schemaNameFilterBuilder_ == null) {
          return schemaNameFilter_;
        } else {
          return schemaNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder setSchemaNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (schemaNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          schemaNameFilter_ = value;
          onChanged();
        } else {
          schemaNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder setSchemaNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          schemaNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder mergeSchemaNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (schemaNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002) &&
              schemaNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            schemaNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(schemaNameFilter_).mergeFrom(value).buildPartial();
          } else {
            schemaNameFilter_ = value;
          }
          onChanged();
        } else {
          schemaNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder clearSchemaNameFilter() {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
          onChanged();
        } else {
          schemaNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getSchemaNameFilterBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSchemaNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder() {
        if (schemaNameFilterBuilder_ != null) {
          return schemaNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return schemaNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getSchemaNameFilterFieldBuilder() {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  schemaNameFilter_,
                  getParentForChildren(),
                  isClean());
          schemaNameFilter_ = null;
        }
        return schemaNameFilterBuilder_;
      }

      // optional .exec.user.LikeFilter table_name_filter = 3;
      private org.apache.drill.exec.proto.UserProtos.LikeFilter tableNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> tableNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public boolean hasTableNameFilter() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getTableNameFilter() {
        if (tableNameFilterBuilder_ == null) {
          return tableNameFilter_;
        } else {
          return tableNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public Builder setTableNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (tableNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          tableNameFilter_ = value;
          onChanged();
        } else {
          tableNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public Builder setTableNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (tableNameFilterBuilder_ == null) {
          tableNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          tableNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public Builder mergeTableNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (tableNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004) &&
              tableNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            tableNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(tableNameFilter_).mergeFrom(value).buildPartial();
          } else {
            tableNameFilter_ = value;
          }
          onChanged();
        } else {
          tableNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public Builder clearTableNameFilter() {
        if (tableNameFilterBuilder_ == null) {
          tableNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
          onChanged();
        } else {
          tableNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getTableNameFilterBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTableNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getTableNameFilterOrBuilder() {
        if (tableNameFilterBuilder_ != null) {
          return tableNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return tableNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getTableNameFilterFieldBuilder() {
        if (tableNameFilterBuilder_ == null) {
          tableNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  tableNameFilter_,
                  getParentForChildren(),
                  isClean());
          tableNameFilter_ = null;
        }
        return tableNameFilterBuilder_;
      }

      // repeated string table_type_filter = 4;
      private com.google.protobuf.LazyStringList tableTypeFilter_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureTableTypeFilterIsMutable() {
        if (!((bitField0_ & 0x00000008) == 0x00000008)) {
          tableTypeFilter_ = new com.google.protobuf.LazyStringArrayList(tableTypeFilter_);
          bitField0_ |= 0x00000008;
         }
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       */
      public java.util.List<java.lang.String>
          getTableTypeFilterList() {
        return java.util.Collections.unmodifiableList(tableTypeFilter_);
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       */
      public int getTableTypeFilterCount() {
        return tableTypeFilter_.size();
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       */
      public java.lang.String getTableTypeFilter(int index) {
        return tableTypeFilter_.get(index);
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       */
      public com.google.protobuf.ByteString
          getTableTypeFilterBytes(int index) {
        return tableTypeFilter_.getByteString(index);
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       */
      public Builder setTableTypeFilter(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureTableTypeFilterIsMutable();
        tableTypeFilter_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       */
      public Builder addTableTypeFilter(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureTableTypeFilterIsMutable();
        tableTypeFilter_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       */
      public Builder addAllTableTypeFilter(
          java.lang.Iterable<java.lang.String> values) {
        ensureTableTypeFilterIsMutable();
        super.addAll(values, tableTypeFilter_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       */
      public Builder clearTableTypeFilter() {
        tableTypeFilter_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       */
      public Builder addTableTypeFilterBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureTableTypeFilterIsMutable();
        tableTypeFilter_.add(value);
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.GetTablesReq)
    }

    static {
      defaultInstance = new GetTablesReq(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetTablesReq)
  }

  public interface TableMetadataOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional string catalog_name = 1;
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    boolean hasCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    java.lang.String getCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    com.google.protobuf.ByteString
        getCatalogNameBytes();

    // optional string schema_name = 2;
    /**
     * <code>optional string schema_name = 2;</code>
     */
    boolean hasSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     */
    java.lang.String getSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     */
    com.google.protobuf.ByteString
        getSchemaNameBytes();

    // optional string table_name = 3;
    /**
     * <code>optional string table_name = 3;</code>
     */
    boolean hasTableName();
    /**
     * <code>optional string table_name = 3;</code>
     */
    java.lang.String getTableName();
    /**
     * <code>optional string table_name = 3;</code>
     */
    com.google.protobuf.ByteString
        getTableNameBytes();

    // optional string type = 4;
    /**
     * <code>optional string type = 4;</code>
     *
     * <pre>
     * Type. Ex. "TABLE", "VIEW" etc.
     * </pre>
     */
    boolean hasType();
    /**
     * <code>optional string type = 4;</code>
     *
     * <pre>
     * Type. Ex. "TABLE", "VIEW" etc.
     * </pre>
     */
    java.lang.String getType();
    /**
     * <code>optional string type = 4;</code>
     *
     * <pre>
     * Type. Ex. "TABLE", "VIEW" etc.
     * </pre>
     */
    com.google.protobuf.ByteString
        getTypeBytes();
  }
  /**
   * Protobuf type {@code exec.user.TableMetadata}
   *
   * <pre>
   *
   * Message encapsulating metadata for a Table.
   * </pre>
   */
  public static final class TableMetadata extends
      com.google.protobuf.GeneratedMessage
      implements TableMetadataOrBuilder {
    // Use TableMetadata.newBuilder() to construct.
    private TableMetadata(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private TableMetadata(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final TableMetadata defaultInstance;
    public static TableMetadata getDefaultInstance() {
      return defaultInstance;
    }

    public TableMetadata getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private TableMetadata(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              catalogName_ = input.readBytes();
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              schemaName_ = input.readBytes();
              break;
            }
            case 26: {
              bitField0_ |= 0x00000004;
              tableName_ = input.readBytes();
              break;
            }
            case 34: {
              bitField0_ |= 0x00000008;
              type_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_TableMetadata_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_TableMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.TableMetadata.class, org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder.class);
    }

    public static com.google.protobuf.Parser<TableMetadata> PARSER =
        new com.google.protobuf.AbstractParser<TableMetadata>() {
      public TableMetadata parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new TableMetadata(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<TableMetadata> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional string catalog_name = 1;
    public static final int CATALOG_NAME_FIELD_NUMBER = 1;
    private java.lang.Object catalogName_;
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    public boolean hasCatalogName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    public java.lang.String getCatalogName() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          catalogName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getCatalogNameBytes() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        catalogName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string schema_name = 2;
    public static final int SCHEMA_NAME_FIELD_NUMBER = 2;
    private java.lang.Object schemaName_;
    /**
     * <code>optional string schema_name = 2;</code>
     */
    public boolean hasSchemaName() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string schema_name = 2;</code>
     */
    public java.lang.String getSchemaName() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          schemaName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string schema_name = 2;</code>
     */
    public com.google.protobuf.ByteString
        getSchemaNameBytes() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        schemaName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string table_name = 3;
    public static final int TABLE_NAME_FIELD_NUMBER = 3;
    private java.lang.Object tableName_;
    /**
     * <code>optional string table_name = 3;</code>
     */
    public boolean hasTableName() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional string table_name = 3;</code>
     */
    public java.lang.String getTableName() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          tableName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string table_name = 3;</code>
     */
    public com.google.protobuf.ByteString
        getTableNameBytes() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        tableName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string type = 4;
    public static final int TYPE_FIELD_NUMBER = 4;
    private java.lang.Object type_;
    /**
     * <code>optional string type = 4;</code>
     *
     * <pre>
     * Type. Ex. "TABLE", "VIEW" etc.
     * </pre>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional string type = 4;</code>
     *
     * <pre>
     * Type. Ex. "TABLE", "VIEW" etc.
     * </pre>
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          type_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string type = 4;</code>
     *
     * <pre>
     * Type. Ex. "TABLE", "VIEW" etc.
     * </pre>
     */
    public com.google.protobuf.ByteString
        getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      catalogName_ = "";
      schemaName_ = "";
      tableName_ = "";
      type_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getCatalogNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getSchemaNameBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(3, getTableNameBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeBytes(4, getTypeBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getCatalogNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getSchemaNameBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, getTableNameBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(4, getTypeBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.TableMetadata prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.TableMetadata}
     *
     * <pre>
     *
     * Message encapsulating metadata for a Table.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_TableMetadata_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_TableMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.TableMetadata.class, org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.TableMetadata.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        catalogName_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        schemaName_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        tableName_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        type_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_TableMetadata_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.TableMetadata getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.TableMetadata.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.TableMetadata build() {
        org.apache.drill.exec.proto.UserProtos.TableMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.TableMetadata buildPartial() {
        org.apache.drill.exec.proto.UserProtos.TableMetadata result = new org.apache.drill.exec.proto.UserProtos.TableMetadata(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.catalogName_ = catalogName_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.schemaName_ = schemaName_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.tableName_ = tableName_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.type_ = type_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.TableMetadata) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.TableMetadata)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.TableMetadata other) {
        if (other == org.apache.drill.exec.proto.UserProtos.TableMetadata.getDefaultInstance()) return this;
        if (other.hasCatalogName()) {
          bitField0_ |= 0x00000001;
          catalogName_ = other.catalogName_;
          onChanged();
        }
        if (other.hasSchemaName()) {
          bitField0_ |= 0x00000002;
          schemaName_ = other.schemaName_;
          onChanged();
        }
        if (other.hasTableName()) {
          bitField0_ |= 0x00000004;
          tableName_ = other.tableName_;
          onChanged();
        }
        if (other.hasType()) {
          bitField0_ |= 0x00000008;
          type_ = other.type_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.TableMetadata parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.TableMetadata) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional string catalog_name = 1;
      private java.lang.Object catalogName_ = "";
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public boolean hasCatalogName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public java.lang.String getCatalogName() {
        java.lang.Object ref = catalogName_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          catalogName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public com.google.protobuf.ByteString
          getCatalogNameBytes() {
        java.lang.Object ref = catalogName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          catalogName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public Builder setCatalogName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public Builder clearCatalogName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        catalogName_ = getDefaultInstance().getCatalogName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public Builder setCatalogNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }

      // optional string schema_name = 2;
      private java.lang.Object schemaName_ = "";
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public boolean hasSchemaName() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public java.lang.String getSchemaName() {
        java.lang.Object ref = schemaName_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          schemaName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public com.google.protobuf.ByteString
          getSchemaNameBytes() {
        java.lang.Object ref = schemaName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          schemaName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public Builder setSchemaName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schemaName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public Builder clearSchemaName() {
        bitField0_ = (bitField0_ & ~0x00000002);
        schemaName_ = getDefaultInstance().getSchemaName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public Builder setSchemaNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schemaName_ = value;
        onChanged();
        return this;
      }

      // optional string table_name = 3;
      private java.lang.Object tableName_ = "";
      /**
       * <code>optional string table_name = 3;</code>
       */
      public boolean hasTableName() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional string table_name = 3;</code>
       */
      public java.lang.String getTableName() {
        java.lang.Object ref = tableName_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          tableName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string table_name = 3;</code>
       */
      public com.google.protobuf.ByteString
          getTableNameBytes() {
        java.lang.Object ref = tableName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          tableName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string table_name = 3;</code>
       */
      public Builder setTableName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        tableName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string table_name = 3;</code>
       */
      public Builder clearTableName() {
        bitField0_ = (bitField0_ & ~0x00000004);
        tableName_ = getDefaultInstance().getTableName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string table_name = 3;</code>
       */
      public Builder setTableNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        tableName_ = value;
        onChanged();
        return this;
      }

      // optional string type = 4;
      private java.lang.Object type_ = "";
      /**
       * <code>optional string type = 4;</code>
       *
       * <pre>
       * Type. Ex. "TABLE", "VIEW" etc.
       * </pre>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional string type = 4;</code>
       *
       * <pre>
       * Type. Ex. "TABLE", "VIEW" etc.
       * </pre>
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          type_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string type = 4;</code>
       *
       * <pre>
       * Type. Ex. "TABLE", "VIEW" etc.
       * </pre>
       */
      public com.google.protobuf.ByteString
          getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string type = 4;</code>
       *
       * <pre>
       * Type. Ex. "TABLE", "VIEW" etc.
       * </pre>
       */
      public Builder setType(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string type = 4;</code>
       *
       * <pre>
       * Type. Ex. "TABLE", "VIEW" etc.
       * </pre>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000008);
        type_ = getDefaultInstance().getType();
        onChanged();
        return this;
      }
      /**
       * <code>optional string type = 4;</code>
       *
       * <pre>
       * Type. Ex. "TABLE", "VIEW" etc.
       * </pre>
       */
      public Builder setTypeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        type_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.TableMetadata)
    }

    static {
      defaultInstance = new TableMetadata(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.TableMetadata)
  }

  public interface GetTablesRespOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.user.RequestStatus status = 1;
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     */
    boolean hasStatus();
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus();

    // repeated .exec.user.TableMetadata tables = 2;
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    java.util.List<org.apache.drill.exec.proto.UserProtos.TableMetadata> 
        getTablesList();
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.TableMetadata getTables(int index);
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    int getTablesCount();
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    java.util.List<? extends org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder> 
        getTablesOrBuilderList();
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder getTablesOrBuilder(
        int index);

    // optional .exec.shared.DrillPBError error = 3;
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    boolean hasError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBError getError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder();
  }
  /**
   * Protobuf type {@code exec.user.GetTablesResp}
   *
   * <pre>
   *
   * Response message for GetTablesReq.
   * </pre>
   */
  public static final class GetTablesResp extends
      com.google.protobuf.GeneratedMessage
      implements GetTablesRespOrBuilder {
    // Use GetTablesResp.newBuilder() to construct.
    private GetTablesResp(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private GetTablesResp(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final GetTablesResp defaultInstance;
    public static GetTablesResp getDefaultInstance() {
      return defaultInstance;
    }

    public GetTablesResp getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private GetTablesResp(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.UserProtos.RequestStatus value = org.apache.drill.exec.proto.UserProtos.RequestStatus.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                status_ = value;
              }
              break;
            }
            case 18: {
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                tables_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.TableMetadata>();
                mutable_bitField0_ |= 0x00000002;
              }
              tables_.add(input.readMessage(org.apache.drill.exec.proto.UserProtos.TableMetadata.PARSER, extensionRegistry));
              break;
            }
            case 26: {
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = error_.toBuilder();
              }
              error_ = input.readMessage(org.apache.drill.exec.proto.UserBitShared.DrillPBError.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(error_);
                error_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          tables_ = java.util.Collections.unmodifiableList(tables_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesResp_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesResp_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetTablesResp.class, org.apache.drill.exec.proto.UserProtos.GetTablesResp.Builder.class);
    }

    public static com.google.protobuf.Parser<GetTablesResp> PARSER =
        new com.google.protobuf.AbstractParser<GetTablesResp>() {
      public GetTablesResp parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new GetTablesResp(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<GetTablesResp> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.user.RequestStatus status = 1;
    public static final int STATUS_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserProtos.RequestStatus status_;
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus() {
      return status_;
    }

    // repeated .exec.user.TableMetadata tables = 2;
    public static final int TABLES_FIELD_NUMBER = 2;
    private java.util.List<org.apache.drill.exec.proto.UserProtos.TableMetadata> tables_;
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    public java.util.List<org.apache.drill.exec.proto.UserProtos.TableMetadata> getTablesList() {
      return tables_;
    }
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder> 
        getTablesOrBuilderList() {
      return tables_;
    }
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    public int getTablesCount() {
      return tables_.size();
    }
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.TableMetadata getTables(int index) {
      return tables_.get(index);
    }
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder getTablesOrBuilder(
        int index) {
      return tables_.get(index);
    }

    // optional .exec.shared.DrillPBError error = 3;
    public static final int ERROR_FIELD_NUMBER = 3;
    private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_;
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
      return error_;
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
      return error_;
    }

    private void initFields() {
      status_ = org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS;
      tables_ = java.util.Collections.emptyList();
      error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, status_.getNumber());
      }
      for (int i = 0; i < tables_.size(); i++) {
        output.writeMessage(2, tables_.get(i));
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(3, error_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, status_.getNumber());
      }
      for (int i = 0; i < tables_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, tables_.get(i));
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, error_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetTablesResp prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.GetTablesResp}
     *
     * <pre>
     *
     * Response message for GetTablesReq.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.GetTablesRespOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesResp_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesResp_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetTablesResp.class, org.apache.drill.exec.proto.UserProtos.GetTablesResp.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetTablesResp.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getTablesFieldBuilder();
          getErrorFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        status_ = org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (tablesBuilder_ == null) {
          tables_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          tablesBuilder_.clear();
        }
        if (errorBuilder_ == null) {
          error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesResp_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.GetTablesResp getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetTablesResp.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.GetTablesResp build() {
        org.apache.drill.exec.proto.UserProtos.GetTablesResp result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.GetTablesResp buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetTablesResp result = new org.apache.drill.exec.proto.UserProtos.GetTablesResp(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.status_ = status_;
        if (tablesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            tables_ = java.util.Collections.unmodifiableList(tables_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.tables_ = tables_;
        } else {
          result.tables_ = tablesBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000002;
        }
        if (errorBuilder_ == null) {
          result.error_ = error_;
        } else {
          result.error_ = errorBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetTablesResp) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetTablesResp)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetTablesResp other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetTablesResp.getDefaultInstance()) return this;
        if (other.hasStatus()) {
          setStatus(other.getStatus());
        }
        if (tablesBuilder_ == null) {
          if (!other.tables_.isEmpty()) {
            if (tables_.isEmpty()) {
              tables_ = other.tables_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureTablesIsMutable();
              tables_.addAll(other.tables_);
            }
            onChanged();
          }
        } else {
          if (!other.tables_.isEmpty()) {
            if (tablesBuilder_.isEmpty()) {
              tablesBuilder_.dispose();
              tablesBuilder_ = null;
              tables_ = other.tables_;
              bitField0_ = (bitField0_ & ~0x00000002);
              tablesBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getTablesFieldBuilder() : null;
            } else {
              tablesBuilder_.addAllMessages(other.tables_);
            }
          }
        }
        if (other.hasError()) {
          mergeError(other.getError());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.GetTablesResp parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.GetTablesResp) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.user.RequestStatus status = 1;
      private org.apache.drill.exec.proto.UserProtos.RequestStatus status_ = org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS;
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus() {
        return status_;
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       */
      public Builder setStatus(org.apache.drill.exec.proto.UserProtos.RequestStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        status_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS;
        onChanged();
        return this;
      }

      // repeated .exec.user.TableMetadata tables = 2;
      private java.util.List<org.apache.drill.exec.proto.UserProtos.TableMetadata> tables_ =
        java.util.Collections.emptyList();
      private void ensureTablesIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          tables_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.TableMetadata>(tables_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.TableMetadata, org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder, org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder> tablesBuilder_;

      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.TableMetadata> getTablesList() {
        if (tablesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(tables_);
        } else {
          return tablesBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public int getTablesCount() {
        if (tablesBuilder_ == null) {
          return tables_.size();
        } else {
          return tablesBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.TableMetadata getTables(int index) {
        if (tablesBuilder_ == null) {
          return tables_.get(index);
        } else {
          return tablesBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder setTables(
          int index, org.apache.drill.exec.proto.UserProtos.TableMetadata value) {
        if (tablesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTablesIsMutable();
          tables_.set(index, value);
          onChanged();
        } else {
          tablesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder setTables(
          int index, org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder builderForValue) {
        if (tablesBuilder_ == null) {
          ensureTablesIsMutable();
          tables_.set(index, builderForValue.build());
          onChanged();
        } else {
          tablesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder addTables(org.apache.drill.exec.proto.UserProtos.TableMetadata value) {
        if (tablesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTablesIsMutable();
          tables_.add(value);
          onChanged();
        } else {
          tablesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder addTables(
          int index, org.apache.drill.exec.proto.UserProtos.TableMetadata value) {
        if (tablesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTablesIsMutable();
          tables_.add(index, value);
          onChanged();
        } else {
          tablesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder addTables(
          org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder builderForValue) {
        if (tablesBuilder_ == null) {
          ensureTablesIsMutable();
          tables_.add(builderForValue.build());
          onChanged();
        } else {
          tablesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder addTables(
          int index, org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder builderForValue) {
        if (tablesBuilder_ == null) {
          ensureTablesIsMutable();
          tables_.add(index, builderForValue.build());
          onChanged();
        } else {
          tablesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder addAllTables(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.UserProtos.TableMetadata> values) {
        if (tablesBuilder_ == null) {
          ensureTablesIsMutable();
          super.addAll(values, tables_);
          onChanged();
        } else {
          tablesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder clearTables() {
        if (tablesBuilder_ == null) {
          tables_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          tablesBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder removeTables(int index) {
        if (tablesBuilder_ == null) {
          ensureTablesIsMutable();
          tables_.remove(index);
          onChanged();
        } else {
          tablesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder getTablesBuilder(
          int index) {
        return getTablesFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder getTablesOrBuilder(
          int index) {
        if (tablesBuilder_ == null) {
          return tables_.get(index);  } else {
          return tablesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder> 
           getTablesOrBuilderList() {
        if (tablesBuilder_ != null) {
          return tablesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(tables_);
        }
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder addTablesBuilder() {
        return getTablesFieldBuilder().addBuilder(
            org.apache.drill.exec.proto.UserProtos.TableMetadata.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder addTablesBuilder(
          int index) {
        return getTablesFieldBuilder().addBuilder(
            index, org.apache.drill.exec.proto.UserProtos.TableMetadata.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder> 
           getTablesBuilderList() {
        return getTablesFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.TableMetadata, org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder, org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder> 
          getTablesFieldBuilder() {
        if (tablesBuilder_ == null) {
          tablesBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.TableMetadata, org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder, org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder>(
                  tables_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          tables_ = null;
        }
        return tablesBuilder_;
      }

      // optional .exec.shared.DrillPBError error = 3;
      private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> errorBuilder_;
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public boolean hasError() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
        if (errorBuilder_ == null) {
          return error_;
        } else {
          return errorBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder setError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          error_ = value;
          onChanged();
        } else {
          errorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder setError(
          org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder builderForValue) {
        if (errorBuilder_ == null) {
          error_ = builderForValue.build();
          onChanged();
        } else {
          errorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder mergeError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004) &&
              error_ != org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance()) {
            error_ =
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.newBuilder(error_).mergeFrom(value).buildPartial();
          } else {
            error_ = value;
          }
          onChanged();
        } else {
          errorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder clearError() {
        if (errorBuilder_ == null) {
          error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
          onChanged();
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder getErrorBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getErrorFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
        if (errorBuilder_ != null) {
          return errorBuilder_.getMessageOrBuilder();
        } else {
          return error_;
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> 
          getErrorFieldBuilder() {
        if (errorBuilder_ == null) {
          errorBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder>(
                  error_,
                  getParentForChildren(),
                  isClean());
          error_ = null;
        }
        return errorBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.GetTablesResp)
    }

    static {
      defaultInstance = new GetTablesResp(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetTablesResp)
  }

  public interface GetColumnsReqOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.user.LikeFilter catalog_name_filter = 1;
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    boolean hasCatalogNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder();

    // optional .exec.user.LikeFilter schema_name_filter = 2;
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    boolean hasSchemaNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder();

    // optional .exec.user.LikeFilter table_name_filter = 3;
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     */
    boolean hasTableNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getTableNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getTableNameFilterOrBuilder();

    // optional .exec.user.LikeFilter column_name_filter = 4;
    /**
     * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
     */
    boolean hasColumnNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getColumnNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getColumnNameFilterOrBuilder();
  }
  /**
   * Protobuf type {@code exec.user.GetColumnsReq}
   *
   * <pre>
   *
   * Request message for getting the metadata for columns satisfying the given optional filters.
   * </pre>
   */
  public static final class GetColumnsReq extends
      com.google.protobuf.GeneratedMessage
      implements GetColumnsReqOrBuilder {
    // Use GetColumnsReq.newBuilder() to construct.
    private GetColumnsReq(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private GetColumnsReq(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final GetColumnsReq defaultInstance;
    public static GetColumnsReq getDefaultInstance() {
      return defaultInstance;
    }

    public GetColumnsReq getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private GetColumnsReq(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = catalogNameFilter_.toBuilder();
              }
              catalogNameFilter_ = input.readMessage(org.apache.drill.exec.proto.UserProtos.LikeFilter.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(catalogNameFilter_);
                catalogNameFilter_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 18: {
              org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = schemaNameFilter_.toBuilder();
              }
              schemaNameFilter_ = input.readMessage(org.apache.drill.exec.proto.UserProtos.LikeFilter.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(schemaNameFilter_);
                schemaNameFilter_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
            case 26: {
              org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder subBuilder = null;
              if (((bitField0_ & 0x00000004) == 0x00000004)) {
                subBuilder = tableNameFilter_.toBuilder();
              }
              tableNameFilter_ = input.readMessage(org.apache.drill.exec.proto.UserProtos.LikeFilter.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(tableNameFilter_);
                tableNameFilter_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000004;
              break;
            }
            case 34: {
              org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder subBuilder = null;
              if (((bitField0_ & 0x00000008) == 0x00000008)) {
                subBuilder = columnNameFilter_.toBuilder();
              }
              columnNameFilter_ = input.readMessage(org.apache.drill.exec.proto.UserProtos.LikeFilter.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(columnNameFilter_);
                columnNameFilter_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000008;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsReq_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsReq_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetColumnsReq.class, org.apache.drill.exec.proto.UserProtos.GetColumnsReq.Builder.class);
    }

    public static com.google.protobuf.Parser<GetColumnsReq> PARSER =
        new com.google.protobuf.AbstractParser<GetColumnsReq>() {
      public GetColumnsReq parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new GetColumnsReq(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<GetColumnsReq> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.user.LikeFilter catalog_name_filter = 1;
    public static final int CATALOG_NAME_FILTER_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter catalogNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    public boolean hasCatalogNameFilter() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter() {
      return catalogNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder() {
      return catalogNameFilter_;
    }

    // optional .exec.user.LikeFilter schema_name_filter = 2;
    public static final int SCHEMA_NAME_FILTER_FIELD_NUMBER = 2;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter schemaNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    public boolean hasSchemaNameFilter() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter() {
      return schemaNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder() {
      return schemaNameFilter_;
    }

    // optional .exec.user.LikeFilter table_name_filter = 3;
    public static final int TABLE_NAME_FILTER_FIELD_NUMBER = 3;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter tableNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     */
    public boolean hasTableNameFilter() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getTableNameFilter() {
      return tableNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getTableNameFilterOrBuilder() {
      return tableNameFilter_;
    }

    // optional .exec.user.LikeFilter column_name_filter = 4;
    public static final int COLUMN_NAME_FILTER_FIELD_NUMBER = 4;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter columnNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
     */
    public boolean hasColumnNameFilter() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getColumnNameFilter() {
      return columnNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getColumnNameFilterOrBuilder() {
      return columnNameFilter_;
    }

    private void initFields() {
      catalogNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      schemaNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      tableNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      columnNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, catalogNameFilter_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, schemaNameFilter_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, tableNameFilter_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeMessage(4, columnNameFilter_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, catalogNameFilter_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, schemaNameFilter_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, tableNameFilter_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, columnNameFilter_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetColumnsReq prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.GetColumnsReq}
     *
     * <pre>
     *
     * Request message for getting the metadata for columns satisfying the given optional filters.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.GetColumnsReqOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsReq_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsReq_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetColumnsReq.class, org.apache.drill.exec.proto.UserProtos.GetColumnsReq.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetColumnsReq.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getCatalogNameFilterFieldBuilder();
          getSchemaNameFilterFieldBuilder();
          getTableNameFilterFieldBuilder();
          getColumnNameFilterFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
        } else {
          catalogNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
        } else {
          schemaNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (tableNameFilterBuilder_ == null) {
          tableNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
        } else {
          tableNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (columnNameFilterBuilder_ == null) {
          columnNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
        } else {
          columnNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsReq_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.GetColumnsReq getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetColumnsReq.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.GetColumnsReq build() {
        org.apache.drill.exec.proto.UserProtos.GetColumnsReq result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.GetColumnsReq buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetColumnsReq result = new org.apache.drill.exec.proto.UserProtos.GetColumnsReq(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (catalogNameFilterBuilder_ == null) {
          result.catalogNameFilter_ = catalogNameFilter_;
        } else {
          result.catalogNameFilter_ = catalogNameFilterBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (schemaNameFilterBuilder_ == null) {
          result.schemaNameFilter_ = schemaNameFilter_;
        } else {
          result.schemaNameFilter_ = schemaNameFilterBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (tableNameFilterBuilder_ == null) {
          result.tableNameFilter_ = tableNameFilter_;
        } else {
          result.tableNameFilter_ = tableNameFilterBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        if (columnNameFilterBuilder_ == null) {
          result.columnNameFilter_ = columnNameFilter_;
        } else {
          result.columnNameFilter_ = columnNameFilterBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetColumnsReq) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetColumnsReq)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetColumnsReq other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetColumnsReq.getDefaultInstance()) return this;
        if (other.hasCatalogNameFilter()) {
          mergeCatalogNameFilter(other.getCatalogNameFilter());
        }
        if (other.hasSchemaNameFilter()) {
          mergeSchemaNameFilter(other.getSchemaNameFilter());
        }
        if (other.hasTableNameFilter()) {
          mergeTableNameFilter(other.getTableNameFilter());
        }
        if (other.hasColumnNameFilter()) {
          mergeColumnNameFilter(other.getColumnNameFilter());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.GetColumnsReq parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.GetColumnsReq) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.user.LikeFilter catalog_name_filter = 1;
      private org.apache.drill.exec.proto.UserProtos.LikeFilter catalogNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> catalogNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public boolean hasCatalogNameFilter() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter() {
        if (catalogNameFilterBuilder_ == null) {
          return catalogNameFilter_;
        } else {
          return catalogNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder setCatalogNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (catalogNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          catalogNameFilter_ = value;
          onChanged();
        } else {
          catalogNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder setCatalogNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          catalogNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder mergeCatalogNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (catalogNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              catalogNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            catalogNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(catalogNameFilter_).mergeFrom(value).buildPartial();
          } else {
            catalogNameFilter_ = value;
          }
          onChanged();
        } else {
          catalogNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder clearCatalogNameFilter() {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
          onChanged();
        } else {
          catalogNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getCatalogNameFilterBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCatalogNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder() {
        if (catalogNameFilterBuilder_ != null) {
          return catalogNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return catalogNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getCatalogNameFilterFieldBuilder() {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  catalogNameFilter_,
                  getParentForChildren(),
                  isClean());
          catalogNameFilter_ = null;
        }
        return catalogNameFilterBuilder_;
      }

      // optional .exec.user.LikeFilter schema_name_filter = 2;
      private org.apache.drill.exec.proto.UserProtos.LikeFilter schemaNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> schemaNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public boolean hasSchemaNameFilter() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter() {
        if (schemaNameFilterBuilder_ == null) {
          return schemaNameFilter_;
        } else {
          return schemaNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder setSchemaNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (schemaNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          schemaNameFilter_ = value;
          onChanged();
        } else {
          schemaNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder setSchemaNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          schemaNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder mergeSchemaNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (schemaNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002) &&
              schemaNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            schemaNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(schemaNameFilter_).mergeFrom(value).buildPartial();
          } else {
            schemaNameFilter_ = value;
          }
          onChanged();
        } else {
          schemaNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder clearSchemaNameFilter() {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
          onChanged();
        } else {
          schemaNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getSchemaNameFilterBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSchemaNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder() {
        if (schemaNameFilterBuilder_ != null) {
          return schemaNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return schemaNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getSchemaNameFilterFieldBuilder() {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  schemaNameFilter_,
                  getParentForChildren(),
                  isClean());
          schemaNameFilter_ = null;
        }
        return schemaNameFilterBuilder_;
      }

      // optional .exec.user.LikeFilter table_name_filter = 3;
      private org.apache.drill.exec.proto.UserProtos.LikeFilter tableNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> tableNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public boolean hasTableNameFilter() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getTableNameFilter() {
        if (tableNameFilterBuilder_ == null) {
          return tableNameFilter_;
        } else {
          return tableNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public Builder setTableNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (tableNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          tableNameFilter_ = value;
          onChanged();
        } else {
          tableNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public Builder setTableNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (tableNameFilterBuilder_ == null) {
          tableNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          tableNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public Builder mergeTableNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (tableNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004) &&
              tableNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            tableNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(tableNameFilter_).mergeFrom(value).buildPartial();
          } else {
            tableNameFilter_ = value;
          }
          onChanged();
        } else {
          tableNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public Builder clearTableNameFilter() {
        if (tableNameFilterBuilder_ == null) {
          tableNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
          onChanged();
        } else {
          tableNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getTableNameFilterBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTableNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getTableNameFilterOrBuilder() {
        if (tableNameFilterBuilder_ != null) {
          return tableNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return tableNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getTableNameFilterFieldBuilder() {
        if (tableNameFilterBuilder_ == null) {
          tableNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  tableNameFilter_,
                  getParentForChildren(),
                  isClean());
          tableNameFilter_ = null;
        }
        return tableNameFilterBuilder_;
      }

      // optional .exec.user.LikeFilter column_name_filter = 4;
      private org.apache.drill.exec.proto.UserProtos.LikeFilter columnNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> columnNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       */
      public boolean hasColumnNameFilter() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getColumnNameFilter() {
        if (columnNameFilterBuilder_ == null) {
          return columnNameFilter_;
        } else {
          return columnNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       */
      public Builder setColumnNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (columnNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          columnNameFilter_ = value;
          onChanged();
        } else {
          columnNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       */
      public Builder setColumnNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (columnNameFilterBuilder_ == null) {
          columnNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          columnNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       */
      public Builder mergeColumnNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (columnNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008) &&
              columnNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            columnNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(columnNameFilter_).mergeFrom(value).buildPartial();
          } else {
            columnNameFilter_ = value;
          }
          onChanged();
        } else {
          columnNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       */
      public Builder clearColumnNameFilter() {
        if (columnNameFilterBuilder_ == null) {
          columnNameFilter_ = org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
          onChanged();
        } else {
          columnNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getColumnNameFilterBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getColumnNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getColumnNameFilterOrBuilder() {
        if (columnNameFilterBuilder_ != null) {
          return columnNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return columnNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getColumnNameFilterFieldBuilder() {
        if (columnNameFilterBuilder_ == null) {
          columnNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  columnNameFilter_,
                  getParentForChildren(),
                  isClean());
          columnNameFilter_ = null;
        }
        return columnNameFilterBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.GetColumnsReq)
    }

    static {
      defaultInstance = new GetColumnsReq(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetColumnsReq)
  }

  public interface ColumnMetadataOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional string catalog_name = 1;
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    boolean hasCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    java.lang.String getCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    com.google.protobuf.ByteString
        getCatalogNameBytes();

    // optional string schema_name = 2;
    /**
     * <code>optional string schema_name = 2;</code>
     */
    boolean hasSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     */
    java.lang.String getSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     */
    com.google.protobuf.ByteString
        getSchemaNameBytes();

    // optional string table_name = 3;
    /**
     * <code>optional string table_name = 3;</code>
     */
    boolean hasTableName();
    /**
     * <code>optional string table_name = 3;</code>
     */
    java.lang.String getTableName();
    /**
     * <code>optional string table_name = 3;</code>
     */
    com.google.protobuf.ByteString
        getTableNameBytes();

    // optional string column_name = 4;
    /**
     * <code>optional string column_name = 4;</code>
     */
    boolean hasColumnName();
    /**
     * <code>optional string column_name = 4;</code>
     */
    java.lang.String getColumnName();
    /**
     * <code>optional string column_name = 4;</code>
     */
    com.google.protobuf.ByteString
        getColumnNameBytes();

    // optional int32 ordinal_position = 5;
    /**
     * <code>optional int32 ordinal_position = 5;</code>
     */
    boolean hasOrdinalPosition();
    /**
     * <code>optional int32 ordinal_position = 5;</code>
     */
    int getOrdinalPosition();

    // optional string default_value = 6;
    /**
     * <code>optional string default_value = 6;</code>
     */
    boolean hasDefaultValue();
    /**
     * <code>optional string default_value = 6;</code>
     */
    java.lang.String getDefaultValue();
    /**
     * <code>optional string default_value = 6;</code>
     */
    com.google.protobuf.ByteString
        getDefaultValueBytes();

    // optional bool is_nullable = 7;
    /**
     * <code>optional bool is_nullable = 7;</code>
     */
    boolean hasIsNullable();
    /**
     * <code>optional bool is_nullable = 7;</code>
     */
    boolean getIsNullable();

    // optional string data_type = 8;
    /**
     * <code>optional string data_type = 8;</code>
     */
    boolean hasDataType();
    /**
     * <code>optional string data_type = 8;</code>
     */
    java.lang.String getDataType();
    /**
     * <code>optional string data_type = 8;</code>
     */
    com.google.protobuf.ByteString
        getDataTypeBytes();

    // optional int32 char_max_length = 9;
    /**
     * <code>optional int32 char_max_length = 9;</code>
     */
    boolean hasCharMaxLength();
    /**
     * <code>optional int32 char_max_length = 9;</code>
     */
    int getCharMaxLength();

    // optional int32 char_octet_length = 10;
    /**
     * <code>optional int32 char_octet_length = 10;</code>
     */
    boolean hasCharOctetLength();
    /**
     * <code>optional int32 char_octet_length = 10;</code>
     */
    int getCharOctetLength();

    // optional int32 numeric_precision = 11;
    /**
     * <code>optional int32 numeric_precision = 11;</code>
     */
    boolean hasNumericPrecision();
    /**
     * <code>optional int32 numeric_precision = 11;</code>
     */
    int getNumericPrecision();

    // optional int32 numeric_precision_radix = 12;
    /**
     * <code>optional int32 numeric_precision_radix = 12;</code>
     */
    boolean hasNumericPrecisionRadix();
    /**
     * <code>optional int32 numeric_precision_radix = 12;</code>
     */
    int getNumericPrecisionRadix();

    // optional int32 numeric_scale = 13;
    /**
     * <code>optional int32 numeric_scale = 13;</code>
     */
    boolean hasNumericScale();
    /**
     * <code>optional int32 numeric_scale = 13;</code>
     */
    int getNumericScale();

    // optional int32 date_time_precision = 14;
    /**
     * <code>optional int32 date_time_precision = 14;</code>
     */
    boolean hasDateTimePrecision();
    /**
     * <code>optional int32 date_time_precision = 14;</code>
     */
    int getDateTimePrecision();

    // optional string interval_type = 15;
    /**
     * <code>optional string interval_type = 15;</code>
     */
    boolean hasIntervalType();
    /**
     * <code>optional string interval_type = 15;</code>
     */
    java.lang.String getIntervalType();
    /**
     * <code>optional string interval_type = 15;</code>
     */
    com.google.protobuf.ByteString
        getIntervalTypeBytes();

    // optional int32 interval_precision = 16;
    /**
     * <code>optional int32 interval_precision = 16;</code>
     */
    boolean hasIntervalPrecision();
    /**
     * <code>optional int32 interval_precision = 16;</code>
     */
    int getIntervalPrecision();

    // optional int32 column_size = 17;
    /**
     * <code>optional int32 column_size = 17;</code>
     */
    boolean hasColumnSize();
    /**
     * <code>optional int32 column_size = 17;</code>
     */
    int getColumnSize();
  }
  /**
   * Protobuf type {@code exec.user.ColumnMetadata}
   *
   * <pre>
   *
   * Message encapsulating metadata for a Column.
   * </pre>
   */
  public static final class ColumnMetadata extends
      com.google.protobuf.GeneratedMessage
      implements ColumnMetadataOrBuilder {
    // Use ColumnMetadata.newBuilder() to construct.
    private ColumnMetadata(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private ColumnMetadata(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final ColumnMetadata defaultInstance;
    public static ColumnMetadata getDefaultInstance() {
      return defaultInstance;
    }

    public ColumnMetadata getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private ColumnMetadata(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              catalogName_ = input.readBytes();
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              schemaName_ = input.readBytes();
              break;
            }
            case 26: {
              bitField0_ |= 0x00000004;
              tableName_ = input.readBytes();
              break;
            }
            case 34: {
              bitField0_ |= 0x00000008;
              columnName_ = input.readBytes();
              break;
            }
            case 40: {
              bitField0_ |= 0x00000010;
              ordinalPosition_ = input.readInt32();
              break;
            }
            case 50: {
              bitField0_ |= 0x00000020;
              defaultValue_ = input.readBytes();
              break;
            }
            case 56: {
              bitField0_ |= 0x00000040;
              isNullable_ = input.readBool();
              break;
            }
            case 66: {
              bitField0_ |= 0x00000080;
              dataType_ = input.readBytes();
              break;
            }
            case 72: {
              bitField0_ |= 0x00000100;
              charMaxLength_ = input.readInt32();
              break;
            }
            case 80: {
              bitField0_ |= 0x00000200;
              charOctetLength_ = input.readInt32();
              break;
            }
            case 88: {
              bitField0_ |= 0x00000400;
              numericPrecision_ = input.readInt32();
              break;
            }
            case 96: {
              bitField0_ |= 0x00000800;
              numericPrecisionRadix_ = input.readInt32();
              break;
            }
            case 104: {
              bitField0_ |= 0x00001000;
              numericScale_ = input.readInt32();
              break;
            }
            case 112: {
              bitField0_ |= 0x00002000;
              dateTimePrecision_ = input.readInt32();
              break;
            }
            case 122: {
              bitField0_ |= 0x00004000;
              intervalType_ = input.readBytes();
              break;
            }
            case 128: {
              bitField0_ |= 0x00008000;
              intervalPrecision_ = input.readInt32();
              break;
            }
            case 136: {
              bitField0_ |= 0x00010000;
              columnSize_ = input.readInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_ColumnMetadata_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_ColumnMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.ColumnMetadata.class, org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder.class);
    }

    public static com.google.protobuf.Parser<ColumnMetadata> PARSER =
        new com.google.protobuf.AbstractParser<ColumnMetadata>() {
      public ColumnMetadata parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ColumnMetadata(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<ColumnMetadata> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional string catalog_name = 1;
    public static final int CATALOG_NAME_FIELD_NUMBER = 1;
    private java.lang.Object catalogName_;
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    public boolean hasCatalogName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    public java.lang.String getCatalogName() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          catalogName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getCatalogNameBytes() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        catalogName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string schema_name = 2;
    public static final int SCHEMA_NAME_FIELD_NUMBER = 2;
    private java.lang.Object schemaName_;
    /**
     * <code>optional string schema_name = 2;</code>
     */
    public boolean hasSchemaName() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string schema_name = 2;</code>
     */
    public java.lang.String getSchemaName() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          schemaName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string schema_name = 2;</code>
     */
    public com.google.protobuf.ByteString
        getSchemaNameBytes() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        schemaName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string table_name = 3;
    public static final int TABLE_NAME_FIELD_NUMBER = 3;
    private java.lang.Object tableName_;
    /**
     * <code>optional string table_name = 3;</code>
     */
    public boolean hasTableName() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional string table_name = 3;</code>
     */
    public java.lang.String getTableName() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          tableName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string table_name = 3;</code>
     */
    public com.google.protobuf.ByteString
        getTableNameBytes() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        tableName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string column_name = 4;
    public static final int COLUMN_NAME_FIELD_NUMBER = 4;
    private java.lang.Object columnName_;
    /**
     * <code>optional string column_name = 4;</code>
     */
    public boolean hasColumnName() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional string column_name = 4;</code>
     */
    public java.lang.String getColumnName() {
      java.lang.Object ref = columnName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          columnName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string column_name = 4;</code>
     */
    public com.google.protobuf.ByteString
        getColumnNameBytes() {
      java.lang.Object ref = columnName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        columnName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional int32 ordinal_position = 5;
    public static final int ORDINAL_POSITION_FIELD_NUMBER = 5;
    private int ordinalPosition_;
    /**
     * <code>optional int32 ordinal_position = 5;</code>
     */
    public boolean hasOrdinalPosition() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional int32 ordinal_position = 5;</code>
     */
    public int getOrdinalPosition() {
      return ordinalPosition_;
    }

    // optional string default_value = 6;
    public static final int DEFAULT_VALUE_FIELD_NUMBER = 6;
    private java.lang.Object defaultValue_;
    /**
     * <code>optional string default_value = 6;</code>
     */
    public boolean hasDefaultValue() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional string default_value = 6;</code>
     */
    public java.lang.String getDefaultValue() {
      java.lang.Object ref = defaultValue_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          defaultValue_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string default_value = 6;</code>
     */
    public com.google.protobuf.ByteString
        getDefaultValueBytes() {
      java.lang.Object ref = defaultValue_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        defaultValue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional bool is_nullable = 7;
    public static final int IS_NULLABLE_FIELD_NUMBER = 7;
    private boolean isNullable_;
    /**
     * <code>optional bool is_nullable = 7;</code>
     */
    public boolean hasIsNullable() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional bool is_nullable = 7;</code>
     */
    public boolean getIsNullable() {
      return isNullable_;
    }

    // optional string data_type = 8;
    public static final int DATA_TYPE_FIELD_NUMBER = 8;
    private java.lang.Object dataType_;
    /**
     * <code>optional string data_type = 8;</code>
     */
    public boolean hasDataType() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     * <code>optional string data_type = 8;</code>
     */
    public java.lang.String getDataType() {
      java.lang.Object ref = dataType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          dataType_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string data_type = 8;</code>
     */
    public com.google.protobuf.ByteString
        getDataTypeBytes() {
      java.lang.Object ref = dataType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        dataType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional int32 char_max_length = 9;
    public static final int CHAR_MAX_LENGTH_FIELD_NUMBER = 9;
    private int charMaxLength_;
    /**
     * <code>optional int32 char_max_length = 9;</code>
     */
    public boolean hasCharMaxLength() {
      return ((bitField0_ & 0x00000100) == 0x00000100);
    }
    /**
     * <code>optional int32 char_max_length = 9;</code>
     */
    public int getCharMaxLength() {
      return charMaxLength_;
    }

    // optional int32 char_octet_length = 10;
    public static final int CHAR_OCTET_LENGTH_FIELD_NUMBER = 10;
    private int charOctetLength_;
    /**
     * <code>optional int32 char_octet_length = 10;</code>
     */
    public boolean hasCharOctetLength() {
      return ((bitField0_ & 0x00000200) == 0x00000200);
    }
    /**
     * <code>optional int32 char_octet_length = 10;</code>
     */
    public int getCharOctetLength() {
      return charOctetLength_;
    }

    // optional int32 numeric_precision = 11;
    public static final int NUMERIC_PRECISION_FIELD_NUMBER = 11;
    private int numericPrecision_;
    /**
     * <code>optional int32 numeric_precision = 11;</code>
     */
    public boolean hasNumericPrecision() {
      return ((bitField0_ & 0x00000400) == 0x00000400);
    }
    /**
     * <code>optional int32 numeric_precision = 11;</code>
     */
    public int getNumericPrecision() {
      return numericPrecision_;
    }

    // optional int32 numeric_precision_radix = 12;
    public static final int NUMERIC_PRECISION_RADIX_FIELD_NUMBER = 12;
    private int numericPrecisionRadix_;
    /**
     * <code>optional int32 numeric_precision_radix = 12;</code>
     */
    public boolean hasNumericPrecisionRadix() {
      return ((bitField0_ & 0x00000800) == 0x00000800);
    }
    /**
     * <code>optional int32 numeric_precision_radix = 12;</code>
     */
    public int getNumericPrecisionRadix() {
      return numericPrecisionRadix_;
    }

    // optional int32 numeric_scale = 13;
    public static final int NUMERIC_SCALE_FIELD_NUMBER = 13;
    private int numericScale_;
    /**
     * <code>optional int32 numeric_scale = 13;</code>
     */
    public boolean hasNumericScale() {
      return ((bitField0_ & 0x00001000) == 0x00001000);
    }
    /**
     * <code>optional int32 numeric_scale = 13;</code>
     */
    public int getNumericScale() {
      return numericScale_;
    }

    // optional int32 date_time_precision = 14;
    public static final int DATE_TIME_PRECISION_FIELD_NUMBER = 14;
    private int dateTimePrecision_;
    /**
     * <code>optional int32 date_time_precision = 14;</code>
     */
    public boolean hasDateTimePrecision() {
      return ((bitField0_ & 0x00002000) == 0x00002000);
    }
    /**
     * <code>optional int32 date_time_precision = 14;</code>
     */
    public int getDateTimePrecision() {
      return dateTimePrecision_;
    }

    // optional string interval_type = 15;
    public static final int INTERVAL_TYPE_FIELD_NUMBER = 15;
    private java.lang.Object intervalType_;
    /**
     * <code>optional string interval_type = 15;</code>
     */
    public boolean hasIntervalType() {
      return ((bitField0_ & 0x00004000) == 0x00004000);
    }
    /**
     * <code>optional string interval_type = 15;</code>
     */
    public java.lang.String getIntervalType() {
      java.lang.Object ref = intervalType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          intervalType_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string interval_type = 15;</code>
     */
    public com.google.protobuf.ByteString
        getIntervalTypeBytes() {
      java.lang.Object ref = intervalType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        intervalType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional int32 interval_precision = 16;
    public static final int INTERVAL_PRECISION_FIELD_NUMBER = 16;
    private int intervalPrecision_;
    /**
     * <code>optional int32 interval_precision = 16;</code>
     */
    public boolean hasIntervalPrecision() {
      return ((bitField0_ & 0x00008000) == 0x00008000);
    }
    /**
     * <code>optional int32 interval_precision = 16;</code>
     */
    public int getIntervalPrecision() {
      return intervalPrecision_;
    }

    // optional int32 column_size = 17;
    public static final int COLUMN_SIZE_FIELD_NUMBER = 17;
    private int columnSize_;
    /**
     * <code>optional int32 column_size = 17;</code>
     */
    public boolean hasColumnSize() {
      return ((bitField0_ & 0x00010000) == 0x00010000);
    }
    /**
     * <code>optional int32 column_size = 17;</code>
     */
    public int getColumnSize() {
      return columnSize_;
    }

    private void initFields() {
      catalogName_ = "";
      schemaName_ = "";
      tableName_ = "";
      columnName_ = "";
      ordinalPosition_ = 0;
      defaultValue_ = "";
      isNullable_ = false;
      dataType_ = "";
      charMaxLength_ = 0;
      charOctetLength_ = 0;
      numericPrecision_ = 0;
      numericPrecisionRadix_ = 0;
      numericScale_ = 0;
      dateTimePrecision_ = 0;
      intervalType_ = "";
      intervalPrecision_ = 0;
      columnSize_ = 0;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getCatalogNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getSchemaNameBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(3, getTableNameBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeBytes(4, getColumnNameBytes());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeInt32(5, ordinalPosition_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeBytes(6, getDefaultValueBytes());
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeBool(7, isNullable_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeBytes(8, getDataTypeBytes());
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        output.writeInt32(9, charMaxLength_);
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        output.writeInt32(10, charOctetLength_);
      }
      if (((bitField0_ & 0x00000400) == 0x00000400)) {
        output.writeInt32(11, numericPrecision_);
      }
      if (((bitField0_ & 0x00000800) == 0x00000800)) {
        output.writeInt32(12, numericPrecisionRadix_);
      }
      if (((bitField0_ & 0x00001000) == 0x00001000)) {
        output.writeInt32(13, numericScale_);
      }
      if (((bitField0_ & 0x00002000) == 0x00002000)) {
        output.writeInt32(14, dateTimePrecision_);
      }
      if (((bitField0_ & 0x00004000) == 0x00004000)) {
        output.writeBytes(15, getIntervalTypeBytes());
      }
      if (((bitField0_ & 0x00008000) == 0x00008000)) {
        output.writeInt32(16, intervalPrecision_);
      }
      if (((bitField0_ & 0x00010000) == 0x00010000)) {
        output.writeInt32(17, columnSize_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getCatalogNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getSchemaNameBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, getTableNameBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(4, getColumnNameBytes());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(5, ordinalPosition_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(6, getDefaultValueBytes());
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(7, isNullable_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(8, getDataTypeBytes());
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(9, charMaxLength_);
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(10, charOctetLength_);
      }
      if (((bitField0_ & 0x00000400) == 0x00000400)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(11, numericPrecision_);
      }
      if (((bitField0_ & 0x00000800) == 0x00000800)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(12, numericPrecisionRadix_);
      }
      if (((bitField0_ & 0x00001000) == 0x00001000)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(13, numericScale_);
      }
      if (((bitField0_ & 0x00002000) == 0x00002000)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(14, dateTimePrecision_);
      }
      if (((bitField0_ & 0x00004000) == 0x00004000)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(15, getIntervalTypeBytes());
      }
      if (((bitField0_ & 0x00008000) == 0x00008000)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(16, intervalPrecision_);
      }
      if (((bitField0_ & 0x00010000) == 0x00010000)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(17, columnSize_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.ColumnMetadata prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.ColumnMetadata}
     *
     * <pre>
     *
     * Message encapsulating metadata for a Column.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_ColumnMetadata_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_ColumnMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.ColumnMetadata.class, org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.ColumnMetadata.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        catalogName_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        schemaName_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        tableName_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        columnName_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        ordinalPosition_ = 0;
        bitField0_ = (bitField0_ & ~0x00000010);
        defaultValue_ = "";
        bitField0_ = (bitField0_ & ~0x00000020);
        isNullable_ = false;
        bitField0_ = (bitField0_ & ~0x00000040);
        dataType_ = "";
        bitField0_ = (bitField0_ & ~0x00000080);
        charMaxLength_ = 0;
        bitField0_ = (bitField0_ & ~0x00000100);
        charOctetLength_ = 0;
        bitField0_ = (bitField0_ & ~0x00000200);
        numericPrecision_ = 0;
        bitField0_ = (bitField0_ & ~0x00000400);
        numericPrecisionRadix_ = 0;
        bitField0_ = (bitField0_ & ~0x00000800);
        numericScale_ = 0;
        bitField0_ = (bitField0_ & ~0x00001000);
        dateTimePrecision_ = 0;
        bitField0_ = (bitField0_ & ~0x00002000);
        intervalType_ = "";
        bitField0_ = (bitField0_ & ~0x00004000);
        intervalPrecision_ = 0;
        bitField0_ = (bitField0_ & ~0x00008000);
        columnSize_ = 0;
        bitField0_ = (bitField0_ & ~0x00010000);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_ColumnMetadata_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.ColumnMetadata getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.ColumnMetadata.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.ColumnMetadata build() {
        org.apache.drill.exec.proto.UserProtos.ColumnMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.ColumnMetadata buildPartial() {
        org.apache.drill.exec.proto.UserProtos.ColumnMetadata result = new org.apache.drill.exec.proto.UserProtos.ColumnMetadata(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.catalogName_ = catalogName_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.schemaName_ = schemaName_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.tableName_ = tableName_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.columnName_ = columnName_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.ordinalPosition_ = ordinalPosition_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.defaultValue_ = defaultValue_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.isNullable_ = isNullable_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000080;
        }
        result.dataType_ = dataType_;
        if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
          to_bitField0_ |= 0x00000100;
        }
        result.charMaxLength_ = charMaxLength_;
        if (((from_bitField0_ & 0x00000200) == 0x00000200)) {
          to_bitField0_ |= 0x00000200;
        }
        result.charOctetLength_ = charOctetLength_;
        if (((from_bitField0_ & 0x00000400) == 0x00000400)) {
          to_bitField0_ |= 0x00000400;
        }
        result.numericPrecision_ = numericPrecision_;
        if (((from_bitField0_ & 0x00000800) == 0x00000800)) {
          to_bitField0_ |= 0x00000800;
        }
        result.numericPrecisionRadix_ = numericPrecisionRadix_;
        if (((from_bitField0_ & 0x00001000) == 0x00001000)) {
          to_bitField0_ |= 0x00001000;
        }
        result.numericScale_ = numericScale_;
        if (((from_bitField0_ & 0x00002000) == 0x00002000)) {
          to_bitField0_ |= 0x00002000;
        }
        result.dateTimePrecision_ = dateTimePrecision_;
        if (((from_bitField0_ & 0x00004000) == 0x00004000)) {
          to_bitField0_ |= 0x00004000;
        }
        result.intervalType_ = intervalType_;
        if (((from_bitField0_ & 0x00008000) == 0x00008000)) {
          to_bitField0_ |= 0x00008000;
        }
        result.intervalPrecision_ = intervalPrecision_;
        if (((from_bitField0_ & 0x00010000) == 0x00010000)) {
          to_bitField0_ |= 0x00010000;
        }
        result.columnSize_ = columnSize_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.ColumnMetadata) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.ColumnMetadata)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.ColumnMetadata other) {
        if (other == org.apache.drill.exec.proto.UserProtos.ColumnMetadata.getDefaultInstance()) return this;
        if (other.hasCatalogName()) {
          bitField0_ |= 0x00000001;
          catalogName_ = other.catalogName_;
          onChanged();
        }
        if (other.hasSchemaName()) {
          bitField0_ |= 0x00000002;
          schemaName_ = other.schemaName_;
          onChanged();
        }
        if (other.hasTableName()) {
          bitField0_ |= 0x00000004;
          tableName_ = other.tableName_;
          onChanged();
        }
        if (other.hasColumnName()) {
          bitField0_ |= 0x00000008;
          columnName_ = other.columnName_;
          onChanged();
        }
        if (other.hasOrdinalPosition()) {
          setOrdinalPosition(other.getOrdinalPosition());
        }
        if (other.hasDefaultValue()) {
          bitField0_ |= 0x00000020;
          defaultValue_ = other.defaultValue_;
          onChanged();
        }
        if (other.hasIsNullable()) {
          setIsNullable(other.getIsNullable());
        }
        if (other.hasDataType()) {
          bitField0_ |= 0x00000080;
          dataType_ = other.dataType_;
          onChanged();
        }
        if (other.hasCharMaxLength()) {
          setCharMaxLength(other.getCharMaxLength());
        }
        if (other.hasCharOctetLength()) {
          setCharOctetLength(other.getCharOctetLength());
        }
        if (other.hasNumericPrecision()) {
          setNumericPrecision(other.getNumericPrecision());
        }
        if (other.hasNumericPrecisionRadix()) {
          setNumericPrecisionRadix(other.getNumericPrecisionRadix());
        }
        if (other.hasNumericScale()) {
          setNumericScale(other.getNumericScale());
        }
        if (other.hasDateTimePrecision()) {
          setDateTimePrecision(other.getDateTimePrecision());
        }
        if (other.hasIntervalType()) {
          bitField0_ |= 0x00004000;
          intervalType_ = other.intervalType_;
          onChanged();
        }
        if (other.hasIntervalPrecision()) {
          setIntervalPrecision(other.getIntervalPrecision());
        }
        if (other.hasColumnSize()) {
          setColumnSize(other.getColumnSize());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.ColumnMetadata parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.ColumnMetadata) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional string catalog_name = 1;
      private java.lang.Object catalogName_ = "";
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public boolean hasCatalogName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public java.lang.String getCatalogName() {
        java.lang.Object ref = catalogName_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          catalogName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public com.google.protobuf.ByteString
          getCatalogNameBytes() {
        java.lang.Object ref = catalogName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          catalogName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public Builder setCatalogName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public Builder clearCatalogName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        catalogName_ = getDefaultInstance().getCatalogName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       */
      public Builder setCatalogNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }

      // optional string schema_name = 2;
      private java.lang.Object schemaName_ = "";
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public boolean hasSchemaName() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public java.lang.String getSchemaName() {
        java.lang.Object ref = schemaName_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          schemaName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public com.google.protobuf.ByteString
          getSchemaNameBytes() {
        java.lang.Object ref = schemaName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          schemaName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public Builder setSchemaName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schemaName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public Builder clearSchemaName() {
        bitField0_ = (bitField0_ & ~0x00000002);
        schemaName_ = getDefaultInstance().getSchemaName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       */
      public Builder setSchemaNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schemaName_ = value;
        onChanged();
        return this;
      }

      // optional string table_name = 3;
      private java.lang.Object tableName_ = "";
      /**
       * <code>optional string table_name = 3;</code>
       */
      public boolean hasTableName() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional string table_name = 3;</code>
       */
      public java.lang.String getTableName() {
        java.lang.Object ref = tableName_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          tableName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string table_name = 3;</code>
       */
      public com.google.protobuf.ByteString
          getTableNameBytes() {
        java.lang.Object ref = tableName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          tableName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string table_name = 3;</code>
       */
      public Builder setTableName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        tableName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string table_name = 3;</code>
       */
      public Builder clearTableName() {
        bitField0_ = (bitField0_ & ~0x00000004);
        tableName_ = getDefaultInstance().getTableName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string table_name = 3;</code>
       */
      public Builder setTableNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        tableName_ = value;
        onChanged();
        return this;
      }

      // optional string column_name = 4;
      private java.lang.Object columnName_ = "";
      /**
       * <code>optional string column_name = 4;</code>
       */
      public boolean hasColumnName() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional string column_name = 4;</code>
       */
      public java.lang.String getColumnName() {
        java.lang.Object ref = columnName_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          columnName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string column_name = 4;</code>
       */
      public com.google.protobuf.ByteString
          getColumnNameBytes() {
        java.lang.Object ref = columnName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          columnName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string column_name = 4;</code>
       */
      public Builder setColumnName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        columnName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string column_name = 4;</code>
       */
      public Builder clearColumnName() {
        bitField0_ = (bitField0_ & ~0x00000008);
        columnName_ = getDefaultInstance().getColumnName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string column_name = 4;</code>
       */
      public Builder setColumnNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        columnName_ = value;
        onChanged();
        return this;
      }

      // optional int32 ordinal_position = 5;
      private int ordinalPosition_ ;
      /**
       * <code>optional int32 ordinal_position = 5;</code>
       */
      public boolean hasOrdinalPosition() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional int32 ordinal_position = 5;</code>
       */
      public int getOrdinalPosition() {
        return ordinalPosition_;
      }
      /**
       * <code>optional int32 ordinal_position = 5;</code>
       */
      public Builder setOrdinalPosition(int value) {
        bitField0_ |= 0x00000010;
        ordinalPosition_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 ordinal_position = 5;</code>
       */
      public Builder clearOrdinalPosition() {
        bitField0_ = (bitField0_ & ~0x00000010);
        ordinalPosition_ = 0;
        onChanged();
        return this;
      }

      // optional string default_value = 6;
      private java.lang.Object defaultValue_ = "";
      /**
       * <code>optional string default_value = 6;</code>
       */
      public boolean hasDefaultValue() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional string default_value = 6;</code>
       */
      public java.lang.String getDefaultValue() {
        java.lang.Object ref = defaultValue_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          defaultValue_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string default_value = 6;</code>
       */
      public com.google.protobuf.ByteString
          getDefaultValueBytes() {
        java.lang.Object ref = defaultValue_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          defaultValue_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string default_value = 6;</code>
       */
      public Builder setDefaultValue(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
        defaultValue_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string default_value = 6;</code>
       */
      public Builder clearDefaultValue() {
        bitField0_ = (bitField0_ & ~0x00000020);
        defaultValue_ = getDefaultInstance().getDefaultValue();
        onChanged();
        return this;
      }
      /**
       * <code>optional string default_value = 6;</code>
       */
      public Builder setDefaultValueBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
        defaultValue_ = value;
        onChanged();
        return this;
      }

      // optional bool is_nullable = 7;
      private boolean isNullable_ ;
      /**
       * <code>optional bool is_nullable = 7;</code>
       */
      public boolean hasIsNullable() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional bool is_nullable = 7;</code>
       */
      public boolean getIsNullable() {
        return isNullable_;
      }
      /**
       * <code>optional bool is_nullable = 7;</code>
       */
      public Builder setIsNullable(boolean value) {
        bitField0_ |= 0x00000040;
        isNullable_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool is_nullable = 7;</code>
       */
      public Builder clearIsNullable() {
        bitField0_ = (bitField0_ & ~0x00000040);
        isNullable_ = false;
        onChanged();
        return this;
      }

      // optional string data_type = 8;
      private java.lang.Object dataType_ = "";
      /**
       * <code>optional string data_type = 8;</code>
       */
      public boolean hasDataType() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <code>optional string data_type = 8;</code>
       */
      public java.lang.String getDataType() {
        java.lang.Object ref = dataType_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          dataType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string data_type = 8;</code>
       */
      public com.google.protobuf.ByteString
          getDataTypeBytes() {
        java.lang.Object ref = dataType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          dataType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string data_type = 8;</code>
       */
      public Builder setDataType(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000080;
        dataType_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string data_type = 8;</code>
       */
      public Builder clearDataType() {
        bitField0_ = (bitField0_ & ~0x00000080);
        dataType_ = getDefaultInstance().getDataType();
        onChanged();
        return this;
      }
      /**
       * <code>optional string data_type = 8;</code>
       */
      public Builder setDataTypeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000080;
        dataType_ = value;
        onChanged();
        return this;
      }

      // optional int32 char_max_length = 9;
      private int charMaxLength_ ;
      /**
       * <code>optional int32 char_max_length = 9;</code>
       */
      public boolean hasCharMaxLength() {
        return ((bitField0_ & 0x00000100) == 0x00000100);
      }
      /**
       * <code>optional int32 char_max_length = 9;</code>
       */
      public int getCharMaxLength() {
        return charMaxLength_;
      }
      /**
       * <code>optional int32 char_max_length = 9;</code>
       */
      public Builder setCharMaxLength(int value) {
        bitField0_ |= 0x00000100;
        charMaxLength_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 char_max_length = 9;</code>
       */
      public Builder clearCharMaxLength() {
        bitField0_ = (bitField0_ & ~0x00000100);
        charMaxLength_ = 0;
        onChanged();
        return this;
      }

      // optional int32 char_octet_length = 10;
      private int charOctetLength_ ;
      /**
       * <code>optional int32 char_octet_length = 10;</code>
       */
      public boolean hasCharOctetLength() {
        return ((bitField0_ & 0x00000200) == 0x00000200);
      }
      /**
       * <code>optional int32 char_octet_length = 10;</code>
       */
      public int getCharOctetLength() {
        return charOctetLength_;
      }
      /**
       * <code>optional int32 char_octet_length = 10;</code>
       */
      public Builder setCharOctetLength(int value) {
        bitField0_ |= 0x00000200;
        charOctetLength_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 char_octet_length = 10;</code>
       */
      public Builder clearCharOctetLength() {
        bitField0_ = (bitField0_ & ~0x00000200);
        charOctetLength_ = 0;
        onChanged();
        return this;
      }

      // optional int32 numeric_precision = 11;
      private int numericPrecision_ ;
      /**
       * <code>optional int32 numeric_precision = 11;</code>
       */
      public boolean hasNumericPrecision() {
        return ((bitField0_ & 0x00000400) == 0x00000400);
      }
      /**
       * <code>optional int32 numeric_precision = 11;</code>
       */
      public int getNumericPrecision() {
        return numericPrecision_;
      }
      /**
       * <code>optional int32 numeric_precision = 11;</code>
       */
      public Builder setNumericPrecision(int value) {
        bitField0_ |= 0x00000400;
        numericPrecision_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 numeric_precision = 11;</code>
       */
      public Builder clearNumericPrecision() {
        bitField0_ = (bitField0_ & ~0x00000400);
        numericPrecision_ = 0;
        onChanged();
        return this;
      }

      // optional int32 numeric_precision_radix = 12;
      private int numericPrecisionRadix_ ;
      /**
       * <code>optional int32 numeric_precision_radix = 12;</code>
       */
      public boolean hasNumericPrecisionRadix() {
        return ((bitField0_ & 0x00000800) == 0x00000800);
      }
      /**
       * <code>optional int32 numeric_precision_radix = 12;</code>
       */
      public int getNumericPrecisionRadix() {
        return numericPrecisionRadix_;
      }
      /**
       * <code>optional int32 numeric_precision_radix = 12;</code>
       */
      public Builder setNumericPrecisionRadix(int value) {
        bitField0_ |= 0x00000800;
        numericPrecisionRadix_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 numeric_precision_radix = 12;</code>
       */
      public Builder clearNumericPrecisionRadix() {
        bitField0_ = (bitField0_ & ~0x00000800);
        numericPrecisionRadix_ = 0;
        onChanged();
        return this;
      }

      // optional int32 numeric_scale = 13;
      private int numericScale_ ;
      /**
       * <code>optional int32 numeric_scale = 13;</code>
       */
      public boolean hasNumericScale() {
        return ((bitField0_ & 0x00001000) == 0x00001000);
      }
      /**
       * <code>optional int32 numeric_scale = 13;</code>
       */
      public int getNumericScale() {
        return numericScale_;
      }
      /**
       * <code>optional int32 numeric_scale = 13;</code>
       */
      public Builder setNumericScale(int value) {
        bitField0_ |= 0x00001000;
        numericScale_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 numeric_scale = 13;</code>
       */
      public Builder clearNumericScale() {
        bitField0_ = (bitField0_ & ~0x00001000);
        numericScale_ = 0;
        onChanged();
        return this;
      }

      // optional int32 date_time_precision = 14;
      private int dateTimePrecision_ ;
      /**
       * <code>optional int32 date_time_precision = 14;</code>
       */
      public boolean hasDateTimePrecision() {
        return ((bitField0_ & 0x00002000) == 0x00002000);
      }
      /**
       * <code>optional int32 date_time_precision = 14;</code>
       */
      public int getDateTimePrecision() {
        return dateTimePrecision_;
      }
      /**
       * <code>optional int32 date_time_precision = 14;</code>
       */
      public Builder setDateTimePrecision(int value) {
        bitField0_ |= 0x00002000;
        dateTimePrecision_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 date_time_precision = 14;</code>
       */
      public Builder clearDateTimePrecision() {
        bitField0_ = (bitField0_ & ~0x00002000);
        dateTimePrecision_ = 0;
        onChanged();
        return this;
      }

      // optional string interval_type = 15;
      private java.lang.Object intervalType_ = "";
      /**
       * <code>optional string interval_type = 15;</code>
       */
      public boolean hasIntervalType() {
        return ((bitField0_ & 0x00004000) == 0x00004000);
      }
      /**
       * <code>optional string interval_type = 15;</code>
       */
      public java.lang.String getIntervalType() {
        java.lang.Object ref = intervalType_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          intervalType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string interval_type = 15;</code>
       */
      public com.google.protobuf.ByteString
          getIntervalTypeBytes() {
        java.lang.Object ref = intervalType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          intervalType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string interval_type = 15;</code>
       */
      public Builder setIntervalType(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00004000;
        intervalType_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string interval_type = 15;</code>
       */
      public Builder clearIntervalType() {
        bitField0_ = (bitField0_ & ~0x00004000);
        intervalType_ = getDefaultInstance().getIntervalType();
        onChanged();
        return this;
      }
      /**
       * <code>optional string interval_type = 15;</code>
       */
      public Builder setIntervalTypeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00004000;
        intervalType_ = value;
        onChanged();
        return this;
      }

      // optional int32 interval_precision = 16;
      private int intervalPrecision_ ;
      /**
       * <code>optional int32 interval_precision = 16;</code>
       */
      public boolean hasIntervalPrecision() {
        return ((bitField0_ & 0x00008000) == 0x00008000);
      }
      /**
       * <code>optional int32 interval_precision = 16;</code>
       */
      public int getIntervalPrecision() {
        return intervalPrecision_;
      }
      /**
       * <code>optional int32 interval_precision = 16;</code>
       */
      public Builder setIntervalPrecision(int value) {
        bitField0_ |= 0x00008000;
        intervalPrecision_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 interval_precision = 16;</code>
       */
      public Builder clearIntervalPrecision() {
        bitField0_ = (bitField0_ & ~0x00008000);
        intervalPrecision_ = 0;
        onChanged();
        return this;
      }

      // optional int32 column_size = 17;
      private int columnSize_ ;
      /**
       * <code>optional int32 column_size = 17;</code>
       */
      public boolean hasColumnSize() {
        return ((bitField0_ & 0x00010000) == 0x00010000);
      }
      /**
       * <code>optional int32 column_size = 17;</code>
       */
      public int getColumnSize() {
        return columnSize_;
      }
      /**
       * <code>optional int32 column_size = 17;</code>
       */
      public Builder setColumnSize(int value) {
        bitField0_ |= 0x00010000;
        columnSize_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 column_size = 17;</code>
       */
      public Builder clearColumnSize() {
        bitField0_ = (bitField0_ & ~0x00010000);
        columnSize_ = 0;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.ColumnMetadata)
    }

    static {
      defaultInstance = new ColumnMetadata(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.ColumnMetadata)
  }

  public interface GetColumnsRespOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.user.RequestStatus status = 1;
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     */
    boolean hasStatus();
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus();

    // repeated .exec.user.ColumnMetadata columns = 2;
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    java.util.List<org.apache.drill.exec.proto.UserProtos.ColumnMetadata> 
        getColumnsList();
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.ColumnMetadata getColumns(int index);
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    int getColumnsCount();
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    java.util.List<? extends org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder> 
        getColumnsOrBuilderList();
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder getColumnsOrBuilder(
        int index);

    // optional .exec.shared.DrillPBError error = 3;
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    boolean hasError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBError getError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder();
  }
  /**
   * Protobuf type {@code exec.user.GetColumnsResp}
   *
   * <pre>
   *
   * Response message for GetColumnsReq.
   * </pre>
   */
  public static final class GetColumnsResp extends
      com.google.protobuf.GeneratedMessage
      implements GetColumnsRespOrBuilder {
    // Use GetColumnsResp.newBuilder() to construct.
    private GetColumnsResp(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private GetColumnsResp(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final GetColumnsResp defaultInstance;
    public static GetColumnsResp getDefaultInstance() {
      return defaultInstance;
    }

    public GetColumnsResp getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private GetColumnsResp(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.UserProtos.RequestStatus value = org.apache.drill.exec.proto.UserProtos.RequestStatus.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                status_ = value;
              }
              break;
            }
            case 18: {
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                columns_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.ColumnMetadata>();
                mutable_bitField0_ |= 0x00000002;
              }
              columns_.add(input.readMessage(org.apache.drill.exec.proto.UserProtos.ColumnMetadata.PARSER, extensionRegistry));
              break;
            }
            case 26: {
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = error_.toBuilder();
              }
              error_ = input.readMessage(org.apache.drill.exec.proto.UserBitShared.DrillPBError.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(error_);
                error_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          columns_ = java.util.Collections.unmodifiableList(columns_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsResp_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsResp_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetColumnsResp.class, org.apache.drill.exec.proto.UserProtos.GetColumnsResp.Builder.class);
    }

    public static com.google.protobuf.Parser<GetColumnsResp> PARSER =
        new com.google.protobuf.AbstractParser<GetColumnsResp>() {
      public GetColumnsResp parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new GetColumnsResp(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<GetColumnsResp> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.user.RequestStatus status = 1;
    public static final int STATUS_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserProtos.RequestStatus status_;
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus() {
      return status_;
    }

    // repeated .exec.user.ColumnMetadata columns = 2;
    public static final int COLUMNS_FIELD_NUMBER = 2;
    private java.util.List<org.apache.drill.exec.proto.UserProtos.ColumnMetadata> columns_;
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    public java.util.List<org.apache.drill.exec.proto.UserProtos.ColumnMetadata> getColumnsList() {
      return columns_;
    }
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder> 
        getColumnsOrBuilderList() {
      return columns_;
    }
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    public int getColumnsCount() {
      return columns_.size();
    }
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.ColumnMetadata getColumns(int index) {
      return columns_.get(index);
    }
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder getColumnsOrBuilder(
        int index) {
      return columns_.get(index);
    }

    // optional .exec.shared.DrillPBError error = 3;
    public static final int ERROR_FIELD_NUMBER = 3;
    private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_;
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
      return error_;
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
      return error_;
    }

    private void initFields() {
      status_ = org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS;
      columns_ = java.util.Collections.emptyList();
      error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, status_.getNumber());
      }
      for (int i = 0; i < columns_.size(); i++) {
        output.writeMessage(2, columns_.get(i));
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(3, error_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, status_.getNumber());
      }
      for (int i = 0; i < columns_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, columns_.get(i));
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, error_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetColumnsResp prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.GetColumnsResp}
     *
     * <pre>
     *
     * Response message for GetColumnsReq.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.GetColumnsRespOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsResp_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsResp_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetColumnsResp.class, org.apache.drill.exec.proto.UserProtos.GetColumnsResp.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetColumnsResp.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getColumnsFieldBuilder();
          getErrorFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        status_ = org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (columnsBuilder_ == null) {
          columns_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          columnsBuilder_.clear();
        }
        if (errorBuilder_ == null) {
          error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsResp_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.GetColumnsResp getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetColumnsResp.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.GetColumnsResp build() {
        org.apache.drill.exec.proto.UserProtos.GetColumnsResp result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.GetColumnsResp buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetColumnsResp result = new org.apache.drill.exec.proto.UserProtos.GetColumnsResp(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.status_ = status_;
        if (columnsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            columns_ = java.util.Collections.unmodifiableList(columns_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.columns_ = columns_;
        } else {
          result.columns_ = columnsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000002;
        }
        if (errorBuilder_ == null) {
          result.error_ = error_;
        } else {
          result.error_ = errorBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetColumnsResp) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetColumnsResp)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetColumnsResp other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetColumnsResp.getDefaultInstance()) return this;
        if (other.hasStatus()) {
          setStatus(other.getStatus());
        }
        if (columnsBuilder_ == null) {
          if (!other.columns_.isEmpty()) {
            if (columns_.isEmpty()) {
              columns_ = other.columns_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureColumnsIsMutable();
              columns_.addAll(other.columns_);
            }
            onChanged();
          }
        } else {
          if (!other.columns_.isEmpty()) {
            if (columnsBuilder_.isEmpty()) {
              columnsBuilder_.dispose();
              columnsBuilder_ = null;
              columns_ = other.columns_;
              bitField0_ = (bitField0_ & ~0x00000002);
              columnsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getColumnsFieldBuilder() : null;
            } else {
              columnsBuilder_.addAllMessages(other.columns_);
            }
          }
        }
        if (other.hasError()) {
          mergeError(other.getError());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.GetColumnsResp parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.GetColumnsResp) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.user.RequestStatus status = 1;
      private org.apache.drill.exec.proto.UserProtos.RequestStatus status_ = org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS;
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus() {
        return status_;
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       */
      public Builder setStatus(org.apache.drill.exec.proto.UserProtos.RequestStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        status_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS;
        onChanged();
        return this;
      }

      // repeated .exec.user.ColumnMetadata columns = 2;
      private java.util.List<org.apache.drill.exec.proto.UserProtos.ColumnMetadata> columns_ =
        java.util.Collections.emptyList();
      private void ensureColumnsIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          columns_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.ColumnMetadata>(columns_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.ColumnMetadata, org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder, org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder> columnsBuilder_;

      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.ColumnMetadata> getColumnsList() {
        if (columnsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(columns_);
        } else {
          return columnsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public int getColumnsCount() {
        if (columnsBuilder_ == null) {
          return columns_.size();
        } else {
          return columnsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.ColumnMetadata getColumns(int index) {
        if (columnsBuilder_ == null) {
          return columns_.get(index);
        } else {
          return columnsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder setColumns(
          int index, org.apache.drill.exec.proto.UserProtos.ColumnMetadata value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.set(index, value);
          onChanged();
        } else {
          columnsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder setColumns(
          int index, org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.set(index, builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder addColumns(org.apache.drill.exec.proto.UserProtos.ColumnMetadata value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.add(value);
          onChanged();
        } else {
          columnsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder addColumns(
          int index, org.apache.drill.exec.proto.UserProtos.ColumnMetadata value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.add(index, value);
          onChanged();
        } else {
          columnsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder addColumns(
          org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.add(builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder addColumns(
          int index, org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.add(index, builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder addAllColumns(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.UserProtos.ColumnMetadata> values) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          super.addAll(values, columns_);
          onChanged();
        } else {
          columnsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder clearColumns() {
        if (columnsBuilder_ == null) {
          columns_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          columnsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder removeColumns(int index) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.remove(index);
          onChanged();
        } else {
          columnsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder getColumnsBuilder(
          int index) {
        return getColumnsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder getColumnsOrBuilder(
          int index) {
        if (columnsBuilder_ == null) {
          return columns_.get(index);  } else {
          return columnsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder> 
           getColumnsOrBuilderList() {
        if (columnsBuilder_ != null) {
          return columnsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(columns_);
        }
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder addColumnsBuilder() {
        return getColumnsFieldBuilder().addBuilder(
            org.apache.drill.exec.proto.UserProtos.ColumnMetadata.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder addColumnsBuilder(
          int index) {
        return getColumnsFieldBuilder().addBuilder(
            index, org.apache.drill.exec.proto.UserProtos.ColumnMetadata.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder> 
           getColumnsBuilderList() {
        return getColumnsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.ColumnMetadata, org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder, org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder> 
          getColumnsFieldBuilder() {
        if (columnsBuilder_ == null) {
          columnsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.ColumnMetadata, org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder, org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder>(
                  columns_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          columns_ = null;
        }
        return columnsBuilder_;
      }

      // optional .exec.shared.DrillPBError error = 3;
      private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> errorBuilder_;
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public boolean hasError() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
        if (errorBuilder_ == null) {
          return error_;
        } else {
          return errorBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder setError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          error_ = value;
          onChanged();
        } else {
          errorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder setError(
          org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder builderForValue) {
        if (errorBuilder_ == null) {
          error_ = builderForValue.build();
          onChanged();
        } else {
          errorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder mergeError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004) &&
              error_ != org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance()) {
            error_ =
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.newBuilder(error_).mergeFrom(value).buildPartial();
          } else {
            error_ = value;
          }
          onChanged();
        } else {
          errorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder clearError() {
        if (errorBuilder_ == null) {
          error_ = org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance();
          onChanged();
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder getErrorBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getErrorFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
        if (errorBuilder_ != null) {
          return errorBuilder_.getMessageOrBuilder();
        } else {
          return error_;
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> 
          getErrorFieldBuilder() {
        if (errorBuilder_ == null) {
          errorBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder>(
                  error_,
                  getParentForChildren(),
                  isClean());
          error_ = null;
        }
        return errorBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.GetColumnsResp)
    }

    static {
      defaultInstance = new GetColumnsResp(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetColumnsResp)
  }

  public interface CreatePreparedStatementReqOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional string sql_query = 1;
    /**
     * <code>optional string sql_query = 1;</code>
     */
    boolean hasSqlQuery();
    /**
     * <code>optional string sql_query = 1;</code>
     */
    java.lang.String getSqlQuery();
    /**
     * <code>optional string sql_query = 1;</code>
     */
    com.google.protobuf.ByteString
        getSqlQueryBytes();
  }
  /**
   * Protobuf type {@code exec.user.CreatePreparedStatementReq}
   *
   * <pre>
   *
   * Request message to create a prepared statement. Currently prepared
   * statement only accepts a SQL query. Query parameter support is not
   * included in current implementation.
   * </pre>
   */
  public static final class CreatePreparedStatementReq extends
      com.google.protobuf.GeneratedMessage
      implements CreatePreparedStatementReqOrBuilder {
    // Use CreatePreparedStatementReq.newBuilder() to construct.
    private CreatePreparedStatementReq(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private CreatePreparedStatementReq(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final CreatePreparedStatementReq defaultInstance;
    public static CreatePreparedStatementReq getDefaultInstance() {
      return defaultInstance;
    }

    public CreatePreparedStatementReq getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private CreatePreparedStatementReq(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              sqlQuery_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CreatePreparedStatementReq_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CreatePreparedStatementReq_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq.class, org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq.Builder.class);
    }

    public static com.google.protobuf.Parser<CreatePreparedStatementReq> PARSER =
        new com.google.protobuf.AbstractParser<CreatePreparedStatementReq>() {
      public CreatePreparedStatementReq parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new CreatePreparedStatementReq(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<CreatePreparedStatementReq> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional string sql_query = 1;
    public static final int SQL_QUERY_FIELD_NUMBER = 1;
    private java.lang.Object sqlQuery_;
    /**
     * <code>optional string sql_query = 1;</code>
     */
    public boolean hasSqlQuery() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string sql_query = 1;</code>
     */
    public java.lang.String getSqlQuery() {
      java.lang.Object ref = sqlQuery_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          sqlQuery_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string sql_query = 1;</code>
     */
    public com.google.protobuf.ByteString
        getSqlQueryBytes() {
      java.lang.Object ref = sqlQuery_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sqlQuery_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      sqlQuery_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getSqlQueryBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getSqlQueryBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.CreatePreparedStatementReq}
     *
     * <pre>
     *
     * Request message to create a prepared statement. Currently prepared
     * statement only accepts a SQL query. Query parameter support is not
     * included in current implementation.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReqOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CreatePreparedStatementReq_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CreatePreparedStatementReq_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq.class, org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        sqlQuery_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CreatePreparedStatementReq_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq build() {
        org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq buildPartial() {
        org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq result = new org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.sqlQuery_ = sqlQuery_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq other) {
        if (other == org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq.getDefaultInstance()) return this;
        if (other.hasSqlQuery()) {
          bitField0_ |= 0x00000001;
          sqlQuery_ = other.sqlQuery_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional string sql_query = 1;
      private java.lang.Object sqlQuery_ = "";
      /**
       * <code>optional string sql_query = 1;</code>
       */
      public boolean hasSqlQuery() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string sql_query = 1;</code>
       */
      public java.lang.String getSqlQuery() {
        java.lang.Object ref = sqlQuery_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          sqlQuery_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string sql_query = 1;</code>
       */
      public com.google.protobuf.ByteString
          getSqlQueryBytes() {
        java.lang.Object ref = sqlQuery_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          sqlQuery_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string sql_query = 1;</code>
       */
      public Builder setSqlQuery(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        sqlQuery_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string sql_query = 1;</code>
       */
      public Builder clearSqlQuery() {
        bitField0_ = (bitField0_ & ~0x00000001);
        sqlQuery_ = getDefaultInstance().getSqlQuery();
        onChanged();
        return this;
      }
      /**
       * <code>optional string sql_query = 1;</code>
       */
      public Builder setSqlQueryBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        sqlQuery_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.CreatePreparedStatementReq)
    }

    static {
      defaultInstance = new CreatePreparedStatementReq(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.CreatePreparedStatementReq)
  }

  public interface ResultColumnMetadataOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional string catalog_name = 1;
    /**
     * <code>optional string catalog_name = 1;</code>
     *
     * <pre>
     *
     * Designated column's catalog name. Empty string if not applicable.
     * Defaults to "DRILL" as drill has only one catalog.
     * </pre>
     */
    boolean hasCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     *
     * <pre>
     *
     * Designated column's catalog name. Empty string if not applicable.
     * Defaults to "DRILL" as drill has only one catalog.
     * </pre>
     */
    java.lang.String getCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     *
     * <pre>
     *
     * Designated column's catalog name. Empty string if not applicable.
     * Defaults to "DRILL" as drill has only one catalog.
     * </pre>
     */
    com.google.protobuf.ByteString
        getCatalogNameBytes();

    // optional string schema_name = 2;
    /**
     * <code>optional string schema_name = 2;</code>
     *
     * <pre>
     *
     * Designated column's schema name. Not set if not applicable. Initial implementation
     * defaults to no value as we use LIMIT 0 queries to get the schema and schema info
     * is lost. If we derive the schema from plan, we may get the right value.
     * </pre>
     */
    boolean hasSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     *
     * <pre>
     *
     * Designated column's schema name. Not set if not applicable. Initial implementation
     * defaults to no value as we use LIMIT 0 queries to get the schema and schema info
     * is lost. If we derive the schema from plan, we may get the right value.
     * </pre>
     */
    java.lang.String getSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     *
     * <pre>
     *
     * Designated column's schema name. Not set if not applicable. Initial implementation
     * defaults to no value as we use LIMIT 0 queries to get the schema and schema info
     * is lost. If we derive the schema from plan, we may get the right value.
     * </pre>
     */
    com.google.protobuf.ByteString
        getSchemaNameBytes();

    // optional string table_name = 3;
    /**
     * <code>optional string table_name = 3;</code>
     *
     * <pre>
     *
     * Designated column's table name. Not set if not applicable. Initial implementation
     * defaults to no value as we use LIMIT 0 queries to get the schema and table info
     * is lost. If we derive the schema from query plan, we may get the right value.
     * </pre>
     */
    boolean hasTableName();
    /**
     * <code>optional string table_name = 3;</code>
     *
     * <pre>
     *
     * Designated column's table name. Not set if not applicable. Initial implementation
     * defaults to no value as we use LIMIT 0 queries to get the schema and table info
     * is lost. If we derive the schema from query plan, we may get the right value.
     * </pre>
     */
    java.lang.String getTableName();
    /**
     * <code>optional string table_name = 3;</code>
     *
     * <pre>
     *
     * Designated column's table name. Not set if not applicable. Initial implementation
     * defaults to no value as we use LIMIT 0 queries to get the schema and table info
     * is lost. If we derive the schema from query plan, we may get the right value.
     * </pre>
     */
    com.google.protobuf.ByteString
        getTableNameBytes();

    // optional string column_name = 4;
    /**
     * <code>optional string column_name = 4;</code>
     *
     * <pre>
     * column name
     * </pre>
     */
    boolean hasColumnName();
    /**
     * <code>optional string column_name = 4;</code>
     *
     * <pre>
     * column name
     * </pre>
     */
    java.lang.String getColumnName();
    /**
     * <code>optional string column_name = 4;</code>
     *
     * <pre>
     * column name
     * </pre>
     */
    com.google.protobuf.ByteString
        getColumnNameBytes();

    // optional string label = 5;
    /**
     * <code>optional string label = 5;</code>
     *
     * <pre>
     *
     * Column label name for display or print purposes.
     * Ex. a column named "empName" might be labeled as "Employee Name".
     * </pre>
     */
    boolean hasLabel();
    /**
     * <code>optional string label = 5;</code>
     *
     * <pre>
     *
     * Column label name for display or print purposes.
     * Ex. a column named "empName" might be labeled as "Employee Name".
     * </pre>
     */
    java.lang.String getLabel();
    /**
     * <code>optional string label = 5;</code>
     *
     * <pre>
     *
     * Column label name for display or print purposes.
     * Ex. a column named "empName" might be labeled as "Employee Name".
     * </pre>
     */
    com.google.protobuf.ByteString
        getLabelBytes();

    // optional string data_type = 6;
    /**
     * <code>optional string data_type = 6;</code>
     *
     * <pre>
     *
     * Data type in string format. Value is SQL standard type.
     * </pre>
     */
    boolean hasDataType();
    /**
     * <code>optional string data_type = 6;</code>
     *
     * <pre>
     *
     * Data type in string format. Value is SQL standard type.
     * </pre>
     */
    java.lang.String getDataType();
    /**
     * <code>optional string data_type = 6;</code>
     *
     * <pre>
     *
     * Data type in string format. Value is SQL standard type.
     * </pre>
     */
    com.google.protobuf.ByteString
        getDataTypeBytes();

    // optional bool is_nullable = 7;
    /**
     * <code>optional bool is_nullable = 7;</code>
     */
    boolean hasIsNullable();
    /**
     * <code>optional bool is_nullable = 7;</code>
     */
    boolean getIsNullable();

    // optional int32 precision = 8;
    /**
     * <code>optional int32 precision = 8;</code>
     *
     * <pre>
     *
     * For numeric data, this is the maximum precision.
     * For character data, this is the length in characters.
     * For datetime datatypes, this is the length in characters of the String representation
     *    (assuming the maximum allowed precision of the fractional seconds component).
     * For binary data, this is the length in bytes.
     * For all other types 0 is returned where the column size is not applicable.
     * </pre>
     */
    boolean hasPrecision();
    /**
     * <code>optional int32 precision = 8;</code>
     *
     * <pre>
     *
     * For numeric data, this is the maximum precision.
     * For character data, this is the length in characters.
     * For datetime datatypes, this is the length in characters of the String representation
     *    (assuming the maximum allowed precision of the fractional seconds component).
     * For binary data, this is the length in bytes.
     * For all other types 0 is returned where the column size is not applicable.
     * </pre>
     */
    int getPrecision();

    // optional int32 scale = 9;
    /**
     * <code>optional int32 scale = 9;</code>
     *
     * <pre>
     *
     * Column's number of digits to right of the decimal point.
     * 0 is returned for types where the scale is not applicable
     * </pre>
     */
    boolean hasScale();
    /**
     * <code>optional int32 scale = 9;</code>
     *
     * <pre>
     *
     * Column's number of digits to right of the decimal point.
     * 0 is returned for types where the scale is not applicable
     * </pre>
     */
    int getScale();

    // optional bool signed = 10;
    /**
     * <code>optional bool signed = 10;</code>
     *
     * <pre>
     *
     * Indicates whether values in the designated column are signed numbers.
     * </pre>
     */
    boolean hasSigned();
    /**
     * <code>optional bool signed = 10;</code>
     *
     * <pre>
     *
     * Indicates whether values in the designated column are signed numbers.
     * </pre>
     */
    boolean getSigned();

    // optional int32 display_size = 11;
    /**
     * <code>optional int32 display_size = 11;</code>
     *
     * <pre>
     *
     * Maximum number of characters required to display data from the column.
     * </pre>
     */
    boolean hasDisplaySize();
    /**
     * <code>optional int32 display_size = 11;</code>
     *
     * <pre>
     *
     * Maximum number of characters required to display data from the column.
     * </pre>
     */
    int getDisplaySize();

    // optional bool is_aliased = 12;
    /**
     * <code>optional bool is_aliased = 12;</code>
     *
     * <pre>
     *
     * Is the column an aliased column. Initial implementation defaults to
     * true as we derive schema from LIMIT 0 query and not the query plan.
     * </pre>
     */
    boolean hasIsAliased();
    /**
     * <code>optional bool is_aliased = 12;</code>
     *
     * <pre>
     *
     * Is the column an aliased column. Initial implementation defaults to
     * true as we derive schema from LIMIT 0 query and not the query plan.
     * </pre>
     */
    boolean getIsAliased();

    // optional .exec.user.ColumnSearchability searchability = 13;
    /**
     * <code>optional .exec.user.ColumnSearchability searchability = 13;</code>
     */
    boolean hasSearchability();
    /**
     * <code>optional .exec.user.ColumnSearchability searchability = 13;</code>
     */
    org.apache.drill.exec.proto.UserProtos.ColumnSearchability getSearchability();

    // optional .exec.user.ColumnUpdatability updatability = 14;
    /**
     * <code>optional .exec.user.ColumnUpdatability updatability = 14;</code>
     *
     * <pre>
     *
     * Defaults to READ_ONLY
     * </pre>
     */
    boolean hasUpdatability();
    /**
     * <code>optional .exec.user.ColumnUpdatability updatability = 14;</code>
     *
     * <pre>
     *
     * Defaults to READ_ONLY
     * </pre>
     */
    org.apache.drill.exec.proto.UserProtos.ColumnUpdatability getUpdatability();

    // optional bool auto_increment = 15;
    /**
     * <code>optional bool auto_increment = 15;</code>
     *
     * <pre>
     *
     * whether the designated column is automatically incremented.
     * </pre>
     */
    boolean hasAutoIncrement();
    /**
     * <code>optional bool auto_increment = 15;</code>
     *
     * <pre>
     *
     * whether the designated column is automatically incremented.
     * </pre>
     */
    boolean getAutoIncrement();

    // optional bool case_sensitivity = 16;
    /**
     * <code>optional bool case_sensitivity = 16;</code>
     *
     * <pre>
     *
     * Whether column's case matters for collations and comparisons. Defaults to true.
     * </pre>
     */
    boolean hasCaseSensitivity();
    /**
     * <code>optional bool case_sensitivity = 16;</code>
     *
     * <pre>
     *
     * Whether column's case matters for collations and comparisons. Defaults to true.
     * </pre>
     */
    boolean getCaseSensitivity();

    // optional bool sortable = 17;
    /**
     * <code>optional bool sortable = 17;</code>
     *
     * <pre>
     *
     * whether the column can be used in ORDER BY clause
     * </pre>
     */
    boolean hasSortable();
    /**
     * <code>optional bool sortable = 17;</code>
     *
     * <pre>
     *
     * whether the column can be used in ORDER BY clause
     * </pre>
     */
    boolean getSortable();

    // optional string class_name = 18;
    /**
     * <code>optional string class_name = 18;</code>
     *
     * <pre>
     *
     * A fully-qualified name of the Java class whose instances are created
     * if the method ResultSet.getObject is called to retrieve
     * a value from the column. Applicable only to JDBC clients.
     * </pre>
     */
    boolean hasClassName();
    /**
     * <code>optional string class_name = 18;</code>
     *
     * <pre>
     *
     * A fully-qualified name of the Java class whose instances are created
     * if the method ResultSet.getObject is called to retrieve
     * a value from the column. Applicable only to JDBC clients.
     * </pre>
     */
    java.lang.String getClassName();
    /**
     * <code>optional string class_name = 18;</code>
     *
     * <pre>
     *
     * A fully-qualified name of the Java class whose instances are created
     * if the method ResultSet.getObject is called to retrieve
     * a value from the column. Applicable only to JDBC clients.
     * </pre>
     */
    com.google.protobuf.ByteString
        getClassNameBytes();

    // optional bool is_currency = 20;
    /**
     * <code>optional bool is_currency = 20;</code>
     *
     * <pre>
     *
     * Is the data type a currency type? For JDBC only.
     * </pre>
     */
    boolean hasIsCurrency();
    /**
     * <code>optional bool is_currency = 20;</code>
     *
     * <pre>
     *
     * Is the data type a currency type? For JDBC only.
     * </pre>
     */
    boolean getIsCurrency();
  }
  /**
   * Protobuf type {@code exec.user.ResultColumnMetadata}
   *
   * <pre>
   *
   * Metadata of a column in query result set
   * </pre>
   */
  public static final class ResultColumnMetadata extends
      com.google.protobuf.GeneratedMessage
      implements ResultColumnMetadataOrBuilder {
    // Use ResultColumnMetadata.newBuilder() to construct.
    private ResultColumnMetadata(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private ResultColumnMetadata(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final ResultColumnMetadata defaultInstance;
    public static ResultColumnMetadata getDefaultInstance() {
      return defaultInstance;
    }

    public ResultColumnMetadata getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private ResultColumnMetadata(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              catalogName_ = input.readBytes();
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              schemaName_ = input.readBytes();
              break;
            }
            case 26: {
              bitField0_ |= 0x00000004;
              tableName_ = input.readBytes();
              break;
            }
            case 34: {
              bitField0_ |= 0x00000008;
              columnName_ = input.readBytes();
              break;
            }
            case 42: {
              bitField0_ |= 0x00000010;
              label_ = input.readBytes();
              break;
            }
            case 50: {
              bitField0_ |= 0x00000020;
              dataType_ = input.readBytes();
              break;
            }
            case 56: {
              bitField0_ |= 0x00000040;
              isNullable_ = input.readBool();
              break;
            }
            case 64: {
              bitField0_ |= 0x00000080;
              precision_ = input.readInt32();
              break;
            }
            case 72: {
              bitField0_ |= 0x00000100;
              scale_ = input.readInt32();
              break;
            }
            case 80: {
              bitField0_ |= 0x00000200;
              signed_ = input.readBool();
              break;
            }
            case 88: {
              bitField0_ |= 0x00000400;
              displaySize_ = input.readInt32();
              break;
            }
            case 96: {
              bitField0_ |= 0x00000800;
              isAliased_ = input.readBool();
              break;
            }
            case 104: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.UserProtos.ColumnSearchability value = org.apache.drill.exec.proto.UserProtos.ColumnSearchability.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(13, rawValue);
              } else {
                bitField0_ |= 0x00001000;
                searchability_ = value;
              }
              break;
            }
            case 112: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.UserProtos.ColumnUpdatability value = org.apache.drill.exec.proto.UserProtos.ColumnUpdatability.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(14, rawValue);
              } else {
                bitField0_ |= 0x00002000;
                updatability_ = value;
              }
              break;
            }
            case 120: {
              bitField0_ |= 0x00004000;
              autoIncrement_ = input.readBool();
              break;
            }
            case 128: {
              bitField0_ |= 0x00008000;
              caseSensitivity_ = input.readBool();
              break;
            }
            case 136: {
              bitField0_ |= 0x00010000;
              sortable_ = input.readBool();
              break;
            }
            case 146: {
              bitField0_ |= 0x00020000;
              className_ = input.readBytes();
              break;
            }
            case 160: {
              bitField0_ |= 0x00040000;
              isCurrency_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_ResultColumnMetadata_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_ResultColumnMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata.class, org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata.Builder.class);
    }

    public static com.google.protobuf.Parser<ResultColumnMetadata> PARSER =
        new com.google.protobuf.AbstractParser<ResultColumnMetadata>() {
      public ResultColumnMetadata parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ResultColumnMetadata(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<ResultColumnMetadata> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional string catalog_name = 1;
    public static final int CATALOG_NAME_FIELD_NUMBER = 1;
    private java.lang.Object catalogName_;
    /**
     * <code>optional string catalog_name = 1;</code>
     *
     * <pre>
     *
     * Designated column's catalog name. Empty string if not applicable.
     * Defaults to "DRILL" as drill has only one catalog.
     * </pre>
     */
    public boolean hasCatalogName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     *
     * <pre>
     *
     * Designated column's catalog name. Empty string if not applicable.
     * Defaults to "DRILL" as drill has only one catalog.
     * </pre>
     */
    public java.lang.String getCatalogName() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          catalogName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     *
     * <pre>
     *
     * Designated column's catalog name. Empty string if not applicable.
     * Defaults to "DRILL" as drill has only one catalog.
     * </pre>
     */
    public com.google.protobuf.ByteString
        getCatalogNameBytes() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        catalogName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string schema_name = 2;
    public static final int SCHEMA_NAME_FIELD_NUMBER = 2;
    private java.lang.Object schemaName_;
    /**
     * <code>optional string schema_name = 2;</code>
     *
     * <pre>
     *
     * Designated column's schema name. Not set if not applicable. Initial implementation
     * defaults to no value as we use LIMIT 0 queries to get the schema and schema info
     * is lost. If we derive the schema from plan, we may get the right value.
     * </pre>
     */
    public boolean hasSchemaName() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string schema_name = 2;</code>
     *
     * <pre>
     *
     * Designated column's schema name. Not set if not applicable. Initial implementation
     * defaults to no value as we use LIMIT 0 queries to get the schema and schema info
     * is lost. If we derive the schema from plan, we may get the right value.
     * </pre>
     */
    public java.lang.String getSchemaName() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          schemaName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string schema_name = 2;</code>
     *
     * <pre>
     *
     * Designated column's schema name. Not set if not applicable. Initial implementation
     * defaults to no value as we use LIMIT 0 queries to get the schema and schema info
     * is lost. If we derive the schema from plan, we may get the right value.
     * </pre>
     */
    public com.google.protobuf.ByteString
        getSchemaNameBytes() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        schemaName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string table_name = 3;
    public static final int TABLE_NAME_FIELD_NUMBER = 3;
    private java.lang.Object tableName_;
    /**
     * <code>optional string table_name = 3;</code>
     *
     * <pre>
     *
     * Designated column's table name. Not set if not applicable. Initial implementation
     * defaults to no value as we use LIMIT 0 queries to get the schema and table info
     * is lost. If we derive the schema from query plan, we may get the right value.
     * </pre>
     */
    public boolean hasTableName() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional string table_name = 3;</code>
     *
     * <pre>
     *
     * Designated column's table name. Not set if not applicable. Initial implementation
     * defaults to no value as we use LIMIT 0 queries to get the schema and table info
     * is lost. If we derive the schema from query plan, we may get the right value.
     * </pre>
     */
    public java.lang.String getTableName() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          tableName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string table_name = 3;</code>
     *
     * <pre>
     *
     * Designated column's table name. Not set if not applicable. Initial implementation
     * defaults to no value as we use LIMIT 0 queries to get the schema and table info
     * is lost. If we derive the schema from query plan, we may get the right value.
     * </pre>
     */
    public com.google.protobuf.ByteString
        getTableNameBytes() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        tableName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string column_name = 4;
    public static final int COLUMN_NAME_FIELD_NUMBER = 4;
    private java.lang.Object columnName_;
    /**
     * <code>optional string column_name = 4;</code>
     *
     * <pre>
     * column name
     * </pre>
     */
    public boolean hasColumnName() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional string column_name = 4;</code>
     *
     * <pre>
     * column name
     * </pre>
     */
    public java.lang.String getColumnName() {
      java.lang.Object ref = columnName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          columnName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string column_name = 4;</code>
     *
     * <pre>
     * column name
     * </pre>
     */
    public com.google.protobuf.ByteString
        getColumnNameBytes() {
      java.lang.Object ref = columnName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        columnName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string label = 5;
    public static final int LABEL_FIELD_NUMBER = 5;
    private java.lang.Object label_;
    /**
     * <code>optional string label = 5;</code>
     *
     * <pre>
     *
     * Column label name for display or print purposes.
     * Ex. a column named "empName" might be labeled as "Employee Name".
     * </pre>
     */
    public boolean hasLabel() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional string label = 5;</code>
     *
     * <pre>
     *
     * Column label name for display or print purposes.
     * Ex. a column named "empName" might be labeled as "Employee Name".
     * </pre>
     */
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          label_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string label = 5;</code>
     *
     * <pre>
     *
     * Column label name for display or print purposes.
     * Ex. a column named "empName" might be labeled as "Employee Name".
     * </pre>
     */
    public com.google.protobuf.ByteString
        getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string data_type = 6;
    public static final int DATA_TYPE_FIELD_NUMBER = 6;
    private java.lang.Object dataType_;
    /**
     * <code>optional string data_type = 6;</code>
     *
     * <pre>
     *
     * Data type in string format. Value is SQL standard type.
     * </pre>
     */
    public boolean hasDataType() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional string data_type = 6;</code>
     *
     * <pre>
     *
     * Data type in string format. Value is SQL standard type.
     * </pre>
     */
    public java.lang.String getDataType() {
      java.lang.Object ref = dataType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          dataType_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string data_type = 6;</code>
     *
     * <pre>
     *
     * Data type in string format. Value is SQL standard type.
     * </pre>
     */
    public com.google.protobuf.ByteString
        getDataTypeBytes() {
      java.lang.Object ref = dataType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        dataType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional bool is_nullable = 7;
    public static final int IS_NULLABLE_FIELD_NUMBER = 7;
    private boolean isNullable_;
    /**
     * <code>optional bool is_nullable = 7;</code>
     */
    public boolean hasIsNullable() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional bool is_nullable = 7;</code>
     */
    public boolean getIsNullable() {
      return isNullable_;
    }

    // optional int32 precision = 8;
    public static final int PRECISION_FIELD_NUMBER = 8;
    private int precision_;
    /**
     * <code>optional int32 precision = 8;</code>
     *
     * <pre>
     *
     * For numeric data, this is the maximum precision.
     * For character data, this is the length in characters.
     * For datetime datatypes, this is the length in characters of the String representation
     *    (assuming the maximum allowed precision of the fractional seconds component).
     * For binary data, this is the length in bytes.
     * For all other types 0 is returned where the column size is not applicable.
     * </pre>
     */
    public boolean hasPrecision() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     * <code>optional int32 precision = 8;</code>
     *
     * <pre>
     *
     * For numeric data, this is the maximum precision.
     * For character data, this is the length in characters.
     * For datetime datatypes, this is the length in characters of the String representation
     *    (assuming the maximum allowed precision of the fractional seconds component).
     * For binary data, this is the length in bytes.
     * For all other types 0 is returned where the column size is not applicable.
     * </pre>
     */
    public int getPrecision() {
      return precision_;
    }

    // optional int32 scale = 9;
    public static final int SCALE_FIELD_NUMBER = 9;
    private int scale_;
    /**
     * <code>optional int32 scale = 9;</code>
     *
     * <pre>
     *
     * Column's number of digits to right of the decimal point.
     * 0 is returned for types where the scale is not applicable
     * </pre>
     */
    public boolean hasScale() {
      return ((bitField0_ & 0x00000100) == 0x00000100);
    }
    /**
     * <code>optional int32 scale = 9;</code>
     *
     * <pre>
     *
     * Column's number of digits to right of the decimal point.
     * 0 is returned for types where the scale is not applicable
     * </pre>
     */
    public int getScale() {
      return scale_;
    }

    // optional bool signed = 10;
    public static final int SIGNED_FIELD_NUMBER = 10;
    private boolean signed_;
    /**
     * <code>optional bool signed = 10;</code>
     *
     * <pre>
     *
     * Indicates whether values in the designated column are signed numbers.
     * </pre>
     */
    public boolean hasSigned() {
      return ((bitField0_ & 0x00000200) == 0x00000200);
    }
    /**
     * <code>optional bool signed = 10;</code>
     *
     * <pre>
     *
     * Indicates whether values in the designated column are signed numbers.
     * </pre>
     */
    public boolean getSigned() {
      return signed_;
    }

    // optional int32 display_size = 11;
    public static final int DISPLAY_SIZE_FIELD_NUMBER = 11;
    private int displaySize_;
    /**
     * <code>optional int32 display_size = 11;</code>
     *
     * <pre>
     *
     * Maximum number of characters required to display data from the column.
     * </pre>
     */
    public boolean hasDisplaySize() {
      return ((bitField0_ & 0x00000400) == 0x00000400);
    }
    /**
     * <code>optional int32 display_size = 11;</code>
     *
     * <pre>
     *
     * Maximum number of characters required to display data from the column.
     * </pre>
     */
    public int getDisplaySize() {
      return displaySize_;
    }

    // optional bool is_aliased = 12;
    public static final int IS_ALIASED_FIELD_NUMBER = 12;
    private boolean isAliased_;
    /**
     * <code>optional bool is_aliased = 12;</code>
     *
     * <pre>
     *
     * Is the column an aliased column. Initial implementation defaults to
     * true as we derive schema from LIMIT 0 query and not the query plan.
     * </pre>
     */
    public boolean hasIsAliased() {
      return ((bitField0_ & 0x00000800) == 0x00000800);
    }
    /**
     * <code>optional bool is_aliased = 12;</code>
     *
     * <pre>
     *
     * Is the column an aliased column. Initial implementation defaults to
     * true as we derive schema from LIMIT 0 query and not the query plan.
     * </pre>
     */
    public boolean getIsAliased() {
      return isAliased_;
    }

    // optional .exec.user.ColumnSearchability searchability = 13;
    public static final int SEARCHABILITY_FIELD_NUMBER = 13;
    private org.apache.drill.exec.proto.UserProtos.ColumnSearchability searchability_;
    /**
     * <code>optional .exec.user.ColumnSearchability searchability = 13;</code>
     */
    public boolean hasSearchability() {
      return ((bitField0_ & 0x00001000) == 0x00001000);
    }
    /**
     * <code>optional .exec.user.ColumnSearchability searchability = 13;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.ColumnSearchability getSearchability() {
      return searchability_;
    }

    // optional .exec.user.ColumnUpdatability updatability = 14;
    public static final int UPDATABILITY_FIELD_NUMBER = 14;
    private org.apache.drill.exec.proto.UserProtos.ColumnUpdatability updatability_;
    /**
     * <code>optional .exec.user.ColumnUpdatability updatability = 14;</code>
     *
     * <pre>
     *
     * Defaults to READ_ONLY
     * </pre>
     */
    public boolean hasUpdatability() {
      return ((bitField0_ & 0x00002000) == 0x00002000);
    }
    /**
     * <code>optional .exec.user.ColumnUpdatability updatability = 14;</code>
     *
     * <pre>
     *
     * Defaults to READ_ONLY
     * </pre>
     */
    public org.apache.drill.exec.proto.UserProtos.ColumnUpdatability getUpdatability() {
      return updatability_;
    }

    // optional bool auto_increment = 15;
    public static final int AUTO_INCREMENT_FIELD_NUMBER = 15;
    private boolean autoIncrement_;
    /**
     * <code>optional bool auto_increment = 15;</code>
     *
     * <pre>
     *
     * whether the designated column is automatically incremented.
     * </pre>
     */
    public boolean hasAutoIncrement() {
      return ((bitField0_ & 0x00004000) == 0x00004000);
    }
    /**
     * <code>optional bool auto_increment = 15;</code>
     *
     * <pre>
     *
     * whether the designated column is automatically incremented.
     * </pre>
     */
    public boolean getAutoIncrement() {
      return autoIncrement_;
    }

    // optional bool case_sensitivity = 16;
    public static final int CASE_SENSITIVITY_FIELD_NUMBER = 16;
    private boolean caseSensitivity_;
    /**
     * <code>optional bool case_sensitivity = 16;</code>
     *
     * <pre>
     *
     * Whether column's case matters for collations and comparisons. Defaults to true.
     * </pre>
     */
    public boolean hasCaseSensitivity() {
      return ((bitField0_ & 0x00008000) == 0x00008000);
    }
    /**
     * <code>optional bool case_sensitivity = 16;</code>
     *
     * <pre>
     *
     * Whether column's case matters for collations and comparisons. Defaults to true.
     * </pre>
     */
    public boolean getCaseSensitivity() {
      return caseSensitivity_;
    }

    // optional bool sortable = 17;
    public static final int SORTABLE_FIELD_NUMBER = 17;
    private boolean sortable_;
    /**
     * <code>optional bool sortable = 17;</code>
     *
     * <pre>
     *
     * whether the column can be used in ORDER BY clause
     * </pre>
     */
    public boolean hasSortable() {
      return ((bitField0_ & 0x00010000) == 0x00010000);
    }
    /**
     * <code>optional bool sortable = 17;</code>
     *
     * <pre>
     *
     * whether the column can be used in ORDER BY clause
     * </pre>
     */
    public boolean getSortable() {
      return sortable_;
    }

    // optional string class_name = 18;
    public static final int CLASS_NAME_FIELD_NUMBER = 18;
    private java.lang.Object className_;
    /**
     * <code>optional string class_name = 18;</code>
     *
     * <pre>
     *
     * A fully-qualified name of the Java class whose instances are created
     * if the method ResultSet.getObject is called to retrieve
     * a value from the column. Applicable only to JDBC clients.
     * </pre>
     */
    public boolean hasClassName() {
      return ((bitField0_ & 0x00020000) == 0x00020000);
    }
    /**
     * <code>optional string class_name = 18;</code>
     *
     * <pre>
     *
     * A fully-qualified name of the Java class whose instances are created
     * if the method ResultSet.getObject is called to retrieve
     * a value from the column. Applicable only to JDBC clients.
     * </pre>
     */
    public java.lang.String getClassName() {
      java.lang.Object ref = className_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          className_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string class_name = 18;</code>
     *
     * <pre>
     *
     * A fully-qualified name of the Java class whose instances are created
     * if the method ResultSet.getObject is called to retrieve
     * a value from the column. Applicable only to JDBC clients.
     * </pre>
     */
    public com.google.protobuf.ByteString
        getClassNameBytes() {
      java.lang.Object ref = className_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        className_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional bool is_currency = 20;
    public static final int IS_CURRENCY_FIELD_NUMBER = 20;
    private boolean isCurrency_;
    /**
     * <code>optional bool is_currency = 20;</code>
     *
     * <pre>
     *
     * Is the data type a currency type? For JDBC only.
     * </pre>
     */
    public boolean hasIsCurrency() {
      return ((bitField0_ & 0x00040000) == 0x00040000);
    }
    /**
     * <code>optional bool is_currency = 20;</code>
     *
     * <pre>
     *
     * Is the data type a currency type? For JDBC only.
     * </pre>
     */
    public boolean getIsCurrency() {
      return isCurrency_;
    }

    private void initFields() {
      catalogName_ = "";
      schemaName_ = "";
      tableName_ = "";
      columnName_ = "";
      label_ = "";
      dataType_ = "";
      isNullable_ = false;
      precision_ = 0;
      scale_ = 0;
      signed_ = false;
      displaySize_ = 0;
      isAliased_ = false;
      searchability_ = org.apache.drill.exec.proto.UserProtos.ColumnSearchability.UNKNOWN_SEARCHABILITY;
      updatability_ = org.apache.drill.exec.proto.UserProtos.ColumnUpdatability.UNKNOWN_UPDATABILITY;
      autoIncrement_ = false;
      caseSensitivity_ = false;
      sortable_ = false;
      className_ = "";
      isCurrency_ = false;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getCatalogNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getSchemaNameBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(3, getTableNameBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeBytes(4, getColumnNameBytes());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeBytes(5, getLabelBytes());
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeBytes(6, getDataTypeBytes());
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeBool(7, isNullable_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeInt32(8, precision_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        output.writeInt32(9, scale_);
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        output.writeBool(10, signed_);
      }
      if (((bitField0_ & 0x00000400) == 0x00000400)) {
        output.writeInt32(11, displaySize_);
      }
      if (((bitField0_ & 0x00000800) == 0x00000800)) {
        output.writeBool(12, isAliased_);
      }
      if (((bitField0_ & 0x00001000) == 0x00001000)) {
        output.writeEnum(13, searchability_.getNumber());
      }
      if (((bitField0_ & 0x00002000) == 0x00002000)) {
        output.writeEnum(14, updatability_.getNumber());
      }
      if (((bitField0_ & 0x00004000) == 0x00004000)) {
        output.writeBool(15, autoIncrement_);
      }
      if (((bitField0_ & 0x00008000) == 0x00008000)) {
        output.writeBool(16, caseSensitivity_);
      }
      if (((bitField0_ & 0x00010000) == 0x00010000)) {
        output.writeBool(17, sortable_);
      }
      if (((bitField0_ & 0x00020000) == 0x00020000)) {
        output.writeBytes(18, getClassNameBytes());
      }
      if (((bitField0_ & 0x00040000) == 0x00040000)) {
        output.writeBool(20, isCurrency_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getCatalogNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getSchemaNameBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, getTableNameBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(4, getColumnNameBytes());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(5, getLabelBytes());
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(6, getDataTypeBytes());
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(7, isNullable_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(8, precision_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(9, scale_);
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(10, signed_);
      }
      if (((bitField0_ & 0x00000400) == 0x00000400)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(11, displaySize_);
      }
      if (((bitField0_ & 0x00000800) == 0x00000800)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(12, isAliased_);
      }
      if (((bitField0_ & 0x00001000) == 0x00001000)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(13, searchability_.getNumber());
      }
      if (((bitField0_ & 0x00002000) == 0x00002000)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(14, updatability_.getNumber());
      }
      if (((bitField0_ & 0x00004000) == 0x00004000)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(15, autoIncrement_);
      }
      if (((bitField0_ & 0x00008000) == 0x00008000)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(16, caseSensitivity_);
      }
      if (((bitField0_ & 0x00010000) == 0x00010000)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(17, sortable_);
      }
      if (((bitField0_ & 0x00020000) == 0x00020000)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(18, getClassNameBytes());
      }
      if (((bitField0_ & 0x00040000) == 0x00040000)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(20, isCurrency_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.ResultColumnMetadata}
     *
     * <pre>
     *
     * Metadata of a column in query result set
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.ResultColumnMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_ResultColumnMetadata_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_ResultColumnMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata.class, org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        catalogName_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        schemaName_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        tableName_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        columnName_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        label_ = "";
        bitField0_ = (bitField0_ & ~0x00000010);
        dataType_ = "";
        bitField0_ = (bitField0_ & ~0x00000020);
        isNullable_ = false;
        bitField0_ = (bitField0_ & ~0x00000040);
        precision_ = 0;
        bitField0_ = (bitField0_ & ~0x00000080);
        scale_ = 0;
        bitField0_ = (bitField0_ & ~0x00000100);
        signed_ = false;
        bitField0_ = (bitField0_ & ~0x00000200);
        displaySize_ = 0;
        bitField0_ = (bitField0_ & ~0x00000400);
        isAliased_ = false;
        bitField0_ = (bitField0_ & ~0x00000800);
        searchability_ = org.apache.drill.exec.proto.UserProtos.ColumnSearchability.UNKNOWN_SEARCHABILITY;
        bitField0_ = (bitField0_ & ~0x00001000);
        updatability_ = org.apache.drill.exec.proto.UserProtos.ColumnUpdatability.UNKNOWN_UPDATABILITY;
        bitField0_ = (bitField0_ & ~0x00002000);
        autoIncrement_ = false;
        bitField0_ = (bitField0_ & ~0x00004000);
        caseSensitivity_ = false;
        bitField0_ = (bitField0_ & ~0x00008000);
        sortable_ = false;
        bitField0_ = (bitField0_ & ~0x00010000);
        className_ = "";
        bitField0_ = (bitField0_ & ~0x00020000);
        isCurrency_ = false;
        bitField0_ = (bitField0_ & ~0x00040000);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_ResultColumnMetadata_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata build() {
        org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata buildPartial() {
        org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata result = new org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.catalogName_ = catalogName_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.schemaName_ = schemaName_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.tableName_ = tableName_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.columnName_ = columnName_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.label_ = label_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.dataType_ = dataType_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.isNullable_ = isNullable_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000080;
        }
        result.precision_ = precision_;
        if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
          to_bitField0_ |= 0x00000100;
        }
        result.scale_ = scale_;
        if (((from_bitField0_ & 0x00000200) == 0x00000200)) {
          to_bitField0_ |= 0x00000200;
        }
        result.signed_ = signed_;
        if (((from_bitField0_ & 0x00000400) == 0x00000400)) {
          to_bitField0_ |= 0x00000400;
        }
        result.displaySize_ = displaySize_;
        if (((from_bitField0_ & 0x00000800) == 0x00000800)) {
          to_bitField0_ |= 0x00000800;
        }
        result.isAliased_ = isAliased_;
        if (((from_bitField0_ & 0x00001000) == 0x00001000)) {
          to_bitField0_ |= 0x00001000;
        }
        result.searchability_ = searchability_;
        if (((from_bitField0_ & 0x00002000) == 0x00002000)) {
          to_bitField0_ |= 0x00002000;
        }
        result.updatability_ = updatability_;
        if (((from_bitField0_ & 0x00004000) == 0x00004000)) {
          to_bitField0_ |= 0x00004000;
        }
        result.autoIncrement_ = autoIncrement_;
        if (((from_bitField0_ & 0x00008000) == 0x00008000)) {
          to_bitField0_ |= 0x00008000;
        }
        result.caseSensitivity_ = caseSensitivity_;
        if (((from_bitField0_ & 0x00010000) == 0x00010000)) {
          to_bitField0_ |= 0x00010000;
        }
        result.sortable_ = sortable_;
        if (((from_bitField0_ & 0x00020000) == 0x00020000)) {
          to_bitField0_ |= 0x00020000;
        }
        result.className_ = className_;
        if (((from_bitField0_ & 0x00040000) == 0x00040000)) {
          to_bitField0_ |= 0x00040000;
        }
        result.isCurrency_ = isCurrency_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata other) {
        if (other == org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata.getDefaultInstance()) return this;
        if (other.hasCatalogName()) {
          bitField0_ |= 0x00000001;
          catalogName_ = other.catalogName_;
          onChanged();
        }
        if (other.hasSchemaName()) {
          bitField0_ |= 0x00000002;
          schemaName_ = other.schemaName_;
          onChanged();
        }
        if (other.hasTableName()) {
          bitField0_ |= 0x00000004;
          tableName_ = other.tableName_;
          onChanged();
        }
        if (other.hasColumnName()) {
          bitField0_ |= 0x00000008;
          columnName_ = other.columnName_;
          onChanged();
        }
        if (other.hasLabel()) {
          bitField0_ |= 0x00000010;
          label_ = other.label_;
          onChanged();
        }
        if (other.hasDataType()) {
          bitField0_ |= 0x00000020;
          dataType_ = other.dataType_;
          onChanged();
        }
        if (other.hasIsNullable()) {
          setIsNullable(other.getIsNullable());
        }
        if (other.hasPrecision()) {
          setPrecision(other.getPrecision());
        }
        if (other.hasScale()) {
          setScale(other.getScale());
        }
        if (other.hasSigned()) {
          setSigned(other.getSigned());
        }
        if (other.hasDisplaySize()) {
          setDisplaySize(other.getDisplaySize());
        }
        if (other.hasIsAliased()) {
          setIsAliased(other.getIsAliased());
        }
        if (other.hasSearchability()) {
          setSearchability(other.getSearchability());
        }
        if (other.hasUpdatability()) {
          setUpdatability(other.getUpdatability());
        }
        if (other.hasAutoIncrement()) {
          setAutoIncrement(other.getAutoIncrement());
        }
        if (other.hasCaseSensitivity()) {
          setCaseSensitivity(other.getCaseSensitivity());
        }
        if (other.hasSortable()) {
          setSortable(other.getSortable());
        }
        if (other.hasClassName()) {
          bitField0_ |= 0x00020000;
          className_ = other.className_;
          onChanged();
        }
        if (other.hasIsCurrency()) {
          setIsCurrency(other.getIsCurrency());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional string catalog_name = 1;
      private java.lang.Object catalogName_ = "";
      /**
       * <code>optional string catalog_name = 1;</code>
       *
       * <pre>
       *
       * Designated column's catalog name. Empty string if not applicable.
       * Defaults to "DRILL" as drill has only one catalog.
       * </pre>
       */
      public boolean hasCatalogName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       *
       * <pre>
       *
       * Designated column's catalog name. Empty string if not applicable.
       * Defaults to "DRILL" as drill has only one catalog.
       * </pre>
       */
      public java.lang.String getCatalogName() {
        java.lang.Object ref = catalogName_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          catalogName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       *
       * <pre>
       *
       * Designated column's catalog name. Empty string if not applicable.
       * Defaults to "DRILL" as drill has only one catalog.
       * </pre>
       */
      public com.google.protobuf.ByteString
          getCatalogNameBytes() {
        java.lang.Object ref = catalogName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          catalogName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       *
       * <pre>
       *
       * Designated column's catalog name. Empty string if not applicable.
       * Defaults to "DRILL" as drill has only one catalog.
       * </pre>
       */
      public Builder setCatalogName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       *
       * <pre>
       *
       * Designated column's catalog name. Empty string if not applicable.
       * Defaults to "DRILL" as drill has only one catalog.
       * </pre>
       */
      public Builder clearCatalogName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        catalogName_ = getDefaultInstance().getCatalogName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       *
       * <pre>
       *
       * Designated column's catalog name. Empty string if not applicable.
       * Defaults to "DRILL" as drill has only one catalog.
       * </pre>
       */
      public Builder setCatalogNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }

      // optional string schema_name = 2;
      private java.lang.Object schemaName_ = "";
      /**
       * <code>optional string schema_name = 2;</code>
       *
       * <pre>
       *
       * Designated column's schema name. Not set if not applicable. Initial implementation
       * defaults to no value as we use LIMIT 0 queries to get the schema and schema info
       * is lost. If we derive the schema from plan, we may get the right value.
       * </pre>
       */
      public boolean hasSchemaName() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string schema_name = 2;</code>
       *
       * <pre>
       *
       * Designated column's schema name. Not set if not applicable. Initial implementation
       * defaults to no value as we use LIMIT 0 queries to get the schema and schema info
       * is lost. If we derive the schema from plan, we may get the right value.
       * </pre>
       */
      public java.lang.String getSchemaName() {
        java.lang.Object ref = schemaName_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          schemaName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       *
       * <pre>
       *
       * Designated column's schema name. Not set if not applicable. Initial implementation
       * defaults to no value as we use LIMIT 0 queries to get the schema and schema info
       * is lost. If we derive the schema from plan, we may get the right value.
       * </pre>
       */
      public com.google.protobuf.ByteString
          getSchemaNameBytes() {
        java.lang.Object ref = schemaName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          schemaName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       *
       * <pre>
       *
       * Designated column's schema name. Not set if not applicable. Initial implementation
       * defaults to no value as we use LIMIT 0 queries to get the schema and schema info
       * is lost. If we derive the schema from plan, we may get the right value.
       * </pre>
       */
      public Builder setSchemaName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schemaName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       *
       * <pre>
       *
       * Designated column's schema name. Not set if not applicable. Initial implementation
       * defaults to no value as we use LIMIT 0 queries to get the schema and schema info
       * is lost. If we derive the schema from plan, we may get the right value.
       * </pre>
       */
      public Builder clearSchemaName() {
        bitField0_ = (bitField0_ & ~0x00000002);
        schemaName_ = getDefaultInstance().getSchemaName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       *
       * <pre>
       *
       * Designated column's schema name. Not set if not applicable. Initial implementation
       * defaults to no value as we use LIMIT 0 queries to get the schema and schema info
       * is lost. If we derive the schema from plan, we may get the right value.
       * </pre>
       */
      public Builder setSchemaNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schemaName_ = value;
        onChanged();
        return this;
      }

      // optional string table_name = 3;
      private java.lang.Object tableName_ = "";
      /**
       * <code>optional string table_name = 3;</code>
       *
       * <pre>
       *
       * Designated column's table name. Not set if not applicable. Initial implementation
       * defaults to no value as we use LIMIT 0 queries to get the schema and table info
       * is lost. If we derive the schema from query plan, we may get the right value.
       * </pre>
       */
      public boolean hasTableName() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional string table_name = 3;</code>
       *
       * <pre>
       *
       * Designated column's table name. Not set if not applicable. Initial implementation
       * defaults to no value as we use LIMIT 0 queries to get the schema and table info
       * is lost. If we derive the schema from query plan, we may get the right value.
       * </pre>
       */
      public java.lang.String getTableName() {
        java.lang.Object ref = tableName_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          tableName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string table_name = 3;</code>
       *
       * <pre>
       *
       * Designated column's table name. Not set if not applicable. Initial implementation
       * defaults to no value as we use LIMIT 0 queries to get the schema and table info
       * is lost. If we derive the schema from query plan, we may get the right value.
       * </pre>
       */
      public com.google.protobuf.ByteString
          getTableNameBytes() {
        java.lang.Object ref = tableName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          tableName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string table_name = 3;</code>
       *
       * <pre>
       *
       * Designated column's table name. Not set if not applicable. Initial implementation
       * defaults to no value as we use LIMIT 0 queries to get the schema and table info
       * is lost. If we derive the schema from query plan, we may get the right value.
       * </pre>
       */
      public Builder setTableName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        tableName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string table_name = 3;</code>
       *
       * <pre>
       *
       * Designated column's table name. Not set if not applicable. Initial implementation
       * defaults to no value as we use LIMIT 0 queries to get the schema and table info
       * is lost. If we derive the schema from query plan, we may get the right value.
       * </pre>
       */
      public Builder clearTableName() {
        bitField0_ = (bitField0_ & ~0x00000004);
        tableName_ = getDefaultInstance().getTableName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string table_name = 3;</code>
       *
       * <pre>
       *
       * Designated column's table name. Not set if not applicable. Initial implementation
       * defaults to no value as we use LIMIT 0 queries to get the schema and table info
       * is lost. If we derive the schema from query plan, we may get the right value.
       * </pre>
       */
      public Builder setTableNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        tableName_ = value;
        onChanged();
        return this;
      }

      // optional string column_name = 4;
      private java.lang.Object columnName_ = "";
      /**
       * <code>optional string column_name = 4;</code>
       *
       * <pre>
       * column name
       * </pre>
       */
      public boolean hasColumnName() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional string column_name = 4;</code>
       *
       * <pre>
       * column name
       * </pre>
       */
      public java.lang.String getColumnName() {
        java.lang.Object ref = columnName_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          columnName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string column_name = 4;</code>
       *
       * <pre>
       * column name
       * </pre>
       */
      public com.google.protobuf.ByteString
          getColumnNameBytes() {
        java.lang.Object ref = columnName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          columnName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string column_name = 4;</code>
       *
       * <pre>
       * column name
       * </pre>
       */
      public Builder setColumnName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        columnName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string column_name = 4;</code>
       *
       * <pre>
       * column name
       * </pre>
       */
      public Builder clearColumnName() {
        bitField0_ = (bitField0_ & ~0x00000008);
        columnName_ = getDefaultInstance().getColumnName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string column_name = 4;</code>
       *
       * <pre>
       * column name
       * </pre>
       */
      public Builder setColumnNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        columnName_ = value;
        onChanged();
        return this;
      }

      // optional string label = 5;
      private java.lang.Object label_ = "";
      /**
       * <code>optional string label = 5;</code>
       *
       * <pre>
       *
       * Column label name for display or print purposes.
       * Ex. a column named "empName" might be labeled as "Employee Name".
       * </pre>
       */
      public boolean hasLabel() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional string label = 5;</code>
       *
       * <pre>
       *
       * Column label name for display or print purposes.
       * Ex. a column named "empName" might be labeled as "Employee Name".
       * </pre>
       */
      public java.lang.String getLabel() {
        java.lang.Object ref = label_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          label_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string label = 5;</code>
       *
       * <pre>
       *
       * Column label name for display or print purposes.
       * Ex. a column named "empName" might be labeled as "Employee Name".
       * </pre>
       */
      public com.google.protobuf.ByteString
          getLabelBytes() {
        java.lang.Object ref = label_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          label_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string label = 5;</code>
       *
       * <pre>
       *
       * Column label name for display or print purposes.
       * Ex. a column named "empName" might be labeled as "Employee Name".
       * </pre>
       */
      public Builder setLabel(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
        label_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string label = 5;</code>
       *
       * <pre>
       *
       * Column label name for display or print purposes.
       * Ex. a column named "empName" might be labeled as "Employee Name".
       * </pre>
       */
      public Builder clearLabel() {
        bitField0_ = (bitField0_ & ~0x00000010);
        label_ = getDefaultInstance().getLabel();
        onChanged();
        return this;
      }
      /**
       * <code>optional string label = 5;</code>
       *
       * <pre>
       *
       * Column label name for display or print purposes.
       * Ex. a column named "empName" might be labeled as "Employee Name".
       * </pre>
       */
      public Builder setLabelBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
        label_ = value;
        onChanged();
        return this;
      }

      // optional string data_type = 6;
      private java.lang.Object dataType_ = "";
      /**
       * <code>optional string data_type = 6;</code>
       *
       * <pre>
       *
       * Data type in string format. Value is SQL standard type.
       * </pre>
       */
      public boolean hasDataType() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional string data_type = 6;</code>
       *
       * <pre>
       *
       * Data type in string format. Value is SQL standard type.
       * </pre>
       */
      public java.lang.String getDataType() {
        java.lang.Object ref = dataType_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          dataType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string data_type = 6;</code>
       *
       * <pre>
       *
       * Data type in string format. Value is SQL standard type.
       * </pre>
       */
      public com.google.protobuf.ByteString
          getDataTypeBytes() {
        java.lang.Object ref = dataType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          dataType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string data_type = 6;</code>
       *
       * <pre>
       *
       * Data type in string format. Value is SQL standard type.
       * </pre>
       */
      public Builder setDataType(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
        dataType_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string data_type = 6;</code>
       *
       * <pre>
       *
       * Data type in string format. Value is SQL standard type.
       * </pre>
       */
      public Builder clearDataType() {
        bitField0_ = (bitField0_ & ~0x00000020);
        dataType_ = getDefaultInstance().getDataType();
        onChanged();
        return this;
      }
      /**
       * <code>optional string data_type = 6;</code>
       *
       * <pre>
       *
       * Data type in string format. Value is SQL standard type.
       * </pre>
       */
      public Builder setDataTypeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
        dataType_ = value;
        onChanged();
        return this;
      }

      // optional bool is_nullable = 7;
      private boolean isNullable_ ;
      /**
       * <code>optional bool is_nullable = 7;</code>
       */
      public boolean hasIsNullable() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional bool is_nullable = 7;</code>
       */
      public boolean getIsNullable() {
        return isNullable_;
      }
      /**
       * <code>optional bool is_nullable = 7;</code>
       */
      public Builder setIsNullable(boolean value) {
        bitField0_ |= 0x00000040;
        isNullable_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool is_nullable = 7;</code>
       */
      public Builder clearIsNullable() {
        bitField0_ = (bitField0_ & ~0x00000040);
        isNullable_ = false;
        onChanged();
        return this;
      }

      // optional int32 precision = 8;
      private int precision_ ;
      /**
       * <code>optional int32 precision = 8;</code>
       *
       * <pre>
       *
       * For numeric data, this is the maximum precision.
       * For character data, this is the length in characters.
       * For datetime datatypes, this is the length in characters of the String representation
       *    (assuming the maximum allowed precision of the fractional seconds component).
       * For binary data, this is the length in bytes.
       * For all other types 0 is returned where the column size is not applicable.
       * </pre>
       */
      public boolean hasPrecision() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <code>optional int32 precision = 8;</code>
       *
       * <pre>
       *
       * For numeric data, this is the maximum precision.
       * For character data, this is the length in characters.
       * For datetime datatypes, this is the length in characters of the String representation
       *    (assuming the maximum allowed precision of the fractional seconds component).
       * For binary data, this is the length in bytes.
       * For all other types 0 is returned where the column size is not applicable.
       * </pre>
       */
      public int getPrecision() {
        return precision_;
      }
      /**
       * <code>optional int32 precision = 8;</code>
       *
       * <pre>
       *
       * For numeric data, this is the maximum precision.
       * For character data, this is the length in characters.
       * For datetime datatypes, this is the length in characters of the String representation
       *    (assuming the maximum allowed precision of the fractional seconds component).
       * For binary data, this is the length in bytes.
       * For all other types 0 is returned where the column size is not applicable.
       * </pre>
       */
      public Builder setPrecision(int value) {
        bitField0_ |= 0x00000080;
        precision_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 precision = 8;</code>
       *
       * <pre>
       *
       * For numeric data, this is the maximum precision.
       * For character data, this is the length in characters.
       * For datetime datatypes, this is the length in characters of the String representation
       *    (assuming the maximum allowed precision of the fractional seconds component).
       * For binary data, this is the length in bytes.
       * For all other types 0 is returned where the column size is not applicable.
       * </pre>
       */
      public Builder clearPrecision() {
        bitField0_ = (bitField0_ & ~0x00000080);
        precision_ = 0;
        onChanged();
        return this;
      }

      // optional int32 scale = 9;
      private int scale_ ;
      /**
       * <code>optional int32 scale = 9;</code>
       *
       * <pre>
       *
       * Column's number of digits to right of the decimal point.
       * 0 is returned for types where the scale is not applicable
       * </pre>
       */
      public boolean hasScale() {
        return ((bitField0_ & 0x00000100) == 0x00000100);
      }
      /**
       * <code>optional int32 scale = 9;</code>
       *
       * <pre>
       *
       * Column's number of digits to right of the decimal point.
       * 0 is returned for types where the scale is not applicable
       * </pre>
       */
      public int getScale() {
        return scale_;
      }
      /**
       * <code>optional int32 scale = 9;</code>
       *
       * <pre>
       *
       * Column's number of digits to right of the decimal point.
       * 0 is returned for types where the scale is not applicable
       * </pre>
       */
      public Builder setScale(int value) {
        bitField0_ |= 0x00000100;
        scale_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 scale = 9;</code>
       *
       * <pre>
       *
       * Column's number of digits to right of the decimal point.
       * 0 is returned for types where the scale is not applicable
       * </pre>
       */
      public Builder clearScale() {
        bitField0_ = (bitField0_ & ~0x00000100);
        scale_ = 0;
        onChanged();
        return this;
      }

      // optional bool signed = 10;
      private boolean signed_ ;
      /**
       * <code>optional bool signed = 10;</code>
       *
       * <pre>
       *
       * Indicates whether values in the designated column are signed numbers.
       * </pre>
       */
      public boolean hasSigned() {
        return ((bitField0_ & 0x00000200) == 0x00000200);
      }
      /**
       * <code>optional bool signed = 10;</code>
       *
       * <pre>
       *
       * Indicates whether values in the designated column are signed numbers.
       * </pre>
       */
      public boolean getSigned() {
        return signed_;
      }
      /**
       * <code>optional bool signed = 10;</code>
       *
       * <pre>
       *
       * Indicates whether values in the designated column are signed numbers.
       * </pre>
       */
      public Builder setSigned(boolean value) {
        bitField0_ |= 0x00000200;
        signed_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool signed = 10;</code>
       *
       * <pre>
       *
       * Indicates whether values in the designated column are signed numbers.
       * </pre>
       */
      public Builder clearSigned() {
        bitField0_ = (bitField0_ & ~0x00000200);
        signed_ = false;
        onChanged();
        return this;
      }

      // optional int32 display_size = 11;
      private int displaySize_ ;
      /**
       * <code>optional int32 display_size = 11;</code>
       *
       * <pre>
       *
       * Maximum number of characters required to display data from the column.
       * </pre>
       */
      public boolean hasDisplaySize() {
        return ((bitField0_ & 0x00000400) == 0x00000400);
      }
      /**
       * <code>optional int32 display_size = 11;</code>
       *
       * <pre>
       *
       * Maximum number of characters required to display data from the column.
       * </pre>
       */
      public int getDisplaySize() {
        return displaySize_;
      }
      /**
       * <code>optional int32 display_size = 11;</code>
       *
       * <pre>
       *
       * Maximum number of characters required to display data from the column.
       * </pre>
       */
      public Builder setDisplaySize(int value) {
        bitField0_ |= 0x00000400;
        displaySize_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 display_size = 11;</code>
       *
       * <pre>
       *
       * Maximum number of characters required to display data from the column.
       * </pre>
       */
      public Builder clearDisplaySize() {
        bitField0_ = (bitField0_ & ~0x00000400);
        displaySize_ = 0;
        onChanged();
        return this;
      }

      // optional bool is_aliased = 12;
      private boolean isAliased_ ;
      /**
       * <code>optional bool is_aliased = 12;</code>
       *
       * <pre>
       *
       * Is the column an aliased column. Initial implementation defaults to
       * true as we derive schema from LIMIT 0 query and not the query plan.
       * </pre>
       */
      public boolean hasIsAliased() {
        return ((bitField0_ & 0x00000800) == 0x00000800);
      }
      /**
       * <code>optional bool is_aliased = 12;</code>
       *
       * <pre>
       *
       * Is the column an aliased column. Initial implementation defaults to
       * true as we derive schema from LIMIT 0 query and not the query plan.
       * </pre>
       */
      public boolean getIsAliased() {
        return isAliased_;
      }
      /**
       * <code>optional bool is_aliased = 12;</code>
       *
       * <pre>
       *
       * Is the column an aliased column. Initial implementation defaults to
       * true as we derive schema from LIMIT 0 query and not the query plan.
       * </pre>
       */
      public Builder setIsAliased(boolean value) {
        bitField0_ |= 0x00000800;
        isAliased_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool is_aliased = 12;</code>
       *
       * <pre>
       *
       * Is the column an aliased column. Initial implementation defaults to
       * true as we derive schema from LIMIT 0 query and not the query plan.
       * </pre>
       */
      public Builder clearIsAliased() {
        bitField0_ = (bitField0_ & ~0x00000800);
        isAliased_ = false;
        onChanged();
        return this;
      }

      // optional .exec.user.ColumnSearchability searchability = 13;
      private org.apache.drill.exec.proto.UserProtos.ColumnSearchability searchability_ = org.apache.drill.exec.proto.UserProtos.ColumnSearchability.UNKNOWN_SEARCHABILITY;
      /**
       * <code>optional .exec.user.ColumnSearchability searchability = 13;</code>
       */
      public boolean hasSearchability() {
        return ((bitField0_ & 0x00001000) == 0x00001000);
      }
      /**
       * <code>optional .exec.user.ColumnSearchability searchability = 13;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.ColumnSearchability getSearchability() {
        return searchability_;
      }
      /**
       * <code>optional .exec.user.ColumnSearchability searchability = 13;</code>
       */
      public Builder setSearchability(org.apache.drill.exec.proto.UserProtos.ColumnSearchability value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00001000;
        searchability_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.user.ColumnSearchability searchability = 13;</code>
       */
      public Builder clearSearchability() {
        bitField0_ = (bitField0_ & ~0x00001000);
        searchability_ = org.apache.drill.exec.proto.UserProtos.ColumnSearchability.UNKNOWN_SEARCHABILITY;
        onChanged();
        return this;
      }

      // optional .exec.user.ColumnUpdatability updatability = 14;
      private org.apache.drill.exec.proto.UserProtos.ColumnUpdatability updatability_ = org.apache.drill.exec.proto.UserProtos.ColumnUpdatability.UNKNOWN_UPDATABILITY;
      /**
       * <code>optional .exec.user.ColumnUpdatability updatability = 14;</code>
       *
       * <pre>
       *
       * Defaults to READ_ONLY
       * </pre>
       */
      public boolean hasUpdatability() {
        return ((bitField0_ & 0x00002000) == 0x00002000);
      }
      /**
       * <code>optional .exec.user.ColumnUpdatability updatability = 14;</code>
       *
       * <pre>
       *
       * Defaults to READ_ONLY
       * </pre>
       */
      public org.apache.drill.exec.proto.UserProtos.ColumnUpdatability getUpdatability() {
        return updatability_;
      }
      /**
       * <code>optional .exec.user.ColumnUpdatability updatability = 14;</code>
       *
       * <pre>
       *
       * Defaults to READ_ONLY
       * </pre>
       */
      public Builder setUpdatability(org.apache.drill.exec.proto.UserProtos.ColumnUpdatability value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00002000;
        updatability_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.user.ColumnUpdatability updatability = 14;</code>
       *
       * <pre>
       *
       * Defaults to READ_ONLY
       * </pre>
       */
      public Builder clearUpdatability() {
        bitField0_ = (bitField0_ & ~0x00002000);
        updatability_ = org.apache.drill.exec.proto.UserProtos.ColumnUpdatability.UNKNOWN_UPDATABILITY;
        onChanged();
        return this;
      }

      // optional bool auto_increment = 15;
      private boolean autoIncrement_ ;
      /**
       * <code>optional bool auto_increment = 15;</code>
       *
       * <pre>
       *
       * whether the designated column is automatically incremented.
       * </pre>
       */
      public boolean hasAutoIncrement() {
        return ((bitField0_ & 0x00004000) == 0x00004000);
      }
      /**
       * <code>optional bool auto_increment = 15;</code>
       *
       * <pre>
       *
       * whether the designated column is automatically incremented.
       * </pre>
       */
      public boolean getAutoIncrement() {
        return autoIncrement_;
      }
      /**
       * <code>optional bool auto_increment = 15;</code>
       *
       * <pre>
       *
       * whether the designated column is automatically incremented.
       * </pre>
       */
      public Builder setAutoIncrement(boolean value) {
        bitField0_ |= 0x00004000;
        autoIncrement_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool auto_increment = 15;</code>
       *
       * <pre>
       *
       * whether the designated column is automatically incremented.
       * </pre>
       */
      public Builder clearAutoIncrement() {
        bitField0_ = (bitField0_ & ~0x00004000);
        autoIncrement_ = false;
        onChanged();
        return this;
      }

      // optional bool case_sensitivity = 16;
      private boolean caseSensitivity_ ;
      /**
       * <code>optional bool case_sensitivity = 16;</code>
       *
       * <pre>
       *
       * Whether column's case matters for collations and comparisons. Defaults to true.
       * </pre>
       */
      public boolean hasCaseSensitivity() {
        return ((bitField0_ & 0x00008000) == 0x00008000);
      }
      /**
       * <code>optional bool case_sensitivity = 16;</code>
       *
       * <pre>
       *
       * Whether column's case matters for collations and comparisons. Defaults to true.
       * </pre>
       */
      public boolean getCaseSensitivity() {
        return caseSensitivity_;
      }
      /**
       * <code>optional bool case_sensitivity = 16;</code>
       *
       * <pre>
       *
       * Whether column's case matters for collations and comparisons. Defaults to true.
       * </pre>
       */
      public Builder setCaseSensitivity(boolean value) {
        bitField0_ |= 0x00008000;
        caseSensitivity_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool case_sensitivity = 16;</code>
       *
       * <pre>
       *
       * Whether column's case matters for collations and comparisons. Defaults to true.
       * </pre>
       */
      public Builder clearCaseSensitivity() {
        bitField0_ = (bitField0_ & ~0x00008000);
        caseSensitivity_ = false;
        onChanged();
        return this;
      }

      // optional bool sortable = 17;
      private boolean sortable_ ;
      /**
       * <code>optional bool sortable = 17;</code>
       *
       * <pre>
       *
       * whether the column can be used in ORDER BY clause
       * </pre>
       */
      public boolean hasSortable() {
        return ((bitField0_ & 0x00010000) == 0x00010000);
      }
      /**
       * <code>optional bool sortable = 17;</code>
       *
       * <pre>
       *
       * whether the column can be used in ORDER BY clause
       * </pre>
       */
      public boolean getSortable() {
        return sortable_;
      }
      /**
       * <code>optional bool sortable = 17;</code>
       *
       * <pre>
       *
       * whether the column can be used in ORDER BY clause
       * </pre>
       */
      public Builder setSortable(boolean value) {
        bitField0_ |= 0x00010000;
        sortable_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool sortable = 17;</code>
       *
       * <pre>
       *
       * whether the column can be used in ORDER BY clause
       * </pre>
       */
      public Builder clearSortable() {
        bitField0_ = (bitField0_ & ~0x00010000);
        sortable_ = false;
        onChanged();
        return this;
      }

      // optional string class_name = 18;
      private java.lang.Object className_ = "";
      /**
       * <code>optional string class_name = 18;</code>
       *
       * <pre>
       *
       * A fully-qualified name of the Java class whose instances are created
       * if the method ResultSet.getObject is called to retrieve
       * a value from the column. Applicable only to JDBC clients.
       * </pre>
       */
      public boolean hasClassName() {
        return ((bitField0_ & 0x00020000) == 0x00020000);
      }
      /**
       * <code>optional string class_name = 18;</code>
       *
       * <pre>
       *
       * A fully-qualified name of the Java class whose instances are created
       * if the method ResultSet.getObject is called to retrieve
       * a value from the column. Applicable only to JDBC clients.
       * </pre>
       */
      public java.lang.String getClassName() {
        java.lang.Object ref = className_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          className_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string class_name = 18;</code>
       *
       * <pre>
       *
       * A fully-qualified name of the Java class whose instances are created
       * if the method ResultSet.getObject is called to retrieve
       * a value from the column. Applicable only to JDBC clients.
       * </pre>
       */
      public com.google.protobuf.ByteString
          getClassNameBytes() {
        java.lang.Object ref = className_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          className_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string class_name = 18;</code>
       *
       * <pre>
       *
       * A fully-qualified name of the Java class whose instances are created
       * if the method ResultSet.getObject is called to retrieve
       * a value from the column. Applicable only to JDBC clients.
       * </pre>
       */
      public Builder setClassName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00020000;
        className_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string class_name = 18;</code>
       *
       * <pre>
       *
       * A fully-qualified name of the Java class whose instances are created
       * if the method ResultSet.getObject is called to retrieve
       * a value from the column. Applicable only to JDBC clients.
       * </pre>
       */
      public Builder clearClassName() {
        bitField0_ = (bitField0_ & ~0x00020000);
        className_ = getDefaultInstance().getClassName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string class_name = 18;</code>
       *
       * <pre>
       *
       * A fully-qualified name of the Java class whose instances are created
       * if the method ResultSet.getObject is called to retrieve
       * a value from the column. Applicable only to JDBC clients.
       * </pre>
       */
      public Builder setClassNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00020000;
        className_ = value;
        onChanged();
        return this;
      }

      // optional bool is_currency = 20;
      private boolean isCurrency_ ;
      /**
       * <code>optional bool is_currency = 20;</code>
       *
       * <pre>
       *
       * Is the data type a currency type? For JDBC only.
       * </pre>
       */
      public boolean hasIsCurrency() {
        return ((bitField0_ & 0x00040000) == 0x00040000);
      }
      /**
       * <code>optional bool is_currency = 20;</code>
       *
       * <pre>
       *
       * Is the data type a currency type? For JDBC only.
       * </pre>
       */
      public boolean getIsCurrency() {
        return isCurrency_;
      }
      /**
       * <code>optional bool is_currency = 20;</code>
       *
       * <pre>
       *
       * Is the data type a currency type? For JDBC only.
       * </pre>
       */
      public Builder setIsCurrency(boolean value) {
        bitField0_ |= 0x00040000;
        isCurrency_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool is_currency = 20;</code>
       *
       * <pre>
       *
       * Is the data type a currency type? For JDBC only.
       * </pre>
       */
      public Builder clearIsCurrency() {
        bitField0_ = (bitField0_ & ~0x00040000);
        isCurrency_ = false;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.ResultColumnMetadata)
    }

    static {
      defaultInstance = new ResultColumnMetadata(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.ResultColumnMetadata)
  }

  public interface PreparedStatementHandleOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional bytes server_info = 1;
    /**
     * <code>optional bytes server_info = 1;</code>
     */
    boolean hasServerInfo();
    /**
     * <code>optional bytes server_info = 1;</code>
     */
    com.google.protobuf.ByteString getServerInfo();
  }
  /**
   * Protobuf type {@code exec.user.PreparedStatementHandle}
   *
   * <pre>
   *
   * Server state of prepared statement. Contents are opaque to
   * client. Client just need to submit this object in RunQuery to
   * the prepared statement.
   * </pre>
   */
  public static final class PreparedStatementHandle extends
      com.google.protobuf.GeneratedMessage
      implements PreparedStatementHandleOrBuilder {
    // Use PreparedStatementHandle.newBuilder() to construct.
    private PreparedStatementHandle(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private PreparedStatementHandle(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final PreparedStatementHandle defaultInstance;
    public static PreparedStatementHandle getDefaultInstance() {
      return defaultInstance;
    }

    public PreparedStatementHandle getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private PreparedStatementHandle(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              serverInfo_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_PreparedStatementHandle_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_PreparedStatementHandle_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle.class, org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle.Builder.class);
    }

    public static com.google.protobuf.Parser<PreparedStatementHandle> PARSER =
        new com.google.protobuf.AbstractParser<PreparedStatementHandle>() {
      public PreparedStatementHandle parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new PreparedStatementHandle(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<PreparedStatementHandle> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional bytes server_info = 1;
    public static final int SERVER_INFO_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString serverInfo_;
    /**
     * <code>optional bytes server_info = 1;</code>
     */
    public boolean hasServerInfo() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional bytes server_info = 1;</code>
     */
    public com.google.protobuf.ByteString getServerInfo() {
      return serverInfo_;
    }

    private void initFields() {
      serverInfo_ = com.google.protobuf.ByteString.EMPTY;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, serverInfo_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, serverInfo_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.PreparedStatementHandle}
     *
     * <pre>
     *
     * Server state of prepared statement. Contents are opaque to
     * client. Client just need to submit this object in RunQuery to
     * the prepared statement.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.PreparedStatementHandleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_PreparedStatementHandle_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_PreparedStatementHandle_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle.class, org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        serverInfo_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_PreparedStatementHandle_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle build() {
        org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle buildPartial() {
        org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle result = new org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.serverInfo_ = serverInfo_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle other) {
        if (other == org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle.getDefaultInstance()) return this;
        if (other.hasServerInfo()) {
          setServerInfo(other.getServerInfo());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional bytes server_info = 1;
      private com.google.protobuf.ByteString serverInfo_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>optional bytes server_info = 1;</code>
       */
      public boolean hasServerInfo() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional bytes server_info = 1;</code>
       */
      public com.google.protobuf.ByteString getServerInfo() {
        return serverInfo_;
      }
      /**
       * <code>optional bytes server_info = 1;</code>
       */
      public Builder setServerInfo(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        serverInfo_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes server_info = 1;</code>
       */
      public Builder clearServerInfo() {
        bitField0_ = (bitField0_ & ~0x00000001);
        serverInfo_ = getDefaultInstance().getServerInfo();
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.PreparedStatementHandle)
    }

    static {
      defaultInstance = new PreparedStatementHandle(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.PreparedStatementHandle)
  }

  public interface PreparedStatementOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // repeated .exec.user.ResultColumnMetadata columns = 1;
    /**
     * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
     */
    java.util.List<org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata> 
        getColumnsList();
    /**
     * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata getColumns(int index);
    /**
     * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
     */
    int getColumnsCount();
    /**
     * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
     */
    java.util.List<? extends org.apache.drill.exec.proto.UserProtos.ResultColumnMetadataOrBuilder> 
        getColumnsOrBuilderList();
    /**
     * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.ResultColumnMetadataOrBuilder getColumnsOrBuilder(
        int index);

    // optional .exec.user.PreparedStatementHandle server_handle = 2;
    /**
     * <code>optional .exec.user.PreparedStatementHandle server_handle = 2;</code>
     *
     * <pre>
     *
     * In order to execute the prepared statement,
     * clients need to submit this object in RunQuery message.
     * </pre>
     */
    boolean hasServerHandle();
    /**
     * <code>optional .exec.user.PreparedStatementHandle server_handle = 2;</code>
     *
     * <pre>
     *
     * In order to execute the prepared statement,
     * clients need to submit this object in RunQuery message.
     * </pre>
     */
    org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle getServerHandle();
    /**
     * <code>optional .exec.user.PreparedStatementHandle server_handle = 2;</code>
     *
     * <pre>
     *
     * In order to execute the prepared statement,
     * clients need to submit this object in RunQuery message.
     * </pre>
     */
    org.apache.drill.exec.proto.UserProtos.PreparedStatementHandleOrBuilder getServerHandleOrBuilder();
  }
  /**
   * Protobuf type {@code exec.user.PreparedStatement}
   *
   * <pre>
   *
   * Prepared statement. It contains the query metadata and handle to prepared
   * statement state on server.
   * </pre>
   */
  public static final class PreparedStatement extends
      com.google.protobuf.GeneratedMessage
      implements PreparedStatementOrBuilder {
    // Use PreparedStatement.newBuilder() to construct.
    private PreparedStatement(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private PreparedStatement(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final PreparedStatement defaultInstance;
    public static PreparedStatement getDefaultInstance() {
      return defaultInstance;
    }

    public PreparedStatement getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private PreparedStatement(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                columns_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata>();
                mutable_bitField0_ |= 0x00000001;
              }
              columns_.add(input.readMessage(org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata.PARSER, extensionRegistry));
              break;
            }
            case 18: {
              org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = serverHandle_.toBuilder();
              }
              serverHandle_ = input.readMessage(org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(serverHandle_);
                serverHandle_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          columns_ = java.util.Collections.unmodifiableList(columns_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_PreparedStatement_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_PreparedStatement_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.PreparedStatement.class, org.apache.drill.exec.proto.UserProtos.PreparedStatement.Builder.class);
    }

    public static com.google.protobuf.Parser<PreparedStatement> PARSER =
        new com.google.protobuf.AbstractParser<PreparedStatement>() {
      public PreparedStatement parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new PreparedStatement(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<PreparedStatement> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // repeated .exec.user.ResultColumnMetadata columns = 1;
    public static final int COLUMNS_FIELD_NUMBER = 1;
    private java.util.List<org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata> columns_;
    /**
     * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
     */
    public java.util.List<org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata> getColumnsList() {
      return columns_;
    }
    /**
     * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
     */
    public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.ResultColumnMetadataOrBuilder> 
        getColumnsOrBuilderList() {
      return columns_;
    }
    /**
     * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
     */
    public int getColumnsCount() {
      return columns_.size();
    }
    /**
     * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata getColumns(int index) {
      return columns_.get(index);
    }
    /**
     * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.ResultColumnMetadataOrBuilder getColumnsOrBuilder(
        int index) {
      return columns_.get(index);
    }

    // optional .exec.user.PreparedStatementHandle server_handle = 2;
    public static final int SERVER_HANDLE_FIELD_NUMBER = 2;
    private org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle serverHandle_;
    /**
     * <code>optional .exec.user.PreparedStatementHandle server_handle = 2;</code>
     *
     * <pre>
     *
     * In order to execute the prepared statement,
     * clients need to submit this object in RunQuery message.
     * </pre>
     */
    public boolean hasServerHandle() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.user.PreparedStatementHandle server_handle = 2;</code>
     *
     * <pre>
     *
     * In order to execute the prepared statement,
     * clients need to submit this object in RunQuery message.
     * </pre>
     */
    public org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle getServerHandle() {
      return serverHandle_;
    }
    /**
     * <code>optional .exec.user.PreparedStatementHandle server_handle = 2;</code>
     *
     * <pre>
     *
     * In order to execute the prepared statement,
     * clients need to submit this object in RunQuery message.
     * </pre>
     */
    public org.apache.drill.exec.proto.UserProtos.PreparedStatementHandleOrBuilder getServerHandleOrBuilder() {
      return serverHandle_;
    }

    private void initFields() {
      columns_ = java.util.Collections.emptyList();
      serverHandle_ = org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < columns_.size(); i++) {
        output.writeMessage(1, columns_.get(i));
      }
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(2, serverHandle_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < columns_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, columns_.get(i));
      }
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, serverHandle_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.PreparedStatement parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatement parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatement parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatement parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatement parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatement parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatement parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatement parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatement parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.PreparedStatement parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.PreparedStatement prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.PreparedStatement}
     *
     * <pre>
     *
     * Prepared statement. It contains the query metadata and handle to prepared
     * statement state on server.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.PreparedStatementOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_PreparedStatement_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_PreparedStatement_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.PreparedStatement.class, org.apache.drill.exec.proto.UserProtos.PreparedStatement.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.PreparedStatement.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getColumnsFieldBuilder();
          getServerHandleFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (columnsBuilder_ == null) {
          columns_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          columnsBuilder_.clear();
        }
        if (serverHandleBuilder_ == null) {
          serverHandle_ = org.apache.drill.exec.proto.UserProtos.PreparedStatementHandle.getDefaultInstance();
        } else {
          serverHandleBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_PreparedStatement_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.PreparedStatement getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.PreparedStatement.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.PreparedStatement build() {
        org.apache.drill.exec.proto.UserProtos.PreparedStatement result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.PreparedStatement buildPartial() {
        org.apache.drill.exec.proto.UserProtos.PreparedStatement result = new org.apache.drill.exec.proto.UserProtos.PreparedStatement(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (columnsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            columns_ = java.util.Collections.unmodifiableList(columns_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.columns_ = columns_;
        } else {
          result.columns_ = columnsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000001;
        }
        if (serverHandleBuilder_ == null) {
          result.serverHandle_ = serverHandle_;
        } else {
          result.serverHandle_ = serverHandleBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.PreparedStatement) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.PreparedStatement)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.PreparedStatement other) {
        if (other == org.apache.drill.exec.proto.UserProtos.PreparedStatement.getDefaultInstance()) return this;
        if (columnsBuilder_ == null) {
          if (!other.columns_.isEmpty()) {
            if (columns_.isEmpty()) {
              columns_ = other.columns_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureColumnsIsMutable();
              columns_.addAll(other.columns_);
            }
            onChanged();
          }
        } else {
          if (!other.columns_.isEmpty()) {
            if (columnsBuilder_.isEmpty()) {
              columnsBuilder_.dispose();
              columnsBuilder_ = null;
              columns_ = other.columns_;
              bitField0_ = (bitField0_ & ~0x00000001);
              columnsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getColumnsFieldBuilder() : null;
            } else {
              columnsBuilder_.addAllMessages(other.columns_);
            }
          }
        }
        if (other.hasServerHandle()) {
          mergeServerHandle(other.getServerHandle());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.PreparedStatement parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.PreparedStatement) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // repeated .exec.user.ResultColumnMetadata columns = 1;
      private java.util.List<org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata> columns_ =
        java.util.Collections.emptyList();
      private void ensureColumnsIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          columns_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata>(columns_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata, org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata.Builder, org.apache.drill.exec.proto.UserProtos.ResultColumnMetadataOrBuilder> columnsBuilder_;

      /**
       * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata> getColumnsList() {
        if (columnsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(columns_);
        } else {
          return columnsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
       */
      public int getColumnsCount() {
        if (columnsBuilder_ == null) {
          return columns_.size();
        } else {
          return columnsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata getColumns(int index) {
        if (columnsBuilder_ == null) {
          return columns_.get(index);
        } else {
          return columnsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
       */
      public Builder setColumns(
          int index, org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.set(index, value);
          onChanged();
        } else {
          columnsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
       */
      public Builder setColumns(
          int index, org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.set(index, builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
       */
      public Builder addColumns(org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.add(value);
          onChanged();
        } else {
          columnsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
       */
      public Builder addColumns(
          int index, org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.add(index, value);
          onChanged();
        } else {
          columnsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
       */
      public Builder addColumns(
          org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.add(builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
       */
      public Builder addColumns(
          int index, org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.add(index, builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
       */
      public Builder addAllColumns(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.UserProtos.ResultColumnMetadata> values) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          super.addAll(values, columns_);
          onChanged();
        } else {
          columnsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ResultColumnMetadata columns = 1;</code>
       */
      public Builder clearColumns() {
        if (columnsBuilder_ == null) {
          columns_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          columnsBuilder_.clear();
        }
        return thi