/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by http://code.google.com/p/protostuff/ ... DO NOT EDIT!
// Generated from protobuf

package org.apache.drill.exec.proto.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

import com.dyuproject.protostuff.ByteString;
import com.dyuproject.protostuff.GraphIOUtil;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;

public final class QueryProfile implements Externalizable, Message<QueryProfile>, Schema<QueryProfile>
{

    public static Schema<QueryProfile> getSchema()
    {
        return DEFAULT_INSTANCE;
    }

    public static QueryProfile getDefaultInstance()
    {
        return DEFAULT_INSTANCE;
    }

    static final QueryProfile DEFAULT_INSTANCE = new QueryProfile();

    static final String DEFAULT_USER = ByteString.stringDefaultValue("-");
    static final String DEFAULT_QUEUE_NAME = ByteString.stringDefaultValue("-");
    
    private QueryId id;
    private QueryType type;
    private long start;
    private long end;
    private String query;
    private String plan;
    private DrillbitEndpoint foreman;
    private QueryResult.QueryState state;
    private int totalFragments;
    private int finishedFragments;
    private List<MajorFragmentProfile> fragmentProfile;
    private String user = DEFAULT_USER;
    private String error;
    private String verboseError;
    private String errorId;
    private String errorNode;
    private String optionsJson;
    private long planEnd;
    private long queueWaitEnd;
    private double totalCost;
    private String queueName = DEFAULT_QUEUE_NAME;

    public QueryProfile()
    {
        
    }

    // getters and setters

    // id

    public QueryId getId()
    {
        return id;
    }

    public QueryProfile setId(QueryId id)
    {
        this.id = id;
        return this;
    }

    // type

    public QueryType getType()
    {
        return type == null ? QueryType.SQL : type;
    }

    public QueryProfile setType(QueryType type)
    {
        this.type = type;
        return this;
    }

    // start

    public long getStart()
    {
        return start;
    }

    public QueryProfile setStart(long start)
    {
        this.start = start;
        return this;
    }

    // end

    public long getEnd()
    {
        return end;
    }

    public QueryProfile setEnd(long end)
    {
        this.end = end;
        return this;
    }

    // query

    public String getQuery()
    {
        return query;
    }

    public QueryProfile setQuery(String query)
    {
        this.query = query;
        return this;
    }

    // plan

    public String getPlan()
    {
        return plan;
    }

    public QueryProfile setPlan(String plan)
    {
        this.plan = plan;
        return this;
    }

    // foreman

    public DrillbitEndpoint getForeman()
    {
        return foreman;
    }

    public QueryProfile setForeman(DrillbitEndpoint foreman)
    {
        this.foreman = foreman;
        return this;
    }

    // state

    public QueryResult.QueryState getState()
    {
        return state == null ? QueryResult.QueryState.STARTING : state;
    }

    public QueryProfile setState(QueryResult.QueryState state)
    {
        this.state = state;
        return this;
    }

    // totalFragments

    public int getTotalFragments()
    {
        return totalFragments;
    }

    public QueryProfile setTotalFragments(int totalFragments)
    {
        this.totalFragments = totalFragments;
        return this;
    }

    // finishedFragments

    public int getFinishedFragments()
    {
        return finishedFragments;
    }

    public QueryProfile setFinishedFragments(int finishedFragments)
    {
        this.finishedFragments = finishedFragments;
        return this;
    }

    // fragmentProfile

    public List<MajorFragmentProfile> getFragmentProfileList()
    {
        return fragmentProfile;
    }

    public QueryProfile setFragmentProfileList(List<MajorFragmentProfile> fragmentProfile)
    {
        this.fragmentProfile = fragmentProfile;
        return this;
    }

    // user

    public String getUser()
    {
        return user;
    }

    public QueryProfile setUser(String user)
    {
        this.user = user;
        return this;
    }

    // error

    public String getError()
    {
        return error;
    }

    public QueryProfile setError(String error)
    {
        this.error = error;
        return this;
    }

    // verboseError

    public String getVerboseError()
    {
        return verboseError;
    }

    public QueryProfile setVerboseError(String verboseError)
    {
        this.verboseError = verboseError;
        return this;
    }

    // errorId

    public String getErrorId()
    {
        return errorId;
    }

    public QueryProfile setErrorId(String errorId)
    {
        this.errorId = errorId;
        return this;
    }

    // errorNode

    public String getErrorNode()
    {
        return errorNode;
    }

    public QueryProfile setErrorNode(String errorNode)
    {
        this.errorNode = errorNode;
        return this;
    }

    // optionsJson

    public String getOptionsJson()
    {
        return optionsJson;
    }

    public QueryProfile setOptionsJson(String optionsJson)
    {
        this.optionsJson = optionsJson;
        return this;
    }

    // planEnd

    public long getPlanEnd()
    {
        return planEnd;
    }

    public QueryProfile setPlanEnd(long planEnd)
    {
        this.planEnd = planEnd;
        return this;
    }

    // queueWaitEnd

    public long getQueueWaitEnd()
    {
        return queueWaitEnd;
    }

    public QueryProfile setQueueWaitEnd(long queueWaitEnd)
    {
        this.queueWaitEnd = queueWaitEnd;
        return this;
    }

    // totalCost

    public double getTotalCost()
    {
        return totalCost;
    }

    public QueryProfile setTotalCost(double totalCost)
    {
        this.totalCost = totalCost;
        return this;
    }

    // queueName

    public String getQueueName()
    {
        return queueName;
    }

    public QueryProfile setQueueName(String queueName)
    {
        this.queueName = queueName;
        return this;
    }

    // java serialization

    public void readExternal(ObjectInput in) throws IOException
    {
        GraphIOUtil.mergeDelimitedFrom(in, this, this);
    }

    public void writeExternal(ObjectOutput out) throws IOException
    {
        GraphIOUtil.writeDelimitedTo(out, this, this);
    }

    // message method

    public Schema<QueryProfile> cachedSchema()
    {
        return DEFAULT_INSTANCE;
    }

    // schema methods

    public QueryProfile newMessage()
    {
        return new QueryProfile();
    }

    public Class<QueryProfile> typeClass()
    {
        return QueryProfile.class;
    }

    public String messageName()
    {
        return QueryProfile.class.getSimpleName();
    }

    public String messageFullName()
    {
        return QueryProfile.class.getName();
    }

    public boolean isInitialized(QueryProfile message)
    {
        return true;
    }

    public void mergeFrom(Input input, QueryProfile message) throws IOException
    {
        for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
        {
            switch(number)
            {
                case 0:
                    return;
                case 1:
                    message.id = input.mergeObject(message.id, QueryId.getSchema());
                    break;

                case 2:
                    message.type = QueryType.valueOf(input.readEnum());
                    break;
                case 3:
                    message.start = input.readInt64();
                    break;
                case 4:
                    message.end = input.readInt64();
                    break;
                case 5:
                    message.query = input.readString();
                    break;
                case 6:
                    message.plan = input.readString();
                    break;
                case 7:
                    message.foreman = input.mergeObject(message.foreman, DrillbitEndpoint.getSchema());
                    break;

                case 8:
                    message.state = QueryResult.QueryState.valueOf(input.readEnum());
                    break;
                case 9:
                    message.totalFragments = input.readInt32();
                    break;
                case 10:
                    message.finishedFragments = input.readInt32();
                    break;
                case 11:
                    if(message.fragmentProfile == null)
                        message.fragmentProfile = new ArrayList<MajorFragmentProfile>();
                    message.fragmentProfile.add(input.mergeObject(null, MajorFragmentProfile.getSchema()));
                    break;

                case 12:
                    message.user = input.readString();
                    break;
                case 13:
                    message.error = input.readString();
                    break;
                case 14:
                    message.verboseError = input.readString();
                    break;
                case 15:
                    message.errorId = input.readString();
                    break;
                case 16:
                    message.errorNode = input.readString();
                    break;
                case 17:
                    message.optionsJson = input.readString();
                    break;
                case 18:
                    message.planEnd = input.readInt64();
                    break;
                case 19:
                    message.queueWaitEnd = input.readInt64();
                    break;
                case 20:
                    message.totalCost = input.readDouble();
                    break;
                case 21:
                    message.queueName = input.readString();
                    break;
                default:
                    input.handleUnknownField(number, this);
            }   
        }
    }


    public void writeTo(Output output, QueryProfile message) throws IOException
    {
        if(message.id != null)
             output.writeObject(1, message.id, QueryId.getSchema(), false);


        if(message.type != null)
             output.writeEnum(2, message.type.number, false);

        if(message.start != 0)
            output.writeInt64(3, message.start, false);

        if(message.end != 0)
            output.writeInt64(4, message.end, false);

        if(message.query != null)
            output.writeString(5, message.query, false);

        if(message.plan != null)
            output.writeString(6, message.plan, false);

        if(message.foreman != null)
             output.writeObject(7, message.foreman, DrillbitEndpoint.getSchema(), false);


        if(message.state != null)
             output.writeEnum(8, message.state.number, false);

        if(message.totalFragments != 0)
            output.writeInt32(9, message.totalFragments, false);

        if(message.finishedFragments != 0)
            output.writeInt32(10, message.finishedFragments, false);

        if(message.fragmentProfile != null)
        {
            for(MajorFragmentProfile fragmentProfile : message.fragmentProfile)
            {
                if(fragmentProfile != null)
                    output.writeObject(11, fragmentProfile, MajorFragmentProfile.getSchema(), true);
            }
        }


        if(message.user != null && message.user != DEFAULT_USER)
            output.writeString(12, message.user, false);

        if(message.error != null)
            output.writeString(13, message.error, false);

        if(message.verboseError != null)
            output.writeString(14, message.verboseError, false);

        if(message.errorId != null)
            output.writeString(15, message.errorId, false);

        if(message.errorNode != null)
            output.writeString(16, message.errorNode, false);

        if(message.optionsJson != null)
            output.writeString(17, message.optionsJson, false);

        if(message.planEnd != 0)
            output.writeInt64(18, message.planEnd, false);

        if(message.queueWaitEnd != 0)
            output.writeInt64(19, message.queueWaitEnd, false);

        if(message.totalCost != 0)
            output.writeDouble(20, message.totalCost, false);

        if(message.queueName != null && message.queueName != DEFAULT_QUEUE_NAME)
            output.writeString(21, message.queueName, false);
    }

    public String getFieldName(int number)
    {
        switch(number)
        {
            case 1: return "id";
            case 2: return "type";
            case 3: return "start";
            case 4: return "end";
            case 5: return "query";
            case 6: return "plan";
            case 7: return "foreman";
            case 8: return "state";
            case 9: return "totalFragments";
            case 10: return "finishedFragments";
            case 11: return "fragmentProfile";
            case 12: return "user";
            case 13: return "error";
            case 14: return "verboseError";
            case 15: return "errorId";
            case 16: return "errorNode";
            case 17: return "optionsJson";
            case 18: return "planEnd";
            case 19: return "queueWaitEnd";
            case 20: return "totalCost";
            case 21: return "queueName";
            default: return null;
        }
    }

    public int getFieldNumber(String name)
    {
        final Integer number = __fieldMap.get(name);
        return number == null ? 0 : number.intValue();
    }

    private static final java.util.HashMap<String,Integer> __fieldMap = new java.util.HashMap<String,Integer>();
    static
    {
        __fieldMap.put("id", 1);
        __fieldMap.put("type", 2);
        __fieldMap.put("start", 3);
        __fieldMap.put("end", 4);
        __fieldMap.put("query", 5);
        __fieldMap.put("plan", 6);
        __fieldMap.put("foreman", 7);
        __fieldMap.put("state", 8);
        __fieldMap.put("totalFragments", 9);
        __fieldMap.put("finishedFragments", 10);
        __fieldMap.put("fragmentProfile", 11);
        __fieldMap.put("user", 12);
        __fieldMap.put("error", 13);
        __fieldMap.put("verboseError", 14);
        __fieldMap.put("errorId", 15);
        __fieldMap.put("errorNode", 16);
        __fieldMap.put("optionsJson", 17);
        __fieldMap.put("planEnd", 18);
        __fieldMap.put("queueWaitEnd", 19);
        __fieldMap.put("totalCost", 20);
        __fieldMap.put("queueName", 21);
    }
    
}
