/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by http://code.google.com/p/protostuff/ ... DO NOT EDIT!
// Generated from protobuf

package org.apache.drill.exec.proto.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import com.dyuproject.protostuff.GraphIOUtil;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;

public final class FragmentHandle implements Externalizable, Message<FragmentHandle>, Schema<FragmentHandle>
{

    public static Schema<FragmentHandle> getSchema()
    {
        return DEFAULT_INSTANCE;
    }

    public static FragmentHandle getDefaultInstance()
    {
        return DEFAULT_INSTANCE;
    }

    static final FragmentHandle DEFAULT_INSTANCE = new FragmentHandle();

    
    private QueryId queryId;
    private int majorFragmentId;
    private int minorFragmentId;
    private QueryId parentQueryId;

    public FragmentHandle()
    {
        
    }

    // getters and setters

    // queryId

    public QueryId getQueryId()
    {
        return queryId;
    }

    public FragmentHandle setQueryId(QueryId queryId)
    {
        this.queryId = queryId;
        return this;
    }

    // majorFragmentId

    public int getMajorFragmentId()
    {
        return majorFragmentId;
    }

    public FragmentHandle setMajorFragmentId(int majorFragmentId)
    {
        this.majorFragmentId = majorFragmentId;
        return this;
    }

    // minorFragmentId

    public int getMinorFragmentId()
    {
        return minorFragmentId;
    }

    public FragmentHandle setMinorFragmentId(int minorFragmentId)
    {
        this.minorFragmentId = minorFragmentId;
        return this;
    }

    // parentQueryId

    public QueryId getParentQueryId()
    {
        return parentQueryId;
    }

    public FragmentHandle setParentQueryId(QueryId parentQueryId)
    {
        this.parentQueryId = parentQueryId;
        return this;
    }

    // java serialization

    public void readExternal(ObjectInput in) throws IOException
    {
        GraphIOUtil.mergeDelimitedFrom(in, this, this);
    }

    public void writeExternal(ObjectOutput out) throws IOException
    {
        GraphIOUtil.writeDelimitedTo(out, this, this);
    }

    // message method

    public Schema<FragmentHandle> cachedSchema()
    {
        return DEFAULT_INSTANCE;
    }

    // schema methods

    public FragmentHandle newMessage()
    {
        return new FragmentHandle();
    }

    public Class<FragmentHandle> typeClass()
    {
        return FragmentHandle.class;
    }

    public String messageName()
    {
        return FragmentHandle.class.getSimpleName();
    }

    public String messageFullName()
    {
        return FragmentHandle.class.getName();
    }

    public boolean isInitialized(FragmentHandle message)
    {
        return true;
    }

    public void mergeFrom(Input input, FragmentHandle message) throws IOException
    {
        for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
        {
            switch(number)
            {
                case 0:
                    return;
                case 1:
                    message.queryId = input.mergeObject(message.queryId, QueryId.getSchema());
                    break;

                case 2:
                    message.majorFragmentId = input.readInt32();
                    break;
                case 3:
                    message.minorFragmentId = input.readInt32();
                    break;
                case 4:
                    message.parentQueryId = input.mergeObject(message.parentQueryId, QueryId.getSchema());
                    break;

                default:
                    input.handleUnknownField(number, this);
            }   
        }
    }


    public void writeTo(Output output, FragmentHandle message) throws IOException
    {
        if(message.queryId != null)
             output.writeObject(1, message.queryId, QueryId.getSchema(), false);


        if(message.majorFragmentId != 0)
            output.writeInt32(2, message.majorFragmentId, false);

        if(message.minorFragmentId != 0)
            output.writeInt32(3, message.minorFragmentId, false);

        if(message.parentQueryId != null)
             output.writeObject(4, message.parentQueryId, QueryId.getSchema(), false);

    }

    public String getFieldName(int number)
    {
        switch(number)
        {
            case 1: return "queryId";
            case 2: return "majorFragmentId";
            case 3: return "minorFragmentId";
            case 4: return "parentQueryId";
            default: return null;
        }
    }

    public int getFieldNumber(String name)
    {
        final Integer number = __fieldMap.get(name);
        return number == null ? 0 : number.intValue();
    }

    private static final java.util.HashMap<String,Integer> __fieldMap = new java.util.HashMap<String,Integer>();
    static
    {
        __fieldMap.put("queryId", 1);
        __fieldMap.put("majorFragmentId", 2);
        __fieldMap.put("minorFragmentId", 3);
        __fieldMap.put("parentQueryId", 4);
    }
    
}
