/*
 * Decompiled with CFR 0.152.
 */
package com.drill.udf.overloading;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.VarCharHolder;

@FunctionTemplate(name="abs", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class Abs
implements DrillSimpleFunc {
    @Param
    VarCharHolder input1;
    @Param
    VarCharHolder input2;
    @Output
    VarCharHolder out;
    @Inject
    DrillBuf buffer;

    public void setup() {
    }

    public void eval() {
        String inputString1 = StringFunctionHelpers.toStringFromUTF8((int)this.input1.start, (int)this.input1.end, (DrillBuf)this.input1.buffer);
        String inputString2 = StringFunctionHelpers.toStringFromUTF8((int)this.input2.start, (int)this.input2.end, (DrillBuf)this.input2.buffer);
        String outputValue = String.format("ABS was overloaded. Input: %s, %s", inputString1, inputString2);
        this.out.buffer = this.buffer;
        this.out.start = 0;
        this.out.end = outputValue.getBytes().length;
        this.buffer.setBytes(0, outputValue.getBytes());
    }
}

