/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by http://code.google.com/p/protostuff/ ... DO NOT EDIT!
// Generated from protobuf

package org.apache.drill.exec.proto.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import com.dyuproject.protostuff.GraphIOUtil;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;

public final class ColumnMetadata implements Externalizable, Message<ColumnMetadata>, Schema<ColumnMetadata>
{

    public static Schema<ColumnMetadata> getSchema()
    {
        return DEFAULT_INSTANCE;
    }

    public static ColumnMetadata getDefaultInstance()
    {
        return DEFAULT_INSTANCE;
    }

    static final ColumnMetadata DEFAULT_INSTANCE = new ColumnMetadata();

    
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String columnName;
    private int ordinalPosition;
    private String defaultValue;
    private Boolean isNullable;
    private String dataType;
    private int charMaxLength;
    private int charOctetLength;
    private int numericPrecision;
    private int numericPrecisionRadix;
    private int numericScale;
    private int dateTimePrecision;
    private String intervalType;
    private int intervalPrecision;
    private int columnSize;

    public ColumnMetadata()
    {
        
    }

    // getters and setters

    // catalogName

    public String getCatalogName()
    {
        return catalogName;
    }

    public ColumnMetadata setCatalogName(String catalogName)
    {
        this.catalogName = catalogName;
        return this;
    }

    // schemaName

    public String getSchemaName()
    {
        return schemaName;
    }

    public ColumnMetadata setSchemaName(String schemaName)
    {
        this.schemaName = schemaName;
        return this;
    }

    // tableName

    public String getTableName()
    {
        return tableName;
    }

    public ColumnMetadata setTableName(String tableName)
    {
        this.tableName = tableName;
        return this;
    }

    // columnName

    public String getColumnName()
    {
        return columnName;
    }

    public ColumnMetadata setColumnName(String columnName)
    {
        this.columnName = columnName;
        return this;
    }

    // ordinalPosition

    public int getOrdinalPosition()
    {
        return ordinalPosition;
    }

    public ColumnMetadata setOrdinalPosition(int ordinalPosition)
    {
        this.ordinalPosition = ordinalPosition;
        return this;
    }

    // defaultValue

    public String getDefaultValue()
    {
        return defaultValue;
    }

    public ColumnMetadata setDefaultValue(String defaultValue)
    {
        this.defaultValue = defaultValue;
        return this;
    }

    // isNullable

    public Boolean getIsNullable()
    {
        return isNullable;
    }

    public ColumnMetadata setIsNullable(Boolean isNullable)
    {
        this.isNullable = isNullable;
        return this;
    }

    // dataType

    public String getDataType()
    {
        return dataType;
    }

    public ColumnMetadata setDataType(String dataType)
    {
        this.dataType = dataType;
        return this;
    }

    // charMaxLength

    public int getCharMaxLength()
    {
        return charMaxLength;
    }

    public ColumnMetadata setCharMaxLength(int charMaxLength)
    {
        this.charMaxLength = charMaxLength;
        return this;
    }

    // charOctetLength

    public int getCharOctetLength()
    {
        return charOctetLength;
    }

    public ColumnMetadata setCharOctetLength(int charOctetLength)
    {
        this.charOctetLength = charOctetLength;
        return this;
    }

    // numericPrecision

    public int getNumericPrecision()
    {
        return numericPrecision;
    }

    public ColumnMetadata setNumericPrecision(int numericPrecision)
    {
        this.numericPrecision = numericPrecision;
        return this;
    }

    // numericPrecisionRadix

    public int getNumericPrecisionRadix()
    {
        return numericPrecisionRadix;
    }

    public ColumnMetadata setNumericPrecisionRadix(int numericPrecisionRadix)
    {
        this.numericPrecisionRadix = numericPrecisionRadix;
        return this;
    }

    // numericScale

    public int getNumericScale()
    {
        return numericScale;
    }

    public ColumnMetadata setNumericScale(int numericScale)
    {
        this.numericScale = numericScale;
        return this;
    }

    // dateTimePrecision

    public int getDateTimePrecision()
    {
        return dateTimePrecision;
    }

    public ColumnMetadata setDateTimePrecision(int dateTimePrecision)
    {
        this.dateTimePrecision = dateTimePrecision;
        return this;
    }

    // intervalType

    public String getIntervalType()
    {
        return intervalType;
    }

    public ColumnMetadata setIntervalType(String intervalType)
    {
        this.intervalType = intervalType;
        return this;
    }

    // intervalPrecision

    public int getIntervalPrecision()
    {
        return intervalPrecision;
    }

    public ColumnMetadata setIntervalPrecision(int intervalPrecision)
    {
        this.intervalPrecision = intervalPrecision;
        return this;
    }

    // columnSize

    public int getColumnSize()
    {
        return columnSize;
    }

    public ColumnMetadata setColumnSize(int columnSize)
    {
        this.columnSize = columnSize;
        return this;
    }

    // java serialization

    public void readExternal(ObjectInput in) throws IOException
    {
        GraphIOUtil.mergeDelimitedFrom(in, this, this);
    }

    public void writeExternal(ObjectOutput out) throws IOException
    {
        GraphIOUtil.writeDelimitedTo(out, this, this);
    }

    // message method

    public Schema<ColumnMetadata> cachedSchema()
    {
        return DEFAULT_INSTANCE;
    }

    // schema methods

    public ColumnMetadata newMessage()
    {
        return new ColumnMetadata();
    }

    public Class<ColumnMetadata> typeClass()
    {
        return ColumnMetadata.class;
    }

    public String messageName()
    {
        return ColumnMetadata.class.getSimpleName();
    }

    public String messageFullName()
    {
        return ColumnMetadata.class.getName();
    }

    public boolean isInitialized(ColumnMetadata message)
    {
        return true;
    }

    public void mergeFrom(Input input, ColumnMetadata message) throws IOException
    {
        for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
        {
            switch(number)
            {
                case 0:
                    return;
                case 1:
                    message.catalogName = input.readString();
                    break;
                case 2:
                    message.schemaName = input.readString();
                    break;
                case 3:
                    message.tableName = input.readString();
                    break;
                case 4:
                    message.columnName = input.readString();
                    break;
                case 5:
                    message.ordinalPosition = input.readInt32();
                    break;
                case 6:
                    message.defaultValue = input.readString();
                    break;
                case 7:
                    message.isNullable = input.readBool();
                    break;
                case 8:
                    message.dataType = input.readString();
                    break;
                case 9:
                    message.charMaxLength = input.readInt32();
                    break;
                case 10:
                    message.charOctetLength = input.readInt32();
                    break;
                case 11:
                    message.numericPrecision = input.readInt32();
                    break;
                case 12:
                    message.numericPrecisionRadix = input.readInt32();
                    break;
                case 13:
                    message.numericScale = input.readInt32();
                    break;
                case 14:
                    message.dateTimePrecision = input.readInt32();
                    break;
                case 15:
                    message.intervalType = input.readString();
                    break;
                case 16:
                    message.intervalPrecision = input.readInt32();
                    break;
                case 17:
                    message.columnSize = input.readInt32();
                    break;
                default:
                    input.handleUnknownField(number, this);
            }   
        }
    }


    public void writeTo(Output output, ColumnMetadata message) throws IOException
    {
        if(message.catalogName != null)
            output.writeString(1, message.catalogName, false);

        if(message.schemaName != null)
            output.writeString(2, message.schemaName, false);

        if(message.tableName != null)
            output.writeString(3, message.tableName, false);

        if(message.columnName != null)
            output.writeString(4, message.columnName, false);

        if(message.ordinalPosition != 0)
            output.writeInt32(5, message.ordinalPosition, false);

        if(message.defaultValue != null)
            output.writeString(6, message.defaultValue, false);

        if(message.isNullable != null)
            output.writeBool(7, message.isNullable, false);

        if(message.dataType != null)
            output.writeString(8, message.dataType, false);

        if(message.charMaxLength != 0)
            output.writeInt32(9, message.charMaxLength, false);

        if(message.charOctetLength != 0)
            output.writeInt32(10, message.charOctetLength, false);

        if(message.numericPrecision != 0)
            output.writeInt32(11, message.numericPrecision, false);

        if(message.numericPrecisionRadix != 0)
            output.writeInt32(12, message.numericPrecisionRadix, false);

        if(message.numericScale != 0)
            output.writeInt32(13, message.numericScale, false);

        if(message.dateTimePrecision != 0)
            output.writeInt32(14, message.dateTimePrecision, false);

        if(message.intervalType != null)
            output.writeString(15, message.intervalType, false);

        if(message.intervalPrecision != 0)
            output.writeInt32(16, message.intervalPrecision, false);

        if(message.columnSize != 0)
            output.writeInt32(17, message.columnSize, false);
    }

    public String getFieldName(int number)
    {
        switch(number)
        {
            case 1: return "catalogName";
            case 2: return "schemaName";
            case 3: return "tableName";
            case 4: return "columnName";
            case 5: return "ordinalPosition";
            case 6: return "defaultValue";
            case 7: return "isNullable";
            case 8: return "dataType";
            case 9: return "charMaxLength";
            case 10: return "charOctetLength";
            case 11: return "numericPrecision";
            case 12: return "numericPrecisionRadix";
            case 13: return "numericScale";
            case 14: return "dateTimePrecision";
            case 15: return "intervalType";
            case 16: return "intervalPrecision";
            case 17: return "columnSize";
            default: return null;
        }
    }

    public int getFieldNumber(String name)
    {
        final Integer number = __fieldMap.get(name);
        return number == null ? 0 : number.intValue();
    }

    private static final java.util.HashMap<String,Integer> __fieldMap = new java.util.HashMap<String,Integer>();
    static
    {
        __fieldMap.put("catalogName", 1);
        __fieldMap.put("schemaName", 2);
        __fieldMap.put("tableName", 3);
        __fieldMap.put("columnName", 4);
        __fieldMap.put("ordinalPosition", 5);
        __fieldMap.put("defaultValue", 6);
        __fieldMap.put("isNullable", 7);
        __fieldMap.put("dataType", 8);
        __fieldMap.put("charMaxLength", 9);
        __fieldMap.put("charOctetLength", 10);
        __fieldMap.put("numericPrecision", 11);
        __fieldMap.put("numericPrecisionRadix", 12);
        __fieldMap.put("numericScale", 13);
        __fieldMap.put("dateTimePrecision", 14);
        __fieldMap.put("intervalType", 15);
        __fieldMap.put("intervalPrecision", 16);
        __fieldMap.put("columnSize", 17);
    }
    
}
