/*
 * Decompiled with CFR 0.152.
 */
package com.drill.udf;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.VarCharHolder;

@FunctionTemplate(name="lower", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CustomLowerFunction
implements DrillSimpleFunc {
    @Param
    VarCharHolder input;
    @Output
    VarCharHolder output;
    @Inject
    DrillBuf buffer;

    public void setup() {
    }

    public void eval() {
        String inputString = StringFunctionHelpers.toStringFromUTF8((int)this.input.start, (int)this.input.end, (DrillBuf)this.input.buffer);
        String outputValue = inputString.toLowerCase();
        this.output.buffer = this.buffer;
        this.output.start = 0;
        this.output.end = outputValue.getBytes().length;
        this.buffer.setBytes(0, outputValue.getBytes());
    }
}

