/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.extended;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.api.ldap.extras.extended.certGeneration.CertGenerationRequest;
import org.apache.directory.api.ldap.extras.extended.certGeneration.CertGenerationResponse;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.security.TlsKeyGenerator;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;

public class CertGenerationRequestHandler
implements ExtendedOperationHandler<CertGenerationRequest, CertGenerationResponse> {
    private static final Set<String> EXTENSION_OIDS;

    @Override
    public String getOid() {
        return "1.3.6.1.4.1.18060.0.1.8";
    }

    @Override
    public Set<String> getExtensionOids() {
        return EXTENSION_OIDS;
    }

    @Override
    public void handleExtendedOperation(LdapSession session, CertGenerationRequest req) throws Exception {
        Entry entry = session.getCoreSession().lookup(new Dn(new String[]{req.getTargetDN()}), new String[0]);
        if (entry != null) {
            TlsKeyGenerator.addKeyPair((Entry)((ClonedServerEntry)entry).getOriginalEntry(), (String)req.getIssuerDN(), (String)req.getSubjectDN(), (String)req.getKeyAlgorithm());
        }
    }

    @Override
    public void setLdapServer(LdapServer ldapServer) {
    }

    static {
        HashSet<String> set = new HashSet<String>(2);
        set.add("1.3.6.1.4.1.18060.0.1.8");
        set.add("1.3.6.1.4.1.18060.0.1.8");
        EXTENSION_OIDS = Collections.unmodifiableSet(set);
    }
}

