/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api.callback;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.util.Strings;
import org.apache.directory.ldap.client.api.SaslRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslCallbackHandler
implements CallbackHandler {
    private SaslRequest saslReq;
    private static final Logger LOG = LoggerFactory.getLogger(SaslCallbackHandler.class);

    public SaslCallbackHandler(SaslRequest saslReq) {
        this.saslReq = saslReq;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback cb : callbacks) {
            if (cb instanceof NameCallback) {
                NameCallback ncb = (NameCallback)cb;
                String name = this.saslReq.getUsername();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_04153_SENDING_NAME_IN_CALLBACK, (Object[])new Object[]{name}));
                }
                ncb.setName(name);
                continue;
            }
            if (cb instanceof PasswordCallback) {
                PasswordCallback pcb = (PasswordCallback)cb;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_04154_SENDING_CREDS_IN_CALLBACK, (Object[])new Object[0]));
                }
                pcb.setPassword(Strings.utf8ToString((byte[])this.saslReq.getCredentials()).toCharArray());
                continue;
            }
            if (cb instanceof RealmCallback) {
                RealmCallback rcb = (RealmCallback)cb;
                if (this.saslReq.getRealmName() != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg((I18n)I18n.MSG_04155_SENDING_USER_REALM_IN_CALLBACK, (Object[])new Object[]{this.saslReq.getRealmName()}));
                    }
                    rcb.setText(this.saslReq.getRealmName());
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_04156_SENDING_DEFAULT_REALM_IN_CALLBACK, (Object[])new Object[]{rcb.getDefaultText()}));
                }
                rcb.setText(rcb.getDefaultText());
                continue;
            }
            if (!(cb instanceof RealmChoiceCallback)) continue;
            RealmChoiceCallback rccb = (RealmChoiceCallback)cb;
            boolean foundRealmName = false;
            String[] realmNames = rccb.getChoices();
            for (int i = 0; i < realmNames.length; ++i) {
                String realmName = realmNames[i];
                if (!realmName.equals(this.saslReq.getRealmName())) continue;
                foundRealmName = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_04157_SENDING_USER_REALM_IN_CALLBACK, (Object[])new Object[]{realmName}));
                }
                rccb.setSelectedIndex(i);
                break;
            }
            if (foundRealmName) continue;
            throw new IOException(I18n.err((I18n)I18n.ERR_04171_CANNOT_PARSE_MATCHED_DN, (Object[])new Object[]{this.saslReq.getRealmName(), this.getRealmNamesAsString(realmNames)}));
        }
    }

    private String getRealmNamesAsString(String[] realmNames) {
        StringBuilder sb = new StringBuilder();
        if (realmNames != null && realmNames.length > 0) {
            for (String realmName : realmNames) {
                sb.append(realmName);
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

