/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.schema.converter;

import java.io.InputStream;
import java.io.Writer;
import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.schema.converter.ParserException;
import org.apache.directory.api.ldap.schema.converter.Schema;
import org.apache.directory.api.ldap.schema.converter.SchemaElement;
import org.apache.directory.api.ldap.schema.converter.SchemaParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaToLdif {
    private static final String HEADER = "#\n#  Licensed to the Apache Software Foundation (ASF) under one\n#  or more contributor license agreements.  See the NOTICE file\n#  distributed with this work for additional information\n#  regarding copyright ownership.  The ASF licenses this file\n#  to you under the Apache License, Version 2.0 (the\n#  \"License\"); you may not use this file except in compliance\n#  with the License.  You may obtain a copy of the License at\n#  \n#    http://www.apache.org/licenses/LICENSE-2.0\n#  \n#  Unless required by applicable law or agreed to in writing,\n#  software distributed under the License is distributed on an\n#  \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n#  KIND, either express or implied.  See the License for the\n#  specific language governing permissions and limitations\n#  under the License. \n#\nversion: 1\n\n";
    private static final Logger LOG = LoggerFactory.getLogger(SchemaToLdif.class);

    private SchemaToLdif() {
    }

    public static void transform(List<Schema> schemas) throws ParserException {
        if (schemas == null || schemas.isEmpty()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(I18n.msg((I18n)I18n.MSG_15000_NO_SCHEMA_DEFINED, (Object[])new Object[0]));
            }
            return;
        }
        int i = 1;
        for (Schema schema : schemas) {
            if (schema.getName() != null) continue;
            String msg = I18n.err((I18n)I18n.ERR_15000_SCHEMA_ELEMENT_NAME_REQUIRED, (Object[])new Object[]{i});
            LOG.error(msg);
            throw new ParserException(msg);
        }
        for (Schema schema : schemas) {
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info(I18n.msg((I18n)I18n.MSG_15001_GENERATING_SCHEMA, (Object[])new Object[]{schema.getName()}));
                }
                SchemaToLdif.generate(schema);
            }
            catch (Exception e) {
                throw new ParserException(I18n.err((I18n)I18n.ERR_15004_CANNOT_GENERATE_SOURCES, (Object[])new Object[]{schema.getName(), e.getMessage()}));
            }
        }
    }

    private static void generate(Schema schema) throws Exception {
        try (InputStream in = schema.getInput();
             Writer out = schema.getOutput();){
            SchemaParser parser = new SchemaParser();
            List<SchemaElement> elements = parser.parse(in);
            out.write(HEADER);
            for (SchemaElement element : elements) {
                out.write(element.toLdif(schema.getName()));
                out.write(10);
            }
            out.flush();
        }
    }
}

