/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2;

import java.util.Arrays;
import java.util.Collection;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.dsmlv2.Dsmlv2Container;
import org.apache.directory.api.dsmlv2.GrammarAction;
import org.apache.directory.api.dsmlv2.actions.ReadSoapHeader;
import org.apache.directory.api.dsmlv2.request.BatchRequestDsml;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.ldif.LdifUtils;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.util.Base64;
import org.apache.directory.api.util.Strings;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ParserUtils {
    public static final String XML_SCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    public static final String XML_SCHEMA_INSTANCE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String BASE64BINARY = "base64Binary";
    public static final String XSI = "xsi";
    public static final String XSD = "xsd";
    public static final Namespace DSML_NAMESPACE = new Namespace(null, "urn:oasis:names:tc:DSML:2:0:core");
    public static final Namespace XSD_NAMESPACE = new Namespace("xsd", "http://www.w3.org/2001/XMLSchema");
    public static final Namespace XSI_NAMESPACE = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    private static final Logger LOG = LoggerFactory.getLogger(ParserUtils.class);
    public static final GrammarAction READ_SOAP_HEADER = new ReadSoapHeader();

    private ParserUtils() {
    }

    public static String getXsiTypeAttributeValue(XmlPullParser xpp) {
        String type = null;
        int nbAttributes = xpp.getAttributeCount();
        for (int i = 0; i < nbAttributes; ++i) {
            if (!"type".equals(xpp.getAttributeName(i)) || !xpp.getNamespace(xpp.getAttributePrefix(i)).equals(XML_SCHEMA_INSTANCE_URI)) continue;
            type = xpp.getAttributeValue(i);
            break;
        }
        return type;
    }

    public static boolean isBase64BinaryValue(XmlPullParser parser, String attrValue) {
        if (attrValue == null) {
            return false;
        }
        String[] splitedString = attrValue.split(":");
        return splitedString.length == 2 && XML_SCHEMA_URI.equals(parser.getNamespace(splitedString[0])) && BASE64BINARY.equals(splitedString[1]);
    }

    public static boolean needsBase64Encoding(Object value) {
        if (value instanceof Value) {
            return false;
        }
        if (value instanceof byte[]) {
            return true;
        }
        if (value instanceof String) {
            return !LdifUtils.isLDIFSafe((String)((String)value));
        }
        return true;
    }

    public static String base64Encode(Object value) {
        if (value instanceof byte[]) {
            return new String(Base64.encode((byte[])((byte[])value)));
        }
        if (value instanceof String) {
            return new String(Base64.encode((byte[])Strings.getBytesUtf8((String)((String)value))));
        }
        return "";
    }

    public static int parseAndVerifyRequestID(String attributeValue, XmlPullParser xpp) throws XmlPullParserException {
        try {
            int requestID = Integer.parseInt(attributeValue);
            if (requestID < 0) {
                throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03016_BELOW_0_REQUEST_ID, (Object[])new Object[]{requestID}), xpp, null);
            }
            return requestID;
        }
        catch (NumberFormatException nfe) {
            throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03012_REQUEST_ID_NOT_INTEGER, (Object[])new Object[0]), xpp, (Throwable)nfe);
        }
    }

    public static void addControls(LdapApiService codec, Element element, Collection<Control> controls, boolean isRequest) {
        if (controls != null) {
            for (Control control : controls) {
                byte[] value;
                Element controlElement = element.addElement("control");
                if (control.getOid() != null) {
                    controlElement.addAttribute("type", control.getOid());
                }
                if (control.isCritical()) {
                    controlElement.addAttribute("criticality", "true");
                }
                Asn1Buffer asn1Buffer = new Asn1Buffer();
                if (isRequest) {
                    ((ControlFactory)codec.getRequestControlFactories().get(control.getOid())).encodeValue(asn1Buffer, control);
                } else {
                    ((ControlFactory)codec.getResponseControlFactories().get(control.getOid())).encodeValue(asn1Buffer, control);
                }
                if ((value = asn1Buffer.getBytes().array()) == null) continue;
                if (ParserUtils.needsBase64Encoding(value)) {
                    element.getDocument().getRootElement().add(XSD_NAMESPACE);
                    element.getDocument().getRootElement().add(XSI_NAMESPACE);
                    Element valueElement = controlElement.addElement("controlValue").addText(ParserUtils.base64Encode(value));
                    valueElement.addAttribute(new QName("type", XSI_NAMESPACE), "xsd:base64Binary");
                    continue;
                }
                controlElement.addElement("controlValue").setText(Arrays.toString(value));
            }
        }
    }

    public static boolean isRequestIdNeeded(Dsmlv2Container container) throws XmlPullParserException {
        BatchRequestDsml batchRequest = container.getBatchRequest();
        if (batchRequest == null) {
            throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03003_UNABLE_TO_FIND_BATCH_REQUEST, (Object[])new Object[0]), container.getParser(), null);
        }
        return batchRequest.getProcessing() == BatchRequestDsml.Processing.PARALLEL && batchRequest.getResponseOrder() == BatchRequestDsml.ResponseOrder.UNORDERED;
    }

    public static Document styleDocument(Document document) {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            transformer = factory.newTransformer(new StreamSource(ParserUtils.class.getResourceAsStream("/org/apache/directory/shared/dsmlv2/DSMLv2.xslt")));
        }
        catch (TransformerConfigurationException e1) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(I18n.msg((I18n)I18n.MSG_3000_FAILED_TO_CREATE_XSLT_TRANSFORMER, (Object[])new Object[0]), (Throwable)e1);
            }
            return document;
        }
        DocumentSource source = new DocumentSource(document);
        DocumentResult result = new DocumentResult();
        try {
            transformer.transform((Source)source, (Result)result);
        }
        catch (TransformerException e) {
            return document;
        }
        return result.getDocument();
    }
}

