/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.schema.converter;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.schema.converter.SchemaElement;
import org.apache.directory.api.ldap.schema.converter.antlrSchemaConverterLexer;
import org.apache.directory.api.ldap.schema.converter.antlrSchemaConverterParser;
import org.apache.directory.api.util.Strings;

public class SchemaParser {
    private antlrSchemaConverterParser parser = null;
    private PipedOutputStream parserIn = null;
    private byte[] buf = new byte[128];
    private InputStream schemaIn;
    private Thread producerThread;

    public SchemaParser() throws IOException {
        this.init();
    }

    public synchronized void init() throws IOException {
        this.parserIn = new PipedOutputStream();
        PipedInputStream in = new PipedInputStream();
        this.parserIn.connect(in);
        antlrSchemaConverterLexer lexer = new antlrSchemaConverterLexer(in);
        this.parser = new antlrSchemaConverterParser(lexer);
    }

    public synchronized void clear() {
        this.parser.clear();
    }

    public synchronized List<SchemaElement> parse(String schemaObject) throws IOException, ParseException {
        if (schemaObject == null || schemaObject.trim().equals("")) {
            throw new ParseException(I18n.err(I18n.ERR_15002_EMPTY_OR_NULL_SCHEMA_OBJECT, new Object[0]), 0);
        }
        this.schemaIn = new ByteArrayInputStream(Strings.getBytesUtf8(schemaObject));
        if (this.producerThread == null) {
            this.producerThread = new Thread(new DataProducer());
        }
        this.producerThread.start();
        return this.invokeParser(schemaObject);
    }

    private List<SchemaElement> invokeParser(String schemaName) throws IOException, ParseException {
        try {
            this.parser.parseSchema();
            return this.parser.getSchemaElements();
        }
        catch (RecognitionException re) {
            String msg = I18n.err(I18n.ERR_15003_PARSER_FAILURE, schemaName, ExceptionUtils.getFullStackTrace((Throwable)re));
            this.init();
            throw new ParseException(msg, re.getColumn());
        }
        catch (TokenStreamException tse) {
            String msg = I18n.err(I18n.ERR_15003_PARSER_FAILURE, schemaName, ExceptionUtils.getFullStackTrace((Throwable)tse));
            this.init();
            throw new ParseException(msg, 0);
        }
    }

    public synchronized List<SchemaElement> parse(InputStream schemaIn) throws IOException, ParseException {
        this.schemaIn = schemaIn;
        if (this.producerThread == null) {
            this.producerThread = new Thread(new DataProducer());
        }
        this.producerThread.start();
        return this.invokeParser("schema input stream ==> " + schemaIn.toString());
    }

    public synchronized void parse(File schemaFile) throws IOException, ParseException {
        this.schemaIn = Files.newInputStream(Paths.get(schemaFile.getPath(), new String[0]), new OpenOption[0]);
        if (this.producerThread == null) {
            this.producerThread = new Thread(new DataProducer());
        }
        this.producerThread.start();
        this.invokeParser("schema file ==> " + schemaFile.getAbsolutePath());
    }

    private class DataProducer
    implements Runnable {
        private DataProducer() {
        }

        @Override
        public void run() {
            int count = -1;
            try {
                while ((count = SchemaParser.this.schemaIn.read(SchemaParser.this.buf)) != -1) {
                    SchemaParser.this.parserIn.write(SchemaParser.this.buf, 0, count);
                    SchemaParser.this.parserIn.flush();
                }
                SchemaParser.this.parserIn.write(Strings.getBytesUtf8("END "));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

