/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.util.Strings;

public class ModifyDnRequestDecorator
extends SingleReplyRequestDecorator<ModifyDnRequest>
implements ModifyDnRequest {
    private int modifyDnRequestLength;
    private byte[] dnBytes;
    private byte[] newSuperiorBytes;

    public ModifyDnRequestDecorator(LdapApiService codec, ModifyDnRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    @Override
    public Dn getName() {
        return ((ModifyDnRequest)this.getDecorated()).getName();
    }

    @Override
    public ModifyDnRequest setName(Dn name) {
        ((ModifyDnRequest)this.getDecorated()).setName(name);
        return this;
    }

    @Override
    public Rdn getNewRdn() {
        return ((ModifyDnRequest)this.getDecorated()).getNewRdn();
    }

    @Override
    public ModifyDnRequest setNewRdn(Rdn newRdn) {
        ((ModifyDnRequest)this.getDecorated()).setNewRdn(newRdn);
        return this;
    }

    @Override
    public boolean getDeleteOldRdn() {
        return ((ModifyDnRequest)this.getDecorated()).getDeleteOldRdn();
    }

    @Override
    public ModifyDnRequest setDeleteOldRdn(boolean deleteOldRdn) {
        ((ModifyDnRequest)this.getDecorated()).setDeleteOldRdn(deleteOldRdn);
        return this;
    }

    @Override
    public Dn getNewSuperior() {
        return ((ModifyDnRequest)this.getDecorated()).getNewSuperior();
    }

    @Override
    public ModifyDnRequest setNewSuperior(Dn newSuperior) {
        ((ModifyDnRequest)this.getDecorated()).setNewSuperior(newSuperior);
        return this;
    }

    @Override
    public boolean isMove() {
        return ((ModifyDnRequest)this.getDecorated()).isMove();
    }

    @Override
    public ModifyDnRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public ModifyDnRequest addControl(Control control) {
        return (ModifyDnRequest)super.addControl(control);
    }

    @Override
    public ModifyDnRequest addAllControls(Control[] controls) {
        return (ModifyDnRequest)super.addAllControls(controls);
    }

    @Override
    public ModifyDnRequest removeControl(Control control) {
        return (ModifyDnRequest)super.removeControl(control);
    }

    @Override
    public int computeLength() {
        int newRdnlength = Strings.getBytesUtf8(this.getNewRdn().getName()).length;
        this.dnBytes = Strings.getBytesUtf8(this.getName().getName());
        this.modifyDnRequestLength = 1 + TLV.getNbBytes(this.dnBytes.length) + this.dnBytes.length + 1 + TLV.getNbBytes(newRdnlength) + newRdnlength + 1 + 1 + 1;
        if (this.getNewSuperior() != null) {
            this.newSuperiorBytes = Strings.getBytesUtf8(this.getNewSuperior().getName());
            this.modifyDnRequestLength += 1 + TLV.getNbBytes(this.newSuperiorBytes.length) + this.newSuperiorBytes.length;
        }
        return 1 + TLV.getNbBytes(this.modifyDnRequestLength) + this.modifyDnRequestLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)108);
            buffer.put(TLV.getBytes(this.modifyDnRequestLength));
            BerValue.encode(buffer, this.dnBytes);
            BerValue.encode(buffer, this.getNewRdn().getName());
            BerValue.encode(buffer, this.getDeleteOldRdn());
            if (this.getNewSuperior() != null) {
                buffer.put((byte)-128);
                int newSuperiorLength = this.newSuperiorBytes.length;
                buffer.put(TLV.getBytes(newSuperiorLength));
                if (newSuperiorLength != 0) {
                    buffer.put(this.newSuperiorBytes);
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_08212_PDU_BUFFER_TOO_SMALL, new Object[0]), boe);
        }
        return buffer;
    }
}

