/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchRequestTypesOnly
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchRequestTypesOnly.class);

    public StoreSearchRequestTypesOnly() {
        super("Store SearchRequest typesOnly flag");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequest searchRequest = (SearchRequest)container.getMessage().getDecorated();
        TLV tlv = container.getCurrentTLV();
        BerValue value = tlv.getValue();
        try {
            searchRequest.setTypesOnly(BooleanDecoder.parse(value));
        }
        catch (BooleanDecoderException bde) {
            LOG.error(I18n.err(I18n.ERR_05155_FLAG_TYPE_INVALID, Strings.dumpBytes(value.getData()), bde.getMessage()));
            throw new DecoderException(bde.getMessage(), bde);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05165_SEARCH_RETURN_TYPE_ONLY, new Object[0]));
        }
    }
}

