/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.testcontrol.impl.validation;

import jakarta.enterprise.inject.Typed;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.deltaspike.cdise.api.CdiContainerLoader;
import org.apache.deltaspike.testcontrol.api.TestControl;
import org.apache.deltaspike.testcontrol.spi.TestAware;
import org.apache.deltaspike.testcontrol.spi.TestControlValidator;

@Typed
public class StandardContextTestControlValidator
implements TestAware,
TestControlValidator {
    private static Boolean customContextControlDetected;
    private static ThreadLocal<Class> currentTestClass;
    private static ThreadLocal<Method> currentTestMethod;

    public void validate(TestControl testControl) {
        this.checkActiveContextControlImplementation();
        ArrayList<Class<? extends Annotation>> scopeClasses = new ArrayList<Class<? extends Annotation>>();
        Collections.addAll(scopeClasses, testControl.startScopes());
        this.validateSupportedScopes(scopeClasses, currentTestClass.get(), currentTestMethod.get());
    }

    private void checkActiveContextControlImplementation() {
        if (customContextControlDetected != null) {
            return;
        }
        customContextControlDetected = !CdiContainerLoader.getCdiContainer().getContextControl().getClass().getName().startsWith("org.apache.deltaspike.");
    }

    private void validateSupportedScopes(List<Class<? extends Annotation>> scopeClasses, Class<?> declaringClass, Method testMethod) {
        if (Boolean.TRUE.equals(customContextControlDetected)) {
            return;
        }
        for (Class<? extends Annotation> scopeClass : scopeClasses) {
            if (scopeClass.getName().startsWith("jakarta.enterprise.context.")) continue;
            throw new IllegalStateException("Please remove " + scopeClass.getName() + " at " + declaringClass + (String)(testMethod != null ? "#" + testMethod.getName() : "") + " from @" + TestControl.class.getName() + ". @" + TestControl.class.getName() + " only supports standard Scope-Annotations provided by the CDI-Specification. Other Contexts start automatically or need to get started with a specific Management-API. Examples: @TransactionScoped gets started automatically once the @Transactional-Interceptor is used. Whereas @WindowScoped starts once WindowContext#activateWindow gets called.");
        }
    }

    public void setTestClass(Class testClass) {
        currentTestClass.set(testClass);
        if (testClass == null) {
            currentTestClass.remove();
        }
    }

    public void setTestMethod(Method testMethod) {
        currentTestMethod.set(testMethod);
        if (testMethod == null) {
            currentTestMethod.remove();
        }
    }

    static {
        currentTestClass = new ThreadLocal();
        currentTestMethod = new ThreadLocal();
    }
}

