/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.scope.viewaccess;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.PassivationCapable;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.apache.deltaspike.core.api.scope.ViewAccessScoped;
import org.apache.deltaspike.core.impl.scope.viewaccess.ViewAccessBeanAccessHistory;
import org.apache.deltaspike.core.impl.scope.viewaccess.ViewAccessBeanHolder;
import org.apache.deltaspike.core.impl.scope.viewaccess.ViewAccessViewHistory;
import org.apache.deltaspike.core.impl.scope.window.WindowContextImpl;
import org.apache.deltaspike.core.spi.scope.viewaccess.ViewAccessContextManager;
import org.apache.deltaspike.core.util.context.AbstractContext;
import org.apache.deltaspike.core.util.context.ContextualInstanceInfo;
import org.apache.deltaspike.core.util.context.ContextualStorage;

@Typed
public class ViewAccessContext
extends AbstractContext
implements ViewAccessContextManager {
    private static final String KEY = "VAS";
    private final BeanManager beanManager;
    private final WindowContextImpl windowContext;
    private ViewAccessBeanHolder viewAccessBeanHolder;
    private ViewAccessBeanAccessHistory viewAccessBeanAccessHistory;
    private ViewAccessViewHistory viewAccessViewHistory;

    public ViewAccessContext(BeanManager beanManager, WindowContextImpl windowContext) {
        super(beanManager);
        this.beanManager = beanManager;
        this.windowContext = windowContext;
    }

    public void init(ViewAccessBeanHolder viewAccessBeanHolder, ViewAccessBeanAccessHistory viewAccessBeanAccessHistory, ViewAccessViewHistory viewAccessViewHistory) {
        this.viewAccessBeanHolder = viewAccessBeanHolder;
        this.viewAccessBeanAccessHistory = viewAccessBeanAccessHistory;
        this.viewAccessViewHistory = viewAccessViewHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> bean) {
        try {
            Object object = super.get(bean);
            return (T)object;
        }
        finally {
            if (bean instanceof PassivationCapable) {
                PassivationCapable pc = (PassivationCapable)bean;
                this.viewAccessBeanAccessHistory.getAccessedBeans().add(pc.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        try {
            Object object = super.get(bean, creationalContext);
            return (T)object;
        }
        finally {
            if (bean instanceof PassivationCapable) {
                PassivationCapable pc = (PassivationCapable)bean;
                this.viewAccessBeanAccessHistory.getAccessedBeans().add(pc.getId());
            }
        }
    }

    protected ContextualStorage getContextualStorage(Contextual<?> contextual, boolean createIfNotExist) {
        return this.viewAccessBeanHolder.getContextualStorage(this.beanManager, KEY, createIfNotExist);
    }

    public Class<? extends Annotation> getScope() {
        return ViewAccessScoped.class;
    }

    public boolean isActive() {
        return this.windowContext.isActive();
    }

    public void onProcessingViewFinished(String view) {
        this.close(view, false);
    }

    public void close(String view, boolean force) {
        if (!this.windowContext.isActive()) {
            return;
        }
        if (force || !view.equals(this.viewAccessViewHistory.getLastView())) {
            this.viewAccessViewHistory.setLastView(view);
            this.destroyExpiredBeans(force);
        }
        this.viewAccessBeanAccessHistory.getAccessedBeans().clear();
    }

    private void destroyExpiredBeans(boolean force) {
        ContextualStorage storage = this.viewAccessBeanHolder.getContextualStorage(this.beanManager, KEY, false);
        if (storage != null) {
            for (Map.Entry storageEntry : storage.getStorage().entrySet()) {
                if (!force && this.viewAccessBeanAccessHistory.getAccessedBeans().contains((String)storageEntry.getKey())) continue;
                Contextual bean = storage.getBean(storageEntry.getKey());
                AbstractContext.destroyBean((Contextual)bean, (ContextualInstanceInfo)((ContextualInstanceInfo)storageEntry.getValue()));
                storage.getStorage().remove(storageEntry.getKey());
            }
        }
    }

    public void close() {
        this.close(null, true);
    }
}

