/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.testcontrol.api.junit;

import jakarta.inject.Named;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.cdise.api.CdiContainer;
import org.apache.deltaspike.cdise.api.CdiContainerLoader;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.config.PropertyLoader;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.spi.config.ConfigSource;
import org.apache.deltaspike.core.spi.filter.ClassFilter;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.testcontrol.api.TestControl;
import org.apache.deltaspike.testcontrol.api.junit.TestBaseConfig;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class CdiTestSuiteRunner
extends Suite {
    public static final String CUSTOM_TEST_CONTAINER_CONFIG_FILE_KEY = "deltaspike.testcontrol.test-container.config-file";
    public static final String DEFAULT_TEST_CONTAINER_CONFIG_FILE_NAME = "META-INF/apache-deltaspike_test-container";
    private static final boolean STOP_CONTAINER;
    private static final ThreadLocal<Boolean> IS_CDI_TEST_RUNNER_EXECUTION;
    private static volatile boolean containerStarted;
    private final Class<?> testSuiteClass;

    public CdiTestSuiteRunner(Class<?> klass, RunnerBuilder builder) throws InitializationError {
        super(klass, builder);
        this.testSuiteClass = klass;
    }

    protected CdiTestSuiteRunner(Class<?> klass, Class<?>[] suiteClasses) throws InitializationError {
        super(klass, (Class[])suiteClasses);
        this.testSuiteClass = klass;
    }

    protected CdiTestSuiteRunner(RunnerBuilder builder, Class<?> klass, Class<?>[] suiteClasses) throws InitializationError {
        super(builder, klass, (Class[])suiteClasses);
        this.testSuiteClass = klass;
    }

    protected CdiTestSuiteRunner(Class<?> klass, List<Runner> runners) throws InitializationError {
        super(klass, runners);
        this.testSuiteClass = klass;
    }

    public void run(RunNotifier notifier) {
        if (this.testSuiteClass == null) {
            throw new IllegalStateException("no test-suite class found");
        }
        CdiContainer container = CdiContainerLoader.getCdiContainer();
        if (!containerStarted) {
            CdiTestSuiteRunner.applyTestSpecificMetaData(this.getTestClass().getJavaClass());
            container.boot((Map)CdiTestSuiteRunner.getTestContainerConfig());
            containerStarted = true;
        }
        notifier.addListener((RunListener)new LogRunListener());
        try {
            super.run(notifier);
        }
        finally {
            if (STOP_CONTAINER) {
                container.shutdown();
                containerStarted = false;
            }
        }
    }

    public static boolean isContainerStarted() {
        return containerStarted;
    }

    static Boolean isStopContainerAllowed() {
        return STOP_CONTAINER;
    }

    static ThreadLocal<Boolean> getCdiTestRunnerExecutionRef() {
        return IS_CDI_TEST_RUNNER_EXECUTION;
    }

    static void setContainerStarted(boolean containerStarted) {
        CdiTestSuiteRunner.containerStarted = containerStarted;
    }

    public static Properties getTestContainerConfig() {
        String cdiTestRunnerConfig = ConfigResolver.getProjectStageAwarePropertyValue((String)CUSTOM_TEST_CONTAINER_CONFIG_FILE_KEY, (String)DEFAULT_TEST_CONTAINER_CONFIG_FILE_NAME);
        return PropertyLoader.getProperties((String)cdiTestRunnerConfig);
    }

    static void applyTestSpecificMetaData(Class<?> currentAnnotationSource) {
        TestControl testControl = currentAnnotationSource.getAnnotation(TestControl.class);
        String activeAlternativeLabel = CdiTestSuiteRunner.checkForLabeledAlternativeConfig(testControl);
        CdiTestSuiteRunner.initTestEnvConfig(currentAnnotationSource, activeAlternativeLabel, testControl);
    }

    private static String checkForLabeledAlternativeConfig(TestControl testControl) {
        Class<? extends TestControl.Label> activeTypedAlternativeLabel;
        Object activeAlternativeLabel = "";
        if (testControl != null && !TestControl.Label.class.equals(activeTypedAlternativeLabel = testControl.activeAlternativeLabel())) {
            Named labelName = activeTypedAlternativeLabel.getAnnotation(Named.class);
            if (labelName != null) {
                activeAlternativeLabel = labelName.value();
            } else {
                String labelClassName = activeTypedAlternativeLabel.getSimpleName();
                activeAlternativeLabel = labelClassName.substring(0, 1).toLowerCase();
                if (labelClassName.length() > 1) {
                    activeAlternativeLabel = (String)activeAlternativeLabel + labelClassName.substring(1);
                }
            }
        }
        return activeAlternativeLabel;
    }

    private static void initTestEnvConfig(Class<?> testClass, String activeAlternativeLabel, TestControl testControl) {
        if (ClassDeactivationUtils.isActivated(TestConfigSource.class)) {
            TestConfigSource testConfigSource = null;
            for (ConfigSource configSource : ConfigResolver.getConfigSources()) {
                if (!(configSource instanceof TestConfigSource)) continue;
                testConfigSource = (TestConfigSource)configSource;
            }
            if (testConfigSource == null) {
                testConfigSource = new TestConfigSource();
                ConfigResolver.addConfigSources(Arrays.asList(testConfigSource));
            }
            testConfigSource.getProperties().put("activeAlternativeLabel", activeAlternativeLabel);
            testConfigSource.getProperties().put("activeAlternativeLabelSource", testClass.getName());
            if (testControl != null) {
                testConfigSource.getProperties().put(TestControl.class.getName(), testClass.getName());
                testConfigSource.getProperties().put(ClassFilter.class.getName(), testControl.classFilter().getName());
            } else {
                testConfigSource.getProperties().put(TestControl.class.getName(), TestControl.class.getName());
                testConfigSource.getProperties().put(ClassFilter.class.getName(), ClassFilter.class.getName());
            }
        } else {
            System.setProperty("activeAlternativeLabel", activeAlternativeLabel);
            System.setProperty("activeAlternativeLabelSource", testClass.getName());
            if (testControl != null) {
                System.setProperty(TestControl.class.getName(), testClass.getName());
                System.setProperty(ClassFilter.class.getName(), testControl.classFilter().getName());
            } else {
                System.setProperty(TestControl.class.getName(), TestControl.class.getName());
                System.setProperty(ClassFilter.class.getName(), ClassFilter.class.getName());
            }
        }
    }

    static {
        IS_CDI_TEST_RUNNER_EXECUTION = new ThreadLocal();
        STOP_CONTAINER = TestBaseConfig.ContainerIntegration.STOP_CONTAINER;
    }

    public static class TestConfigSource
    implements ConfigSource,
    Deactivatable {
        private Map<String, String> testConfig = new ConcurrentHashMap<String, String>();

        public int getOrdinal() {
            return Integer.MIN_VALUE;
        }

        public Map<String, String> getProperties() {
            return this.testConfig;
        }

        public String getPropertyValue(String key) {
            return this.testConfig.get(key);
        }

        public String getConfigName() {
            return "ds-test-config";
        }

        public boolean isScannable() {
            return true;
        }
    }

    static class LogRunListener
    extends RunListener {
        private final Logger logger = Logger.getLogger(LogRunListener.class.getName());

        LogRunListener() {
        }

        public void testStarted(Description description) throws Exception {
            if (Boolean.TRUE.equals(IS_CDI_TEST_RUNNER_EXECUTION.get())) {
                this.logger.info("[run] " + description.getClassName() + "#" + description.getMethodName());
            }
            super.testRunStarted(description);
        }

        public void testFinished(Description description) throws Exception {
            Level level = this.logger.getLevel();
            this.logger.setLevel(Level.INFO);
            if (Boolean.TRUE.equals(IS_CDI_TEST_RUNNER_EXECUTION.get())) {
                this.logger.info("[finished] " + description.getClassName() + "#" + description.getMethodName());
            }
            try {
                super.testFinished(description);
            }
            finally {
                this.logger.setLevel(level);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void testFailure(Failure failure) throws Exception {
            Level level = this.logger.getLevel();
            this.logger.setLevel(Level.INFO);
            if (Boolean.TRUE.equals(IS_CDI_TEST_RUNNER_EXECUTION.get())) {
                Description description = failure.getDescription();
                this.logger.info("[failed] " + description.getClassName() + "#" + description.getMethodName() + " message: " + failure.getMessage());
            }
            try {
                super.testFailure(failure);
            }
            finally {
                this.logger.setLevel(level);
            }
        }
    }
}

