/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.util;

import jakarta.enterprise.inject.Typed;
import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.lifecycle.ClientWindow;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.jsf.api.config.base.JsfBaseConfig;
import org.apache.deltaspike.jsf.impl.util.JsfUtils;

@Typed
public abstract class ClientWindowHelper {
    private static final Logger LOG = Logger.getLogger(ClientWindowHelper.class.getName());
    private static final String INITIAL_REDIRECT_WINDOW_ID = ClientWindowHelper.class.getName() + ".INITIAL_REDIRECT_WINDOW_ID";

    public static String constructRequestUrl(FacesContext facesContext, ExternalContext externalContext) {
        Object url = externalContext.getRequestContextPath() + externalContext.getRequestServletPath();
        if (externalContext.getRequestPathInfo() != null) {
            url = (String)url + externalContext.getRequestPathInfo();
        }
        url = JsfUtils.addRequestParameters(externalContext, (String)url, true);
        url = JsfUtils.removeUrlParameter((String)url, "jfwid");
        HttpServletResponse servletResponse = (HttpServletResponse)externalContext.getResponse();
        url = servletResponse.encodeRedirectURL(ClientWindowHelper.encodeURL((String)url, facesContext, servletResponse.getCharacterEncoding()));
        return url;
    }

    private static String encodeURL(String baseUrl, FacesContext facesContext, String encoding) {
        boolean hasParams;
        ClientWindow window;
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is null");
        }
        String fragment = null;
        String queryString = null;
        HashMap<String, List<String>> paramMap = null;
        int index = baseUrl.indexOf(35);
        if (index != -1) {
            fragment = baseUrl.substring(index + 1);
            baseUrl = baseUrl.substring(0, index);
        }
        if ((index = baseUrl.indexOf(63)) != -1) {
            queryString = baseUrl.substring(index + 1);
            baseUrl = baseUrl.substring(0, index);
            String[] nameValuePairs = queryString.split("&");
            for (int i = 0; i < nameValuePairs.length; ++i) {
                ArrayList<String> values;
                String[] currentPair = nameValuePairs[i].split("=");
                String string = currentPair[0];
                if (paramMap == null) {
                    paramMap = new HashMap(5, 1.0f);
                }
                if ((values = (ArrayList<String>)paramMap.get(string)) == null) {
                    values = new ArrayList<String>(1);
                    paramMap.put(string, values);
                }
                try {
                    values.add(currentPair.length > 1 ? URLDecoder.decode(currentPair[1], encoding) : "");
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new UnsupportedOperationException("Encoding type=" + encoding + " not supported", e);
                }
            }
        }
        if ((window = facesContext.getExternalContext().getClientWindow()) != null && window.isClientWindowRenderModeEnabled(facesContext)) {
            Map additionalQueryURLParameters;
            if (paramMap == null) {
                paramMap = new HashMap<String, List<String>>(5, 1.0f);
            }
            if (!paramMap.containsKey("jfwid")) {
                paramMap.put("jfwid", Arrays.asList(window.getId()));
            }
            if ((additionalQueryURLParameters = window.getQueryURLParameters(facesContext)) != null) {
                for (Map.Entry entry : additionalQueryURLParameters.entrySet()) {
                    paramMap.put((String)entry.getKey(), Arrays.asList((String)entry.getValue()));
                }
            }
        }
        boolean bl = hasParams = paramMap != null && !paramMap.isEmpty();
        if (!hasParams && fragment == null) {
            return baseUrl;
        }
        StringBuilder newUrl = new StringBuilder(baseUrl.length() + 10);
        newUrl.append(baseUrl);
        if (hasParams) {
            boolean bl2 = true;
            for (Map.Entry pair : paramMap.entrySet()) {
                for (int i = 0; i < ((List)pair.getValue()).size(); ++i) {
                    boolean bl3;
                    String value = (String)((List)pair.getValue()).get(i);
                    if (!bl3) {
                        newUrl.append('&');
                    } else {
                        newUrl.append('?');
                        bl3 = false;
                    }
                    newUrl.append((String)pair.getKey());
                    newUrl.append('=');
                    if (value == null) continue;
                    try {
                        newUrl.append(URLEncoder.encode(value, encoding));
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new UnsupportedOperationException("Encoding type=" + encoding + " not supported", e);
                    }
                }
            }
        }
        if (fragment != null) {
            newUrl.append('#');
            newUrl.append(fragment);
        }
        return newUrl.toString();
    }

    public static void handleInitialRedirect(FacesContext facesContext, String newWindowId) {
        facesContext.getAttributes().put(INITIAL_REDIRECT_WINDOW_ID, newWindowId);
        ExternalContext externalContext = facesContext.getExternalContext();
        String url = ClientWindowHelper.constructRequestUrl(facesContext, externalContext);
        ClientWindowHelper.addRequestWindowIdCookie(facesContext, newWindowId, newWindowId);
        try {
            externalContext.redirect(url);
        }
        catch (IOException e) {
            throw new FacesException("Could not send initial redirect!", (Throwable)e);
        }
    }

    public static boolean isInitialRedirect(FacesContext facesContext) {
        return facesContext.getAttributes().containsKey(INITIAL_REDIRECT_WINDOW_ID);
    }

    public static String getInitialRedirectWindowId(FacesContext facesContext) {
        return (String)facesContext.getAttributes().get(INITIAL_REDIRECT_WINDOW_ID);
    }

    public static void addRequestWindowIdCookie(FacesContext context, String requestToken, String windowId) {
        context.getExternalContext().addResponseHeader("Set-Cookie", "dsrwid-" + requestToken + "=" + windowId + "; path=/; maxAge=30; SameSite=Strict");
    }

    public static Object getRequestWindowIdCookie(FacesContext context, String requestToken) {
        Map cookieMap = context.getExternalContext().getRequestCookieMap();
        if (cookieMap.containsKey("dsrwid-" + requestToken)) {
            return cookieMap.get("dsrwid-" + requestToken);
        }
        return null;
    }

    public static int getMaxWindowIdLength() {
        int result = JsfBaseConfig.ScopeCustomization.WindowRestriction.ID_MAX_LENGTH;
        if (result > 10 && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("ATTENTION: if you change this value to be significant longer than 10, you can introduce a security issue in WindowIdHtmlRenderer. If you increase it because window.name contains a value already, please revisit that usage or create shorter unique ids since they just need to be unique within the user-session.");
        }
        return result;
    }

    public abstract class Cookies {
        public static final String REQUEST_WINDOW_ID_PREFIX = "dsrwid-";
    }

    public abstract class RequestParameters {
        public static final String REQUEST_TOKEN = "dsrid";
    }
}

