/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.handler;

import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.metamodel.Metamodel;
import java.util.Map;
import org.apache.deltaspike.data.api.EntityManagerDelegate;
import org.apache.deltaspike.data.spi.DelegateQueryHandler;
import org.apache.deltaspike.data.spi.QueryInvocationContext;

@Dependent
public class EntityManagerDelegateHandler<E>
implements EntityManagerDelegate<E>,
DelegateQueryHandler {
    @Inject
    private QueryInvocationContext context;

    public void persist(E entity) {
        this.entityManager().persist(entity);
    }

    public E merge(E entity) {
        return (E)this.entityManager().merge(entity);
    }

    public E find(Object primaryKey, Map<String, Object> properties) {
        return (E)this.entityManager().find(this.context.getEntityClass(), primaryKey, properties);
    }

    public E find(Object primaryKey, LockModeType lockMode) {
        return (E)this.entityManager().find(this.context.getEntityClass(), primaryKey, lockMode);
    }

    public E find(Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return (E)this.entityManager().find(this.context.getEntityClass(), primaryKey, lockMode, properties);
    }

    public E getReference(Object primaryKey) {
        return (E)this.entityManager().getReference(this.context.getEntityClass(), primaryKey);
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.entityManager().setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        return this.entityManager().getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.entityManager().lock(entity, lockMode);
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.entityManager().lock(entity, lockMode, properties);
    }

    public void refresh(E entity, Map<String, Object> properties) {
        this.entityManager().refresh(entity, properties);
    }

    public void refresh(E entity, LockModeType lockMode) {
        this.entityManager().refresh(entity, lockMode);
    }

    public void refresh(E entity, LockModeType lockMode, Map<String, Object> properties) {
        this.entityManager().refresh(entity, lockMode, properties);
    }

    public void clear() {
        this.entityManager().clear();
    }

    public void detach(E entity) {
        this.entityManager().detach(entity);
    }

    public boolean contains(E entity) {
        return this.entityManager().contains(entity);
    }

    public LockModeType getLockMode(E entity) {
        return this.entityManager().getLockMode(entity);
    }

    public void setProperty(String propertyName, Object value) {
        this.entityManager().setProperty(propertyName, value);
    }

    public Map<String, Object> getProperties() {
        return this.entityManager().getProperties();
    }

    public void joinTransaction() {
        this.entityManager().joinTransaction();
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.entityManager().unwrap(cls);
    }

    public Object getDelegate() {
        return this.entityManager().getDelegate();
    }

    public void close() {
        this.entityManager().close();
    }

    public boolean isOpen() {
        return this.entityManager().isOpen();
    }

    public EntityTransaction getTransaction() {
        return this.entityManager().getTransaction();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManager().getEntityManagerFactory();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.entityManager().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.entityManager().getMetamodel();
    }

    private EntityManager entityManager() {
        return this.context.getEntityManager();
    }
}

