/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.cdise.owb;

import jakarta.enterprise.inject.Typed;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Typed
public class MockHttpSession
implements HttpSession {
    private String sessionId;
    private Map<String, Object> sessionMap = new ConcurrentHashMap<String, Object>();

    public MockHttpSession(String sessionId) {
        this.sessionId = sessionId;
    }

    public long getCreationTime() {
        return 0L;
    }

    public String getId() {
        return this.sessionId;
    }

    public long getLastAccessedTime() {
        return 0L;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public void setMaxInactiveInterval(int interval) {
    }

    public int getMaxInactiveInterval() {
        return 0;
    }

    public Object getAttribute(String name) {
        return this.sessionMap.get(name);
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return null;
    }

    public String[] getValueNames() {
        return new String[0];
    }

    public void setAttribute(String name, Object value) {
        this.sessionMap.put(name, value);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.sessionMap.remove(name);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        this.sessionMap.clear();
    }

    public boolean isNew() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockHttpSession that = (MockHttpSession)o;
        return !(this.sessionId != null ? !this.sessionId.equals(that.sessionId) : that.sessionId != null);
    }

    public int hashCode() {
        return this.sessionId != null ? this.sessionId.hashCode() : 0;
    }

    public String toString() {
        return "MockHttpSession{sessionId='" + this.sessionId + "'}";
    }
}

