/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.filters.bloomfilter;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesReadOnlyException;
import org.apache.datasketches.filters.bloomfilter.BitArray;
import org.apache.datasketches.filters.bloomfilter.DirectBitArrayR;
import org.apache.datasketches.filters.bloomfilter.HeapBitArray;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectBitArrayRTest {
    private static Memory bitArrayToMemory(HeapBitArray ba) {
        int numBytes = (int)ba.getSerializedSizeBytes();
        byte[] bytes = new byte[numBytes];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])bytes);
        ba.writeToBuffer(wmem.asWritableBuffer());
        return wmem;
    }

    @Test
    public void createBitArrayTest() {
        HeapBitArray hba = new HeapBitArray(119L);
        Assert.assertTrue((boolean)hba.isEmpty());
        Memory mem = DirectBitArrayRTest.bitArrayToMemory(hba);
        DirectBitArrayR dba = DirectBitArrayR.wrap((Memory)mem, (boolean)hba.isEmpty());
        Assert.assertTrue((boolean)dba.isEmpty());
        Assert.assertEquals((long)dba.getCapacity(), (long)128L);
        Assert.assertEquals((int)dba.getArrayLength(), (int)2);
        Assert.assertEquals((long)dba.getNumBitsSet(), (long)0L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void createNegativeSizeBitArrayTest() {
        byte[] bytes = new byte[32];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])bytes);
        wmem.putInt(0L, -1);
        DirectBitArrayR.wrap((Memory)wmem, (boolean)true);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void tooSmallCapacityTest() {
        byte[] bytes = new byte[32];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])bytes);
        wmem.putInt(0L, 1024);
        wmem.putLong(8L, 201L);
        DirectBitArrayR.wrap((Memory)wmem, (boolean)false);
    }

    @Test
    public void basicOperationTest() {
        HeapBitArray hba = new HeapBitArray(128L);
        Assert.assertFalse((boolean)hba.getAndSetBit(1L));
        Assert.assertFalse((boolean)hba.getAndSetBit(2L));
        for (int i = 4; i < 64; i <<= 1) {
            hba.getAndSetBit((long)(64 + i));
        }
        Assert.assertEquals((long)hba.getNumBitsSet(), (long)6L);
        Assert.assertTrue((boolean)hba.getBit(68L));
        Assert.assertFalse((boolean)hba.isEmpty());
        Memory mem = DirectBitArrayRTest.bitArrayToMemory(hba);
        DirectBitArrayR dba = DirectBitArrayR.wrap((Memory)mem, (boolean)hba.isEmpty());
        Assert.assertEquals((long)dba.getNumBitsSet(), (long)6L);
        Assert.assertTrue((boolean)dba.getBit(68L));
        Assert.assertFalse((boolean)dba.isEmpty());
        Assert.assertFalse((boolean)dba.isDirty());
        Assert.assertTrue((boolean)dba.hasMemory());
        Assert.assertFalse((boolean)dba.isDirect());
        Assert.assertTrue((boolean)dba.isReadOnly());
    }

    @Test
    public void countBitsWhenDirty() {
        HeapBitArray hba = new HeapBitArray(128L);
        Assert.assertFalse((boolean)hba.getAndSetBit(1L));
        Assert.assertFalse((boolean)hba.getAndSetBit(2L));
        for (int i = 4; i < 64; i <<= 1) {
            hba.setBit((long)(64 + i));
        }
        Assert.assertEquals((long)hba.getNumBitsSet(), (long)6L);
        Assert.assertTrue((boolean)hba.getBit(68L));
        Assert.assertFalse((boolean)hba.isEmpty());
        Memory mem = DirectBitArrayRTest.bitArrayToMemory(hba);
        DirectBitArrayR dba = DirectBitArrayR.wrap((Memory)mem, (boolean)hba.isEmpty());
        Assert.assertEquals((long)dba.getNumBitsSet(), (long)6L);
        Assert.assertTrue((boolean)dba.getBit(68L));
        Assert.assertFalse((boolean)dba.isEmpty());
        Assert.assertFalse((boolean)dba.isDirty());
    }

    @Test
    public void bitAddressOutOfBoundsEmptyTest() {
        int numBits = 256;
        HeapBitArray hba = new HeapBitArray(256L);
        Memory mem = DirectBitArrayRTest.bitArrayToMemory(hba);
        DirectBitArrayR dba = DirectBitArrayR.wrap((Memory)mem, (boolean)hba.isEmpty());
        Assert.assertFalse((boolean)dba.getBit(19L));
        Assert.assertFalse((boolean)dba.getBit(-10L));
        Assert.assertFalse((boolean)dba.getBit(2048L));
    }

    @Test
    public void bitAddressOutOfBoundsNonEmptyTest() {
        int numBits = 1024;
        HeapBitArray hba = new HeapBitArray(1024L);
        for (int i = 0; i < 1024; i += 128) {
            hba.getAndSetBit((long)i);
        }
        Memory mem = DirectBitArrayRTest.bitArrayToMemory(hba);
        DirectBitArrayR dba = DirectBitArrayR.wrap((Memory)mem, (boolean)hba.isEmpty());
        Assert.assertThrows(AssertionError.class, () -> dba.getBit(-10L));
        Assert.assertThrows(AssertionError.class, () -> dba.getBit(2048L));
    }

    @Test
    public void checkInvalidMethods() {
        int numBits = 1024;
        HeapBitArray hba = new HeapBitArray(1024L);
        for (int i = 0; i < 1024; i += 128) {
            hba.getAndSetBit((long)i);
        }
        Memory mem = DirectBitArrayRTest.bitArrayToMemory(hba);
        DirectBitArrayR dba = DirectBitArrayR.wrap((Memory)mem, (boolean)hba.isEmpty());
        Assert.assertThrows(SketchesReadOnlyException.class, () -> dba.setBit(14L));
        Assert.assertThrows(SketchesReadOnlyException.class, () -> dba.getAndSetBit(100L));
        Assert.assertThrows(SketchesReadOnlyException.class, () -> dba.reset());
        Assert.assertThrows(SketchesReadOnlyException.class, () -> dba.invert());
        Assert.assertThrows(SketchesReadOnlyException.class, () -> dba.intersect((BitArray)hba));
        Assert.assertThrows(SketchesReadOnlyException.class, () -> dba.union((BitArray)hba));
    }
}

