/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.BackwardConversions;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketch;
import org.apache.datasketches.theta.HeapUnionTest;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.SetOperationBuilder;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectUnionTest {
    @Test
    public void checkExactUnionNoOverlap() {
        int i;
        int lgK = 9;
        int k = 512;
        int u = 512;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(512).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 256; ++i) {
            usk1.update((long)i);
        }
        for (i = 256; i < 512; ++i) {
            usk2.update((long)i);
        }
        Assert.assertEquals((double)512.0, (double)(usk1.getEstimate() + usk2.getEstimate()), (double)0.0);
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)512)]);
        Union union = SetOperation.builder().setNominalEntries(512).buildUnion(uMem);
        union.union((Sketch)usk1);
        union.union((Sketch)usk2);
        HeapUnionTest.testAllCompactForms(union, 512.0, 0.0);
    }

    @Test
    public void checkEstUnionNoOverlap() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(4096).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        union.union((Sketch)usk1);
        union.union((Sketch)usk2);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
    }

    @Test
    public void checkExactUnionWithOverlap() {
        int i;
        int lgK = 9;
        int k = 512;
        int u = 512;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(512).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 256; ++i) {
            usk1.update((long)i);
        }
        for (i = 0; i < 512; ++i) {
            usk2.update((long)i);
        }
        Assert.assertEquals((double)512.0, (double)(usk1.getEstimate() + usk2.getEstimate() / 2.0), (double)0.0);
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)512)]);
        Union union = SetOperation.builder().setNominalEntries(512).buildUnion(uMem);
        union.union((Sketch)usk1);
        union.union((Sketch)usk2);
        HeapUnionTest.testAllCompactForms(union, 512.0, 0.0);
    }

    @Test
    public void checkHeapifyExact() {
        int i;
        int lgK = 9;
        int k = 512;
        int u = 512;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(512).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 256; ++i) {
            usk1.update((long)i);
        }
        for (i = 256; i < 512; ++i) {
            usk2.update((long)i);
        }
        Assert.assertEquals((double)512.0, (double)(usk1.getEstimate() + usk2.getEstimate()), (double)0.0);
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)512)]);
        Union union = SetOperation.builder().setNominalEntries(512).buildUnion(uMem);
        union.union((Sketch)usk1);
        union.union((Sketch)usk2);
        HeapUnionTest.testAllCompactForms(union, 512.0, 0.0);
        Union union2 = (Union)SetOperation.heapify((Memory)WritableMemory.writableWrap((byte[])union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 512.0, 0.0);
    }

    @Test
    public void checkWrapExact() {
        int i;
        int lgK = 9;
        int k = 512;
        int u = 512;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(512).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 256; ++i) {
            usk1.update((long)i);
        }
        for (i = 256; i < 512; ++i) {
            usk2.update((long)i);
        }
        Assert.assertEquals((double)512.0, (double)(usk1.getEstimate() + usk2.getEstimate()), (double)0.0);
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)512)]);
        Union union = SetOperation.builder().setNominalEntries(512).buildUnion(uMem);
        union.union((Sketch)usk1);
        union.union((Sketch)usk2);
        HeapUnionTest.testAllCompactForms(union, 512.0, 0.0);
        Union union2 = Sketches.wrapUnion((WritableMemory)WritableMemory.writableWrap((byte[])union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 512.0, 0.0);
    }

    @Test
    public void checkWrapEstNoOverlap() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(8192).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        union.union((Sketch)usk1);
        union.union((Sketch)usk2);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
        Union union2 = Sketches.wrapUnion((WritableMemory)WritableMemory.writableWrap((byte[])union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 16384.0, 0.05);
    }

    @Test
    public void checkWrapEstNoOverlapOrderedIn() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(8192).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        CompactSketch cosk2 = usk2.compact(true, null);
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        union.union((Sketch)usk1);
        union.union((Sketch)cosk2);
        UpdateSketch emptySketch = UpdateSketch.builder().setNominalEntries(4096).build();
        union.union((Sketch)emptySketch);
        emptySketch = null;
        union.union((Sketch)emptySketch);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
        Union union2 = Sketches.wrapUnion((WritableMemory)WritableMemory.writableWrap((byte[])union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 16384.0, 0.05);
        union2.reset();
        Assert.assertEquals((double)union2.getResult(true, null).getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void checkWrapEstNoOverlapOrderedDirectIn() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(8192).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        WritableMemory cskMem2 = WritableMemory.writableWrap((byte[])new byte[usk2.getCompactBytes()]);
        CompactSketch cosk2 = usk2.compact(true, cskMem2);
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        union.union((Sketch)usk1);
        union.union((Sketch)cosk2);
        UpdateSketch emptySketch = UpdateSketch.builder().setNominalEntries(4096).build();
        union.union((Sketch)emptySketch);
        emptySketch = null;
        union.union((Sketch)emptySketch);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
        Union union2 = Sketches.wrapUnion((WritableMemory)WritableMemory.writableWrap((byte[])union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 16384.0, 0.05);
        union2.reset();
        Assert.assertEquals((double)union2.getResult(true, null).getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void checkWrapEstNoOverlapOrderedMemIn() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(8192).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        WritableMemory cskMem2 = WritableMemory.writableWrap((byte[])new byte[usk2.getCompactBytes()]);
        usk2.compact(true, cskMem2);
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        union.union((Sketch)usk1);
        union.union((Memory)cskMem2);
        UpdateSketch emptySketch = UpdateSketch.builder().setNominalEntries(4096).build();
        union.union((Sketch)emptySketch);
        emptySketch = null;
        union.union((Sketch)emptySketch);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
        Union union2 = Sketches.wrapUnion((WritableMemory)WritableMemory.writableWrap((byte[])union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 16384.0, 0.05);
        union2.reset();
        Assert.assertEquals((double)union2.getResult(true, null).getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void checkWrapEstNoOverlapUnorderedMemIn() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(8192).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        WritableMemory cskMem2 = WritableMemory.writableWrap((byte[])new byte[usk2.getCompactBytes()]);
        usk2.compact(false, cskMem2);
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        union.union((Sketch)usk1);
        union.union((Memory)cskMem2);
        UpdateSketch emptySketch = UpdateSketch.builder().setNominalEntries(4096).build();
        union.union((Sketch)emptySketch);
        emptySketch = null;
        union.union((Sketch)emptySketch);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
        Union union2 = Sketches.wrapUnion((WritableMemory)WritableMemory.writableWrap((byte[])union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 16384.0, 0.05);
        union2.reset();
        Assert.assertEquals((double)union2.getResult(true, null).getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void checkMultiUnion() {
        int i;
        int lgK = 13;
        int k = 8192;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(8192).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(8192).build();
        UpdateSketch usk3 = UpdateSketch.builder().setNominalEntries(8192).build();
        UpdateSketch usk4 = UpdateSketch.builder().setNominalEntries(8192).build();
        int v = 0;
        int u = 1000000;
        for (i = 0; i < u; ++i) {
            usk1.update((long)(i + v));
        }
        v += u;
        u = 26797;
        for (i = 0; i < u; ++i) {
            usk2.update((long)(i + v));
        }
        v += u;
        for (i = 0; i < u; ++i) {
            usk3.update((long)(i + v));
        }
        v += u;
        for (i = 0; i < u; ++i) {
            usk4.update((long)(i + v));
        }
        v += u;
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)8192)]);
        Union union = SetOperation.builder().setNominalEntries(8192).buildUnion(uMem);
        union.union((Sketch)usk1);
        union.union((Sketch)usk2);
        union.union((Sketch)usk3);
        union.union((Sketch)usk4);
        CompactSketch csk = union.getResult(true, null);
        double est = csk.getEstimate();
        Assert.assertEquals((double)est, (double)v, (double)(0.01 * (double)v));
    }

    @Test
    public void checkDirectMemoryIn() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u1 = 8192;
        int u2 = 1024;
        int totU = 9216;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(4096).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 9216; ++i) {
            usk2.update((long)i);
        }
        Memory skMem1 = Memory.wrap((byte[])usk1.compact(false, null).toByteArray());
        Memory skMem2 = Memory.wrap((byte[])usk2.compact(true, null).toByteArray());
        CompactSketch csk1 = (CompactSketch)Sketch.wrap((Memory)skMem1);
        CompactSketch csk2 = (CompactSketch)Sketch.wrap((Memory)skMem2);
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        union.union((Sketch)csk1);
        union.union((Sketch)csk2);
        CompactSketch cOut = union.getResult(true, null);
        Assert.assertEquals((double)cOut.getEstimate(), (double)9216.0, (double)204.8);
    }

    @Test
    public void checkSerVer1Handling() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u1 = 8192;
        int u2 = 1024;
        int totU = 9216;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(4096).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 9216; ++i) {
            usk2.update((long)i);
        }
        Memory v1mem1 = BackwardConversions.convertSerVer3toSerVer1(usk1.compact(true, null));
        Memory v1mem2 = BackwardConversions.convertSerVer3toSerVer1(usk2.compact(true, null));
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        union.union(v1mem1);
        union.union(v1mem2);
        CompactSketch cOut = union.getResult(true, null);
        Assert.assertEquals((double)cOut.getEstimate(), (double)9216.0, (double)204.8);
    }

    @Test
    public void checkSerVer2Handling() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u1 = 8192;
        int u2 = 1024;
        int totU = 9216;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(4096).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 9216; ++i) {
            usk2.update((long)i);
        }
        Memory v2mem1 = BackwardConversions.convertSerVer3toSerVer2(usk1.compact(true, null), 9001L);
        Memory v2mem2 = BackwardConversions.convertSerVer3toSerVer2(usk2.compact(true, null), 9001L);
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        union.union(v2mem1);
        union.union(v2mem2);
        CompactSketch cOut = union.getResult(true, null);
        Assert.assertEquals((double)cOut.getEstimate(), (double)9216.0, (double)204.8);
    }

    @Test
    public void checkUpdateMemorySpecialCases() {
        int lgK = 12;
        int k = 4096;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        CompactSketch usk1c = usk1.compact(true, null);
        WritableMemory v3mem1 = WritableMemory.writableWrap((byte[])usk1c.toByteArray());
        Memory v1mem1 = BackwardConversions.convertSerVer3toSerVer1(usk1c);
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        union.union(v1mem1);
        CompactSketch cOut = union.getResult(true, null);
        Assert.assertEquals((double)cOut.getEstimate(), (double)0.0, (double)0.0);
        Memory v2mem1 = BackwardConversions.convertSerVer3toSerVer2(usk1c, 9001L);
        uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        union.union(v2mem1);
        cOut = union.getResult(true, null);
        Assert.assertEquals((double)cOut.getEstimate(), (double)0.0, (double)0.0);
        uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        union.union((Memory)v3mem1);
        cOut = union.getResult(true, null);
        Assert.assertEquals((double)cOut.getEstimate(), (double)0.0, (double)0.0);
        uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        v3mem1 = null;
        union.union((Memory)v3mem1);
        cOut = union.getResult(true, null);
        Assert.assertEquals((double)cOut.getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void checkUpdateMemorySpecialCases2() {
        int lgK = 12;
        int k = 4096;
        int u = 8192;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        for (int i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        CompactSketch usk1c = usk1.compact(true, null);
        WritableMemory v3mem1 = WritableMemory.writableWrap((byte[])usk1c.toByteArray());
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        union.union((Memory)v3mem1);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMemBadSerVer() {
        int lgK = 12;
        int k = 4096;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        usk1.update(1L);
        usk1.update(2L);
        CompactSketch usk1c = usk1.compact(true, null);
        WritableMemory v3mem1 = WritableMemory.writableWrap((byte[])usk1c.toByteArray());
        v3mem1.putByte(1L, (byte)0);
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        union.union((Memory)v3mem1);
    }

    @Test
    public void checkEmptySerVer2and3() {
        int lgK = 12;
        int k = 4096;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        CompactSketch usk1c = usk1.compact(true, null);
        byte[] skArr = usk1c.toByteArray();
        byte[] skArr2 = Arrays.copyOf(skArr, skArr.length * 2);
        WritableMemory v3mem1 = WritableMemory.writableWrap((byte[])skArr2);
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        union.union((Memory)v3mem1);
        Memory v2mem1 = BackwardConversions.convertSerVer3toSerVer2(usk1c, 9001L);
        WritableMemory v2mem2 = WritableMemory.writableWrap((byte[])new byte[16]);
        v2mem1.copyTo(0L, v2mem2, 0L, 8L);
        uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        union.union((Memory)v2mem2);
    }

    @Test
    public void checkDirectWrap() {
        int nomEntries = 16;
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)16)]);
        SetOperation.builder().setNominalEntries(16).buildUnion(uMem);
        UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(16).build();
        sk1.update("a");
        sk1.update("b");
        UpdateSketch sk2 = UpdateSketch.builder().setNominalEntries(16).build();
        sk2.update("c");
        sk2.update("d");
        Union union = Sketches.wrapUnion((WritableMemory)uMem);
        union.union((Sketch)sk1);
        union = Sketches.wrapUnion((WritableMemory)uMem);
        union.union((Sketch)sk2);
        CompactSketch sketch = union.getResult(true, null);
        Assert.assertEquals((double)4.0, (double)sketch.getEstimate(), (double)0.0);
    }

    @Test
    public void checkEmptyUnionCompactResult() {
        int k = 64;
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)64)]);
        Union union = SetOperation.builder().setNominalEntries(64).buildUnion(uMem);
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[Sketch.getMaxCompactSketchBytes((int)0)]);
        CompactSketch csk = union.getResult(false, mem);
        Assert.assertTrue((boolean)csk.isEmpty());
    }

    @Test
    public void checkEmptyUnionCompactOrderedResult() {
        int k = 64;
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)64)]);
        Union union = SetOperation.builder().setNominalEntries(64).buildUnion(uMem);
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[Sketch.getMaxCompactSketchBytes((int)0)]);
        CompactSketch csk = union.getResult(true, mem);
        Assert.assertTrue((boolean)csk.isEmpty());
    }

    @Test
    public void checkUnionMemToString() {
        int k = 64;
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)64)]);
        SetOperation.builder().setNominalEntries(64).buildUnion(uMem);
    }

    @Test
    public void checkGetResult() {
        int k = 1024;
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        int memBytes = SetOperation.getMaxUnionBytes((int)1024);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        Union union = Sketches.setOperationBuilder().setNominalEntries(1024).buildUnion(iMem);
        union.union((Sketch)sk);
        CompactSketch csk = union.getResult();
        Assert.assertEquals((int)csk.getCompactBytes(), (int)8);
    }

    @Test
    public void checkPrimitiveUpdates() {
        int k = 32;
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)32)]);
        Union union = SetOperation.builder().setNominalEntries(32).buildUnion(uMem);
        union.update(1L);
        union.update(1.5);
        union.update(0.0);
        union.update(-0.0);
        String s = null;
        union.update(s);
        s = "";
        union.update(s);
        s = "String";
        union.update(s);
        byte[] byteArr = null;
        union.update(byteArr);
        byteArr = new byte[]{};
        union.update(byteArr);
        byteArr = "Byte Array".getBytes(StandardCharsets.UTF_8);
        union.update(byteArr);
        int[] intArr = null;
        union.update(intArr);
        intArr = new int[]{};
        union.update(intArr);
        int[] intArr2 = new int[]{1, 2, 3, 4, 5};
        union.update(intArr2);
        long[] longArr = null;
        union.update(longArr);
        longArr = new long[]{};
        union.update(longArr);
        long[] longArr2 = new long[]{6L, 7L, 8L, 9L};
        union.update(longArr2);
        CompactSketch comp = union.getResult();
        double est = comp.getEstimate();
        boolean empty = comp.isEmpty();
        Assert.assertEquals((double)est, (double)7.0, (double)0.0);
        Assert.assertFalse((boolean)empty);
    }

    @Test
    public void checkGetFamily() {
        int k = 16;
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[288]);
        SetOperation setOp = new SetOperationBuilder().setNominalEntries(16).build(Family.UNION, mem);
        Assert.assertEquals((Object)setOp.getFamily(), (Object)Family.UNION);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkPreambleLongsCorruption() {
        int k = 16;
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[288]);
        SetOperation setOp = new SetOperationBuilder().setNominalEntries(16).build(Family.UNION, mem);
        DirectUnionTest.println(setOp.toString());
        int familyID = PreambleUtil.extractFamilyID((Memory)mem);
        int preLongs = PreambleUtil.extractPreLongs((Memory)mem);
        Assert.assertEquals((int)familyID, (int)Family.UNION.getID());
        Assert.assertEquals((int)preLongs, (int)Family.UNION.getMaxPreLongs());
        PreambleUtil.insertPreLongs((WritableMemory)mem, (int)3);
        DirectQuickSelectSketch.writableWrap((WritableMemory)mem, (long)9001L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSizeTooSmall() {
        int k = 16;
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[288]);
        SetOperation setOp = new SetOperationBuilder().setNominalEntries(16).build(Family.UNION, mem);
        DirectUnionTest.println(setOp.toString());
        WritableMemory mem2 = WritableMemory.writableWrap((byte[])new byte[32]);
        mem.copyTo(0L, mem2, 0L, 32L);
        DirectQuickSelectSketch.writableWrap((WritableMemory)mem2, (long)9001L);
    }

    @Test
    public void checkForDruidBug() {
        int k = 16384;
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(16384).build();
        for (int i = 0; i < 100000; ++i) {
            usk.update(Integer.toString(i));
        }
        usk.rebuild();
        CompactSketch s = usk.compact();
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)16384)]);
        Union union1 = SetOperation.builder().setNominalEntries(16384).buildUnion(mem);
        union1.union((Sketch)s);
        CompactSketch csk = union1.getResult();
        Assert.assertTrue((csk.getTheta() < 0.2 ? 1 : 0) != 0);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)16384);
        double est = csk.getEstimate();
        Assert.assertTrue((est > 98663.0 ? 1 : 0) != 0);
        Assert.assertTrue((est < 101530.0 ? 1 : 0) != 0);
    }

    @Test
    public void checkForDruidBug2() {
        int k = 16384;
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(16384).build();
        for (int i = 0; i < 100000; ++i) {
            usk.update(Integer.toString(i));
        }
        usk.rebuild();
        WritableMemory memIn = WritableMemory.allocate((int)usk.getCompactBytes());
        usk.compact(true, memIn);
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)16384)]);
        Union union1 = SetOperation.builder().setNominalEntries(16384).buildUnion(mem);
        union1.union((Memory)memIn);
        CompactSketch csk = union1.getResult();
        Assert.assertTrue((csk.getTheta() < 0.2 ? 1 : 0) != 0);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)16384);
        double est = csk.getEstimate();
        Assert.assertTrue((est > 98663.0 ? 1 : 0) != 0);
        Assert.assertTrue((est < 101530.0 ? 1 : 0) != 0);
    }

    @Test
    public void printlnTest() {
        DirectUnionTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

