/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PreambleUtilTest {
    @Test
    public void checkInsertsAndExtracts() {
        int bytes = 32;
        try (WritableHandle offHeapMemHandler = WritableMemory.allocateDirect((long)32L);){
            WritableMemory offHeapMem = offHeapMemHandler.getWritable();
            WritableMemory onHeapMem = WritableMemory.writableWrap((byte[])new byte[32]);
            onHeapMem.clear();
            offHeapMem.clear();
            int v = 255;
            PreambleUtil.insertPreLongs((WritableMemory)onHeapMem, (int)v);
            int onH = PreambleUtil.extractPreLongs((Memory)onHeapMem);
            Assert.assertEquals((int)onH, (int)v);
            PreambleUtil.insertPreLongs((WritableMemory)offHeapMem, (int)v);
            int offH = PreambleUtil.extractPreLongs((Memory)offHeapMem);
            Assert.assertEquals((int)offH, (int)v);
            onHeapMem.clear();
            offHeapMem.clear();
            PreambleUtil.insertSerVer((WritableMemory)onHeapMem, (int)v);
            onH = PreambleUtil.extractSerVer((Memory)onHeapMem);
            Assert.assertEquals((int)onH, (int)v);
            PreambleUtil.insertSerVer((WritableMemory)offHeapMem, (int)v);
            offH = PreambleUtil.extractSerVer((Memory)offHeapMem);
            Assert.assertEquals((int)offH, (int)v);
            onHeapMem.clear();
            offHeapMem.clear();
            PreambleUtil.insertFamilyID((WritableMemory)onHeapMem, (int)v);
            onH = PreambleUtil.extractFamilyID((Memory)onHeapMem);
            Assert.assertEquals((int)onH, (int)v);
            PreambleUtil.insertFamilyID((WritableMemory)offHeapMem, (int)v);
            offH = PreambleUtil.extractFamilyID((Memory)offHeapMem);
            Assert.assertEquals((int)offH, (int)v);
            onHeapMem.clear();
            offHeapMem.clear();
            PreambleUtil.insertFlags((WritableMemory)onHeapMem, (int)v);
            onH = PreambleUtil.extractFlags((Memory)onHeapMem);
            Assert.assertEquals((int)onH, (int)v);
            PreambleUtil.insertFlags((WritableMemory)offHeapMem, (int)v);
            offH = PreambleUtil.extractFlags((Memory)offHeapMem);
            Assert.assertEquals((int)offH, (int)v);
            onHeapMem.clear();
            offHeapMem.clear();
            v = 65535;
            PreambleUtil.insertK((WritableMemory)onHeapMem, (int)v);
            onH = PreambleUtil.extractK((Memory)onHeapMem);
            Assert.assertEquals((int)onH, (int)v);
            PreambleUtil.insertK((WritableMemory)offHeapMem, (int)v);
            offH = PreambleUtil.extractK((Memory)offHeapMem);
            Assert.assertEquals((int)offH, (int)v);
            onHeapMem.clear();
            offHeapMem.clear();
            long vL = 0x40000000L;
            PreambleUtil.insertN((WritableMemory)onHeapMem, (long)vL);
            long onHL = PreambleUtil.extractN((Memory)onHeapMem);
            Assert.assertEquals((long)onHL, (long)vL);
            PreambleUtil.insertN((WritableMemory)offHeapMem, (long)vL);
            long offHL = PreambleUtil.extractN((Memory)offHeapMem);
            Assert.assertEquals((long)offHL, (long)vL);
            onHeapMem.clear();
            offHeapMem.clear();
            double vD = 1.099511627776E12;
            PreambleUtil.insertMinDouble((WritableMemory)onHeapMem, (double)vD);
            double onHD = PreambleUtil.extractMinDouble((Memory)onHeapMem);
            Assert.assertEquals((double)onHD, (double)vD);
            PreambleUtil.insertMinDouble((WritableMemory)offHeapMem, (double)vD);
            double offHD = PreambleUtil.extractMinDouble((Memory)offHeapMem);
            Assert.assertEquals((double)offHD, (double)vD);
            onHeapMem.clear();
            offHeapMem.clear();
            PreambleUtil.insertMaxDouble((WritableMemory)onHeapMem, (double)vD);
            onHD = PreambleUtil.extractMaxDouble((Memory)onHeapMem);
            Assert.assertEquals((double)onHD, (double)vD);
            PreambleUtil.insertMaxDouble((WritableMemory)offHeapMem, (double)vD);
            offHD = PreambleUtil.extractMaxDouble((Memory)offHeapMem);
            Assert.assertEquals((double)offHD, (double)vD);
            onHeapMem.clear();
            offHeapMem.clear();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkToString() {
        int k = 128;
        int n = 1000000;
        UpdateDoublesSketch qs = DoublesSketch.builder().setK(k).build();
        for (int i = 0; i < n; ++i) {
            qs.update((double)i);
        }
        byte[] byteArr = qs.toByteArray();
        DoublesSketch.toString((byte[])byteArr);
        PreambleUtilTest.println(DoublesSketch.toString((Memory)Memory.wrap((byte[])byteArr)));
    }

    @Test
    public void checkToStringEmpty() {
        int k = 128;
        UpdateDoublesSketch qs = DoublesSketch.builder().setK(k).build();
        byte[] byteArr = qs.toByteArray();
        PreambleUtilTest.println(PreambleUtil.toString((byte[])byteArr, (boolean)true));
    }

    @Test
    public void printlnTest() {
        PreambleUtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

