/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfBooleansSerDe;
import org.apache.datasketches.common.ArrayOfDoublesSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantiles.ItemsSketchSortedView;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantilescommon.GenericSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ItemsSketchTest {
    private static final boolean enablePrinting = false;

    @BeforeMethod
    public void setUp() {
        ItemsSketch.rand.setSeed(32749L);
    }

    @Test
    public void empty() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, (int)128, Comparator.naturalOrder());
        Assert.assertNotNull((Object)sketch);
        sketch.update(null);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)0);
        try {
            sketch.getMinItem();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getMaxItem();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantile(0.5);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantiles(new double[]{0.0, 1.0});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        byte[] byteArr = sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertEquals((int)byteArr.length, (int)8);
        try {
            sketch.getPMF((Object[])new String[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getCDF((Object[])new String[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getRank((Object)"a");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void oneItem() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, (int)128, Comparator.naturalOrder());
        sketch.update((Object)"a");
        Assert.assertEquals((long)sketch.getN(), (long)1L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)1);
        Assert.assertEquals((String)((String)sketch.getMinItem()), (String)"a");
        Assert.assertEquals((String)((String)sketch.getMaxItem()), (String)"a");
        Assert.assertEquals((String)((String)sketch.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE)), (String)"a");
        Assert.assertEquals((double)sketch.getRank((Object)"a", QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        double[] pmf = sketch.getPMF((Object[])new String[0], QuantileSearchCriteria.EXCLUSIVE);
        Assert.assertEquals((int)pmf.length, (int)1);
        Assert.assertEquals((double)pmf[0], (double)1.0);
        pmf = sketch.getPMF((Object[])new String[]{"a"}, QuantileSearchCriteria.EXCLUSIVE);
        Assert.assertEquals((int)pmf.length, (int)2);
        Assert.assertEquals((double)pmf[0], (double)0.0);
        Assert.assertEquals((double)pmf[1], (double)1.0);
        double[] cdf = sketch.getCDF((Object[])new String[0], QuantileSearchCriteria.EXCLUSIVE);
        Assert.assertEquals((int)cdf.length, (int)1);
        Assert.assertEquals((double)cdf[0], (double)1.0);
        cdf = sketch.getCDF((Object[])new String[]{"a"}, QuantileSearchCriteria.EXCLUSIVE);
        Assert.assertEquals((int)cdf.length, (int)2);
        Assert.assertEquals((double)cdf[0], (double)0.0);
        Assert.assertEquals((double)cdf[1], (double)1.0);
        sketch.reset();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)0);
        try {
            sketch.getMinItem();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getMaxItem();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantile(0.5);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void tenItems() {
        int i;
        int i2;
        int i3;
        ItemsSketch sketch = ItemsSketch.getInstance(Integer.class, (int)128, Comparator.naturalOrder());
        for (i3 = 1; i3 <= 10; ++i3) {
            sketch.update((Object)i3);
        }
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.hasMemory());
        Assert.assertFalse((boolean)sketch.isReadOnly());
        Assert.assertEquals((long)sketch.getN(), (long)10L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)10);
        for (i3 = 1; i3 <= 10; ++i3) {
            Assert.assertEquals((double)sketch.getRank((Object)i3), (double)((double)i3 / 10.0));
            Assert.assertEquals((double)sketch.getRank((Object)i3, QuantileSearchCriteria.EXCLUSIVE), (double)((double)(i3 - 1) / 10.0));
            Assert.assertEquals((double)sketch.getRank((Object)i3, QuantileSearchCriteria.INCLUSIVE), (double)((double)i3 / 10.0));
        }
        Object[] qArr = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        double[] rOut = sketch.getRanks(qArr);
        for (i2 = 0; i2 < qArr.length; ++i2) {
            Assert.assertEquals((double)rOut[i2], (double)((double)(i2 + 1) / 10.0));
        }
        rOut = sketch.getRanks(qArr, QuantileSearchCriteria.EXCLUSIVE);
        for (i2 = 0; i2 < qArr.length; ++i2) {
            Assert.assertEquals((double)rOut[i2], (double)((double)i2 / 10.0));
        }
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.0, QuantileSearchCriteria.EXCLUSIVE)), (int)1);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.1, QuantileSearchCriteria.EXCLUSIVE)), (int)2);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.2, QuantileSearchCriteria.EXCLUSIVE)), (int)3);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.3, QuantileSearchCriteria.EXCLUSIVE)), (int)4);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.4, QuantileSearchCriteria.EXCLUSIVE)), (int)5);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE)), (int)6);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.6, QuantileSearchCriteria.EXCLUSIVE)), (int)7);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.7, QuantileSearchCriteria.EXCLUSIVE)), (int)8);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.8, QuantileSearchCriteria.EXCLUSIVE)), (int)9);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.9, QuantileSearchCriteria.EXCLUSIVE)), (int)10);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(1.0, QuantileSearchCriteria.EXCLUSIVE)), (int)10);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.0, QuantileSearchCriteria.INCLUSIVE)), (int)1);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.1, QuantileSearchCriteria.INCLUSIVE)), (int)1);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.2, QuantileSearchCriteria.INCLUSIVE)), (int)2);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.3, QuantileSearchCriteria.INCLUSIVE)), (int)3);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.4, QuantileSearchCriteria.INCLUSIVE)), (int)4);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.5, QuantileSearchCriteria.INCLUSIVE)), (int)5);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.6, QuantileSearchCriteria.INCLUSIVE)), (int)6);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.7, QuantileSearchCriteria.INCLUSIVE)), (int)7);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.8, QuantileSearchCriteria.INCLUSIVE)), (int)8);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.9, QuantileSearchCriteria.INCLUSIVE)), (int)9);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(1.0, QuantileSearchCriteria.INCLUSIVE)), (int)10);
        Integer[] quantiles = (Integer[])sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0});
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((Object)sketch.getQuantile((double)i / 10.0), (Object)quantiles[i]);
        }
        quantiles = (Integer[])sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0}, QuantileSearchCriteria.INCLUSIVE);
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((Object)sketch.getQuantile((double)i / 10.0, QuantileSearchCriteria.INCLUSIVE), (Object)quantiles[i]);
        }
    }

    @Test
    public void estimation() {
        ItemsSketch sketch = ItemsSketch.getInstance(Integer.class, (int)128, Comparator.naturalOrder());
        for (int i = 1; i <= 1000; ++i) {
            sketch.update((Object)i);
        }
        Assert.assertEquals((long)sketch.getN(), (long)1000L);
        Assert.assertTrue((sketch.getNumRetained() < 1000 ? 1 : 0) != 0);
        Assert.assertEquals((Object)sketch.getMinItem(), (Object)1);
        Assert.assertEquals((Object)sketch.getMaxItem(), (Object)1000);
        Assert.assertEquals((float)((Integer)sketch.getQuantile(0.5)).intValue(), (float)Integer.valueOf(500).intValue(), (float)17.0f);
        double[] normRanks = new double[]{0.0, 0.5, 1.0};
        Integer[] quantiles = (Integer[])sketch.getQuantiles(normRanks);
        Assert.assertEquals((float)quantiles[1].intValue(), (float)Integer.valueOf(500).intValue(), (float)17.0f);
        double[] normRanks2 = new double[]{0.25, 0.5, 0.75};
        Integer[] quantiles2 = (Integer[])sketch.getQuantiles(normRanks2);
        Assert.assertEquals((float)quantiles2[0].intValue(), (float)Integer.valueOf(250).intValue(), (float)17.0f);
        Assert.assertEquals((float)quantiles2[1].intValue(), (float)Integer.valueOf(500).intValue(), (float)17.0f);
        Assert.assertEquals((float)quantiles2[2].intValue(), (float)Integer.valueOf(750).intValue(), (float)17.0f);
        double normErr = sketch.getNormalizedRankError(true);
        Assert.assertEquals((double)normErr, (double)0.0172, (double)0.001);
        ItemsSketchTest.println("" + normErr);
        double[] pmf = sketch.getPMF((Object[])new Integer[0]);
        Assert.assertEquals((int)pmf.length, (int)1);
        Assert.assertEquals((double)pmf[0], (double)1.0);
        pmf = sketch.getPMF((Object[])new Integer[]{500});
        Assert.assertEquals((int)pmf.length, (int)2);
        Assert.assertEquals((double)pmf[0], (double)0.5, (double)0.05);
        Assert.assertEquals((double)pmf[1], (double)0.5, (double)0.05);
        Object[] intArr = new Integer[50];
        for (int i = 0; i < 50; ++i) {
            intArr[i] = 20 * i + 10;
        }
        double[] pmf2 = sketch.getPMF(intArr);
        Assert.assertEquals((int)pmf2.length, (int)51);
        double[] cdf = sketch.getCDF((Object[])new Integer[0]);
        Assert.assertEquals((int)cdf.length, (int)1);
        Assert.assertEquals((double)cdf[0], (double)1.0);
        cdf = sketch.getCDF((Object[])new Integer[]{500});
        Assert.assertEquals((int)cdf.length, (int)2);
        Assert.assertEquals((double)cdf[0], (double)0.5, (double)0.05);
        Assert.assertEquals((double)cdf[1], (double)1.0, (double)0.05);
        Assert.assertEquals((double)sketch.getRank((Object)500), (double)0.5, (double)0.01);
    }

    @Test
    public void serializeDeserializeLong() {
        ItemsSketch sketch1 = ItemsSketch.getInstance(Long.class, (int)128, Comparator.naturalOrder());
        for (int i = 1; i <= 500; ++i) {
            sketch1.update((Object)i);
        }
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        byte[] bytes = sketch1.toByteArray((ArrayOfItemsSerDe)serDe);
        ItemsSketch sketch2 = ItemsSketch.getInstance(Long.class, (Memory)Memory.wrap((byte[])bytes), Comparator.naturalOrder(), (ArrayOfItemsSerDe)serDe);
        for (int i = 501; i <= 1000; ++i) {
            sketch2.update((Object)i);
        }
        Assert.assertEquals((long)sketch2.getN(), (long)1000L);
        Assert.assertTrue((sketch2.getNumRetained() < 1000 ? 1 : 0) != 0);
        Assert.assertEquals((Object)sketch2.getMinItem(), (Object)1L);
        Assert.assertEquals((Object)sketch2.getMaxItem(), (Object)1000L);
        Assert.assertEquals((float)((Long)sketch2.getQuantile(0.5)).longValue(), (float)Long.valueOf(500L).longValue(), (float)17.0f);
    }

    @Test
    public void serializeDeserializeDouble() {
        ItemsSketch sketch1 = ItemsSketch.getInstance(Double.class, (int)128, Comparator.naturalOrder());
        for (int i = 1; i <= 500; ++i) {
            sketch1.update((Object)i);
        }
        ArrayOfDoublesSerDe serDe = new ArrayOfDoublesSerDe();
        byte[] bytes = sketch1.toByteArray((ArrayOfItemsSerDe)serDe);
        ItemsSketch sketch2 = ItemsSketch.getInstance(Double.class, (Memory)Memory.wrap((byte[])bytes), Comparator.naturalOrder(), (ArrayOfItemsSerDe)serDe);
        for (int i = 501; i <= 1000; ++i) {
            sketch2.update((Object)i);
        }
        Assert.assertEquals((long)sketch2.getN(), (long)1000L);
        Assert.assertTrue((sketch2.getNumRetained() < 1000 ? 1 : 0) != 0);
        Assert.assertEquals((Object)sketch2.getMinItem(), (Object)1.0);
        Assert.assertEquals((Object)sketch2.getMaxItem(), (Object)1000.0);
        Assert.assertEquals((double)((Double)sketch2.getQuantile(0.5)), (double)500.0, (double)17.0);
    }

    @Test
    public void serializeDeserializeString() {
        Comparator<String> numericOrder = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                Integer i1 = Integer.parseInt(s1, 2);
                Integer i2 = Integer.parseInt(s2, 2);
                return i1.compareTo(i2);
            }
        };
        ItemsSketch sketch1 = ItemsSketch.getInstance(String.class, (int)128, (Comparator)numericOrder);
        for (int i = 1; i <= 500; ++i) {
            sketch1.update((Object)Integer.toBinaryString(i << 10));
        }
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        byte[] bytes = sketch1.toByteArray((ArrayOfItemsSerDe)serDe);
        ItemsSketch sketch2 = ItemsSketch.getInstance(String.class, (Memory)Memory.wrap((byte[])bytes), (Comparator)numericOrder, (ArrayOfItemsSerDe)serDe);
        for (int i = 501; i <= 1000; ++i) {
            sketch2.update((Object)Integer.toBinaryString(i << 10));
        }
        Assert.assertEquals((long)sketch2.getN(), (long)1000L);
        Assert.assertTrue((sketch2.getNumRetained() < 1000 ? 1 : 0) != 0);
        Assert.assertEquals((String)((String)sketch2.getMinItem()), (String)Integer.toBinaryString(1024));
        Assert.assertEquals((String)((String)sketch2.getMaxItem()), (String)Integer.toBinaryString(1024000));
        Assert.assertEquals((float)(Integer.parseInt((String)sketch2.getQuantile(0.5), 2) >> 10), (float)Integer.valueOf(500).intValue(), (float)17.0f);
    }

    @Test
    public void toStringCrudeCheck() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, Comparator.naturalOrder());
        String brief = sketch.toString();
        String full = sketch.toString(true, true);
        String part = sketch.toString(false, true);
        sketch.update((Object)"a");
        brief = sketch.toString();
        full = sketch.toString(true, true);
        part = sketch.toString(false, true);
        Assert.assertTrue((brief.length() < full.length() ? 1 : 0) != 0);
        Assert.assertTrue((part.length() < full.length() ? 1 : 0) != 0);
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        byte[] bytes = sketch.toByteArray((ArrayOfItemsSerDe)serDe);
        ItemsSketch.toString((byte[])bytes);
        ItemsSketch.toString((Memory)Memory.wrap((byte[])bytes));
    }

    @Test
    public void toStringBiggerCheck() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, (int)16, Comparator.naturalOrder());
        for (int i = 0; i < 40; ++i) {
            sketch.update((Object)Integer.toString(i));
        }
        String bigger = sketch.toString();
        String full = sketch.toString(true, true);
        Assert.assertTrue((bigger.length() < full.length() ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkDownsampleException() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, (int)16, Comparator.naturalOrder());
        for (int i = 0; i < 40; ++i) {
            sketch.update((Object)Integer.toString(i));
        }
        sketch.downSample(32);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void negativeQuantileMustThrow() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, (int)16, Comparator.naturalOrder());
        sketch.update((Object)"ABC");
        sketch.getQuantile(-0.1);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkGetInstanceExcep1() {
        Memory mem = Memory.wrap((byte[])new byte[4]);
        ItemsSketch.getInstance(String.class, (Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkGetInstanceExcep2() {
        Memory mem = Memory.wrap((byte[])new byte[8]);
        ItemsSketch.getInstance(String.class, (Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test
    public void checkGoodSerDeId() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, Comparator.naturalOrder());
        byte[] byteArr = sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Memory mem = Memory.wrap((byte[])byteArr);
        ItemsSketch.getInstance(String.class, (Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test
    public void checkDownsample() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, (int)16, Comparator.naturalOrder());
        for (int i = 0; i < 40; ++i) {
            sketch.update((Object)Integer.toString(i));
        }
        ItemsSketch out = sketch.downSample(8);
        Assert.assertEquals((int)out.getK(), (int)8);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void unorderedSplitPoints() {
        ItemsSketch sketch = ItemsSketch.getInstance(Integer.class, Comparator.naturalOrder());
        sketch.update((Object)1);
        sketch.getPMF((Object[])new Integer[]{2, 1});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void nonUniqueSplitPoints() {
        ItemsSketch sketch = ItemsSketch.getInstance(Integer.class, Comparator.naturalOrder());
        sketch.update((Object)1);
        sketch.getPMF((Object[])new Integer[]{1, 1});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void nullInSplitPoints() {
        ItemsSketch sketch = ItemsSketch.getInstance(Integer.class, Comparator.naturalOrder());
        sketch.update((Object)1);
        sketch.getPMF((Object[])new Integer[]{1, null});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void compactNotSupported() {
        ArrayOfDoublesSerDe serDe = new ArrayOfDoublesSerDe();
        ItemsSketch sketch = ItemsSketch.getInstance(Double.class, Comparator.naturalOrder());
        byte[] byteArr = sketch.toByteArray((ArrayOfItemsSerDe)serDe);
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArr);
        mem.clearBits(3L, (byte)8);
        ItemsSketchTest.println(PreambleUtil.toString((Memory)mem, (boolean)false));
        ItemsSketch.getInstance(Double.class, (Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)serDe);
    }

    @Test
    public void checkPutMemory() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, (int)16, Comparator.naturalOrder());
        for (int i = 0; i < 40; ++i) {
            sketch.update((Object)Integer.toString(i));
        }
        byte[] byteArr = new byte[200];
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArr);
        sketch.putMemory(mem, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkPutMemoryException() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, (int)16, Comparator.naturalOrder());
        for (int i = 0; i < 40; ++i) {
            sketch.update((Object)Integer.toString(i));
        }
        byte[] byteArr = new byte[100];
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArr);
        sketch.putMemory(mem, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test
    public void checkPMFonEmpty() {
        ItemsSketch<String> iss = ItemsSketchTest.buildStringIS(32, 32);
        double[] ranks = new double[]{};
        String[] qOut = (String[])iss.getQuantiles(ranks);
        ItemsSketchTest.println("qOut: " + qOut.length);
        Assert.assertEquals((int)qOut.length, (int)0);
        double[] cdfOut = iss.getCDF((Object[])new String[0]);
        ItemsSketchTest.println("cdfOut: " + cdfOut.length);
        Assert.assertEquals((double)cdfOut[0], (double)1.0, (double)0.0);
    }

    @Test
    public void checkToFromByteArray() {
        ItemsSketchTest.checkToFromByteArray2(128, 1300);
        ItemsSketchTest.checkToFromByteArray2(4, 7);
        ItemsSketchTest.checkToFromByteArray2(4, 8);
        ItemsSketchTest.checkToFromByteArray2(4, 9);
    }

    @Test
    public void getRankAndGetCdfConsistency() {
        int i;
        ItemsSketch sketch = ItemsSketch.getInstance(Integer.class, Comparator.naturalOrder());
        int n = 1000000;
        Object[] values = new Integer[1000000];
        for (int i2 = 0; i2 < 1000000; ++i2) {
            sketch.update((Object)i2);
            values[i2] = i2;
        }
        double[] ranks = sketch.getCDF(values);
        for (i = 0; i < 1000000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]), (double)1.0E-5, (String)("CDF vs rank for value " + i));
        }
        ranks = sketch.getCDF(values, QuantileSearchCriteria.INCLUSIVE);
        for (i = 0; i < 1000000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i], QuantileSearchCriteria.INCLUSIVE), (double)1.0E-5, (String)("CDF vs rank for value " + i));
        }
    }

    @Test
    public void getRankAndGetCdfConsistencyReverseComparator() {
        ItemsSketch sketch = ItemsSketch.getInstance(Integer.class, Comparator.naturalOrder().reversed());
        int n = 1000000;
        Object[] values = new Integer[1000000];
        for (int i = 0; i < 1000000; ++i) {
            sketch.update((Object)i);
            values[i] = i;
        }
        Arrays.sort(values, sketch.getComparator());
        double[] ranks = sketch.getCDF(values);
        for (int i = 0; i < 1000000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]), (double)1.0E-5, (String)("CDF vs rank for value " + i));
        }
    }

    @Test
    public void checkBounds() {
        ItemsSketch sketch = ItemsSketch.getInstance(Double.class, Comparator.naturalOrder());
        for (int i = 0; i < 1000; ++i) {
            sketch.update((Object)i);
        }
        double eps = sketch.getNormalizedRankError(false);
        double est = (Double)sketch.getQuantile(0.5);
        double ub = (Double)sketch.getQuantileUpperBound(0.5);
        double lb = (Double)sketch.getQuantileLowerBound(0.5);
        Assert.assertEquals((double)ub, (double)((Double)sketch.getQuantile(0.5 + eps)));
        Assert.assertEquals((double)lb, (double)((Double)sketch.getQuantile(0.5 - eps)));
        ItemsSketchTest.println("Ext     : " + est);
        ItemsSketchTest.println("UB      : " + ub);
        ItemsSketchTest.println("LB      : " + lb);
    }

    @Test
    public void checkGetKFromEqs() {
        ItemsSketch sketch = ItemsSketch.getInstance(Double.class, Comparator.naturalOrder());
        int k = sketch.getK();
        double eps = ItemsSketch.getNormalizedRankError((int)k, (boolean)false);
        double epsPmf = ItemsSketch.getNormalizedRankError((int)k, (boolean)true);
        int kEps = ItemsSketch.getKFromEpsilon((double)eps, (boolean)false);
        int kEpsPmf = ItemsSketch.getKFromEpsilon((double)epsPmf, (boolean)true);
        Assert.assertEquals((int)kEps, (int)k);
        Assert.assertEquals((int)kEpsPmf, (int)k);
    }

    private static void checkToFromByteArray2(int k, int n) {
        double f;
        ItemsSketch<String> is = ItemsSketchTest.buildStringIS(k, n);
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        byte[] byteArr = is.toByteArray(true, (ArrayOfItemsSerDe)serDe);
        Memory mem = Memory.wrap((byte[])byteArr);
        ItemsSketch is2 = ItemsSketch.getInstance(String.class, (Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)serDe);
        for (f = 0.1; f < 0.95; f += 0.1) {
            Assert.assertEquals((String)((String)is.getQuantile(f)), (String)((String)is2.getQuantile(f)));
        }
        byteArr = is.toByteArray(false, (ArrayOfItemsSerDe)serDe);
        mem = Memory.wrap((byte[])byteArr);
        is2 = ItemsSketch.getInstance(String.class, (Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)serDe);
        for (f = 0.1; f < 0.95; f += 0.1) {
            Assert.assertEquals((String)((String)is.getQuantile(f)), (String)((String)is2.getQuantile(f)));
        }
    }

    static ItemsSketch<String> buildStringIS(int k, int n) {
        return ItemsSketchTest.buildStringIS(k, n, 0);
    }

    static ItemsSketch<String> buildStringIS(int k, int n, int start) {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, (int)k, Comparator.naturalOrder());
        for (int i = 0; i < n; ++i) {
            sketch.update((Object)Integer.toString(i + start));
        }
        return sketch;
    }

    @Test
    public void sortedView() {
        ItemsSketch sketch = ItemsSketch.getInstance(Integer.class, Comparator.naturalOrder());
        sketch.update((Object)3);
        sketch.update((Object)1);
        sketch.update((Object)2);
        ItemsSketchSortedView view = sketch.getSortedView();
        GenericSortedViewIterator it = view.iterator();
        Assert.assertEquals((boolean)it.next(), (boolean)true);
        Assert.assertEquals((Integer)((Integer)it.getQuantile()), (int)1);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertEquals((long)it.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)1L);
        Assert.assertEquals((boolean)it.next(), (boolean)true);
        Assert.assertEquals((Integer)((Integer)it.getQuantile()), (int)2);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertEquals((long)it.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)2L);
        Assert.assertEquals((boolean)it.next(), (boolean)true);
        Assert.assertEquals((Integer)((Integer)it.getQuantile()), (int)3);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertEquals((long)it.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)3L);
        Assert.assertEquals((boolean)it.next(), (boolean)false);
    }

    @Test
    public void sortedView2() {
        Object[] qArr = new Double[]{8.0, 10.0, 10.0, 20.0};
        long[] cwArr = new long[]{1L, 3L, 4L, 5L};
        Comparator comp = Comparator.naturalOrder();
        ItemsSketchSortedView sv = new ItemsSketchSortedView(qArr, cwArr, 5L, comp, (Object)20.0, (Object)8.0);
        double[] ranks = new double[]{0.0, 0.1, 0.2, 0.3, 0.6, 0.7, 0.8, 0.9, 1.0};
        Double[] qOut = new Double[9];
        for (int i = 0; i < ranks.length; ++i) {
            qOut[i] = (Double)sv.getQuantile(ranks[i], QuantileSearchCriteria.EXCLUSIVE);
            ItemsSketchTest.println("rank: " + ranks[i] + ", quantiles: " + qOut[i]);
        }
        long[] cumWts = sv.getCumulativeWeights();
        Double[] quants = (Double[])sv.getQuantiles();
        for (int i = 0; i < qArr.length; ++i) {
            Assert.assertEquals((Object)quants[i], (Object)qArr[i]);
            Assert.assertEquals((long)cumWts[i], (long)cwArr[i]);
        }
    }

    @Test
    public void getQuantiles() {
        ItemsSketch sketch = ItemsSketch.getInstance(Integer.class, Comparator.naturalOrder());
        sketch.update((Object)1);
        sketch.update((Object)2);
        sketch.update((Object)3);
        sketch.update((Object)4);
        Object[] quantiles1 = (Integer[])sketch.getQuantiles(new double[]{0.0, 0.5, 1.0}, QuantileSearchCriteria.EXCLUSIVE);
        Object[] quantiles2 = (Integer[])sketch.getPartitionBoundaries(2, QuantileSearchCriteria.EXCLUSIVE).getBoundaries();
        Assert.assertEquals((Object[])quantiles1, (Object[])quantiles2);
        quantiles1 = (Integer[])sketch.getQuantiles(new double[]{0.0, 0.5, 1.0}, QuantileSearchCriteria.INCLUSIVE);
        quantiles2 = (Integer[])sketch.getPartitionBoundaries(2, QuantileSearchCriteria.INCLUSIVE).getBoundaries();
        Assert.assertEquals((Object[])quantiles1, (Object[])quantiles2);
    }

    @Test
    public void checkIssue484() {
        Boolean[] items = new Boolean[]{true, false, true, false, true, false, true, false, true, false};
        ItemsSketch sketch = ItemsSketch.getInstance(Boolean.class, Boolean::compareTo);
        for (int i = 0; i < items.length; ++i) {
            sketch.update((Object)items[i]);
        }
        byte[] serialized = sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfBooleansSerDe());
        ItemsSketch deserialized = ItemsSketch.getInstance(Boolean.class, (Memory)Memory.wrap((byte[])serialized), Boolean::compareTo, (ArrayOfItemsSerDe)new ArrayOfBooleansSerDe());
        ItemsSketchTest.checkSketchesEqual(sketch, deserialized);
    }

    private static <T> void checkSketchesEqual(ItemsSketch<T> expected, ItemsSketch<T> actual) {
        ItemsSketchSortedView expSV = expected.getSortedView();
        ItemsSketchSortedView actSV = actual.getSortedView();
        int N = (int)actSV.getN();
        long[] expCumWts = expSV.getCumulativeWeights();
        Object[] expItemsArr = (Boolean[])expSV.getQuantiles();
        long[] actCumWts = actSV.getCumulativeWeights();
        Object[] actItemsArr = (Boolean[])actSV.getQuantiles();
        ItemsSketchTest.printf("%3s %8s %8s\n", "i", "Actual", "Expected");
        for (int i = 0; i < N; ++i) {
            ItemsSketchTest.printf("%3d %8s %8s\n", i, ((Boolean)actItemsArr[i]).toString(), ((Boolean)expItemsArr[i]).toString());
        }
        Assert.assertEquals((long[])actCumWts, (long[])expCumWts);
        Assert.assertEquals((Object[])actItemsArr, (Object[])expItemsArr);
    }

    @Test
    public void printlnTest() {
        ItemsSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

