/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchTest;
import org.apache.datasketches.quantiles.HeapCompactDoublesSketch;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HeapCompactDoublesSketchTest {
    @BeforeMethod
    public void setUp() {
        DoublesSketch.rand.setSeed(32749L);
    }

    @Test
    public void heapifyFromUpdateSketch() {
        int k = 4;
        int n = 45;
        UpdateDoublesSketch qs = HeapCompactDoublesSketchTest.buildAndLoadQS(4, 45);
        byte[] qsBytes = qs.toByteArray();
        Memory qsMem = Memory.wrap((byte[])qsBytes);
        HeapCompactDoublesSketch compactQs = HeapCompactDoublesSketch.heapifyInstance((Memory)qsMem);
        DoublesSketchTest.testSketchEquality((DoublesSketch)qs, (DoublesSketch)compactQs);
        Assert.assertNull((Object)compactQs.getMemory());
    }

    @Test
    public void createFromUnsortedUpdateSketch() {
        int k = 4;
        int n = 13;
        UpdateDoublesSketch qs = DoublesSketch.builder().setK(4).build();
        for (int i = 13; i > 0; --i) {
            qs.update((double)i);
        }
        HeapCompactDoublesSketch compactQs = HeapCompactDoublesSketch.createFromUpdateSketch((UpdateDoublesSketch)qs);
        HeapCompactDoublesSketchTest.checkBaseBufferIsSorted(compactQs);
    }

    @Test
    public void heapifyFromCompactSketch() {
        int k = 8;
        int n = 177;
        UpdateDoublesSketch qs = HeapCompactDoublesSketchTest.buildAndLoadQS(8, 177);
        byte[] qsBytes = qs.compact().toByteArray();
        Memory qsMem = Memory.wrap((byte[])qsBytes);
        HeapCompactDoublesSketch compactQs = HeapCompactDoublesSketch.heapifyInstance((Memory)qsMem);
        DoublesSketchTest.testSketchEquality((DoublesSketch)qs, (DoublesSketch)compactQs);
    }

    @Test
    public void checkHeapifyUnsortedCompactV2() {
        int k = 64;
        UpdateDoublesSketch qs = DoublesSketch.builder().setK(64).build();
        for (int i = 0; i < 192; ++i) {
            qs.update((double)i);
        }
        Assert.assertEquals((int)qs.getBaseBufferCount(), (int)64);
        byte[] sketchBytes = qs.toByteArray(true);
        WritableMemory mem = WritableMemory.writableWrap((byte[])sketchBytes);
        PreambleUtil.insertSerVer((WritableMemory)mem, (int)2);
        PreambleUtil.insertFlags((WritableMemory)mem, (int)0);
        long tgtAddr = 288L;
        mem.putDouble(288L, -1.0);
        assert (mem.getDouble(280L) > mem.getDouble(288L));
        HeapCompactDoublesSketch qs2 = HeapCompactDoublesSketch.heapifyInstance((Memory)mem);
        HeapCompactDoublesSketchTest.checkBaseBufferIsSorted(qs2);
    }

    @Test
    public void checkEmpty() {
        int k = 128;
        UpdateDoublesSketch qs1 = HeapCompactDoublesSketchTest.buildAndLoadQS(128, 0);
        byte[] byteArr = qs1.compact().toByteArray();
        byte[] byteArr2 = qs1.toByteArray(true);
        Memory mem = Memory.wrap((byte[])byteArr);
        HeapCompactDoublesSketch qs2 = HeapCompactDoublesSketch.heapifyInstance((Memory)mem);
        Assert.assertTrue((boolean)qs2.isEmpty());
        Assert.assertEquals((int)byteArr.length, (int)qs1.getSerializedSizeBytes());
        Assert.assertEquals((byte[])byteArr, (byte[])byteArr2);
        try {
            qs2.getQuantile(0.5);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            qs2.getQuantiles(new double[]{0.0, 0.5, 1.0});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            qs2.getRank(0.0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMemTooSmall1() {
        Memory mem = Memory.wrap((byte[])new byte[7]);
        HeapCompactDoublesSketch.heapifyInstance((Memory)mem);
    }

    static void checkBaseBufferIsSorted(HeapCompactDoublesSketch qs) {
        double[] combinedBuffer = qs.getCombinedBuffer();
        int bbCount = qs.getBaseBufferCount();
        for (int i = 1; i < bbCount; ++i) {
            assert (combinedBuffer[i - 1] <= combinedBuffer[i]);
        }
    }

    static UpdateDoublesSketch buildAndLoadQS(int k, int n) {
        return HeapCompactDoublesSketchTest.buildAndLoadQS(k, n, 0);
    }

    static UpdateDoublesSketch buildAndLoadQS(int k, int n, int startV) {
        UpdateDoublesSketch qs = DoublesSketch.builder().setK(k).build();
        for (int i = 1; i <= n; ++i) {
            qs.update((double)(startV + i));
        }
        return qs;
    }

    @Test
    public void printlnTest() {
        HeapCompactDoublesSketchTest.println("PRINTING: " + this.getClass().getName());
        HeapCompactDoublesSketchTest.print("PRINTING: " + this.getClass().getName() + ClassicUtil.LS);
    }

    static void println(String s) {
        HeapCompactDoublesSketchTest.print(s + ClassicUtil.LS);
    }

    static void print(String s) {
    }
}

