/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDirectFloatsSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHeapFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.FloatsSortedView;
import org.apache.datasketches.quantilescommon.FloatsSortedViewIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllMiscFloatsTest {
    static final String LS = System.getProperty("line.separator");
    private final MemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();
    private static final boolean enablePrinting = false;

    @Test
    public void checkSortedViewConstruction() {
        KllFloatsSketch kll = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 20; ++i) {
            kll.update((float)i);
        }
        FloatsSortedView fsv = kll.getSortedView();
        long[] cumWeights = fsv.getCumulativeWeights();
        float[] values = fsv.getQuantiles();
        Assert.assertEquals((int)cumWeights.length, (int)20);
        Assert.assertEquals((int)values.length, (int)20);
        for (int i = 0; i < 20; ++i) {
            Assert.assertEquals((long)cumWeights[i], (long)(i + 1));
            Assert.assertEquals((float)values[i], (float)(i + 1));
        }
    }

    @Test
    public void checkBounds() {
        KllFloatsSketch kll = KllFloatsSketch.newHeapInstance();
        for (int i = 0; i < 1000; ++i) {
            kll.update((float)i);
        }
        double eps = kll.getNormalizedRankError(false);
        float est = kll.getQuantile(0.5);
        float ub = kll.getQuantileUpperBound(0.5);
        float lb = kll.getQuantileLowerBound(0.5);
        Assert.assertEquals((float)ub, (float)kll.getQuantile(0.5 + eps));
        Assert.assertEquals((float)lb, (float)kll.getQuantile(0.5 - eps));
        KllMiscFloatsTest.println("Ext     : " + est);
        KllMiscFloatsTest.println("UB      : " + ub);
        KllMiscFloatsTest.println("LB      : " + lb);
        double rest = kll.getRank(est);
        double restUB = kll.getRankUpperBound(rest);
        double restLB = kll.getRankLowerBound(rest);
        Assert.assertTrue((restUB - rest < 2.0 * eps ? 1 : 0) != 0);
        Assert.assertTrue((rest - restLB < 2.0 * eps ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions1() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(6L, (byte)3);
        KllFloatsSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions2() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(0L, (byte)1);
        KllFloatsSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions3() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        sk.update(1.0f);
        sk.update(2.0f);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(0L, (byte)1);
        KllFloatsSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions4() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(1L, (byte)0);
        KllFloatsSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions5() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(2L, (byte)0);
        KllFloatsSketch.heapify((Memory)wmem);
    }

    @Test
    public void checkMisc() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)8);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        KllMiscFloatsTest.println(sk.toString(true, true));
        for (int i = 0; i < 20; ++i) {
            sk.update((float)i);
        }
        KllMiscFloatsTest.println(sk.toString(true, true));
        sk.toByteArray();
        float[] items = sk.getFloatItemsArray();
        Assert.assertEquals((int)items.length, (int)16);
        int[] levels = sk.getLevelsArray(sk.sketchStructure);
        Assert.assertEquals((int)levels.length, (int)3);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
    }

    @Test
    public void visualCheckToString() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        int n = 21;
        for (int i = 1; i <= n; ++i) {
            sk.update((float)i);
        }
        KllMiscFloatsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
        Assert.assertEquals((float)sk.getMaxItem(), (float)21.0f);
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        KllFloatsSketch sk2 = KllFloatsSketch.newHeapInstance((int)20);
        n = 400;
        for (int i = 101; i <= n + 100; ++i) {
            sk2.update((float)i);
        }
        KllMiscFloatsTest.println("\n" + sk2.toString(true, true));
        Assert.assertEquals((int)sk2.getNumLevels(), (int)5);
        Assert.assertEquals((float)sk2.getMinItem(), (float)101.0f);
        Assert.assertEquals((float)sk2.getMaxItem(), (float)500.0f);
        Assert.assertEquals((int)sk2.getNumRetained(), (int)52);
        sk2.merge((KllSketch)sk);
        KllMiscFloatsTest.println(LS + sk2.toString(true, true));
        Assert.assertEquals((int)sk2.getNumLevels(), (int)5);
        Assert.assertEquals((float)sk2.getMinItem(), (float)1.0f);
        Assert.assertEquals((float)sk2.getMaxItem(), (float)500.0f);
        Assert.assertEquals((int)sk2.getNumRetained(), (int)56);
    }

    @Test
    public void viewHeapCompactions() {
        int k = 20;
        int n = 108;
        int compaction = 0;
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= n; ++i) {
            sk.update((float)i);
            if (sk.levelsArr[0] != 0) continue;
            KllMiscFloatsTest.println(LS + "#<<< BEFORE COMPACTION # " + ++compaction + " >>>");
            KllMiscFloatsTest.println(sk.toString(true, true));
            sk.update((float)(++i));
            KllMiscFloatsTest.println(LS + "#<<< AFTER COMPACTION  # " + compaction + " >>>");
            KllMiscFloatsTest.println(sk.toString(true, true));
            Assert.assertEquals((float)sk.getFloatItemsArray()[sk.levelsArr[0]], (float)i);
        }
    }

    @Test
    public void viewDirectCompactions() {
        int k = 20;
        int n = 108;
        int sizeBytes = KllSketch.getMaxSerializedSizeBytes((int)k, (long)n, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        WritableMemory wmem = WritableMemory.allocate((int)sizeBytes);
        KllFloatsSketch sk = KllFloatsSketch.newDirectInstance((int)k, (WritableMemory)wmem, (MemoryRequestServer)this.memReqSvr);
        for (int i = 1; i <= n; ++i) {
            sk.update((float)i);
            if (sk.levelsArr[0] != 0) continue;
            KllMiscFloatsTest.println(sk.toString(true, true));
            sk.update((float)(++i));
            KllMiscFloatsTest.println(sk.toString(true, true));
            Assert.assertEquals((float)sk.getFloatItemsArray()[sk.levelsArr[0]], (float)i);
        }
    }

    @Test
    public void viewCompactionAndSortedView() {
        int n = 43;
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= n; ++i) {
            sk.update((float)i);
        }
        KllMiscFloatsTest.println(sk.toString(true, true));
        FloatsSortedView sv = sk.getSortedView();
        FloatsSortedViewIterator itr = sv.iterator();
        KllMiscFloatsTest.println("### SORTED VIEW");
        KllMiscFloatsTest.printf("%12s%12s\n", "Value", "CumWeight");
        while (itr.next()) {
            float v = itr.getQuantile();
            long wt = itr.getWeight();
            KllMiscFloatsTest.printf("%12.1f%12d\n", Float.valueOf(v), wt);
        }
    }

    @Test
    public void checkGrowLevels() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((float)i);
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure)[2], (int)33);
    }

    @Test
    public void checkSketchInitializeFloatHeap() {
        int k = 20;
        KllMiscFloatsTest.println("#### CASE: FLOAT FULL HEAP");
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((float)i);
        }
        KllMiscFloatsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((float)sk.getMaxItem(), (float)21.0f);
        Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscFloatsTest.println("#### CASE: FLOAT HEAP EMPTY");
        sk = KllFloatsSketch.newHeapInstance((int)k);
        KllMiscFloatsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscFloatsTest.println("#### CASE: FLOAT HEAP SINGLE");
        sk = KllFloatsSketch.newHeapInstance((int)k);
        sk.update(1.0f);
        KllMiscFloatsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((float)sk.getMaxItem(), (float)1.0f);
        Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeFloatHeapifyCompactMem() {
        int k = 20;
        KllMiscFloatsTest.println("#### CASE: FLOAT FULL HEAPIFIED FROM COMPACT");
        KllFloatsSketch sk2 = KllFloatsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((float)i);
        }
        byte[] compBytes = sk2.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllMiscFloatsTest.println(KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true));
        KllFloatsSketch sk = KllFloatsSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((float)sk.getMaxItem(), (float)21.0f);
        Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscFloatsTest.println("#### CASE: FLOAT EMPTY HEAPIFIED FROM COMPACT");
        sk2 = KllFloatsSketch.newHeapInstance((int)k);
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllFloatsSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscFloatsTest.println("#### CASE: FLOAT SINGLE HEAPIFIED FROM COMPACT");
        sk2 = KllFloatsSketch.newHeapInstance((int)k);
        sk2.update(1.0f);
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllFloatsSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((float)sk.getMaxItem(), (float)1.0f);
        Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeFloatHeapifyUpdatableMem() {
        int k = 20;
        KllMiscFloatsTest.println("#### CASE: FLOAT FULL HEAPIFIED FROM UPDATABLE");
        KllFloatsSketch sk2 = KllFloatsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((float)i);
        }
        byte[] compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllMiscFloatsTest.println(KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true));
        KllHeapFloatsSketch sk = KllHeapFloatsSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((float)sk.getMaxItem(), (float)21.0f);
        Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscFloatsTest.println("#### CASE: FLOAT EMPTY HEAPIFIED FROM UPDATABLE");
        sk2 = KllFloatsSketch.newHeapInstance((int)k);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllHeapFloatsSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscFloatsTest.println("#### CASE: FLOAT SINGLE HEAPIFIED FROM UPDATABLE");
        sk2 = KllFloatsSketch.newHeapInstance((int)k);
        sk2.update(1.0f);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllHeapFloatsSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((float)sk.getMaxItem(), (float)1.0f);
        Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkMemoryToStringFloatCompact() {
        int k = 20;
        KllMiscFloatsTest.println("#### CASE: FLOAT FULL COMPACT");
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((float)i);
        }
        byte[] compBytes = sk.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        String s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscFloatsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscFloatsTest.println(s);
        KllFloatsSketch sk2 = KllFloatsSketch.heapify((Memory)wmem);
        byte[] compBytes2 = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscFloatsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscFloatsTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
        KllMiscFloatsTest.println("#### CASE: FLOAT EMPTY COMPACT");
        sk = KllFloatsSketch.newHeapInstance((int)k);
        compBytes = sk.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscFloatsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscFloatsTest.println(s);
        sk2 = KllFloatsSketch.heapify((Memory)wmem);
        compBytes2 = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscFloatsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscFloatsTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
        KllMiscFloatsTest.println("#### CASE: FLOAT SINGLE COMPACT");
        sk = KllFloatsSketch.newHeapInstance((int)k);
        sk.update(1.0f);
        compBytes = sk.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscFloatsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscFloatsTest.println(s);
        sk2 = KllFloatsSketch.heapify((Memory)wmem);
        compBytes2 = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscFloatsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscFloatsTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
    }

    @Test
    public void checkMemoryToStringFloatUpdatable() {
        int k = 20;
        KllMiscFloatsTest.println("#### CASE: FLOAT FULL UPDATABLE");
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((float)i);
        }
        byte[] upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])upBytes);
        String s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscFloatsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscFloatsTest.println(s);
        KllHeapFloatsSketch sk2 = KllHeapFloatsSketch.heapifyImpl((Memory)wmem);
        byte[] upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscFloatsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscFloatsTest.println(s);
        Assert.assertEquals((long)sk.getN(), (long)sk2.getN());
        Assert.assertEquals((float)sk.getMinItem(), (float)sk2.getMinItem());
        Assert.assertEquals((float)sk.getMaxItem(), (float)sk2.getMaxItem());
        Assert.assertEquals((int)sk.getNumRetained(), (int)sk2.getNumRetained());
        KllMiscFloatsTest.println("#### CASE: FLOAT EMPTY UPDATABLE");
        sk = KllFloatsSketch.newHeapInstance((int)k);
        upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscFloatsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscFloatsTest.println(s);
        sk2 = KllHeapFloatsSketch.heapifyImpl((Memory)wmem);
        upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscFloatsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscFloatsTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
        KllMiscFloatsTest.println("#### CASE: FLOAT SINGLE UPDATABLE");
        sk = KllFloatsSketch.newHeapInstance((int)k);
        sk.update(1.0f);
        upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscFloatsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscFloatsTest.println(s);
        sk2 = KllHeapFloatsSketch.heapifyImpl((Memory)wmem);
        upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscFloatsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscFloatsTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
    }

    @Test
    public void checkSimpleMerge() {
        int i;
        int k = 20;
        int m = 8;
        int n1 = 21;
        int n2 = 43;
        WritableMemory wmem = WritableMemory.allocate((int)3000);
        WritableMemory wmem2 = WritableMemory.allocate((int)3000);
        KllDirectFloatsSketch sk1 = KllDirectFloatsSketch.newDirectUpdatableInstance((int)k, (int)m, (WritableMemory)wmem, (MemoryRequestServer)this.memReqSvr);
        KllDirectFloatsSketch sk2 = KllDirectFloatsSketch.newDirectUpdatableInstance((int)k, (int)m, (WritableMemory)wmem2, (MemoryRequestServer)this.memReqSvr);
        for (i = 1; i <= n1; ++i) {
            sk1.update((float)i);
        }
        for (i = 1; i <= n2; ++i) {
            sk2.update((float)(i + 100));
        }
        sk1.merge((KllSketch)sk2);
        Assert.assertEquals((double)sk1.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk1.getMaxItem(), (double)143.0);
    }

    @Test
    public void checkGetSingleItem() {
        int k = 20;
        KllFloatsSketch skHeap = KllFloatsSketch.newHeapInstance((int)k);
        skHeap.update(1.0f);
        Assert.assertTrue((boolean)(skHeap instanceof KllHeapFloatsSketch));
        Assert.assertEquals((float)skHeap.getFloatSingleItem(), (float)1.0f);
        WritableMemory srcMem = WritableMemory.writableWrap((byte[])KllHelper.toByteArray((KllSketch)skHeap, (boolean)true));
        KllFloatsSketch skDirect = KllFloatsSketch.writableWrap((WritableMemory)srcMem, (MemoryRequestServer)this.memReqSvr);
        Assert.assertTrue((boolean)(skDirect instanceof KllDirectFloatsSketch));
        Assert.assertEquals((float)skDirect.getFloatSingleItem(), (float)1.0f);
        Memory srcMem2 = Memory.wrap((byte[])skHeap.toByteArray());
        KllFloatsSketch skCompact = KllFloatsSketch.wrap((Memory)srcMem2);
        Assert.assertTrue((boolean)(skCompact instanceof KllDirectFloatsSketch.KllDirectCompactFloatsSketch));
        Assert.assertEquals((float)skCompact.getFloatSingleItem(), (float)1.0f);
    }

    @Test
    public void printlnTest() {
        String s = "PRINTING:  printf in " + this.getClass().getName();
        KllMiscFloatsTest.println(s);
        KllMiscFloatsTest.printf("%s\n", s);
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

