/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllHelperTest {
    public ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();

    @Test
    public void checkConvertToCumulative() {
        long[] array = new long[]{1L, 2L, 3L, 2L, 1L};
        long out = KllHelper.convertToCumulative((long[])array);
        Assert.assertEquals((long)out, (long)9L);
    }

    @Test
    public void checkCheckM() {
        try {
            KllHelper.checkM((int)0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            KllHelper.checkM((int)3);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            KllHelper.checkM((int)10);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkGetKFromEps() {
        int k = 200;
        double eps = KllHelper.getNormalizedRankError((int)200, (boolean)false);
        double epsPmf = KllHelper.getNormalizedRankError((int)200, (boolean)true);
        int kEps = KllSketch.getKFromEpsilon((double)eps, (boolean)false);
        int kEpsPmf = KllSketch.getKFromEpsilon((double)epsPmf, (boolean)true);
        Assert.assertEquals((int)kEps, (int)200);
        Assert.assertEquals((int)kEpsPmf, (int)200);
    }

    @Test
    public void checkIntCapAux() {
        int lvlCap = KllHelper.levelCapacity((int)10, (int)61, (int)0, (int)8);
        Assert.assertEquals((int)lvlCap, (int)8);
        lvlCap = KllHelper.levelCapacity((int)10, (int)61, (int)60, (int)8);
        Assert.assertEquals((int)lvlCap, (int)10);
    }

    @Test
    public void checkSuperLargeKandLevels() {
        int size = KllHelper.computeTotalItemCapacity((int)0x20000000, (int)8, (int)61);
        Assert.assertEquals((int)size, (int)0x6000006E);
    }

    @Test
    public void checkUbOnNumLevels() {
        Assert.assertEquals((int)KllHelper.ubOnNumLevels((long)0L), (int)1);
    }

    @Test
    public void checkUpdatableSerDeDouble() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)200);
        for (int i = 1; i <= 533; ++i) {
            sk.update((double)i);
        }
        int retained = sk.getNumRetained();
        int numLevels = sk.getNumLevels();
        KllHelperTest.println("NumLevels: " + numLevels);
        KllHelperTest.println("NumRetained: " + retained);
        byte[] compByteArr1 = sk.toByteArray();
        int compBytes1 = compByteArr1.length;
        KllHelperTest.println("compBytes1: " + compBytes1);
        byte[] upByteArr1 = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        int upBytes1 = upByteArr1.length;
        KllHelperTest.println("upBytes1: " + upBytes1);
        Memory mem = Memory.wrap((byte[])compByteArr1);
        KllDoublesSketch sk2 = KllDoublesSketch.heapify((Memory)mem);
        byte[] compByteArr2 = sk2.toByteArray();
        int compBytes2 = compByteArr2.length;
        KllHelperTest.println("compBytes2: " + compBytes2);
        Assert.assertEquals((int)compBytes1, (int)compBytes2);
        Assert.assertEquals((int)sk2.getNumRetained(), (int)retained);
        mem = Memory.wrap((byte[])compByteArr2);
        sk2 = KllDoublesSketch.heapify((Memory)mem);
        byte[] upByteArr2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        int upBytes2 = upByteArr2.length;
        KllHelperTest.println("upBytes2: " + upBytes2);
        Assert.assertEquals((int)upBytes1, (int)upBytes2);
        Assert.assertEquals((int)sk2.getNumRetained(), (int)retained);
    }

    @Test
    public void checkUpdatableSerDeFloat() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)200);
        for (int i = 1; i <= 533; ++i) {
            sk.update((float)i);
        }
        int retained = sk.getNumRetained();
        int numLevels = sk.getNumLevels();
        KllHelperTest.println("NumLevels: " + numLevels);
        KllHelperTest.println("NumRetained: " + retained);
        byte[] compByteArr1 = sk.toByteArray();
        int compBytes1 = compByteArr1.length;
        KllHelperTest.println("compBytes1: " + compBytes1);
        byte[] upByteArr1 = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        int upBytes1 = upByteArr1.length;
        KllHelperTest.println("upBytes1: " + upBytes1);
        Memory mem = Memory.wrap((byte[])compByteArr1);
        KllFloatsSketch sk2 = KllFloatsSketch.heapify((Memory)mem);
        byte[] compByteArr2 = sk2.toByteArray();
        int compBytes2 = compByteArr2.length;
        KllHelperTest.println("compBytes2: " + compBytes2);
        Assert.assertEquals((int)compBytes1, (int)compBytes2);
        Assert.assertEquals((int)sk2.getNumRetained(), (int)retained);
        mem = Memory.wrap((byte[])compByteArr2);
        sk2 = KllFloatsSketch.heapify((Memory)mem);
        byte[] upByteArr2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        int upBytes2 = upByteArr2.length;
        KllHelperTest.println("upBytes2: " + upBytes2);
        Assert.assertEquals((int)upBytes1, (int)upBytes2);
        Assert.assertEquals((int)sk2.getNumRetained(), (int)retained);
    }

    @Test
    public void checkUpdatableSerDeItem() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)200, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 533;
        int digits = Util.numDigits((int)533);
        for (int i = 1; i <= 533; ++i) {
            sk.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        int retained = sk.getNumRetained();
        int numLevels = sk.getNumLevels();
        KllHelperTest.println("NumLevels: " + numLevels);
        KllHelperTest.println("NumRetained: " + retained);
        byte[] compByteArr1 = sk.toByteArray();
        int compBytes1 = compByteArr1.length;
        KllHelperTest.println("compBytes1: " + compBytes1);
        byte[] upByteArr1 = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        int upBytes1 = upByteArr1.length;
        KllHelperTest.println("upBytes1: " + upBytes1);
        Assert.assertEquals((int)upBytes1, (int)compBytes1);
        Memory mem = Memory.wrap((byte[])compByteArr1);
        KllItemsSketch sk2 = KllItemsSketch.heapify((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        byte[] compByteArr2 = sk2.toByteArray();
        int compBytes2 = compByteArr2.length;
        KllHelperTest.println("compBytes2: " + compBytes2);
        Assert.assertEquals((int)compBytes1, (int)compBytes2);
        Assert.assertEquals((int)sk2.getNumRetained(), (int)retained);
        mem = Memory.wrap((byte[])compByteArr2);
        sk2 = KllItemsSketch.heapify((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        byte[] upByteArr2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        int upBytes2 = upByteArr2.length;
        KllHelperTest.println("upBytes2: " + upBytes2);
        Assert.assertEquals((int)upBytes1, (int)upBytes2);
        Assert.assertEquals((int)sk2.getNumRetained(), (int)retained);
    }

    @Test
    public void getMaxCompactDoublesSerializedSizeBytes() {
        int sizeBytes = KllSketch.getMaxSerializedSizeBytes((int)200, (long)0x40000000L, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)false);
        Assert.assertEquals((int)sizeBytes, (int)5704);
    }

    @Test
    public void getMaxCompactFloatsSerializedSizeBytes() {
        int sizeBytes = KllSketch.getMaxSerializedSizeBytes((int)200, (long)0x40000000L, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)false);
        Assert.assertEquals((int)sizeBytes, (int)2908);
    }

    @Test
    public void getMaxUpdatableDoubleSerializedSizeBytes() {
        int sizeBytes = KllSketch.getMaxSerializedSizeBytes((int)200, (long)0x40000000L, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        Assert.assertEquals((int)sizeBytes, (int)5708);
    }

    @Test
    public void getMaxUpdatableFloatsSerializedSizeBytes() {
        int sizeBytes = KllSketch.getMaxSerializedSizeBytes((int)200, (long)0x40000000L, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        Assert.assertEquals((int)sizeBytes, (int)2912);
    }

    @Test
    public void getMaxUpdatableItemsSerializedSizeBytes() {
        try {
            KllSketch.getMaxSerializedSizeBytes((int)200, (long)0x40000000L, (KllSketch.SketchType)KllSketch.SketchType.ITEMS_SKETCH, (boolean)true);
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getStatsAtNumLevels() {
        int k = 200;
        int m = 8;
        int numLevels = 23;
        KllHelper.LevelStats lvlStats = KllHelper.getFinalSketchStatsAtNumLevels((int)k, (int)m, (int)numLevels, (boolean)true);
        Assert.assertEquals((int)lvlStats.numItems, (int)697);
        Assert.assertEquals((long)lvlStats.n, (long)1257766904L);
    }

    @Test
    public void getStatsAtNumLevels2() {
        int k = 20;
        int m = 8;
        int numLevels = 2;
        KllHelper.LevelStats lvlStats = KllHelper.getFinalSketchStatsAtNumLevels((int)k, (int)m, (int)numLevels, (boolean)true);
        Assert.assertEquals((int)lvlStats.numLevels, (int)2);
        Assert.assertEquals((int)lvlStats.numItems, (int)33);
    }

    @Test
    public void testGetAllLevelStatsDoubles() {
        long n = 0x40000000L;
        int k = 200;
        int m = 8;
        KllHelper.GrowthStats gStats = KllHelper.getGrowthSchemeForGivenN((int)k, (int)m, (long)n, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        Assert.assertEquals((long)gStats.maxN, (long)1257766904L);
        Assert.assertEquals((int)gStats.numLevels, (int)23);
        Assert.assertEquals((int)gStats.maxItems, (int)697);
        Assert.assertEquals((int)gStats.compactBytes, (int)5704);
        Assert.assertEquals((int)gStats.updatableBytes, (int)5708);
    }

    @Test
    public void testGetAllLevelStatsFloats() {
        long n = 0x40000000L;
        int k = 200;
        int m = 8;
        KllHelper.GrowthStats gStats = KllHelper.getGrowthSchemeForGivenN((int)k, (int)m, (long)n, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        Assert.assertEquals((long)gStats.maxN, (long)1257766904L);
        Assert.assertEquals((int)gStats.numLevels, (int)23);
        Assert.assertEquals((int)gStats.maxItems, (int)697);
        Assert.assertEquals((int)gStats.compactBytes, (int)2908);
        Assert.assertEquals((int)gStats.updatableBytes, (int)2912);
    }

    @Test
    public void testGetAllLevelStatsDoubles2() {
        long n = 533L;
        int k = 200;
        int m = 8;
        KllHelper.GrowthStats gStats = KllHelper.getGrowthSchemeForGivenN((int)k, (int)m, (long)n, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        Assert.assertEquals((long)gStats.maxN, (long)533L);
        Assert.assertEquals((int)gStats.numLevels, (int)2);
        Assert.assertEquals((int)gStats.maxItems, (int)333);
        Assert.assertEquals((int)gStats.compactBytes, (int)2708);
        Assert.assertEquals((int)gStats.updatableBytes, (int)2712);
    }

    @Test
    public void testGetAllLevelStatsFloats2() {
        long n = 533L;
        int k = 200;
        int m = 8;
        KllHelper.GrowthStats gStats = KllHelper.getGrowthSchemeForGivenN((int)k, (int)m, (long)n, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        Assert.assertEquals((long)gStats.maxN, (long)533L);
        Assert.assertEquals((int)gStats.numLevels, (int)2);
        Assert.assertEquals((int)gStats.maxItems, (int)333);
        Assert.assertEquals((int)gStats.compactBytes, (int)1368);
        Assert.assertEquals((int)gStats.updatableBytes, (int)1372);
    }

    @Test
    public void testGetAllLevelStatsItems() {
        long n = 533L;
        int k = 200;
        int m = 8;
        try {
            KllHelper.getGrowthSchemeForGivenN((int)k, (int)m, (long)n, (KllSketch.SketchType)KllSketch.SketchType.ITEMS_SKETCH, (boolean)true);
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    static void println(Object o) {
    }
}

