/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllDirectCompactItemsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDirectCompactItemsSketchTest {
    public ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
    private static final boolean enablePrinting = false;

    @Test
    public void checkRODirectCompact() {
        int k = 20;
        int n = 21;
        int digits = Util.numDigits((int)21);
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        for (int i = 1; i <= 21; ++i) {
            sk.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        byte[] byteArr = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        Memory srcMem = Memory.wrap((byte[])byteArr);
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)srcMem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertTrue((boolean)(sk2 instanceof KllDirectCompactItemsSketch));
        KllDirectCompactItemsSketchTest.println(sk2.toString(true, false));
        Assert.assertFalse((boolean)sk2.isMemoryUpdatableFormat());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertEquals((String)((String)sk2.getMinItem()), (String)" 1");
        Assert.assertEquals((String)((String)sk2.getMaxItem()), (String)"21");
    }

    @Test
    public void checkDirectCompactSingleItem() {
        int k = 20;
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk.update((Object)"1");
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertTrue((boolean)(sk2 instanceof KllDirectCompactItemsSketch));
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertEquals((String)((String)sk2.getSingleItem()), (String)"1");
        sk.update((Object)"2");
        sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((long)sk2.getN(), (long)2L);
        try {
            sk2.getSingleItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkHeapGetFullItemsArray() {
        int j;
        int k = 20;
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        String[] itemsArr = (String[])sk.getTotalItemsArray();
        for (j = 0; j < k; ++j) {
            Assert.assertNull((Object)itemsArr[j]);
        }
        sk.update((Object)" 1");
        itemsArr = (String[])sk.getTotalItemsArray();
        for (j = 0; j < k - 1; ++j) {
            Assert.assertNull((Object)itemsArr[j]);
        }
        Assert.assertEquals((String)itemsArr[k - 1], (String)" 1");
        sk.update((Object)" 2");
        itemsArr = (String[])sk.getTotalItemsArray();
        for (j = 0; j < k - 2; ++j) {
            Assert.assertNull((Object)itemsArr[j]);
        }
        Assert.assertEquals((String)itemsArr[k - 1], (String)" 1");
        Assert.assertEquals((String)itemsArr[k - 2], (String)" 2");
    }

    @Test
    public void checkDirectCompactGetFullItemsArray() {
        int j;
        int k = 20;
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        String[] itemsArr = (String[])sk2.getTotalItemsArray();
        for (j = 0; j < k; ++j) {
            Assert.assertNull((Object)itemsArr[j]);
        }
        sk.update((Object)" 1");
        sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        itemsArr = (String[])sk2.getTotalItemsArray();
        for (j = 0; j < k - 1; ++j) {
            Assert.assertNull((Object)itemsArr[j]);
        }
        Assert.assertEquals((String)itemsArr[k - 1], (String)" 1");
        sk.update((Object)" 2");
        sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        itemsArr = (String[])sk2.getTotalItemsArray();
        for (j = 0; j < k - 2; ++j) {
            Assert.assertNull((Object)itemsArr[j]);
        }
        Assert.assertEquals((String)itemsArr[k - 1], (String)" 1");
        Assert.assertEquals((String)itemsArr[k - 2], (String)" 2");
    }

    @Test
    public void checkHeapAndDirectCompactGetRetainedItemsArray() {
        int k = 20;
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        String[] retArr = (String[])sk.getRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)sk.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)0);
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        retArr = (String[])sk2.getRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)sk2.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)0);
        sk.update((Object)" 1");
        retArr = (String[])sk.getRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)sk.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)1);
        Assert.assertEquals((String)retArr[0], (String)" 1");
        sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        retArr = (String[])sk2.getRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)sk2.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)1);
        Assert.assertEquals((String)retArr[0], (String)" 1");
        for (int i = 2; i <= 21; ++i) {
            sk.update((Object)Util.intToFixedLengthString((int)i, (int)2));
        }
        retArr = (String[])sk.getRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)sk.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)11);
        sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((int)retArr.length, (int)sk2.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)11);
    }

    @Test
    public void checkMinAndMax() {
        int k = 20;
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        try {
            sk2.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        sk.update((Object)" 1");
        sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((String)((String)sk2.getMaxItem()), (String)" 1");
        Assert.assertEquals((String)((String)sk2.getMinItem()), (String)" 1");
        for (int i = 2; i <= 21; ++i) {
            sk.update((Object)Util.intToFixedLengthString((int)i, (int)2));
        }
        sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((String)((String)sk2.getMaxItem()), (String)"21");
        Assert.assertEquals((String)((String)sk2.getMinItem()), (String)" 1");
    }

    @Test
    public void checkQuantile() {
        KllItemsSketch sk1 = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        for (int i = 1; i <= 1000; ++i) {
            sk1.update((Object)Util.intToFixedLengthString((int)i, (int)4));
        }
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])sk1.toByteArray()), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        String med2 = (String)sk2.getQuantile(0.5);
        String med1 = (String)sk1.getQuantile(0.5);
        Assert.assertEquals((String)med1, (String)med2);
        KllDirectCompactItemsSketchTest.println("Med1: " + med1);
        KllDirectCompactItemsSketchTest.println("Med2: " + med2);
    }

    @Test
    public void checkCompactSingleItemMerge() {
        int k = 20;
        KllItemsSketch skH1 = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        skH1.update((Object)"21");
        KllItemsSketch skDC1 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])skH1.toByteArray()), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        KllItemsSketch skH20 = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        for (int i = 1; i <= 20; ++i) {
            skH20.update((Object)Util.intToFixedLengthString((int)i, (int)2));
        }
        skH20.merge((KllSketch)skDC1);
        Assert.assertEquals((long)skH20.getN(), (long)21L);
    }

    private static final void println(Object o) {
    }
}

