/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.datasketches.common.TestUtil;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ThetaSketchCrossLanguageTest {
    @Test(groups={"generate_java_files"})
    public void generateBinariesForCompatibilityTesting() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            UpdateSketch sk = UpdateSketch.builder().build();
            for (int i = 0; i < n; ++i) {
                sk.update((long)i);
            }
            Files.newOutputStream(TestUtil.javaPath.resolve("theta_n" + n + "_java.sk"), new OpenOption[0]).write(sk.compact().toByteArray());
        }
    }

    @Test(groups={"generate_java_files"})
    public void generateBinariesForCompatibilityTestingNonEmptyNoEntries() throws IOException {
        UpdateSketch sk = UpdateSketch.builder().setP(0.01f).build();
        sk.update(1L);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertEquals((int)sk.getRetainedEntries(), (int)0);
        Files.newOutputStream(TestUtil.javaPath.resolve("theta_non_empty_no_entries_java.sk"), new OpenOption[0]).write(sk.compact().toByteArray());
    }

    @Test(groups={"check_cpp_files"})
    public void deserializeFromCpp() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("theta_n" + n + "_cpp.sk"));
            CompactSketch sketch = CompactSketch.wrap((Memory)Memory.wrap((byte[])bytes));
            Assert.assertTrue((boolean)(n == 0 ? sketch.isEmpty() : !sketch.isEmpty()));
            Assert.assertEquals((double)sketch.getEstimate(), (double)n, (double)((double)n * 0.03));
            Assert.assertTrue((boolean)sketch.isOrdered());
            HashIterator it = sketch.iterator();
            long previous = 0L;
            while (it.next()) {
                Assert.assertTrue((it.get() < sketch.getThetaLong() ? 1 : 0) != 0);
                Assert.assertTrue((it.get() > previous ? 1 : 0) != 0);
                previous = it.get();
            }
        }
    }

    @Test(groups={"check_cpp_files"})
    public void deserializeFromCppCompressed() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("theta_compressed_n" + n + "_cpp.sk"));
            CompactSketch sketch = CompactSketch.wrap((Memory)Memory.wrap((byte[])bytes));
            Assert.assertTrue((boolean)(n == 0 ? sketch.isEmpty() : !sketch.isEmpty()));
            Assert.assertEquals((double)sketch.getEstimate(), (double)n, (double)((double)n * 0.03));
            Assert.assertTrue((boolean)sketch.isOrdered());
            HashIterator it = sketch.iterator();
            long previous = 0L;
            while (it.next()) {
                Assert.assertTrue((it.get() < sketch.getThetaLong() ? 1 : 0) != 0);
                Assert.assertTrue((it.get() > previous ? 1 : 0) != 0);
                previous = it.get();
            }
        }
    }

    @Test(groups={"check_cpp_files"})
    public void deserializeFromCppNonEmptyNoEntries() throws IOException {
        byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("theta_non_empty_no_entries_cpp.sk"));
        CompactSketch sketch = CompactSketch.wrap((Memory)Memory.wrap((byte[])bytes));
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)0);
    }
}

