/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.req;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantilescommon.FloatsSortedView;
import org.apache.datasketches.quantilescommon.FloatsSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesFloatsSketchIterator;
import org.apache.datasketches.quantilescommon.QuantilesUtil;
import org.apache.datasketches.req.ReqDebug;
import org.apache.datasketches.req.ReqDebugImplTest;
import org.apache.datasketches.req.ReqSketch;
import org.apache.datasketches.req.ReqSketchBuilder;
import org.apache.datasketches.req.ReqSketchSortedView;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReqSketchTest {
    private static final String LS = System.getProperty("line.separator");
    private static final int skDebug = 0;
    private static final int iDebug = 0;

    @Test
    public void bigTest() {
        this.bigTestImpl(20, 1, 100, true, true, QuantileSearchCriteria.INCLUSIVE, 0);
        this.bigTestImpl(20, 1, 100, false, false, QuantileSearchCriteria.INCLUSIVE, 0);
        this.bigTestImpl(20, 1, 100, false, true, QuantileSearchCriteria.EXCLUSIVE, 0);
        this.bigTestImpl(20, 1, 100, true, false, QuantileSearchCriteria.INCLUSIVE, 0);
    }

    public void bigTestImpl(int k, int min, int max, boolean up, boolean hra, QuantileSearchCriteria crit, int skDebug) {
        ReqSketch sk = this.loadSketch(k, min, max, up, hra, skDebug);
        FloatsSortedView sv = sk.getSortedView();
        ReqSketchTest.checkToString(sk, 0);
        ReqSketchTest.checkSortedView(sk, 0);
        ReqSketchTest.checkGetRank(sk, min, max, 0);
        ReqSketchTest.checkGetRanks(sk, max, 0);
        ReqSketchTest.checkGetQuantiles(sk, 0);
        ReqSketchTest.checkGetCDF(sk, 0);
        ReqSketchTest.checkGetPMF(sk, 0);
        ReqSketchTest.checkIterator(sk, 0);
        ReqSketchTest.checkMerge(sk, 0);
        ReqSketchTest.printBoundary(skDebug);
        sk.reset();
    }

    public ReqSketch loadSketch(int k, int min, int max, boolean up, boolean hra, int skDebug) {
        ReqSketchBuilder bldr = ReqSketch.builder();
        bldr.setReqDebug((ReqDebug)new ReqDebugImplTest(skDebug, "%5.0f"));
        bldr.setK(k);
        bldr.setHighRankAccuracy(hra);
        ReqSketch sk = bldr.build();
        if (up) {
            for (int i = min; i <= max; ++i) {
                sk.update((float)i);
            }
        } else {
            int i = max + 1;
            while (i-- > min) {
                sk.update((float)i);
            }
        }
        return sk;
    }

    private static void printBoundary(int iDebug) {
        if (iDebug > 0) {
            ReqSketchTest.println("===========================================================");
        }
    }

    private static void checkToString(ReqSketch sk, int iDebug) {
        boolean summary = iDebug == 1;
        boolean allData = iDebug == 2;
        String brief = sk.toString();
        String all = sk.viewCompactorDetail("%4.0f", true);
        if (summary) {
            ReqSketchTest.println(brief);
            ReqSketchTest.println(sk.viewCompactorDetail("%4.0f", false));
        }
        if (allData) {
            ReqSketchTest.println(brief);
            ReqSketchTest.println(all);
        }
    }

    private static void checkGetRank(ReqSketch sk, int min, int max, int iDebug) {
        if (iDebug > 0) {
            ReqSketchTest.println("GetRank Test: INCLUSIVE");
        }
        float[] spArr = QuantilesUtil.evenlySpacedFloats((float)0.0f, (float)max, (int)11);
        double[] trueRanks = QuantilesUtil.evenlySpacedDoubles((double)0.0, (double)1.0, (int)11);
        String dfmt = "%10.2f%10.6f" + LS;
        String sfmt = "%10s%10s" + LS;
        if (iDebug > 0) {
            ReqSketchTest.printf(sfmt, "Value", "Rank");
        }
        float va = 0.0f;
        double ranka = 0.0;
        for (int i = 0; i < spArr.length; ++i) {
            float v = spArr[i];
            double trueRank = trueRanks[i];
            double rank = sk.getRank(v);
            if (iDebug > 0) {
                ReqSketchTest.printf(dfmt, Float.valueOf(v), rank);
            }
            Assert.assertEquals((double)rank, (double)trueRank, (double)0.01);
        }
        if (iDebug > 0) {
            ReqSketchTest.println("");
        }
    }

    private static void checkGetRanks(ReqSketch sk, int max, int iDebug) {
        if (iDebug > 0) {
            ReqSketchTest.println("GetRanks Test:");
        }
        float[] sp = QuantilesUtil.evenlySpacedFloats((float)0.0f, (float)max, (int)11);
        String dfmt = "%10.2f%10.6f" + LS;
        String sfmt = "%10s%10s" + LS;
        if (iDebug > 0) {
            ReqSketchTest.printf(sfmt, "Value", "Rank");
        }
        double[] nRanks = sk.getRanks(sp);
        for (int i = 0; i < nRanks.length; ++i) {
            if (iDebug <= 0) continue;
            ReqSketchTest.printf(dfmt, Float.valueOf(sp[i]), nRanks[i]);
        }
        if (iDebug > 0) {
            ReqSketchTest.println("");
        }
    }

    private static void checkSortedView(ReqSketch sk, int iDebug) {
        ReqSketchSortedView sv = new ReqSketchSortedView(sk);
        FloatsSortedViewIterator itr = sv.iterator();
        int retainedCount = sk.getNumRetained();
        long totalN = sk.getN();
        int count = 0;
        long cumWt = 0L;
        while (itr.next()) {
            cumWt = itr.getNaturalRank(QuantileSearchCriteria.INCLUSIVE);
            ++count;
        }
        Assert.assertEquals((long)cumWt, (long)totalN);
        Assert.assertEquals((int)count, (int)retainedCount);
    }

    private static void checkGetQuantiles(ReqSketch sk, int iDebug) {
        if (iDebug > 0) {
            ReqSketchTest.println("GetQuantiles() Test");
        }
        double[] rArr = new double[]{0.0, 0.1f, 0.2f, 0.3f, 0.4f, 0.5, 0.6f, 0.7f, 0.8f, 0.9f, 1.0};
        float[] qOut = sk.getQuantiles(rArr);
        if (iDebug > 0) {
            for (int i = 0; i < qOut.length; ++i) {
                String r = String.format("%6.3f", rArr[i]);
                ReqSketchTest.println("nRank: " + r + ", q: " + qOut[i]);
            }
        }
        if (iDebug > 0) {
            ReqSketchTest.println("");
        }
    }

    private static void checkGetCDF(ReqSketch sk, int iDebug) {
        if (iDebug > 0) {
            ReqSketchTest.println("GetCDF() Test");
        }
        float[] spArr = new float[]{20.0f, 40.0f, 60.0f, 80.0f};
        double[] cdf = sk.getCDF(spArr);
        if (iDebug > 0) {
            for (int i = 0; i < cdf.length; ++i) {
                float sp = i == spArr.length ? sk.getMaxItem() : spArr[i];
                ReqSketchTest.println("SP: " + sp + ", Den: " + cdf[i]);
            }
        }
        if (iDebug > 0) {
            ReqSketchTest.println("");
        }
    }

    private static void checkGetPMF(ReqSketch sk, int iDebug) {
        if (iDebug > 0) {
            ReqSketchTest.println("GetPMF() Test");
        }
        float[] spArr = new float[]{20.0f, 40.0f, 60.0f, 80.0f};
        double[] pmf = sk.getPMF(spArr);
        if (iDebug > 0) {
            for (int i = 0; i < pmf.length; ++i) {
                float sp = i == spArr.length ? sk.getMaxItem() : spArr[i];
                ReqSketchTest.println("SP: " + sp + ", Mass: " + pmf[i]);
            }
        }
        if (iDebug > 0) {
            ReqSketchTest.println("");
        }
    }

    private static void checkIterator(ReqSketch sk, int iDebug) {
        if (iDebug > 0) {
            ReqSketchTest.println("Sketch iterator() Test");
        }
        QuantilesFloatsSketchIterator itr = sk.iterator();
        while (itr.next()) {
            float v = itr.getQuantile();
            long wt = itr.getWeight();
            if (iDebug <= 0) continue;
            ReqSketchTest.println(" v=" + v + " wt=" + wt);
        }
        if (iDebug > 0) {
            ReqSketchTest.println("");
        }
    }

    private static void checkMerge(ReqSketch sk, int iDebug) {
        boolean summary;
        boolean allData = iDebug > 1;
        boolean bl = summary = iDebug > 0;
        if (summary) {
            ReqSketchTest.println("Merge Test");
            ReqSketchTest.println("Before Merge:");
            ReqSketchTest.outputCompactorDetail(sk, "%5.0f", allData, "Host Sketch:");
        }
        ReqSketch sk2 = new ReqSketch(sk);
        if (summary) {
            ReqSketchTest.outputCompactorDetail(sk2, "%5.0f", allData, "Incoming Sketch:");
            ReqSketchTest.println("Merge Process:");
        }
        sk.merge(sk2);
        Assert.assertEquals((long)sk.getN(), (long)200L);
    }

    @Test
    public void merge() {
        ReqSketch s1 = ReqSketch.builder().setK(12).build();
        for (int i = 0; i < 40; ++i) {
            s1.update((float)i);
        }
        ReqSketch s2 = ReqSketch.builder().setK(12).build();
        for (int i = 0; i < 40; ++i) {
            s2.update((float)i);
        }
        ReqSketch s3 = ReqSketch.builder().setK(12).build();
        for (int i = 0; i < 40; ++i) {
            s3.update((float)i);
        }
        ReqSketch s = ReqSketch.builder().setK(12).build();
        s.merge(s1);
        s.merge(s2);
        s.merge(s3);
    }

    @Test
    public void checkValidateSplits() {
        float[] arr = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        ReqSketch.validateSplits((float[])arr);
        try {
            float[] arr1 = new float[]{1.0f, 2.0f, 4.0f, 3.0f, 5.0f};
            ReqSketch.validateSplits((float[])arr1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkSerDe() {
        int k = 12;
        int exact = 71;
        ReqSketchTest.checkSerDeImpl(12, false, 0);
        ReqSketchTest.checkSerDeImpl(12, true, 0);
        ReqSketchTest.checkSerDeImpl(12, false, 4);
        ReqSketchTest.checkSerDeImpl(12, true, 4);
        ReqSketchTest.checkSerDeImpl(12, false, 71);
        ReqSketchTest.checkSerDeImpl(12, true, 71);
        ReqSketchTest.checkSerDeImpl(12, false, 142);
        ReqSketchTest.checkSerDeImpl(12, true, 142);
    }

    private static void checkSerDeImpl(int k, boolean hra, int count) {
        ReqSketch sk1 = ReqSketch.builder().setK(k).setHighRankAccuracy(hra).build();
        for (int i = 1; i <= count; ++i) {
            sk1.update((float)i);
        }
        byte[] sk1Arr = sk1.toByteArray();
        Memory mem = Memory.wrap((byte[])sk1Arr);
        ReqSketch sk2 = ReqSketch.heapify((Memory)mem);
        Assert.assertEquals((int)sk2.getNumRetained(), (int)sk1.getNumRetained());
        Assert.assertEquals((boolean)sk1.isEmpty(), (boolean)sk2.isEmpty());
        if (sk2.isEmpty()) {
            try {
                sk2.getMinItem();
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                sk2.getMaxItem();
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            Assert.assertEquals((float)sk2.getMinItem(), (float)sk1.getMinItem());
            Assert.assertEquals((float)sk2.getMaxItem(), (float)sk1.getMaxItem());
        }
        Assert.assertEquals((long)sk2.getN(), (long)sk1.getN());
        Assert.assertEquals((boolean)sk2.getHighRankAccuracyMode(), (boolean)sk1.getHighRankAccuracyMode());
        Assert.assertEquals((int)sk2.getK(), (int)sk1.getK());
        Assert.assertEquals((int)sk2.getMaxNomSize(), (int)sk1.getMaxNomSize());
        Assert.assertEquals((int)sk2.getNumLevels(), (int)sk1.getNumLevels());
        Assert.assertEquals((int)sk2.getSerializedSizeBytes(), (int)sk1.getSerializedSizeBytes());
    }

    @Test
    public void checkK() {
        try {
            ReqSketch sk1 = ReqSketch.builder().setK(1).build();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void tenValues() {
        int i;
        int i2;
        ReqSketch sketch = ReqSketch.builder().build();
        for (i2 = 1; i2 <= 10; ++i2) {
            sketch.update((float)i2);
        }
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)10L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)10);
        for (i2 = 1; i2 <= 10; ++i2) {
            Assert.assertEquals((double)sketch.getRank((float)i2), (double)((double)i2 / 10.0));
            Assert.assertEquals((double)sketch.getRank((float)i2, QuantileSearchCriteria.EXCLUSIVE), (double)((double)(i2 - 1) / 10.0));
            Assert.assertEquals((double)sketch.getRank((float)i2, QuantileSearchCriteria.INCLUSIVE), (double)((double)i2 / 10.0));
        }
        Assert.assertEquals((float)sketch.getQuantile(0.0, QuantileSearchCriteria.EXCLUSIVE), (float)1.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.1, QuantileSearchCriteria.EXCLUSIVE), (float)2.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.2, QuantileSearchCriteria.EXCLUSIVE), (float)3.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.3, QuantileSearchCriteria.EXCLUSIVE), (float)4.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.4, QuantileSearchCriteria.EXCLUSIVE), (float)5.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (float)6.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.6, QuantileSearchCriteria.EXCLUSIVE), (float)7.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.7, QuantileSearchCriteria.EXCLUSIVE), (float)8.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.8, QuantileSearchCriteria.EXCLUSIVE), (float)9.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.9, QuantileSearchCriteria.EXCLUSIVE), (float)10.0f);
        Assert.assertEquals((double)sketch.getQuantile(1.0, QuantileSearchCriteria.EXCLUSIVE), (double)10.0);
        Assert.assertEquals((float)sketch.getQuantile(0.0, QuantileSearchCriteria.INCLUSIVE), (float)1.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.1, QuantileSearchCriteria.INCLUSIVE), (float)1.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.2, QuantileSearchCriteria.INCLUSIVE), (float)2.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.3, QuantileSearchCriteria.INCLUSIVE), (float)3.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.4, QuantileSearchCriteria.INCLUSIVE), (float)4.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.5, QuantileSearchCriteria.INCLUSIVE), (float)5.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.6, QuantileSearchCriteria.INCLUSIVE), (float)6.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.7, QuantileSearchCriteria.INCLUSIVE), (float)7.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.8, QuantileSearchCriteria.INCLUSIVE), (float)8.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.9, QuantileSearchCriteria.INCLUSIVE), (float)9.0f);
        Assert.assertEquals((float)sketch.getQuantile(1.0, QuantileSearchCriteria.INCLUSIVE), (float)10.0f);
        float[] quantiles = sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0});
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((float)sketch.getQuantile((double)i / 10.0), (float)quantiles[i]);
        }
        quantiles = sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0}, QuantileSearchCriteria.INCLUSIVE);
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((float)sketch.getQuantile((double)i / 10.0, QuantileSearchCriteria.INCLUSIVE), (float)quantiles[i]);
        }
    }

    private static void outputCompactorDetail(ReqSketch sk, String fmt, boolean allData, String text) {
        ReqSketchTest.println(text);
        ReqSketchTest.println(sk.viewCompactorDetail(fmt, allData));
    }

    private static final void printf(String format, Object ... args) {
        System.out.printf(format, args);
    }

    private static final void print(Object o) {
        System.out.print(o.toString());
    }

    private static final void println(Object o) {
        System.out.println(o.toString());
    }
}

