/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfBooleansSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllDirectCompactItemsSketch;
import org.apache.datasketches.kll.KllHeapItemsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.kll.KllItemsSketchSortedView;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.GenericSortedViewIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllMiscItemsTest {
    static final String LS = System.getProperty("line.separator");
    public ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
    private static final boolean enablePrinting = false;

    @Test
    public void checkSortedViewConstruction() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 20;
        int digits = Util.numDigits((int)20);
        for (int i = 1; i <= 20; ++i) {
            sk.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        KllItemsSketchSortedView sv = sk.getSortedView();
        long[] cumWeights = sv.getCumulativeWeights();
        String[] values = (String[])sv.getQuantiles();
        Assert.assertEquals((int)cumWeights.length, (int)20);
        Assert.assertEquals((int)values.length, (int)20);
        for (int i = 0; i < 20; ++i) {
            Assert.assertEquals((long)cumWeights[i], (long)(i + 1));
            Assert.assertEquals((String)values[i], (String)Util.intToFixedLengthString((int)(i + 1), (int)digits));
        }
    }

    @Test
    public void checkBounds() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 1000;
        int digits = Util.numDigits((int)1000);
        for (int i = 1; i <= 1000; ++i) {
            sk.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        double eps = sk.getNormalizedRankError(false);
        String est = (String)sk.getQuantile(0.5);
        String ub = (String)sk.getQuantileUpperBound(0.5);
        String lb = (String)sk.getQuantileLowerBound(0.5);
        Assert.assertEquals((String)ub, (String)((String)sk.getQuantile(0.5 + eps)));
        Assert.assertEquals((String)lb, (String)((String)sk.getQuantile(0.5 - eps)));
        KllMiscItemsTest.println("Ext     : " + est);
        KllMiscItemsTest.println("UB      : " + ub);
        KllMiscItemsTest.println("LB      : " + lb);
        double rest = sk.getRank((Object)est);
        double restUB = sk.getRankUpperBound(rest);
        double restLB = sk.getRankLowerBound(rest);
        Assert.assertTrue((restUB - rest < 2.0 * eps ? 1 : 0) != 0);
        Assert.assertTrue((rest - restLB < 2.0 * eps ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions1() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(6L, (byte)3);
        KllItemsSketch.heapify((Memory)wmem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions2() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(0L, (byte)1);
        KllItemsSketch.heapify((Memory)wmem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions3() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk.update((Object)"1");
        sk.update((Object)"2");
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(0L, (byte)1);
        KllItemsSketch.heapify((Memory)wmem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions4() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(1L, (byte)0);
        KllItemsSketch.heapify((Memory)wmem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions5() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(2L, (byte)0);
        KllItemsSketch.heapify((Memory)wmem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
    }

    @Test
    public void checkMisc() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        KllMiscItemsTest.println(sk.toString(true, true));
        int n = 21;
        int digits = Util.numDigits((int)21);
        for (int i = 1; i <= 21; ++i) {
            sk.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        KllMiscItemsTest.println(sk.toString(true, true));
        sk.toByteArray();
        String[] items = (String[])sk.getTotalItemsArray();
        Assert.assertEquals((int)items.length, (int)33);
        int[] levels = sk.getLevelsArray(sk.sketchStructure);
        Assert.assertEquals((int)levels.length, (int)3);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
    }

    public void visualCheckToString() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 21;
        int digits = 3;
        for (int i = 1; i <= n; ++i) {
            sk.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        KllMiscItemsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertEquals((String)((String)sk.getMinItem()), (String)"  1");
        Assert.assertEquals((String)((String)sk.getMaxItem()), (String)" 21");
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        KllItemsSketch sk2 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        n = 400;
        digits = 3;
        for (int i = 101; i <= n + 100; ++i) {
            sk2.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        KllMiscItemsTest.println(LS + sk2.toString(true, true));
        Assert.assertEquals((int)sk2.getNumLevels(), (int)5);
        Assert.assertEquals((String)((String)sk2.getMinItem()), (String)"101");
        Assert.assertEquals((String)((String)sk2.getMaxItem()), (String)"500");
        Assert.assertEquals((int)sk2.getNumRetained(), (int)52);
        sk2.merge((KllSketch)sk);
        KllMiscItemsTest.println(LS + sk2.toString(true, true));
        Assert.assertEquals((int)sk2.getNumLevels(), (int)5);
        Assert.assertEquals((String)((String)sk2.getMinItem()), (String)"  1");
        Assert.assertEquals((String)((String)sk2.getMaxItem()), (String)"500");
        Assert.assertEquals((int)sk2.getNumRetained(), (int)56);
    }

    @Test
    public void viewHeapCompactions() {
        int k = 20;
        int n = 108;
        int digits = Util.numDigits((int)n);
        int compaction = 0;
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        for (int i = 1; i <= n; ++i) {
            sk.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
            if (sk.levelsArr[0] != 0) continue;
            KllMiscItemsTest.println(LS + "#<<< BEFORE COMPACTION # " + ++compaction + " >>>");
            KllMiscItemsTest.println(sk.toString(true, true));
            sk.update((Object)Util.intToFixedLengthString((int)(++i), (int)digits));
            KllMiscItemsTest.println(LS + "#<<< AFTER COMPACTION  # " + compaction + " >>>");
            KllMiscItemsTest.println(sk.toString(true, true));
            Assert.assertEquals((String)((String[])sk.getTotalItemsArray())[sk.levelsArr[0]], (String)Util.intToFixedLengthString((int)i, (int)digits));
        }
    }

    @Test
    public void viewCompactionAndSortedView() {
        int n = 43;
        int digits = Util.numDigits((int)43);
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        for (int i = 1; i <= 43; ++i) {
            sk.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        KllMiscItemsTest.println(sk.toString(true, true));
        KllItemsSketchSortedView sv = sk.getSortedView();
        GenericSortedViewIterator itr = sv.iterator();
        KllMiscItemsTest.println("### SORTED VIEW");
        KllMiscItemsTest.printf("%12s%12s\n", "Value", "CumWeight");
        while (itr.next()) {
            String v = (String)itr.getQuantile();
            long wt = itr.getWeight();
            KllMiscItemsTest.printf("%12s%12d\n", v, wt);
        }
    }

    @Test
    public void checkGrowLevels() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 21;
        int digits = Util.numDigits((int)21);
        for (int i = 1; i <= 21; ++i) {
            sk.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertEquals((int)((String[])sk.getTotalItemsArray()).length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure)[2], (int)33);
    }

    @Test
    public void checkSketchInitializeItemsHeap() {
        int k = 20;
        int n = 21;
        int digits = Util.numDigits((int)n);
        KllMiscItemsTest.println("#### CASE: FLOAT FULL HEAP");
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        for (int i = 1; i <= n; ++i) {
            sk.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        KllMiscItemsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)n);
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)((String[])sk.getTotalItemsArray()).length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((String)((String)sk.getMaxItem()), (String)"21");
        Assert.assertEquals((String)((String)sk.getMinItem()), (String)" 1");
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscItemsTest.println("#### CASE: FLOAT HEAP EMPTY");
        sk = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        KllMiscItemsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)((String[])sk.getTotalItemsArray()).length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscItemsTest.println("#### CASE: FLOAT HEAP SINGLE");
        sk = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk.update((Object)"1");
        KllMiscItemsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)((String[])sk.getTotalItemsArray()).length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((String)((String)sk.getMaxItem()), (String)"1");
        Assert.assertEquals((String)((String)sk.getMinItem()), (String)"1");
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeItemsHeapifyCompactMem() {
        int k = 20;
        int n = 21;
        int digits = Util.numDigits((int)n);
        KllMiscItemsTest.println("#### CASE: FLOAT FULL HEAPIFIED FROM COMPACT");
        KllItemsSketch sk2 = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        for (int i = 1; i <= n; ++i) {
            sk2.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        KllMiscItemsTest.println(sk2.toString(true, true));
        byte[] compBytes = sk2.toByteArray();
        Memory mem = Memory.wrap((byte[])compBytes);
        KllMiscItemsTest.println(KllPreambleUtil.toString((Memory)mem, (KllSketch.SketchType)KllSketch.SketchType.ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe));
        KllItemsSketch sk = KllItemsSketch.heapify((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)((String[])sk.getTotalItemsArray()).length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((String)((String)sk.getMaxItem()), (String)"21");
        Assert.assertEquals((String)((String)sk.getMinItem()), (String)" 1");
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscItemsTest.println("#### CASE: FLOAT EMPTY HEAPIFIED FROM COMPACT");
        sk2 = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        compBytes = sk2.toByteArray();
        mem = Memory.wrap((byte[])compBytes);
        KllMiscItemsTest.println(KllPreambleUtil.toString((Memory)mem, (KllSketch.SketchType)KllSketch.SketchType.ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe));
        sk = KllItemsSketch.heapify((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)((String[])sk.getTotalItemsArray()).length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscItemsTest.println("#### CASE: FLOAT SINGLE HEAPIFIED FROM COMPACT");
        sk2 = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk2.update((Object)"1");
        compBytes = sk2.toByteArray();
        mem = Memory.wrap((byte[])compBytes);
        KllMiscItemsTest.println(KllPreambleUtil.toString((Memory)mem, (KllSketch.SketchType)KllSketch.SketchType.ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe));
        sk = KllItemsSketch.heapify((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)((String[])sk.getTotalItemsArray()).length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((String)((String)sk.getMaxItem()), (String)"1");
        Assert.assertEquals((String)((String)sk.getMinItem()), (String)"1");
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkMemoryToStringItemsCompact() {
        int k = 20;
        int n = 21;
        int digits = Util.numDigits((int)n);
        KllMiscItemsTest.println("#### CASE: FLOAT FULL COMPACT");
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        for (int i = 1; i <= n; ++i) {
            sk.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        byte[] compBytes = sk.toByteArray();
        Memory mem = Memory.wrap((byte[])compBytes);
        String s = KllPreambleUtil.toString((Memory)mem, (KllSketch.SketchType)KllSketch.SketchType.ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe);
        KllMiscItemsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscItemsTest.println(s);
        KllItemsSketch sk2 = KllItemsSketch.heapify((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        byte[] compBytes2 = sk2.toByteArray();
        mem = Memory.wrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)mem, (KllSketch.SketchType)KllSketch.SketchType.ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe);
        KllMiscItemsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscItemsTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
        KllMiscItemsTest.println("#### CASE: FLOAT EMPTY COMPACT");
        sk = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        compBytes = sk.toByteArray();
        mem = Memory.wrap((byte[])compBytes);
        s = KllPreambleUtil.toString((Memory)mem, (KllSketch.SketchType)KllSketch.SketchType.ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe);
        KllMiscItemsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscItemsTest.println(s);
        sk2 = KllItemsSketch.heapify((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        compBytes2 = sk2.toByteArray();
        mem = Memory.wrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)mem, (KllSketch.SketchType)KllSketch.SketchType.ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe);
        KllMiscItemsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscItemsTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
        KllMiscItemsTest.println("#### CASE: FLOAT SINGLE COMPACT");
        sk = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk.update((Object)"1");
        compBytes = sk.toByteArray();
        mem = Memory.wrap((byte[])compBytes);
        s = KllPreambleUtil.toString((Memory)mem, (KllSketch.SketchType)KllSketch.SketchType.ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe);
        KllMiscItemsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscItemsTest.println(s);
        sk2 = KllItemsSketch.heapify((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        compBytes2 = sk2.toByteArray();
        mem = Memory.wrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)mem, (KllSketch.SketchType)KllSketch.SketchType.ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe);
        KllMiscItemsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscItemsTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
    }

    @Test
    public void checkGetSingleItem() {
        int k = 20;
        KllItemsSketch skHeap = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        skHeap.update((Object)"1");
        Assert.assertTrue((boolean)(skHeap instanceof KllHeapItemsSketch));
        Assert.assertEquals((String)((String)skHeap.getSingleItem()), (String)"1");
        Memory srcMem = Memory.wrap((byte[])KllHelper.toByteArray((KllSketch)skHeap, (boolean)true));
        KllItemsSketch skDirect = KllItemsSketch.wrap((Memory)srcMem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertTrue((boolean)(skDirect instanceof KllDirectCompactItemsSketch));
        Assert.assertEquals((String)((String)skDirect.getSingleItem()), (String)"1");
        Memory srcMem2 = Memory.wrap((byte[])skHeap.toByteArray());
        KllItemsSketch skCompact = KllItemsSketch.wrap((Memory)srcMem2, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertTrue((boolean)(skCompact instanceof KllDirectCompactItemsSketch));
        Assert.assertEquals((String)((String)skCompact.getSingleItem()), (String)"1");
    }

    @Test
    public void checkIssue484() {
        Boolean[] items = new Boolean[]{true, false, true, false, true, false, true, false, true, false};
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Boolean::compareTo, (ArrayOfItemsSerDe)new ArrayOfBooleansSerDe());
        for (int i = 0; i < items.length; ++i) {
            sketch.update((Object)items[i]);
        }
        byte[] serialized = sketch.toByteArray();
        KllItemsSketch deserialized = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])serialized), Boolean::compareTo, (ArrayOfItemsSerDe)new ArrayOfBooleansSerDe());
        KllMiscItemsTest.checkSketchesEqual(sketch, deserialized);
    }

    private static <T> void checkSketchesEqual(KllItemsSketch<T> expected, KllItemsSketch<T> actual) {
        KllItemsSketchSortedView expSV = expected.getSortedView();
        KllItemsSketchSortedView actSV = actual.getSortedView();
        int N = (int)actSV.getN();
        long[] expCumWts = expSV.getCumulativeWeights();
        Object[] expItemsArr = (Boolean[])expSV.getQuantiles();
        long[] actCumWts = actSV.getCumulativeWeights();
        Object[] actItemsArr = (Boolean[])actSV.getQuantiles();
        KllMiscItemsTest.printf("%3s %8s %8s\n", "i", "Actual", "Expected");
        for (int i = 0; i < N; ++i) {
            KllMiscItemsTest.printf("%3d %8s %8s\n", i, ((Boolean)actItemsArr[i]).toString(), ((Boolean)expItemsArr[i]).toString());
        }
        Assert.assertEquals((long[])actCumWts, (long[])expCumWts);
        Assert.assertEquals((Object[])actItemsArr, (Object[])expItemsArr);
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

