/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.util.Random;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.AnotB;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.PairwiseSetOperations;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SetOpsCornerCasesTest {
    Random rand = new Random(9001L);

    @Test
    public void checkSetOpsRandom() {
        int hiA = 0;
        int loB = 0;
        int hiB = 0;
        for (int i = 0; i < 1000; ++i) {
            hiA = this.rand.nextInt(128);
            loB = this.rand.nextInt(64);
            hiB = loB + this.rand.nextInt(64);
            SetOpsCornerCasesTest.compareSetOpsRandom(64, 0, hiA, loB, hiB);
        }
    }

    private static void compareSetOpsRandom(int k, int loA, int hiA, int loB, int hiB) {
        int i;
        UpdateSketch tskA = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        UpdateSketch tskB = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        for (i = loA; i < hiA; ++i) {
            tskA.update((long)i);
        }
        for (i = loB; i < hiB; ++i) {
            tskB.update((long)i);
        }
        CompactSketch rcskStdU = SetOpsCornerCasesTest.doStdUnion((Sketch)tskA, (Sketch)tskB, k, null);
        CompactSketch rcskPwU = SetOpsCornerCasesTest.doPwUnion((Sketch)tskA, (Sketch)tskB, k);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskPwU, (Sketch)rcskStdU);
        CompactSketch rcskStdPairU = SetOpsCornerCasesTest.doStdPairUnion((Sketch)tskA, (Sketch)tskB, k, null);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskStdPairU, (Sketch)rcskStdU);
        CompactSketch rcskStdI = SetOpsCornerCasesTest.doStdIntersection((Sketch)tskA, (Sketch)tskB, null);
        CompactSketch rcskPwI = SetOpsCornerCasesTest.doPwIntersection((Sketch)tskA, (Sketch)tskB);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskPwI, (Sketch)rcskStdI);
        CompactSketch rcskStdPairI = SetOpsCornerCasesTest.doStdPairIntersection((Sketch)tskA, (Sketch)tskB, null);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskStdPairI, (Sketch)rcskStdI);
        CompactSketch rcskStdAnotB = SetOpsCornerCasesTest.doStdAnotB((Sketch)tskA, (Sketch)tskB, null);
        CompactSketch rcskPwAnotB = SetOpsCornerCasesTest.doPwAnotB((Sketch)tskA, (Sketch)tskB);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskPwAnotB, (Sketch)rcskStdAnotB);
        CompactSketch rcskStdStatefulAnotB = SetOpsCornerCasesTest.doStdStatefulAnotB((Sketch)tskA, (Sketch)tskB, null);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskStdStatefulAnotB, (Sketch)rcskStdAnotB);
    }

    @Test
    public void compareCornerCases() {
        int k = 64;
        for (State stateA : State.values()) {
            for (State stateB : State.values()) {
                if (stateA == State.EST_MEMORY_UNORDERED || stateB == State.EST_MEMORY_UNORDERED || stateA == State.NULL || stateB == State.NULL) continue;
                SetOpsCornerCasesTest.cornerCaseChecks(stateA, stateB, k);
                SetOpsCornerCasesTest.cornerCaseChecksMemory(stateA, stateB, k);
            }
        }
    }

    private static void cornerCaseChecksMemory(State stateA, State stateB, int k) {
        SetOpsCornerCasesTest.println("StateA: " + (Object)((Object)stateA) + ", StateB: " + (Object)((Object)stateB));
        CompactSketch tcskA = SetOpsCornerCasesTest.generate(stateA, k);
        CompactSketch tcskB = SetOpsCornerCasesTest.generate(stateB, k);
        WritableMemory wmem = WritableMemory.allocate((int)SetOperation.getMaxUnionBytes((int)k));
        CompactSketch rcskStdU = SetOpsCornerCasesTest.doStdUnion((Sketch)tcskA, (Sketch)tcskB, k, null);
        CompactSketch rcskPwU = SetOpsCornerCasesTest.doPwUnion((Sketch)tcskA, (Sketch)tcskB, k);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskPwU, (Sketch)rcskStdU);
        rcskStdU = SetOpsCornerCasesTest.doStdUnion((Sketch)tcskA, (Sketch)tcskB, k, wmem);
        CompactSketch rcskStdPairU = SetOpsCornerCasesTest.doStdPairUnion((Sketch)tcskA, (Sketch)tcskB, k, wmem);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskStdPairU, (Sketch)rcskStdU);
        wmem = WritableMemory.allocate((int)SetOperation.getMaxIntersectionBytes((int)k));
        CompactSketch rcskStdI = SetOpsCornerCasesTest.doStdIntersection((Sketch)tcskA, (Sketch)tcskB, null);
        CompactSketch rcskPwI = SetOpsCornerCasesTest.doPwIntersection((Sketch)tcskA, (Sketch)tcskB);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskPwI, (Sketch)rcskStdI);
        rcskStdI = SetOpsCornerCasesTest.doStdIntersection((Sketch)tcskA, (Sketch)tcskB, wmem);
        CompactSketch rcskStdPairI = SetOpsCornerCasesTest.doStdPairIntersection((Sketch)tcskA, (Sketch)tcskB, wmem);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskStdPairI, (Sketch)rcskStdI);
        wmem = WritableMemory.allocate((int)SetOperation.getMaxAnotBResultBytes((int)k));
        CompactSketch rcskStdAnotB = SetOpsCornerCasesTest.doStdAnotB((Sketch)tcskA, (Sketch)tcskB, null);
        CompactSketch rcskPwAnotB = SetOpsCornerCasesTest.doPwAnotB((Sketch)tcskA, (Sketch)tcskB);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskPwAnotB, (Sketch)rcskStdAnotB);
        rcskStdAnotB = SetOpsCornerCasesTest.doStdAnotB((Sketch)tcskA, (Sketch)tcskB, wmem);
        CompactSketch rcskStdStatefulAnotB = SetOpsCornerCasesTest.doStdStatefulAnotB((Sketch)tcskA, (Sketch)tcskB, wmem);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskStdStatefulAnotB, (Sketch)rcskStdAnotB);
    }

    private static void cornerCaseChecks(State stateA, State stateB, int k) {
        SetOpsCornerCasesTest.println("StateA: " + (Object)((Object)stateA) + ", StateB: " + (Object)((Object)stateB));
        CompactSketch tcskA = SetOpsCornerCasesTest.generate(stateA, k);
        CompactSketch tcskB = SetOpsCornerCasesTest.generate(stateB, k);
        CompactSketch rcskStdU = SetOpsCornerCasesTest.doStdUnion((Sketch)tcskA, (Sketch)tcskB, k, null);
        CompactSketch rcskPwU = SetOpsCornerCasesTest.doPwUnion((Sketch)tcskA, (Sketch)tcskB, k);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskPwU, (Sketch)rcskStdU);
        CompactSketch rcskStdPairU = SetOpsCornerCasesTest.doStdPairUnion((Sketch)tcskA, (Sketch)tcskB, k, null);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskStdPairU, (Sketch)rcskStdU);
        CompactSketch rcskStdI = SetOpsCornerCasesTest.doStdIntersection((Sketch)tcskA, (Sketch)tcskB, null);
        CompactSketch rcskPwI = SetOpsCornerCasesTest.doPwIntersection((Sketch)tcskA, (Sketch)tcskB);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskPwI, (Sketch)rcskStdI);
        CompactSketch rcskStdPairI = SetOpsCornerCasesTest.doStdPairIntersection((Sketch)tcskA, (Sketch)tcskB, null);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskStdPairI, (Sketch)rcskStdI);
        CompactSketch rcskStdAnotB = SetOpsCornerCasesTest.doStdAnotB((Sketch)tcskA, (Sketch)tcskB, null);
        CompactSketch rcskPwAnotB = SetOpsCornerCasesTest.doPwAnotB((Sketch)tcskA, (Sketch)tcskB);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskPwAnotB, (Sketch)rcskStdAnotB);
        CompactSketch rcskStdStatefulAnotB = SetOpsCornerCasesTest.doStdStatefulAnotB((Sketch)tcskA, (Sketch)tcskB, null);
        SetOpsCornerCasesTest.checkCornerCase((Sketch)rcskStdStatefulAnotB, (Sketch)rcskStdAnotB);
    }

    private static CompactSketch doStdUnion(Sketch tskA, Sketch tskB, int k, WritableMemory wmem) {
        Union union = Sketches.setOperationBuilder().setNominalEntries(k).buildUnion();
        union.union(tskA);
        union.union(tskB);
        return union.getResult(true, wmem);
    }

    private static CompactSketch doStdPairUnion(Sketch tskA, Sketch tskB, int k, WritableMemory wmem) {
        Union union = Sketches.setOperationBuilder().setNominalEntries(k).buildUnion();
        return union.union(tskA, tskB, true, wmem);
    }

    private static CompactSketch doStdIntersection(Sketch tskA, Sketch tskB, WritableMemory wmem) {
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        inter.intersect(tskA);
        inter.intersect(tskB);
        return inter.getResult(true, wmem);
    }

    private static CompactSketch doStdPairIntersection(Sketch tskA, Sketch tskB, WritableMemory wmem) {
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        return inter.intersect(tskA, tskB, true, wmem);
    }

    private static CompactSketch doStdAnotB(Sketch tskA, Sketch tskB, WritableMemory wmem) {
        AnotB anotb = Sketches.setOperationBuilder().buildANotB();
        return anotb.aNotB(tskA, tskB, true, wmem);
    }

    private static CompactSketch doStdStatefulAnotB(Sketch tskA, Sketch tskB, WritableMemory wmem) {
        AnotB anotb = Sketches.setOperationBuilder().buildANotB();
        anotb.setA(tskA);
        anotb.notB(tskB);
        anotb.getResult(false);
        return anotb.getResult(true, wmem, true);
    }

    private static CompactSketch doPwUnion(Sketch tskA, Sketch tskB, int k) {
        CompactSketch tcskA;
        if (tskA == null) {
            tcskA = null;
        } else {
            CompactSketch compactSketch = tcskA = tskA instanceof CompactSketch ? (CompactSketch)tskA : tskA.compact();
        }
        CompactSketch tcskB = tskB == null ? null : (tskB instanceof CompactSketch ? (CompactSketch)tskB : tskB.compact());
        return PairwiseSetOperations.union((CompactSketch)tcskA, (CompactSketch)tcskB, (int)k);
    }

    private static CompactSketch doPwIntersection(Sketch tskA, Sketch tskB) {
        return PairwiseSetOperations.intersect((Sketch)tskA, (Sketch)tskB);
    }

    private static CompactSketch doPwAnotB(Sketch tskA, Sketch tskB) {
        return PairwiseSetOperations.aNotB((Sketch)tskA, (Sketch)tskB);
    }

    private static void checkCornerCase(Sketch rskA, Sketch rskB) {
        double estA = rskA.getEstimate();
        double estB = rskB.getEstimate();
        boolean emptyA = rskA.isEmpty();
        boolean emptyB = rskB.isEmpty();
        long thetaLongA = rskA.getThetaLong();
        long thetaLongB = rskB.getThetaLong();
        int countA = rskA.getRetainedEntries(true);
        int countB = rskB.getRetainedEntries(true);
        Assert.assertEquals((double)estB, (double)estA, (double)0.0);
        Assert.assertEquals((boolean)emptyB, (boolean)emptyA);
        Assert.assertEquals((long)thetaLongB, (long)thetaLongA);
        Assert.assertEquals((int)countB, (int)countA);
        Assert.assertEquals((String)rskA.getClass().getSimpleName(), (String)rskB.getClass().getSimpleName());
    }

    @Test
    public void checkUnionNotOrdered() {
        int k = 64;
        CompactSketch skNull = SetOpsCornerCasesTest.generate(State.NULL, k);
        CompactSketch skEmpty = SetOpsCornerCasesTest.generate(State.EMPTY, k);
        CompactSketch skHeap = SetOpsCornerCasesTest.generate(State.EST_HEAP, k);
        CompactSketch skHeapUO = SetOpsCornerCasesTest.generate(State.EST_MEMORY_UNORDERED, k);
        PairwiseSetOperations.union((CompactSketch)skNull, (CompactSketch)skHeapUO, (int)k);
        PairwiseSetOperations.union((CompactSketch)skEmpty, (CompactSketch)skHeapUO, (int)k);
        PairwiseSetOperations.union((CompactSketch)skHeapUO, (CompactSketch)skNull, (int)k);
        PairwiseSetOperations.union((CompactSketch)skHeapUO, (CompactSketch)skEmpty, (int)k);
        PairwiseSetOperations.union((CompactSketch)skHeapUO, (CompactSketch)skHeap, (int)k);
        PairwiseSetOperations.union((CompactSketch)skHeap, (CompactSketch)skHeapUO, (int)k);
    }

    @Test
    public void checkSeedHash() {
        int k = 64;
        UpdateSketch tmp1 = Sketches.updateSketchBuilder().setNominalEntries(k).setSeed(123L).build();
        tmp1.update(1L);
        tmp1.update(3L);
        CompactSketch skSmallSeed2A = tmp1.compact(true, null);
        UpdateSketch tmp2 = Sketches.updateSketchBuilder().setNominalEntries(k).setSeed(123L).build();
        tmp2.update(1L);
        tmp2.update(2L);
        CompactSketch skSmallSeed2B = tmp2.compact(true, null);
        CompactSketch skExact = SetOpsCornerCasesTest.generate(State.EXACT, k);
        CompactSketch skHeap = SetOpsCornerCasesTest.generate(State.EST_HEAP, 2 * k);
        try {
            PairwiseSetOperations.intersect((Sketch)skExact, (Sketch)skSmallSeed2A);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.intersect((Sketch)skExact, (Sketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.intersect((Sketch)skSmallSeed2B, (Sketch)skExact);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.intersect((Sketch)skHeap, (Sketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.aNotB((Sketch)skExact, (Sketch)skSmallSeed2A);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.aNotB((Sketch)skExact, (Sketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.aNotB((Sketch)skSmallSeed2B, (Sketch)skExact);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.aNotB((Sketch)skHeap, (Sketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.union((CompactSketch)skExact, (CompactSketch)skSmallSeed2A);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.union((CompactSketch)skExact, (CompactSketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.union((CompactSketch)skSmallSeed2B, (CompactSketch)skExact);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.union((CompactSketch)skHeap, (CompactSketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void checkPwUnionReduceToK() {
        int k = 16;
        CompactSketch skNull = SetOpsCornerCasesTest.generate(State.NULL, k);
        CompactSketch skEmpty = SetOpsCornerCasesTest.generate(State.EMPTY, k);
        CompactSketch skHeap1 = SetOpsCornerCasesTest.generate(State.EST_HEAP, k);
        CompactSketch skHeap2 = SetOpsCornerCasesTest.generate(State.EST_HEAP, k);
        CompactSketch csk = PairwiseSetOperations.union((CompactSketch)skNull, (CompactSketch)skHeap1, (int)k);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)k);
        csk = PairwiseSetOperations.union((CompactSketch)skEmpty, (CompactSketch)skHeap1, (int)k);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)k);
        csk = PairwiseSetOperations.union((CompactSketch)skHeap1, (CompactSketch)skNull, (int)k);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)k);
        csk = PairwiseSetOperations.union((CompactSketch)skHeap1, (CompactSketch)skEmpty, (int)k);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)k);
        csk = PairwiseSetOperations.union((CompactSketch)skHeap1, (CompactSketch)skHeap2, (int)k);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)k);
    }

    @Test
    public void printlnTest() {
        SetOpsCornerCasesTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }

    @Test
    public void checkGenerator() {
        int k = 16;
        CompactSketch csk = SetOpsCornerCasesTest.generate(State.NULL, 0);
        Assert.assertNull((Object)csk);
        csk = SetOpsCornerCasesTest.generate(State.EMPTY, k);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)false);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)0);
        Assert.assertEquals((long)csk.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((boolean)csk.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)true);
        csk = SetOpsCornerCasesTest.generate(State.SINGLE, k);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)false);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)1);
        Assert.assertEquals((long)csk.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((boolean)csk.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)true);
        csk = SetOpsCornerCasesTest.generate(State.EXACT, k);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)false);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)k);
        Assert.assertEquals((long)csk.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((boolean)csk.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)true);
        csk = SetOpsCornerCasesTest.generate(State.EST_HEAP, k);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)true);
        Assert.assertEquals((csk.getRetainedEntries(true) > k ? 1 : 0) != 0, (boolean)true);
        Assert.assertEquals((csk.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0, (boolean)true);
        Assert.assertEquals((boolean)csk.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)true);
        csk = SetOpsCornerCasesTest.generate(State.THLT1_CNT0_FALSE, k);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)true);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)0);
        Assert.assertEquals((csk.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0, (boolean)true);
        Assert.assertEquals((boolean)csk.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)true);
        csk = SetOpsCornerCasesTest.generate(State.THEQ1_CNT0_TRUE, k);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)false);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)0);
        Assert.assertEquals((csk.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0, (boolean)false);
        Assert.assertEquals((boolean)csk.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)true);
        csk = SetOpsCornerCasesTest.generate(State.EST_MEMORY_UNORDERED, k);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)true);
        Assert.assertEquals((csk.getRetainedEntries(true) > k ? 1 : 0) != 0, (boolean)true);
        Assert.assertEquals((csk.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0, (boolean)true);
        Assert.assertEquals((boolean)csk.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemory(), (boolean)true);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)false);
    }

    private static CompactSketch generate(State state, int k) {
        UpdateSketch sk = null;
        CompactSketch csk = null;
        switch (state) {
            case NULL: {
                break;
            }
            case EMPTY: {
                csk = Sketches.updateSketchBuilder().setNominalEntries(k).build().compact(true, null);
                break;
            }
            case SINGLE: {
                sk = Sketches.updateSketchBuilder().setNominalEntries(k).build();
                sk.update(1L);
                csk = sk.compact(true, null);
                break;
            }
            case EXACT: {
                sk = Sketches.updateSketchBuilder().setNominalEntries(k).build();
                for (int i = 0; i < k; ++i) {
                    sk.update((long)i);
                }
                csk = sk.compact(true, null);
                break;
            }
            case EST_HEAP: {
                sk = Sketches.updateSketchBuilder().setNominalEntries(k).build();
                for (int i = 0; i < 4 * k; ++i) {
                    sk.update((long)i);
                }
                csk = sk.compact(true, null);
                break;
            }
            case THLT1_CNT0_FALSE: {
                sk = Sketches.updateSketchBuilder().setP(0.5f).setNominalEntries(k).build();
                sk.update(7L);
                assert (sk.getRetainedEntries(true) == 0);
                csk = sk.compact(true, null);
                break;
            }
            case THEQ1_CNT0_TRUE: {
                sk = Sketches.updateSketchBuilder().setP(0.5f).setNominalEntries(k).build();
                assert (sk.getRetainedEntries(true) == 0);
                csk = sk.compact(true, null);
                break;
            }
            case EST_MEMORY_UNORDERED: {
                sk = Sketches.updateSketchBuilder().setNominalEntries(k).build();
                for (int i = 0; i < 4 * k; ++i) {
                    sk.update((long)i);
                }
                int bytes = Sketch.getMaxCompactSketchBytes((int)sk.getRetainedEntries(true));
                byte[] byteArr = new byte[bytes];
                WritableMemory mem = WritableMemory.writableWrap((byte[])byteArr);
                csk = sk.compact(false, mem);
                break;
            }
        }
        return csk;
    }

    static enum State {
        NULL,
        EMPTY,
        SINGLE,
        EXACT,
        EST_HEAP,
        THLT1_CNT0_FALSE,
        THEQ1_CNT0_TRUE,
        EST_MEMORY_UNORDERED;

    }
}

