/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchSortedView;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.quantilescommon.LinearRanksAndQuantiles;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CustomQuantilesTest {
    private static final boolean enablePrinting = false;

    @Test
    public void checkQuantilesV400() {
        double nrN;
        double qTrue;
        double q;
        double nr;
        CustomQuantilesTest.println("Classic DoubleSketch, Version 4.0.0, k=4");
        CustomQuantilesTest.println("");
        int k = 4;
        UpdateDoublesSketch sk = DoublesSketch.builder().setK(k).build();
        for (int i = 1; i <= 3; ++i) {
            for (int q2 = 10; q2 <= k * 10; q2 += 10) {
                sk.update((double)q2);
            }
        }
        long N = sk.getN();
        DoublesSketchSortedView sv = new DoublesSketchSortedView((DoublesSketch)sk);
        double[] quantilesArr = sv.getQuantiles();
        long[] cumWtsArr = sv.getCumulativeWeights();
        int lenQ = quantilesArr.length;
        CustomQuantilesTest.println("Sorted View:");
        CustomQuantilesTest.printf("%12s%12s%12s\n", "Quantiles", "ICumWts", "IRanks");
        for (int i = 0; i < lenQ; ++i) {
            double normRank = (double)cumWtsArr[i] / (double)N;
            CustomQuantilesTest.printf("%12.1f%12d%12.4f\n", quantilesArr[i], cumWtsArr[i], normRank);
        }
        CustomQuantilesTest.println("");
        CustomQuantilesTest.println("GetRanks, EXCLUSIVE:");
        CustomQuantilesTest.println("  R of the largest Q at the highest index that is < q. If q <= smallest Q => 0");
        CustomQuantilesTest.printf("%12s%12s\n", "Quantiles", "Ranks");
        for (int q3 = 0; q3 <= k * 10 + 5; q3 += 5) {
            double nr2 = sk.getRank((double)q3, QuantileSearchCriteria.EXCLUSIVE);
            double nrTrue = LinearRanksAndQuantiles.getTrueDoubleRank(cumWtsArr, quantilesArr, q3, QuantileSearchCriteria.EXCLUSIVE);
            Assert.assertEquals((double)nr2, (double)nrTrue);
            CustomQuantilesTest.printf("%12.1f%12.3f\n", q3, nr2);
        }
        CustomQuantilesTest.println("");
        CustomQuantilesTest.println("GetQuantiles, EXCLUSIVE (round down)");
        CustomQuantilesTest.println("  Q of the smallest rank > r. If r = 1.0 => null or NaN");
        CustomQuantilesTest.printf("%12s%12s%12s\n", "Ranks", "Quantiles", "CompRank");
        double inc = 1.0 / (double)(2L * N);
        for (long j = 0L; j <= 2L * N; ++j) {
            nr = (double)j * inc;
            q = sk.getQuantile(nr, QuantileSearchCriteria.EXCLUSIVE);
            qTrue = LinearRanksAndQuantiles.getTrueDoubleQuantile(cumWtsArr, quantilesArr, nr, QuantileSearchCriteria.EXCLUSIVE);
            Assert.assertEquals((double)q, (double)qTrue);
            nrN = Math.floor(nr * (double)N);
            CustomQuantilesTest.printf("%12.4f%12.1f%12.1f\n", nr, q, nrN);
        }
        CustomQuantilesTest.println("");
        CustomQuantilesTest.println("GetRanks, INCLUSIVE:");
        CustomQuantilesTest.println("  R of the largest Q at the highest index that is <= q. If q < smallest Q => 0");
        CustomQuantilesTest.printf("%12s%12s\n", "Quantiles", "Ranks");
        for (int q4 = 0; q4 <= k * 10 + 5; q4 += 5) {
            double nr3 = sk.getRank((double)q4, QuantileSearchCriteria.INCLUSIVE);
            double nrTrue = LinearRanksAndQuantiles.getTrueDoubleRank(cumWtsArr, quantilesArr, q4, QuantileSearchCriteria.INCLUSIVE);
            Assert.assertEquals((double)nr3, (double)nrTrue);
            CustomQuantilesTest.printf("%12.1f%12.3f\n", q4, nr3);
        }
        CustomQuantilesTest.println("");
        CustomQuantilesTest.println("GetQuantiles, INCLUSIVE (round up)");
        CustomQuantilesTest.println("  Q of the smallest rank >= r.");
        CustomQuantilesTest.printf("%12s%12s%12s\n", "Ranks", "Quantiles", "CompRank");
        inc = 1.0 / (double)(2L * N);
        for (long j = 0L; j <= 2L * N; ++j) {
            nr = (double)j * inc;
            q = sk.getQuantile(nr, QuantileSearchCriteria.INCLUSIVE);
            qTrue = LinearRanksAndQuantiles.getTrueDoubleQuantile(cumWtsArr, quantilesArr, nr, QuantileSearchCriteria.INCLUSIVE);
            Assert.assertEquals((double)q, (double)qTrue);
            nrN = Math.ceil(nr * (double)N);
            CustomQuantilesTest.printf("%12.4f%12.1f%12.1f\n", nr, q, nrN);
        }
        CustomQuantilesTest.println("");
    }

    static final void print(Object o) {
    }

    static final void println(Object o) {
    }

    static final void printf(String format, Object ... args) {
    }
}

