/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.kll.KllItemsSketchSortedView;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesGenericSketchIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllItemsSketchiteratorTest {
    private ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();

    @Test
    public void emptySketch() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        QuantilesGenericSketchIterator it = sketch.iterator();
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void oneItemSketch() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sketch.update((Object)"1");
        QuantilesGenericSketchIterator it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((String)((String)it.getQuantile()), (String)"1");
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void twoItemSketchForIterator() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sketch.update((Object)"1");
        sketch.update((Object)"2");
        QuantilesGenericSketchIterator itr = sketch.iterator();
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((String)((String)itr.getQuantile()), (String)"2");
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((String)((String)itr.getQuantile()), (String)"1");
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
    }

    @Test
    public void twoItemSketchForSortedViewIterator() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sketch.update((Object)"1");
        sketch.update((Object)"2");
        KllItemsSketchSortedView.KllItemsSketchSortedViewIterator itr = sketch.getSortedView().iterator();
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((String)((String)itr.getQuantile()), (String)"1");
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.EXCLUSIVE), (long)0L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.INCLUSIVE), (long)1L);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.INCLUSIVE), (double)0.5);
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((String)((String)itr.getQuantile()), (String)"2");
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.EXCLUSIVE), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.INCLUSIVE), (long)2L);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.EXCLUSIVE), (double)0.5);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.INCLUSIVE), (double)1.0);
    }

    @Test
    public void bigSketches() {
        int digits = 6;
        for (int n = 1000; n < 100000; n += 2000) {
            KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
            for (int i = 0; i < n; ++i) {
                sketch.update((Object)Util.intToFixedLengthString((int)i, (int)6));
            }
            QuantilesGenericSketchIterator it = sketch.iterator();
            int count = 0;
            int weight = 0;
            while (it.next()) {
                ++count;
                weight += (int)it.getWeight();
            }
            Assert.assertEquals((int)count, (int)sketch.getNumRetained());
            Assert.assertEquals((int)weight, (int)n);
        }
    }
}

