/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import java.util.Objects;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;

public final class QuantilesUtil {
    public static final String THROWS_EMPTY = "The sketch must not be empty at this point.";

    private QuantilesUtil() {
    }

    public static final void checkNormalizedRankBounds(double nRank) {
        if (nRank < 0.0 || nRank > 1.0) {
            throw new SketchesArgumentException("A normalized rank must be >= 0 and <= 1.0: " + nRank);
        }
    }

    public static final void checkDoublesSplitPointsOrder(double[] values) {
        Objects.requireNonNull(values);
        int len = values.length - 1;
        for (int j = 0; j < len; ++j) {
            if (values[j] < values[j + 1]) continue;
            throw new SketchesArgumentException("Values must be unique, monotonically increasing and not NaN.");
        }
    }

    public static final void checkFloatsSplitPointsOrder(float[] values) {
        Objects.requireNonNull(values);
        int len = values.length - 1;
        for (int j = 0; j < len; ++j) {
            if (values[j] < values[j + 1]) continue;
            throw new SketchesArgumentException("Values must be unique, monotonically increasing and not NaN.");
        }
    }

    public static double[] equallyWeightedRanks(int num) {
        if (num < 1) {
            throw new IllegalArgumentException("num must be >= 1");
        }
        double[] out = new double[num + 1];
        out[0] = 0.0;
        out[num] = 1.0;
        double delta = 1.0 / (double)num;
        for (int i = 1; i < num; ++i) {
            out[i] = (double)i * delta;
        }
        return out;
    }

    public static float[] evenlySpacedFloats(float value1, float value2, int num) {
        if (num < 2) {
            throw new SketchesArgumentException("num must be >= 2");
        }
        float[] out = new float[num];
        out[0] = value1;
        out[num - 1] = value2;
        if (num == 2) {
            return out;
        }
        float delta = (value2 - value1) / (float)(num - 1);
        for (int i = 1; i < num - 1; ++i) {
            out[i] = (float)i * delta + value1;
        }
        return out;
    }

    public static double[] evenlySpacedDoubles(double value1, double value2, int num) {
        if (num < 2) {
            throw new SketchesArgumentException("num must be >= 2");
        }
        double[] out = new double[num];
        out[0] = value1;
        out[num - 1] = value2;
        if (num == 2) {
            return out;
        }
        double delta = (value2 - value1) / (double)(num - 1);
        for (int i = 1; i < num - 1; ++i) {
            out[i] = (double)i * delta + value1;
        }
        return out;
    }

    public static double[] evenlyLogSpaced(double value1, double value2, int num) {
        if (num < 2) {
            throw new SketchesArgumentException("num must be >= 2");
        }
        if (value1 <= 0.0 || value2 <= 0.0) {
            throw new SketchesArgumentException("value1 and value2 must be > 0.");
        }
        double[] arr = QuantilesUtil.evenlySpacedDoubles(Math.log(value1) / Util.LOG2, Math.log(value2) / Util.LOG2, num);
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = Math.pow(2.0, arr[i]);
        }
        return arr;
    }
}

