/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.BackwardConversions;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.tuple.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HeapifyWrapSerVer1and2Test {
    private static final short defaultSeedHash = Util.computeSeedHash((long)9001L);

    @Test
    public void checkHeapifyCompactSketchAssumedDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdateSketch sv3usk = UpdateSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            sv3usk.update((long)i);
        }
        CompactSketch sv3csk = sv3usk.compact();
        Memory sv3cskMem = Memory.wrap((byte[])sv3csk.toByteArray());
        CompactSketch sv3cskResult = Sketches.heapifyCompactSketch((Memory)sv3cskMem);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Memory sv2cskMem = BackwardConversions.convertSerVer3toSerVer2(sv3csk, 9001L);
        sv3cskResult = Sketches.heapifyCompactSketch((Memory)sv2cskMem);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Memory sv1cskMem = BackwardConversions.convertSerVer3toSerVer1(sv3csk);
        sv3cskResult = Sketches.heapifyCompactSketch((Memory)sv1cskMem);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
    }

    @Test
    public void checkHeapifyCompactSketchAssumedDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdateSketch sv3usk = UpdateSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            sv3usk.update((long)i);
        }
        CompactSketch sv3csk = sv3usk.compact();
        Memory sv3cskMem = Memory.wrap((byte[])sv3csk.toByteArray());
        CompactSketch sv3cskResult = Sketches.heapifyCompactSketch((Memory)sv3cskMem);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Memory sv2cskMem = BackwardConversions.convertSerVer3toSerVer2(sv3csk, 128L);
        sv3cskResult = Sketches.heapifyCompactSketch((Memory)sv2cskMem);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Memory sv1cskMem = BackwardConversions.convertSerVer3toSerVer1(sv3csk);
        sv3cskResult = Sketches.heapifyCompactSketch((Memory)sv1cskMem);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)defaultSeedHash);
    }

    @Test
    public void checkHeapifyCompactSketchGivenDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdateSketch sv3usk = UpdateSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            sv3usk.update((long)i);
        }
        CompactSketch sv3csk = sv3usk.compact();
        Memory sv3cskMem = Memory.wrap((byte[])sv3csk.toByteArray());
        CompactSketch sv3cskResult = Sketches.heapifyCompactSketch((Memory)sv3cskMem, (long)9001L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Memory sv2cskMem = BackwardConversions.convertSerVer3toSerVer2(sv3csk, 9001L);
        sv3cskResult = Sketches.heapifyCompactSketch((Memory)sv2cskMem, (long)9001L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Memory sv1cskMem = BackwardConversions.convertSerVer3toSerVer1(sv3csk);
        sv3cskResult = Sketches.heapifyCompactSketch((Memory)sv1cskMem, (long)9001L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
    }

    @Test
    public void checkHeapifyCompactSketchGivenDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdateSketch sv3usk = UpdateSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            sv3usk.update((long)i);
        }
        CompactSketch sv3csk = sv3usk.compact();
        Memory sv3cskMem = Memory.wrap((byte[])sv3csk.toByteArray());
        CompactSketch sv3cskResult = Sketches.heapifyCompactSketch((Memory)sv3cskMem, (long)128L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Memory sv2cskMem = BackwardConversions.convertSerVer3toSerVer2(sv3csk, 128L);
        sv3cskResult = Sketches.heapifyCompactSketch((Memory)sv2cskMem, (long)128L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Memory sv1cskMem = BackwardConversions.convertSerVer3toSerVer1(sv3csk);
        sv3cskResult = Sketches.heapifyCompactSketch((Memory)sv1cskMem, (long)128L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
    }

    @Test
    public void checkHeapifySketchAssumedDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdateSketch sv3usk = UpdateSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            sv3usk.update((long)i);
        }
        CompactSketch sv3csk = sv3usk.compact();
        Memory sv3cskMem = Memory.wrap((byte[])sv3csk.toByteArray());
        CompactSketch sv3cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv3cskMem);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Memory sv2cskMem = BackwardConversions.convertSerVer3toSerVer2(sv3csk, 9001L);
        sv3cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv2cskMem);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Memory sv1cskMem = BackwardConversions.convertSerVer3toSerVer1(sv3csk);
        sv3cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv1cskMem);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
    }

    @Test
    public void checkHeapifySketchAssumedDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdateSketch sv3usk = UpdateSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            sv3usk.update((long)i);
        }
        CompactSketch sv3csk = sv3usk.compact();
        Memory sv3cskMem = Memory.wrap((byte[])sv3csk.toByteArray());
        CompactSketch sv3cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv3cskMem);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Memory sv2cskMem = BackwardConversions.convertSerVer3toSerVer2(sv3csk, 128L);
        sv3cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv2cskMem);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Memory sv1cskMem = BackwardConversions.convertSerVer3toSerVer1(sv3csk);
        sv3cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv1cskMem);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)defaultSeedHash);
    }

    @Test
    public void checkHeapifySketchGivenDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdateSketch sv3usk = UpdateSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            sv3usk.update((long)i);
        }
        CompactSketch sv3csk = sv3usk.compact();
        Memory sv3cskMem = Memory.wrap((byte[])sv3csk.toByteArray());
        CompactSketch sv3cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv3cskMem, (long)9001L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Memory sv2cskMem = BackwardConversions.convertSerVer3toSerVer2(sv3csk, 9001L);
        sv3cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv2cskMem, (long)9001L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Memory sv1cskMem = BackwardConversions.convertSerVer3toSerVer1(sv3csk);
        sv3cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv1cskMem, (long)9001L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
    }

    @Test
    public void checkHeapifySketchGivenDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdateSketch sv3usk = UpdateSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            sv3usk.update((long)i);
        }
        CompactSketch sv3csk = sv3usk.compact();
        Memory sv3cskMem = Memory.wrap((byte[])sv3csk.toByteArray());
        CompactSketch sv3cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv3cskMem, (long)128L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Memory sv2cskMem = BackwardConversions.convertSerVer3toSerVer2(sv3csk, 128L);
        sv3cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv2cskMem, (long)128L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Memory sv1cskMem = BackwardConversions.convertSerVer3toSerVer1(sv3csk);
        sv3cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv1cskMem, (long)128L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
    }

    @Test
    public void checkWrapCompactSketchAssumedDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdateSketch sv3usk = UpdateSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            sv3usk.update((long)i);
        }
        CompactSketch sv3csk = sv3usk.compact();
        WritableHandle wh = HeapifyWrapSerVer1and2Test.putOffHeap(Memory.wrap((byte[])sv3csk.toByteArray()));
        CompactSketch sv3cskResult = Sketches.wrapCompactSketch((Memory)wh.getWritable());
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertTrue((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wh = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer2(sv3csk, 9001L));
        sv3cskResult = Sketches.wrapCompactSketch((Memory)wh.getWritable());
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wh = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer1(sv3csk));
        sv3cskResult = Sketches.wrapCompactSketch((Memory)wh.getWritable());
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void checkWrapCompactSketchAssumedDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdateSketch sv3usk = UpdateSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            sv3usk.update((long)i);
        }
        CompactSketch sv3csk = sv3usk.compact();
        WritableHandle wh = HeapifyWrapSerVer1and2Test.putOffHeap(Memory.wrap((byte[])sv3csk.toByteArray()));
        CompactSketch sv3cskResult = Sketches.wrapCompactSketch((Memory)wh.getWritable());
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertTrue((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wh = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer2(sv3csk, 128L));
        sv3cskResult = Sketches.wrapCompactSketch((Memory)wh.getWritable());
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wh = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer1(sv3csk));
        sv3cskResult = Sketches.wrapCompactSketch((Memory)wh.getWritable());
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)defaultSeedHash);
        Assert.assertFalse((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void checkWrapCompactSketchGivenDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdateSketch sv3usk = UpdateSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            sv3usk.update((long)i);
        }
        CompactSketch sv3csk = sv3usk.compact();
        WritableHandle wh = HeapifyWrapSerVer1and2Test.putOffHeap(Memory.wrap((byte[])sv3csk.toByteArray()));
        CompactSketch sv3cskResult = Sketches.wrapCompactSketch((Memory)wh.getWritable(), (long)9001L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertTrue((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wh = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer2(sv3csk, 9001L));
        sv3cskResult = Sketches.wrapCompactSketch((Memory)wh.getWritable(), (long)9001L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wh = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer1(sv3csk));
        sv3cskResult = Sketches.wrapCompactSketch((Memory)wh.getWritable(), (long)9001L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void checkWrapCompactSketchGivenDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdateSketch sv3usk = UpdateSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            sv3usk.update((long)i);
        }
        CompactSketch sv3csk = sv3usk.compact();
        WritableHandle wh = HeapifyWrapSerVer1and2Test.putOffHeap(Memory.wrap((byte[])sv3csk.toByteArray()));
        CompactSketch sv3cskResult = Sketches.wrapCompactSketch((Memory)wh.getWritable(), (long)128L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertTrue((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wh = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer2(sv3csk, 128L));
        sv3cskResult = Sketches.wrapCompactSketch((Memory)wh.getWritable(), (long)128L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wh = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer1(sv3csk));
        sv3cskResult = Sketches.wrapCompactSketch((Memory)wh.getWritable(), (long)128L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void checkWrapSketchAssumedDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdateSketch sv3usk = UpdateSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            sv3usk.update((long)i);
        }
        CompactSketch sv3csk = sv3usk.compact();
        WritableHandle wh = HeapifyWrapSerVer1and2Test.putOffHeap(Memory.wrap((byte[])sv3csk.toByteArray()));
        CompactSketch sv3cskResult = (CompactSketch)Sketches.wrapSketch((Memory)wh.getWritable());
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertTrue((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wh = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer2(sv3csk, 9001L));
        sv3cskResult = (CompactSketch)Sketches.wrapSketch((Memory)wh.getWritable());
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wh = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer1(sv3csk));
        sv3cskResult = (CompactSketch)Sketches.wrapSketch((Memory)wh.getWritable());
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void checkWrapSketchAssumedDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdateSketch sv3usk = UpdateSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            sv3usk.update((long)i);
        }
        CompactSketch sv3csk = sv3usk.compact();
        WritableHandle wh = HeapifyWrapSerVer1and2Test.putOffHeap(Memory.wrap((byte[])sv3csk.toByteArray()));
        CompactSketch sv3cskResult = (CompactSketch)Sketches.wrapSketch((Memory)wh.getWritable());
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertTrue((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wh = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer2(sv3csk, 128L));
        sv3cskResult = (CompactSketch)Sketches.wrapSketch((Memory)wh.getWritable());
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wh = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer1(sv3csk));
        sv3cskResult = (CompactSketch)Sketches.wrapSketch((Memory)wh.getWritable());
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)defaultSeedHash);
        Assert.assertFalse((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void checkWrapSketchGivenDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdateSketch sv3usk = UpdateSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            sv3usk.update((long)i);
        }
        CompactSketch sv3csk = sv3usk.compact();
        WritableHandle wh = HeapifyWrapSerVer1and2Test.putOffHeap(Memory.wrap((byte[])sv3csk.toByteArray()));
        CompactSketch sv3cskResult = (CompactSketch)Sketches.wrapSketch((Memory)wh.getWritable(), (long)9001L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertTrue((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wh = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer2(sv3csk, 9001L));
        sv3cskResult = (CompactSketch)Sketches.wrapSketch((Memory)wh.getWritable(), (long)9001L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wh = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer1(sv3csk));
        sv3cskResult = (CompactSketch)Sketches.wrapSketch((Memory)wh.getWritable(), (long)9001L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void checkWrapSketchGivenDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdateSketch sv3usk = UpdateSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            sv3usk.update((long)i);
        }
        CompactSketch sv3csk = sv3usk.compact();
        WritableHandle wh = HeapifyWrapSerVer1and2Test.putOffHeap(Memory.wrap((byte[])sv3csk.toByteArray()));
        CompactSketch sv3cskResult = (CompactSketch)Sketches.wrapSketch((Memory)wh.getWritable(), (long)128L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertTrue((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wh = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer2(sv3csk, 128L));
        sv3cskResult = (CompactSketch)Sketches.wrapSketch((Memory)wh.getWritable(), (long)128L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wh = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer1(sv3csk));
        sv3cskResult = (CompactSketch)Sketches.wrapSketch((Memory)wh.getWritable(), (long)128L);
        Assert.assertEquals((double)sv3cskResult.getEstimate(), (double)sv3usk.getEstimate());
        Assert.assertEquals((short)sv3cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)sv3cskResult.isDirect());
        try {
            wh.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static WritableHandle putOffHeap(Memory heapMem) {
        long cap = heapMem.getCapacity();
        WritableHandle wh = WritableMemory.allocateDirect((long)cap);
        WritableMemory wmem = wh.getWritable();
        heapMem.copyTo(0L, wmem, 0L, cap);
        return wh;
    }

    @Test
    public void printlnTest() {
        HeapifyWrapSerVer1and2Test.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

