/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.testng.Assert;

public class LinearRanksAndQuantiles {
    public static float getTrueFloatQuantile(long[] cumWeights, float[] quantiles, double givenNormR, QuantileSearchCriteria inclusive) {
        int len = cumWeights.length;
        long N = cumWeights[len - 1];
        float result = Float.NaN;
        for (int i = 0; i < len; ++i) {
            if (i == len - 1) {
                double topR = (double)cumWeights[i] / (double)N;
                float topQ = quantiles[i];
                if (inclusive == QuantileSearchCriteria.INCLUSIVE) {
                    if (givenNormR <= topR) {
                        result = topQ;
                        break;
                    }
                    Assert.fail((String)"normRank > 1.0");
                }
                if (givenNormR < topR) {
                    result = topQ;
                    break;
                }
                if (givenNormR > 1.0) {
                    Assert.fail((String)"normRank > 1.0");
                }
                result = topQ;
                break;
            }
            double loR = (double)cumWeights[i] / (double)N;
            double hiR = (double)cumWeights[i + 1] / (double)N;
            float loQ = quantiles[i];
            float hiQ = quantiles[i + 1];
            if (inclusive == QuantileSearchCriteria.INCLUSIVE) {
                if (i == 0 && givenNormR <= loR) {
                    result = loQ;
                    break;
                }
                if (!(loR < givenNormR) || !(givenNormR <= hiR)) continue;
                result = hiQ;
                break;
            }
            if (i == 0 && givenNormR < loR) {
                result = loQ;
                break;
            }
            if (!(loR <= givenNormR) || !(givenNormR < hiR)) continue;
            result = hiQ;
            break;
        }
        return result;
    }

    public static double getTrueDoubleQuantile(long[] cumWeights, double[] quantiles, double givenNormR, QuantileSearchCriteria inclusive) {
        int len = cumWeights.length;
        long N = cumWeights[len - 1];
        double result = Double.NaN;
        for (int i = 0; i < len; ++i) {
            if (i == len - 1) {
                double topR = (double)cumWeights[i] / (double)N;
                double topQ = quantiles[i];
                if (inclusive == QuantileSearchCriteria.INCLUSIVE) {
                    if (givenNormR <= topR) {
                        result = topQ;
                        break;
                    }
                    Assert.fail((String)"normRank > 1.0");
                }
                if (givenNormR < topR) {
                    result = topQ;
                    break;
                }
                if (givenNormR > 1.0) {
                    Assert.fail((String)"normRank > 1.0");
                }
                result = topQ;
                break;
            }
            double loR = (double)cumWeights[i] / (double)N;
            double hiR = (double)cumWeights[i + 1] / (double)N;
            double loQ = quantiles[i];
            double hiQ = quantiles[i + 1];
            if (inclusive == QuantileSearchCriteria.INCLUSIVE) {
                if (i == 0 && givenNormR <= loR) {
                    result = loQ;
                    break;
                }
                if (!(loR < givenNormR) || !(givenNormR <= hiR)) continue;
                result = hiQ;
                break;
            }
            if (i == 0 && givenNormR < loR) {
                result = loQ;
                break;
            }
            if (!(loR <= givenNormR) || !(givenNormR < hiR)) continue;
            result = hiQ;
            break;
        }
        return result;
    }

    public static double getTrueFloatRank(long[] cumWeights, float[] quantiles, float givenQ, QuantileSearchCriteria inclusive) {
        int len = quantiles.length;
        long N = cumWeights[len - 1];
        double result = Double.NaN;
        int i = len;
        while (i-- > 0) {
            if (i == 0) {
                double bottomR = (double)cumWeights[i] / (double)N;
                float bottomQ = quantiles[i];
                if (inclusive == QuantileSearchCriteria.INCLUSIVE) {
                    if (givenQ < bottomQ) {
                        result = 0.0;
                        break;
                    }
                    result = bottomR;
                    break;
                }
                if (givenQ <= bottomQ) {
                    result = 0.0;
                    break;
                }
                if (!(bottomQ < givenQ)) continue;
                result = bottomR;
                break;
            }
            double loR = (double)cumWeights[i - 1] / (double)N;
            float loQ = quantiles[i - 1];
            float hiQ = quantiles[i];
            if (inclusive == QuantileSearchCriteria.INCLUSIVE) {
                if (i == len - 1 && hiQ <= givenQ) {
                    result = 1.0;
                    break;
                }
                if (!(loQ <= givenQ) || !(givenQ < hiQ)) continue;
                result = loR;
                break;
            }
            if (i == len - 1 && hiQ < givenQ) {
                result = 1.0;
                break;
            }
            if (!(loQ < givenQ) || !(givenQ <= hiQ)) continue;
            result = loR;
            break;
        }
        return result;
    }

    public static double getTrueDoubleRank(long[] cumWeights, double[] quantiles, double givenQ, QuantileSearchCriteria inclusive) {
        int len = quantiles.length;
        long N = cumWeights[len - 1];
        double result = Double.NaN;
        int i = len;
        while (i-- > 0) {
            if (i == 0) {
                double bottomR = (double)cumWeights[i] / (double)N;
                double bottomQ = quantiles[i];
                if (inclusive == QuantileSearchCriteria.INCLUSIVE) {
                    if (givenQ < bottomQ) {
                        result = 0.0;
                        break;
                    }
                    result = bottomR;
                    break;
                }
                if (givenQ <= bottomQ) {
                    result = 0.0;
                    break;
                }
                if (!(bottomQ < givenQ)) continue;
                result = bottomR;
                break;
            }
            double loR = (double)cumWeights[i - 1] / (double)N;
            double loQ = quantiles[i - 1];
            double hiQ = quantiles[i];
            if (inclusive == QuantileSearchCriteria.INCLUSIVE) {
                if (i == len - 1 && hiQ <= givenQ) {
                    result = 1.0;
                    break;
                }
                if (!(loQ <= givenQ) || !(givenQ < hiQ)) continue;
                result = loR;
                break;
            }
            if (i == len - 1 && hiQ < givenQ) {
                result = 1.0;
                break;
            }
            if (!(loQ < givenQ) || !(givenQ <= hiQ)) continue;
            result = loR;
            break;
        }
        return result;
    }
}

