/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.CompactDoublesSketch;
import org.apache.datasketches.quantiles.DirectCompactDoublesSketch;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchTest;
import org.apache.datasketches.quantiles.DoublesUtil;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketch;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketchTest;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.testng.annotations.Test;

public class DoublesUtilTest {
    @Test
    public void checkPrintMemData() {
        int k = 16;
        int n = 1000;
        UpdateDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(16, 1000);
        byte[] byteArr = qs.toByteArray(false);
        Memory mem = Memory.wrap((byte[])byteArr);
        DoublesUtilTest.println(DoublesUtil.memToString((boolean)true, (boolean)true, (Memory)mem));
        byteArr = qs.toByteArray(true);
        mem = Memory.wrap((byte[])byteArr);
        DoublesUtilTest.println(DoublesUtil.memToString((boolean)true, (boolean)true, (Memory)mem));
    }

    @Test
    public void checkPrintMemData2() {
        int k = 128;
        boolean n = false;
        UpdateDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 0);
        byte[] byteArr = qs.toByteArray();
        Memory mem = Memory.wrap((byte[])byteArr);
        DoublesUtilTest.println(DoublesUtil.memToString((boolean)true, (boolean)true, (Memory)mem));
    }

    @Test
    public void checkCopyToHeap() {
        int k = 128;
        int n = 400;
        HeapUpdateDoublesSketch huds = (HeapUpdateDoublesSketch)HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 400);
        HeapUpdateDoublesSketch target1 = DoublesUtil.copyToHeap((DoublesSketch)huds);
        DoublesSketchTest.testSketchEquality((DoublesSketch)huds, (DoublesSketch)target1);
        WritableMemory mem1 = WritableMemory.writableWrap((byte[])huds.toByteArray());
        DirectUpdateDoublesSketch duds = (DirectUpdateDoublesSketch)UpdateDoublesSketch.wrap((WritableMemory)mem1);
        HeapUpdateDoublesSketch target2 = DoublesUtil.copyToHeap((DoublesSketch)duds);
        DoublesSketchTest.testSketchEquality((DoublesSketch)huds, (DoublesSketch)duds);
        DoublesSketchTest.testSketchEquality((DoublesSketch)duds, (DoublesSketch)target2);
        CompactDoublesSketch hcds = huds.compact();
        HeapUpdateDoublesSketch target3 = DoublesUtil.copyToHeap((DoublesSketch)hcds);
        DoublesSketchTest.testSketchEquality((DoublesSketch)huds, (DoublesSketch)hcds);
        DoublesSketchTest.testSketchEquality((DoublesSketch)hcds, (DoublesSketch)target3);
        Memory mem2 = Memory.wrap((byte[])hcds.toByteArray());
        DirectCompactDoublesSketch dcds = (DirectCompactDoublesSketch)DoublesSketch.wrap((Memory)mem2);
        HeapUpdateDoublesSketch target4 = DoublesUtil.copyToHeap((DoublesSketch)dcds);
        DoublesSketchTest.testSketchEquality((DoublesSketch)huds, (DoublesSketch)dcds);
        DoublesSketchTest.testSketchEquality((DoublesSketch)dcds, (DoublesSketch)target4);
    }

    @Test
    public void printlnTest() {
        DoublesUtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
        DoublesUtilTest.print(s + ClassicUtil.LS);
    }

    static void print(String s) {
    }
}

