/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.testng.Assert;

public class KllFloatsValidationTest {
    private static final long[] correctResultsWithReset = new long[]{0L, 200L, 180L, 3246533L, 1L, 180L, 1098352976109474698L, 1L, 200L, 198L, 8349603L, 1L, 198L, 686681527497651888L, 2L, 200L, 217L, 676491L, 2L, 117L, 495856134049157644L, 3L, 200L, 238L, 3204507L, 2L, 138L, 44453438498725402L, 4L, 200L, 261L, 2459373L, 2L, 161L, 719830627391926938L, 5L, 200L, 287L, 5902143L, 2L, 187L, 389303173170515580L, 6L, 200L, 315L, 5188793L, 2L, 215L, 985218890825795000L, 7L, 200L, 346L, 801923L, 2L, 246L, 589362992166904413L, 8L, 200L, 380L, 2466269L, 2L, 280L, 1081848693781775853L, 9L, 200L, 418L, 5968041L, 2L, 318L, 533825689515788397L, 10L, 200L, 459L, 3230027L, 2L, 243L, 937332670315558786L, 11L, 200L, 504L, 5125875L, 2L, 288L, 1019197831515566845L, 12L, 200L, 554L, 4195571L, 3L, 230L, 797351479150148224L, 13L, 200L, 609L, 2221181L, 3L, 285L, 451246040374318529L, 14L, 200L, 669L, 5865503L, 3L, 345L, 253851269470815909L, 15L, 200L, 735L, 831703L, 3L, 411L, 491974970526372303L, 16L, 200L, 808L, 4830785L, 3L, 327L, 1032107507126916277L, 17L, 200L, 888L, 1356257L, 3L, 407L, 215225420986342944L, 18L, 200L, 976L, 952071L, 3L, 417L, 600280049738270697L, 19L, 200L, 1073L, 6729833L, 3L, 397L, 341758522977365969L, 20L, 200L, 1180L, 6017925L, 3L, 406L, 1080227312339182949L, 21L, 200L, 1298L, 4229891L, 3L, 401L, 1092460534756675086L, 22L, 200L, 1427L, 7264889L, 4L, 320L, 884533400696890024L, 23L, 200L, 1569L, 5836327L, 4L, 462L, 660575800011134382L, 24L, 200L, 1725L, 5950087L, 4L, 416L, 669373957401387528L, 25L, 200L, 1897L, 2692555L, 4L, 406L, 607308667566496888L, 26L, 200L, 2086L, 1512443L, 4L, 459L, 744260340112029032L, 27L, 200L, 2294L, 2681171L, 4L, 434L, 199120609113802485L, 28L, 200L, 2523L, 3726521L, 4L, 450L, 570993497599288304L, 29L, 200L, 2775L, 2695247L, 4L, 442L, 306717093329516310L, 30L, 200L, 3052L, 5751175L, 5L, 400L, 256024589545754217L, 31L, 200L, 3357L, 1148897L, 5L, 514L, 507276662329207479L, 32L, 200L, 3692L, 484127L, 5L, 457L, 1082660223488175122L, 33L, 200L, 4061L, 6414559L, 5L, 451L, 620820308918522117L, 34L, 200L, 4467L, 5587461L, 5L, 466L, 121975084804459305L, 35L, 200L, 4913L, 1615017L, 5L, 483L, 152986529342916376L, 36L, 200L, 5404L, 6508535L, 5L, 492L, 858526451332425960L, 37L, 200L, 5944L, 2991657L, 5L, 492L, 624906434274621995L, 38L, 200L, 6538L, 6736565L, 6L, 511L, 589153542019036049L, 39L, 200L, 7191L, 1579893L, 6L, 507L, 10255312374117907L, 40L, 200L, 7910L, 412509L, 6L, 538L, 570863587164194186L, 41L, 200L, 8701L, 1112089L, 6L, 477L, 553100668286355347L, 42L, 200L, 9571L, 1258813L, 6L, 526L, 344845406406036297L, 43L, 200L, 10528L, 1980049L, 6L, 508L, 411846569527905064L, 44L, 200L, 11580L, 2167127L, 6L, 520L, 966876726203675488L, 45L, 200L, 12738L, 1975435L, 7L, 561L, 724125506920592732L, 46L, 200L, 14011L, 4289627L, 7L, 560L, 753686005174215572L, 47L, 200L, 15412L, 5384001L, 7L, 494L, 551637841878573955L, 48L, 200L, 16953L, 2902685L, 7L, 560L, 94602851752354802L, 49L, 200L, 18648L, 4806445L, 7L, 562L, 597672400688514221L, 50L, 200L, 20512L, 2085L, 7L, 529L, 417280161591969960L, 51L, 200L, 22563L, 6375939L, 7L, 558L, 11300453985206678L, 52L, 200L, 24819L, 7837057L, 7L, 559L, 283668599967437754L, 53L, 200L, 27300L, 6607975L, 8L, 561L, 122183647493325363L, 54L, 200L, 30030L, 1519191L, 8L, 550L, 1145227891427321202L, 55L, 200L, 33033L, 808061L, 8L, 568L, 71070843834364939L, 56L, 200L, 36336L, 2653529L, 8L, 570L, 450311772805359006L, 57L, 200L, 39969L, 2188957L, 8L, 561L, 269670427054904115L, 58L, 200L, 43965L, 5885655L, 8L, 539L, 1039064186324091890L, 59L, 200L, 48361L, 6185889L, 8L, 574L, 178055275082387938L, 60L, 200L, 53197L, 208767L, 9L, 579L, 139766040442973048L, 61L, 200L, 58516L, 2551345L, 9L, 569L, 322655279254252950L, 62L, 200L, 64367L, 1950873L, 9L, 569L, 101542216315768285L, 63L, 200L, 70803L, 2950429L, 9L, 582L, 72294008568551853L, 64L, 200L, 77883L, 3993977L, 9L, 572L, 299014330559512530L, 65L, 200L, 85671L, 428871L, 9L, 585L, 491351721800568188L, 66L, 200L, 94238L, 6740849L, 9L, 577L, 656204268858348899L, 67L, 200L, 103661L, 2315497L, 9L, 562L, 829926273188300764L, 68L, 200L, 114027L, 5212835L, 10L, 581L, 542222554617639557L, 69L, 200L, 125429L, 4213475L, 10L, 593L, 713339189579860773L, 70L, 200L, 137971L, 2411583L, 10L, 592L, 649651658985845357L, 71L, 200L, 151768L, 5243307L, 10L, 567L, 1017459402785275179L, 72L, 200L, 166944L, 2468367L, 10L, 593L, 115034451827634398L, 73L, 200L, 183638L, 2210923L, 10L, 583L, 365735165000548572L, 74L, 200L, 202001L, 321257L, 10L, 591L, 928479940794929153L, 75L, 200L, 222201L, 8185105L, 11L, 600L, 780163958693677795L, 76L, 200L, 244421L, 6205349L, 11L, 598L, 132454307780236135L, 77L, 200L, 268863L, 3165901L, 11L, 600L, 369824066179493948L, 78L, 200L, 295749L, 2831723L, 11L, 595L, 80968411797441666L, 79L, 200L, 325323L, 464193L, 11L, 594L, 125773061716381917L, 80L, 200L, 357855L, 7499035L, 11L, 576L, 994150328579932916L, 81L, 200L, 393640L, 1514479L, 11L, 596L, 111092193875842594L, 82L, 200L, 433004L, 668493L, 12L, 607L, 497338041653302784L, 83L, 200L, 476304L, 3174931L, 12L, 606L, 845986926165673887L, 84L, 200L, 523934L, 914611L, 12L, 605L, 354993119685278556L, 85L, 200L, 576327L, 7270385L, 12L, 602L, 937679531753465428L, 86L, 200L, 633959L, 1956979L, 12L, 598L, 659413123921208266L, 87L, 200L, 697354L, 3137635L, 12L, 606L, 874228711599628459L, 88L, 200L, 767089L, 214923L, 12L, 608L, 1077644643342432307L, 89L, 200L, 843797L, 3084545L, 13L, 612L, 79317113064339979L, 90L, 200L, 928176L, 7800899L, 13L, 612L, 357414065779796772L, 91L, 200L, 1020993L, 6717253L, 13L, 615L, 532723577905833296L, 92L, 200L, 1123092L, 5543015L, 13L, 614L, 508695073250223746L, 93L, 200L, 1235401L, 298785L, 13L, 616L, 34344606952783179L, 94L, 200L, 1358941L, 4530313L, 13L, 607L, 169924026179364121L, 95L, 200L, 1494835L, 4406457L, 13L, 612L, 1026773494313671061L, 96L, 200L, 1644318L, 1540983L, 13L, 614L, 423454640036650614L, 97L, 200L, 1808749L, 7999631L, 14L, 624L, 466122870338520329L, 98L, 200L, 1989623L, 4295537L, 14L, 621L, 609309853701283445L, 99L, 200L, 2188585L, 7379971L, 14L, 622L, 141739898871015642L, 100L, 200L, 2407443L, 6188931L, 14L, 621L, 22515080776738923L, 101L, 200L, 2648187L, 6701239L, 14L, 619L, 257441864177795548L, 102L, 200L, 2913005L, 2238709L, 14L, 623L, 867028825821064773L, 103L, 200L, 3204305L, 5371075L, 14L, 625L, 1110615471273395112L, 104L, 200L, 3524735L, 7017341L, 15L, 631L, 619518037415974467L, 105L, 200L, 3877208L, 323337L, 15L, 633L, 513230912593541122L, 106L, 200L, 4264928L, 6172471L, 15L, 628L, 885861662583325072L, 107L, 200L, 4691420L, 5653803L, 15L, 633L, 754052473303005204L, 108L, 200L, 5160562L, 1385265L, 15L, 630L, 294993765757975100L, 109L, 200L, 5676618L, 4350899L, 15L, 617L, 1073144684944932303L, 110L, 200L, 6244279L, 1272235L, 15L, 630L, 308982934296855020L, 111L, 200L, 6868706L, 1763939L, 16L, 638L, 356231694823272867L, 112L, 200L, 7555576L, 3703411L, 16L, 636L, 20043268926300101L, 113L, 200L, 8311133L, 6554171L, 16L, 637L, 121111429906734123L};

    private static int[] makeInputArray(int n, int stride) {
        assert (Util.isOdd((long)stride));
        int mask = 0x7FFFFF;
        int cur = 0;
        int[] arr = new int[n];
        for (int i = 0; i < n; ++i) {
            cur += stride;
            arr[i] = cur &= mask;
        }
        return arr;
    }

    public void testMakeInputArray() {
        int[] array = new int[]{3654721, 7309442, 2575555, 6230276, 1496389, 5151110};
        Assert.assertEquals((int[])KllFloatsValidationTest.makeInputArray(6, 3654721), (int[])array);
    }

    private static long simpleHashOfSubArray(float[] arr, int start, int subLength) {
        long multiplier = 738219921L;
        long mask60 = 0xFFFFFFFFFFFFFFFL;
        long accum = 0L;
        for (int i = start; i < start + subLength; ++i) {
            accum += (long)arr[i];
            accum *= 738219921L;
            accum &= 0xFFFFFFFFFFFFFFFL;
            accum ^= accum >> 30;
        }
        return accum;
    }

    public void testHash() {
        float[] array = new float[]{907500.0f, 944104.0f, 807020.0f, 219921.0f, 678370.0f, 955217.0f, 426885.0f};
        Assert.assertEquals((long)KllFloatsValidationTest.simpleHashOfSubArray(array, 1, 5), (long)1141543353991880193L);
    }

    public void checkTestResults() {
        int numTests = correctResultsWithReset.length / 7;
        for (int testI = 0; testI < numTests; ++testI) {
            assert ((int)correctResultsWithReset[7 * testI] == testI);
            int k = (int)correctResultsWithReset[7 * testI + 1];
            int n = (int)correctResultsWithReset[7 * testI + 2];
            int stride = (int)correctResultsWithReset[7 * testI + 3];
            int[] inputArray = KllFloatsValidationTest.makeInputArray(n, stride);
            KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance((int)k);
            for (int i = 0; i < n; ++i) {
                sketch.update((float)inputArray[i]);
            }
            int numLevels = sketch.getNumLevels();
            int numSamples = sketch.getNumRetained();
            int[] levels = sketch.getLevelsArray();
            long hashedSamples = KllFloatsValidationTest.simpleHashOfSubArray(sketch.getFloatItemsArray(), levels[0], numSamples);
            System.out.print(testI);
            assert (correctResultsWithReset[7 * testI + 4] == (long)numLevels);
            assert (correctResultsWithReset[7 * testI + 5] == (long)numSamples);
            assert (correctResultsWithReset[7 * testI + 6] == hashedSamples);
            if (correctResultsWithReset[7 * testI + 6] != hashedSamples) {
                System.out.print(" " + correctResultsWithReset[7 * testI + 6] + " != " + hashedSamples);
                System.out.println(" fail");
                System.out.println(sketch.toString(true, true));
                break;
            }
            System.out.println(" pass");
        }
    }
}

