/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

final class KllPreambleUtil {
    static final String LS = System.getProperty("line.separator");
    static final int PREAMBLE_INTS_BYTE_ADR = 0;
    static final int SER_VER_BYTE_ADR = 1;
    static final int FAMILY_BYTE_ADR = 2;
    static final int FLAGS_BYTE_ADR = 3;
    static final int K_SHORT_ADR = 4;
    static final int M_BYTE_ADR = 6;
    static final int DATA_START_ADR_SINGLE_ITEM = 8;
    static final int N_LONG_ADR = 8;
    static final int MIN_K_SHORT_ADR = 16;
    static final int NUM_LEVELS_BYTE_ADR = 18;
    static final int DATA_START_ADR = 20;
    static final byte SERIAL_VERSION_EMPTY_FULL = 1;
    static final byte SERIAL_VERSION_SINGLE = 2;
    static final byte SERIAL_VERSION_UPDATABLE = 3;
    static final byte PREAMBLE_INTS_EMPTY_SINGLE = 2;
    static final byte PREAMBLE_INTS_FULL = 5;
    static final byte KLL_FAMILY = 15;
    static final int EMPTY_BIT_MASK = 1;
    static final int LEVEL_ZERO_SORTED_BIT_MASK = 2;
    static final int SINGLE_ITEM_BIT_MASK = 4;
    static final int DOUBLES_SKETCH_BIT_MASK = 8;
    static final int UPDATABLE_BIT_MASK = 16;

    private KllPreambleUtil() {
    }

    static String toString(byte[] byteArr, boolean includeData) {
        Memory mem = Memory.wrap((byte[])byteArr);
        return KllPreambleUtil.toString(mem, includeData);
    }

    static String toString(Memory mem, boolean includeData) {
        KllMemoryValidate memVal = new KllMemoryValidate(mem);
        int flags = memVal.flags & 0xFF;
        String flagsStr = flags + ", 0x" + Integer.toHexString(flags) + ", " + Util.zeroPad(Integer.toBinaryString(flags), 8);
        int preInts = memVal.preInts;
        boolean doublesSketch = memVal.doublesSketch;
        boolean updatableMemFormat = memVal.updatableMemFormat;
        boolean empty = memVal.empty;
        boolean singleItem = memVal.singleItem;
        int sketchBytes = memVal.sketchBytes;
        int typeBytes = memVal.typeBytes;
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS).append("### KLL SKETCH MEMORY SUMMARY:").append(LS);
        sb.append("Byte   0   : Preamble Ints       : ").append(preInts).append(LS);
        sb.append("Byte   1   : SerVer              : ").append(memVal.serVer).append(LS);
        sb.append("Byte   2   : FamilyID            : ").append(memVal.familyID).append(LS);
        sb.append("             FamilyName          : ").append(memVal.famName).append(LS);
        sb.append("Byte   3   : Flags Field         : ").append(flagsStr).append(LS);
        sb.append("         Bit Flag Name").append(LS);
        sb.append("           0 EMPTY COMPACT       : ").append(empty).append(LS);
        sb.append("           1 LEVEL_ZERO_SORTED   : ").append(memVal.level0Sorted).append(LS);
        sb.append("           2 SINGLE_ITEM COMPACT : ").append(singleItem).append(LS);
        sb.append("           3 DOUBLES_SKETCH      : ").append(doublesSketch).append(LS);
        sb.append("           4 UPDATABLE           : ").append(updatableMemFormat).append(LS);
        sb.append("Bytes  4-5 : K                   : ").append(memVal.k).append(LS);
        sb.append("Byte   6   : Min Level Cap, M    : ").append(memVal.m).append(LS);
        sb.append("Byte   7   : (Reserved)          : ").append(LS);
        long n = memVal.n;
        int minK = memVal.minK;
        int numLevels = memVal.numLevels;
        if (updatableMemFormat || !empty && !singleItem) {
            sb.append("Bytes  8-15: N                   : ").append(n).append(LS);
            sb.append("Bytes 16-17: MinK                : ").append(minK).append(LS);
            sb.append("Byte  18   : NumLevels           : ").append(numLevels).append(LS);
        } else {
            sb.append("Assumed    : N                   : ").append(n).append(LS);
            sb.append("Assumed    : MinK                : ").append(minK).append(LS);
            sb.append("Assumed    : NumLevels           : ").append(numLevels).append(LS);
        }
        sb.append("PreambleBytes                    : ").append(preInts * 4).append(LS);
        sb.append("Sketch Bytes                     : ").append(sketchBytes).append(LS);
        sb.append("Memory Capacity Bytes            : ").append(mem.getCapacity()).append(LS);
        sb.append("### END KLL Sketch Memory Summary").append(LS);
        if (includeData) {
            sb.append(LS);
            sb.append("### START KLL DATA:").append(LS);
            int offsetBytes = 0;
            if (updatableMemFormat) {
                sb.append("LEVELS ARR:").append(LS);
                offsetBytes = 20;
                for (int i = 0; i < numLevels + 1; ++i) {
                    sb.append(i + ", " + mem.getInt((long)offsetBytes)).append(LS);
                    offsetBytes += 4;
                }
                sb.append("MIN/MAX:").append(LS);
                if (doublesSketch) {
                    sb.append(mem.getDouble((long)offsetBytes)).append(LS);
                    sb.append(mem.getDouble((long)(offsetBytes += typeBytes))).append(LS);
                    offsetBytes += typeBytes;
                } else {
                    sb.append(mem.getFloat((long)offsetBytes)).append(LS);
                    sb.append(mem.getFloat((long)(offsetBytes += typeBytes))).append(LS);
                    offsetBytes += typeBytes;
                }
                sb.append("ITEMS DATA").append(LS);
                int itemsSpace = (sketchBytes - offsetBytes) / typeBytes;
                if (doublesSketch) {
                    for (int i = 0; i < itemsSpace; ++i) {
                        sb.append(i + ", " + mem.getDouble((long)offsetBytes)).append(LS);
                        offsetBytes += typeBytes;
                    }
                } else {
                    for (int i = 0; i < itemsSpace; ++i) {
                        sb.append(mem.getFloat((long)offsetBytes)).append(LS);
                        offsetBytes += typeBytes;
                    }
                }
            } else if (!empty && !singleItem) {
                sb.append("LEVELS ARR:").append(LS);
                offsetBytes = 20;
                for (int i = 0; i < numLevels; ++i) {
                    sb.append(i + ", " + mem.getInt((long)offsetBytes)).append(LS);
                    offsetBytes += 4;
                }
                sb.append("(top level of Levels arr is absent)").append(LS);
                sb.append("MIN/MAX:").append(LS);
                if (doublesSketch) {
                    sb.append(mem.getDouble((long)offsetBytes)).append(LS);
                    sb.append(mem.getDouble((long)(offsetBytes += typeBytes))).append(LS);
                    offsetBytes += typeBytes;
                } else {
                    sb.append(mem.getFloat((long)offsetBytes)).append(LS);
                    sb.append(mem.getFloat((long)(offsetBytes += typeBytes))).append(LS);
                    offsetBytes += typeBytes;
                }
                sb.append("ITEMS DATA").append(LS);
                int itemSpace = (sketchBytes - offsetBytes) / typeBytes;
                if (doublesSketch) {
                    for (int i = 0; i < itemSpace; ++i) {
                        sb.append(i + ", " + mem.getDouble((long)offsetBytes)).append(LS);
                        offsetBytes += typeBytes;
                    }
                } else {
                    for (int i = 0; i < itemSpace; ++i) {
                        sb.append(i + ", " + mem.getFloat((long)offsetBytes)).append(LS);
                        offsetBytes += typeBytes;
                    }
                }
            } else if (singleItem) {
                sb.append("SINGLE ITEM DATA").append(LS);
                sb.append(doublesSketch ? mem.getDouble(8L) : (double)mem.getFloat(8L)).append(LS);
            }
            sb.append("### END KLL DATA:").append(LS);
        }
        return sb.toString();
    }

    static int getMemoryPreInts(Memory mem) {
        return mem.getByte(0L) & 0xFF;
    }

    static int getMemorySerVer(Memory mem) {
        return mem.getByte(1L) & 0xFF;
    }

    static int getMemoryFamilyID(Memory mem) {
        return mem.getByte(2L) & 0xFF;
    }

    static int getMemoryFlags(Memory mem) {
        return mem.getByte(3L) & 0xFF;
    }

    static boolean getMemoryEmptyFlag(Memory mem) {
        return (KllPreambleUtil.getMemoryFlags(mem) & 1) != 0;
    }

    static boolean getMemoryLevelZeroSortedFlag(Memory mem) {
        return (KllPreambleUtil.getMemoryFlags(mem) & 2) != 0;
    }

    static boolean getMemorySingleItemFlag(Memory mem) {
        return (KllPreambleUtil.getMemoryFlags(mem) & 4) != 0;
    }

    static boolean getMemoryDoubleSketchFlag(Memory mem) {
        return (KllPreambleUtil.getMemoryFlags(mem) & 8) != 0;
    }

    static boolean getMemoryUpdatableFormatFlag(Memory mem) {
        return (KllPreambleUtil.getMemoryFlags(mem) & 0x10) != 0;
    }

    static int getMemoryK(Memory mem) {
        return mem.getShort(4L) & 0xFFFF;
    }

    static int getMemoryM(Memory mem) {
        return mem.getByte(6L) & 0xFF;
    }

    static long getMemoryN(Memory mem) {
        return mem.getLong(8L);
    }

    static int getMemoryMinK(Memory mem) {
        return mem.getShort(16L) & 0xFFFF;
    }

    static int getMemoryNumLevels(Memory mem) {
        return mem.getByte(18L) & 0xFF;
    }

    static void setMemoryPreInts(WritableMemory wmem, int numPreInts) {
        wmem.putByte(0L, (byte)numPreInts);
    }

    static void setMemorySerVer(WritableMemory wmem, int serVer) {
        wmem.putByte(1L, (byte)serVer);
    }

    static void setMemoryFamilyID(WritableMemory wmem, int famId) {
        wmem.putByte(2L, (byte)famId);
    }

    static void setMemoryFlags(WritableMemory wmem, int flags) {
        wmem.putByte(3L, (byte)flags);
    }

    static void setMemoryEmptyFlag(WritableMemory wmem, boolean empty) {
        int flags = KllPreambleUtil.getMemoryFlags((Memory)wmem);
        KllPreambleUtil.setMemoryFlags(wmem, empty ? flags | 1 : flags & 0xFFFFFFFE);
    }

    static void setMemoryLevelZeroSortedFlag(WritableMemory wmem, boolean levelZeroSorted) {
        int flags = KllPreambleUtil.getMemoryFlags((Memory)wmem);
        KllPreambleUtil.setMemoryFlags(wmem, levelZeroSorted ? flags | 2 : flags & 0xFFFFFFFD);
    }

    static void setMemorySingleItemFlag(WritableMemory wmem, boolean singleItem) {
        int flags = KllPreambleUtil.getMemoryFlags((Memory)wmem);
        KllPreambleUtil.setMemoryFlags(wmem, singleItem ? flags | 4 : flags & 0xFFFFFFFB);
    }

    static void setMemoryDoubleSketchFlag(WritableMemory wmem, boolean doubleSketch) {
        int flags = KllPreambleUtil.getMemoryFlags((Memory)wmem);
        KllPreambleUtil.setMemoryFlags(wmem, doubleSketch ? flags | 8 : flags & 0xFFFFFFF7);
    }

    static void setMemoryUpdatableFlag(WritableMemory wmem, boolean updatable) {
        int flags = KllPreambleUtil.getMemoryFlags((Memory)wmem);
        KllPreambleUtil.setMemoryFlags(wmem, updatable ? flags | 0x10 : flags & 0xFFFFFFEF);
    }

    static void setMemoryK(WritableMemory wmem, int memK) {
        wmem.putShort(4L, (short)memK);
    }

    static void setMemoryM(WritableMemory wmem, int memM) {
        wmem.putByte(6L, (byte)memM);
    }

    static void setMemoryN(WritableMemory wmem, long memN) {
        wmem.putLong(8L, memN);
    }

    static void setMemoryMinK(WritableMemory wmem, int memMinK) {
        wmem.putShort(16L, (short)memMinK);
    }

    static void setMemoryNumLevels(WritableMemory wmem, int memNumLevels) {
        wmem.putByte(18L, (byte)memNumLevels);
    }
}

