/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.common.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.CompactDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ForwardCompatibilityTest {
    private static final String LS = System.getProperty("line.separator");

    @Test
    public void check030_50() {
        int n = 50;
        String ver = "0.3.0";
        double expected = 26.0;
        ForwardCompatibilityTest.getAndCheck(ver, n, expected);
    }

    @Test
    public void check030_1000() {
        int n = 1000;
        String ver = "0.3.0";
        double expected = 501.0;
        ForwardCompatibilityTest.getAndCheck(ver, n, expected);
    }

    @Test
    public void check060_50() {
        int n = 50;
        String ver = "0.6.0";
        double expected = 26.0;
        ForwardCompatibilityTest.getAndCheck(ver, n, expected);
    }

    @Test
    public void check060_1000() {
        int n = 1000;
        String ver = "0.6.0";
        double expected = 501.0;
        ForwardCompatibilityTest.getAndCheck(ver, n, expected);
    }

    @Test
    public void check080_50() {
        int n = 50;
        String ver = "0.8.0";
        double expected = 26.0;
        ForwardCompatibilityTest.getAndCheck(ver, n, expected);
    }

    @Test
    public void check080_1000() {
        int n = 1000;
        String ver = "0.8.0";
        double expected = 501.0;
        ForwardCompatibilityTest.getAndCheck(ver, n, expected);
    }

    @Test
    public void check083_50() {
        int n = 50;
        String ver = "0.8.3";
        double expected = 26.0;
        ForwardCompatibilityTest.getAndCheck(ver, n, expected);
    }

    @Test
    public void check083_1000() {
        int n = 1000;
        String ver = "0.8.3";
        double expected = 501.0;
        ForwardCompatibilityTest.getAndCheck(ver, n, expected);
    }

    private static void getAndCheck(String ver, int n, double quantile) {
        DoublesSketch.rand.setSeed(131L);
        int k = 128;
        double nf = 0.5;
        String fileName = String.format("Qk%d_n%d_v%s.sk", k, n, ver);
        ForwardCompatibilityTest.println("fullName: " + fileName);
        ForwardCompatibilityTest.println("Old Median: " + quantile);
        byte[] byteArr2 = Util.getResourceBytes((String)fileName);
        Memory srcMem = Memory.wrap((byte[])byteArr2);
        UpdateDoublesSketch qs2 = UpdateDoublesSketch.heapify((Memory)srcMem);
        double q2 = qs2.getQuantile(nf, QuantileSearchCriteria.EXCLUSIVE);
        ForwardCompatibilityTest.println("New Median: " + q2);
        Assert.assertEquals((double)q2, (double)quantile, (double)0.0);
        qs2 = CompactDoublesSketch.heapify((Memory)srcMem);
        q2 = qs2.getQuantile(nf, QuantileSearchCriteria.EXCLUSIVE);
        ForwardCompatibilityTest.println("New Median: " + q2);
        Assert.assertEquals((double)q2, (double)quantile, (double)0.0);
    }

    @Test
    public void printlnTest() {
        ForwardCompatibilityTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
        if (o == null) {
            ForwardCompatibilityTest.print(LS);
        } else {
            ForwardCompatibilityTest.print(o.toString() + LS);
        }
    }

    static void print(Object o) {
        if (o != null) {
            // empty if block
        }
    }
}

