/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.DoublesSortedView;
import org.apache.datasketches.quantilescommon.DoublesSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDoublesSketchTest {
    private static final double PMF_EPS_FOR_K_8 = 0.35;
    private static final double PMF_EPS_FOR_K_128 = 0.025;
    private static final double PMF_EPS_FOR_K_256 = 0.013;
    private static final double NUMERIC_NOISE_TOLERANCE = 1.0E-6;
    private static final DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();
    private static final boolean enablePrinting = false;

    @Test
    public void empty() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(Double.NaN);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)0);
        try {
            sketch.getMinItem();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getMaxItem();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantile(0.5);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantiles(new double[]{0.0});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getPMF(new double[]{0.0});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)sketch.toString(true, true));
        Assert.assertNotNull((Object)sketch.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantileInvalidArg() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(1.0);
        sketch.getQuantile(-1.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantilesInvalidArg() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(1.0);
        sketch.getQuantiles(new double[]{2.0});
    }

    @Test
    public void oneValue() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(1.0);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)1);
        Assert.assertEquals((double)sketch.getRank(0.0, QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)sketch.getRank(1.0, QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)sketch.getRank(2.0, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getRank(0.0, QuantileSearchCriteria.INCLUSIVE), (double)0.0);
        Assert.assertEquals((double)sketch.getRank(1.0, QuantileSearchCriteria.INCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getRank(2.0, QuantileSearchCriteria.INCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sketch.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sketch.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getQuantile(0.5, QuantileSearchCriteria.INCLUSIVE), (double)1.0);
    }

    @Test
    public void tenValues() {
        int i;
        int i2;
        int i3;
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        for (i3 = 1; i3 <= 10; ++i3) {
            sketch.update((double)i3);
        }
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)10L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)10);
        for (i3 = 1; i3 <= 10; ++i3) {
            Assert.assertEquals((double)sketch.getRank((double)i3, QuantileSearchCriteria.EXCLUSIVE), (double)((double)(i3 - 1) / 10.0));
            Assert.assertEquals((double)sketch.getRank((double)i3, QuantileSearchCriteria.EXCLUSIVE), (double)((double)(i3 - 1) / 10.0));
            Assert.assertEquals((double)sketch.getRank((double)i3, QuantileSearchCriteria.INCLUSIVE), (double)((double)i3 / 10.0));
        }
        double[] qArr = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        double[] rOut = sketch.getRanks(qArr);
        for (i2 = 0; i2 < qArr.length; ++i2) {
            Assert.assertEquals((double)rOut[i2], (double)((double)(i2 + 1) / 10.0));
        }
        rOut = sketch.getRanks(qArr, QuantileSearchCriteria.EXCLUSIVE);
        for (i2 = 0; i2 < qArr.length; ++i2) {
            Assert.assertEquals((double)rOut[i2], (double)((double)i2 / 10.0));
        }
        Assert.assertEquals((double)sketch.getQuantile(0.0, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getQuantile(0.1, QuantileSearchCriteria.EXCLUSIVE), (double)2.0);
        Assert.assertEquals((double)sketch.getQuantile(0.2, QuantileSearchCriteria.EXCLUSIVE), (double)3.0);
        Assert.assertEquals((double)sketch.getQuantile(0.3, QuantileSearchCriteria.EXCLUSIVE), (double)4.0);
        Assert.assertEquals((double)sketch.getQuantile(0.4, QuantileSearchCriteria.EXCLUSIVE), (double)5.0);
        Assert.assertEquals((double)sketch.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (double)6.0);
        Assert.assertEquals((double)sketch.getQuantile(0.6, QuantileSearchCriteria.EXCLUSIVE), (double)7.0);
        Assert.assertEquals((double)sketch.getQuantile(0.7, QuantileSearchCriteria.EXCLUSIVE), (double)8.0);
        Assert.assertEquals((double)sketch.getQuantile(0.8, QuantileSearchCriteria.EXCLUSIVE), (double)9.0);
        Assert.assertEquals((double)sketch.getQuantile(0.9, QuantileSearchCriteria.EXCLUSIVE), (double)10.0);
        Assert.assertEquals((double)sketch.getQuantile(1.0, QuantileSearchCriteria.EXCLUSIVE), (double)10.0);
        Assert.assertEquals((double)sketch.getQuantile(0.0, QuantileSearchCriteria.INCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getQuantile(0.1, QuantileSearchCriteria.INCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getQuantile(0.2, QuantileSearchCriteria.INCLUSIVE), (double)2.0);
        Assert.assertEquals((double)sketch.getQuantile(0.3, QuantileSearchCriteria.INCLUSIVE), (double)3.0);
        Assert.assertEquals((double)sketch.getQuantile(0.4, QuantileSearchCriteria.INCLUSIVE), (double)4.0);
        Assert.assertEquals((double)sketch.getQuantile(0.5, QuantileSearchCriteria.INCLUSIVE), (double)5.0);
        Assert.assertEquals((double)sketch.getQuantile(0.6, QuantileSearchCriteria.INCLUSIVE), (double)6.0);
        Assert.assertEquals((double)sketch.getQuantile(0.7, QuantileSearchCriteria.INCLUSIVE), (double)7.0);
        Assert.assertEquals((double)sketch.getQuantile(0.8, QuantileSearchCriteria.INCLUSIVE), (double)8.0);
        Assert.assertEquals((double)sketch.getQuantile(0.9, QuantileSearchCriteria.INCLUSIVE), (double)9.0);
        Assert.assertEquals((double)sketch.getQuantile(1.0, QuantileSearchCriteria.INCLUSIVE), (double)10.0);
        double[] quantiles = sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9}, QuantileSearchCriteria.EXCLUSIVE);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((double)sketch.getQuantile((double)i / 10.0, QuantileSearchCriteria.EXCLUSIVE), (double)quantiles[i]);
        }
        quantiles = sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0}, QuantileSearchCriteria.INCLUSIVE);
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((double)sketch.getQuantile((double)i / 10.0, QuantileSearchCriteria.INCLUSIVE), (double)quantiles[i]);
        }
    }

    @Test
    public void manyValuesEstimationMode() {
        int i;
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        int n = 1000000;
        for (i = 0; i < 1000000; ++i) {
            sketch.update((double)i);
        }
        Assert.assertEquals((long)sketch.getN(), (long)1000000L);
        for (i = 0; i < 1000000; ++i) {
            double trueRank = (double)i / 1000000.0;
            Assert.assertEquals((double)sketch.getRank((double)i), (double)trueRank, (double)0.013, (String)("for value " + i));
        }
        double[] pmf = sketch.getPMF(new double[]{500000.0});
        Assert.assertEquals((int)pmf.length, (int)2);
        Assert.assertEquals((double)pmf[0], (double)0.5, (double)0.013);
        Assert.assertEquals((double)pmf[1], (double)0.5, (double)0.013);
        Assert.assertEquals((double)sketch.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch.getMaxItem(), (double)999999.0);
        double[] fractions = new double[1001];
        double[] reverseFractions = new double[1001];
        for (int i2 = 0; i2 <= 1000; ++i2) {
            fractions[i2] = (double)i2 / 1000.0;
            reverseFractions[1000 - i2] = fractions[i2];
        }
        double[] quantiles = sketch.getQuantiles(fractions);
        double[] reverseQuantiles = sketch.getQuantiles(reverseFractions);
        double previousQuantile = 0.0;
        for (int i3 = 0; i3 <= 1000; ++i3) {
            double quantile = sketch.getQuantile(fractions[i3]);
            Assert.assertEquals((double)quantile, (double)quantiles[i3]);
            Assert.assertEquals((double)quantile, (double)reverseQuantiles[1000 - i3]);
            Assert.assertTrue((previousQuantile <= quantile ? 1 : 0) != 0);
            previousQuantile = quantile;
        }
    }

    @Test
    public void getRankGetCdfGetPmfConsistency() {
        int i;
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        int n = 1000;
        double[] values = new double[1000];
        for (int i2 = 0; i2 < 1000; ++i2) {
            sketch.update((double)i2);
            values[i2] = i2;
        }
        double[] ranks = sketch.getCDF(values);
        double[] pmf = sketch.getPMF(values);
        double sumPmf = 0.0;
        for (i = 0; i < 1000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]), (double)1.0E-6, (String)("rank vs CDF for value " + i));
            Assert.assertEquals((double)ranks[i], (double)(sumPmf += pmf[i]), (double)1.0E-6, (String)("CDF vs PMF for value " + i));
        }
        Assert.assertEquals((double)(sumPmf += pmf[1000]), (double)1.0, (double)1.0E-6);
        Assert.assertEquals((double)ranks[1000], (double)1.0, (double)1.0E-6);
        ranks = sketch.getCDF(values, QuantileSearchCriteria.INCLUSIVE);
        pmf = sketch.getPMF(values, QuantileSearchCriteria.INCLUSIVE);
        sumPmf = 0.0;
        for (i = 0; i < 1000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i], QuantileSearchCriteria.INCLUSIVE), (double)1.0E-6, (String)("rank vs CDF for value " + i));
            Assert.assertEquals((double)ranks[i], (double)(sumPmf += pmf[i]), (double)1.0E-6, (String)("CDF vs PMF for value " + i));
        }
        Assert.assertEquals((double)(sumPmf += pmf[1000]), (double)1.0, (double)1.0E-6);
        Assert.assertEquals((double)ranks[1000], (double)1.0, (double)1.0E-6);
    }

    @Test
    public void merge() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance();
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance();
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((double)i * 1.0);
            sketch2.update((double)(20000 - i - 1) * 1.0);
        }
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)9999.0);
        Assert.assertEquals((double)sketch2.getMinItem(), (double)10000.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)19999.0);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)19999.0);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)130.0);
    }

    @Test
    public void mergeLowerK() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance((int)256);
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance((int)128);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((double)i);
            sketch2.update((double)(20000 - i - 1));
        }
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)9999.0);
        Assert.assertEquals((double)sketch2.getMinItem(), (double)10000.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)19999.0);
        Assert.assertTrue((sketch1.getNormalizedRankError(false) < sketch2.getNormalizedRankError(false) ? 1 : 0) != 0);
        Assert.assertTrue((sketch1.getNormalizedRankError(true) < sketch2.getNormalizedRankError(true) ? 1 : 0) != 0);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(false), (double)sketch2.getNormalizedRankError(false));
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)sketch2.getNormalizedRankError(true));
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)19999.0);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)250.0);
    }

    @Test
    public void mergeEmptyLowerK() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance((int)256);
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance((int)128);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((double)i);
        }
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)9999.0);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)65.0);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)9999.0);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)65.0);
    }

    @Test
    public void mergeExactModeLowerK() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance((int)256);
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance((int)128);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((double)i);
        }
        sketch2.update(1.0);
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
    }

    @Test
    public void mergeMinMinValueFromOther() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance();
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance();
        sketch1.update(1.0);
        sketch2.update(2.0);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((double)sketch2.getMinItem(), (double)1.0);
    }

    @Test
    public void mergeMinAndMaxFromOther() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance();
        for (int i = 1; i <= 1000000; ++i) {
            sketch1.update((double)i);
        }
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance();
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((double)sketch2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)1000000.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooSmall() {
        KllDoublesSketch.newHeapInstance((int)7);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooLarge() {
        KllDoublesSketch.newHeapInstance((int)65536);
    }

    @Test
    public void minK() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance((int)8);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((double)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)8);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)175.0);
    }

    @Test
    public void maxK() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance((int)65535);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((double)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)65535);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)6.5);
    }

    @Test
    public void serializeDeserializeEmpty() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance();
        byte[] bytes = sketch1.toByteArray();
        KllDoublesSketch sketch2 = KllDoublesSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.getCurrentCompactSerializedSizeBytes());
        Assert.assertTrue((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        try {
            sketch2.getMinItem();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch2.getMaxItem();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sketch2.getCurrentCompactSerializedSizeBytes(), (int)sketch1.getCurrentCompactSerializedSizeBytes());
    }

    @Test
    public void serializeDeserializeOneValue() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance();
        sketch1.update(1.0);
        byte[] bytes = sketch1.toByteArray();
        KllDoublesSketch sketch2 = KllDoublesSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.getCurrentCompactSerializedSizeBytes());
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)1);
        Assert.assertEquals((long)sketch2.getN(), (long)1L);
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertEquals((double)sketch2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)1.0);
        Assert.assertEquals((int)sketch2.getCurrentCompactSerializedSizeBytes(), (int)16);
    }

    @Test
    public void serializeDeserialize() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance();
        int n = 1000;
        for (int i = 0; i < 1000; ++i) {
            sketch1.update((double)i);
        }
        byte[] bytes = sketch1.toByteArray();
        KllDoublesSketch sketch2 = KllDoublesSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.getCurrentCompactSerializedSizeBytes());
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertEquals((double)sketch2.getMinItem(), (double)sketch1.getMinItem());
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)sketch1.getMaxItem());
        Assert.assertEquals((int)sketch2.getCurrentCompactSerializedSizeBytes(), (int)sketch1.getCurrentCompactSerializedSizeBytes());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void outOfOrderSplitPoints() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(0.0);
        sketch.getCDF(new double[]{1.0, 0.0});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void nanSplitPoint() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(0.0);
        sketch.getCDF(new double[]{Double.NaN});
    }

    @Test
    public void getQuantiles() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(1.0);
        sketch.update(2.0);
        sketch.update(3.0);
        sketch.update(4.0);
        double[] quantiles1 = sketch.getQuantiles(new double[]{0.0, 0.5, 1.0}, QuantileSearchCriteria.EXCLUSIVE);
        double[] quantiles2 = sketch.getPartitionBoundaries((int)2, (QuantileSearchCriteria)QuantileSearchCriteria.EXCLUSIVE).boundaries;
        Assert.assertEquals((double[])quantiles1, (double[])quantiles2);
        quantiles1 = sketch.getQuantiles(new double[]{0.0, 0.5, 1.0}, QuantileSearchCriteria.INCLUSIVE);
        quantiles2 = sketch.getPartitionBoundaries((int)2, (QuantileSearchCriteria)QuantileSearchCriteria.INCLUSIVE).boundaries;
        Assert.assertEquals((double[])quantiles1, (double[])quantiles2);
    }

    @Test
    public void checkReset() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 100; ++i) {
            sk.update((double)i);
        }
        long n1 = sk.getN();
        double min1 = sk.getMinItem();
        double max1 = sk.getMaxItem();
        sk.reset();
        for (int i = 1; i <= 100; ++i) {
            sk.update((double)i);
        }
        long n2 = sk.getN();
        double min2 = sk.getMinItem();
        double max2 = sk.getMaxItem();
        Assert.assertEquals((long)n2, (long)n1);
        Assert.assertEquals((double)min2, (double)min1);
        Assert.assertEquals((double)max2, (double)max1);
    }

    @Test
    public void coverInheritanceArtifacts() {
        float[] fltArr = new float[]{};
        float fltV = 1.0f;
        int idx = 1;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        try {
            sk.getFloatItemsArray();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMaxFloatItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinFloatItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.setFloatItemsArray(fltArr);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.setFloatItemsArrayAt(idx, fltV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.setMaxFloatItem(fltV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.setMinFloatItem(fltV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkReadOnlyUpdate() {
        KllDoublesSketch sk1 = KllDoublesSketch.newHeapInstance((int)20);
        Memory mem = Memory.wrap((byte[])sk1.toByteArray());
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((Memory)mem);
        try {
            sk2.update(1.0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkNewDirectInstanceAndSize() {
        WritableMemory wmem = WritableMemory.allocate((int)3000);
        KllDoublesSketch.newDirectInstance((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        try {
            KllDoublesSketch.newDirectInstance(null, (MemoryRequestServer)memReqSvr);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            KllFloatsSketch.newDirectInstance((WritableMemory)wmem, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int updateSize = KllDoublesSketch.getMaxSerializedSizeBytes((int)200, (long)0L, (boolean)true);
        int compactSize = KllDoublesSketch.getMaxSerializedSizeBytes((int)200, (long)0L, (boolean)false);
        Assert.assertTrue((compactSize < updateSize ? 1 : 0) != 0);
    }

    @Test
    public void sortedView() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        sk.update(3.0);
        sk.update(1.0);
        sk.update(2.0);
        DoublesSortedView view = sk.getSortedView();
        DoublesSortedViewIterator itr = view.iterator();
        Assert.assertEquals((boolean)itr.next(), (boolean)true);
        Assert.assertEquals((double)itr.getQuantile(), (double)1.0);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.EXCLUSIVE), (long)0L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.INCLUSIVE), (long)1L);
        Assert.assertEquals((boolean)itr.next(), (boolean)true);
        Assert.assertEquals((double)itr.getQuantile(), (double)2.0);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.EXCLUSIVE), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.INCLUSIVE), (long)2L);
        Assert.assertEquals((boolean)itr.next(), (boolean)true);
        Assert.assertEquals((double)itr.getQuantile(), (double)3.0);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.EXCLUSIVE), (long)2L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.INCLUSIVE), (long)3L);
        Assert.assertEquals((boolean)itr.next(), (boolean)false);
    }

    @Test
    public void checkCDF_PDF() {
        int i;
        double[] cdfI = new double[]{0.25, 0.5, 0.75, 1.0, 1.0};
        double[] cdfE = new double[]{0.0, 0.25, 0.5, 0.75, 1.0};
        double[] pmfI = new double[]{0.25, 0.25, 0.25, 0.25, 0.0};
        double[] pmfE = new double[]{0.0, 0.25, 0.25, 0.25, 0.25};
        double toll = 1.0E-10;
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        double[] doublesIn = new double[]{10.0, 20.0, 30.0, 40.0};
        for (int i2 = 0; i2 < doublesIn.length; ++i2) {
            sketch.update(doublesIn[i2]);
        }
        double[] sp = new double[]{10.0, 20.0, 30.0, 40.0};
        KllDoublesSketchTest.println("SplitPoints:");
        for (int i3 = 0; i3 < sp.length; ++i3) {
            KllDoublesSketchTest.printf("%10.2f", sp[i3]);
        }
        KllDoublesSketchTest.println("");
        KllDoublesSketchTest.println("INCLUSIVE:");
        double[] cdf = sketch.getCDF(sp, QuantileSearchCriteria.INCLUSIVE);
        double[] pmf = sketch.getPMF(sp, QuantileSearchCriteria.INCLUSIVE);
        KllDoublesSketchTest.printf("%10s%10s\n", "CDF", "PMF");
        for (i = 0; i < cdf.length; ++i) {
            KllDoublesSketchTest.printf("%10.2f%10.2f\n", cdf[i], pmf[i]);
            Assert.assertEquals((double)cdf[i], (double)cdfI[i], (double)1.0E-10);
            Assert.assertEquals((double)pmf[i], (double)pmfI[i], (double)1.0E-10);
        }
        KllDoublesSketchTest.println("EXCLUSIVE");
        cdf = sketch.getCDF(sp, QuantileSearchCriteria.EXCLUSIVE);
        pmf = sketch.getPMF(sp, QuantileSearchCriteria.EXCLUSIVE);
        KllDoublesSketchTest.printf("%10s%10s\n", "CDF", "PMF");
        for (i = 0; i < cdf.length; ++i) {
            KllDoublesSketchTest.printf("%10.2f%10.2f\n", cdf[i], pmf[i]);
            Assert.assertEquals((double)cdf[i], (double)cdfE[i], (double)1.0E-10);
            Assert.assertEquals((double)pmf[i], (double)pmfE[i], (double)1.0E-10);
        }
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

