/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketches;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HeapArrayOfDoublesCompactSketchTest {
    @Test
    public void emptyFromQuickSelectSketch() {
        ArrayOfDoublesUpdatableSketch us = new ArrayOfDoublesUpdatableSketchBuilder().build();
        ArrayOfDoublesCompactSketch sketch = us.compact();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
        Assert.assertEquals((double)sketch.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)sketch.getUpperBound(1), (double)0.0);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)0);
        Assert.assertEquals((long)sketch.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((double)sketch.getTheta(), (double)1.0);
        Assert.assertNotNull((Object)sketch.getValues());
        Assert.assertEquals((int)sketch.getValues().length, (int)0);
        ArrayOfDoublesSketchIterator it = sketch.iterator();
        while (it.next()) {
            Assert.fail((String)"empty sketch expected");
        }
    }

    @Test
    public void exactModeFromQuickSelectSketch() {
        ArrayOfDoublesUpdatableSketch us = new ArrayOfDoublesUpdatableSketchBuilder().build();
        us.update(1L, new double[]{1.0});
        us.update(2L, new double[]{1.0});
        us.update(3L, new double[]{1.0});
        us.update(1L, new double[]{1.0});
        us.update(2L, new double[]{1.0});
        us.update(3L, new double[]{1.0});
        ArrayOfDoublesCompactSketch sketch = us.compact();
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)3.0);
        Assert.assertEquals((double)sketch.getLowerBound(1), (double)3.0);
        Assert.assertEquals((double)sketch.getUpperBound(1), (double)3.0);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)3);
        Assert.assertEquals((long)sketch.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((double)sketch.getTheta(), (double)1.0);
        double[][] values = sketch.getValues();
        Assert.assertEquals((int)values.length, (int)3);
        for (double[] array : values) {
            Assert.assertEquals((double)array[0], (double)2.0);
        }
    }

    @Test
    public void serializeDeserializeSmallExact() {
        ArrayOfDoublesUpdatableSketch us = new ArrayOfDoublesUpdatableSketchBuilder().build();
        us.update("a", new double[]{1.0});
        us.update("b", new double[]{1.0});
        us.update("c", new double[]{1.0});
        ArrayOfDoublesCompactSketch sketch1 = us.compact();
        ArrayOfDoublesSketch sketch2 = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])sketch1.toByteArray()));
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertFalse((boolean)sketch2.isEstimationMode());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)3.0);
        Assert.assertEquals((double)sketch2.getLowerBound(1), (double)3.0);
        Assert.assertEquals((double)sketch2.getUpperBound(1), (double)3.0);
        Assert.assertEquals((int)sketch2.getRetainedEntries(), (int)3);
        Assert.assertEquals((long)sketch2.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((double)sketch2.getTheta(), (double)1.0);
        double[][] values = sketch2.getValues();
        Assert.assertEquals((int)values.length, (int)3);
        for (double[] array : values) {
            Assert.assertEquals((double)array[0], (double)1.0);
        }
    }

    @Test
    public void serializeDeserializeEstimation() {
        ArrayOfDoublesUpdatableSketch us = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            us.update((long)i, new double[]{1.0});
        }
        WritableMemory wmem = WritableMemory.writableWrap((byte[])us.toByteArray());
        ArrayOfDoublesUpdatableSketch wrappedUS = ArrayOfDoublesSketches.wrapUpdatableSketch((WritableMemory)wmem);
        Assert.assertFalse((boolean)wrappedUS.isEmpty());
        Assert.assertTrue((boolean)wrappedUS.isEstimationMode());
        Assert.assertEquals((double)wrappedUS.getEstimate(), (double)us.getEstimate());
        Assert.assertEquals((long)wrappedUS.getThetaLong(), (long)us.getThetaLong());
        ArrayOfDoublesUpdatableSketch heapUS = ArrayOfDoublesSketches.heapifyUpdatableSketch((Memory)wmem);
        Assert.assertFalse((boolean)heapUS.isEmpty());
        Assert.assertTrue((boolean)heapUS.isEstimationMode());
        Assert.assertEquals((double)heapUS.getEstimate(), (double)us.getEstimate());
        Assert.assertEquals((long)heapUS.getThetaLong(), (long)us.getThetaLong());
        ArrayOfDoublesCompactSketch sketch1 = us.compact();
        ArrayOfDoublesSketch sketch2 = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])sketch1.toByteArray()));
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertTrue((boolean)sketch2.isEstimationMode());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)sketch1.getEstimate());
        Assert.assertEquals((long)sketch2.getThetaLong(), (long)sketch1.getThetaLong());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void deserializeWithWrongSeed() {
        ArrayOfDoublesUpdatableSketch us = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            us.update((long)i, new double[]{1.0});
        }
        ArrayOfDoublesCompactSketch sketch1 = us.compact();
        Memory mem = Memory.wrap((byte[])sketch1.toByteArray());
        ArrayOfDoublesSketches.heapifySketch((Memory)mem, (long)123L);
    }
}

