/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Intersection;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.Union;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.datasketches.tuple.adouble.DoubleSummarySetOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TupleExamples2Test {
    private final DoubleSummary.Mode umode = DoubleSummary.Mode.Sum;
    private final DoubleSummary.Mode imode = DoubleSummary.Mode.AlwaysOne;
    private final DoubleSummarySetOperations dsso0 = new DoubleSummarySetOperations();
    private final DoubleSummarySetOperations dsso1 = new DoubleSummarySetOperations(this.umode);
    private final DoubleSummarySetOperations dsso2 = new DoubleSummarySetOperations(this.umode, this.imode);
    private final DoubleSummaryFactory ufactory = new DoubleSummaryFactory(this.umode);
    private final DoubleSummaryFactory ifactory = new DoubleSummaryFactory(this.imode);
    private final UpdateSketchBuilder thetaBldr = UpdateSketch.builder();
    private final UpdatableSketchBuilder<Double, DoubleSummary> tupleBldr = new UpdatableSketchBuilder((SummaryFactory)this.ufactory);

    @Test
    public void example1() {
        UpdatableSketch tupleSk = this.tupleBldr.build();
        UpdateSketch thetaSk = this.thetaBldr.build();
        for (int i = 1; i <= 12; ++i) {
            tupleSk.update((long)i, (Object)1.0);
            thetaSk.update((long)(i + 3));
        }
        Union union = new Union((SummarySetOperations)this.dsso2);
        union.union((Sketch)tupleSk);
        union.union((org.apache.datasketches.theta.Sketch)thetaSk, (Summary)this.ufactory.newSummary().update(Double.valueOf(1.0)));
        CompactSketch ucsk = union.getResult();
        int entries = ucsk.getRetainedEntries();
        TupleExamples2Test.println("Union Stateful: tuple, theta: " + entries);
        SketchIterator uiter = ucsk.iterator();
        int counter = 1;
        int twos = 0;
        int ones = 0;
        while (uiter.next()) {
            int i = (int)((DoubleSummary)uiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            if (i == 1) {
                ++ones;
            }
            if (i != 2) continue;
            ++twos;
        }
        Assert.assertEquals((int)ones, (int)6);
        Assert.assertEquals((int)twos, (int)9);
        Intersection inter = new Intersection((SummarySetOperations)this.dsso2);
        inter.intersect((Sketch)tupleSk);
        inter.intersect((org.apache.datasketches.theta.Sketch)thetaSk, (Summary)this.ifactory.newSummary().update(Double.valueOf(1.0)));
        CompactSketch icsk = inter.getResult();
        entries = icsk.getRetainedEntries();
        TupleExamples2Test.println("Intersection Stateful: tuple, theta: " + entries);
        SketchIterator iiter = icsk.iterator();
        counter = 1;
        while (iiter.next()) {
            int i = (int)((DoubleSummary)iiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            Assert.assertEquals((int)i, (int)1);
        }
    }

    @Test
    public void example2() {
        UpdatableSketch tupleSk1 = this.tupleBldr.build();
        UpdatableSketch tupleSk2 = this.tupleBldr.build();
        for (int i = 1; i <= 12; ++i) {
            tupleSk1.update((long)i, (Object)1.0);
            tupleSk2.update((long)(i + 3), (Object)1.0);
        }
        Union union = new Union((SummarySetOperations)this.dsso2);
        CompactSketch ucsk = union.union((Sketch)tupleSk1, (Sketch)tupleSk2);
        int entries = ucsk.getRetainedEntries();
        TupleExamples2Test.println("Union: " + entries);
        SketchIterator uiter = ucsk.iterator();
        int counter = 1;
        int twos = 0;
        int ones = 0;
        while (uiter.next()) {
            int i = (int)((DoubleSummary)uiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            if (i == 1) {
                ++ones;
            }
            if (i != 2) continue;
            ++twos;
        }
        Assert.assertEquals((int)ones, (int)6);
        Assert.assertEquals((int)twos, (int)9);
        Intersection inter = new Intersection((SummarySetOperations)this.dsso2);
        CompactSketch icsk = inter.intersect((Sketch)tupleSk1, (Sketch)tupleSk2);
        entries = icsk.getRetainedEntries();
        TupleExamples2Test.println("Intersection: " + entries);
        SketchIterator iiter = icsk.iterator();
        counter = 1;
        while (iiter.next()) {
            int i = (int)((DoubleSummary)iiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            Assert.assertEquals((int)i, (int)1);
        }
    }

    @Test
    public void example3() {
        UpdatableSketch tupleSk = this.tupleBldr.build();
        UpdateSketch thetaSk = this.thetaBldr.build();
        for (int i = 1; i <= 12; ++i) {
            tupleSk.update((long)i, (Object)1.0);
            thetaSk.update((long)(i + 3));
        }
        Union union = new Union((SummarySetOperations)this.dsso2);
        CompactSketch ucsk = union.union((Sketch)tupleSk, (org.apache.datasketches.theta.Sketch)thetaSk, (Summary)this.ufactory.newSummary().update(Double.valueOf(1.0)));
        int entries = ucsk.getRetainedEntries();
        TupleExamples2Test.println("Union: " + entries);
        SketchIterator uiter = ucsk.iterator();
        int counter = 1;
        int twos = 0;
        int ones = 0;
        while (uiter.next()) {
            int i = (int)((DoubleSummary)uiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            if (i == 1) {
                ++ones;
            }
            if (i != 2) continue;
            ++twos;
        }
        Assert.assertEquals((int)ones, (int)6);
        Assert.assertEquals((int)twos, (int)9);
        Intersection inter = new Intersection((SummarySetOperations)this.dsso2);
        CompactSketch icsk = inter.intersect((Sketch)tupleSk, (org.apache.datasketches.theta.Sketch)thetaSk, (Summary)this.ufactory.newSummary().update(Double.valueOf(1.0)));
        entries = icsk.getRetainedEntries();
        TupleExamples2Test.println("Intersection: " + entries);
        SketchIterator iiter = icsk.iterator();
        counter = 1;
        while (iiter.next()) {
            int i = (int)((DoubleSummary)iiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            Assert.assertEquals((int)i, (int)1);
        }
    }

    @Test
    public void example4() {
        UpdatableSketch tupleSk = this.tupleBldr.build();
        UpdateSketch thetaSk = this.thetaBldr.build();
        for (int i = 1; i <= 12; ++i) {
            tupleSk.update((long)i, (Object)1.0);
            thetaSk.update((long)(i + 3));
        }
        Union union = new Union((SummarySetOperations)this.dsso0);
        union.union((Sketch)tupleSk);
        union.union((org.apache.datasketches.theta.Sketch)thetaSk, (Summary)this.ufactory.newSummary().update(Double.valueOf(1.0)));
        CompactSketch ucsk = union.getResult();
        int entries = ucsk.getRetainedEntries();
        TupleExamples2Test.println("Union Stateful: tuple, theta: " + entries);
        SketchIterator uiter = ucsk.iterator();
        int counter = 1;
        int twos = 0;
        int ones = 0;
        while (uiter.next()) {
            int i = (int)((DoubleSummary)uiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            if (i == 1) {
                ++ones;
            }
            if (i != 2) continue;
            ++twos;
        }
        Assert.assertEquals((int)ones, (int)6);
        Assert.assertEquals((int)twos, (int)9);
        Intersection inter = new Intersection((SummarySetOperations)this.dsso0);
        inter.intersect((Sketch)tupleSk);
        inter.intersect((org.apache.datasketches.theta.Sketch)thetaSk, (Summary)this.ifactory.newSummary().update(Double.valueOf(1.0)));
        CompactSketch icsk = inter.getResult();
        entries = icsk.getRetainedEntries();
        TupleExamples2Test.println("Intersection Stateful: tuple, theta: " + entries);
        SketchIterator iiter = icsk.iterator();
        counter = 1;
        while (iiter.next()) {
            int i = (int)((DoubleSummary)iiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            Assert.assertEquals((int)i, (int)2);
        }
    }

    @Test
    public void example5() {
        UpdatableSketch tupleSk = this.tupleBldr.build();
        UpdateSketch thetaSk = this.thetaBldr.build();
        for (int i = 1; i <= 12; ++i) {
            tupleSk.update((long)i, (Object)1.0);
            thetaSk.update((long)(i + 3));
        }
        Union union = new Union((SummarySetOperations)this.dsso1);
        union.union((Sketch)tupleSk);
        union.union((org.apache.datasketches.theta.Sketch)thetaSk, (Summary)this.ufactory.newSummary().update(Double.valueOf(1.0)));
        CompactSketch ucsk = union.getResult();
        int entries = ucsk.getRetainedEntries();
        TupleExamples2Test.println("Union Stateful: tuple, theta: " + entries);
        SketchIterator uiter = ucsk.iterator();
        int counter = 1;
        int twos = 0;
        int ones = 0;
        while (uiter.next()) {
            int i = (int)((DoubleSummary)uiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            if (i == 1) {
                ++ones;
            }
            if (i != 2) continue;
            ++twos;
        }
        Assert.assertEquals((int)ones, (int)6);
        Assert.assertEquals((int)twos, (int)9);
        Intersection inter = new Intersection((SummarySetOperations)this.dsso1);
        inter.intersect((Sketch)tupleSk);
        inter.intersect((org.apache.datasketches.theta.Sketch)thetaSk, (Summary)this.ifactory.newSummary().update(Double.valueOf(1.0)));
        CompactSketch icsk = inter.getResult();
        entries = icsk.getRetainedEntries();
        TupleExamples2Test.println("Intersection Stateful: tuple, theta: " + entries);
        SketchIterator iiter = icsk.iterator();
        counter = 1;
        while (iiter.next()) {
            int i = (int)((DoubleSummary)iiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            Assert.assertEquals((int)i, (int)2);
        }
    }

    @Test
    public void printlnTest() {
        TupleExamples2Test.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

