/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.IntegerSummaryDeserializer;
import org.apache.datasketches.tuple.IntegerSummaryFactory;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SerialVersion3Test {
    @Test
    public void version2Compatibility() throws Exception {
        byte[] bytes = Util.getResourceBytes((String)"TupleWithTestIntegerSummary4kTrimmedSerVer2.sk");
        Sketch sketch1 = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes), (SummaryDeserializer)new IntegerSummaryDeserializer());
        int lgK = 12;
        int K = 4096;
        UpdatableSketchBuilder builder = new UpdatableSketchBuilder((SummaryFactory)new IntegerSummaryFactory());
        UpdatableSketch updatableSketch = builder.build();
        for (int i = 0; i < 8192; ++i) {
            updatableSketch.update((long)i, (Object)1);
        }
        updatableSketch.trim();
        CompactSketch sketch2 = updatableSketch.compact();
        Assert.assertEquals((int)sketch1.getRetainedEntries(), (int)sketch2.getRetainedEntries());
        Assert.assertEquals((long)sketch1.getThetaLong(), (long)sketch2.getThetaLong());
        Assert.assertEquals((boolean)sketch1.isEmpty(), (boolean)sketch2.isEmpty());
        Assert.assertEquals((boolean)sketch1.isEstimationMode(), (boolean)sketch2.isEstimationMode());
    }

    @Test
    public void emptyFromCpp() {
        byte[] bytes = Util.getResourceBytes((String)"tuple-int-empty-cpp.sk");
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes), (SummaryDeserializer)new IntegerSummaryDeserializer());
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)0);
        Assert.assertEquals((long)sketch.getThetaLong(), (long)Long.MAX_VALUE);
    }

    @Test
    public void singleItemFromCpp() {
        byte[] bytes = Util.getResourceBytes((String)"tuple-int-single-cpp.sk");
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes), (SummaryDeserializer)new IntegerSummaryDeserializer());
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        Assert.assertEquals((long)sketch.getThetaLong(), (long)Long.MAX_VALUE);
    }

    @Test
    public void exactModeFromCpp() {
        byte[] bytes = Util.getResourceBytes((String)"tuple-int-two-cpp.sk");
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes), (SummaryDeserializer)new IntegerSummaryDeserializer());
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)2);
        Assert.assertEquals((long)sketch.getThetaLong(), (long)Long.MAX_VALUE);
    }

    @Test
    public void estimationModeFromCpp() {
        byte[] bytes = Util.getResourceBytes((String)"tuple-int-est-trim-cpp.sk");
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes), (SummaryDeserializer)new IntegerSummaryDeserializer());
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertTrue((boolean)sketch.isEstimationMode());
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)4096);
        Assert.assertTrue((sketch.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0);
    }
}

