/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.AnotB;
import org.apache.datasketches.theta.AnotBimpl;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AnotBimplTest {
    @Test
    public void checkExactAnotB_AvalidNoOverlap() {
        int i;
        int k = 512;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(512).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 256; ++i) {
            usk1.update((long)i);
        }
        for (i = 256; i < 512; ++i) {
            usk2.update((long)i);
        }
        AnotB aNb = SetOperation.builder().buildANotB();
        Assert.assertTrue((boolean)aNb.isEmpty());
        Assert.assertTrue((aNb.getCache().length == 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)aNb.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((short)aNb.getSeedHash(), (short)Util.computeSeedHash((long)9001L));
        aNb.setA((Sketch)usk1);
        aNb.notB((Sketch)usk2);
        Assert.assertEquals((int)aNb.getRetainedEntries(), (int)256);
        CompactSketch rsk1 = aNb.getResult(false, null, true);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)256.0);
        aNb.setA((Sketch)usk1);
        aNb.notB((Sketch)usk2);
        rsk1 = aNb.getResult(true, null, true);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)256.0);
        int bytes = rsk1.getCurrentBytes();
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        aNb.setA((Sketch)usk1);
        aNb.notB((Sketch)usk2);
        rsk1 = aNb.getResult(false, wmem, true);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)256.0);
        aNb.setA((Sketch)usk1);
        aNb.notB((Sketch)usk2);
        rsk1 = aNb.getResult(true, wmem, true);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)256.0);
    }

    @Test
    public void checkCombinations() {
        int k = 512;
        Sketch aNull = null;
        Sketch bNull = null;
        UpdateSketch aEmpty = UpdateSketch.builder().setNominalEntries(512).build();
        UpdateSketch bEmpty = UpdateSketch.builder().setNominalEntries(512).build();
        UpdateSketch aHT = UpdateSketch.builder().setNominalEntries(512).build();
        for (int i = 0; i < 512; ++i) {
            aHT.update((long)i);
        }
        CompactSketch aC = aHT.compact(false, null);
        CompactSketch aO = aHT.compact(true, null);
        UpdateSketch bHT = UpdateSketch.builder().setNominalEntries(512).build();
        for (int i = 256; i < 768; ++i) {
            bHT.update((long)i);
        }
        CompactSketch bC = bHT.compact(false, null);
        CompactSketch bO = bHT.compact(true, null);
        boolean ordered = true;
        AnotB aNb = SetOperation.builder().buildANotB();
        try {
            aNb.setA(aNull);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        aNb.notB(bNull);
        try {
            aNb.aNotB(aNull, bNull);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            aNb.aNotB(aNull, (Sketch)bEmpty);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            aNb.aNotB((Sketch)aEmpty, bNull);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        CompactSketch result = aNb.aNotB((Sketch)aEmpty, (Sketch)bEmpty, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((Sketch)aEmpty, (Sketch)bC, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((Sketch)aEmpty, (Sketch)bO, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((Sketch)aEmpty, (Sketch)bHT, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((Sketch)aC, (Sketch)bEmpty, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)512.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((Sketch)aC, (Sketch)bC, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((Sketch)aC, (Sketch)bO, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((Sketch)aC, (Sketch)bHT, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((Sketch)aO, (Sketch)bEmpty, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)512.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((Sketch)aO, (Sketch)bC, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((Sketch)aO, (Sketch)bO, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((Sketch)aO, (Sketch)bHT, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((Sketch)aHT, (Sketch)bEmpty, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)512.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((Sketch)aHT, (Sketch)bC, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((Sketch)aHT, (Sketch)bO, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((Sketch)aHT, (Sketch)bHT, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
    }

    @Test
    public void checkAnotBnotC() {
        int k = 1024;
        boolean ordered = true;
        UpdateSketch aU = UpdateSketch.builder().setNominalEntries(1024).build();
        for (int i = 0; i < 1024; ++i) {
            aU.update((long)i);
        }
        UpdateSketch bU = UpdateSketch.builder().setNominalEntries(1024).build();
        for (int i = 0; i < 512; ++i) {
            bU.update((long)i);
        }
        UpdateSketch cU = UpdateSketch.builder().setNominalEntries(1024).build();
        for (int i = 512; i < 768; ++i) {
            cU.update((long)i);
        }
        int memBytes = Sketch.getMaxUpdateSketchBytes((int)1024);
        WritableMemory wmem1 = WritableMemory.allocate((int)memBytes);
        WritableMemory wmem2 = WritableMemory.allocate((int)memBytes);
        WritableMemory wmem3 = WritableMemory.allocate((int)memBytes);
        AnotB aNb = SetOperation.builder().buildANotB();
        aNb.setA((Sketch)aU);
        CompactSketch result1 = aNb.aNotB((Sketch)aU, (Sketch)bU, true, wmem1);
        aNb.notB((Sketch)bU);
        CompactSketch result2 = aNb.aNotB((Sketch)result1, (Sketch)cU, true, wmem2);
        aNb.notB((Sketch)cU);
        double est2 = result2.getEstimate();
        AnotBimplTest.println("est: " + est2);
        Assert.assertEquals((double)est2, (double)256.0, (double)0.0);
        CompactSketch result3 = aNb.getResult(true, wmem3, true);
        double est3 = result3.getEstimate();
        Assert.assertEquals((double)est3, (double)256.0, (double)0.0);
    }

    @Test
    public void checkAnotBnotC_sameMemory() {
        int k = 1024;
        boolean ordered = true;
        UpdateSketch a = UpdateSketch.builder().setNominalEntries(1024).build();
        for (int i = 0; i < 1024; ++i) {
            a.update((long)i);
        }
        UpdateSketch b = UpdateSketch.builder().setNominalEntries(1024).build();
        for (int i = 0; i < 512; ++i) {
            b.update((long)i);
        }
        UpdateSketch c = UpdateSketch.builder().setNominalEntries(1024).build();
        for (int i = 512; i < 768; ++i) {
            c.update((long)i);
        }
        int memBytes = Sketch.getMaxCompactSketchBytes((int)a.getRetainedEntries(true));
        WritableMemory mem = WritableMemory.allocate((int)memBytes);
        AnotB aNb = SetOperation.builder().buildANotB();
        aNb.setA((Sketch)a);
        CompactSketch result1 = aNb.aNotB((Sketch)a, (Sketch)b, true, mem);
        aNb.notB((Sketch)b);
        result1 = aNb.aNotB((Sketch)result1, (Sketch)c, true, mem);
        aNb.notB((Sketch)c);
        CompactSketch result2 = aNb.getResult(true, mem, true);
        double est1 = result1.getEstimate();
        AnotBimplTest.println("est: " + est1);
        Assert.assertEquals((double)est1, (double)256.0, (double)0.0);
        double est2 = result2.getEstimate();
        Assert.assertEquals((double)est2, (double)256.0, (double)0.0);
    }

    @Test
    public void checkAnotBsimple() {
        UpdateSketch skA = Sketches.updateSketchBuilder().build();
        UpdateSketch skB = Sketches.updateSketchBuilder().build();
        AnotB aNotB = Sketches.setOperationBuilder().buildANotB();
        CompactSketch csk = aNotB.aNotB((Sketch)skA, (Sketch)skB);
        Assert.assertEquals((int)csk.getCurrentBytes(), (int)8);
    }

    @Test
    public void checkGetResult() {
        UpdateSketch skA = Sketches.updateSketchBuilder().build();
        UpdateSketch skB = Sketches.updateSketchBuilder().build();
        AnotB aNotB = Sketches.setOperationBuilder().buildANotB();
        CompactSketch csk = aNotB.aNotB((Sketch)skA, (Sketch)skB);
        Assert.assertEquals((int)csk.getCurrentBytes(), (int)8);
    }

    @Test
    public void checkGetFamily() {
        AnotBimpl anotb = new AnotBimpl(9001L);
        Assert.assertEquals((Object)anotb.getFamily(), (Object)Family.A_NOT_B);
    }

    @Test
    public void checkGetMaxBytes() {
        int bytes = Sketches.getMaxAnotBResultBytes((int)10);
        Assert.assertEquals((int)bytes, (int)264);
    }

    @Test
    public void printlnTest() {
        AnotBimplTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

