/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.datasketches.sampling.VarOptItemsSamples;
import org.apache.datasketches.sampling.VarOptItemsSketch;
import org.apache.datasketches.sampling.VarOptItemsSketchTest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VarOptItemsSamplesTest {
    @Test
    public void compareIteratorToArrays() {
        int k = 64;
        int n = 1024;
        VarOptItemsSketch<Long> sketch = VarOptItemsSketchTest.getUnweightedLongsVIS(64, 1024);
        sketch.update((Object)10240L, 10240.0);
        sketch.update((Object)11264L, 11264.0);
        sketch.update((Object)12288L, 12288.0);
        VarOptItemsSamples samples = sketch.getSketchSamples();
        Long[] items = (Long[])samples.items();
        double[] weights = samples.weights();
        int i = 0;
        for (VarOptItemsSamples.WeightedSample ws : samples) {
            Assert.assertEquals((double)ws.getWeight(), (double)weights[i]);
            Assert.assertEquals((Object)ws.getItem(), (Object)items[i]);
            ++i;
        }
    }

    @Test(expectedExceptions={ConcurrentModificationException.class})
    public void checkConcurrentModification() {
        int k = 128;
        VarOptItemsSketch<Long> sketch = VarOptItemsSketchTest.getUnweightedLongsVIS(128, 128);
        VarOptItemsSamples samples = sketch.getSketchSamples();
        for (VarOptItemsSamples.WeightedSample ws : samples) {
            if ((Long)ws.getItem() <= 64L) continue;
            sketch.update((Object)-1L, 1.0);
        }
        Assert.fail();
    }

    @Test(expectedExceptions={ConcurrentModificationException.class})
    public void checkWeightCorrectingConcurrentModification() {
        int k = 128;
        VarOptItemsSketch<Long> sketch = VarOptItemsSketchTest.getUnweightedLongsVIS(128, 256);
        Iterator iter = sketch.getSketchSamples().getWeightCorrRIter();
        int i = 0;
        while (iter.hasNext()) {
            iter.next();
            if (++i <= 64) continue;
            sketch.update((Object)-1L, 1.0);
        }
        Assert.fail();
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void checkReadingPastEndOfIterator() {
        int k = 128;
        VarOptItemsSketch<Long> sketch = VarOptItemsSketchTest.getUnweightedLongsVIS(128, 128);
        Iterator iter = sketch.getSketchSamples().iterator();
        while (iter.hasNext()) {
            iter.next();
        }
        iter.next();
        Assert.fail();
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void checkWeightCorrectionReadingPastEndOfIterator() {
        int k = 128;
        VarOptItemsSketch<Long> sketch = VarOptItemsSketchTest.getUnweightedLongsVIS(128, 128);
        Iterator iter = sketch.getSketchSamples().getWeightCorrRIter();
        while (iter.hasNext()) {
            iter.next();
        }
        iter.next();
        Assert.fail();
    }

    @Test
    public void checkPolymorphicBaseClass() {
        VarOptItemsSamples samples2;
        VarOptItemsSketch sketch = VarOptItemsSketch.newInstance((int)12);
        sketch.update((Object)1, 0.5);
        sketch.update((Object)2L, 1.7);
        sketch.update((Object)Float.valueOf(3.0f), 2.0);
        sketch.update((Object)4.0, 3.1);
        try {
            samples2 = sketch.getSketchSamples();
            samples2.items();
            Assert.fail();
        }
        catch (ArrayStoreException samples2) {
            // empty catch block
        }
        samples2 = sketch.getSketchSamples();
        samples2.setClass(Number.class);
        Assert.assertEquals((Object)samples2.items(0), (Object)1);
        Assert.assertEquals((Object)samples2.items(1), (Object)2L);
        Assert.assertEquals((Object)samples2.items(2), (Object)Float.valueOf(3.0f));
        Assert.assertEquals((Object)samples2.items(3), (Object)4.0);
    }

    @Test
    public void checkEmptySketch() {
        VarOptItemsSketch sketch = VarOptItemsSketch.newInstance((int)32);
        Assert.assertEquals((int)sketch.getNumSamples(), (int)0);
        VarOptItemsSamples samples = sketch.getSketchSamples();
        Assert.assertEquals((int)samples.getNumSamples(), (int)0);
        Assert.assertNull((Object)samples.items());
        Assert.assertNull((Object)samples.items(0));
        Assert.assertNull((Object)samples.weights());
        Assert.assertTrue((boolean)Double.isNaN(samples.weights(0)));
    }

    @Test
    public void checkUnderFullSketchIterator() {
        int k = 128;
        VarOptItemsSketch<Long> sketch = VarOptItemsSketchTest.getUnweightedLongsVIS(128, 64);
        VarOptItemsSamples samples = sketch.getSketchSamples();
        for (VarOptItemsSamples.WeightedSample ws : samples) {
            Assert.assertTrue(((Long)ws.getItem() >= 0L && (Long)ws.getItem() < 64L ? 1 : 0) != 0);
        }
    }
}

