/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.req;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.req.FloatBuffer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FloatBufferTest {
    @Test
    public void checkTrimCount() {
        FloatBufferTest.checkTrimCountImpl(true);
        FloatBufferTest.checkTrimCountImpl(false);
    }

    private static void checkTrimCountImpl(boolean spaceAtBottom) {
        FloatBuffer buf = new FloatBuffer(16, 4, spaceAtBottom);
        for (int i = 0; i < 8; ++i) {
            buf.append((float)(i + 1));
        }
        Assert.assertEquals((int)buf.getCount(), (int)8);
        buf.trimCount(4);
        Assert.assertEquals((int)buf.getCount(), (int)4);
    }

    @Test
    public void checkGetEvensOrOdds() {
        FloatBufferTest.checkGetEvensOrOddsImpl(false, false);
        FloatBufferTest.checkGetEvensOrOddsImpl(false, true);
        FloatBufferTest.checkGetEvensOrOddsImpl(true, false);
        FloatBufferTest.checkGetEvensOrOddsImpl(true, true);
    }

    private static void checkGetEvensOrOddsImpl(boolean odds, boolean spaceAtBottom) {
        int cap = 16;
        FloatBuffer buf = new FloatBuffer(16, 0, spaceAtBottom);
        for (int i = 0; i < 8; ++i) {
            buf.append((float)i);
        }
        FloatBuffer out = buf.getEvensOrOdds(0, 8, odds);
        for (int i = 0; i < out.getCount(); ++i) {
            int v = (int)out.getItem(i);
            if (odds) {
                Assert.assertTrue(((v & 1) == 1 ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue(((v & 1) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkAppendAndSpaceTop() {
        FloatBufferTest.checkAppendAndSpaceImpl(true);
        FloatBufferTest.checkAppendAndSpaceImpl(false);
    }

    private static void checkAppendAndSpaceImpl(boolean spaceAtBottom) {
        FloatBuffer buf = new FloatBuffer(2, 2, spaceAtBottom);
        Assert.assertEquals((int)buf.getCount(), (int)0);
        Assert.assertEquals((int)buf.getCapacity(), (int)2);
        Assert.assertEquals((int)buf.getSpace(), (int)2);
        buf.append(1.0f);
        Assert.assertEquals((int)buf.getCount(), (int)1);
        Assert.assertEquals((int)buf.getCapacity(), (int)2);
        Assert.assertEquals((int)buf.getSpace(), (int)1);
        buf.append(2.0f);
        Assert.assertEquals((int)buf.getCount(), (int)2);
        Assert.assertEquals((int)buf.getCapacity(), (int)2);
        Assert.assertEquals((int)buf.getSpace(), (int)0);
        buf.append(3.0f);
        Assert.assertEquals((int)buf.getCount(), (int)3);
        Assert.assertEquals((int)buf.getCapacity(), (int)5);
        Assert.assertEquals((int)buf.getSpace(), (int)2);
    }

    @Test
    public void checkEnsureCapacity() {
        FloatBufferTest.checkEnsureCapacityImpl(true);
        FloatBufferTest.checkEnsureCapacityImpl(false);
    }

    private static void checkEnsureCapacityImpl(boolean spaceAtBottom) {
        FloatBuffer buf = new FloatBuffer(4, 2, spaceAtBottom);
        buf.append(2.0f);
        buf.append(1.0f);
        buf.append(3.0f);
        buf.ensureCapacity(8);
        buf.sort();
        Assert.assertEquals((float)buf.getItem(0), (float)1.0f);
        Assert.assertEquals((float)buf.getItem(1), (float)2.0f);
        Assert.assertEquals((float)buf.getItem(2), (float)3.0f);
    }

    @Test
    public void checkCountLessThan() {
        FloatBufferTest.checkCountLessThanImpl(true);
        FloatBufferTest.checkCountLessThanImpl(false);
    }

    private static void checkCountLessThanImpl(boolean spaceAtBottom) {
        float[] sortedArr = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f};
        FloatBuffer buf = FloatBuffer.wrap((float[])sortedArr, (boolean)true, (boolean)spaceAtBottom);
        FloatBuffer buf2 = new FloatBuffer(7, 0, spaceAtBottom);
        buf2.mergeSortIn(buf);
        Assert.assertEquals((int)buf2.getCountWithCriterion(4.0f, false), (int)3);
        buf2.mergeSortIn(buf);
        Assert.assertEquals((int)buf2.getCountWithCriterion(4.0f, false), (int)6);
        Assert.assertEquals((int)buf2.getCount(), (int)14);
        buf2.trimCount(12);
        Assert.assertEquals((int)buf2.getCount(), (int)12);
    }

    @Test
    public void checkCountWcriteria() {
        boolean delta = false;
        int cap = 16;
        boolean spaceAtBottom = true;
        for (int len = 5; len < 10; ++len) {
            FloatBufferTest.iterateValues(FloatBufferTest.createSortedFloatBuffer(16, 0, true, len), len);
            FloatBufferTest.iterateValues(FloatBufferTest.createSortedFloatBuffer(16, 0, false, len), len);
        }
    }

    private static void iterateValues(FloatBuffer buf, int len) {
        for (float v = 0.5f; v <= (float)len + 0.5f; v += 0.5f) {
            FloatBufferTest.checkCountWithCriteria(buf, v);
        }
    }

    public void checkCount() {
        FloatBuffer buf = FloatBufferTest.createSortedFloatBuffer(120, 0, true, 100);
        FloatBufferTest.println("LT: " + buf.getCountWithCriterion(100.0f, false));
        FloatBufferTest.println("LE: " + buf.getCountWithCriterion(100.0f, true));
    }

    private static void checkCountWithCriteria(FloatBuffer buf, float v) {
        int len = buf.getCount();
        int iv = (int)v;
        int count = buf.getCountWithCriterion(v, false);
        Assert.assertEquals((int)count, (int)(v > (float)len ? len : (v <= 1.0f ? 0 : ((float)iv == v ? iv - 1 : iv))));
        count = buf.getCountWithCriterion(v, true);
        Assert.assertEquals((int)count, (int)(v >= (float)len ? len : (v < 1.0f ? 0 : iv)));
    }

    private static FloatBuffer createSortedFloatBuffer(int cap, int delta, boolean sab, int len) {
        FloatBuffer buf = new FloatBuffer(cap, delta, sab);
        for (int i = 0; i < len; ++i) {
            buf.append((float)(i + 1));
        }
        return buf;
    }

    @Test
    public void checkMergeSortIn() {
        FloatBufferTest.checkMergeSortInImpl(true);
        FloatBufferTest.checkMergeSortInImpl(false);
    }

    private static void checkMergeSortInImpl(boolean spaceAtBottom) {
        int i;
        float[] arr1 = new float[]{1.0f, 2.0f, 5.0f, 6.0f};
        float[] arr2 = new float[]{3.0f, 4.0f, 7.0f, 8.0f};
        FloatBuffer buf1 = new FloatBuffer(12, 0, spaceAtBottom);
        FloatBuffer buf2 = new FloatBuffer(12, 0, spaceAtBottom);
        for (i = 0; i < arr1.length; ++i) {
            buf1.append(arr1[i]);
        }
        for (i = 0; i < arr2.length; ++i) {
            buf2.append(arr2[i]);
        }
        Assert.assertEquals((int)buf1.getSpace(), (int)8);
        Assert.assertEquals((int)buf2.getSpace(), (int)8);
        Assert.assertEquals((int)buf1.getCount(), (int)4);
        Assert.assertEquals((int)buf2.getCount(), (int)4);
        buf1.sort();
        buf2.sort();
        buf1.mergeSortIn(buf2);
        Assert.assertEquals((int)buf1.getSpace(), (int)4);
        int len = buf1.getCount();
        Assert.assertEquals((int)len, (int)8);
        for (int i2 = 0; i2 < len; ++i2) {
            int item = (int)buf1.getItem(i2);
            Assert.assertEquals((int)item, (int)(i2 + 1));
        }
    }

    @Test
    private static void checkMergeSortInNotSorted() {
        float[] arr1 = new float[]{6.0f, 5.0f, 2.0f, 1.0f};
        float[] arr2 = new float[]{8.0f, 7.0f, 4.0f, 3.0f};
        FloatBuffer buf1 = new FloatBuffer(4, 0, false);
        FloatBuffer buf2 = new FloatBuffer(4, 0, false);
        for (int i = 0; i < 4; ++i) {
            buf1.append(arr1[i]);
            buf2.append(arr2[i]);
        }
        try {
            buf1.mergeSortIn(buf2);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkGetCountLtOrEqOddRange() {
        FloatBuffer buf = new FloatBuffer(8, 0, false);
        Assert.assertTrue((boolean)buf.isEmpty());
        buf.append(3.0f);
        buf.append(2.0f);
        buf.append(1.0f);
        buf.trimCount(4);
        Assert.assertEquals((int)buf.getCount(), (int)3);
        int cnt = buf.getCountWithCriterion(3.0f, true);
        Assert.assertEquals((int)cnt, (int)3);
        Assert.assertEquals((float)buf.getItemFromIndex(2), (float)3.0f);
        try {
            buf.getEvensOrOdds(0, 3, false);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkTrimCapacityToCount() {
        FloatBuffer buf = new FloatBuffer(100, 100, true);
        for (int i = 0; i <= 100; ++i) {
            buf.append((float)i);
        }
        Assert.assertEquals((int)buf.getCapacity(), (int)201);
        Assert.assertEquals((int)buf.getCount(), (int)101);
        buf.trimCapacity();
        Assert.assertEquals((float)buf.getItemFromIndex(0), (float)100.0f);
        Assert.assertEquals((int)buf.getCapacity(), (int)101);
        Assert.assertEquals((int)buf.getCount(), (int)101);
    }

    @Test
    public void checkSerDe() {
        FloatBufferTest.checkSerDeImpl(true);
        FloatBufferTest.checkSerDeImpl(false);
    }

    private static void checkSerDeImpl(boolean hra) {
        FloatBuffer buf = new FloatBuffer(100, 100, hra);
        for (int i = 0; i <= 100; ++i) {
            buf.append((float)i);
        }
        int capacity = buf.getCapacity();
        int count = buf.getCount();
        int delta = buf.getDelta();
        boolean sorted = buf.isSorted();
        boolean sab = buf.isSpaceAtBottom();
        Assert.assertEquals((float)buf.getItemFromIndex(100), (float)100.0f);
        Assert.assertEquals((float)buf.getItemFromIndex(hra ? 199 : 1), (float)1.0f);
        Assert.assertEquals((boolean)buf.isSpaceAtBottom(), (boolean)hra);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])buf.floatsToBytes());
        float[] farr2 = new float[101];
        wmem.getFloatArray(0L, farr2, 0, 101);
        FloatBuffer buf2 = FloatBuffer.reconstruct((float[])farr2, (int)count, (int)capacity, (int)delta, (boolean)sorted, (boolean)sab);
        Assert.assertEquals((int)buf2.getCapacity(), (int)capacity);
        Assert.assertEquals((int)buf2.getCount(), (int)count);
        Assert.assertEquals((int)buf2.getDelta(), (int)delta);
        Assert.assertEquals((boolean)buf2.isSorted(), (boolean)sorted);
        Assert.assertEquals((float)buf2.getItemFromIndex(100), (float)100.0f);
        Assert.assertEquals((float)buf2.getItemFromIndex(hra ? 199 : 1), (float)1.0f);
        Assert.assertEquals((boolean)buf2.isSpaceAtBottom(), (boolean)sab);
    }

    static void print(Object o) {
        System.out.print(o.toString());
    }

    static void println(Object o) {
        System.out.println(o.toString());
    }
}

